/*************************************************************************
 *
 *  $RCSfile: tagtype.c,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:29:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include "precomp.h"
#include "tagtype.h"

#include <string.h>
#include "new_del.h"

void
TagType_CTOR( TagType_THIS,
			  char *	i_pElementName )
{
	Cstring_CTOR( MREF(sElementName), i_pElementName );
}

void
TagType_DTOR( TagType_THIS )
{
	Cstring_DTOR( MREF(sElementName) );
}

void
TT_GetBeginTag( TagType_THIS,
				Cstring * o_sResult )
{
	intt nLen = 3 + Cs_Length(MREF(sElementName));
	char * buff = New(nLen);
	buff[0] = '<';
	buff[nLen-2] = '>';
	buff[nLen-1] = '\0';
	strncpy(buff+1, Cs_Str(MREF(sElementName)),nLen-3);
	Cs_Assign(o_sResult, buff);
	Delete(buff);
}

void
TT_GetEndTag( TagType_THIS,
			  Cstring *	o_sResult )
{
	intt nLen = 4 + Cs_Length(MREF(sElementName));
	char * buff = New(nLen);
	buff[0] = '<';
	buff[0] = '/';
	buff[nLen-2] = '>';
	buff[nLen-1] = '\0';
	strncpy(buff+1, Cs_Str(MREF(sElementName)),nLen-3);
	Cs_Assign(o_sResult, buff);
	Delete(buff);
}



/*
	intt nLen = 4 + strlen(TT_ElementName(MREF(aType)));
	char * buff = New(nLen);
	buff[0] = '<';
	buff[1] = '/';
	buff[nLen-2] = '>';
	buff[nLen-1] = '\0';
	strnc

*/

char *
TT_ElementName( TagType_THIS )
{
	return Cs_Str( MREF(sElementName) );
}





