<!--

   The Contents of this file are made available subject to the terms of
   either of the following licenses

          - GNU Lesser General Public License Version 2.1
          - Sun Industry Standards Source License Version 1.1

   Sun Microsystems Inc., October, 2000

   GNU Lesser General Public License Version 2.1
   =============================================
   Copyright 2000 by Sun Microsystems, Inc.
   901 San Antonio Road, Palo Alto, CA 94303, USA

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License version 2.1, as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
   MA  02111-1307  USA


   Sun Industry Standards Source License Version 1.1
   =================================================
   The contents of this file are subject to the Sun Industry Standards
   Source License Version 1.1 (the "License"); You may not use this file
   except in compliance with the License. You may obtain a copy of the
   License at http://www.openoffice.org/license.html.

   Software provided under this License is provided on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
   See the License for the specific provisions governing your rights and
   obligations concerning the Software.

   The Initial Developer of the Original Code is: Sun Microsystems, Inc.

   Copyright: 2000 by Sun Microsystems, Inc.

   All Rights Reserved.

   Contributor(s): _______________________________________

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xt="http://www.jclark.com/xt"
                xmlns:office="http://openoffice.org/2000/office"
                xmlns:style="http://openoffice.org/2000/style"
                xmlns:text="http://openoffice.org/2000/text"
                xmlns:table="http://openoffice.org/2000/table"
                xmlns:draw="http://openoffice.org/2000/drawing"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:xlink="http://www.w3.org/1999/xlink"
                xmlns:number="http://openoffice.org/2000/datastyle"
                xmlns:svg="http://www.w3.org/2000/svg"
                xmlns:chart="http://openoffice.org/2000/chart"
                xmlns:dr3d="http://openoffice.org/2000/dr3d"
                xmlns:math="http://www.w3.org/1998/Math/MathML"
                xmlns:form="http://openoffice.org/2000/form"
                xmlns:script="http://openoffice.org/2000/script"
                office:class="text"
                office:version="1.0"
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                xmlns:meta="http://openoffice.org/2000/meta"
                xmlns:config="http://openoffice.org/2001/config"
                xmlns:help="http://openoffice.org/2000/help">




    <!-- ************ -->
    <!-- *** body *** -->
    <!-- ************ -->


    <xsl:template match="/office:document-content/office:body">


    <!-- DEBUG-START: only DEBUG purpose: shows the inlined style attributes of the temporary variable -->
    <xsl:if test="$DEBUG and not($outputType = 'CSS_HEADER')">
        <xsl:element name="debug_tree_of_styles"><xsl:text>
            </xsl:text><xsl:for-each select="$cssStyleProperties/allstyles/*">
<xsl:text>                      </xsl:text><xsl:value-of select="name()"/><xsl:text> = </xsl:text><xsl:value-of select="."/><xsl:text>
            </xsl:text>
                    </xsl:for-each>
        </xsl:element>
    </xsl:if>
    <!-- DEBUG-END -->

        <xsl:call-template name="apply-styles-and-content"/>
    </xsl:template>


    <!-- deactivating default template -->
    <xsl:template match="*"/>


    <!-- allowing all matched text nodes -->
    <xsl:template match="text()">
<!-- WML         <xsl:value-of select="normalize-space(.)"/> -->
        <xsl:value-of select="."/>
    </xsl:template>



    <!-- ################### -->
    <!-- ### INLINE-TEXT ### -->
    <!-- ################### -->


    <!-- ****************** -->
    <!-- *** Paragraphs *** -->
    <!-- ****************** -->

    <xsl:template match="text:p | draw:text-box | draw:page">
            <xsl:choose>
                <!--+++++ CSS (CASCADING STLYE SHEET) HEADER STYLE WAY +++++-->
                <xsl:when test="$outputType = 'CSS_HEADER'">
                    <xsl:element name="p">
                        <xsl:call-template name="apply-styles-and-content"/>
                    </xsl:element>
                </xsl:when>

                <!--+++++ HTML 4.0 INLINED WAY  +++++-->
                <xsl:when test="$outputType = 'CSS_INLINED'">
                    <xsl:element name="p">
                        <xsl:call-template name="apply-styles-and-content"/>
                    </xsl:element>
                </xsl:when>
                <!--+++++ PALM 3.2 SUBSET INLINED WAY  +++++-->
                <xsl:when test="$outputType = 'PALM'">
                    <xsl:choose>
                        <!-- in palm paragraphs children of text:list-items are better shown without 'p' tag-->
                        <xsl:when test="name(parent::*) = 'text:list-item'">
                            <xsl:call-template name="apply-styles-and-content"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:element name="p">
                                <xsl:call-template name="apply-styles-and-content"/>
                            </xsl:element>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <!--+++++ WML / WAP  +++++-->
                <xsl:otherwise>
                    <!-- no nested p tags in wml1.1 allowed -->
                    <xsl:choose>
                        <xsl:when test="ancestor::*[contains($wap-paragraph-elements, name())]">
                            <xsl:call-template name="apply-styles-and-content"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:element name="p">
                                <xsl:call-template name="apply-styles-and-content"/>
                             </xsl:element>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
    </xsl:template>




    <!-- **************** -->
    <!-- *** Headings *** -->
    <!-- **************** -->

    <xsl:template match="text:h">

        <xsl:variable name="headertyp" select="concat('h', @text:level)"/>


        <xsl:choose>
            <!--+++++ CSS (CASCADING STLYE SHEET) HEADER STYLE WAY +++++-->
            <xsl:when test="$outputType = 'CSS_HEADER'">
                <xsl:element name="{$headertyp}">
                    <xsl:call-template name="apply-styles-and-content"/>
                </xsl:element>
            </xsl:when>

            <!--+++++ HTML 4.0 INLINED WAY  +++++-->
            <xsl:when test="$outputType = 'CSS_INLINED'">
                <xsl:element name="{$headertyp}">
                    <xsl:call-template name="apply-styles-and-content"/>
                </xsl:element>
            </xsl:when>

            <!--+++++ PALM 3.2 SUBSET INLINED WAY  +++++-->
            <xsl:when test="$outputType = 'PALM'">
                <xsl:element name="{$headertyp}">
                    <!-- All children content have to be nested in the styles (e.g. <i><b>ANY CONTENT</b></i>)
                         for this xsl:apply-templates will be called later / implicit -->
                    <xsl:call-template name="create-attribute-ALIGN">
                        <!-- getting the css styles for the style name (mapped by style-mapping.xsl) -->
                        <xsl:with-param name="styleProperties" select="$cssStyleProperties/allstyles/*[name()=current()/@text:style-name]"/>
                    </xsl:call-template>
                </xsl:element>
            </xsl:when>

            <!--+++++ WML / WAP  +++++-->
            <xsl:otherwise>
                <!-- no nested p tags in wml1.1 allowed -->
                <xsl:choose>
                    <xsl:when test="ancestor::*[contains($wap-paragraph-elements, name())]">
                        <!-- since no header styles exist, an emphasis is used -->
                        <xsl:element name="em">
                            <xsl:call-template name="apply-styles-and-content"/>
                        </xsl:element>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:element name="p">
                            <!-- since no header styles exist, an emphasis is used -->
                            <xsl:element name="em">
                                <xsl:call-template name="apply-styles-and-content"/>
                            </xsl:element>
                        </xsl:element>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>



    <!-- ***************** -->
    <!-- *** Text Span *** -->
    <!-- ***************** -->

    <xsl:template match="text:span">
            <xsl:choose>
                <!--+++++ CSS (CASCADING STLYE SHEET) HEADER STYLE WAY +++++-->
                <xsl:when test="$outputType = 'CSS_HEADER'">
                    <xsl:element name="span">
                        <xsl:call-template name="apply-styles-and-content"/>
                    </xsl:element>
                </xsl:when>

                <!--+++++ HTML 4.0 INLINED WAY  +++++-->
                <xsl:when test="$outputType = 'CSS_INLINED'">
                    <xsl:element name="span">
                        <xsl:call-template name="apply-styles-and-content"/>
                    </xsl:element>
                </xsl:when>
                <!--+++++ PALM 3.2 SUBSET INLINED WAY  +++++-->
                <xsl:when test="$outputType = 'PALM'">
                    <xsl:call-template name="apply-styles-and-content"/>
                </xsl:when>
                <!--+++++ WML / WAP  +++++-->
                <xsl:otherwise>
                    <!-- no nested p tags in wml1.1 allowed -->
                    <xsl:choose>
                        <xsl:when test="ancestor::*[contains($wap-paragraph-elements, name())]">
                            <xsl:call-template name="apply-styles-and-content"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:element name="p">
                                <xsl:call-template name="apply-styles-and-content"/>
                            </xsl:element>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:otherwise>

            </xsl:choose>
    </xsl:template>


    <!-- ************* -->
    <!-- *** Link  *** -->
    <!-- ************* -->

    <xsl:template match="text:a | draw:a | office:a">
        <!-- workaround of an writer buck (empty hrefs) fixed in SRC617 -->
        <xsl:choose>
            <xsl:when test="not(@xlink:href='')">
                <xsl:choose>
                    <xsl:when test="not($outputType = 'WML')">
                        <xsl:element name="a">
                            <xsl:attribute name="href"><xsl:value-of select="@xlink:href"/></xsl:attribute>
                            <!--<xsl:attribute name="class">ContentLink</xsl:attribute>-->
                            <xsl:call-template name="apply-styles-and-content"/>
                        </xsl:element>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- no nested p tags in wml1.1 allowed -->
                        <xsl:choose>
                            <xsl:when test="ancestor::*[contains($wap-paragraph-elements, name())]">
                                <xsl:element name="a">
                                    <xsl:attribute name="href"><xsl:value-of select="@xlink:href"/></xsl:attribute>
                                    <xsl:apply-templates select="descendant::text()"/>
                                </xsl:element>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:element name="p">
                                    <xsl:element name="a">
                                        <xsl:attribute name="href"><xsl:value-of select="@xlink:href"/></xsl:attribute>
                                        <xsl:apply-templates select="descendant::text()"/>
                                    </xsl:element>
                                </xsl:element>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="apply-styles-and-content"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>



    <!-- ******************* -->
    <!-- *** Image Link  *** -->
    <!-- ******************* -->

    <xsl:template match="draw:image | office:image">
        <!-- NO IMAGES SUPPLIED FOR WAP OR PALM -->
        <xsl:if test="$outputType = 'CSS_HEADER' or $outputType = 'CSS_INLINED'">
            <xsl:element name="img">
                <xsl:choose>
                     <!-- for images jared in open office document -->
                    <xsl:when test="contains(@xlink:href, '#Pictures/')">
                        <!-- creating an absolute http URL to the packed image file -->
                        <xsl:attribute name="src"><xsl:value-of select="concat($documentPackageURL, '/Pictures/', substring-after(@xlink:href, '#Pictures/'), $suffixOfURL)"/></xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- 2DO: absolute external links have to be encoded, url encoder - this soltution works only for relative URLs  -->
                        <xsl:attribute name="src"><xsl:value-of select="concat($baseURL, @xlink:href, $suffixOfURL)"/></xsl:attribute>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:element>
        </xsl:if>
    </xsl:template>




    <!-- ******************** -->
    <!-- *** ordered list *** -->
    <!-- ******************** -->

    <xsl:template match="text:ordered-list">
            <xsl:choose>
                <!--+++++ CSS (CASCADING STLYE SHEET) HEADER STYLE WAY +++++-->
                <xsl:when test="$outputType = 'CSS_HEADER'">
                    <xsl:element name="ol"><xsl:call-template name="apply-styles-and-content"/></xsl:element>
                </xsl:when>
                <!--+++++ HTML 4.0 INLINED WAY  +++++-->
                <xsl:when test="$outputType = 'CSS_INLINED'">
                    <xsl:element name="ol">
                        <xsl:call-template name="apply-styles-and-content"/>
                    </xsl:element>
                </xsl:when>
                <!--+++++ PALM 3.2 SUBSET AND WAP INLINED WAY  +++++-->
                <xsl:when test="$outputType = 'PALM'">
                    <xsl:element name="ol">
<!--                    <xsl:call-template name="create-list-attributes">
                            <!~~ the style-output-nodset is already prepared by the included section style_mapping.xsl ~~>
                            <xsl:with-param name="styleProperties" select="$cssStyleProperties/allstyles/*[name()=current()/@text:style-name]"/>
                        </xsl:call-template>-->
                        <xsl:call-template name="apply-styles-and-content"/>
                    </xsl:element>
                </xsl:when>
                <!--+++++ WML / WAP  +++++-->
                <xsl:otherwise>
                    <xsl:choose>
                        <!-- simulating content break of capsulated list elements -->
                        <xsl:when test="ancestor::text:list-item">
                            <xsl:choose>
                                <xsl:when test="ancestor::*[contains($wap-paragraph-elements, name())]">
                                    <!-- simulating content break of capsulated list elements -->
                                    <xsl:element name="br"></xsl:element>
                                    <xsl:call-template name="apply-styles-and-content"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:element name="p">
                                        <!-- simulating content break of capsulated list elements -->
                                        <xsl:element name="br"></xsl:element>
                                        <xsl:call-template name="apply-styles-and-content"/>
                                    </xsl:element>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:call-template name="apply-styles-and-content"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
    </xsl:template>



    <!-- ********************** -->
    <!-- *** unordered list *** -->
    <!-- ********************** -->

    <xsl:template match="text:unordered-list">
        <xsl:choose>
            <!--+++++ CSS (CASCADING STLYE SHEET) HEADER STYLE WAY +++++-->
            <xsl:when test="$outputType = 'CSS_HEADER'">
                <xsl:element name="ul">
                    <xsl:apply-templates select="@text:style-name | @draw:style-name | @draw:text-style-name"/><!-- | @presentation:style-name -->
                    <xsl:call-template name="apply-styles-and-content"/>
                </xsl:element>
            </xsl:when>

            <!--+++++ HTML 4.0 INLINED WAY  +++++-->
            <xsl:when test="$outputType = 'CSS_INLINED'">
                <xsl:element name="ul">
                    <xsl:apply-templates select="@text:style-name | @draw:style-name | @draw:text-style-name"/><!-- | @presentation:style-name -->
                    <xsl:call-template name="apply-styles-and-content"/>
                </xsl:element>
            </xsl:when>

            <!--+++++ PALM 3.2 SUBSET AND WAP INLINED WAY  +++++-->
            <xsl:when test="$outputType = 'PALM'">
                <xsl:element name="ul">
<!--                    <xsl:call-template name="create-list-attributes">
                            <!~~ the style-output-nodset is already prepared by the included section style_mapping.xsl ~~>
                            <xsl:with-param name="styleProperties" select="$cssStyleProperties/allstyles/*[name()=current()/@text:style-name]"/>
                        </xsl:call-template>-->
                    <xsl:call-template name="apply-styles-and-content"/>
                </xsl:element>
            </xsl:when>

            <!--+++++ WML / WAP  +++++-->
            <xsl:otherwise>
                <xsl:choose>
                    <!-- simulating content break of capsulated list elements -->
                    <xsl:when test="ancestor::text:list-item">
                        <xsl:choose>
                            <xsl:when test="ancestor::*[contains($wap-paragraph-elements, name())]">
                                <!-- simulating content break of capsulated list elements -->
                                <xsl:element name="br"></xsl:element>
                                <xsl:call-template name="apply-styles-and-content"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:element name="p">
                                    <!-- simulating content break of capsulated list elements -->
                                    <xsl:element name="br"></xsl:element>
                                    <xsl:call-template name="apply-styles-and-content"/>
                                </xsl:element>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="apply-styles-and-content"/>
                    </xsl:otherwise>
                </xsl:choose>
<!--
                <xsl:choose>
                    <xsl:when test="ancestor::*[contains($wap-paragraph-elements, name())]">
                        <!~~ simulating content break of capsulated list elements ~~>
                        <xsl:if test="ancestor::text:list-item">
                            <!~~ ASCII table row end simulation ~~>
                            <xsl:element name="br"></xsl:element>
                        </xsl:if>
                        <xsl:call-template name="apply-styles-and-content"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:element name="p">
                            <!~~ simulating content break of capsulated list elements ~~>
                            <xsl:if test="ancestor::text:list-item">
                                <!~~ ASCII table row end simulation ~~>
                                <xsl:element name="br"></xsl:element>
                            </xsl:if>
                            <xsl:call-template name="apply-styles-and-content"/>
                        </xsl:element>
                    </xsl:otherwise>
                </xsl:choose>
-->
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>



    <!-- ****************** -->
    <!-- *** list item  *** -->
    <!-- ****************** -->

    <xsl:template match="text:list-item">
        <xsl:choose>
            <!--+++++ CSS (CASCADING STLYE SHEET) HEADER STYLE WAY +++++-->
            <xsl:when test="$outputType = 'CSS_HEADER'">
                <xsl:element name="li">
                    <xsl:call-template name="apply-styles-and-content"/>
                </xsl:element>
            </xsl:when>

            <!--+++++ HTML 4.0 INLINED WAY  +++++-->
            <xsl:when test="$outputType = 'CSS_INLINED'">
                <xsl:element name="li">
                    <xsl:call-template name="apply-styles-and-content"/>
                </xsl:element>
            </xsl:when>

            <!--+++++ PALM 3.2 SUBSET AND WAP INLINED WAY  +++++-->
            <xsl:when test="$outputType = 'PALM'">
                <xsl:element name="li">
<!--                    <xsl:call-template name="create-list-attributes">
                            <!~~ the style-output-nodset is already prepared by the included section style_mapping.xsl ~~>
                            <xsl:with-param name="styleProperties" select="$cssStyleProperties/allstyles/*[name()=current()/@text:style-name]"/>
                        </xsl:call-template>-->
                    <xsl:call-template name="apply-styles-and-content"/>
                </xsl:element>
            </xsl:when>

            <!--+++++ WML / WAP  +++++-->
            <xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="ancestor::*[contains($wap-paragraph-elements, name())]">
                        <!-- simulating list elements -->
                        <xsl:for-each select="ancestor::text:list-item">*</xsl:for-each>
                        <xsl:text>* </xsl:text>
                        <xsl:call-template name="apply-styles-and-content"/>
                        <!-- list item break simulation (not in a table)-->
                        <xsl:if test="not(ancestor::table:table-cell) or following-sibling::text:list-item">
                            <xsl:element name="br"/>
                        </xsl:if>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:element name="p">
                            <!-- simulating list elements -->
                            <xsl:for-each select="ancestor::text:list-item">*</xsl:for-each>
                            <xsl:text>* </xsl:text>
                            <xsl:call-template name="apply-styles-and-content"/>
                            <!-- list item break simulation (not in a table)-->
                            <xsl:if test="not(ancestor::table:table-cell) or following-sibling::text:list-item">
                                <xsl:element name="br"/>
                            </xsl:if>
                        </xsl:element>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>



    <!-- ********************************************** -->
    <!-- *** Text Section (contains: draw:text-box) *** -->
    <!-- ********************************************** -->

    <xsl:template match="text:section">
        <xsl:if test="not(contains(@text:display, 'none'))">
            <xsl:choose>
                <!--+++++ CSS (CASCADING STLYE SHEET) HEADER STYLE WAY +++++-->
                <xsl:when test="$outputType = 'CSS_HEADER'">
                    <xsl:element name="span">
                        <xsl:call-template name="apply-styles-and-content"/>
                    </xsl:element>
                </xsl:when>
                <!--+++++ HTML 4.0 INLINED WAY  +++++-->
                <xsl:when test="$outputType = 'CSS_INLINED'">
                    <xsl:element name="span">
                        <xsl:call-template name="apply-styles-and-content"/>
                    </xsl:element>
                </xsl:when>
                <!--+++++ PALM 3.2 SUBSET INLINED WAY  +++++-->
                <xsl:when test="$outputType = 'PALM'">
                    <xsl:choose>
                        <xsl:when test="name(parent::*) = 'text:list-item'">
                            <xsl:call-template name="apply-styles-and-content"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:element name="p">
                                <xsl:call-template name="apply-styles-and-content"/>
                            </xsl:element>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <!--+++++ WML / WAP  +++++-->
                <xsl:otherwise>
                    <xsl:choose>
                        <xsl:when test="not($outputType = 'WML')">
                            <xsl:element name="a">
                                <xsl:attribute name="href"><xsl:value-of select="@xlink:href"/></xsl:attribute>
                                <xsl:call-template name="apply-styles-and-content"/>
                            </xsl:element>
                        </xsl:when>
                        <xsl:otherwise>
                            <!-- no nested p tags in wml1.1 allowed -->
                            <xsl:choose>
                                <xsl:when test="ancestor::*[contains($wap-paragraph-elements, name())]">
                                    <xsl:call-template name="apply-styles-and-content"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:element name="p">
                                        <xsl:call-template name="apply-styles-and-content"/>
                                    </xsl:element>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>



    <xsl:template match="text:line-break">
        <xsl:element name="br"/>
    </xsl:template>


<!--
    TABHANDLING PROBLEM: Tabs are possible to be shown in the HTML text file, but will be later stripped as whitespaces.
        To prevent this the only way I find was the PRE tag which unfortunately ALWAYS result into a line-break. No surrounding NOBR tags help.

    <xsl:template match="text:tab-stop">
        <xsl:if test="not(preceding-sibling::text:tab-stop)">
            <xsl:element name="pre"><xsl:text>&#9;</xsl:text><xsl:for-each select="following-sibling::text:tab-stop"><xsl:text>&#9;</xsl:text></xsl:for-each></xsl:element>
        </xsl:if>
     </xsl:template>

-->
    <!-- HOTFIX: 8 non-breakable-spaces instead of a TAB is a hack sometimes less Tabs are needed and the code more difficult to read -->
    <xsl:template match="text:tab-stop"><xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;</xsl:text></xsl:template>



    <!-- currently there have to be an explicit call of the style attribute nodes, maybe the attributes nodes have no priority only order relevant-->
    <!-- STRANGE: checked with biorythm.sxc a simple xsl:apply-templates did not recognice the styles. Maybe caused by the template match order?  -->
    <xsl:template name="apply-styles-and-content">
        <xsl:apply-templates select="@text:style-name | @draw:style-name | @draw:text-style-name"/><!-- | @presentation:style-name -->
        <xsl:apply-templates/>
    </xsl:template>



    <xsl:template match="@text:style-name | @draw:style-name | @draw:text-style-name"><!-- | @presentation:style-name -->
        <xsl:choose>
            <!--+++++ CSS (CASCADING STLYE SHEET) HEADER STYLE WAY +++++-->
            <xsl:when test="$outputType = 'CSS_HEADER'">
                <xsl:attribute name="class"><xsl:value-of select="translate(., '. ', '')"/></xsl:attribute>
            </xsl:when>

            <!--+++++ HTML 4.0 INLINED WAY  +++++-->
            <xsl:when test="$outputType = 'CSS_INLINED'">
                <xsl:attribute name="style"><xsl:value-of select="$cssStyleProperties/allstyles/*[name()=current()/.]"/></xsl:attribute>
            </xsl:when>

            <!--+++++ PALM 3.2 SUBSET INLINED WAY  and  WML / WAP   +++++-->
            <xsl:when test="$outputType = 'PALM' or $outputType = 'WML'">
                <!-- getting the css styles for the style name (mapped by style-mapping.xsl) -->
                <xsl:variable name="styleProperties" select="$cssStyleProperties/allstyles/*[name()=current()/.]"/>
                <!-- changing the context node -->
                <xsl:for-each select="parent::*">
                    <xsl:call-template name="create-nested-format-tags">
                        <xsl:with-param name="styleProperties" select="$styleProperties"/>
                    </xsl:call-template>
                </xsl:for-each>
            </xsl:when>
        </xsl:choose>
    </xsl:template>


</xsl:stylesheet>
