/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.InstallerHelper;

import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.Util.ExecuteProcess;
import org.openoffice.setup.Util.LogManager;
import org.openoffice.setup.Util.SystemManager;

public class SolarisHelper {
    private void createLocalTempDir() {
        String mktempString = "/usr/bin/mktemp";
        File mktemp = new File(mktempString);
        if (mktemp.exists()) {
            LogManager.setCommandsHeaderLine("Preparing Solaris 10 user installation");
            InstallData data = InstallData.getInstance();
            String mktempCommand = mktempString + " -d";
            String[] mktempCommandArray = new String[]{mktempString, "-d"};
            Vector returnVector = new Vector();
            Vector returnErrorVector = new Vector();
            int returnValue = ExecuteProcess.executeProcessReturnVector(mktempCommandArray, returnVector, returnErrorVector);
            String uniqueLocalDir = (String)returnVector.get(0);
            data.setLocalTempPath(uniqueLocalDir);
            String log = mktempCommand + "<br><b>Returns: " + uniqueLocalDir + "</b><br>";
            LogManager.addCommandsLogfileComment(log);
            String installRoot = data.getInstallRoot();
            File installRootTemp = new File(installRoot, "tmp");
            if (installRootTemp.exists()) {
                SystemManager.removeDirectory(installRootTemp);
            }
            String linkCommand = "ln -s " + uniqueLocalDir + " " + installRootTemp.getPath();
            String[] linkCommandArray = new String[]{"ln", "-s", uniqueLocalDir, installRootTemp.getPath()};
            returnValue = ExecuteProcess.executeProcessReturnValue(linkCommandArray);
            log = linkCommand + "<br><b>Returns: " + returnValue + "</b><br>";
            LogManager.addCommandsLogfileComment(log);
        }
    }

    private void removeLocalTempDir() {
        InstallData data = InstallData.getInstance();
        if (data.getLocalTempPath() != null) {
            File localTemp;
            File installRootTemp = new File(data.getInstallRoot(), "tmp");
            if (installRootTemp.exists()) {
                installRootTemp.delete();
                SystemManager.createDirectory(installRootTemp);
            }
            if ((localTemp = new File(data.getLocalTempPath())).exists()) {
                SystemManager.removeDirectory(localTemp);
            }
        }
    }

    private Vector getAdminFileContent(boolean relocatable) {
        Vector<String> adminFile = new Vector<String>();
        InstallData data = InstallData.getInstance();
        if (relocatable) {
            String installDir = data.getInstallDir();
            String baseDirLine = "basedir=" + installDir;
            adminFile.add(baseDirLine);
        }
        String conflictLine = "conflict=quit";
        if (data.isUserInstallation()) {
            conflictLine = "conflict=nocheck";
        }
        adminFile.add(conflictLine);
        String runlevelLine = "runlevel=nocheck";
        adminFile.add(runlevelLine);
        String setuidLine = "setuid=quit";
        if (data.isUserInstallation()) {
            setuidLine = "setuid=nocheck";
        }
        adminFile.add(setuidLine);
        String actionLine = "action=nocheck";
        adminFile.add(actionLine);
        String partialLine = "partial=quit";
        if (data.isUserInstallation()) {
            partialLine = "partial=nocheck";
        }
        adminFile.add(partialLine);
        String instanceLine = "instance=unique";
        adminFile.add(instanceLine);
        String idependLine = "idepend=nocheck";
        adminFile.add(idependLine);
        String rdependLine = "rdepend=nocheck";
        if (data.isUserInstallation()) {
            rdependLine = "rdepend=nocheck";
        }
        adminFile.add(rdependLine);
        String spaceLine = "space=quit";
        if (data.isUserInstallation()) {
            spaceLine = "space=nocheck";
        }
        adminFile.add(spaceLine);
        return adminFile;
    }

    private String getMainVersion(String version) {
        String mainVersion = null;
        int pos = version.indexOf(",");
        if (pos > -1) {
            mainVersion = version.substring(0, pos);
        }
        return mainVersion;
    }

    private String getPackageRevision(String version) {
        String revision = null;
        int pos = version.indexOf("=");
        if (pos > -1) {
            revision = version.substring(pos + 1, version.length());
        }
        return revision;
    }

    private Vector getVectorOfNumbers(String version) {
        Vector<String> numbers = new Vector<String>();
        int pos = -1;
        do {
            if ((pos = version.indexOf(".")) <= -1) continue;
            String number = version.substring(0, pos);
            version = version.substring(pos + 1, version.length());
            numbers.add(number);
        } while (pos > -1);
        numbers.add(version);
        return numbers;
    }

    private int getMinimum(int a, int b) {
        int minimum = a < b ? a : b;
        return minimum;
    }

    private String compareVersion(String firstVersion, String secondVersion) {
        String comparison = "bothPackagesAreEqual";
        Vector firstVector = this.getVectorOfNumbers(firstVersion);
        Vector secondVector = this.getVectorOfNumbers(secondVersion);
        int firstLength = firstVector.size();
        int secondLength = secondVector.size();
        int minimum = this.getMinimum(firstLength, secondLength);
        for (int i = 0; i < minimum; ++i) {
            String firstS = (String)firstVector.get(i);
            String secondS = (String)secondVector.get(i);
            int first = Integer.parseInt(firstS);
            int second_ = Integer.parseInt(secondS);
            if (second_ > first) {
                comparison = "firstPackageIsOlder";
                break;
            }
            if (second_ >= first) continue;
            comparison = "secondPackageIsOlder";
            break;
        }
        return comparison;
    }

    public void saveModulesLogFile(InstallData data) {
        if (data.logModuleStates()) {
            Vector logContent = LogManager.getModulesLogFile();
            File baseDir = new File(data.getInstallRoot(), data.getInstallDir());
            File uninstallDir = new File(baseDir, data.getUninstallDirName());
            File modulesLogFile = new File(uninstallDir, "moduleSettingsLog.txt");
            SystemManager.saveCharFileVector(modulesLogFile.getPath(), logContent);
        }
    }

    public void removeSolarisLockFile() {
        String lockFileName = "/tmp/.ai.pkg.zone.lock-afdb66cf-1dd1-11b2-a049-000d560ddc3e";
        File lockFile = new File(lockFileName);
        if (lockFile.exists()) {
            boolean bl = lockFile.delete();
        }
    }

    public String getSolarisDatabasePath(InstallData data) {
        String databasePath = null;
        databasePath = data.getInstallRoot();
        return databasePath;
    }

    public void createAdminFile(boolean relocatable) {
        InstallData data = InstallData.getInstance();
        Vector removeFiles = data.getRemoveFiles();
        String adminFileName = "";
        adminFileName = relocatable ? "adminFileReloc" : "adminFileNoReloc";
        Vector fileContent = this.getAdminFileContent(relocatable);
        File adminDir = new File(data.getInstallRoot(), data.getInstallDir());
        File adminFile = new File(adminDir, adminFileName);
        String completeAdminFileName = adminFile.getPath();
        if (relocatable) {
            data.setAdminFileNameReloc(completeAdminFileName);
        } else {
            data.setAdminFileNameNoReloc(completeAdminFileName);
        }
        if (!adminFile.exists()) {
            SystemManager.saveCharFileVector(completeAdminFileName, fileContent);
            removeFiles.add(completeAdminFileName);
        }
    }

    public void setEnvironmentForUserInstall() {
        InstallData data = InstallData.getInstance();
        HashMap env = SystemManager.getEnvironmentHashMap();
        env.put("LD_PRELOAD_32", data.getGetUidPath());
        data.setShellEnvironment(env);
    }

    public String getVersionString(Vector returnVector) {
        String versionString = null;
        String versionLine = null;
        for (int i = 0; i < returnVector.size(); ++i) {
            String line = (String)returnVector.get(i);
            int pos = line.indexOf("REV=");
            if (pos <= -1) continue;
            versionLine = line;
            break;
        }
        if (versionLine != null) {
            versionLine = versionLine.trim();
            int pos = versionLine.lastIndexOf(" ");
            versionString = versionLine.substring(pos + 1, versionLine.length());
        }
        return versionString;
    }

    public boolean comparePackageVersions(String firstPackageVersion, String secondPackageVersion) {
        boolean firstPackageIsOlder = false;
        String comparison = null;
        String firstPackageMainVersion = this.getMainVersion(firstPackageVersion);
        String secondPackageMainVersion = this.getMainVersion(secondPackageVersion);
        if (firstPackageMainVersion != null && secondPackageMainVersion != null) {
            comparison = this.compareVersion(firstPackageMainVersion, secondPackageMainVersion);
        }
        if (comparison.equals("firstPackageIsOlder")) {
            firstPackageIsOlder = true;
        } else if (comparison.equals("secondPackageIsOlder")) {
            firstPackageIsOlder = false;
        } else if (comparison.equals("bothPackagesAreEqual")) {
            String firstPackageRevision = this.getPackageRevision(firstPackageVersion);
            String secondPackageRevision = this.getPackageRevision(secondPackageVersion);
            if (firstPackageRevision != null && secondPackageRevision != null) {
                comparison = this.compareVersion(firstPackageRevision, secondPackageRevision);
                firstPackageIsOlder = comparison.equals("firstPackageIsOlder");
            }
        }
        return firstPackageIsOlder;
    }
}

