require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_STRING_H)) {
    die("Never use <bits/string3.h> directly; include <string.h> instead.");
}
undef(&memcpy) if defined(&memcpy);
undef(&memmove) if defined(&memmove);
undef(&memset) if defined(&memset);
undef(&strcat) if defined(&strcat);
undef(&strcpy) if defined(&strcpy);
undef(&strncat) if defined(&strncat);
undef(&strncpy) if defined(&strncpy);
if(defined(&__USE_GNU)) {
    undef(&mempcpy) if defined(&mempcpy);
    undef(&stpcpy) if defined(&stpcpy);
}
if(defined(&__USE_BSD)) {
    undef(&bcopy) if defined(&bcopy);
    undef(&bzero) if defined(&bzero);
}
unless(defined(&memcpy)) {
    sub memcpy {
	my($dest, $src, $len) = @_;
	eval q((( &__bos0 ($dest) !=  -1) ?  &__builtin___memcpy_chk ($dest, $src, $len,  &__bos0 ($dest)) :  &__memcpy_ichk ($dest, $src, $len)));
    }
}
unless(defined(&__attribute__)) {
    sub __attribute__ {
	eval q((( &__always_inline__))  &__memcpy_ichk ( &void * &__restrict  &__dest,  &const  &void * &__restrict  &__src, 'size_t'  &__len) {  &__builtin___memcpy_chk ( &__dest,  &__src,  &__len,  &__bos0 ( &__dest)); });
    }
}
unless(defined(&memmove)) {
    sub memmove {
	my($dest, $src, $len) = @_;
	eval q((( &__bos0 ($dest) !=  -1) ?  &__builtin___memmove_chk ($dest, $src, $len,  &__bos0 ($dest)) :  &__memmove_ichk ($dest, $src, $len)));
    }
}
unless(defined(&__attribute__)) {
    sub __attribute__ {
	eval q((( &__always_inline__))  &__memmove_ichk ( &void * &__dest,  &const  &void * &__src, 'size_t'  &__len) {  &__builtin___memmove_chk ( &__dest,  &__src,  &__len,  &__bos0 ( &__dest)); });
    }
}
if(defined(&__USE_GNU)) {
    eval 'sub mempcpy {
        my($dest, $src, $len) = @_;
	    eval q((( &__bos0 ($dest) !=  -1) ?  &__builtin___mempcpy_chk ($dest, $src, $len,  &__bos0 ($dest)) :  &__mempcpy_ichk ($dest, $src, $len)));
    }' unless defined(&mempcpy);
    eval 'sub __attribute__ {
        eval q((( &__always_inline__))  &__mempcpy_ichk ( &void * &__restrict  &__dest,  &const  &void * &__restrict  &__src, \'size_t\'  &__len) {  &__builtin___mempcpy_chk ( &__dest,  &__src,  &__len,  &__bos0 ( &__dest)); });
    }' unless defined(&__attribute__);
}
unless(defined(&memset)) {
    sub memset {
	my($dest, $ch, $len) = @_;
	eval q((( &__bos0 ($dest) !=  -1) ?  &__builtin___memset_chk ($dest, $ch, $len,  &__bos0 ($dest)) :  &__memset_ichk ($dest, $ch, $len)));
    }
}
unless(defined(&__attribute__)) {
    sub __attribute__ {
	eval q((( &__always_inline__))  &__memset_ichk ( &void * &__dest, 'int'  &__ch, 'size_t'  &__len) {  &__builtin___memset_chk ( &__dest,  &__ch,  &__len,  &__bos0 ( &__dest)); });
    }
}
if(defined(&__USE_BSD)) {
    eval 'sub bcopy {
        my($src, $dest, $len) = @_;
	    eval q((( &void) (( &__bos0 ($dest) !=  -1) ?  &__builtin___memmove_chk ($dest, $src, $len,  &__bos0 ($dest)) :  &__memmove_ichk ($dest, $src, $len))));
    }' unless defined(&bcopy);
    eval 'sub bzero {
        my($dest, $len) = @_;
	    eval q((( &void) (( &__bos0 ($dest) !=  -1) ?  &__builtin___memset_chk ($dest, ord(\'\\\\0\', len, __bos0 (dest))		   : __memset_ichk (dest, \'\\\\0\'), $len))));
    }' unless defined(&bzero);
}
unless(defined(&strcpy)) {
    sub strcpy {
	my($dest, $src) = @_;
	eval q((( &__bos ($dest) !=  -1) ?  &__builtin___strcpy_chk ($dest, $src,  &__bos ($dest)) :  &__strcpy_ichk ($dest, $src)));
    }
}
unless(defined(&__attribute__)) {
    sub __attribute__ {
	eval q((( &__always_inline__))  &__strcpy_ichk ('char' * &__restrict  &__dest,  &const 'char' * &__restrict  &__src) {  &__builtin___strcpy_chk ( &__dest,  &__src,  &__bos ( &__dest)); });
    }
}
if(defined(&__USE_GNU)) {
    eval 'sub stpcpy {
        my($dest, $src) = @_;
	    eval q((( &__bos ($dest) !=  -1) ?  &__builtin___stpcpy_chk ($dest, $src,  &__bos ($dest)) :  &__stpcpy_ichk ($dest, $src)));
    }' unless defined(&stpcpy);
    eval 'sub __attribute__ {
        eval q((( &__always_inline__))  &__stpcpy_ichk (\'char\' * &__restrict  &__dest,  &const \'char\' * &__restrict  &__src) {  &__builtin___stpcpy_chk ( &__dest,  &__src,  &__bos ( &__dest)); });
    }' unless defined(&__attribute__);
}
unless(defined(&strncpy)) {
    sub strncpy {
	my($dest, $src, $len) = @_;
	eval q((( &__bos ($dest) !=  -1) ?  &__builtin___strncpy_chk ($dest, $src, $len,  &__bos ($dest)) :  &__strncpy_ichk ($dest, $src, $len)));
    }
}
unless(defined(&__attribute__)) {
    sub __attribute__ {
	eval q((( &__always_inline__))  &__strncpy_ichk ('char' * &__restrict  &__dest,  &const 'char' * &__restrict  &__src, 'size_t'  &__len) {  &__builtin___strncpy_chk ( &__dest,  &__src,  &__len,  &__bos ( &__dest)); });
    }
}
unless(defined(&strcat)) {
    sub strcat {
	my($dest, $src) = @_;
	eval q((( &__bos ($dest) !=  -1) ?  &__builtin___strcat_chk ($dest, $src,  &__bos ($dest)) :  &__strcat_ichk ($dest, $src)));
    }
}
unless(defined(&__attribute__)) {
    sub __attribute__ {
	eval q((( &__always_inline__))  &__strcat_ichk ('char' * &__restrict  &__dest,  &const 'char' * &__restrict  &__src) {  &__builtin___strcat_chk ( &__dest,  &__src,  &__bos ( &__dest)); });
    }
}
unless(defined(&strncat)) {
    sub strncat {
	my($dest, $src, $len) = @_;
	eval q((( &__bos ($dest) !=  -1) ?  &__builtin___strncat_chk ($dest, $src, $len,  &__bos ($dest)) :  &__strncat_ichk ($dest, $src, $len)));
    }
}
unless(defined(&__attribute__)) {
    sub __attribute__ {
	eval q((( &__always_inline__))  &__strncat_ichk ('char' * &__restrict  &__dest,  &const 'char' * &__restrict  &__src, 'size_t'  &__len) {  &__builtin___strncat_chk ( &__dest,  &__src,  &__len,  &__bos ( &__dest)); });
    }
}
1;
