require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_X86_64_I387_H)) {
    eval 'sub __ASM_X86_64_I387_H () {1;}' unless defined(&__ASM_X86_64_I387_H);
    require 'linux/sched.ph';
    require 'asm/processor.ph';
    require 'asm/sigcontext.ph';
    require 'asm/user.ph';
    eval 'sub kernel_fpu_end () {
        eval q( &stts());
    }' unless defined(&kernel_fpu_end);
    eval 'sub unlazy_fpu {
        my( $tsk ) = @_;
	    eval q( &do {  &if (  ($tsk->{flags}) &  &PF_USEDFPU )  &save_init_fpu( $tsk ); }  &while (0));
    }' unless defined(&unlazy_fpu);
    eval 'sub clear_fpu {
        my( $tsk ) = @_;
	    eval q( &do {  &if (  ($tsk->{flags}) &  &PF_USEDFPU ) {  &asm  &volatile(\\"fwait\\");  ($tsk->{flags}) &= ~ &PF_USEDFPU;  &stts(); } }  &while (0));
    }' unless defined(&clear_fpu);
    eval 'sub load_mxcsr {
        my( $val ) = @_;
	    eval q( &do { \'unsigned long __mxcsr\' = (($val) & 0xffbf);  &asm  &volatile( \\"ldmxcsr %0\\" : : \\"m\\" ( &__mxcsr) ); }  &while (0));
    }' unless defined(&load_mxcsr);
    eval 'sub get_fpu_mxcsr {
        my($t) = @_;
	    eval q((($t)-> ($thread->{i387}->{fxsave}->{mxcsr})));
    }' unless defined(&get_fpu_mxcsr);
    eval 'sub get_fpu_cwd {
        my($t) = @_;
	    eval q((($t)-> ($thread->{i387}->{fxsave}->{cwd})));
    }' unless defined(&get_fpu_cwd);
    eval 'sub get_fpu_fxsr_twd {
        my($t) = @_;
	    eval q((($t)-> ($thread->{i387}->{fxsave}->{twd})));
    }' unless defined(&get_fpu_fxsr_twd);
    eval 'sub get_fpu_swd {
        my($t) = @_;
	    eval q((($t)-> ($thread->{i387}->{fxsave}->{swd})));
    }' unless defined(&get_fpu_swd);
    eval 'sub set_fpu_cwd {
        my($t,$val) = @_;
	    eval q((($t)-> ($thread->{i387}->{fxsave}->{cwd}) = ($val)));
    }' unless defined(&set_fpu_cwd);
    eval 'sub set_fpu_swd {
        my($t,$val) = @_;
	    eval q((($t)-> ($thread->{i387}->{fxsave}->{swd}) = ($val)));
    }' unless defined(&set_fpu_swd);
    eval 'sub set_fpu_fxsr_twd {
        my($t,$val) = @_;
	    eval q((($t)-> ($thread->{i387}->{fxsave}->{twd}) = ($val)));
    }' unless defined(&set_fpu_fxsr_twd);
    eval 'sub set_fpu_mxcsr {
        my($t,$val) = @_;
	    eval q((($t)-> ($thread->{i387}->{fxsave}->{mxcsr}) = ($val)&0xffbf));
    }' unless defined(&set_fpu_mxcsr);
    eval 'sub restore_fpu {
        my($tsk) = @_;
	    eval q({  &asm  &volatile(\\"rex64 ; fxrstor %0\\" :: \\"m\\" ( ($tsk->{thread}->{i387}->{fxsave})) ); });
    }' unless defined(&restore_fpu);
    eval 'sub restore_fpu_checking {
        my($fx) = @_;
	    eval q({ \'int\'  &err;  &asm  &volatile(\\"1:  rex64 ; fxrstor (%[fx])\\\\n\\\\t\\" \\"2:\\\\n\\" \\".section .fixup,\\\\\\"ax\\\\\\"\\\\n\\" \\"3:  movl $-1,%[err]\\\\n\\" \\"    jmp  2b\\\\n\\" \\".previous\\\\n\\" \\".section __ex_table,\\\\\\"a\\\\\\"\\\\n\\" \\"   .align 8\\\\n\\" \\"   .quad  1b,3b\\\\n\\" \\".previous\\" : [ &err] \\"=r\\" ( &err) : [$fx] \\"r\\" ($fx), \\"0\\" (0));  &err; } );
    }' unless defined(&restore_fpu_checking);
    eval 'sub save_i387_checking {
        my($fx) = @_;
	    eval q({ \'int\'  &err;  &asm  &volatile(\\"1:  rex64 ; fxsave (%[fx])\\\\n\\\\t\\" \\"2:\\\\n\\" \\".section .fixup,\\\\\\"ax\\\\\\"\\\\n\\" \\"3:  movl $-1,%[err]\\\\n\\" \\"    jmp  2b\\\\n\\" \\".previous\\\\n\\" \\".section __ex_table,\\\\\\"a\\\\\\"\\\\n\\" \\"   .align 8\\\\n\\" \\"   .quad  1b,3b\\\\n\\" \\".previous\\" : [ &err] \\"=r\\" ( &err) : [$fx] \\"r\\" ($fx), \\"0\\" (0));  &err; } );
    }' unless defined(&save_i387_checking);
    eval 'sub kernel_fpu_begin {
        my($void) = @_;
	    eval q({ \'struct task_struct\' * &tsk =  &current;  &if ( ($tsk->{flags}) &  &PF_USEDFPU) {  &asm  &volatile(\\"fxsave %0 ; fnclex\\" : \\"=m\\" ( ($tsk->{thread}->{i387}->{fxsave})));  ($tsk->{flags}) &= ~ &PF_USEDFPU; ; }  &clts(); });
    }' unless defined(&kernel_fpu_begin);
    eval 'sub save_init_fpu {
        my($tsk) = @_;
	    eval q({  &asm  &volatile( \\"fxsave %0 ; fnclex\\" : \\"=m\\" ( ($tsk->{thread}->{i387}->{fxsave})));  ($tsk->{flags}) &= ~ &PF_USEDFPU;  &stts(); });
    }' unless defined(&save_init_fpu);
    eval 'sub empty_fpu {
        my($child) = @_;
	    eval q({  &if (! ($child->{used_math})) {  ($child->{thread}->{i387}->{fxsave}->{cwd}) = 0x37f;  ($child->{thread}->{i387}->{fxsave}->{swd}) = 0;  ($child->{thread}->{i387}->{fxsave}->{twd}) = 0;  ($child->{thread}->{i387}->{fxsave}->{mxcsr}) &= 0xffbf; }  ($child->{used_math}) = 1; } );
    }' unless defined(&empty_fpu);
}
1;
