require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_HW_IRQ_H)) {
    eval 'sub _ASM_HW_IRQ_H () {1;}' unless defined(&_ASM_HW_IRQ_H);
    require 'linux/config.ph';
    require 'asm/atomic.ph';
    require 'asm/irq.ph';
    eval 'sub FIRST_EXTERNAL_VECTOR () {0x20;}' unless defined(&FIRST_EXTERNAL_VECTOR);
    eval 'sub IA32_SYSCALL_VECTOR () {0x80;}' unless defined(&IA32_SYSCALL_VECTOR);
    eval 'sub KDBENTER_VECTOR () {0x81;}' unless defined(&KDBENTER_VECTOR);
    eval 'sub SPURIOUS_APIC_VECTOR () {0xff;}' unless defined(&SPURIOUS_APIC_VECTOR);
    eval 'sub ERROR_APIC_VECTOR () {0xfe;}' unless defined(&ERROR_APIC_VECTOR);
    eval 'sub INVALIDATE_TLB_VECTOR () {0xfd;}' unless defined(&INVALIDATE_TLB_VECTOR);
    eval 'sub RESCHEDULE_VECTOR () {0xfc;}' unless defined(&RESCHEDULE_VECTOR);
    eval 'sub KDB_VECTOR () {0xfa;}' unless defined(&KDB_VECTOR);
    eval 'sub CALL_FUNCTION_VECTOR () {0xfb;}' unless defined(&CALL_FUNCTION_VECTOR);
    eval 'sub KDB_VECTOR () {0xfa;}' unless defined(&KDB_VECTOR);
    eval 'sub LOCAL_TIMER_VECTOR () {0xef;}' unless defined(&LOCAL_TIMER_VECTOR);
    eval 'sub FIRST_DEVICE_VECTOR () {0x31;}' unless defined(&FIRST_DEVICE_VECTOR);
    eval 'sub FIRST_SYSTEM_VECTOR () {0xef;}' unless defined(&FIRST_SYSTEM_VECTOR);
    eval 'sub IO_APIC_VECTOR {
        my($irq) = @_;
	    eval q( $irq_vector[$irq]);
    }' unless defined(&IO_APIC_VECTOR);
    eval 'sub IO_APIC_IRQ {
        my($x) = @_;
	    eval q(((($x) >= 16) || ((1<<($x)) &  &io_apic_irqs)));
    }' unless defined(&IO_APIC_IRQ);
    eval 'sub __STR {
        my($x) = @_;
	    eval q($x);
    }' unless defined(&__STR);
    eval 'sub STR {
        my($x) = @_;
	    eval q( &__STR($x));
    }' unless defined(&STR);
    require 'asm/ptrace.ph';
    unless(defined(&ASM_OFFSET_H)) {
	require 'asm/offset.ph';
    }
    eval 'sub IRQ_ENTER () {"	cld ;" "	pushq %rdi ;" "	pushq %rsi ;" "	pushq %rdx ;" "	pushq %rcx ;" "	pushq %rax ;" "	pushq %r8 ;" "	pushq %r9 ;" "	pushq %r10 ;" "	pushq %r11 ;" "	leaq -48(%rsp),%rdi	;" "	testl $3,136(%rdi)	;" "	je 1f ;" "	swapgs ;" "1:	addl $1,%gs: "  &STR( &pda_irqcount) ";" "	movq %gs: "  &STR( &pda_irqstackptr) ",%rax ;" "	cmoveq %rax,%rsp ;" "	pushq %rdi ;";}' unless defined(&IRQ_ENTER);
    eval 'sub IRQ_NAME2 {
        my($nr) = @_;
	    eval q($nr &_interrupt( &void));
    }' unless defined(&IRQ_NAME2);
    eval 'sub IRQ_NAME {
        my($nr) = @_;
	    eval q( &IRQ_NAME2( &IRQ$nr));
    }' unless defined(&IRQ_NAME);
    eval 'sub BUILD_SMP_INTERRUPT {
        my($x,$v) = @_;
	    eval q( &XBUILD_SMP_INTERRUPT($x,$v));
    }' unless defined(&BUILD_SMP_INTERRUPT);
    eval 'sub XBUILD_SMP_INTERRUPT {
        my($x,$v) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&XBUILD_SMP_INTERRUPT);
    eval 'sub BUILD_SMP_TIMER_INTERRUPT {
        my($x,$v) = @_;
	    eval q( &XBUILD_SMP_TIMER_INTERRUPT($x,$v));
    }' unless defined(&BUILD_SMP_TIMER_INTERRUPT);
    eval 'sub XBUILD_SMP_TIMER_INTERRUPT {
        my($x,$v) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&XBUILD_SMP_TIMER_INTERRUPT);
    eval 'sub BUILD_COMMON_IRQ () {
        eval q();
    }' unless defined(&BUILD_COMMON_IRQ);
    eval 'sub BUILD_IRQ {
        my($nr) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&BUILD_IRQ);
    if(defined(&CONFIG_SMP)) {
	eval 'sub hw_resend_irq {
	    my($h,$i) = @_;
    	    eval q({  &if ( &IO_APIC_IRQ($i))  &send_IPI_self( &IO_APIC_VECTOR($i)); });
	}' unless defined(&hw_resend_irq);
    } else {
    }
}
1;
