require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_SPINLOCK_H)) {
    eval 'sub __ASM_SPINLOCK_H () {1;}' unless defined(&__ASM_SPINLOCK_H);
    require 'asm/atomic.ph';
    require 'asm/rwlock.ph';
    require 'asm/page.ph';
    require 'linux/config.ph';
    if(defined( &CONFIG_DEBUG_SPINLOCK)) {
	eval 'sub SPINLOCK_DEBUG () {1;}' unless defined(&SPINLOCK_DEBUG);
    } else {
	eval 'sub SPINLOCK_DEBUG () {0;}' unless defined(&SPINLOCK_DEBUG);
    }
    if((defined(&SPINLOCK_DEBUG) ? &SPINLOCK_DEBUG : undef)) {
    }
    eval 'sub SPINLOCK_MAGIC () {0xdead4ead;}' unless defined(&SPINLOCK_MAGIC);
    if((defined(&SPINLOCK_DEBUG) ? &SPINLOCK_DEBUG : undef)) {
	eval 'sub SPINLOCK_MAGIC_INIT () {,  &SPINLOCK_MAGIC;}' unless defined(&SPINLOCK_MAGIC_INIT);
    } else {
	eval 'sub SPINLOCK_MAGIC_INIT () {1;}' unless defined(&SPINLOCK_MAGIC_INIT);
    }
    eval 'sub SPIN_LOCK_UNLOCKED () {( &spinlock_t) { 1 &SPINLOCK_MAGIC_INIT };}' unless defined(&SPIN_LOCK_UNLOCKED);
    eval 'sub spin_lock_init {
        my($x) = @_;
	    eval q( &do { *($x) =  &SPIN_LOCK_UNLOCKED; }  &while(0));
    }' unless defined(&spin_lock_init);
    eval 'sub spin_is_locked {
        my($x) = @_;
	    eval q((*( &volatile \'char\' *)(($x)-> &lock) <= 0));
    }' unless defined(&spin_is_locked);
    eval 'sub spin_unlock_wait {
        my($x) = @_;
	    eval q( &do {  &barrier(); }  &while( &spin_is_locked($x)));
    }' unless defined(&spin_unlock_wait);
    eval 'sub spin_lock_string () {"\\n1:\\t" "lock ; decb %0\\n\\t" "js 2f\\n" ".section .text.lock,\\"ax\\"\\n" "2:\\t" "cmpb $0,%0\\n\\t" "rep;nop\\n\\t" "jle 2b\\n\\t" "jmp 1b\\n" ".previous";}' unless defined(&spin_lock_string);
    eval 'sub spin_unlock_string () {"movb $1,%0";}' unless defined(&spin_unlock_string);
    eval 'sub spin_trylock {
        my($lock) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&spin_trylock);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub spin_lock {
        my($lock) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&spin_lock);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub spin_unlock {
        my($lock) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&spin_unlock);
    if((defined(&SPINLOCK_DEBUG) ? &SPINLOCK_DEBUG : undef)) {
    }
    eval 'sub RWLOCK_MAGIC () {0xdeaf1eed;}' unless defined(&RWLOCK_MAGIC);
    if((defined(&SPINLOCK_DEBUG) ? &SPINLOCK_DEBUG : undef)) {
	eval 'sub RWLOCK_MAGIC_INIT () {,  &RWLOCK_MAGIC;}' unless defined(&RWLOCK_MAGIC_INIT);
    } else {
	eval 'sub RWLOCK_MAGIC_INIT () {1;}' unless defined(&RWLOCK_MAGIC_INIT);
    }
    eval 'sub RW_LOCK_UNLOCKED () {( &rwlock_t) {  &RW_LOCK_BIAS  &RWLOCK_MAGIC_INIT };}' unless defined(&RW_LOCK_UNLOCKED);
    eval 'sub rwlock_init {
        my($x) = @_;
	    eval q( &do { *($x) =  &RW_LOCK_UNLOCKED; }  &while(0));
    }' unless defined(&rwlock_init);
    if((defined(&SPINLOCK_DEBUG) ? &SPINLOCK_DEBUG : undef)) {
    }
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub write_lock {
        my($rw) = @_;
	    eval q({  &__build_write_lock($rw, \\"__write_lock_failed\\"); });
    }' unless defined(&write_lock);
    eval 'sub read_unlock {
        my($rw) = @_;
	    eval q( &asm  &volatile(\\"lock ; incl %0\\" :\\"=m\\" (($rw)-> &lock) : : \\"memory\\"));
    }' unless defined(&read_unlock);
    eval 'sub write_unlock {
        my($rw) = @_;
	    eval q( &asm  &volatile(\\"lock ; addl $\\"  &RW_LOCK_BIAS_STR \\",%0\\":\\"=m\\" (($rw)-> &lock) : : \\"memory\\"));
    }' unless defined(&write_unlock);
    eval 'sub write_trylock {
        my($lock) = @_;
	    eval q({  &atomic_t * &count = ( &atomic_t *)$lock;  &if ( &atomic_sub_and_test( &RW_LOCK_BIAS,  &count)) 1;  &atomic_add( &RW_LOCK_BIAS,  &count); 0; });
    }' unless defined(&write_trylock);
}
1;
