#! /bin/sh
### BEGIN INIT INFO
# Provides:          dhcpv6_hack
# Required-Start:
# Required-Stop:
# Default-Start:     2 3 4 5
# Default-Stop:      0 6
# Short-Description: dhcp v6 key creation.
# Description:       Create dhcp v6 key.
### END INIT INFO

DHCP6CCTLKEY=/etc/wide-dhcpv6/dhcp6cctlkey

case "$1" in
  start|"")
	# The key mustn\'t be world readable
	umask 066

	echo "Generating ${DHCP6CCTLKEY}..." >&2
	dd if=/dev/random bs=32 count=1 2>/dev/null | 		uuencode -m ${DHCP6CCTLKEY} | 		head -n 2 | tail -n 1 > ${DHCP6CCTLKEY}

	umask 022
	/usr/sbin/update-rc.d dhcpv6_hack.sh remove >/dev/null 2>&1
	;;
  *)
	echo "Usage: dhcpv6_hack [start]" >&2
	exit 3
	;;
esac

:

