﻿// <auto-generated />

using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Threading;


namespace Microsoft.AspNetCore.Razor.Language.Syntax
{
  internal partial class SyntaxVisitor<TResult>
  {
    /// <summary>Called when the visitor visits a RazorDocumentSyntax node.</summary>
    public virtual TResult VisitRazorDocument(RazorDocumentSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a RazorCommentBlockSyntax node.</summary>
    public virtual TResult VisitRazorCommentBlock(RazorCommentBlockSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a RazorMetaCodeSyntax node.</summary>
    public virtual TResult VisitRazorMetaCode(RazorMetaCodeSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a GenericBlockSyntax node.</summary>
    public virtual TResult VisitGenericBlock(GenericBlockSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a UnclassifiedTextLiteralSyntax node.</summary>
    public virtual TResult VisitUnclassifiedTextLiteral(UnclassifiedTextLiteralSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupBlockSyntax node.</summary>
    public virtual TResult VisitMarkupBlock(MarkupBlockSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupTransitionSyntax node.</summary>
    public virtual TResult VisitMarkupTransition(MarkupTransitionSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupTextLiteralSyntax node.</summary>
    public virtual TResult VisitMarkupTextLiteral(MarkupTextLiteralSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupEphemeralTextLiteralSyntax node.</summary>
    public virtual TResult VisitMarkupEphemeralTextLiteral(MarkupEphemeralTextLiteralSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupCommentBlockSyntax node.</summary>
    public virtual TResult VisitMarkupCommentBlock(MarkupCommentBlockSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupMinimizedAttributeBlockSyntax node.</summary>
    public virtual TResult VisitMarkupMinimizedAttributeBlock(MarkupMinimizedAttributeBlockSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupAttributeBlockSyntax node.</summary>
    public virtual TResult VisitMarkupAttributeBlock(MarkupAttributeBlockSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupMiscAttributeContentSyntax node.</summary>
    public virtual TResult VisitMarkupMiscAttributeContent(MarkupMiscAttributeContentSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupLiteralAttributeValueSyntax node.</summary>
    public virtual TResult VisitMarkupLiteralAttributeValue(MarkupLiteralAttributeValueSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupDynamicAttributeValueSyntax node.</summary>
    public virtual TResult VisitMarkupDynamicAttributeValue(MarkupDynamicAttributeValueSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupElementSyntax node.</summary>
    public virtual TResult VisitMarkupElement(MarkupElementSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupStartTagSyntax node.</summary>
    public virtual TResult VisitMarkupStartTag(MarkupStartTagSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupEndTagSyntax node.</summary>
    public virtual TResult VisitMarkupEndTag(MarkupEndTagSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupTagHelperElementSyntax node.</summary>
    public virtual TResult VisitMarkupTagHelperElement(MarkupTagHelperElementSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupTagHelperStartTagSyntax node.</summary>
    public virtual TResult VisitMarkupTagHelperStartTag(MarkupTagHelperStartTagSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupTagHelperEndTagSyntax node.</summary>
    public virtual TResult VisitMarkupTagHelperEndTag(MarkupTagHelperEndTagSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupTagHelperAttributeSyntax node.</summary>
    public virtual TResult VisitMarkupTagHelperAttribute(MarkupTagHelperAttributeSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupMinimizedTagHelperAttributeSyntax node.</summary>
    public virtual TResult VisitMarkupMinimizedTagHelperAttribute(MarkupMinimizedTagHelperAttributeSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupTagHelperAttributeValueSyntax node.</summary>
    public virtual TResult VisitMarkupTagHelperAttributeValue(MarkupTagHelperAttributeValueSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupTagHelperDirectiveAttributeSyntax node.</summary>
    public virtual TResult VisitMarkupTagHelperDirectiveAttribute(MarkupTagHelperDirectiveAttributeSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupMinimizedTagHelperDirectiveAttributeSyntax node.</summary>
    public virtual TResult VisitMarkupMinimizedTagHelperDirectiveAttribute(MarkupMinimizedTagHelperDirectiveAttributeSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a CSharpCodeBlockSyntax node.</summary>
    public virtual TResult VisitCSharpCodeBlock(CSharpCodeBlockSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a CSharpTransitionSyntax node.</summary>
    public virtual TResult VisitCSharpTransition(CSharpTransitionSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a CSharpStatementLiteralSyntax node.</summary>
    public virtual TResult VisitCSharpStatementLiteral(CSharpStatementLiteralSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a CSharpExpressionLiteralSyntax node.</summary>
    public virtual TResult VisitCSharpExpressionLiteral(CSharpExpressionLiteralSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a CSharpEphemeralTextLiteralSyntax node.</summary>
    public virtual TResult VisitCSharpEphemeralTextLiteral(CSharpEphemeralTextLiteralSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a CSharpTemplateBlockSyntax node.</summary>
    public virtual TResult VisitCSharpTemplateBlock(CSharpTemplateBlockSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a CSharpStatementSyntax node.</summary>
    public virtual TResult VisitCSharpStatement(CSharpStatementSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a CSharpStatementBodySyntax node.</summary>
    public virtual TResult VisitCSharpStatementBody(CSharpStatementBodySyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a CSharpExplicitExpressionSyntax node.</summary>
    public virtual TResult VisitCSharpExplicitExpression(CSharpExplicitExpressionSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a CSharpExplicitExpressionBodySyntax node.</summary>
    public virtual TResult VisitCSharpExplicitExpressionBody(CSharpExplicitExpressionBodySyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a CSharpImplicitExpressionSyntax node.</summary>
    public virtual TResult VisitCSharpImplicitExpression(CSharpImplicitExpressionSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a CSharpImplicitExpressionBodySyntax node.</summary>
    public virtual TResult VisitCSharpImplicitExpressionBody(CSharpImplicitExpressionBodySyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a RazorDirectiveSyntax node.</summary>
    public virtual TResult VisitRazorDirective(RazorDirectiveSyntax node)
    {
      return DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a RazorDirectiveBodySyntax node.</summary>
    public virtual TResult VisitRazorDirectiveBody(RazorDirectiveBodySyntax node)
    {
      return DefaultVisit(node);
    }
  }

  internal partial class SyntaxVisitor
  {
    /// <summary>Called when the visitor visits a RazorDocumentSyntax node.</summary>
    public virtual void VisitRazorDocument(RazorDocumentSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a RazorCommentBlockSyntax node.</summary>
    public virtual void VisitRazorCommentBlock(RazorCommentBlockSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a RazorMetaCodeSyntax node.</summary>
    public virtual void VisitRazorMetaCode(RazorMetaCodeSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a GenericBlockSyntax node.</summary>
    public virtual void VisitGenericBlock(GenericBlockSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a UnclassifiedTextLiteralSyntax node.</summary>
    public virtual void VisitUnclassifiedTextLiteral(UnclassifiedTextLiteralSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupBlockSyntax node.</summary>
    public virtual void VisitMarkupBlock(MarkupBlockSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupTransitionSyntax node.</summary>
    public virtual void VisitMarkupTransition(MarkupTransitionSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupTextLiteralSyntax node.</summary>
    public virtual void VisitMarkupTextLiteral(MarkupTextLiteralSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupEphemeralTextLiteralSyntax node.</summary>
    public virtual void VisitMarkupEphemeralTextLiteral(MarkupEphemeralTextLiteralSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupCommentBlockSyntax node.</summary>
    public virtual void VisitMarkupCommentBlock(MarkupCommentBlockSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupMinimizedAttributeBlockSyntax node.</summary>
    public virtual void VisitMarkupMinimizedAttributeBlock(MarkupMinimizedAttributeBlockSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupAttributeBlockSyntax node.</summary>
    public virtual void VisitMarkupAttributeBlock(MarkupAttributeBlockSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupMiscAttributeContentSyntax node.</summary>
    public virtual void VisitMarkupMiscAttributeContent(MarkupMiscAttributeContentSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupLiteralAttributeValueSyntax node.</summary>
    public virtual void VisitMarkupLiteralAttributeValue(MarkupLiteralAttributeValueSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupDynamicAttributeValueSyntax node.</summary>
    public virtual void VisitMarkupDynamicAttributeValue(MarkupDynamicAttributeValueSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupElementSyntax node.</summary>
    public virtual void VisitMarkupElement(MarkupElementSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupStartTagSyntax node.</summary>
    public virtual void VisitMarkupStartTag(MarkupStartTagSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupEndTagSyntax node.</summary>
    public virtual void VisitMarkupEndTag(MarkupEndTagSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupTagHelperElementSyntax node.</summary>
    public virtual void VisitMarkupTagHelperElement(MarkupTagHelperElementSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupTagHelperStartTagSyntax node.</summary>
    public virtual void VisitMarkupTagHelperStartTag(MarkupTagHelperStartTagSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupTagHelperEndTagSyntax node.</summary>
    public virtual void VisitMarkupTagHelperEndTag(MarkupTagHelperEndTagSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupTagHelperAttributeSyntax node.</summary>
    public virtual void VisitMarkupTagHelperAttribute(MarkupTagHelperAttributeSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupMinimizedTagHelperAttributeSyntax node.</summary>
    public virtual void VisitMarkupMinimizedTagHelperAttribute(MarkupMinimizedTagHelperAttributeSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupTagHelperAttributeValueSyntax node.</summary>
    public virtual void VisitMarkupTagHelperAttributeValue(MarkupTagHelperAttributeValueSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupTagHelperDirectiveAttributeSyntax node.</summary>
    public virtual void VisitMarkupTagHelperDirectiveAttribute(MarkupTagHelperDirectiveAttributeSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a MarkupMinimizedTagHelperDirectiveAttributeSyntax node.</summary>
    public virtual void VisitMarkupMinimizedTagHelperDirectiveAttribute(MarkupMinimizedTagHelperDirectiveAttributeSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a CSharpCodeBlockSyntax node.</summary>
    public virtual void VisitCSharpCodeBlock(CSharpCodeBlockSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a CSharpTransitionSyntax node.</summary>
    public virtual void VisitCSharpTransition(CSharpTransitionSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a CSharpStatementLiteralSyntax node.</summary>
    public virtual void VisitCSharpStatementLiteral(CSharpStatementLiteralSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a CSharpExpressionLiteralSyntax node.</summary>
    public virtual void VisitCSharpExpressionLiteral(CSharpExpressionLiteralSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a CSharpEphemeralTextLiteralSyntax node.</summary>
    public virtual void VisitCSharpEphemeralTextLiteral(CSharpEphemeralTextLiteralSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a CSharpTemplateBlockSyntax node.</summary>
    public virtual void VisitCSharpTemplateBlock(CSharpTemplateBlockSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a CSharpStatementSyntax node.</summary>
    public virtual void VisitCSharpStatement(CSharpStatementSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a CSharpStatementBodySyntax node.</summary>
    public virtual void VisitCSharpStatementBody(CSharpStatementBodySyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a CSharpExplicitExpressionSyntax node.</summary>
    public virtual void VisitCSharpExplicitExpression(CSharpExplicitExpressionSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a CSharpExplicitExpressionBodySyntax node.</summary>
    public virtual void VisitCSharpExplicitExpressionBody(CSharpExplicitExpressionBodySyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a CSharpImplicitExpressionSyntax node.</summary>
    public virtual void VisitCSharpImplicitExpression(CSharpImplicitExpressionSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a CSharpImplicitExpressionBodySyntax node.</summary>
    public virtual void VisitCSharpImplicitExpressionBody(CSharpImplicitExpressionBodySyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a RazorDirectiveSyntax node.</summary>
    public virtual void VisitRazorDirective(RazorDirectiveSyntax node)
    {
      DefaultVisit(node);
    }

    /// <summary>Called when the visitor visits a RazorDirectiveBodySyntax node.</summary>
    public virtual void VisitRazorDirectiveBody(RazorDirectiveBodySyntax node)
    {
      DefaultVisit(node);
    }
  }

  internal partial class SyntaxRewriter : SyntaxVisitor<SyntaxNode>
  {
    public override SyntaxNode VisitRazorDocument(RazorDocumentSyntax node)
    {
      var document = (RazorBlockSyntax)Visit(node.Document);
      return node.Update(document);
    }

    public override SyntaxNode VisitRazorCommentBlock(RazorCommentBlockSyntax node)
    {
      var startCommentTransition = (SyntaxToken)VisitToken(node.StartCommentTransition);
      var startCommentStar = (SyntaxToken)VisitToken(node.StartCommentStar);
      var comment = (SyntaxToken)VisitToken(node.Comment);
      var endCommentStar = (SyntaxToken)VisitToken(node.EndCommentStar);
      var endCommentTransition = (SyntaxToken)VisitToken(node.EndCommentTransition);
      return node.Update(startCommentTransition, startCommentStar, comment, endCommentStar, endCommentTransition);
    }

    public override SyntaxNode VisitRazorMetaCode(RazorMetaCodeSyntax node)
    {
      var metaCode = VisitList(node.MetaCode);
      return node.Update(metaCode);
    }

    public override SyntaxNode VisitGenericBlock(GenericBlockSyntax node)
    {
      var children = VisitList(node.Children);
      return node.Update(children);
    }

    public override SyntaxNode VisitUnclassifiedTextLiteral(UnclassifiedTextLiteralSyntax node)
    {
      var literalTokens = VisitList(node.LiteralTokens);
      return node.Update(literalTokens);
    }

    public override SyntaxNode VisitMarkupBlock(MarkupBlockSyntax node)
    {
      var children = VisitList(node.Children);
      return node.Update(children);
    }

    public override SyntaxNode VisitMarkupTransition(MarkupTransitionSyntax node)
    {
      var transitionTokens = VisitList(node.TransitionTokens);
      return node.Update(transitionTokens);
    }

    public override SyntaxNode VisitMarkupTextLiteral(MarkupTextLiteralSyntax node)
    {
      var literalTokens = VisitList(node.LiteralTokens);
      return node.Update(literalTokens);
    }

    public override SyntaxNode VisitMarkupEphemeralTextLiteral(MarkupEphemeralTextLiteralSyntax node)
    {
      var literalTokens = VisitList(node.LiteralTokens);
      return node.Update(literalTokens);
    }

    public override SyntaxNode VisitMarkupCommentBlock(MarkupCommentBlockSyntax node)
    {
      var children = VisitList(node.Children);
      return node.Update(children);
    }

    public override SyntaxNode VisitMarkupMinimizedAttributeBlock(MarkupMinimizedAttributeBlockSyntax node)
    {
      var namePrefix = (MarkupTextLiteralSyntax)Visit(node.NamePrefix);
      var name = (MarkupTextLiteralSyntax)Visit(node.Name);
      return node.Update(namePrefix, name);
    }

    public override SyntaxNode VisitMarkupAttributeBlock(MarkupAttributeBlockSyntax node)
    {
      var namePrefix = (MarkupTextLiteralSyntax)Visit(node.NamePrefix);
      var name = (MarkupTextLiteralSyntax)Visit(node.Name);
      var nameSuffix = (MarkupTextLiteralSyntax)Visit(node.NameSuffix);
      var equalsToken = (SyntaxToken)VisitToken(node.EqualsToken);
      var valuePrefix = (MarkupTextLiteralSyntax)Visit(node.ValuePrefix);
      var value = (RazorBlockSyntax)Visit(node.Value);
      var valueSuffix = (MarkupTextLiteralSyntax)Visit(node.ValueSuffix);
      return node.Update(namePrefix, name, nameSuffix, equalsToken, valuePrefix, value, valueSuffix);
    }

    public override SyntaxNode VisitMarkupMiscAttributeContent(MarkupMiscAttributeContentSyntax node)
    {
      var children = VisitList(node.Children);
      return node.Update(children);
    }

    public override SyntaxNode VisitMarkupLiteralAttributeValue(MarkupLiteralAttributeValueSyntax node)
    {
      var prefix = (MarkupTextLiteralSyntax)Visit(node.Prefix);
      var value = (MarkupTextLiteralSyntax)Visit(node.Value);
      return node.Update(prefix, value);
    }

    public override SyntaxNode VisitMarkupDynamicAttributeValue(MarkupDynamicAttributeValueSyntax node)
    {
      var prefix = (MarkupTextLiteralSyntax)Visit(node.Prefix);
      var value = (RazorBlockSyntax)Visit(node.Value);
      return node.Update(prefix, value);
    }

    public override SyntaxNode VisitMarkupElement(MarkupElementSyntax node)
    {
      var startTag = (MarkupStartTagSyntax)Visit(node.StartTag);
      var body = VisitList(node.Body);
      var endTag = (MarkupEndTagSyntax)Visit(node.EndTag);
      return node.Update(startTag, body, endTag);
    }

    public override SyntaxNode VisitMarkupStartTag(MarkupStartTagSyntax node)
    {
      var openAngle = (SyntaxToken)VisitToken(node.OpenAngle);
      var bang = (SyntaxToken)VisitToken(node.Bang);
      var name = (SyntaxToken)VisitToken(node.Name);
      var attributes = VisitList(node.Attributes);
      var forwardSlash = (SyntaxToken)VisitToken(node.ForwardSlash);
      var closeAngle = (SyntaxToken)VisitToken(node.CloseAngle);
      return node.Update(openAngle, bang, name, attributes, forwardSlash, closeAngle);
    }

    public override SyntaxNode VisitMarkupEndTag(MarkupEndTagSyntax node)
    {
      var openAngle = (SyntaxToken)VisitToken(node.OpenAngle);
      var forwardSlash = (SyntaxToken)VisitToken(node.ForwardSlash);
      var bang = (SyntaxToken)VisitToken(node.Bang);
      var name = (SyntaxToken)VisitToken(node.Name);
      var miscAttributeContent = (MarkupMiscAttributeContentSyntax)Visit(node.MiscAttributeContent);
      var closeAngle = (SyntaxToken)VisitToken(node.CloseAngle);
      return node.Update(openAngle, forwardSlash, bang, name, miscAttributeContent, closeAngle);
    }

    public override SyntaxNode VisitMarkupTagHelperElement(MarkupTagHelperElementSyntax node)
    {
      var startTag = (MarkupTagHelperStartTagSyntax)Visit(node.StartTag);
      var body = VisitList(node.Body);
      var endTag = (MarkupTagHelperEndTagSyntax)Visit(node.EndTag);
      return node.Update(startTag, body, endTag);
    }

    public override SyntaxNode VisitMarkupTagHelperStartTag(MarkupTagHelperStartTagSyntax node)
    {
      var openAngle = (SyntaxToken)VisitToken(node.OpenAngle);
      var bang = (SyntaxToken)VisitToken(node.Bang);
      var name = (SyntaxToken)VisitToken(node.Name);
      var attributes = VisitList(node.Attributes);
      var forwardSlash = (SyntaxToken)VisitToken(node.ForwardSlash);
      var closeAngle = (SyntaxToken)VisitToken(node.CloseAngle);
      return node.Update(openAngle, bang, name, attributes, forwardSlash, closeAngle);
    }

    public override SyntaxNode VisitMarkupTagHelperEndTag(MarkupTagHelperEndTagSyntax node)
    {
      var openAngle = (SyntaxToken)VisitToken(node.OpenAngle);
      var forwardSlash = (SyntaxToken)VisitToken(node.ForwardSlash);
      var bang = (SyntaxToken)VisitToken(node.Bang);
      var name = (SyntaxToken)VisitToken(node.Name);
      var miscAttributeContent = (MarkupMiscAttributeContentSyntax)Visit(node.MiscAttributeContent);
      var closeAngle = (SyntaxToken)VisitToken(node.CloseAngle);
      return node.Update(openAngle, forwardSlash, bang, name, miscAttributeContent, closeAngle);
    }

    public override SyntaxNode VisitMarkupTagHelperAttribute(MarkupTagHelperAttributeSyntax node)
    {
      var namePrefix = (MarkupTextLiteralSyntax)Visit(node.NamePrefix);
      var name = (MarkupTextLiteralSyntax)Visit(node.Name);
      var nameSuffix = (MarkupTextLiteralSyntax)Visit(node.NameSuffix);
      var equalsToken = (SyntaxToken)VisitToken(node.EqualsToken);
      var valuePrefix = (MarkupTextLiteralSyntax)Visit(node.ValuePrefix);
      var value = (MarkupTagHelperAttributeValueSyntax)Visit(node.Value);
      var valueSuffix = (MarkupTextLiteralSyntax)Visit(node.ValueSuffix);
      return node.Update(namePrefix, name, nameSuffix, equalsToken, valuePrefix, value, valueSuffix);
    }

    public override SyntaxNode VisitMarkupMinimizedTagHelperAttribute(MarkupMinimizedTagHelperAttributeSyntax node)
    {
      var namePrefix = (MarkupTextLiteralSyntax)Visit(node.NamePrefix);
      var name = (MarkupTextLiteralSyntax)Visit(node.Name);
      return node.Update(namePrefix, name);
    }

    public override SyntaxNode VisitMarkupTagHelperAttributeValue(MarkupTagHelperAttributeValueSyntax node)
    {
      var children = VisitList(node.Children);
      return node.Update(children);
    }

    public override SyntaxNode VisitMarkupTagHelperDirectiveAttribute(MarkupTagHelperDirectiveAttributeSyntax node)
    {
      var namePrefix = (MarkupTextLiteralSyntax)Visit(node.NamePrefix);
      var transition = (RazorMetaCodeSyntax)Visit(node.Transition);
      var name = (MarkupTextLiteralSyntax)Visit(node.Name);
      var colon = (RazorMetaCodeSyntax)Visit(node.Colon);
      var parameterName = (MarkupTextLiteralSyntax)Visit(node.ParameterName);
      var nameSuffix = (MarkupTextLiteralSyntax)Visit(node.NameSuffix);
      var equalsToken = (SyntaxToken)VisitToken(node.EqualsToken);
      var valuePrefix = (MarkupTextLiteralSyntax)Visit(node.ValuePrefix);
      var value = (MarkupTagHelperAttributeValueSyntax)Visit(node.Value);
      var valueSuffix = (MarkupTextLiteralSyntax)Visit(node.ValueSuffix);
      return node.Update(namePrefix, transition, name, colon, parameterName, nameSuffix, equalsToken, valuePrefix, value, valueSuffix);
    }

    public override SyntaxNode VisitMarkupMinimizedTagHelperDirectiveAttribute(MarkupMinimizedTagHelperDirectiveAttributeSyntax node)
    {
      var namePrefix = (MarkupTextLiteralSyntax)Visit(node.NamePrefix);
      var transition = (RazorMetaCodeSyntax)Visit(node.Transition);
      var name = (MarkupTextLiteralSyntax)Visit(node.Name);
      var colon = (RazorMetaCodeSyntax)Visit(node.Colon);
      var parameterName = (MarkupTextLiteralSyntax)Visit(node.ParameterName);
      return node.Update(namePrefix, transition, name, colon, parameterName);
    }

    public override SyntaxNode VisitCSharpCodeBlock(CSharpCodeBlockSyntax node)
    {
      var children = VisitList(node.Children);
      return node.Update(children);
    }

    public override SyntaxNode VisitCSharpTransition(CSharpTransitionSyntax node)
    {
      var transition = (SyntaxToken)VisitToken(node.Transition);
      return node.Update(transition);
    }

    public override SyntaxNode VisitCSharpStatementLiteral(CSharpStatementLiteralSyntax node)
    {
      var literalTokens = VisitList(node.LiteralTokens);
      return node.Update(literalTokens);
    }

    public override SyntaxNode VisitCSharpExpressionLiteral(CSharpExpressionLiteralSyntax node)
    {
      var literalTokens = VisitList(node.LiteralTokens);
      return node.Update(literalTokens);
    }

    public override SyntaxNode VisitCSharpEphemeralTextLiteral(CSharpEphemeralTextLiteralSyntax node)
    {
      var literalTokens = VisitList(node.LiteralTokens);
      return node.Update(literalTokens);
    }

    public override SyntaxNode VisitCSharpTemplateBlock(CSharpTemplateBlockSyntax node)
    {
      var children = VisitList(node.Children);
      return node.Update(children);
    }

    public override SyntaxNode VisitCSharpStatement(CSharpStatementSyntax node)
    {
      var transition = (CSharpTransitionSyntax)Visit(node.Transition);
      var body = (CSharpSyntaxNode)Visit(node.Body);
      return node.Update(transition, body);
    }

    public override SyntaxNode VisitCSharpStatementBody(CSharpStatementBodySyntax node)
    {
      var openBrace = (RazorMetaCodeSyntax)Visit(node.OpenBrace);
      var cSharpCode = (CSharpCodeBlockSyntax)Visit(node.CSharpCode);
      var closeBrace = (RazorMetaCodeSyntax)Visit(node.CloseBrace);
      return node.Update(openBrace, cSharpCode, closeBrace);
    }

    public override SyntaxNode VisitCSharpExplicitExpression(CSharpExplicitExpressionSyntax node)
    {
      var transition = (CSharpTransitionSyntax)Visit(node.Transition);
      var body = (CSharpSyntaxNode)Visit(node.Body);
      return node.Update(transition, body);
    }

    public override SyntaxNode VisitCSharpExplicitExpressionBody(CSharpExplicitExpressionBodySyntax node)
    {
      var openParen = (RazorMetaCodeSyntax)Visit(node.OpenParen);
      var cSharpCode = (CSharpCodeBlockSyntax)Visit(node.CSharpCode);
      var closeParen = (RazorMetaCodeSyntax)Visit(node.CloseParen);
      return node.Update(openParen, cSharpCode, closeParen);
    }

    public override SyntaxNode VisitCSharpImplicitExpression(CSharpImplicitExpressionSyntax node)
    {
      var transition = (CSharpTransitionSyntax)Visit(node.Transition);
      var body = (CSharpSyntaxNode)Visit(node.Body);
      return node.Update(transition, body);
    }

    public override SyntaxNode VisitCSharpImplicitExpressionBody(CSharpImplicitExpressionBodySyntax node)
    {
      var cSharpCode = (CSharpCodeBlockSyntax)Visit(node.CSharpCode);
      return node.Update(cSharpCode);
    }

    public override SyntaxNode VisitRazorDirective(RazorDirectiveSyntax node)
    {
      var transition = (CSharpTransitionSyntax)Visit(node.Transition);
      var body = (CSharpSyntaxNode)Visit(node.Body);
      return node.Update(transition, body);
    }

    public override SyntaxNode VisitRazorDirectiveBody(RazorDirectiveBodySyntax node)
    {
      var keyword = (RazorSyntaxNode)Visit(node.Keyword);
      var cSharpCode = (CSharpCodeBlockSyntax)Visit(node.CSharpCode);
      return node.Update(keyword, cSharpCode);
    }
  }

  internal static partial class SyntaxFactory
  {
    /// <summary>Creates a new RazorDocumentSyntax instance.</summary>
    public static RazorDocumentSyntax RazorDocument(RazorBlockSyntax document)
    {
      if (document == null)
        throw new ArgumentNullException(nameof(document));
      return (RazorDocumentSyntax)InternalSyntax.SyntaxFactory.RazorDocument(document == null ? null : (InternalSyntax.RazorBlockSyntax)document.Green).CreateRed();
    }

    /// <summary>Creates a new RazorCommentBlockSyntax instance.</summary>
    public static RazorCommentBlockSyntax RazorCommentBlock(SyntaxToken startCommentTransition, SyntaxToken startCommentStar, SyntaxToken comment, SyntaxToken endCommentStar, SyntaxToken endCommentTransition)
    {
      switch (startCommentTransition.Kind)
      {
        case SyntaxKind.RazorCommentTransition:
          break;
        default:
          throw new ArgumentException("startCommentTransition");
      }
      switch (startCommentStar.Kind)
      {
        case SyntaxKind.RazorCommentStar:
          break;
        default:
          throw new ArgumentException("startCommentStar");
      }
      switch (comment.Kind)
      {
        case SyntaxKind.RazorCommentLiteral:
          break;
        default:
          throw new ArgumentException("comment");
      }
      switch (endCommentStar.Kind)
      {
        case SyntaxKind.RazorCommentStar:
          break;
        default:
          throw new ArgumentException("endCommentStar");
      }
      switch (endCommentTransition.Kind)
      {
        case SyntaxKind.RazorCommentTransition:
          break;
        default:
          throw new ArgumentException("endCommentTransition");
      }
      return (RazorCommentBlockSyntax)InternalSyntax.SyntaxFactory.RazorCommentBlock((Syntax.InternalSyntax.SyntaxToken)startCommentTransition.Green, (Syntax.InternalSyntax.SyntaxToken)startCommentStar.Green, (Syntax.InternalSyntax.SyntaxToken)comment.Green, (Syntax.InternalSyntax.SyntaxToken)endCommentStar.Green, (Syntax.InternalSyntax.SyntaxToken)endCommentTransition.Green).CreateRed();
    }

    /// <summary>Creates a new RazorCommentBlockSyntax instance.</summary>
    public static RazorCommentBlockSyntax RazorCommentBlock()
    {
      return SyntaxFactory.RazorCommentBlock(SyntaxFactory.Token(SyntaxKind.RazorCommentTransition), SyntaxFactory.Token(SyntaxKind.RazorCommentStar), SyntaxFactory.Token(SyntaxKind.RazorCommentLiteral), SyntaxFactory.Token(SyntaxKind.RazorCommentStar), SyntaxFactory.Token(SyntaxKind.RazorCommentTransition));
    }

    /// <summary>Creates a new RazorMetaCodeSyntax instance.</summary>
    public static RazorMetaCodeSyntax RazorMetaCode(SyntaxList<SyntaxToken> metaCode)
    {
      return (RazorMetaCodeSyntax)InternalSyntax.SyntaxFactory.RazorMetaCode(metaCode.Node.ToGreenList<InternalSyntax.SyntaxToken>()).CreateRed();
    }

    /// <summary>Creates a new RazorMetaCodeSyntax instance.</summary>
    public static RazorMetaCodeSyntax RazorMetaCode()
    {
      return SyntaxFactory.RazorMetaCode(default(SyntaxList<SyntaxToken>));
    }

    /// <summary>Creates a new GenericBlockSyntax instance.</summary>
    public static GenericBlockSyntax GenericBlock(SyntaxList<RazorSyntaxNode> children)
    {
      return (GenericBlockSyntax)InternalSyntax.SyntaxFactory.GenericBlock(children.Node.ToGreenList<InternalSyntax.RazorSyntaxNode>()).CreateRed();
    }

    /// <summary>Creates a new GenericBlockSyntax instance.</summary>
    public static GenericBlockSyntax GenericBlock()
    {
      return SyntaxFactory.GenericBlock(default(SyntaxList<RazorSyntaxNode>));
    }

    /// <summary>Creates a new UnclassifiedTextLiteralSyntax instance.</summary>
    public static UnclassifiedTextLiteralSyntax UnclassifiedTextLiteral(SyntaxList<SyntaxToken> literalTokens)
    {
      return (UnclassifiedTextLiteralSyntax)InternalSyntax.SyntaxFactory.UnclassifiedTextLiteral(literalTokens.Node.ToGreenList<InternalSyntax.SyntaxToken>()).CreateRed();
    }

    /// <summary>Creates a new UnclassifiedTextLiteralSyntax instance.</summary>
    public static UnclassifiedTextLiteralSyntax UnclassifiedTextLiteral()
    {
      return SyntaxFactory.UnclassifiedTextLiteral(default(SyntaxList<SyntaxToken>));
    }

    /// <summary>Creates a new MarkupBlockSyntax instance.</summary>
    public static MarkupBlockSyntax MarkupBlock(SyntaxList<RazorSyntaxNode> children)
    {
      return (MarkupBlockSyntax)InternalSyntax.SyntaxFactory.MarkupBlock(children.Node.ToGreenList<InternalSyntax.RazorSyntaxNode>()).CreateRed();
    }

    /// <summary>Creates a new MarkupBlockSyntax instance.</summary>
    public static MarkupBlockSyntax MarkupBlock()
    {
      return SyntaxFactory.MarkupBlock(default(SyntaxList<RazorSyntaxNode>));
    }

    /// <summary>Creates a new MarkupTransitionSyntax instance.</summary>
    public static MarkupTransitionSyntax MarkupTransition(SyntaxList<SyntaxToken> transitionTokens)
    {
      return (MarkupTransitionSyntax)InternalSyntax.SyntaxFactory.MarkupTransition(transitionTokens.Node.ToGreenList<InternalSyntax.SyntaxToken>()).CreateRed();
    }

    /// <summary>Creates a new MarkupTransitionSyntax instance.</summary>
    public static MarkupTransitionSyntax MarkupTransition()
    {
      return SyntaxFactory.MarkupTransition(default(SyntaxList<SyntaxToken>));
    }

    /// <summary>Creates a new MarkupTextLiteralSyntax instance.</summary>
    public static MarkupTextLiteralSyntax MarkupTextLiteral(SyntaxList<SyntaxToken> literalTokens)
    {
      return (MarkupTextLiteralSyntax)InternalSyntax.SyntaxFactory.MarkupTextLiteral(literalTokens.Node.ToGreenList<InternalSyntax.SyntaxToken>()).CreateRed();
    }

    /// <summary>Creates a new MarkupTextLiteralSyntax instance.</summary>
    public static MarkupTextLiteralSyntax MarkupTextLiteral()
    {
      return SyntaxFactory.MarkupTextLiteral(default(SyntaxList<SyntaxToken>));
    }

    /// <summary>Creates a new MarkupEphemeralTextLiteralSyntax instance.</summary>
    public static MarkupEphemeralTextLiteralSyntax MarkupEphemeralTextLiteral(SyntaxList<SyntaxToken> literalTokens)
    {
      return (MarkupEphemeralTextLiteralSyntax)InternalSyntax.SyntaxFactory.MarkupEphemeralTextLiteral(literalTokens.Node.ToGreenList<InternalSyntax.SyntaxToken>()).CreateRed();
    }

    /// <summary>Creates a new MarkupEphemeralTextLiteralSyntax instance.</summary>
    public static MarkupEphemeralTextLiteralSyntax MarkupEphemeralTextLiteral()
    {
      return SyntaxFactory.MarkupEphemeralTextLiteral(default(SyntaxList<SyntaxToken>));
    }

    /// <summary>Creates a new MarkupCommentBlockSyntax instance.</summary>
    public static MarkupCommentBlockSyntax MarkupCommentBlock(SyntaxList<RazorSyntaxNode> children)
    {
      return (MarkupCommentBlockSyntax)InternalSyntax.SyntaxFactory.MarkupCommentBlock(children.Node.ToGreenList<InternalSyntax.RazorSyntaxNode>()).CreateRed();
    }

    /// <summary>Creates a new MarkupCommentBlockSyntax instance.</summary>
    public static MarkupCommentBlockSyntax MarkupCommentBlock()
    {
      return SyntaxFactory.MarkupCommentBlock(default(SyntaxList<RazorSyntaxNode>));
    }

    /// <summary>Creates a new MarkupMinimizedAttributeBlockSyntax instance.</summary>
    public static MarkupMinimizedAttributeBlockSyntax MarkupMinimizedAttributeBlock(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name)
    {
      if (name == null)
        throw new ArgumentNullException(nameof(name));
      return (MarkupMinimizedAttributeBlockSyntax)InternalSyntax.SyntaxFactory.MarkupMinimizedAttributeBlock(namePrefix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)namePrefix.Green, name == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)name.Green).CreateRed();
    }

    /// <summary>Creates a new MarkupMinimizedAttributeBlockSyntax instance.</summary>
    public static MarkupMinimizedAttributeBlockSyntax MarkupMinimizedAttributeBlock()
    {
      return SyntaxFactory.MarkupMinimizedAttributeBlock(default(MarkupTextLiteralSyntax), SyntaxFactory.MarkupTextLiteral());
    }

    /// <summary>Creates a new MarkupAttributeBlockSyntax instance.</summary>
    public static MarkupAttributeBlockSyntax MarkupAttributeBlock(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, RazorBlockSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
      if (name == null)
        throw new ArgumentNullException(nameof(name));
      switch (equalsToken.Kind)
      {
        case SyntaxKind.Equals:
          break;
        default:
          throw new ArgumentException("equalsToken");
      }
      return (MarkupAttributeBlockSyntax)InternalSyntax.SyntaxFactory.MarkupAttributeBlock(namePrefix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)namePrefix.Green, name == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)name.Green, nameSuffix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)nameSuffix.Green, (Syntax.InternalSyntax.SyntaxToken)equalsToken.Green, valuePrefix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)valuePrefix.Green, value == null ? null : (InternalSyntax.RazorBlockSyntax)value.Green, valueSuffix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)valueSuffix.Green).CreateRed();
    }

    /// <summary>Creates a new MarkupAttributeBlockSyntax instance.</summary>
    public static MarkupAttributeBlockSyntax MarkupAttributeBlock(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, MarkupTextLiteralSyntax valuePrefix, RazorBlockSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
      return SyntaxFactory.MarkupAttributeBlock(namePrefix, name, nameSuffix, SyntaxFactory.Token(SyntaxKind.Equals), valuePrefix, value, valueSuffix);
    }

    /// <summary>Creates a new MarkupAttributeBlockSyntax instance.</summary>
    public static MarkupAttributeBlockSyntax MarkupAttributeBlock()
    {
      return SyntaxFactory.MarkupAttributeBlock(default(MarkupTextLiteralSyntax), SyntaxFactory.MarkupTextLiteral(), default(MarkupTextLiteralSyntax), SyntaxFactory.Token(SyntaxKind.Equals), default(MarkupTextLiteralSyntax), default(RazorBlockSyntax), default(MarkupTextLiteralSyntax));
    }

    /// <summary>Creates a new MarkupMiscAttributeContentSyntax instance.</summary>
    public static MarkupMiscAttributeContentSyntax MarkupMiscAttributeContent(SyntaxList<RazorSyntaxNode> children)
    {
      return (MarkupMiscAttributeContentSyntax)InternalSyntax.SyntaxFactory.MarkupMiscAttributeContent(children.Node.ToGreenList<InternalSyntax.RazorSyntaxNode>()).CreateRed();
    }

    /// <summary>Creates a new MarkupMiscAttributeContentSyntax instance.</summary>
    public static MarkupMiscAttributeContentSyntax MarkupMiscAttributeContent()
    {
      return SyntaxFactory.MarkupMiscAttributeContent(default(SyntaxList<RazorSyntaxNode>));
    }

    /// <summary>Creates a new MarkupLiteralAttributeValueSyntax instance.</summary>
    public static MarkupLiteralAttributeValueSyntax MarkupLiteralAttributeValue(MarkupTextLiteralSyntax prefix, MarkupTextLiteralSyntax value)
    {
      return (MarkupLiteralAttributeValueSyntax)InternalSyntax.SyntaxFactory.MarkupLiteralAttributeValue(prefix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)prefix.Green, value == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)value.Green).CreateRed();
    }

    /// <summary>Creates a new MarkupLiteralAttributeValueSyntax instance.</summary>
    public static MarkupLiteralAttributeValueSyntax MarkupLiteralAttributeValue()
    {
      return SyntaxFactory.MarkupLiteralAttributeValue(default(MarkupTextLiteralSyntax), default(MarkupTextLiteralSyntax));
    }

    /// <summary>Creates a new MarkupDynamicAttributeValueSyntax instance.</summary>
    public static MarkupDynamicAttributeValueSyntax MarkupDynamicAttributeValue(MarkupTextLiteralSyntax prefix, RazorBlockSyntax value)
    {
      if (value == null)
        throw new ArgumentNullException(nameof(value));
      return (MarkupDynamicAttributeValueSyntax)InternalSyntax.SyntaxFactory.MarkupDynamicAttributeValue(prefix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)prefix.Green, value == null ? null : (InternalSyntax.RazorBlockSyntax)value.Green).CreateRed();
    }

    /// <summary>Creates a new MarkupDynamicAttributeValueSyntax instance.</summary>
    public static MarkupDynamicAttributeValueSyntax MarkupDynamicAttributeValue(RazorBlockSyntax value)
    {
      return SyntaxFactory.MarkupDynamicAttributeValue(default(MarkupTextLiteralSyntax), value);
    }

    /// <summary>Creates a new MarkupElementSyntax instance.</summary>
    public static MarkupElementSyntax MarkupElement(MarkupStartTagSyntax startTag, SyntaxList<RazorSyntaxNode> body, MarkupEndTagSyntax endTag)
    {
      return (MarkupElementSyntax)InternalSyntax.SyntaxFactory.MarkupElement(startTag == null ? null : (InternalSyntax.MarkupStartTagSyntax)startTag.Green, body.Node.ToGreenList<InternalSyntax.RazorSyntaxNode>(), endTag == null ? null : (InternalSyntax.MarkupEndTagSyntax)endTag.Green).CreateRed();
    }

    /// <summary>Creates a new MarkupElementSyntax instance.</summary>
    public static MarkupElementSyntax MarkupElement(SyntaxList<RazorSyntaxNode> body = default(SyntaxList<RazorSyntaxNode>))
    {
      return SyntaxFactory.MarkupElement(default(MarkupStartTagSyntax), body, default(MarkupEndTagSyntax));
    }

    /// <summary>Creates a new MarkupStartTagSyntax instance.</summary>
    public static MarkupStartTagSyntax MarkupStartTag(SyntaxToken openAngle, SyntaxToken bang, SyntaxToken name, SyntaxList<RazorSyntaxNode> attributes, SyntaxToken forwardSlash, SyntaxToken closeAngle)
    {
      switch (openAngle.Kind)
      {
        case SyntaxKind.OpenAngle:
          break;
        default:
          throw new ArgumentException("openAngle");
      }
      if (bang != null)
      {
      switch (bang.Kind)
      {
        case SyntaxKind.Bang:
        case SyntaxKind.None:
          break;
        default:
          throw new ArgumentException("bang");
      }
      }
      switch (name.Kind)
      {
        case SyntaxKind.Text:
          break;
        default:
          throw new ArgumentException("name");
      }
      if (forwardSlash != null)
      {
      switch (forwardSlash.Kind)
      {
        case SyntaxKind.ForwardSlash:
        case SyntaxKind.None:
          break;
        default:
          throw new ArgumentException("forwardSlash");
      }
      }
      switch (closeAngle.Kind)
      {
        case SyntaxKind.CloseAngle:
          break;
        default:
          throw new ArgumentException("closeAngle");
      }
      return (MarkupStartTagSyntax)InternalSyntax.SyntaxFactory.MarkupStartTag((Syntax.InternalSyntax.SyntaxToken)openAngle.Green, (Syntax.InternalSyntax.SyntaxToken)bang?.Green, (Syntax.InternalSyntax.SyntaxToken)name.Green, attributes.Node.ToGreenList<InternalSyntax.RazorSyntaxNode>(), (Syntax.InternalSyntax.SyntaxToken)forwardSlash?.Green, (Syntax.InternalSyntax.SyntaxToken)closeAngle.Green).CreateRed();
    }

    /// <summary>Creates a new MarkupStartTagSyntax instance.</summary>
    public static MarkupStartTagSyntax MarkupStartTag(SyntaxList<RazorSyntaxNode> attributes = default(SyntaxList<RazorSyntaxNode>))
    {
      return SyntaxFactory.MarkupStartTag(SyntaxFactory.Token(SyntaxKind.OpenAngle), default(SyntaxToken), SyntaxFactory.Token(SyntaxKind.Text), attributes, default(SyntaxToken), SyntaxFactory.Token(SyntaxKind.CloseAngle));
    }

    /// <summary>Creates a new MarkupEndTagSyntax instance.</summary>
    public static MarkupEndTagSyntax MarkupEndTag(SyntaxToken openAngle, SyntaxToken forwardSlash, SyntaxToken bang, SyntaxToken name, MarkupMiscAttributeContentSyntax miscAttributeContent, SyntaxToken closeAngle)
    {
      switch (openAngle.Kind)
      {
        case SyntaxKind.OpenAngle:
          break;
        default:
          throw new ArgumentException("openAngle");
      }
      switch (forwardSlash.Kind)
      {
        case SyntaxKind.ForwardSlash:
          break;
        default:
          throw new ArgumentException("forwardSlash");
      }
      if (bang != null)
      {
      switch (bang.Kind)
      {
        case SyntaxKind.Bang:
        case SyntaxKind.None:
          break;
        default:
          throw new ArgumentException("bang");
      }
      }
      switch (name.Kind)
      {
        case SyntaxKind.Text:
          break;
        default:
          throw new ArgumentException("name");
      }
      switch (closeAngle.Kind)
      {
        case SyntaxKind.CloseAngle:
          break;
        default:
          throw new ArgumentException("closeAngle");
      }
      return (MarkupEndTagSyntax)InternalSyntax.SyntaxFactory.MarkupEndTag((Syntax.InternalSyntax.SyntaxToken)openAngle.Green, (Syntax.InternalSyntax.SyntaxToken)forwardSlash.Green, (Syntax.InternalSyntax.SyntaxToken)bang?.Green, (Syntax.InternalSyntax.SyntaxToken)name.Green, miscAttributeContent == null ? null : (InternalSyntax.MarkupMiscAttributeContentSyntax)miscAttributeContent.Green, (Syntax.InternalSyntax.SyntaxToken)closeAngle.Green).CreateRed();
    }

    /// <summary>Creates a new MarkupEndTagSyntax instance.</summary>
    public static MarkupEndTagSyntax MarkupEndTag(MarkupMiscAttributeContentSyntax miscAttributeContent = default(MarkupMiscAttributeContentSyntax))
    {
      return SyntaxFactory.MarkupEndTag(SyntaxFactory.Token(SyntaxKind.OpenAngle), SyntaxFactory.Token(SyntaxKind.ForwardSlash), default(SyntaxToken), SyntaxFactory.Token(SyntaxKind.Text), miscAttributeContent, SyntaxFactory.Token(SyntaxKind.CloseAngle));
    }

    /// <summary>Creates a new MarkupTagHelperElementSyntax instance.</summary>
    public static MarkupTagHelperElementSyntax MarkupTagHelperElement(MarkupTagHelperStartTagSyntax startTag, SyntaxList<RazorSyntaxNode> body, MarkupTagHelperEndTagSyntax endTag)
    {
      if (startTag == null)
        throw new ArgumentNullException(nameof(startTag));
      return (MarkupTagHelperElementSyntax)InternalSyntax.SyntaxFactory.MarkupTagHelperElement(startTag == null ? null : (InternalSyntax.MarkupTagHelperStartTagSyntax)startTag.Green, body.Node.ToGreenList<InternalSyntax.RazorSyntaxNode>(), endTag == null ? null : (InternalSyntax.MarkupTagHelperEndTagSyntax)endTag.Green).CreateRed();
    }

    /// <summary>Creates a new MarkupTagHelperElementSyntax instance.</summary>
    public static MarkupTagHelperElementSyntax MarkupTagHelperElement(SyntaxList<RazorSyntaxNode> body = default(SyntaxList<RazorSyntaxNode>))
    {
      return SyntaxFactory.MarkupTagHelperElement(SyntaxFactory.MarkupTagHelperStartTag(), body, default(MarkupTagHelperEndTagSyntax));
    }

    /// <summary>Creates a new MarkupTagHelperStartTagSyntax instance.</summary>
    public static MarkupTagHelperStartTagSyntax MarkupTagHelperStartTag(SyntaxToken openAngle, SyntaxToken bang, SyntaxToken name, SyntaxList<RazorSyntaxNode> attributes, SyntaxToken forwardSlash, SyntaxToken closeAngle)
    {
      switch (openAngle.Kind)
      {
        case SyntaxKind.OpenAngle:
          break;
        default:
          throw new ArgumentException("openAngle");
      }
      if (bang != null)
      {
      switch (bang.Kind)
      {
        case SyntaxKind.Bang:
        case SyntaxKind.None:
          break;
        default:
          throw new ArgumentException("bang");
      }
      }
      switch (name.Kind)
      {
        case SyntaxKind.Text:
          break;
        default:
          throw new ArgumentException("name");
      }
      if (forwardSlash != null)
      {
      switch (forwardSlash.Kind)
      {
        case SyntaxKind.ForwardSlash:
        case SyntaxKind.None:
          break;
        default:
          throw new ArgumentException("forwardSlash");
      }
      }
      switch (closeAngle.Kind)
      {
        case SyntaxKind.CloseAngle:
          break;
        default:
          throw new ArgumentException("closeAngle");
      }
      return (MarkupTagHelperStartTagSyntax)InternalSyntax.SyntaxFactory.MarkupTagHelperStartTag((Syntax.InternalSyntax.SyntaxToken)openAngle.Green, (Syntax.InternalSyntax.SyntaxToken)bang?.Green, (Syntax.InternalSyntax.SyntaxToken)name.Green, attributes.Node.ToGreenList<InternalSyntax.RazorSyntaxNode>(), (Syntax.InternalSyntax.SyntaxToken)forwardSlash?.Green, (Syntax.InternalSyntax.SyntaxToken)closeAngle.Green).CreateRed();
    }

    /// <summary>Creates a new MarkupTagHelperStartTagSyntax instance.</summary>
    public static MarkupTagHelperStartTagSyntax MarkupTagHelperStartTag(SyntaxList<RazorSyntaxNode> attributes = default(SyntaxList<RazorSyntaxNode>))
    {
      return SyntaxFactory.MarkupTagHelperStartTag(SyntaxFactory.Token(SyntaxKind.OpenAngle), default(SyntaxToken), SyntaxFactory.Token(SyntaxKind.Text), attributes, default(SyntaxToken), SyntaxFactory.Token(SyntaxKind.CloseAngle));
    }

    /// <summary>Creates a new MarkupTagHelperEndTagSyntax instance.</summary>
    public static MarkupTagHelperEndTagSyntax MarkupTagHelperEndTag(SyntaxToken openAngle, SyntaxToken forwardSlash, SyntaxToken bang, SyntaxToken name, MarkupMiscAttributeContentSyntax miscAttributeContent, SyntaxToken closeAngle)
    {
      switch (openAngle.Kind)
      {
        case SyntaxKind.OpenAngle:
          break;
        default:
          throw new ArgumentException("openAngle");
      }
      switch (forwardSlash.Kind)
      {
        case SyntaxKind.ForwardSlash:
          break;
        default:
          throw new ArgumentException("forwardSlash");
      }
      if (bang != null)
      {
      switch (bang.Kind)
      {
        case SyntaxKind.Bang:
        case SyntaxKind.None:
          break;
        default:
          throw new ArgumentException("bang");
      }
      }
      switch (name.Kind)
      {
        case SyntaxKind.Text:
          break;
        default:
          throw new ArgumentException("name");
      }
      switch (closeAngle.Kind)
      {
        case SyntaxKind.CloseAngle:
          break;
        default:
          throw new ArgumentException("closeAngle");
      }
      return (MarkupTagHelperEndTagSyntax)InternalSyntax.SyntaxFactory.MarkupTagHelperEndTag((Syntax.InternalSyntax.SyntaxToken)openAngle.Green, (Syntax.InternalSyntax.SyntaxToken)forwardSlash.Green, (Syntax.InternalSyntax.SyntaxToken)bang?.Green, (Syntax.InternalSyntax.SyntaxToken)name.Green, miscAttributeContent == null ? null : (InternalSyntax.MarkupMiscAttributeContentSyntax)miscAttributeContent.Green, (Syntax.InternalSyntax.SyntaxToken)closeAngle.Green).CreateRed();
    }

    /// <summary>Creates a new MarkupTagHelperEndTagSyntax instance.</summary>
    public static MarkupTagHelperEndTagSyntax MarkupTagHelperEndTag(MarkupMiscAttributeContentSyntax miscAttributeContent = default(MarkupMiscAttributeContentSyntax))
    {
      return SyntaxFactory.MarkupTagHelperEndTag(SyntaxFactory.Token(SyntaxKind.OpenAngle), SyntaxFactory.Token(SyntaxKind.ForwardSlash), default(SyntaxToken), SyntaxFactory.Token(SyntaxKind.Text), miscAttributeContent, SyntaxFactory.Token(SyntaxKind.CloseAngle));
    }

    /// <summary>Creates a new MarkupTagHelperAttributeSyntax instance.</summary>
    public static MarkupTagHelperAttributeSyntax MarkupTagHelperAttribute(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
      if (name == null)
        throw new ArgumentNullException(nameof(name));
      switch (equalsToken.Kind)
      {
        case SyntaxKind.Equals:
          break;
        default:
          throw new ArgumentException("equalsToken");
      }
      if (value == null)
        throw new ArgumentNullException(nameof(value));
      return (MarkupTagHelperAttributeSyntax)InternalSyntax.SyntaxFactory.MarkupTagHelperAttribute(namePrefix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)namePrefix.Green, name == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)name.Green, nameSuffix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)nameSuffix.Green, (Syntax.InternalSyntax.SyntaxToken)equalsToken.Green, valuePrefix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)valuePrefix.Green, value == null ? null : (InternalSyntax.MarkupTagHelperAttributeValueSyntax)value.Green, valueSuffix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)valueSuffix.Green).CreateRed();
    }

    /// <summary>Creates a new MarkupTagHelperAttributeSyntax instance.</summary>
    public static MarkupTagHelperAttributeSyntax MarkupTagHelperAttribute(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
      return SyntaxFactory.MarkupTagHelperAttribute(namePrefix, name, nameSuffix, SyntaxFactory.Token(SyntaxKind.Equals), valuePrefix, value, valueSuffix);
    }

    /// <summary>Creates a new MarkupTagHelperAttributeSyntax instance.</summary>
    public static MarkupTagHelperAttributeSyntax MarkupTagHelperAttribute()
    {
      return SyntaxFactory.MarkupTagHelperAttribute(default(MarkupTextLiteralSyntax), SyntaxFactory.MarkupTextLiteral(), default(MarkupTextLiteralSyntax), SyntaxFactory.Token(SyntaxKind.Equals), default(MarkupTextLiteralSyntax), SyntaxFactory.MarkupTagHelperAttributeValue(), default(MarkupTextLiteralSyntax));
    }

    /// <summary>Creates a new MarkupMinimizedTagHelperAttributeSyntax instance.</summary>
    public static MarkupMinimizedTagHelperAttributeSyntax MarkupMinimizedTagHelperAttribute(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name)
    {
      if (name == null)
        throw new ArgumentNullException(nameof(name));
      return (MarkupMinimizedTagHelperAttributeSyntax)InternalSyntax.SyntaxFactory.MarkupMinimizedTagHelperAttribute(namePrefix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)namePrefix.Green, name == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)name.Green).CreateRed();
    }

    /// <summary>Creates a new MarkupMinimizedTagHelperAttributeSyntax instance.</summary>
    public static MarkupMinimizedTagHelperAttributeSyntax MarkupMinimizedTagHelperAttribute()
    {
      return SyntaxFactory.MarkupMinimizedTagHelperAttribute(default(MarkupTextLiteralSyntax), SyntaxFactory.MarkupTextLiteral());
    }

    /// <summary>Creates a new MarkupTagHelperAttributeValueSyntax instance.</summary>
    public static MarkupTagHelperAttributeValueSyntax MarkupTagHelperAttributeValue(SyntaxList<RazorSyntaxNode> children)
    {
      return (MarkupTagHelperAttributeValueSyntax)InternalSyntax.SyntaxFactory.MarkupTagHelperAttributeValue(children.Node.ToGreenList<InternalSyntax.RazorSyntaxNode>()).CreateRed();
    }

    /// <summary>Creates a new MarkupTagHelperAttributeValueSyntax instance.</summary>
    public static MarkupTagHelperAttributeValueSyntax MarkupTagHelperAttributeValue()
    {
      return SyntaxFactory.MarkupTagHelperAttributeValue(default(SyntaxList<RazorSyntaxNode>));
    }

    /// <summary>Creates a new MarkupTagHelperDirectiveAttributeSyntax instance.</summary>
    public static MarkupTagHelperDirectiveAttributeSyntax MarkupTagHelperDirectiveAttribute(MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
      if (transition == null)
        throw new ArgumentNullException(nameof(transition));
      if (name == null)
        throw new ArgumentNullException(nameof(name));
      switch (equalsToken.Kind)
      {
        case SyntaxKind.Equals:
          break;
        default:
          throw new ArgumentException("equalsToken");
      }
      if (value == null)
        throw new ArgumentNullException(nameof(value));
      return (MarkupTagHelperDirectiveAttributeSyntax)InternalSyntax.SyntaxFactory.MarkupTagHelperDirectiveAttribute(namePrefix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)namePrefix.Green, transition == null ? null : (InternalSyntax.RazorMetaCodeSyntax)transition.Green, name == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)name.Green, colon == null ? null : (InternalSyntax.RazorMetaCodeSyntax)colon.Green, parameterName == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)parameterName.Green, nameSuffix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)nameSuffix.Green, (Syntax.InternalSyntax.SyntaxToken)equalsToken.Green, valuePrefix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)valuePrefix.Green, value == null ? null : (InternalSyntax.MarkupTagHelperAttributeValueSyntax)value.Green, valueSuffix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)valueSuffix.Green).CreateRed();
    }

    /// <summary>Creates a new MarkupTagHelperDirectiveAttributeSyntax instance.</summary>
    public static MarkupTagHelperDirectiveAttributeSyntax MarkupTagHelperDirectiveAttribute(MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName, MarkupTextLiteralSyntax nameSuffix, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
      return SyntaxFactory.MarkupTagHelperDirectiveAttribute(namePrefix, transition, name, colon, parameterName, nameSuffix, SyntaxFactory.Token(SyntaxKind.Equals), valuePrefix, value, valueSuffix);
    }

    /// <summary>Creates a new MarkupTagHelperDirectiveAttributeSyntax instance.</summary>
    public static MarkupTagHelperDirectiveAttributeSyntax MarkupTagHelperDirectiveAttribute()
    {
      return SyntaxFactory.MarkupTagHelperDirectiveAttribute(default(MarkupTextLiteralSyntax), SyntaxFactory.RazorMetaCode(), SyntaxFactory.MarkupTextLiteral(), default(RazorMetaCodeSyntax), default(MarkupTextLiteralSyntax), default(MarkupTextLiteralSyntax), SyntaxFactory.Token(SyntaxKind.Equals), default(MarkupTextLiteralSyntax), SyntaxFactory.MarkupTagHelperAttributeValue(), default(MarkupTextLiteralSyntax));
    }

    /// <summary>Creates a new MarkupMinimizedTagHelperDirectiveAttributeSyntax instance.</summary>
    public static MarkupMinimizedTagHelperDirectiveAttributeSyntax MarkupMinimizedTagHelperDirectiveAttribute(MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName)
    {
      if (transition == null)
        throw new ArgumentNullException(nameof(transition));
      if (name == null)
        throw new ArgumentNullException(nameof(name));
      return (MarkupMinimizedTagHelperDirectiveAttributeSyntax)InternalSyntax.SyntaxFactory.MarkupMinimizedTagHelperDirectiveAttribute(namePrefix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)namePrefix.Green, transition == null ? null : (InternalSyntax.RazorMetaCodeSyntax)transition.Green, name == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)name.Green, colon == null ? null : (InternalSyntax.RazorMetaCodeSyntax)colon.Green, parameterName == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)parameterName.Green).CreateRed();
    }

    /// <summary>Creates a new MarkupMinimizedTagHelperDirectiveAttributeSyntax instance.</summary>
    public static MarkupMinimizedTagHelperDirectiveAttributeSyntax MarkupMinimizedTagHelperDirectiveAttribute()
    {
      return SyntaxFactory.MarkupMinimizedTagHelperDirectiveAttribute(default(MarkupTextLiteralSyntax), SyntaxFactory.RazorMetaCode(), SyntaxFactory.MarkupTextLiteral(), default(RazorMetaCodeSyntax), default(MarkupTextLiteralSyntax));
    }

    /// <summary>Creates a new CSharpCodeBlockSyntax instance.</summary>
    public static CSharpCodeBlockSyntax CSharpCodeBlock(SyntaxList<RazorSyntaxNode> children)
    {
      return (CSharpCodeBlockSyntax)InternalSyntax.SyntaxFactory.CSharpCodeBlock(children.Node.ToGreenList<InternalSyntax.RazorSyntaxNode>()).CreateRed();
    }

    /// <summary>Creates a new CSharpCodeBlockSyntax instance.</summary>
    public static CSharpCodeBlockSyntax CSharpCodeBlock()
    {
      return SyntaxFactory.CSharpCodeBlock(default(SyntaxList<RazorSyntaxNode>));
    }

    /// <summary>Creates a new CSharpTransitionSyntax instance.</summary>
    public static CSharpTransitionSyntax CSharpTransition(SyntaxToken transition)
    {
      switch (transition.Kind)
      {
        case SyntaxKind.Transition:
          break;
        default:
          throw new ArgumentException("transition");
      }
      return (CSharpTransitionSyntax)InternalSyntax.SyntaxFactory.CSharpTransition((Syntax.InternalSyntax.SyntaxToken)transition.Green).CreateRed();
    }

    /// <summary>Creates a new CSharpTransitionSyntax instance.</summary>
    public static CSharpTransitionSyntax CSharpTransition()
    {
      return SyntaxFactory.CSharpTransition(SyntaxFactory.Token(SyntaxKind.Transition));
    }

    /// <summary>Creates a new CSharpStatementLiteralSyntax instance.</summary>
    public static CSharpStatementLiteralSyntax CSharpStatementLiteral(SyntaxList<SyntaxToken> literalTokens)
    {
      return (CSharpStatementLiteralSyntax)InternalSyntax.SyntaxFactory.CSharpStatementLiteral(literalTokens.Node.ToGreenList<InternalSyntax.SyntaxToken>()).CreateRed();
    }

    /// <summary>Creates a new CSharpStatementLiteralSyntax instance.</summary>
    public static CSharpStatementLiteralSyntax CSharpStatementLiteral()
    {
      return SyntaxFactory.CSharpStatementLiteral(default(SyntaxList<SyntaxToken>));
    }

    /// <summary>Creates a new CSharpExpressionLiteralSyntax instance.</summary>
    public static CSharpExpressionLiteralSyntax CSharpExpressionLiteral(SyntaxList<SyntaxToken> literalTokens)
    {
      return (CSharpExpressionLiteralSyntax)InternalSyntax.SyntaxFactory.CSharpExpressionLiteral(literalTokens.Node.ToGreenList<InternalSyntax.SyntaxToken>()).CreateRed();
    }

    /// <summary>Creates a new CSharpExpressionLiteralSyntax instance.</summary>
    public static CSharpExpressionLiteralSyntax CSharpExpressionLiteral()
    {
      return SyntaxFactory.CSharpExpressionLiteral(default(SyntaxList<SyntaxToken>));
    }

    /// <summary>Creates a new CSharpEphemeralTextLiteralSyntax instance.</summary>
    public static CSharpEphemeralTextLiteralSyntax CSharpEphemeralTextLiteral(SyntaxList<SyntaxToken> literalTokens)
    {
      return (CSharpEphemeralTextLiteralSyntax)InternalSyntax.SyntaxFactory.CSharpEphemeralTextLiteral(literalTokens.Node.ToGreenList<InternalSyntax.SyntaxToken>()).CreateRed();
    }

    /// <summary>Creates a new CSharpEphemeralTextLiteralSyntax instance.</summary>
    public static CSharpEphemeralTextLiteralSyntax CSharpEphemeralTextLiteral()
    {
      return SyntaxFactory.CSharpEphemeralTextLiteral(default(SyntaxList<SyntaxToken>));
    }

    /// <summary>Creates a new CSharpTemplateBlockSyntax instance.</summary>
    public static CSharpTemplateBlockSyntax CSharpTemplateBlock(SyntaxList<RazorSyntaxNode> children)
    {
      return (CSharpTemplateBlockSyntax)InternalSyntax.SyntaxFactory.CSharpTemplateBlock(children.Node.ToGreenList<InternalSyntax.RazorSyntaxNode>()).CreateRed();
    }

    /// <summary>Creates a new CSharpTemplateBlockSyntax instance.</summary>
    public static CSharpTemplateBlockSyntax CSharpTemplateBlock()
    {
      return SyntaxFactory.CSharpTemplateBlock(default(SyntaxList<RazorSyntaxNode>));
    }

    /// <summary>Creates a new CSharpStatementSyntax instance.</summary>
    public static CSharpStatementSyntax CSharpStatement(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
      if (transition == null)
        throw new ArgumentNullException(nameof(transition));
      if (body == null)
        throw new ArgumentNullException(nameof(body));
      return (CSharpStatementSyntax)InternalSyntax.SyntaxFactory.CSharpStatement(transition == null ? null : (InternalSyntax.CSharpTransitionSyntax)transition.Green, body == null ? null : (InternalSyntax.CSharpSyntaxNode)body.Green).CreateRed();
    }

    /// <summary>Creates a new CSharpStatementSyntax instance.</summary>
    public static CSharpStatementSyntax CSharpStatement(CSharpSyntaxNode body)
    {
      return SyntaxFactory.CSharpStatement(SyntaxFactory.CSharpTransition(), body);
    }

    /// <summary>Creates a new CSharpStatementBodySyntax instance.</summary>
    public static CSharpStatementBodySyntax CSharpStatementBody(RazorMetaCodeSyntax openBrace, CSharpCodeBlockSyntax cSharpCode, RazorMetaCodeSyntax closeBrace)
    {
      if (openBrace == null)
        throw new ArgumentNullException(nameof(openBrace));
      if (cSharpCode == null)
        throw new ArgumentNullException(nameof(cSharpCode));
      if (closeBrace == null)
        throw new ArgumentNullException(nameof(closeBrace));
      return (CSharpStatementBodySyntax)InternalSyntax.SyntaxFactory.CSharpStatementBody(openBrace == null ? null : (InternalSyntax.RazorMetaCodeSyntax)openBrace.Green, cSharpCode == null ? null : (InternalSyntax.CSharpCodeBlockSyntax)cSharpCode.Green, closeBrace == null ? null : (InternalSyntax.RazorMetaCodeSyntax)closeBrace.Green).CreateRed();
    }

    /// <summary>Creates a new CSharpStatementBodySyntax instance.</summary>
    public static CSharpStatementBodySyntax CSharpStatementBody()
    {
      return SyntaxFactory.CSharpStatementBody(SyntaxFactory.RazorMetaCode(), SyntaxFactory.CSharpCodeBlock(), SyntaxFactory.RazorMetaCode());
    }

    /// <summary>Creates a new CSharpExplicitExpressionSyntax instance.</summary>
    public static CSharpExplicitExpressionSyntax CSharpExplicitExpression(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
      if (transition == null)
        throw new ArgumentNullException(nameof(transition));
      if (body == null)
        throw new ArgumentNullException(nameof(body));
      return (CSharpExplicitExpressionSyntax)InternalSyntax.SyntaxFactory.CSharpExplicitExpression(transition == null ? null : (InternalSyntax.CSharpTransitionSyntax)transition.Green, body == null ? null : (InternalSyntax.CSharpSyntaxNode)body.Green).CreateRed();
    }

    /// <summary>Creates a new CSharpExplicitExpressionSyntax instance.</summary>
    public static CSharpExplicitExpressionSyntax CSharpExplicitExpression(CSharpSyntaxNode body)
    {
      return SyntaxFactory.CSharpExplicitExpression(SyntaxFactory.CSharpTransition(), body);
    }

    /// <summary>Creates a new CSharpExplicitExpressionBodySyntax instance.</summary>
    public static CSharpExplicitExpressionBodySyntax CSharpExplicitExpressionBody(RazorMetaCodeSyntax openParen, CSharpCodeBlockSyntax cSharpCode, RazorMetaCodeSyntax closeParen)
    {
      if (openParen == null)
        throw new ArgumentNullException(nameof(openParen));
      if (cSharpCode == null)
        throw new ArgumentNullException(nameof(cSharpCode));
      if (closeParen == null)
        throw new ArgumentNullException(nameof(closeParen));
      return (CSharpExplicitExpressionBodySyntax)InternalSyntax.SyntaxFactory.CSharpExplicitExpressionBody(openParen == null ? null : (InternalSyntax.RazorMetaCodeSyntax)openParen.Green, cSharpCode == null ? null : (InternalSyntax.CSharpCodeBlockSyntax)cSharpCode.Green, closeParen == null ? null : (InternalSyntax.RazorMetaCodeSyntax)closeParen.Green).CreateRed();
    }

    /// <summary>Creates a new CSharpExplicitExpressionBodySyntax instance.</summary>
    public static CSharpExplicitExpressionBodySyntax CSharpExplicitExpressionBody()
    {
      return SyntaxFactory.CSharpExplicitExpressionBody(SyntaxFactory.RazorMetaCode(), SyntaxFactory.CSharpCodeBlock(), SyntaxFactory.RazorMetaCode());
    }

    /// <summary>Creates a new CSharpImplicitExpressionSyntax instance.</summary>
    public static CSharpImplicitExpressionSyntax CSharpImplicitExpression(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
      if (transition == null)
        throw new ArgumentNullException(nameof(transition));
      if (body == null)
        throw new ArgumentNullException(nameof(body));
      return (CSharpImplicitExpressionSyntax)InternalSyntax.SyntaxFactory.CSharpImplicitExpression(transition == null ? null : (InternalSyntax.CSharpTransitionSyntax)transition.Green, body == null ? null : (InternalSyntax.CSharpSyntaxNode)body.Green).CreateRed();
    }

    /// <summary>Creates a new CSharpImplicitExpressionSyntax instance.</summary>
    public static CSharpImplicitExpressionSyntax CSharpImplicitExpression(CSharpSyntaxNode body)
    {
      return SyntaxFactory.CSharpImplicitExpression(SyntaxFactory.CSharpTransition(), body);
    }

    /// <summary>Creates a new CSharpImplicitExpressionBodySyntax instance.</summary>
    public static CSharpImplicitExpressionBodySyntax CSharpImplicitExpressionBody(CSharpCodeBlockSyntax cSharpCode)
    {
      if (cSharpCode == null)
        throw new ArgumentNullException(nameof(cSharpCode));
      return (CSharpImplicitExpressionBodySyntax)InternalSyntax.SyntaxFactory.CSharpImplicitExpressionBody(cSharpCode == null ? null : (InternalSyntax.CSharpCodeBlockSyntax)cSharpCode.Green).CreateRed();
    }

    /// <summary>Creates a new CSharpImplicitExpressionBodySyntax instance.</summary>
    public static CSharpImplicitExpressionBodySyntax CSharpImplicitExpressionBody()
    {
      return SyntaxFactory.CSharpImplicitExpressionBody(SyntaxFactory.CSharpCodeBlock());
    }

    /// <summary>Creates a new RazorDirectiveSyntax instance.</summary>
    public static RazorDirectiveSyntax RazorDirective(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
      if (transition == null)
        throw new ArgumentNullException(nameof(transition));
      if (body == null)
        throw new ArgumentNullException(nameof(body));
      return (RazorDirectiveSyntax)InternalSyntax.SyntaxFactory.RazorDirective(transition == null ? null : (InternalSyntax.CSharpTransitionSyntax)transition.Green, body == null ? null : (InternalSyntax.CSharpSyntaxNode)body.Green).CreateRed();
    }

    /// <summary>Creates a new RazorDirectiveSyntax instance.</summary>
    public static RazorDirectiveSyntax RazorDirective(CSharpSyntaxNode body)
    {
      return SyntaxFactory.RazorDirective(SyntaxFactory.CSharpTransition(), body);
    }

    /// <summary>Creates a new RazorDirectiveBodySyntax instance.</summary>
    public static RazorDirectiveBodySyntax RazorDirectiveBody(RazorSyntaxNode keyword, CSharpCodeBlockSyntax cSharpCode)
    {
      if (keyword == null)
        throw new ArgumentNullException(nameof(keyword));
      return (RazorDirectiveBodySyntax)InternalSyntax.SyntaxFactory.RazorDirectiveBody(keyword == null ? null : (InternalSyntax.RazorSyntaxNode)keyword.Green, cSharpCode == null ? null : (InternalSyntax.CSharpCodeBlockSyntax)cSharpCode.Green).CreateRed();
    }

    /// <summary>Creates a new RazorDirectiveBodySyntax instance.</summary>
    public static RazorDirectiveBodySyntax RazorDirectiveBody(RazorSyntaxNode keyword)
    {
      return SyntaxFactory.RazorDirectiveBody(keyword, default(CSharpCodeBlockSyntax));
    }
  }
}
