/* simple-query.c generated by valac 0.28.0.16-b1323, the Vala compiler
 * generated from simple-query.vala, do not modify */

/*
 * Copyright (C) 2011, 2015 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <gee.h>


#define FOLKS_TYPE_QUERY (folks_query_get_type ())
#define FOLKS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_QUERY, FolksQuery))
#define FOLKS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_QUERY, FolksQueryClass))
#define FOLKS_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_QUERY))
#define FOLKS_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_QUERY))
#define FOLKS_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_QUERY, FolksQueryClass))

typedef struct _FolksQuery FolksQuery;
typedef struct _FolksQueryClass FolksQueryClass;
typedef struct _FolksQueryPrivate FolksQueryPrivate;

#define FOLKS_TYPE_INDIVIDUAL (folks_individual_get_type ())
#define FOLKS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividual))
#define FOLKS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))
#define FOLKS_IS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_IS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_INDIVIDUAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))

typedef struct _FolksIndividual FolksIndividual;
typedef struct _FolksIndividualClass FolksIndividualClass;

#define FOLKS_TYPE_SIMPLE_QUERY (folks_simple_query_get_type ())
#define FOLKS_SIMPLE_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_SIMPLE_QUERY, FolksSimpleQuery))
#define FOLKS_SIMPLE_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_SIMPLE_QUERY, FolksSimpleQueryClass))
#define FOLKS_IS_SIMPLE_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_SIMPLE_QUERY))
#define FOLKS_IS_SIMPLE_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_SIMPLE_QUERY))
#define FOLKS_SIMPLE_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_SIMPLE_QUERY, FolksSimpleQueryClass))

typedef struct _FolksSimpleQuery FolksSimpleQuery;
typedef struct _FolksSimpleQueryClass FolksSimpleQueryClass;
typedef struct _FolksSimpleQueryPrivate FolksSimpleQueryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_param_spec_unref0(var) ((var == NULL) ? NULL : (var = (g_param_spec_unref (var), NULL)))

#define FOLKS_TYPE_STRUCTURED_NAME (folks_structured_name_get_type ())
#define FOLKS_STRUCTURED_NAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName))
#define FOLKS_STRUCTURED_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredNameClass))
#define FOLKS_IS_STRUCTURED_NAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_STRUCTURED_NAME))
#define FOLKS_IS_STRUCTURED_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_STRUCTURED_NAME))
#define FOLKS_STRUCTURED_NAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredNameClass))

typedef struct _FolksStructuredName FolksStructuredName;
typedef struct _FolksStructuredNameClass FolksStructuredNameClass;

#define FOLKS_TYPE_ABSTRACT_FIELD_DETAILS (folks_abstract_field_details_get_type ())
#define FOLKS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails))
#define FOLKS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))

typedef struct _FolksAbstractFieldDetails FolksAbstractFieldDetails;
typedef struct _FolksAbstractFieldDetailsClass FolksAbstractFieldDetailsClass;

#define FOLKS_TYPE_ROLE (folks_role_get_type ())
#define FOLKS_ROLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ROLE, FolksRole))
#define FOLKS_ROLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_ROLE, FolksRoleClass))
#define FOLKS_IS_ROLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ROLE))
#define FOLKS_IS_ROLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_ROLE))
#define FOLKS_ROLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_ROLE, FolksRoleClass))

typedef struct _FolksRole FolksRole;
typedef struct _FolksRoleClass FolksRoleClass;

#define FOLKS_TYPE_POSTAL_ADDRESS (folks_postal_address_get_type ())
#define FOLKS_POSTAL_ADDRESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddress))
#define FOLKS_POSTAL_ADDRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddressClass))
#define FOLKS_IS_POSTAL_ADDRESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_POSTAL_ADDRESS))
#define FOLKS_IS_POSTAL_ADDRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_POSTAL_ADDRESS))
#define FOLKS_POSTAL_ADDRESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddressClass))

typedef struct _FolksPostalAddress FolksPostalAddress;
typedef struct _FolksPostalAddressClass FolksPostalAddressClass;

#define FOLKS_TYPE_PHONE_FIELD_DETAILS (folks_phone_field_details_get_type ())
#define FOLKS_PHONE_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PHONE_FIELD_DETAILS, FolksPhoneFieldDetails))
#define FOLKS_PHONE_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PHONE_FIELD_DETAILS, FolksPhoneFieldDetailsClass))
#define FOLKS_IS_PHONE_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PHONE_FIELD_DETAILS))
#define FOLKS_IS_PHONE_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PHONE_FIELD_DETAILS))
#define FOLKS_PHONE_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PHONE_FIELD_DETAILS, FolksPhoneFieldDetailsClass))

typedef struct _FolksPhoneFieldDetails FolksPhoneFieldDetails;
typedef struct _FolksPhoneFieldDetailsClass FolksPhoneFieldDetailsClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FolksQuery {
	GObject parent_instance;
	FolksQueryPrivate * priv;
};

struct _FolksQueryClass {
	GObjectClass parent_class;
	guint (*is_match) (FolksQuery* self, FolksIndividual* individual);
	gchar** (*get_match_fields) (FolksQuery* self, int* result_length1);
	void (*set_match_fields) (FolksQuery* self, gchar** value, int value_length1);
};

struct _FolksSimpleQuery {
	FolksQuery parent_instance;
	FolksSimpleQueryPrivate * priv;
};

struct _FolksSimpleQueryClass {
	FolksQueryClass parent_class;
};

struct _FolksSimpleQueryPrivate {
	gchar* _query_string;
	gchar** _query_tokens;
	gint _query_tokens_length1;
	gint __query_tokens_size_;
	gchar* _query_locale;
};


static gpointer folks_simple_query_parent_class = NULL;

GType folks_query_get_type (void) G_GNUC_CONST;
GType folks_individual_get_type (void) G_GNUC_CONST;
GType folks_simple_query_get_type (void) G_GNUC_CONST;
#define FOLKS_SIMPLE_QUERY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_SIMPLE_QUERY, FolksSimpleQueryPrivate))
enum  {
	FOLKS_SIMPLE_QUERY_DUMMY_PROPERTY,
	FOLKS_SIMPLE_QUERY_QUERY_STRING,
	FOLKS_SIMPLE_QUERY_QUERY_LOCALE
};
static void _folks_simple_query_update_query_string (FolksSimpleQuery* self, const gchar* query_string, const gchar* query_locale);
const gchar* folks_simple_query_get_query_locale (FolksSimpleQuery* self);
FolksSimpleQuery* folks_simple_query_new (const gchar* query_string, gchar** match_fields, int match_fields_length1);
FolksSimpleQuery* folks_simple_query_construct (GType object_type, const gchar* query_string, gchar** match_fields, int match_fields_length1);
static gchar** _vala_array_dup6 (gchar** self, int length);
static guint folks_simple_query_real_is_match (FolksQuery* base, FolksIndividual* individual);
gchar** folks_query_get_match_fields (FolksQuery* self, int* result_length1);
static guint _folks_simple_query_prop_contains_token (FolksSimpleQuery* self, FolksIndividual* individual, const gchar* individual_translit_locale, const gchar* prop_name, GParamSpec* prop_spec, const gchar* token);
static inline guint _folks_simple_query_string_matches_token (FolksSimpleQuery* self, const gchar* str, const gchar* token, const gchar* str_translit_locale);
GType folks_structured_name_get_type (void) G_GNUC_CONST;
const gchar* folks_structured_name_get_given_name (FolksStructuredName* self);
const gchar* folks_structured_name_get_family_name (FolksStructuredName* self);
const gchar* folks_structured_name_get_additional_names (FolksStructuredName* self);
GType folks_abstract_field_details_get_type (void) G_GNUC_CONST;
GType folks_abstract_field_details_get_value_type (FolksAbstractFieldDetails* self);
static guint _folks_simple_query_prop_contains_token_fd_string (FolksSimpleQuery* self, FolksIndividual* individual, const gchar* individual_translit_locale, const gchar* prop_name, GParamSpec* prop_spec, FolksAbstractFieldDetails* val, const gchar* token);
GType folks_role_get_type (void) G_GNUC_CONST;
static guint _folks_simple_query_prop_contains_token_fd_role (FolksSimpleQuery* self, FolksIndividual* individual, const gchar* individual_translit_locale, const gchar* prop_name, GParamSpec* prop_spec, FolksAbstractFieldDetails* val, const gchar* token);
GType folks_postal_address_get_type (void) G_GNUC_CONST;
static guint _folks_simple_query_prop_contains_token_fd_postal_address (FolksSimpleQuery* self, FolksIndividual* individual, const gchar* individual_translit_locale, const gchar* prop_name, GParamSpec* prop_spec, FolksAbstractFieldDetails* val, const gchar* token);
GType folks_phone_field_details_get_type (void) G_GNUC_CONST;
gboolean folks_abstract_field_details_values_equal (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
FolksPhoneFieldDetails* folks_phone_field_details_new (const gchar* value, GeeMultiMap* parameters);
FolksPhoneFieldDetails* folks_phone_field_details_construct (GType object_type, const gchar* value, GeeMultiMap* parameters);
gconstpointer folks_abstract_field_details_get_value (FolksAbstractFieldDetails* self);
const gchar* folks_postal_address_get_street (FolksPostalAddress* self);
const gchar* folks_postal_address_get_locality (FolksPostalAddress* self);
const gchar* folks_postal_address_get_region (FolksPostalAddress* self);
const gchar* folks_postal_address_get_country (FolksPostalAddress* self);
const gchar* folks_role_get_organisation_name (FolksRole* self);
const gchar* folks_role_get_title (FolksRole* self);
const gchar* folks_role_get_role (FolksRole* self);
const gchar* folks_simple_query_get_query_string (FolksSimpleQuery* self);
void folks_simple_query_set_query_string (FolksSimpleQuery* self, const gchar* value);
void folks_simple_query_set_query_locale (FolksSimpleQuery* self, const gchar* value);
static void folks_simple_query_finalize (GObject* obj);
static void _vala_folks_simple_query_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_simple_query_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _folks_simple_query_update_query_string (FolksSimpleQuery* self, const gchar* query_string, const gchar* query_locale) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query_string != NULL);
	_tmp0_ = query_string;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_query_string);
	self->priv->_query_string = _tmp1_;
	_tmp2_ = query_locale;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->_query_locale);
	self->priv->_query_locale = _tmp3_;
	_tmp4_ = self->priv->_query_string;
	_tmp5_ = folks_simple_query_get_query_locale (self);
	_tmp6_ = _tmp5_;
	_tmp8_ = _tmp7_ = g_str_tokenize_and_fold (_tmp4_, _tmp6_, NULL);
	self->priv->_query_tokens = (_vala_array_free (self->priv->_query_tokens, self->priv->_query_tokens_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_query_tokens = _tmp8_;
	self->priv->_query_tokens_length1 = _vala_array_length (_tmp7_);
	self->priv->__query_tokens_size_ = self->priv->_query_tokens_length1;
	g_debug ("simple-query.vala:102: Created simple query with tokens:");
	_tmp9_ = self->priv->_query_tokens;
	_tmp9__length1 = self->priv->_query_tokens_length1;
	{
		gchar** token_collection = NULL;
		gint token_collection_length1 = 0;
		gint _token_collection_size_ = 0;
		gint token_it = 0;
		token_collection = _tmp9_;
		token_collection_length1 = _tmp9__length1;
		for (token_it = 0; token_it < _tmp9__length1; token_it = token_it + 1) {
			gchar* _tmp10_ = NULL;
			gchar* token = NULL;
			_tmp10_ = g_strdup (token_collection[token_it]);
			token = _tmp10_;
			{
				const gchar* _tmp11_ = NULL;
				_tmp11_ = token;
				g_debug ("simple-query.vala:104: \t%s", _tmp11_);
				_g_free0 (token);
			}
		}
	}
	g_object_freeze_notify ((GObject*) self);
	g_object_notify ((GObject*) self, "query-string");
	g_object_notify ((GObject*) self, "query-locale");
	g_object_thaw_notify ((GObject*) self);
}


/**
   * Create a simple text query.
   *
   * @param query_string text to match contacts against. Results will match all
   * tokens within the whitespace-delimited string (logical-ANDing the tokens).
   * A value of "" will match all contacts. However, it is recommended to not
   * use a query at all if filtering is not required.
   * @param match_fields the field names to apply this query to. See
   * {@link Query.match_fields} for more details. An empty array will match all
   * contacts. However, it is recommended to use the
   * {@link IndividualAggregator} directly if filtering is not required.
   * {@link PersonaDetail} and {@link PersonaStore.detail_key} for pre-defined
   * field names.
   *
   * @since 0.11.0
   */
static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


FolksSimpleQuery* folks_simple_query_construct (GType object_type, const gchar* query_string, gchar** match_fields, int match_fields_length1) {
	FolksSimpleQuery * self = NULL;
	gchar** match_fields_safe = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint match_fields_safe_length1 = 0;
	gint _match_fields_safe_size_ = 0;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_val_if_fail (query_string != NULL, NULL);
	_tmp0_ = match_fields;
	_tmp0__length1 = match_fields_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup6 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	match_fields_safe = _tmp1_;
	match_fields_safe_length1 = _tmp1__length1;
	_match_fields_safe_size_ = match_fields_safe_length1;
	_tmp2_ = query_string;
	_tmp3_ = setlocale (LC_ALL, NULL);
	self = (FolksSimpleQuery*) g_object_new (object_type, "query-string", _tmp2_, "match-fields", match_fields_safe, "query-locale", _tmp3_, NULL);
	match_fields_safe = (_vala_array_free (match_fields_safe, match_fields_safe_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


FolksSimpleQuery* folks_simple_query_new (const gchar* query_string, gchar** match_fields, int match_fields_length1) {
	return folks_simple_query_construct (FOLKS_TYPE_SIMPLE_QUERY, query_string, match_fields, match_fields_length1);
}


/**
   * {@inheritDoc}
   *
   * @since 0.11.0
   */
static gpointer _g_param_spec_ref0 (gpointer self) {
	return self ? g_param_spec_ref (self) : NULL;
}


static guint folks_simple_query_real_is_match (FolksQuery* base, FolksIndividual* individual) {
	FolksSimpleQuery * self;
	guint result = 0U;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GeeHashSet* tokens_remaining = NULL;
	GeeHashSet* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar* individual_translit_locale = NULL;
	guint match_score = 0U;
	gchar** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	GeeHashSet* _tmp39_ = NULL;
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	self = (FolksSimpleQuery*) base;
	g_return_val_if_fail (individual != NULL, 0U);
	_tmp1_ = self->priv->_query_tokens;
	_tmp1__length1 = self->priv->_query_tokens_length1;
	if (_tmp1__length1 < 1) {
		_tmp0_ = TRUE;
	} else {
		gchar** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		gchar** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		_tmp2_ = folks_query_get_match_fields ((FolksQuery*) self, &_tmp2__length1);
		_tmp3_ = _tmp2_;
		_tmp3__length1 = _tmp2__length1;
		_tmp0_ = _tmp3__length1 < 1;
	}
	if (_tmp0_) {
		result = (guint) 1;
		return result;
	}
	_tmp4_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	tokens_remaining = _tmp4_;
	_tmp5_ = self->priv->_query_tokens;
	_tmp5__length1 = self->priv->_query_tokens_length1;
	{
		gchar** t_collection = NULL;
		gint t_collection_length1 = 0;
		gint _t_collection_size_ = 0;
		gint t_it = 0;
		t_collection = _tmp5_;
		t_collection_length1 = _tmp5__length1;
		for (t_it = 0; t_it < _tmp5__length1; t_it = t_it + 1) {
			gchar* _tmp6_ = NULL;
			gchar* t = NULL;
			_tmp6_ = g_strdup (t_collection[t_it]);
			t = _tmp6_;
			{
				GeeHashSet* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				_tmp7_ = tokens_remaining;
				_tmp8_ = t;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp8_);
				_g_free0 (t);
			}
		}
	}
	individual_translit_locale = NULL;
	match_score = (guint) 0;
	_tmp9_ = folks_query_get_match_fields ((FolksQuery*) self, &_tmp9__length1);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp9__length1;
	{
		gchar** prop_name_collection = NULL;
		gint prop_name_collection_length1 = 0;
		gint _prop_name_collection_size_ = 0;
		gint prop_name_it = 0;
		prop_name_collection = _tmp10_;
		prop_name_collection_length1 = _tmp10__length1;
		for (prop_name_it = 0; prop_name_it < _tmp10__length1; prop_name_it = prop_name_it + 1) {
			gchar* _tmp11_ = NULL;
			gchar* prop_name = NULL;
			_tmp11_ = g_strdup (prop_name_collection[prop_name_it]);
			prop_name = _tmp11_;
			{
				GObjectClass* iclass = NULL;
				FolksIndividual* _tmp12_ = NULL;
				GObjectClass* _tmp13_ = NULL;
				GParamSpec* prop_spec = NULL;
				GObjectClass* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				GParamSpec* _tmp16_ = NULL;
				GParamSpec* _tmp17_ = NULL;
				GParamSpec* _tmp18_ = NULL;
				_tmp12_ = individual;
				_tmp13_ = G_OBJECT_GET_CLASS ((GObject*) _tmp12_);
				iclass = _tmp13_;
				_tmp14_ = iclass;
				_tmp15_ = prop_name;
				_tmp16_ = g_object_class_find_property (_tmp14_, _tmp15_);
				_tmp17_ = _g_param_spec_ref0 (_tmp16_);
				prop_spec = _tmp17_;
				_tmp18_ = prop_spec;
				if (_tmp18_ == NULL) {
					const gchar* _tmp19_ = NULL;
					_tmp19_ = prop_name;
					g_warning ("simple-query.vala:182: Folks.Individual does not contain property '%s'", _tmp19_);
				} else {
					GeeIterator* iter = NULL;
					GeeHashSet* _tmp20_ = NULL;
					GeeIterator* _tmp21_ = NULL;
					_tmp20_ = tokens_remaining;
					_tmp21_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp20_);
					iter = _tmp21_;
					while (TRUE) {
						GeeIterator* _tmp22_ = NULL;
						gboolean _tmp23_ = FALSE;
						gchar* token = NULL;
						GeeIterator* _tmp24_ = NULL;
						gpointer _tmp25_ = NULL;
						guint inc = 0U;
						FolksIndividual* _tmp26_ = NULL;
						const gchar* _tmp27_ = NULL;
						const gchar* _tmp28_ = NULL;
						GParamSpec* _tmp29_ = NULL;
						const gchar* _tmp30_ = NULL;
						guint _tmp31_ = 0U;
						guint _tmp32_ = 0U;
						guint _tmp33_ = 0U;
						guint _tmp34_ = 0U;
						_tmp22_ = iter;
						_tmp23_ = gee_iterator_next (_tmp22_);
						if (!_tmp23_) {
							break;
						}
						_tmp24_ = iter;
						_tmp25_ = gee_iterator_get (_tmp24_);
						token = (gchar*) _tmp25_;
						_tmp26_ = individual;
						_tmp27_ = individual_translit_locale;
						_tmp28_ = prop_name;
						_tmp29_ = prop_spec;
						_tmp30_ = token;
						_tmp31_ = _folks_simple_query_prop_contains_token (self, _tmp26_, _tmp27_, _tmp28_, _tmp29_, _tmp30_);
						inc = _tmp31_;
						_tmp32_ = match_score;
						_tmp33_ = inc;
						match_score = _tmp32_ + _tmp33_;
						_tmp34_ = inc;
						if (_tmp34_ > ((guint) 0)) {
							GeeIterator* _tmp35_ = NULL;
							GeeHashSet* _tmp36_ = NULL;
							gint _tmp37_ = 0;
							gint _tmp38_ = 0;
							_tmp35_ = iter;
							gee_iterator_remove (_tmp35_);
							_tmp36_ = tokens_remaining;
							_tmp37_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp36_);
							_tmp38_ = _tmp37_;
							if (_tmp38_ == 0) {
								result = match_score;
								_g_free0 (token);
								_g_object_unref0 (iter);
								_g_param_spec_unref0 (prop_spec);
								_g_free0 (prop_name);
								_g_free0 (individual_translit_locale);
								_g_object_unref0 (tokens_remaining);
								return result;
							}
						}
						_g_free0 (token);
					}
					_g_object_unref0 (iter);
				}
				_g_param_spec_unref0 (prop_spec);
				_g_free0 (prop_name);
			}
		}
	}
	_tmp39_ = tokens_remaining;
	_tmp40_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp39_);
	_tmp41_ = _tmp40_;
	_vala_assert (_tmp41_ > 0, "tokens_remaining.size > 0");
	result = (guint) 0;
	_g_free0 (individual_translit_locale);
	_g_object_unref0 (tokens_remaining);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static guint _folks_simple_query_prop_contains_token (FolksSimpleQuery* self, FolksIndividual* individual, const gchar* individual_translit_locale, const gchar* prop_name, GParamSpec* prop_spec, const gchar* token) {
	guint result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (individual != NULL, 0U);
	g_return_val_if_fail (prop_name != NULL, 0U);
	g_return_val_if_fail (prop_spec != NULL, 0U);
	g_return_val_if_fail (token != NULL, 0U);
	if (FALSE) {
	} else {
		GParamSpec* _tmp0_ = NULL;
		GType _tmp1_ = 0UL;
		_tmp0_ = prop_spec;
		_tmp1_ = _tmp0_->value_type;
		if (_tmp1_ == G_TYPE_STRING) {
			gchar* prop_value = NULL;
			FolksIndividual* _tmp2_ = NULL;
			const gchar* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
			const gchar* _tmp5_ = NULL;
			guint score = 0U;
			const gchar* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			guint _tmp10_ = 0U;
			guint _tmp11_ = 0U;
			_tmp2_ = individual;
			_tmp3_ = prop_name;
			g_object_get ((GObject*) _tmp2_, _tmp3_, &prop_value, NULL);
			_tmp5_ = prop_value;
			if (_tmp5_ == NULL) {
				_tmp4_ = TRUE;
			} else {
				const gchar* _tmp6_ = NULL;
				_tmp6_ = prop_value;
				_tmp4_ = g_strcmp0 (_tmp6_, "") == 0;
			}
			if (_tmp4_) {
				result = (guint) 0;
				_g_free0 (prop_value);
				return result;
			}
			_tmp7_ = prop_value;
			_tmp8_ = token;
			_tmp9_ = individual_translit_locale;
			_tmp10_ = _folks_simple_query_string_matches_token (self, _tmp7_, _tmp8_, _tmp9_);
			score = _tmp10_;
			_tmp11_ = score;
			if (_tmp11_ > ((guint) 0)) {
				gboolean _tmp12_ = FALSE;
				const gchar* _tmp13_ = NULL;
				_tmp13_ = prop_name;
				if (g_strcmp0 (_tmp13_, "full-name") == 0) {
					_tmp12_ = TRUE;
				} else {
					const gchar* _tmp14_ = NULL;
					_tmp14_ = prop_name;
					_tmp12_ = g_strcmp0 (_tmp14_, "nickname") == 0;
				}
				if (_tmp12_) {
					guint _tmp15_ = 0U;
					_tmp15_ = score;
					result = _tmp15_ * 10;
					_g_free0 (prop_value);
					return result;
				} else {
					guint _tmp16_ = 0U;
					_tmp16_ = score;
					result = _tmp16_ * 2;
					_g_free0 (prop_value);
					return result;
				}
			}
			_g_free0 (prop_value);
		} else {
			GParamSpec* _tmp17_ = NULL;
			GType _tmp18_ = 0UL;
			_tmp17_ = prop_spec;
			_tmp18_ = _tmp17_->value_type;
			if (_tmp18_ == FOLKS_TYPE_STRUCTURED_NAME) {
				FolksStructuredName* prop_value = NULL;
				FolksIndividual* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				FolksStructuredName* _tmp21_ = NULL;
				guint score = 0U;
				FolksStructuredName* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				const gchar* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				guint _tmp27_ = 0U;
				guint _tmp28_ = 0U;
				FolksStructuredName* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
				const gchar* _tmp34_ = NULL;
				guint _tmp35_ = 0U;
				guint _tmp36_ = 0U;
				FolksStructuredName* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				const gchar* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				const gchar* _tmp42_ = NULL;
				guint _tmp43_ = 0U;
				guint _tmp44_ = 0U;
				_tmp19_ = individual;
				_tmp20_ = prop_name;
				g_object_get ((GObject*) _tmp19_, _tmp20_, &prop_value, NULL);
				_tmp21_ = prop_value;
				if (_tmp21_ == NULL) {
					result = (guint) 0;
					_g_object_unref0 (prop_value);
					return result;
				}
				_tmp22_ = prop_value;
				_tmp23_ = folks_structured_name_get_given_name (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = token;
				_tmp26_ = individual_translit_locale;
				_tmp27_ = _folks_simple_query_string_matches_token (self, _tmp24_, _tmp25_, _tmp26_);
				score = _tmp27_;
				_tmp28_ = score;
				if (_tmp28_ > ((guint) 0)) {
					guint _tmp29_ = 0U;
					_tmp29_ = score;
					result = _tmp29_ * 10;
					_g_object_unref0 (prop_value);
					return result;
				}
				_tmp30_ = prop_value;
				_tmp31_ = folks_structured_name_get_family_name (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = token;
				_tmp34_ = individual_translit_locale;
				_tmp35_ = _folks_simple_query_string_matches_token (self, _tmp32_, _tmp33_, _tmp34_);
				score = _tmp35_;
				_tmp36_ = score;
				if (_tmp36_ > ((guint) 0)) {
					guint _tmp37_ = 0U;
					_tmp37_ = score;
					result = _tmp37_ * 10;
					_g_object_unref0 (prop_value);
					return result;
				}
				_tmp38_ = prop_value;
				_tmp39_ = folks_structured_name_get_additional_names (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = token;
				_tmp42_ = individual_translit_locale;
				_tmp43_ = _folks_simple_query_string_matches_token (self, _tmp40_, _tmp41_, _tmp42_);
				score = _tmp43_;
				_tmp44_ = score;
				if (_tmp44_ > ((guint) 0)) {
					guint _tmp45_ = 0U;
					_tmp45_ = score;
					result = _tmp45_ * 5;
					_g_object_unref0 (prop_value);
					return result;
				}
				_g_object_unref0 (prop_value);
			} else {
				GParamSpec* _tmp46_ = NULL;
				GType _tmp47_ = 0UL;
				_tmp46_ = prop_spec;
				_tmp47_ = _tmp46_->value_type;
				if (_tmp47_ == GEE_TYPE_SET) {
					GeeSet* prop_value_set = NULL;
					FolksIndividual* _tmp48_ = NULL;
					const gchar* _tmp49_ = NULL;
					gboolean _tmp50_ = FALSE;
					GeeSet* _tmp51_ = NULL;
					GeeSet* _tmp55_ = NULL;
					GType _tmp56_ = 0UL;
					GType _tmp57_ = 0UL;
					gboolean _tmp58_ = FALSE;
					_tmp48_ = individual;
					_tmp49_ = prop_name;
					g_object_get ((GObject*) _tmp48_, _tmp49_, &prop_value_set, NULL);
					_tmp51_ = prop_value_set;
					if (_tmp51_ == NULL) {
						_tmp50_ = TRUE;
					} else {
						GeeSet* _tmp52_ = NULL;
						gboolean _tmp53_ = FALSE;
						gboolean _tmp54_ = FALSE;
						_tmp52_ = prop_value_set;
						_tmp53_ = gee_collection_get_is_empty ((GeeCollection*) _tmp52_);
						_tmp54_ = _tmp53_;
						_tmp50_ = _tmp54_;
					}
					if (_tmp50_) {
						result = (guint) 0;
						_g_object_unref0 (prop_value_set);
						return result;
					}
					_tmp55_ = prop_value_set;
					_tmp56_ = gee_traversable_get_element_type ((GeeTraversable*) _tmp55_);
					_tmp57_ = _tmp56_;
					_tmp58_ = g_type_is_a (_tmp57_, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS);
					if (_tmp58_) {
						GeeSet* prop_value_afd = NULL;
						GeeSet* _tmp59_ = NULL;
						GeeSet* _tmp60_ = NULL;
						_tmp59_ = prop_value_set;
						_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp59_, GEE_TYPE_SET) ? ((GeeSet*) _tmp59_) : NULL);
						prop_value_afd = _tmp60_;
						{
							GeeIterator* _val_it = NULL;
							GeeSet* _tmp61_ = NULL;
							GeeIterator* _tmp62_ = NULL;
							_tmp61_ = prop_value_afd;
							_tmp62_ = gee_iterable_iterator ((GeeIterable*) _tmp61_);
							_val_it = _tmp62_;
							while (TRUE) {
								GeeIterator* _tmp63_ = NULL;
								gboolean _tmp64_ = FALSE;
								FolksAbstractFieldDetails* val = NULL;
								GeeIterator* _tmp65_ = NULL;
								gpointer _tmp66_ = NULL;
								FolksAbstractFieldDetails* _tmp67_ = NULL;
								GType _tmp68_ = 0UL;
								GType _tmp69_ = 0UL;
								_tmp63_ = _val_it;
								_tmp64_ = gee_iterator_next (_tmp63_);
								if (!_tmp64_) {
									break;
								}
								_tmp65_ = _val_it;
								_tmp66_ = gee_iterator_get (_tmp65_);
								val = (FolksAbstractFieldDetails*) _tmp66_;
								_tmp67_ = val;
								_tmp68_ = folks_abstract_field_details_get_value_type (_tmp67_);
								_tmp69_ = _tmp68_;
								if (_tmp69_ == G_TYPE_STRING) {
									guint score = 0U;
									FolksIndividual* _tmp70_ = NULL;
									const gchar* _tmp71_ = NULL;
									const gchar* _tmp72_ = NULL;
									GParamSpec* _tmp73_ = NULL;
									FolksAbstractFieldDetails* _tmp74_ = NULL;
									const gchar* _tmp75_ = NULL;
									guint _tmp76_ = 0U;
									guint _tmp77_ = 0U;
									_tmp70_ = individual;
									_tmp71_ = individual_translit_locale;
									_tmp72_ = prop_name;
									_tmp73_ = prop_spec;
									_tmp74_ = val;
									_tmp75_ = token;
									_tmp76_ = _folks_simple_query_prop_contains_token_fd_string (self, _tmp70_, _tmp71_, _tmp72_, _tmp73_, _tmp74_, _tmp75_);
									score = _tmp76_;
									_tmp77_ = score;
									if (_tmp77_ > ((guint) 0)) {
										const gchar* _tmp78_ = NULL;
										_tmp78_ = prop_name;
										if (g_strcmp0 (_tmp78_, "email-addresses") == 0) {
											guint _tmp79_ = 0U;
											_tmp79_ = score;
											result = _tmp79_ * 4;
											_g_object_unref0 (val);
											_g_object_unref0 (_val_it);
											_g_object_unref0 (prop_value_afd);
											_g_object_unref0 (prop_value_set);
											return result;
										} else {
											guint _tmp80_ = 0U;
											_tmp80_ = score;
											result = _tmp80_ * 2;
											_g_object_unref0 (val);
											_g_object_unref0 (_val_it);
											_g_object_unref0 (prop_value_afd);
											_g_object_unref0 (prop_value_set);
											return result;
										}
									}
								} else {
									FolksAbstractFieldDetails* _tmp81_ = NULL;
									GType _tmp82_ = 0UL;
									GType _tmp83_ = 0UL;
									_tmp81_ = val;
									_tmp82_ = folks_abstract_field_details_get_value_type (_tmp81_);
									_tmp83_ = _tmp82_;
									if (_tmp83_ == FOLKS_TYPE_ROLE) {
										guint score = 0U;
										FolksIndividual* _tmp84_ = NULL;
										const gchar* _tmp85_ = NULL;
										const gchar* _tmp86_ = NULL;
										GParamSpec* _tmp87_ = NULL;
										FolksAbstractFieldDetails* _tmp88_ = NULL;
										const gchar* _tmp89_ = NULL;
										guint _tmp90_ = 0U;
										guint _tmp91_ = 0U;
										_tmp84_ = individual;
										_tmp85_ = individual_translit_locale;
										_tmp86_ = prop_name;
										_tmp87_ = prop_spec;
										_tmp88_ = val;
										_tmp89_ = token;
										_tmp90_ = _folks_simple_query_prop_contains_token_fd_role (self, _tmp84_, _tmp85_, _tmp86_, _tmp87_, _tmp88_, _tmp89_);
										score = _tmp90_;
										_tmp91_ = score;
										if (_tmp91_ > ((guint) 0)) {
											guint _tmp92_ = 0U;
											_tmp92_ = score;
											result = _tmp92_ * 1;
											_g_object_unref0 (val);
											_g_object_unref0 (_val_it);
											_g_object_unref0 (prop_value_afd);
											_g_object_unref0 (prop_value_set);
											return result;
										}
									} else {
										FolksAbstractFieldDetails* _tmp93_ = NULL;
										GType _tmp94_ = 0UL;
										GType _tmp95_ = 0UL;
										_tmp93_ = val;
										_tmp94_ = folks_abstract_field_details_get_value_type (_tmp93_);
										_tmp95_ = _tmp94_;
										if (_tmp95_ == FOLKS_TYPE_POSTAL_ADDRESS) {
											guint score = 0U;
											FolksIndividual* _tmp96_ = NULL;
											const gchar* _tmp97_ = NULL;
											const gchar* _tmp98_ = NULL;
											GParamSpec* _tmp99_ = NULL;
											FolksAbstractFieldDetails* _tmp100_ = NULL;
											const gchar* _tmp101_ = NULL;
											guint _tmp102_ = 0U;
											guint _tmp103_ = 0U;
											_tmp96_ = individual;
											_tmp97_ = individual_translit_locale;
											_tmp98_ = prop_name;
											_tmp99_ = prop_spec;
											_tmp100_ = val;
											_tmp101_ = token;
											_tmp102_ = _folks_simple_query_prop_contains_token_fd_postal_address (self, _tmp96_, _tmp97_, _tmp98_, _tmp99_, _tmp100_, _tmp101_);
											score = _tmp102_;
											_tmp103_ = score;
											if (_tmp103_ > ((guint) 0)) {
												guint _tmp104_ = 0U;
												_tmp104_ = score;
												result = _tmp104_ * 3;
												_g_object_unref0 (val);
												_g_object_unref0 (_val_it);
												_g_object_unref0 (prop_value_afd);
												_g_object_unref0 (prop_value_set);
												return result;
											}
										} else {
											FolksAbstractFieldDetails* _tmp105_ = NULL;
											GType _tmp106_ = 0UL;
											GType _tmp107_ = 0UL;
											const gchar* _tmp108_ = NULL;
											_tmp105_ = val;
											_tmp106_ = folks_abstract_field_details_get_value_type (_tmp105_);
											_tmp107_ = _tmp106_;
											_tmp108_ = g_type_name (_tmp107_);
											g_warning ("Cannot check for match in detail type " "Gee.Set<AbstractFieldDetails<%s>>", _tmp108_);
											result = (guint) 0;
											_g_object_unref0 (val);
											_g_object_unref0 (_val_it);
											_g_object_unref0 (prop_value_afd);
											_g_object_unref0 (prop_value_set);
											return result;
										}
									}
								}
								_g_object_unref0 (val);
							}
							_g_object_unref0 (_val_it);
						}
						_g_object_unref0 (prop_value_afd);
					} else {
						GeeSet* _tmp109_ = NULL;
						GType _tmp110_ = 0UL;
						GType _tmp111_ = 0UL;
						_tmp109_ = prop_value_set;
						_tmp110_ = gee_traversable_get_element_type ((GeeTraversable*) _tmp109_);
						_tmp111_ = _tmp110_;
						if (_tmp111_ == G_TYPE_STRING) {
							GeeSet* prop_value_string = NULL;
							GeeSet* _tmp112_ = NULL;
							GeeSet* _tmp113_ = NULL;
							_tmp112_ = prop_value_set;
							_tmp113_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp112_, GEE_TYPE_SET) ? ((GeeSet*) _tmp112_) : NULL);
							prop_value_string = _tmp113_;
							{
								GeeIterator* _val_it = NULL;
								GeeSet* _tmp114_ = NULL;
								GeeIterator* _tmp115_ = NULL;
								_tmp114_ = prop_value_string;
								_tmp115_ = gee_iterable_iterator ((GeeIterable*) _tmp114_);
								_val_it = _tmp115_;
								while (TRUE) {
									GeeIterator* _tmp116_ = NULL;
									gboolean _tmp117_ = FALSE;
									gchar* val = NULL;
									GeeIterator* _tmp118_ = NULL;
									gpointer _tmp119_ = NULL;
									gboolean _tmp120_ = FALSE;
									const gchar* _tmp121_ = NULL;
									guint score = 0U;
									const gchar* _tmp123_ = NULL;
									const gchar* _tmp124_ = NULL;
									const gchar* _tmp125_ = NULL;
									guint _tmp126_ = 0U;
									guint _tmp127_ = 0U;
									_tmp116_ = _val_it;
									_tmp117_ = gee_iterator_next (_tmp116_);
									if (!_tmp117_) {
										break;
									}
									_tmp118_ = _val_it;
									_tmp119_ = gee_iterator_get (_tmp118_);
									val = (gchar*) _tmp119_;
									_tmp121_ = val;
									if (_tmp121_ == NULL) {
										_tmp120_ = TRUE;
									} else {
										const gchar* _tmp122_ = NULL;
										_tmp122_ = val;
										_tmp120_ = g_strcmp0 (_tmp122_, "") == 0;
									}
									if (_tmp120_) {
										_g_free0 (val);
										continue;
									}
									_tmp123_ = val;
									_tmp124_ = token;
									_tmp125_ = individual_translit_locale;
									_tmp126_ = _folks_simple_query_string_matches_token (self, _tmp123_, _tmp124_, _tmp125_);
									score = _tmp126_;
									_tmp127_ = score;
									if (_tmp127_ > ((guint) 0)) {
										guint _tmp128_ = 0U;
										_tmp128_ = score;
										result = _tmp128_ * 1;
										_g_free0 (val);
										_g_object_unref0 (_val_it);
										_g_object_unref0 (prop_value_string);
										_g_object_unref0 (prop_value_set);
										return result;
									}
									_g_free0 (val);
								}
								_g_object_unref0 (_val_it);
							}
							_g_object_unref0 (prop_value_string);
						} else {
							const gchar* _tmp129_ = NULL;
							GeeSet* _tmp130_ = NULL;
							GType _tmp131_ = 0UL;
							GType _tmp132_ = 0UL;
							const gchar* _tmp133_ = NULL;
							_tmp129_ = prop_name;
							_tmp130_ = prop_value_set;
							_tmp131_ = gee_traversable_get_element_type ((GeeTraversable*) _tmp130_);
							_tmp132_ = _tmp131_;
							_tmp133_ = g_type_name (_tmp132_);
							g_warning ("Cannot check for match in property ‘%s’, detail type " "Gee.Set<%s>", _tmp129_, _tmp133_);
							result = (guint) 0;
							_g_object_unref0 (prop_value_set);
							return result;
						}
					}
					_g_object_unref0 (prop_value_set);
				} else {
					GParamSpec* _tmp134_ = NULL;
					GType _tmp135_ = 0UL;
					_tmp134_ = prop_spec;
					_tmp135_ = _tmp134_->value_type;
					if (_tmp135_ == GEE_TYPE_MULTI_MAP) {
						GeeMultiMap* prop_value_multi_map = NULL;
						FolksIndividual* _tmp136_ = NULL;
						const gchar* _tmp137_ = NULL;
						gboolean _tmp138_ = FALSE;
						GeeMultiMap* _tmp139_ = NULL;
						GType key_type = 0UL;
						GeeMultiMap* _tmp143_ = NULL;
						GType _tmp144_ = 0UL;
						GType _tmp145_ = 0UL;
						GType value_type = 0UL;
						GeeMultiMap* _tmp146_ = NULL;
						GType _tmp147_ = 0UL;
						GType _tmp148_ = 0UL;
						gboolean _tmp149_ = FALSE;
						GType _tmp150_ = 0UL;
						gboolean _tmp151_ = FALSE;
						_tmp136_ = individual;
						_tmp137_ = prop_name;
						g_object_get ((GObject*) _tmp136_, _tmp137_, &prop_value_multi_map, NULL);
						_tmp139_ = prop_value_multi_map;
						if (_tmp139_ == NULL) {
							_tmp138_ = TRUE;
						} else {
							GeeMultiMap* _tmp140_ = NULL;
							gint _tmp141_ = 0;
							gint _tmp142_ = 0;
							_tmp140_ = prop_value_multi_map;
							_tmp141_ = gee_multi_map_get_size (_tmp140_);
							_tmp142_ = _tmp141_;
							_tmp138_ = _tmp142_ < 1;
						}
						if (_tmp138_) {
							result = (guint) 0;
							_g_object_unref0 (prop_value_multi_map);
							return result;
						}
						_tmp143_ = prop_value_multi_map;
						_tmp144_ = gee_multi_map_get_key_type (_tmp143_);
						_tmp145_ = _tmp144_;
						key_type = _tmp145_;
						_tmp146_ = prop_value_multi_map;
						_tmp147_ = gee_multi_map_get_value_type (_tmp146_);
						_tmp148_ = _tmp147_;
						value_type = _tmp148_;
						_tmp150_ = key_type;
						_tmp151_ = g_type_is_a (_tmp150_, G_TYPE_STRING);
						if (_tmp151_) {
							GType _tmp152_ = 0UL;
							gboolean _tmp153_ = FALSE;
							_tmp152_ = value_type;
							_tmp153_ = g_type_is_a (_tmp152_, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS);
							_tmp149_ = _tmp153_;
						} else {
							_tmp149_ = FALSE;
						}
						if (_tmp149_) {
							GeeMultiMap* prop_value_multi_map_afd = NULL;
							GeeMultiMap* _tmp154_ = NULL;
							GeeMultiMap* _tmp155_ = NULL;
							GeeMapIterator* iter = NULL;
							GeeMultiMap* _tmp156_ = NULL;
							GeeMapIterator* _tmp157_ = NULL;
							_tmp154_ = prop_value_multi_map;
							_tmp155_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp154_, GEE_TYPE_MULTI_MAP) ? ((GeeMultiMap*) _tmp154_) : NULL);
							prop_value_multi_map_afd = _tmp155_;
							_tmp156_ = prop_value_multi_map_afd;
							_tmp157_ = gee_multi_map_map_iterator (_tmp156_);
							iter = _tmp157_;
							while (TRUE) {
								GeeMapIterator* _tmp158_ = NULL;
								gboolean _tmp159_ = FALSE;
								FolksAbstractFieldDetails* val = NULL;
								GeeMapIterator* _tmp160_ = NULL;
								gpointer _tmp161_ = NULL;
								FolksAbstractFieldDetails* _tmp162_ = NULL;
								GType _tmp163_ = 0UL;
								GType _tmp164_ = 0UL;
								_tmp158_ = iter;
								_tmp159_ = gee_map_iterator_next (_tmp158_);
								if (!_tmp159_) {
									break;
								}
								_tmp160_ = iter;
								_tmp161_ = gee_map_iterator_get_value (_tmp160_);
								val = (FolksAbstractFieldDetails*) _tmp161_;
								_tmp162_ = val;
								_tmp163_ = folks_abstract_field_details_get_value_type (_tmp162_);
								_tmp164_ = _tmp163_;
								if (_tmp164_ == G_TYPE_STRING) {
									guint score = 0U;
									FolksIndividual* _tmp165_ = NULL;
									const gchar* _tmp166_ = NULL;
									const gchar* _tmp167_ = NULL;
									GParamSpec* _tmp168_ = NULL;
									FolksAbstractFieldDetails* _tmp169_ = NULL;
									const gchar* _tmp170_ = NULL;
									guint _tmp171_ = 0U;
									guint _tmp172_ = 0U;
									_tmp165_ = individual;
									_tmp166_ = individual_translit_locale;
									_tmp167_ = prop_name;
									_tmp168_ = prop_spec;
									_tmp169_ = val;
									_tmp170_ = token;
									_tmp171_ = _folks_simple_query_prop_contains_token_fd_string (self, _tmp165_, _tmp166_, _tmp167_, _tmp168_, _tmp169_, _tmp170_);
									score = _tmp171_;
									_tmp172_ = score;
									if (_tmp172_ > ((guint) 0)) {
										guint _tmp173_ = 0U;
										_tmp173_ = score;
										result = _tmp173_ * 2;
										_g_object_unref0 (val);
										_g_object_unref0 (iter);
										_g_object_unref0 (prop_value_multi_map_afd);
										_g_object_unref0 (prop_value_multi_map);
										return result;
									}
								}
								_g_object_unref0 (val);
							}
							_g_object_unref0 (iter);
							_g_object_unref0 (prop_value_multi_map_afd);
						} else {
							GType _tmp174_ = 0UL;
							const gchar* _tmp175_ = NULL;
							GType _tmp176_ = 0UL;
							const gchar* _tmp177_ = NULL;
							_tmp174_ = key_type;
							_tmp175_ = g_type_name (_tmp174_);
							_tmp176_ = value_type;
							_tmp177_ = g_type_name (_tmp176_);
							g_warning ("Cannot check for match in detail type " "Gee.MultiMap<%s, %s>", _tmp175_, _tmp177_);
							result = (guint) 0;
							_g_object_unref0 (prop_value_multi_map);
							return result;
						}
						_g_object_unref0 (prop_value_multi_map);
					} else {
						GParamSpec* _tmp178_ = NULL;
						GType _tmp179_ = 0UL;
						const gchar* _tmp180_ = NULL;
						_tmp178_ = prop_spec;
						_tmp179_ = _tmp178_->value_type;
						_tmp180_ = g_type_name (_tmp179_);
						g_warning ("simple-query.vala:398: Cannot check for match in detail type %s", _tmp180_);
					}
				}
			}
		}
	}
	result = (guint) 0;
	return result;
}


static guint _folks_simple_query_prop_contains_token_fd_string (FolksSimpleQuery* self, FolksIndividual* individual, const gchar* individual_translit_locale, const gchar* prop_name, GParamSpec* prop_spec, FolksAbstractFieldDetails* val, const gchar* token) {
	guint result = 0U;
	FolksAbstractFieldDetails* _tmp0_ = NULL;
	GType _tmp1_ = 0UL;
	FolksAbstractFieldDetails* _tmp8_ = NULL;
	gconstpointer _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (individual != NULL, 0U);
	g_return_val_if_fail (prop_name != NULL, 0U);
	g_return_val_if_fail (prop_spec != NULL, 0U);
	g_return_val_if_fail (val != NULL, 0U);
	g_return_val_if_fail (token != NULL, 0U);
	_tmp0_ = val;
	_tmp1_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp0_);
	if (_tmp1_ == FOLKS_TYPE_PHONE_FIELD_DETAILS) {
		FolksAbstractFieldDetails* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		FolksPhoneFieldDetails* _tmp4_ = NULL;
		FolksPhoneFieldDetails* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		_tmp2_ = val;
		_tmp3_ = token;
		_tmp4_ = folks_phone_field_details_new (_tmp3_, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = folks_abstract_field_details_values_equal (_tmp2_, (FolksAbstractFieldDetails*) _tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		if (_tmp7_) {
			result = (guint) 2;
			return result;
		}
	}
	_tmp8_ = val;
	_tmp9_ = folks_abstract_field_details_get_value (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = token;
	_tmp12_ = individual_translit_locale;
	_tmp13_ = _folks_simple_query_string_matches_token (self, (const gchar*) _tmp10_, _tmp11_, _tmp12_);
	result = _tmp13_;
	return result;
}


static guint _folks_simple_query_prop_contains_token_fd_postal_address (FolksSimpleQuery* self, FolksIndividual* individual, const gchar* individual_translit_locale, const gchar* prop_name, GParamSpec* prop_spec, FolksAbstractFieldDetails* val, const gchar* token) {
	guint result = 0U;
	guint score = 0U;
	FolksAbstractFieldDetails* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	FolksPostalAddress* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	FolksAbstractFieldDetails* _tmp9_ = NULL;
	gconstpointer _tmp10_ = NULL;
	FolksPostalAddress* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	guint _tmp16_ = 0U;
	guint _tmp17_ = 0U;
	FolksAbstractFieldDetails* _tmp18_ = NULL;
	gconstpointer _tmp19_ = NULL;
	FolksPostalAddress* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	guint _tmp25_ = 0U;
	guint _tmp26_ = 0U;
	FolksAbstractFieldDetails* _tmp27_ = NULL;
	gconstpointer _tmp28_ = NULL;
	FolksPostalAddress* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	guint _tmp34_ = 0U;
	guint _tmp35_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (individual != NULL, 0U);
	g_return_val_if_fail (prop_name != NULL, 0U);
	g_return_val_if_fail (prop_spec != NULL, 0U);
	g_return_val_if_fail (val != NULL, 0U);
	g_return_val_if_fail (token != NULL, 0U);
	_tmp0_ = val;
	_tmp1_ = folks_abstract_field_details_get_value (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_postal_address_get_street ((FolksPostalAddress*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = token;
	_tmp6_ = individual_translit_locale;
	_tmp7_ = _folks_simple_query_string_matches_token (self, _tmp4_, _tmp5_, _tmp6_);
	score = _tmp7_;
	_tmp8_ = score;
	if (_tmp8_ > ((guint) 0)) {
		result = score;
		return result;
	}
	_tmp9_ = val;
	_tmp10_ = folks_abstract_field_details_get_value (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = folks_postal_address_get_locality ((FolksPostalAddress*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = token;
	_tmp15_ = individual_translit_locale;
	_tmp16_ = _folks_simple_query_string_matches_token (self, _tmp13_, _tmp14_, _tmp15_);
	score = _tmp16_;
	_tmp17_ = score;
	if (_tmp17_ > ((guint) 0)) {
		result = score;
		return result;
	}
	_tmp18_ = val;
	_tmp19_ = folks_abstract_field_details_get_value (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = folks_postal_address_get_region ((FolksPostalAddress*) _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = token;
	_tmp24_ = individual_translit_locale;
	_tmp25_ = _folks_simple_query_string_matches_token (self, _tmp22_, _tmp23_, _tmp24_);
	score = _tmp25_;
	_tmp26_ = score;
	if (_tmp26_ > ((guint) 0)) {
		result = score;
		return result;
	}
	_tmp27_ = val;
	_tmp28_ = folks_abstract_field_details_get_value (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = folks_postal_address_get_country ((FolksPostalAddress*) _tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = token;
	_tmp33_ = individual_translit_locale;
	_tmp34_ = _folks_simple_query_string_matches_token (self, _tmp31_, _tmp32_, _tmp33_);
	score = _tmp34_;
	_tmp35_ = score;
	if (_tmp35_ > ((guint) 0)) {
		result = score;
		return result;
	}
	result = (guint) 0;
	return result;
}


static guint _folks_simple_query_prop_contains_token_fd_role (FolksSimpleQuery* self, FolksIndividual* individual, const gchar* individual_translit_locale, const gchar* prop_name, GParamSpec* prop_spec, FolksAbstractFieldDetails* val, const gchar* token) {
	guint result = 0U;
	guint score = 0U;
	FolksAbstractFieldDetails* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	FolksRole* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	FolksAbstractFieldDetails* _tmp9_ = NULL;
	gconstpointer _tmp10_ = NULL;
	FolksRole* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	guint _tmp16_ = 0U;
	guint _tmp17_ = 0U;
	FolksAbstractFieldDetails* _tmp18_ = NULL;
	gconstpointer _tmp19_ = NULL;
	FolksRole* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	guint _tmp25_ = 0U;
	guint _tmp26_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (individual != NULL, 0U);
	g_return_val_if_fail (prop_name != NULL, 0U);
	g_return_val_if_fail (prop_spec != NULL, 0U);
	g_return_val_if_fail (val != NULL, 0U);
	g_return_val_if_fail (token != NULL, 0U);
	_tmp0_ = val;
	_tmp1_ = folks_abstract_field_details_get_value (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_role_get_organisation_name ((FolksRole*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = token;
	_tmp6_ = individual_translit_locale;
	_tmp7_ = _folks_simple_query_string_matches_token (self, _tmp4_, _tmp5_, _tmp6_);
	score = _tmp7_;
	_tmp8_ = score;
	if (_tmp8_ > ((guint) 0)) {
		result = score;
		return result;
	}
	_tmp9_ = val;
	_tmp10_ = folks_abstract_field_details_get_value (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = folks_role_get_title ((FolksRole*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = token;
	_tmp15_ = individual_translit_locale;
	_tmp16_ = _folks_simple_query_string_matches_token (self, _tmp13_, _tmp14_, _tmp15_);
	score = _tmp16_;
	_tmp17_ = score;
	if (_tmp17_ > ((guint) 0)) {
		result = score;
		return result;
	}
	_tmp18_ = val;
	_tmp19_ = folks_abstract_field_details_get_value (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = folks_role_get_role ((FolksRole*) _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = token;
	_tmp24_ = individual_translit_locale;
	_tmp25_ = _folks_simple_query_string_matches_token (self, _tmp22_, _tmp23_, _tmp24_);
	score = _tmp25_;
	_tmp26_ = score;
	if (_tmp26_ > ((guint) 0)) {
		result = score;
		return result;
	}
	result = (guint) 0;
	return result;
}


static inline guint _folks_simple_query_string_matches_token (FolksSimpleQuery* self, const gchar* str, const gchar* token, const gchar* str_translit_locale) {
	guint result = 0U;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar** alternates = NULL;
	gint alternates_length1 = 0;
	gint _alternates_size_ = 0;
	gchar** str_tokens = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint str_tokens_length1 = 0;
	gint _str_tokens_size_ = 0;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (str != NULL, 0U);
	g_return_val_if_fail (token != NULL, 0U);
	_tmp0_ = str;
	_tmp1_ = token;
	g_debug ("simple-query.vala:492: Matching string ‘%s’ against token ‘%s’.", _tmp0_, _tmp1_);
	_tmp2_ = str;
	_tmp3_ = str_translit_locale;
	_tmp6_ = _tmp5_ = g_str_tokenize_and_fold (_tmp2_, _tmp3_, &_tmp4_);
	alternates = (_vala_array_free (alternates, alternates_length1, (GDestroyNotify) g_free), NULL);
	alternates = _tmp4_;
	alternates_length1 = -1;
	_alternates_size_ = alternates_length1;
	alternates_length1 = _vala_array_length (alternates);
	str_tokens = _tmp6_;
	str_tokens_length1 = _vala_array_length (_tmp5_);
	_str_tokens_size_ = str_tokens_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gchar** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gint _tmp10_ = 0;
				const gchar* _tmp11_ = NULL;
				gchar* str_token = NULL;
				gchar** _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				gint _tmp13_ = 0;
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = str_tokens;
				_tmp9__length1 = str_tokens_length1;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				if (!(_tmp11_ != NULL)) {
					break;
				}
				_tmp12_ = str_tokens;
				_tmp12__length1 = str_tokens_length1;
				_tmp13_ = i;
				_tmp14_ = _tmp12_[_tmp13_];
				_tmp15_ = g_strdup (_tmp14_);
				str_token = _tmp15_;
				_tmp16_ = str_token;
				_tmp17_ = token;
				if (g_strcmp0 (_tmp16_, _tmp17_) == 0) {
					result = (guint) 3;
					_g_free0 (str_token);
					str_tokens = (_vala_array_free (str_tokens, str_tokens_length1, (GDestroyNotify) g_free), NULL);
					alternates = (_vala_array_free (alternates, alternates_length1, (GDestroyNotify) g_free), NULL);
					return result;
				} else {
					const gchar* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					gboolean _tmp20_ = FALSE;
					_tmp18_ = str_token;
					_tmp19_ = token;
					_tmp20_ = g_str_has_prefix (_tmp18_, _tmp19_);
					if (_tmp20_) {
						result = (guint) 2;
						_g_free0 (str_token);
						str_tokens = (_vala_array_free (str_tokens, str_tokens_length1, (GDestroyNotify) g_free), NULL);
						alternates = (_vala_array_free (alternates, alternates_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
				}
				_g_free0 (str_token);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp21_ = FALSE;
			_tmp21_ = TRUE;
			while (TRUE) {
				gchar** _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				gint _tmp24_ = 0;
				const gchar* _tmp25_ = NULL;
				gchar* str_token = NULL;
				gchar** _tmp26_ = NULL;
				gint _tmp26__length1 = 0;
				gint _tmp27_ = 0;
				const gchar* _tmp28_ = NULL;
				gchar* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
				if (!_tmp21_) {
					gint _tmp22_ = 0;
					_tmp22_ = i;
					i = _tmp22_ + 1;
				}
				_tmp21_ = FALSE;
				_tmp23_ = alternates;
				_tmp23__length1 = alternates_length1;
				_tmp24_ = i;
				_tmp25_ = _tmp23_[_tmp24_];
				if (!(_tmp25_ != NULL)) {
					break;
				}
				_tmp26_ = alternates;
				_tmp26__length1 = alternates_length1;
				_tmp27_ = i;
				_tmp28_ = _tmp26_[_tmp27_];
				_tmp29_ = g_strdup (_tmp28_);
				str_token = _tmp29_;
				_tmp30_ = str_token;
				_tmp31_ = token;
				if (g_strcmp0 (_tmp30_, _tmp31_) == 0) {
					result = (guint) 2;
					_g_free0 (str_token);
					str_tokens = (_vala_array_free (str_tokens, str_tokens_length1, (GDestroyNotify) g_free), NULL);
					alternates = (_vala_array_free (alternates, alternates_length1, (GDestroyNotify) g_free), NULL);
					return result;
				} else {
					const gchar* _tmp32_ = NULL;
					const gchar* _tmp33_ = NULL;
					gboolean _tmp34_ = FALSE;
					_tmp32_ = str_token;
					_tmp33_ = token;
					_tmp34_ = g_str_has_prefix (_tmp32_, _tmp33_);
					if (_tmp34_) {
						result = (guint) 1;
						_g_free0 (str_token);
						str_tokens = (_vala_array_free (str_tokens, str_tokens_length1, (GDestroyNotify) g_free), NULL);
						alternates = (_vala_array_free (alternates, alternates_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
				}
				_g_free0 (str_token);
			}
		}
	}
	result = (guint) 0;
	str_tokens = (_vala_array_free (str_tokens, str_tokens_length1, (GDestroyNotify) g_free), NULL);
	alternates = (_vala_array_free (alternates, alternates_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


const gchar* folks_simple_query_get_query_string (FolksSimpleQuery* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_query_string;
	result = _tmp0_;
	return result;
}


void folks_simple_query_set_query_string (FolksSimpleQuery* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	if (_tmp0_ == NULL) {
		value = "";
	}
	_tmp1_ = self->priv->_query_string;
	_tmp2_ = value;
	if (g_strcmp0 (_tmp1_, _tmp2_) == 0) {
		return;
	}
	_tmp3_ = value;
	_tmp4_ = self->priv->_query_locale;
	_folks_simple_query_update_query_string (self, _tmp3_, _tmp4_);
	g_object_notify ((GObject *) self, "query-string");
}


const gchar* folks_simple_query_get_query_locale (FolksSimpleQuery* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_query_locale;
	result = _tmp0_;
	return result;
}


void folks_simple_query_set_query_locale (FolksSimpleQuery* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_query_locale;
	_tmp1_ = value;
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
		return;
	}
	_tmp2_ = self->priv->_query_string;
	_tmp3_ = value;
	_folks_simple_query_update_query_string (self, _tmp2_, _tmp3_);
	g_object_notify ((GObject *) self, "query-locale");
}


static void folks_simple_query_class_init (FolksSimpleQueryClass * klass) {
	folks_simple_query_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksSimpleQueryPrivate));
	((FolksQueryClass *) klass)->is_match = folks_simple_query_real_is_match;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_simple_query_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_simple_query_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_simple_query_finalize;
	/**
	   * The text query string.
	   *
	   * This re-evaluates the query immediately, so most clients should implement
	   * de-bouncing to ensure re-evaluation only happens when (for example) the
	   * user has stopped typing a new query.
	   *
	   * @since 0.11.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_SIMPLE_QUERY_QUERY_STRING, g_param_spec_string ("query-string", "query-string", "query-string", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * Locale to interpret the {@link SimpleQuery.query_string} in.
	   *
	   * If possible, locale-specific query string transliteration is done to
	   * increase the number of matches. Set this property to a POSIX locale name
	   * (e.g. ‘en’, ‘de_DE’, ‘de_DE@euro’ or ‘C’) to potentially improve the
	   * transliteration performed.
	   *
	   * This may be `null` if the locale is unknown, in which case the current
	   * locale will be used. To perform transliteration for no specific locale,
	   * use `C`.
	   *
	   * @since 0.11.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_SIMPLE_QUERY_QUERY_LOCALE, g_param_spec_string ("query-locale", "query-locale", "query-locale", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void folks_simple_query_instance_init (FolksSimpleQuery * self) {
	self->priv = FOLKS_SIMPLE_QUERY_GET_PRIVATE (self);
	self->priv->_query_locale = NULL;
}


static void folks_simple_query_finalize (GObject* obj) {
	FolksSimpleQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_SIMPLE_QUERY, FolksSimpleQuery);
	_g_free0 (self->priv->_query_string);
	self->priv->_query_tokens = (_vala_array_free (self->priv->_query_tokens, self->priv->_query_tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_query_locale);
	G_OBJECT_CLASS (folks_simple_query_parent_class)->finalize (obj);
}


/**
 * A simple text-based contact query.
 *
 * This is a generic implementation of the {@link Query} interface which
 * supports general UI-style search use cases. It implements case-insensitive
 * prefix matching, with transliteration of accents and other non-ASCII
 * characters to improve matching against accented characters. It also
 * normalises phone numbers to make matches invariant to hyphenation and spacing
 * in phone numbers.
 *
 * @see SearchView
 * @since 0.11.0
 */
GType folks_simple_query_get_type (void) {
	static volatile gsize folks_simple_query_type_id__volatile = 0;
	if (g_once_init_enter (&folks_simple_query_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksSimpleQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_simple_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksSimpleQuery), 0, (GInstanceInitFunc) folks_simple_query_instance_init, NULL };
		GType folks_simple_query_type_id;
		folks_simple_query_type_id = g_type_register_static (FOLKS_TYPE_QUERY, "FolksSimpleQuery", &g_define_type_info, 0);
		g_once_init_leave (&folks_simple_query_type_id__volatile, folks_simple_query_type_id);
	}
	return folks_simple_query_type_id__volatile;
}


static void _vala_folks_simple_query_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksSimpleQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_SIMPLE_QUERY, FolksSimpleQuery);
	switch (property_id) {
		case FOLKS_SIMPLE_QUERY_QUERY_STRING:
		g_value_set_string (value, folks_simple_query_get_query_string (self));
		break;
		case FOLKS_SIMPLE_QUERY_QUERY_LOCALE:
		g_value_set_string (value, folks_simple_query_get_query_locale (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_simple_query_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksSimpleQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_SIMPLE_QUERY, FolksSimpleQuery);
	switch (property_id) {
		case FOLKS_SIMPLE_QUERY_QUERY_STRING:
		folks_simple_query_set_query_string (self, g_value_get_string (value));
		break;
		case FOLKS_SIMPLE_QUERY_QUERY_LOCALE:
		folks_simple_query_set_query_locale (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



