/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.gjt.jclasslib.browser.BrowserMDIFrame;
import org.gjt.jclasslib.util.GUIHelper;

public class RecentMenu
extends JMenu
implements ActionListener {
    private static final int RECENT_PROJECTS_MAX_SIZE = 10;
    private static final String SETTINGS_RECENT_WORKSPACES = "recentWorkspaces";
    private static final String ACTION_CLEAR_LIST = "clearList";
    private BrowserMDIFrame frame;
    private LinkedList recentWorkspaces = new LinkedList();

    public RecentMenu(BrowserMDIFrame browserMDIFrame) {
        this.frame = browserMDIFrame;
        this.setText("Reopen workspace");
        this.setIcon(GUIHelper.ICON_EMPTY);
    }

    public void menuSelectionChanged(boolean bl) {
        super.menuSelectionChanged(bl);
        this.updateContents();
    }

    public void actionPerformed(final ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(ACTION_CLEAR_LIST)) {
            this.recentWorkspaces.clear();
        } else {
            this.setPopupMenuVisible(false);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RecentMenu.this.frame.openWorkspace(new File(((JMenuItem)actionEvent.getSource()).getText()));
                }
            });
        }
    }

    public void addRecentWorkspace(File file) {
        try {
            String string = file.getCanonicalFile().getAbsolutePath();
            this.recentWorkspaces.remove(string);
            this.recentWorkspaces.addFirst(string);
            if (this.recentWorkspaces.size() > 10) {
                this.recentWorkspaces.removeLast();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void read(Preferences preferences) {
        this.recentWorkspaces.clear();
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        Preferences preferences2 = preferences.node(SETTINGS_RECENT_WORKSPACES);
        try {
            String[] stringArray = preferences2.keys();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = preferences2.get(string, null);
                if (string2 == null) continue;
                treeMap.put(new Integer(string), string2);
            }
            this.recentWorkspaces.addAll(treeMap.values());
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public void save(Preferences preferences) {
        Preferences preferences2 = preferences.node(SETTINGS_RECENT_WORKSPACES);
        try {
            preferences2.clear();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        int n = 0;
        Iterator iterator = this.recentWorkspaces.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            preferences2.put(String.valueOf(n++), string);
        }
    }

    private void updateContents() {
        this.removeAll();
        if (this.recentWorkspaces.size() > 0) {
            Object object;
            Iterator iterator = this.recentWorkspaces.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                JMenuItem jMenuItem = new JMenuItem((String)object);
                jMenuItem.addActionListener(this);
                this.add(jMenuItem);
            }
            this.addSeparator();
            object = new JMenuItem("Clear list");
            ((AbstractButton)object).setActionCommand(ACTION_CLEAR_LIST);
            ((AbstractButton)object).addActionListener(this);
            this.add((JMenuItem)object);
        } else {
            JMenuItem jMenuItem = new JMenuItem("(Empty)");
            jMenuItem.setEnabled(false);
            this.add(jMenuItem);
        }
    }
}

