/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractTool;

public class SelectAreaTracker
extends AbstractTool {
    private Rectangle fSelectGroup;
    private Color fRubberBandColor;

    public SelectAreaTracker(DrawingEditor drawingEditor) {
        this(drawingEditor, Color.black);
    }

    public SelectAreaTracker(DrawingEditor drawingEditor, Color color) {
        super(drawingEditor);
        this.fRubberBandColor = color;
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDown(mouseEvent, mouseEvent.getX(), mouseEvent.getY());
        this.rubberBand(this.getAnchorX(), this.getAnchorY(), this.getAnchorX(), this.getAnchorY());
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDrag(mouseEvent, mouseEvent.getX(), mouseEvent.getY());
        this.eraseRubberBand();
        this.rubberBand(this.getAnchorX(), this.getAnchorY(), mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        this.eraseRubberBand();
        this.selectGroup(mouseEvent.isShiftDown());
        super.mouseUp(mouseEvent, mouseEvent.getX(), mouseEvent.getY());
    }

    private void rubberBand(int n, int n2, int n3, int n4) {
        this.fSelectGroup = new Rectangle(new Point(n, n2));
        this.fSelectGroup.add(new Point(n3, n4));
        this.drawXORRect(this.fSelectGroup);
    }

    private void eraseRubberBand() {
        this.drawXORRect(this.fSelectGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawXORRect(Rectangle rectangle) {
        Graphics graphics = this.view().getGraphics();
        if (graphics != null) {
            try {
                if (graphics instanceof Graphics2D) {
                    BasicStroke basicStroke = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{5.0f, 5.0f, 5.0f, 5.0f}, 5.0f);
                    ((Graphics2D)graphics).setStroke(basicStroke);
                }
                graphics.setXORMode(this.view().getBackground());
                graphics.setColor(this.fRubberBandColor);
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    private void selectGroup(boolean bl) {
        FigureEnumeration figureEnumeration = this.drawing().figuresReverse();
        while (figureEnumeration.hasNextFigure()) {
            Figure figure = figureEnumeration.nextFigure();
            Rectangle rectangle = figure.displayBox();
            if (!this.fSelectGroup.contains(rectangle.x, rectangle.y) || !this.fSelectGroup.contains(rectangle.x + rectangle.width, rectangle.y + rectangle.height)) continue;
            if (bl) {
                this.view().toggleSelection(figure);
                continue;
            }
            this.view().addToSelection(figure);
        }
    }
}

