/*
             Common Public License Version 0.5

             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.

             1. DEFINITIONS

             "Contribution" means: 
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and 

                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;

                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.


             "Contributor" means any person or entity that distributes
             the Program.

             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program. 

             "Program" means the Contributions distributed in
             accordance with this Agreement.

             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.

             2. GRANT OF RIGHTS

                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.

                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.

                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.

                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.

             3. REQUIREMENTS

             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and

                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;

                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;

                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and

                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program. 

             Contributors may not remove or alter any copyright notices
             contained within the Program.

             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution. 


             4. COMMERCIAL DISTRIBUTION

             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.


             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.


             5. NO WARRANTY

             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations. 

             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL

             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.


             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.

             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive. 

             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.


             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation. 



*/

/* (C) COPYRIGHT International Business Machines Corp. 2001,2002          */


#include <pthread.h>
#include <stdlib.h>
#include <stdio.h>
#include <dlfcn.h>
#include <errno.h>
#include <sys/syslog.h>

#include <sys/ipc.h>

#include <stdarg.h>
#include <pthread.h>

#include <pkcs11types.h>

#include "defs.h"
#include "host_defs.h"

#include "tok_spec_struct.h"
extern token_spec_t token_specific;

#include "tokenlocal.h"



#include "msg.h"  // HACK  

void stlogit(char *, ...);
//extern char **err_msg;

#include <sys/types.h>
#include <sys/stat.h>

#if 0
extern FILE  *debugfile;
char  lfname[1024];
#else
extern int  debugfile;
#endif
pthread_mutex_t  lmtx=PTHREAD_MUTEX_INITIALIZER;

static int enabled=0;
static int logging=0;
static int env_log_check=0; 

// Logging types.  Ultimately this will allow
// us to log to different log files.  The logger will also
// handle keeping the files to a decent size.
// Much work needs to be done on this capability... 
// Other logging types need to be implemented

void 
stloginit(){
   char *logval;
   if (!env_log_check){
      logval = getenv("PKCS_ERROR_LOG");
      env_log_check = 1;
      if (logval != NULL)
         logging = 1;
      else
         logging = 0;
   }
   if (!enabled && logging){
      enabled=1;
      openlog((const char *)DBGTAG,LOG_PID|LOG_NDELAY,LOG_LOCAL6);
      setlogmask(LOG_UPTO(LOG_DEBUG));


#ifdef DEBUG
      debugfile = 1;
#else
      debugfile = 0;
#endif
#if 0
      sprintf(lfname,"%s/%s.%d",CONFIG_PATH,DBGTAG,getpid());
      debugfile = fopen(lfname,"w+");
      if (debugfile) {
         fchmod(fileno(debugfile),
         S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH);
      }
#endif
      stlogit("Log initialized");
   }
}

void
stlogterm()
{
  enabled = 0;
}

void
stlogit2(int type,char *fmt, ...)
{
      va_list pvar;
      char buffer[4096*4];
//      char buf1[4096];

   if (!enabled)  stloginit();

   if ( enabled && debugfile){
//         sprintf(buf1,"Tid %d",pthread_self());
//         syslog_r(LOG_DEBUG,&log_data,buf1);
         va_start(pvar, fmt);
         vsprintf(buffer,fmt,pvar);
         va_end(pvar);
         pthread_mutex_lock(&lmtx);
         syslog(LOG_DEBUG,buffer);
         pthread_mutex_unlock(&lmtx);
#if 0
	if (debugfile) {
         pthread_mutex_lock(&lmtx);
         fprintf(debugfile,"[%d]:%s\n",getpid(),buffer);
          fflush(debugfile);
         pthread_mutex_unlock(&lmtx);
 	}
#endif
   }

}



void
stlogit(char *fmt, ...)
{
      va_list pvar;
      char buffer[4096*4];

   if (!enabled)  stloginit();

   if ( enabled && debugfile){
         va_start(pvar, fmt);
         vsprintf(buffer,fmt,pvar);
         va_end(pvar);
         pthread_mutex_lock(&lmtx);
         syslog(LOG_DEBUG,buffer);
         pthread_mutex_unlock(&lmtx);
#if 0
	if (debugfile) {
         pthread_mutex_lock(&lmtx);
         fprintf(debugfile,"[%d]:%s\n",getpid(),buffer);
          fflush(debugfile);
         pthread_mutex_unlock(&lmtx);
 	}
#endif
   }

}

/* moved in from msg.h */

struct messages err_msg[]={
		{"Malloc Failed"},
		{"Not Enough Memory in Context"},
		{"Slot Invalid"},
		{"General Error"},
		{"%s Function Failed"},
		//#5
		{"%s Bad Arguments"},
		{"No Event"},
		{"Attribute Read Only"},
		{"Attribute Type Invalid"},
		{"Attribute Value Invalid"},
		//#10
		{"Data Invalid"},
		{"Data Length out of Range"},
		{"Device Error"},
		{"Device Removed"},
		{"Encrypted Data Invalid"},
		//15
		{"Encrypted Data Length out of Range"},
		{"Function Cancelled"},
		{"Function Not Parallel"},
		{"Key Handle Invalid"},
		{"Key Size out of Range"},
		//20
		{"Key Type Inconsistent"},
		{"Key Not Needed"},
		{"Key Changed"},
		{"Key Needed"},
		{"Key Indigestible"},
		//25
		{"Key Function Not Permitted"},
		{"Key Not Wrappable"},
		{"Key Unextractable"},
		{"Mechanism Invalid"},
		{"Mechanism Param Invalid"},
		//30
		{"Object Handle Invalid"},
		{"Operation Active"},
		{"Operation Not Initialized"},
		{"Pin Incorrect"},
		{"Pin Invalid"},
		//35
		{"Pin Length out of Range"},
		{"Pin Expired"},
		{"Pin Locked"},
		{"Session Closed"},
		{"Session Count"},
		//40
		{"Session Handle Invalid"},
		{"Parallel Session Not Supported"},
		{"Session Read Only"},
		{"Session Exists"},
		{"Session Read only Exists"},
		//45
		{"Session Read Write Exists"},
		{"Signature Length out of Range"},
		{"Signature Invalid"},
		{"Template Incomplete"},
		{"Template Inconsistent"},
		//50
		{"Token Not Present"},
		{"Token Not Recognized"},
		{"Token Write Protected"},
		{"Unwrapping Key Handle Invalid"},
		{"Unwrapping Key Size Range Invalid"},
		//55
		{"Unwrapping Key Type Inconsistent"},
		{"User Already Logged In"},
		{"User Not Logged In"},
		{"User PIN Not Initialized"},
		{"User Type Invalid"},
		//60
		{"Another User Already Logged In"},
		{"Too Many User Types"},
		{"Wrapped Key Invalid"},
		{"Wrapped Key Length Out of Range"},
		{"Wrapping Key Size out of Range"},
		//65
		{"Wrapping Key Type Inconsistent"},
		{"Random Seed Not Supported"},
		{"Random Number Invalid"},
		{"Buffer Too Small"},
		{"Saved State Invalid"},
		//70
		{"Information Sensitive"},
		{"State Unsaveable"},
		{"API not initialized"},
		{"API already Initialized"},
		{"Mutex Bad"},
		//75
		{"Mutex Lock Invalid"},
		{"Encode Integer Failed"},
		{"Encode Octet String Failed"},
		{"Encode Sequence Failed"},
		{"Decode Integer Failed"},
		//80
		{"Decode Octet String Failed"},
		{"Decode Sequence Failed"},
		{"Encode Private Key Failed"},
		{"Decode Private Key Failed"},
		{"Build Attribute Failed"},
		//85
		{"Function Not Permitted"},
		{"Key Not Exportable"},
		{"Encode Private Key failed"},
		{"Decode Private Key failed"},
		{"Object Mgr Create Skeleton failed"},
		//90
		{"Object Mgr Create Final failed"},
		{"Key Generation failed"},
		{"DES Wrap Get Data Failed"},
		{"DES3 Wrap Get Data Failed"},
		{"RSA Wrap Get Data Failed"},
		//95
		{"DSA Wrap Get Data Failed"},
		{"Generic Secret Wrap Get Data Failed"},
		{"DES Wrap Format Failed"},
		{"Encryption Mgr Init Failed"},
		{"Encryption Mgr Encrypt Failed"},
		//100
		{"Decryption Mgr Decrypt Failed"},
		{"Flatten Object Failed"},
		{"Key Mgr Get Priv Key Type Failed"},
		{"Decrypt Private Key Info Failed"},
		{"Save Token Failed"},
		//105
		{"Triple DES CBC Encrypt Failed"},
		{"Triple DES CBC Decrypt Failed"},
		{"Restore Private Token Failed"},
		{"Restore Object Failed"},
		{"Data Length Out of Range"},
		//110
		{"Object Manager Find in Map Failed"},
		{"Token Specific RNG Failed"},
		{"Encrypted Data Length Out of Range"},
		{"DES CBC Encrypt Failed"},
		{"DES CBC Decrypt Failed"},
		//115
		{"DES ECB Encrypt Failed"},
		{"DES ECB Decrypt Failed"},
		{"Token Specific DES ECB Failed"},
		{"Token Specific DES CBC Failed"},
		{"Token Specific 3DES CBC Failed"},
		//120
		{"Token Specific 3DES ECB Failed"},
		{"DSA Verify Failed"},
		{"DSA Sign Failed"},
		{"Digest Init Failed"},
		{"Digest Failed"},
		//125
		{"Digest Update Failed"},
		{"Digest Final Failed"},
		{"Sign Init Failed"},
		{"Sign Update Failed"},
		{"Sign Final Failed"},
		//130
		{"Random Number Generate Failed"},
		{"RSA Format Block Failed"},
		{"RSA Encrypt Failed"},
		{"RSA Decrypt Failed"},
		{"Token Specific RSA Encrypt Failed"},
		//135
		{"Token Specific RSA Decrypt Failed"},
		{"SSL SHA Failed"},
		{"SSL3 MD5 Failed"},
		{"SSL3 Process MAC Keys Failed"},
		{"SSL3 Process Write Keys Failed"},
		//140
		{"Validate Attribute Failed"},
		{"SSL3 Process Write Keys Failed"},
		{"%s Function Not Supported"},
		{"Token Already Initialized"},
		{"Cannot Attach to Shared Memory"},
		//145
		{"Token Specific Init Failed"},
		{"Mutex Lock Failed"},
		{"Mutex Unlock Failed"},
		{"Hash Computation Failed"},
		{"Save Master Key Failed"},
		//150
		{"Process Lock Failed"},
		{"Process Unlock Failed"},
		{"Session Mgr New Failed"},
		{"Close all Sessions Failed"},
		{"Session Mgr Get Op State Failed"},
		//155
		{"Load Master Key Failed"},
		{"Object Create Failed"},
		{"Object Mgr Add to Map Failed"},
		{"Object Copy Failed"},
		{"Object Get Attribute Values Failed"},
		//160
		{"Object Restore Data Failed"},
		{"Object Set Attribute Values Failed"},
		{"Object Mgr Search for Object Failed"},
		{"Copy Template Failed"},
		{"Add Attribute Failed"},
		//165
		{"Check Required Attributes Failed"},
		{"Unflatten Template Failed"},
		{"Verify Init Failed"},
		{"Verify Failed"},
		{"Verify Update Failed"},
		//170
		{"Verify Final Failed"},
		{"Sign Failed"},
		{"Set Default Attributes Failed"},
		{"Unwrap Key Failed"},
		{"Session Mgr New Failed"},
		//175
		{"Merge Attributes Failed"},
		{"Encryption Mgr Encrypt Update Failed"},
		{"Encryption Mgr Encrypt Final Failed"},
		{"Update Attribute Failed"},
		{"Decryption Mgr Init Failed"},
		//180
		{"Decryption Mgr Update Failed"},
		{"Decryption Mgr Final Failed"},
		{"Object Mgr Destroy Failed"},
		{"Attribute Undefined"},
		{"Object Mgr Get Size Failed"},
		//185
		{"Object Manager Find Init Failed"},
		{"Sign Recover Failed"},
		{"Verify Recover Failed"},
		{"Wrap Key Failed"},
		{"Unwrap Key Failed"},
		//190
		{"Derive Key Failed"},
		{"AES Wrap Get Data Failed"},
		{"AES Wrap Format Failed"},
		{"Domain Parameter Invalid"},
		{"File \"%s\" could not be opened, errno=%d"}
};

