/* ----------------------------------------------------------------------------
 * pbb_list.c
 *
 * Copyright 2002-2005 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdlib.h>
#include <string.h>

#include "pbblist.h"

/*     +--------+
 * +-> |first   | --+
 * |   |tail    | <-+   tail is always NULL: no predecessor (pred) 
 * +-- |tailpred|       for 'first' and no successor (next) for 'tail'
 *     +--------+       The header is first and last node of the list.
 */
void
initListHeader (struct listhead *lh)
{
	lh->first    = (struct listnode *) &lh->tail;
	lh->tail     = NULL;
	lh->tailpred = (struct listnode *) &lh->first;
}

void
freeList (struct listhead *lh)
{
	struct listnode *it = lh->first;

	while ((it = it->next))
		free (it->pred);

	initListHeader (lh);
}

/* append new node to the end of the list
 */
void
appendListNode (struct listhead *lh, struct listnode *ln)
{
	ln->next = lh->tailpred->next;
	ln->pred = lh->tailpred;
	lh->tailpred->next = ln;
	lh->tailpred = ln;
}

/* remove node from list
 */
struct listnode*
removeListNode (struct listnode *ln)
{
	if (ln) {
		ln->pred->next = ln->next;
		ln->next->pred = ln->pred;
		ln->next = NULL;
		ln->pred = NULL;
	}
	return ln;
}

/* remove node from list if it is still part of one
 * and free memory
 */
void
freeListNode (struct listnode *ln)
{
	if (ln->next)           /* is node part of a list? */
		ln = removeListNode (ln);  /* then remove node from list */
	free (ln);
}

/* get memory for a new list node and extend the allocation by
 * datalen. This buffer behind the node structure is for user
 * data.
 */
struct listnode*
newListNode (int datalen)
{
	struct listnode *newnode;
	
	if ((newnode = malloc (sizeof (struct listnode) + datalen))) {
		bzero (newnode, sizeof (struct listnode) + datalen);
		newnode->datalen = datalen;
	}
	return newnode;
}

void *
getNodeData (struct listnode *ln)
{
	return (char *) ln + sizeof (struct listnode);
}

void *
getNodeDataEnd (struct listnode *ln)
{
	return (char *) ln + sizeof (struct listnode) + ln->datalen;
}

int
getNodeCount (struct listhead *lh)
{
	struct listnode *it = lh->first;
	int n = 0;
	
	while ((it = it->next))
		n++;
	return n;
}


