/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.pilotlink;

import java.util.Date;
import java.util.GregorianCalendar;

public abstract class Record {
    public static final int DELETED = 128;
    public static final int DIRTY = 64;
    public static final int BUSY = 32;
    public static final int SECRET = 16;
    public static final int ARCHIVED = 8;
    protected long id;
    protected int attribs;
    protected int category;
    protected int size;

    public Record() {
        this.id = 0L;
        this.attribs = 0;
        this.category = 0;
        this.size = 0;
    }

    public boolean isDeleted() {
        return (this.attribs & 0x80) != 0;
    }

    public boolean isSecret() {
        return (this.attribs & 0x10) != 0;
    }

    public boolean isArchived() {
        return (this.attribs & 8) != 0;
    }

    public boolean isDirty() {
        return (this.attribs & 0x40) != 0;
    }

    public boolean isBusy() {
        return (this.attribs & 0x20) != 0;
    }

    public void setDirty(boolean bl) {
        this.attribs = bl ? (this.attribs |= 0x40) : (this.attribs &= 0xFFFFFFBF);
    }

    public void setSecret(boolean bl) {
        this.attribs = bl ? (this.attribs |= 0x10) : (this.attribs &= 0xFFFFFFEF);
    }

    public void setArchived(boolean bl) {
        this.attribs = bl ? (this.attribs |= 8) : (this.attribs &= 0xFFFFFFF7);
    }

    public Record(int n, int n2, int n3, int n4) {
        this.size = n4;
        this.id = n;
        this.attribs = n2;
        this.category = n3;
    }

    public Record(Record record) {
        this.size = record.getSize();
        this.id = record.getId();
        this.attribs = record.getAttribs();
        this.category = record.getCategory();
        this.setBuffer(record.getBuffer());
    }

    public void setId(long l) {
        this.id = l;
    }

    public int getCategory() {
        return this.category;
    }

    public void setCategory(int n) {
        this.category = n;
    }

    public void setAttribs(int n) {
        this.attribs = n;
    }

    public int getAttribs() {
        return this.attribs;
    }

    public long getId() {
        return this.id;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public abstract byte[] getBuffer();

    public abstract void setBuffer(byte[] var1);

    public Date getDateAt(int n) {
        return Record.getDateAt(this.getBuffer(), n);
    }

    public static Date getDateAt(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFF) * 256 + (byArray[n + 1] & 0xFF);
        int n3 = n2 & 0xFE00;
        n3 >>= 9;
        int n4 = n2 & 0x1E0;
        n4 >>= 5;
        int n5 = n2 & 0x1F;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n3 += 1904, --n4, n5);
        return gregorianCalendar.getTime();
    }

    public static void setDateAt(byte[] byArray, Date date, int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        int n2 = 0;
        int n3 = gregorianCalendar.get(1);
        int n4 = gregorianCalendar.get(2);
        int n5 = gregorianCalendar.get(5);
        n3 -= 1904;
        ++n4;
        n2 = (n3 <<= 9) | (n4 <<= 5) | n5;
        byArray[n + 1] = (byte)(n2 & 0xFF);
        byArray[n] = (byte)((n2 & 0xFF00) >> 8);
    }

    public static void setDateTimeAt(byte[] byArray, Date date, int n, int n2) {
        Record.setDateAt(byArray, date, n);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        int n3 = gregorianCalendar.get(11);
        int n4 = gregorianCalendar.get(12);
        byArray[n2] = (byte)n3;
        byArray[n2 + 1] = (byte)n4;
    }

    public Date getDateTimeAt(int n, int n2) {
        return Record.getDateTimeAt(this.getBuffer(), n, n2);
    }

    public static Date getDateTimeAt(byte[] byArray, int n, int n2) {
        int n3 = (byArray[n] & 0xFF) * 256 + (byArray[n + 1] & 0xFF);
        int n4 = n3 & 0xFE00;
        n4 >>= 9;
        n4 += 1904;
        int n5 = n3 & 0x1E0;
        n5 >>= 5;
        int n6 = n3 & 0x1F;
        int n7 = byArray[n2] & 0xFF;
        int n8 = byArray[n2 + 1] & 0xFF;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n4, --n5, n6, n7, n8, 0);
        return gregorianCalendar.getTime();
    }

    public static int setStringAt(byte[] byArray, String string, int n) {
        if (string == null) {
            return n;
        }
        byte[] byArray2 = string.getBytes();
        for (int i = 0; i < byArray2.length; ++i) {
            byArray[n + i] = string.charAt(i) == '\ufffd' ? -4 : (string.charAt(i) == '\ufffd' ? -10 : (string.charAt(i) == '\ufffd' ? -28 : (string.charAt(i) == '\ufffd' ? -33 : (string.charAt(i) == '\ufffd' ? -60 : (string.charAt(i) == '\ufffd' ? -36 : (string.charAt(i) == '\ufffd' ? -42 : byArray2[i]))))));
        }
        byArray[n + byArray2.length] = 0;
        return n + byArray2.length + 1;
    }

    public String getStringAt(int n) {
        return Record.getStringAt(this.getBuffer(), n);
    }

    public static String getStringAt(byte[] byArray, int n) {
        String string = "";
        while (n < byArray.length && byArray[n] != 0) {
            string = byArray[n] + 256 == 252 ? string + "\ufffd" : (byArray[n] + 256 == 246 ? string + "\ufffd" : (byArray[n] + 256 == 228 ? string + "\ufffd" : (byArray[n] + 256 == 223 ? string + "\ufffd" : (byArray[n] + 256 == 196 ? string + "\ufffd" : (byArray[n] + 256 == 220 ? string + "\ufffd" : (byArray[n] + 256 == 214 ? string + "\ufffd" : string + (char)byArray[n]))))));
            ++n;
        }
        return string;
    }

    public static void setIntAt(byte[] byArray, int n, int n2) {
        byArray[n2 + 1] = (byte)(n & 0xFF);
        byArray[n2] = (byte)((n & 0xFF00) >> 8);
    }

    public int getIntAt(int n) {
        return Record.getIntAt(this.getBuffer(), n);
    }

    public static int getIntAt(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF);
    }

    public static double getDoubleAt(byte[] byArray, int n) {
        long l = Record.getDoubleLongAt(byArray, n);
        return Double.longBitsToDouble(l);
    }

    public static void setDoubleAt(byte[] byArray, double d, int n) {
        long l = Double.doubleToLongBits(d);
        Record.setDoubleLongAt(byArray, l, n);
    }

    public static long getDoubleLongAt(byte[] byArray, int n) {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                if ((byArray[i + n] & 1 << j) == 0) continue;
                l |= 1L << 56 - i * 8 + j;
            }
        }
        return l;
    }

    public static void setDoubleLongAt(byte[] byArray, long l, int n) {
        byArray[n + 0] = (byte)((l & 0xFF00000000000000L) >> 56);
        byArray[n + 1] = (byte)((l & 0xFF000000000000L) >> 48);
        byArray[n + 2] = (byte)((l & 0xFF0000000000L) >> 40);
        byArray[n + 3] = (byte)((l & 0xFF00000000L) >> 32);
        byArray[n + 4] = (byte)((l & 0xFF000000L) >> 24);
        byArray[n + 5] = (byte)((l & 0xFF0000L) >> 16);
        byArray[n + 6] = (byte)((l & 0xFF00L) >> 8);
        byArray[n + 7] = (byte)(l & 0xFFL);
    }

    public static void setLongAt(byte[] byArray, long l, int n) {
        byArray[n + 0] = (byte)((l & 0xFF000000L) >> 24);
        byArray[n + 1] = (byte)((l & 0xFF0000L) >> 16);
        byArray[n + 2] = (byte)((l & 0xFF00L) >> 8);
        byArray[n + 3] = (byte)(l & 0xFFL);
    }

    public static long getLongAt(byte[] byArray, int n) {
        long l = 0L;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 8; ++j) {
                if ((byArray[i + n] & 1 << j) == 0) continue;
                l |= 1L << 24 - i * 8 + j;
            }
        }
        return l;
    }
}

