/* Generated by re2c */
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2015 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Zeev Suraski <zeev@zend.com>                                |
   |          Jani Taskinen <jani@php.net>                                |
   |          Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   +----------------------------------------------------------------------+
*/

/* $Id$ */

#include <errno.h>
#include "zend.h"
#include "zend_API.h"
#include "zend_globals.h"
#include <zend_ini_parser.h>
#include "zend_ini_scanner.h"

#ifdef YYDEBUG
#undef YYDEBUG
#endif

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_ini_scanner_defs.h"

#define YYCTYPE   unsigned char
/* allow the scanner to read one null byte after the end of the string (from ZEND_MMAP_AHEAD)
 * so that if will be able to terminate to match the current token (e.g. non-enclosed string) */
#define YYFILL(n) { if (YYCURSOR > YYLIMIT) return 0; }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do {	YYCURSOR = (unsigned char*)yytext + x; \
							yyleng   = (unsigned int)x; } while(0)

/* #define yymore()     goto yymore_restart */

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 6
#if ZEND_MMAP_AHEAD < (YYMAXFILL + 1)
# error ZEND_MMAP_AHEAD should be greater than YYMAXFILL
#endif


/* How it works (for the core ini directives):
 * ===========================================
 *
 * 1. Scanner scans file for tokens and passes them to parser.
 * 2. Parser parses the tokens and passes the name/value pairs to the callback
 *    function which stores them in the configuration hash table.
 * 3. Later REGISTER_INI_ENTRIES() is called which triggers the actual
 *    registering of ini entries and uses zend_get_configuration_directive()
 *    to fetch the previously stored name/value pair from configuration hash table
 *    and registers the static ini entries which match the name to the value
 *    into EG(ini_directives) hash table.
 * 4. PATH section entries are used per-request from down to top, each overriding
 *    previous if one exists. zend_alter_ini_entry() is called for each entry.
 *    Settings in PATH section are ZEND_INI_SYSTEM accessible and thus mimics the
 *    php_admin_* directives used within Apache httpd.conf when PHP is compiled as
 *    module for Apache.
 * 5. User defined ini files (like .htaccess for apache) are parsed for each request and
 *    stored in separate hash defined by SAPI.
 */

/* TODO: (ordered by importance :-)
 * ===============================================================================
 *
 *  - Separate constant lookup totally from plain strings (using CONSTANT pattern)
 *  - Add #if .. #else .. #endif and ==, !=, <, > , <=, >= operators
 *  - Add #include "some.ini"
 *  - Allow variables to refer to options also when using parse_ini_file()
 *
 */

/* Globals Macros */
#define SCNG	INI_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id ini_scanner_globals_id;
#else
ZEND_API zend_ini_scanner_globals ini_scanner_globals;
#endif

/* Eat leading whitespace */
#define EAT_LEADING_WHITESPACE()                     \
	while (yytext[0]) {                              \
		if (yytext[0] == ' ' || yytext[0] == '\t') { \
			SCNG(yy_text)++;                         \
			yyleng--;                                \
		} else {                                     \
			break;                                   \
		}                                            \
	}

/* Eat trailing whitespace + extra char */
#define EAT_TRAILING_WHITESPACE_EX(ch)              \
	while (yyleng > 0 && (                          \
		(ch != 'X' && yytext[yyleng - 1] ==  ch) || \
		yytext[yyleng - 1] == '\n' ||               \
		yytext[yyleng - 1] == '\r' ||               \
		yytext[yyleng - 1] == '\t' ||               \
		yytext[yyleng - 1] == ' ')                  \
	) {                                             \
		yyleng--;                                   \
	}

/* Eat trailing whitespace */
#define EAT_TRAILING_WHITESPACE()	EAT_TRAILING_WHITESPACE_EX('X')

#define zend_ini_copy_value(retval, str, len)	\
	ZVAL_NEW_STR(retval, zend_string_init(str, len, 1))


#define RETURN_TOKEN(type, str, len) {                       \
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_TYPED) {      \
		zend_ini_copy_typed_value(ini_lval, type, str, len); \
	} else {                                                 \
		zend_ini_copy_value(ini_lval, str, len);             \
	}                                                        \
	return type;                                             \
}

static inline int convert_to_number(zval *retval, const char *str, const int str_len)
{
	zend_uchar type;
	int overflow;
	zend_long lval;
	double dval;

	if ((type = is_numeric_string_ex(str, str_len, &lval, &dval, 0, &overflow)) != 0) {
		if (type == IS_LONG) {
			ZVAL_LONG(retval, lval);
			return SUCCESS;
		} else if (type == IS_DOUBLE && !overflow) {
			ZVAL_DOUBLE(retval, dval);
			return SUCCESS;
		}
	}

	return FAILURE;
}

static void zend_ini_copy_typed_value(zval *retval, const int type, const char *str, int len)
{
	switch (type) {
		case BOOL_FALSE:
		case BOOL_TRUE:
			ZVAL_BOOL(retval, type == BOOL_TRUE);
			break;

		case NULL_NULL:
			ZVAL_NULL(retval);
			break;

		case TC_NUMBER:
			if (convert_to_number(retval, str, len) == SUCCESS) {
				break;
			}
			/* intentional fall-through */
		default:
			zend_ini_copy_value(retval, str, len);
	}
}

static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len)
{
	YYCURSOR = (YYCTYPE*)str;
	SCNG(yy_start) = YYCURSOR;
	YYLIMIT  = YYCURSOR + len;
}

#define ini_filename SCNG(filename)

/* {{{ init_ini_scanner()
*/
static int init_ini_scanner(int scanner_mode, zend_file_handle *fh)
{
	/* Sanity check */
	if (scanner_mode != ZEND_INI_SCANNER_NORMAL && scanner_mode != ZEND_INI_SCANNER_RAW && scanner_mode != ZEND_INI_SCANNER_TYPED) {
		zend_error(E_WARNING, "Invalid scanner mode");
		return FAILURE;
	}

	SCNG(lineno) = 1;
	SCNG(scanner_mode) = scanner_mode;
	SCNG(yy_in) = fh;

	if (fh != NULL) {
		ini_filename = zend_strndup(fh->filename, strlen(fh->filename));
	} else {
		ini_filename = NULL;
	}

	zend_stack_init(&SCNG(state_stack), sizeof(int));
	BEGIN(INITIAL);

	return SUCCESS;
}
/* }}} */

/* {{{ shutdown_ini_scanner()
*/
void shutdown_ini_scanner(void)
{
	zend_stack_destroy(&SCNG(state_stack));
	if (ini_filename) {
		free(ini_filename);
	}
}
/* }}} */

/* {{{ zend_ini_scanner_get_lineno()
*/
int zend_ini_scanner_get_lineno(void)
{
	return SCNG(lineno);
}
/* }}} */

/* {{{ zend_ini_scanner_get_filename()
*/
char *zend_ini_scanner_get_filename(void)
{
	return ini_filename ? ini_filename : "Unknown";
}
/* }}} */

/* {{{ zend_ini_open_file_for_scanning()
*/
int zend_ini_open_file_for_scanning(zend_file_handle *fh, int scanner_mode)
{
	char *buf;
	size_t size;

	if (zend_stream_fixup(fh, &buf, &size) == FAILURE) {
		return FAILURE;
	}

	if (init_ini_scanner(scanner_mode, fh) == FAILURE) {
		zend_file_handle_dtor(fh);
		return FAILURE;
	}

	yy_scan_buffer(buf, (unsigned int)size);

	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_prepare_string_for_scanning()
*/
int zend_ini_prepare_string_for_scanning(char *str, int scanner_mode)
{
	int len = (int)strlen(str);

	if (init_ini_scanner(scanner_mode, NULL) == FAILURE) {
		return FAILURE;
	}

	yy_scan_buffer(str, len);

	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_escape_string()
 */
static void zend_ini_escape_string(zval *lval, char *str, int len, char quote_type)
{
	register char *s, *t;
	char *end;

	zend_ini_copy_value(lval, str, len);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(lval);
	end = s + Z_STRLEN_P(lval);

	while (s < end) {
		if (*s == '\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				continue;
			}
			switch (*s) {
				case '"':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					Z_STRLEN_P(lval)--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			SCNG(lineno)++;
		}
		s++;
	}
	*t = 0;
}
/* }}} */

int ini_lex(zval *ini_lval)
{
restart:
	SCNG(yy_text) = YYCURSOR;

/* yymore_restart: */
	/* detect EOF */
	if (YYCURSOR >= YYLIMIT) {
		if (YYSTATE == STATE(ST_VALUE) || YYSTATE == STATE(ST_RAW)) {
			BEGIN(INITIAL);
			return END_OF_LINE;
		}
		return 0;
	}

	/* Eat any UTF-8 BOM we find in the first 3 bytes */
	if (YYCURSOR == SCNG(yy_start) && YYCURSOR + 3 < YYLIMIT) {
		if (memcmp(YYCURSOR, "\xef\xbb\xbf", 3) == 0) {
			YYCURSOR += 3;
			goto restart;
		}
	}

{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static void *yyctable[8] = {
		&&yyc_INITIAL,
		&&yyc_ST_OFFSET,
		&&yyc_ST_SECTION_VALUE,
		&&yyc_ST_VALUE,
		&&yyc_ST_SECTION_RAW,
		&&yyc_ST_DOUBLE_QUOTES,
		&&yyc_ST_VARNAME,
		&&yyc_ST_RAW,
	};
	goto *yyctable[YYGETCONDITION()];
/* *********************************** */
yyc_INITIAL:
	{
		static const unsigned char yybm[] = {
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 160,   0, 144, 144,   0, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			240, 128, 128, 144, 128, 144, 128, 144, 
			128, 128, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 144, 128, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 144, 144, 128, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 128, 128, 128, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
		};
		YYDEBUG(1, *YYCURSOR);
		YYFILL(5);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy6,  &&yy9,  &&yy3,  &&yy3,  &&yy11, &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy12, &&yy14, &&yy14, &&yy3,  &&yy14, &&yy3,  &&yy14, &&yy3,
				&&yy14, &&yy14, &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy16, &&yy3,  &&yy18, &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy21, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy22, &&yy23,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy24, &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy25, &&yy3,  &&yy26, &&yy3,  &&yy3,  &&yy14, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy21, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy22, &&yy23,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy24, &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy25, &&yy3,  &&yy14, &&yy14, &&yy14, &&yy14, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3
			};
			goto *yytarget[yych];
		}
yy3:
		YYDEBUG(3, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy4:
		YYDEBUG(4, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy5,  &&yy5,  &&yy3,  &&yy3,  &&yy5,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy5,  &&yy5,  &&yy3,  &&yy5,  &&yy3,  &&yy5,  &&yy3,
				&&yy5,  &&yy5,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy5,  &&yy3,  &&yy5,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy28, &&yy3,  &&yy3,  &&yy5,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3
			};
			goto *yytarget[yych];
		}
yy5:
		YYDEBUG(5, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get option name */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace */
	EAT_TRAILING_WHITESPACE();

	RETURN_TOKEN(TC_LABEL, yytext, yyleng);
}
yy6:
		YYDEBUG(6, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(7, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy6,  &&yy9,  &&yy8,  &&yy8,  &&yy11, &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy6,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy31, &&yy8,  &&yy18, &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8
			};
			goto *yytarget[yych];
		}
yy8:
		YYDEBUG(8, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* eat whitespace */
	goto restart;
}
yy9:
		YYDEBUG(9, *YYCURSOR);
		++YYCURSOR;
yy10:
		YYDEBUG(10, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy11:
		YYDEBUG(11, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy9;
		goto yy10;
yy12:
		YYDEBUG(12, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(13, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy6,  &&yy9,  &&yy3,  &&yy3,  &&yy11, &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy12, &&yy5,  &&yy5,  &&yy3,  &&yy5,  &&yy3,  &&yy5,  &&yy3,
				&&yy5,  &&yy5,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy31, &&yy3,  &&yy18, &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy28, &&yy3,  &&yy3,  &&yy5,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3
			};
			goto *yytarget[yych];
		}
yy14:
		YYDEBUG(14, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(15, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Disallow these chars outside option values */
	return yytext[0];
}
yy16:
		YYDEBUG(16, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy32;
		YYDEBUG(17, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy18:
		YYDEBUG(18, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(19, *YYCURSOR);
		if (yych == '\t') goto yy18;
		if (yych == ' ') goto yy18;
		YYDEBUG(20, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Start option value */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		yy_push_state(ST_RAW);
	} else {
		yy_push_state(ST_VALUE);
	}
	return '=';
}
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy36;
		if (yych == 'a') goto yy36;
		goto yy4;
yy22:
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy37,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy39, &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy37,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy39, &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4
			};
			goto *yytarget[yych];
		}
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy40, &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy41, &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy40, &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy41, &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4
			};
			goto *yytarget[yych];
		}
yy24:
		YYDEBUG(24, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy44;
		if (yych == 'r') goto yy44;
		goto yy4;
yy25:
		YYDEBUG(25, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy45;
		if (yych == 'e') goto yy45;
		goto yy4;
yy26:
		YYDEBUG(26, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(27, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Section start */
	/* Enter section data lookup state */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		yy_push_state(ST_SECTION_RAW);
	} else {
		yy_push_state(ST_SECTION_VALUE);
	}
	return TC_SECTION;
}
yy28:
		YYDEBUG(28, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(29, *YYCURSOR);
		if (yych == '\t') goto yy28;
		if (yych == ' ') goto yy28;
		YYDEBUG(30, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Start of option with offset */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace and [ */
	EAT_TRAILING_WHITESPACE_EX('[');

	/* Enter offset lookup state */
	yy_push_state(ST_OFFSET);

	RETURN_TOKEN(TC_OFFSET, yytext, yyleng);
}
yy31:
		YYDEBUG(31, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy32:
		YYDEBUG(32, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy31;
		}
		if (yych >= '\v') goto yy35;
yy33:
		YYDEBUG(33, *YYCURSOR);
		++YYCURSOR;
yy34:
		YYDEBUG(34, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy35:
		YYDEBUG(35, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy33;
		goto yy34;
yy36:
		YYDEBUG(36, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy46;
		if (yych == 'l') goto yy46;
		goto yy4;
yy37:
		YYDEBUG(37, *YYCURSOR);
		++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy47, &&yy38, &&yy4,  &&yy4,  &&yy38, &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy49, &&yy38, &&yy38, &&yy4,  &&yy38, &&yy4,  &&yy38, &&yy4,
				&&yy38, &&yy38, &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy38, &&yy4,  &&yy38, &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy51, &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy38, &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy51, &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy38, &&yy38, &&yy38, &&yy38, &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4
			};
			goto *yytarget[(yych = *YYCURSOR)];
		}
yy38:
		YYDEBUG(38, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
yy39:
		YYDEBUG(39, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy52;
		if (yych == 'l') goto yy52;
		goto yy4;
yy40:
		YYDEBUG(40, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy49;
		if (yych == 'f') goto yy49;
		goto yy4;
yy41:
		YYDEBUG(41, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(42, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy53, &&yy43, &&yy3,  &&yy3,  &&yy43, &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy41, &&yy43, &&yy43, &&yy3,  &&yy43, &&yy3,  &&yy43, &&yy3,
				&&yy43, &&yy43, &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy43, &&yy3,  &&yy43, &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy28, &&yy3,  &&yy3,  &&yy43, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy43, &&yy43, &&yy43, &&yy43, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3
			};
			goto *yytarget[yych];
		}
yy43:
		YYDEBUG(43, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
yy44:
		YYDEBUG(44, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy55;
		if (yych == 'u') goto yy55;
		goto yy4;
yy45:
		YYDEBUG(45, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy41;
		if (yych == 's') goto yy41;
		goto yy4;
yy46:
		YYDEBUG(46, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy51;
		if (yych == 's') goto yy51;
		goto yy4;
yy47:
		YYDEBUG(47, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(48, *YYCURSOR);
		if (yych == '\t') goto yy47;
		if (yych == ' ') goto yy47;
		goto yy38;
yy49:
		YYDEBUG(49, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(50, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy47, &&yy38, &&yy3,  &&yy3,  &&yy38, &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy49, &&yy38, &&yy38, &&yy3,  &&yy38, &&yy3,  &&yy38, &&yy3,
				&&yy38, &&yy38, &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy38, &&yy3,  &&yy38, &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy28, &&yy3,  &&yy3,  &&yy38, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy38, &&yy38, &&yy38, &&yy38, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3
			};
			goto *yytarget[yych];
		}
yy51:
		YYDEBUG(51, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy49;
		if (yych == 'e') goto yy49;
		goto yy4;
yy52:
		YYDEBUG(52, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy56;
		if (yych == 'l') goto yy56;
		goto yy4;
yy53:
		YYDEBUG(53, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(54, *YYCURSOR);
		if (yych == '\t') goto yy53;
		if (yych == ' ') goto yy53;
		goto yy43;
yy55:
		YYDEBUG(55, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy41;
		if (yych == 'e') goto yy41;
		goto yy4;
yy56:
		YYDEBUG(56, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(57, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy59, &&yy58, &&yy3,  &&yy3,  &&yy58, &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy56, &&yy58, &&yy58, &&yy3,  &&yy58, &&yy3,  &&yy58, &&yy3,
				&&yy58, &&yy58, &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy58, &&yy3,  &&yy58, &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy28, &&yy3,  &&yy3,  &&yy58, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy58, &&yy58, &&yy58, &&yy58, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3
			};
			goto *yytarget[yych];
		}
yy58:
		YYDEBUG(58, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(NULL_NULL, "", 0);
}
yy59:
		YYDEBUG(59, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(60, *YYCURSOR);
		if (yych == '\t') goto yy59;
		if (yych == ' ') goto yy59;
		goto yy58;
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		YYDEBUG(61, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '"') goto yy65;
		if (yych == '$') goto yy68;
		YYDEBUG(63, *YYCURSOR);
		++YYCURSOR;
yy64:
		YYDEBUG(64, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Escape double quoted string contents */
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				if (YYCURSOR < YYLIMIT && YYCURSOR[-2] == '\\' && *YYCURSOR != '\r' && *YYCURSOR != '\n') {
					continue;
				}
				break;
			case '$':
				if (*YYCURSOR == '{') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '"') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	zend_ini_escape_string(ini_lval, yytext, yyleng, '"');
	return TC_QUOTED_STRING;
}
yy65:
		YYDEBUG(65, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(66, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy65;
		}
		YYDEBUG(67, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string ends */
	yy_pop_state();
	return '"';
}
yy68:
		YYDEBUG(68, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '{') goto yy64;
		YYDEBUG(69, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(70, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
	}
/* *********************************** */
yyc_ST_OFFSET:
	{
		static const unsigned char yybm[] = {
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 140, 128, 132, 132, 128, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			140, 132, 128, 132, 192, 132, 132,   0, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			180, 180, 180, 180, 180, 180, 180, 180, 
			180, 180, 132, 128, 132, 132, 132, 132, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 192, 128, 132, 164, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
		};
		YYDEBUG(71, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy76, &&yy78, &&yy73, &&yy73, &&yy78, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy76, &&yy73, &&yy80, &&yy73, &&yy82, &&yy73, &&yy73, &&yy83,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy84, &&yy84, &&yy73,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy73, &&yy78, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88,
				&&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88,
				&&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88,
				&&yy88, &&yy88, &&yy88, &&yy73, &&yy91, &&yy92, &&yy73, &&yy88,
				&&yy73, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88,
				&&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88,
				&&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88,
				&&yy88, &&yy88, &&yy88, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73
			};
			goto *yytarget[yych];
		}
yy73:
		YYDEBUG(73, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy74:
		YYDEBUG(74, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy73;
		}
		if (yych <= '"') goto yy75;
		if (yych <= '$') goto yy94;
		if (yych <= ';') goto yy75;
		if (yych <= '\\') goto yy96;
yy75:
		YYDEBUG(75, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
yy76:
		YYDEBUG(76, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(77, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy76, &&yy75, &&yy73, &&yy73, &&yy75, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy76, &&yy73, &&yy80, &&yy73, &&yy94, &&yy73, &&yy73, &&yy75,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy75, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy96, &&yy92, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73
			};
			goto *yytarget[yych];
		}
yy78:
		YYDEBUG(78, *YYCURSOR);
		++YYCURSOR;
yy79:
		YYDEBUG(79, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy80:
		YYDEBUG(80, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(81, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
yy82:
		YYDEBUG(82, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy79;
			if (yych <= '[') goto yy73;
			goto yy97;
		} else {
			if (yych == '{') goto yy99;
			goto yy73;
		}
yy83:
		YYDEBUG(83, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy101;
		}
		goto yy79;
yy84:
		YYDEBUG(84, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy74;
		if (yych <= '9') goto yy103;
		goto yy74;
yy85:
		YYDEBUG(85, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(86, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy87,  &&yy73,  &&yy73,  &&yy87,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy87,  &&yy73,  &&yy94,  &&yy73,  &&yy73,  &&yy87,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy103, &&yy73,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy73,  &&yy87,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy96,  &&yy87,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73
			};
			goto *yytarget[yych];
		}
yy87:
		YYDEBUG(87, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
yy88:
		YYDEBUG(88, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(89, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy90, &&yy73, &&yy73, &&yy90, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy90, &&yy73, &&yy94, &&yy73, &&yy73, &&yy90,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88,
				&&yy88, &&yy88, &&yy73, &&yy90, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88,
				&&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88,
				&&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88,
				&&yy88, &&yy88, &&yy88, &&yy73, &&yy96, &&yy90, &&yy73, &&yy88,
				&&yy73, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88,
				&&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88,
				&&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88, &&yy88,
				&&yy88, &&yy88, &&yy88, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73
			};
			goto *yytarget[yych];
		}
yy90:
		YYDEBUG(90, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
yy91:
		YYDEBUG(91, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy73;
yy92:
		YYDEBUG(92, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(93, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of section or an option offset */
	BEGIN(INITIAL);
	return ']';
}
yy94:
		YYDEBUG(94, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy95;
			if (yych <= '[') goto yy73;
			goto yy97;
		} else {
			if (yych != '{') goto yy73;
		}
yy95:
		YYDEBUG(95, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy75;
			} else {
				goto yy79;
			}
		} else {
			if (yyaccept == 2) {
				goto yy87;
			} else {
				goto yy90;
			}
		}
yy96:
		YYDEBUG(96, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy73;
yy97:
		YYDEBUG(97, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(98, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy97;
		}
		goto yy73;
yy99:
		YYDEBUG(99, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(100, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
yy101:
		YYDEBUG(101, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(102, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy101;
		}
		goto yy105;
yy103:
		YYDEBUG(103, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(104, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy87,  &&yy73,  &&yy73,  &&yy87,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy87,  &&yy73,  &&yy94,  &&yy73,  &&yy73,  &&yy87,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103, &&yy103,
				&&yy103, &&yy103, &&yy73,  &&yy87,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy96,  &&yy87,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,
				&&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73,  &&yy73
			};
			goto *yytarget[yych];
		}
yy105:
		YYDEBUG(105, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(106, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
	}
/* *********************************** */
yyc_ST_RAW:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 192,   0, 128, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			192, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(107, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy109, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy113, &&yy114, &&yy111, &&yy111, &&yy116, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy113, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy117, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111
			};
			goto *yytarget[yych];
		}
yy109:
		YYDEBUG(109, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(110, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
yy111:
		YYDEBUG(111, *YYCURSOR);
		++YYCURSOR;
yy112:
		YYDEBUG(112, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	unsigned char *sc = NULL;
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR) {
			case '\n':
			case '\r':
				goto end_raw_value_chars;
				break;
			case ';':
				if (sc == NULL) {
					sc = YYCURSOR;
				}
				/* no break */
			default:
				YYCURSOR++;
				break;
		}
	}
end_raw_value_chars:
	yyleng = YYCURSOR - SCNG(yy_text);

	/* Eat trailing semicolons */
	while (yytext[yyleng - 1] == ';') {
		yyleng--;
	}

	/* Eat leading and trailing double quotes */
	if (yytext[0] == '"' && yytext[yyleng - 1] == '"') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	} else if (sc) {
		YYCURSOR = sc;
		yyleng = YYCURSOR - SCNG(yy_text);
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
yy113:
		YYDEBUG(113, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy119, &&yy119, &&yy112, &&yy112, &&yy119, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy119, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy119, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112,
				&&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112, &&yy112
			};
			goto *yytarget[yych];
		}
yy114:
		YYDEBUG(114, *YYCURSOR);
		++YYCURSOR;
yy115:
		YYDEBUG(115, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy116:
		YYDEBUG(116, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy114;
		goto yy115;
yy117:
		YYDEBUG(117, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy122;
yy118:
		YYDEBUG(118, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy119:
		YYDEBUG(119, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy118;
		}
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy120;
			if (yych <= '\n') goto yy114;
		} else {
			if (yych <= '\r') goto yy116;
			if (yych == ';') goto yy121;
		}
yy120:
		YYDEBUG(120, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* eat whitespace */
	goto restart;
}
yy121:
		YYDEBUG(121, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy122:
		YYDEBUG(122, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy121;
		}
		if (yych >= '\v') goto yy125;
yy123:
		YYDEBUG(123, *YYCURSOR);
		++YYCURSOR;
yy124:
		YYDEBUG(124, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy125:
		YYDEBUG(125, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy123;
		goto yy124;
	}
/* *********************************** */
yyc_ST_SECTION_RAW:
	{
		static const unsigned char yybm[] = {
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64, 192,   0,  64,  64,   0,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			192,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,   0,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(126, *YYCURSOR);
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy128;
		}
		if (yych <= '\r') goto yy131;
		goto yy133;
yy128:
		YYDEBUG(128, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(129, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy128;
		}
		YYDEBUG(130, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
yy131:
		YYDEBUG(131, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(132, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy133:
		YYDEBUG(133, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(134, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy133;
		}
		if (yych <= 0x08) goto yy135;
		if (yych <= '\n') goto yy136;
		if (yych == '\r') goto yy137;
yy135:
		YYDEBUG(135, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
yy136:
		YYDEBUG(136, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy135;
yy137:
		YYDEBUG(137, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy136;
		goto yy135;
	}
/* *********************************** */
yyc_ST_SECTION_VALUE:
	{
		static const unsigned char yybm[] = {
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 140, 128, 132, 132, 128, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			140, 132, 128, 132, 192, 132, 132,   0, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			180, 180, 180, 180, 180, 180, 180, 180, 
			180, 180, 132, 128, 132, 132, 132, 132, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 192, 128, 132, 164, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
		};
		YYDEBUG(138, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy143, &&yy145, &&yy140, &&yy140, &&yy145, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy143, &&yy140, &&yy147, &&yy140, &&yy149, &&yy140, &&yy140, &&yy150,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy151, &&yy151, &&yy140,
				&&yy152, &&yy152, &&yy152, &&yy152, &&yy152, &&yy152, &&yy152, &&yy152,
				&&yy152, &&yy152, &&yy140, &&yy145, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155,
				&&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155,
				&&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155,
				&&yy155, &&yy155, &&yy155, &&yy140, &&yy158, &&yy159, &&yy140, &&yy155,
				&&yy140, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155,
				&&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155,
				&&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155,
				&&yy155, &&yy155, &&yy155, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140
			};
			goto *yytarget[yych];
		}
yy140:
		YYDEBUG(140, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy141:
		YYDEBUG(141, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy140;
		}
		if (yych <= '"') goto yy142;
		if (yych <= '$') goto yy162;
		if (yych <= ';') goto yy142;
		if (yych <= '\\') goto yy164;
yy142:
		YYDEBUG(142, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
yy143:
		YYDEBUG(143, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(144, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy143, &&yy142, &&yy140, &&yy140, &&yy142, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy143, &&yy140, &&yy147, &&yy140, &&yy162, &&yy140, &&yy140, &&yy142,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy142, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy164, &&yy142, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140
			};
			goto *yytarget[yych];
		}
yy145:
		YYDEBUG(145, *YYCURSOR);
		++YYCURSOR;
yy146:
		YYDEBUG(146, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy147:
		YYDEBUG(147, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(148, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
yy149:
		YYDEBUG(149, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy146;
			if (yych <= '[') goto yy140;
			goto yy165;
		} else {
			if (yych == '{') goto yy167;
			goto yy140;
		}
yy150:
		YYDEBUG(150, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy169;
		}
		goto yy146;
yy151:
		YYDEBUG(151, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy141;
		if (yych <= '9') goto yy171;
		goto yy141;
yy152:
		YYDEBUG(152, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(153, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy154, &&yy140, &&yy140, &&yy154, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy154, &&yy140, &&yy162, &&yy140, &&yy140, &&yy154,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy171, &&yy140,
				&&yy152, &&yy152, &&yy152, &&yy152, &&yy152, &&yy152, &&yy152, &&yy152,
				&&yy152, &&yy152, &&yy140, &&yy154, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy164, &&yy154, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140
			};
			goto *yytarget[yych];
		}
yy154:
		YYDEBUG(154, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
yy155:
		YYDEBUG(155, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(156, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy157, &&yy140, &&yy140, &&yy157, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy157, &&yy140, &&yy162, &&yy140, &&yy140, &&yy157,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155,
				&&yy155, &&yy155, &&yy140, &&yy157, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155,
				&&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155,
				&&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155,
				&&yy155, &&yy155, &&yy155, &&yy140, &&yy164, &&yy157, &&yy140, &&yy155,
				&&yy140, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155,
				&&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155,
				&&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155, &&yy155,
				&&yy155, &&yy155, &&yy155, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140
			};
			goto *yytarget[yych];
		}
yy157:
		YYDEBUG(157, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
yy158:
		YYDEBUG(158, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy140;
yy159:
		YYDEBUG(159, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(160, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy161;
			if (yych <= '\t') goto yy159;
			if (yych <= '\n') goto yy173;
		} else {
			if (yych <= '\r') goto yy174;
			if (yych == ' ') goto yy159;
		}
yy161:
		YYDEBUG(161, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
yy162:
		YYDEBUG(162, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy163;
			if (yych <= '[') goto yy140;
			goto yy165;
		} else {
			if (yych != '{') goto yy140;
		}
yy163:
		YYDEBUG(163, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy142;
			} else {
				goto yy146;
			}
		} else {
			if (yyaccept == 2) {
				goto yy154;
			} else {
				goto yy157;
			}
		}
yy164:
		YYDEBUG(164, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy140;
yy165:
		YYDEBUG(165, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(166, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy165;
		}
		goto yy140;
yy167:
		YYDEBUG(167, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(168, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
yy169:
		YYDEBUG(169, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(170, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy169;
		}
		goto yy175;
yy171:
		YYDEBUG(171, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(172, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy154, &&yy140, &&yy140, &&yy154, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy154, &&yy140, &&yy162, &&yy140, &&yy140, &&yy154,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy171, &&yy171, &&yy171, &&yy171, &&yy171, &&yy171, &&yy171, &&yy171,
				&&yy171, &&yy171, &&yy140, &&yy154, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy164, &&yy154, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140
			};
			goto *yytarget[yych];
		}
yy173:
		YYDEBUG(173, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy161;
yy174:
		YYDEBUG(174, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy173;
		goto yy161;
yy175:
		YYDEBUG(175, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(176, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
	}
/* *********************************** */
yyc_ST_VALUE:
	{
		static const unsigned char yybm[] = {
			 96,  98,  98,  98,  98,  98,  98,  98, 
			 98, 100,  64,  98,  98,  64,  98,  98, 
			 98,  98,  98,  98,  98,  98,  98,  98, 
			 98,  98,  98,  98,  98,  98,  98,  98, 
			100,  96,  96,  98, 224,  98,  96,  32, 
			 96,  96,  98,  98,  98,  98,  98,  98, 
			122, 122, 122, 122, 122, 122, 122, 122, 
			122, 122,  98,  96,  98,  96,  98,  98, 
			 98, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114,  98,  98,  98,  96, 114, 
			 98, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114,  98,  96,  98,  96,  98, 
			 98,  98,  98,  98,  98,  98,  98,  98, 
			 98,  98,  98,  98,  98,  98,  98,  98, 
			 98,  98,  98,  98,  98,  98,  98,  98, 
			 98,  98,  98,  98,  98,  98,  98,  98, 
			 98,  98,  98,  98,  98,  98,  98,  98, 
			 98,  98,  98,  98,  98,  98,  98,  98, 
			 98,  98,  98,  98,  98,  98,  98,  98, 
			 98,  98,  98,  98,  98,  98,  98,  98, 
			 98,  98,  98,  98,  98,  98,  98,  98, 
			 98,  98,  98,  98,  98,  98,  98,  98, 
			 98,  98,  98,  98,  98,  98,  98,  98, 
			 98,  98,  98,  98,  98,  98,  98,  98, 
			 98,  98,  98,  98,  98,  98,  98,  98, 
			 98,  98,  98,  98,  98,  98,  98,  98, 
			 98,  98,  98,  98,  98,  98,  98,  98, 
			 98,  98,  98,  98,  98,  98,  98,  98, 
		};
		YYDEBUG(177, *YYCURSOR);
		YYFILL(6);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy179, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy184, &&yy187, &&yy181, &&yy181, &&yy189, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy184, &&yy190, &&yy193, &&yy181, &&yy195, &&yy181, &&yy190, &&yy196,
				&&yy190, &&yy190, &&yy181, &&yy181, &&yy181, &&yy197, &&yy197, &&yy181,
				&&yy198, &&yy198, &&yy198, &&yy198, &&yy198, &&yy198, &&yy198, &&yy198,
				&&yy198, &&yy198, &&yy181, &&yy201, &&yy181, &&yy202, &&yy181, &&yy181,
				&&yy181, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy207, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy208, &&yy209,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy210, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy211, &&yy204, &&yy181, &&yy181, &&yy181, &&yy190, &&yy204,
				&&yy181, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy207, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy208, &&yy209,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy210, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy211, &&yy204, &&yy181, &&yy190, &&yy181, &&yy190, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181
			};
			goto *yytarget[yych];
		}
yy179:
		YYDEBUG(179, *YYCURSOR);
		++YYCURSOR;
yy180:
		YYDEBUG(180, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
yy181:
		YYDEBUG(181, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy182:
		YYDEBUG(182, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy183, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy183, &&yy183, &&yy181, &&yy181, &&yy183, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy183, &&yy183, &&yy183, &&yy181, &&yy212, &&yy181, &&yy183, &&yy183,
				&&yy183, &&yy183, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy183, &&yy181, &&yy183, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy183, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy183, &&yy181, &&yy183, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181
			};
			goto *yytarget[yych];
		}
yy183:
		YYDEBUG(183, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get everything else as option/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
yy184:
		YYDEBUG(184, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(185, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy184, &&yy187, &&yy186, &&yy186, &&yy189, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy184, &&yy186, &&yy193, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy214, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186
			};
			goto *yytarget[yych];
		}
yy186:
		YYDEBUG(186, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(TC_WHITESPACE, yytext, yyleng);
}
yy187:
		YYDEBUG(187, *YYCURSOR);
		++YYCURSOR;
yy188:
		YYDEBUG(188, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy189:
		YYDEBUG(189, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy187;
		goto yy188;
yy190:
		YYDEBUG(190, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(191, *YYCURSOR);
		if (yych == '\t') goto yy190;
		if (yych == ' ') goto yy190;
		YYDEBUG(192, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Boolean operators */
	return yytext[0];
}
yy193:
		YYDEBUG(193, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(194, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
yy195:
		YYDEBUG(195, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy180;
			if (yych <= '[') goto yy181;
			goto yy216;
		} else {
			if (yych == '{') goto yy217;
			goto yy181;
		}
yy196:
		YYDEBUG(196, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy219;
		}
		goto yy180;
yy197:
		YYDEBUG(197, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy182;
		if (yych <= '9') goto yy221;
		goto yy182;
yy198:
		YYDEBUG(198, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(199, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy200, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy200, &&yy200, &&yy181, &&yy181, &&yy200, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy200, &&yy200, &&yy200, &&yy181, &&yy212, &&yy181, &&yy200, &&yy200,
				&&yy200, &&yy200, &&yy181, &&yy181, &&yy181, &&yy181, &&yy221, &&yy181,
				&&yy198, &&yy198, &&yy198, &&yy198, &&yy198, &&yy198, &&yy198, &&yy198,
				&&yy198, &&yy198, &&yy181, &&yy200, &&yy181, &&yy200, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy200, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy200, &&yy181, &&yy200, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181
			};
			goto *yytarget[yych];
		}
yy200:
		YYDEBUG(200, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
yy201:
		YYDEBUG(201, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy215;
yy202:
		YYDEBUG(202, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(203, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Make = used in option value to trigger error */
	yyless(0);
	BEGIN(INITIAL);
	return END_OF_LINE;
}
yy204:
		YYDEBUG(204, *YYCURSOR);
		yyaccept = 4;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(205, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy206, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy206, &&yy206, &&yy181, &&yy181, &&yy206, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy206, &&yy206, &&yy206, &&yy181, &&yy212, &&yy181, &&yy206, &&yy206,
				&&yy206, &&yy206, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy181, &&yy206, &&yy181, &&yy206, &&yy181, &&yy181,
				&&yy181, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy181, &&yy181, &&yy181, &&yy206, &&yy204,
				&&yy181, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy181, &&yy206, &&yy181, &&yy206, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181
			};
			goto *yytarget[yych];
		}
yy206:
		YYDEBUG(206, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
yy207:
		YYDEBUG(207, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy206, &&yy206, &&yy182, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy206, &&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy206, &&yy206,
				&&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy226, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy182, &&yy182, &&yy206, &&yy204,
				&&yy182, &&yy226, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182
			};
			goto *yytarget[yych];
		}
yy208:
		YYDEBUG(208, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy206, &&yy206, &&yy182, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy206, &&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy206, &&yy206,
				&&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy227,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy229, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy182, &&yy182, &&yy206, &&yy204,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy227,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy229, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182
			};
			goto *yytarget[yych];
		}
yy209:
		YYDEBUG(209, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy206, &&yy206, &&yy182, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy206, &&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy206, &&yy206,
				&&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy230, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy231, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy182, &&yy182, &&yy206, &&yy204,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy230, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy231, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182
			};
			goto *yytarget[yych];
		}
yy210:
		YYDEBUG(210, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy206, &&yy206, &&yy182, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy206, &&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy206, &&yy206,
				&&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy233, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy182, &&yy182, &&yy206, &&yy204,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy233, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182
			};
			goto *yytarget[yych];
		}
yy211:
		YYDEBUG(211, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy206, &&yy206, &&yy182, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy206, &&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy206, &&yy206,
				&&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy234, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy182, &&yy182, &&yy206, &&yy204,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy234, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182
			};
			goto *yytarget[yych];
		}
yy212:
		YYDEBUG(212, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy213;
			if (yych <= '[') goto yy181;
			goto yy216;
		} else {
			if (yych != '{') goto yy181;
		}
yy213:
		YYDEBUG(213, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 3) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy183;
				} else {
					goto yy186;
				}
			} else {
				if (yyaccept == 2) {
					goto yy180;
				} else {
					goto yy200;
				}
			}
		} else {
			if (yyaccept <= 5) {
				if (yyaccept == 4) {
					goto yy206;
				} else {
					goto yy228;
				}
			} else {
				if (yyaccept == 6) {
					goto yy232;
				} else {
					goto yy249;
				}
			}
		}
yy214:
		YYDEBUG(214, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy215:
		YYDEBUG(215, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy214;
		}
		if (yych <= '\n') goto yy223;
		goto yy225;
yy216:
		YYDEBUG(216, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy235;
		}
		goto yy181;
yy217:
		YYDEBUG(217, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(218, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
yy219:
		YYDEBUG(219, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(220, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy219;
		}
		goto yy237;
yy221:
		YYDEBUG(221, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(222, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy200, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy200, &&yy200, &&yy181, &&yy181, &&yy200, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy200, &&yy200, &&yy200, &&yy181, &&yy212, &&yy181, &&yy200, &&yy200,
				&&yy200, &&yy200, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy221, &&yy221, &&yy221, &&yy221, &&yy221, &&yy221, &&yy221, &&yy221,
				&&yy221, &&yy221, &&yy181, &&yy200, &&yy181, &&yy200, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy200, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy200, &&yy181, &&yy200, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181, &&yy181
			};
			goto *yytarget[yych];
		}
yy223:
		YYDEBUG(223, *YYCURSOR);
		++YYCURSOR;
yy224:
		YYDEBUG(224, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy225:
		YYDEBUG(225, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy223;
		goto yy224;
yy226:
		YYDEBUG(226, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy206, &&yy206, &&yy182, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy206, &&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy206, &&yy206,
				&&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy239, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy182, &&yy182, &&yy206, &&yy204,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy239, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182
			};
			goto *yytarget[yych];
		}
yy227:
		YYDEBUG(227, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy228, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy240, &&yy228, &&yy182, &&yy182, &&yy228, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy240, &&yy228, &&yy228, &&yy182, &&yy182, &&yy182, &&yy228, &&yy228,
				&&yy228, &&yy228, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy182, &&yy228, &&yy182, &&yy228, &&yy182, &&yy182,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy242, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy182, &&yy182, &&yy228, &&yy204,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy242, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy228, &&yy182, &&yy228, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182
			};
			goto *yytarget[yych];
		}
yy228:
		YYDEBUG(228, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
yy229:
		YYDEBUG(229, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy206, &&yy206, &&yy182, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy206, &&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy206, &&yy206,
				&&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy243, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy182, &&yy182, &&yy206, &&yy204,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy243, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182
			};
			goto *yytarget[yych];
		}
yy230:
		YYDEBUG(230, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy206, &&yy206, &&yy182, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy206, &&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy206, &&yy206,
				&&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy244, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy182, &&yy182, &&yy206, &&yy204,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy244, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182
			};
			goto *yytarget[yych];
		}
yy231:
		YYDEBUG(231, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy232, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy245, &&yy232, &&yy182, &&yy182, &&yy232, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy245, &&yy232, &&yy232, &&yy182, &&yy182, &&yy182, &&yy232, &&yy232,
				&&yy232, &&yy232, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy182, &&yy232, &&yy182, &&yy232, &&yy182, &&yy182,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy182, &&yy182, &&yy232, &&yy204,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy232, &&yy182, &&yy232, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182
			};
			goto *yytarget[yych];
		}
yy232:
		YYDEBUG(232, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
yy233:
		YYDEBUG(233, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy206, &&yy206, &&yy182, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy206, &&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy206, &&yy206,
				&&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy247, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy182, &&yy182, &&yy206, &&yy204,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy247, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182
			};
			goto *yytarget[yych];
		}
yy234:
		YYDEBUG(234, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy206, &&yy206, &&yy182, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy206, &&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy206, &&yy206,
				&&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy231, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy182, &&yy182, &&yy206, &&yy204,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy231, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182
			};
			goto *yytarget[yych];
		}
yy235:
		YYDEBUG(235, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(236, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy235;
		}
		if (yych <= 0x00) goto yy183;
		if (yych == '\\') goto yy216;
		goto yy181;
yy237:
		YYDEBUG(237, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(238, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
yy239:
		YYDEBUG(239, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy206, &&yy206, &&yy182, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy206, &&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy206, &&yy206,
				&&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy242, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy182, &&yy182, &&yy206, &&yy204,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy242, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182
			};
			goto *yytarget[yych];
		}
yy240:
		YYDEBUG(240, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(241, *YYCURSOR);
		if (yych == '\t') goto yy240;
		if (yych == ' ') goto yy240;
		goto yy228;
yy242:
		YYDEBUG(242, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy206, &&yy206, &&yy182, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy206, &&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy206, &&yy206,
				&&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy244, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy182, &&yy182, &&yy206, &&yy204,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy244, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182
			};
			goto *yytarget[yych];
		}
yy243:
		YYDEBUG(243, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy206, &&yy206, &&yy182, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy206, &&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy206, &&yy206,
				&&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy248, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy182, &&yy182, &&yy206, &&yy204,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy248, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182
			};
			goto *yytarget[yych];
		}
yy244:
		YYDEBUG(244, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy228, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy240, &&yy228, &&yy182, &&yy182, &&yy228, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy240, &&yy228, &&yy228, &&yy182, &&yy182, &&yy182, &&yy228, &&yy228,
				&&yy228, &&yy228, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy182, &&yy228, &&yy182, &&yy228, &&yy182, &&yy182,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy182, &&yy182, &&yy228, &&yy204,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy228, &&yy182, &&yy228, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182
			};
			goto *yytarget[yych];
		}
yy245:
		YYDEBUG(245, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(246, *YYCURSOR);
		if (yych == '\t') goto yy245;
		if (yych == ' ') goto yy245;
		goto yy232;
yy247:
		YYDEBUG(247, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy206, &&yy206, &&yy182, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy206, &&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy206, &&yy206,
				&&yy206, &&yy206, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182, &&yy182,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy231, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy182, &&yy182, &&yy206, &&yy204,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy231, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy206, &&yy182, &&yy206, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182
			};
			goto *yytarget[yych];
		}
yy248:
		YYDEBUG(248, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy249, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy250, &&yy249, &&yy182, &&yy182, &&yy249, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy250, &&yy249, &&yy249, &&yy182, &&yy182, &&yy182, &&yy249, &&yy249,
				&&yy249, &&yy249, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy182, &&yy249, &&yy182, &&yy249, &&yy182, &&yy182,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy182, &&yy182, &&yy249, &&yy204,
				&&yy182, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204, &&yy204,
				&&yy204, &&yy204, &&yy204, &&yy182, &&yy249, &&yy182, &&yy249, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182, &&yy182
			};
			goto *yytarget[yych];
		}
yy249:
		YYDEBUG(249, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(NULL_NULL, "", 0);
}
yy250:
		YYDEBUG(250, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(251, *YYCURSOR);
		if (yych == '\t') goto yy250;
		if (yych == ' ') goto yy250;
		goto yy249;
	}
/* *********************************** */
yyc_ST_VARNAME:
	{
		YYDEBUG(252, *YYCURSOR);
		YYFILL(1);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy257, &&yy257, &&yy254, &&yy254, &&yy257, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy257, &&yy257, &&yy254, &&yy257, &&yy254, &&yy257, &&yy254,
				&&yy257, &&yy257, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy257, &&yy254, &&yy257, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy257, &&yy254, &&yy254, &&yy257, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy257, &&yy257, &&yy259, &&yy257, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254
			};
			goto *yytarget[yych];
		}
yy254:
		YYDEBUG(254, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(255, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy256, &&yy256, &&yy254, &&yy254, &&yy256, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy256, &&yy256, &&yy254, &&yy256, &&yy254, &&yy256, &&yy254,
				&&yy256, &&yy256, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy256, &&yy254, &&yy256, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy256, &&yy254, &&yy254, &&yy256, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy256, &&yy256, &&yy256, &&yy256, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254,
				&&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254, &&yy254
			};
			goto *yytarget[yych];
		}
yy256:
		YYDEBUG(256, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable name */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace */
	EAT_TRAILING_WHITESPACE();

	RETURN_TOKEN(TC_VARNAME, yytext, yyleng);
}
yy257:
		YYDEBUG(257, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(258, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy259:
		YYDEBUG(259, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(260, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable end */
	yy_pop_state();
	return '}';
}
	}
}

}
re2c: warning: line 384: column 13: escape has no effect: '\.' [-Wuseless-escape]
re2c: warning: line 384: column 32: escape has no effect: '\.' [-Wuseless-escape]
re2c: warning: line 391: column 27: escape has no effect: '\[' [-Wuseless-escape]
re2c: warning: line 392: column 11: escape has no effect: '\[' [-Wuseless-escape]
re2c: warning: line 648: unreachable rule in condition 'ST_DOUBLE_QUOTES' (shadowed by rules at lines 582, 587) [-Wunreachable-rules]
re2c: warning: line 623: unreachable rule in condition 'ST_OFFSET' (shadowed by rule at line 573) [-Wunreachable-rules]
re2c: warning: line 648: unreachable rule in condition 'ST_RAW' (shadowed by rules at lines 500, 541, 643) [-Wunreachable-rules]
re2c: warning: line 623: unreachable rule in condition 'ST_SECTION_VALUE' (shadowed by rule at line 573) [-Wunreachable-rules]
re2c: warning: line 648: unreachable rule in condition 'ST_VALUE' (shadowed by rules at lines 541, 547, 551, 559, 563, 569, 577, 623, 643) [-Wunreachable-rules]
re2c: warning: line 652: looks like you use hardcoded numbers instead of autogenerated condition names: better add '/*!types:re2c*/' directive or '-t, --type-header' option and don't rely on fixed condition order. [-Wcondition-order]
