#  tickcount - a Python extension to provide access to the tick counter
#  Copyright (C) 2006  Canonical Ltd
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License, or (at your option) any later version.
#
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
#  USA

import unittest
import tickcount

class TickCountTestCase(unittest.TestCase):

    def test_monotonic(self):
        oldcount = tickcount.tickcount()
        newcount = tickcount.tickcount()
        self.assertTrue(tickcount.difference(oldcount, newcount) >= 0,
                        "tick count went backwards! (%d > %d)"
                        % (oldcount, newcount))

    def test_difference_wrap(self):
        import struct

        # Work out what the maximum sized unsigned C int is.  Note that
        # this will differ from the maximum sized Python int on 64-bit
        # platforms.
        sizeof_int = struct.calcsize('I')
        uint_max = struct.unpack('I', '\xff' * sizeof_int)[0]

        # create two tick counts that straddle the wrap point
        oldcount = uint_max / 2 - 10
        newcount = oldcount + 20 - uint_max

        self.assertEqual(tickcount.difference(oldcount, newcount), 20)

def test_suite():
    loader = unittest.TestLoader()
    return loader.loadTestsFromName(__name__)

if __name__ == '__main__':
    unittest.main(defaultTest='test_suite')
