/*
 * Freescale MXS UARTAPP Register Definitions
 *
 * Copyright (C) 2013 Andreas Wass <andreas.wass@dalelven.com>
 *
 * Based on code from LTIB:
 * Copyright 2008-2010 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#ifndef __ARCH_ARM___MXS_UARTAPP_H
#define __ARCH_ARM___MXS_UARTAPP_H

#include <asm/imx-common/regs-common.h>

#ifndef __ASSEMBLY__
struct mxs_uartapp_regs {
	mxs_reg_32(hw_uartapp_ctrl0)
	mxs_reg_32(hw_uartapp_ctrl1)
	mxs_reg_32(hw_uartapp_ctrl2)
	mxs_reg_32(hw_uartapp_linectrl)
	mxs_reg_32(hw_uartapp_linectrl2)
	mxs_reg_32(hw_uartapp_intr)
	mxs_reg_32(hw_uartapp_data)
	mxs_reg_32(hw_uartapp_stat)
	mxs_reg_32(hw_uartapp_debug)
	mxs_reg_32(hw_uartapp_version)
	mxs_reg_32(hw_uartapp_autobaud)
};
#endif

#define UARTAPP_CTRL0_SFTRST_MASK				(1 << 31)
#define UARTAPP_CTRL0_CLKGATE_MASK			(1 << 30)
#define UARTAPP_CTRL0_RUN_MASK				(1 << 29)
#define UARTAPP_CTRL0_RX_SOURCE_MASK			(1 << 28)
#define UARTAPP_CTRL0_RXTO_ENABLE_MASK			(1 << 27)
#define UARTAPP_CTRL0_RXTIMEOUT_OFFSET			16
#define UARTAPP_CTRL0_RXTIMEOUT_MASK			(0x7FF << 16)
#define UARTAPP_CTRL0_XFER_COUNT_OFFSET			0
#define UARTAPP_CTRL0_XFER_COUNT_MASK			0xFFFF

#define UARTAPP_CTRL1_RUN_MASK				(1 << 28)

#define UARTAPP_CTRL1_XFER_COUNT_OFFSET			0
#define UARTAPP_CTRL1_XFER_COUNT_MASK			0xFFFF

#define UARTAPP_CTRL2_INVERT_RTS_MASK			(1 << 31)
#define UARTAPP_CTRL2_INVERT_CTS_MASK			(1 << 30)
#define UARTAPP_CTRL2_INVERT_TX_MASK			(1 << 29)
#define UARTAPP_CTRL2_INVERT_RX_MASK			(1 << 28)
#define UARTAPP_CTRL2_RTS_SEMAPHORE_MASK			(1 << 27)
#define UARTAPP_CTRL2_DMAONERR_MASK			(1 << 26)
#define UARTAPP_CTRL2_TXDMAE_MASK				(1 << 25)
#define UARTAPP_CTRL2_RXDMAE_MASK				(1 << 24)
#define UARTAPP_CTRL2_RXIFLSEL_OFFSET			20
#define UARTAPP_CTRL2_RXIFLSEL_MASK			(0x7 << 20)

#define UARTAPP_CTRL2_RXIFLSEL_NOT_EMPTY		(0x0 << 20)
#define UARTAPP_CTRL2_RXIFLSEL_ONE_QUARTER		(0x1 << 20)
#define UARTAPP_CTRL2_RXIFLSEL_ONE_HALF		(0x2 << 20)
#define UARTAPP_CTRL2_RXIFLSEL_THREE_QUARTERS		(0x3 << 20)
#define UARTAPP_CTRL2_RXIFLSEL_SEVEN_EIGHTHS		(0x4 << 20)
#define UARTAPP_CTRL2_RXIFLSEL_INVALID5		(0x5 << 20)
#define UARTAPP_CTRL2_RXIFLSEL_INVALID6		(0x6 << 20)
#define UARTAPP_CTRL2_RXIFLSEL_INVALID7		(0x7 << 20)
#define UARTAPP_CTRL2_TXIFLSEL_OFFSET			16
#define UARTAPP_CTRL2_TXIFLSEL_MASK			(0x7 << 16)
#define UARTAPP_CTRL2_TXIFLSEL_EMPTY			(0x0 << 16)
#define UARTAPP_CTRL2_TXIFLSEL_ONE_QUARTER		(0x1 << 16)
#define UARTAPP_CTRL2_TXIFLSEL_ONE_HALF		(0x2 << 16)
#define UARTAPP_CTRL2_TXIFLSEL_THREE_QUARTERS		(0x3 << 16)
#define UARTAPP_CTRL2_TXIFLSEL_SEVEN_EIGHTHS		(0x4 << 16)
#define UARTAPP_CTRL2_TXIFLSEL_INVALID5		(0x5 << 16)
#define UARTAPP_CTRL2_TXIFLSEL_INVALID6		(0x6 << 16)
#define UARTAPP_CTRL2_TXIFLSEL_INVALID7		(0x7 << 16)
#define UARTAPP_CTRL2_CTSEN_MASK				(1 << 15)
#define UARTAPP_CTRL2_RTSEN_MASK				(1 << 14)
#define UARTAPP_CTRL2_OUT2_MASK				(1 << 13)
#define UARTAPP_CTRL2_OUT1_MASK				(1 << 12)
#define UARTAPP_CTRL2_RTS_MASK				(1 << 11)
#define UARTAPP_CTRL2_DTR_MASK				(1 << 10)
#define UARTAPP_CTRL2_RXE_MASK				(1 << 9)
#define UARTAPP_CTRL2_TXE_MASK				(1 << 8)
#define UARTAPP_CTRL2_LBE_MASK				(1 << 7)
#define UARTAPP_CTRL2_USE_LCR2_MASK			(1 << 6)

#define UARTAPP_CTRL2_SIRLP_MASK				(1 << 2)
#define UARTAPP_CTRL2_SIREN_MASK				(1 << 1)
#define UARTAPP_CTRL2_UARTEN_MASK				0x01

#define UARTAPP_LINECTRL_BAUD_DIVINT_OFFSET			16
#define UARTAPP_LINECTRL_BAUD_DIVINT_MASK			(0xFFFF << 16)
#define UARTAPP_LINECTRL_EXTRACT_BAUD_DIVINT_OFFSET		6

#define UARTAPP_LINECTRL_BAUD_DIVFRAC_OFFSET		8
#define UARTAPP_LINECTRL_BAUD_DIVFRAC_MASK		(0x3F << 8)
#define UARTAPP_LINECTRL_EXTRACT_BAUD_DIVFRAC_MASK	0x3F

#define UARTAPP_LINECTRL_SPS_MASK				(1 << 7)
#define UARTAPP_LINECTRL_WLEN_OFFSET			5
#define UARTAPP_LINECTRL_WLEN_MASK			(0x03 << 5)
#define UARTAPP_LINECTRL_WLEN_5BITS			(0x00 << 5)
#define UARTAPP_LINECTRL_WLEN_6BITS			(0x01 << 5)
#define UARTAPP_LINECTRL_WLEN_7BITS			(0x02 << 5)
#define UARTAPP_LINECTRL_WLEN_8BITS			(0x03 << 5)

#define UARTAPP_LINECTRL_FEN_MASK				(1 << 4)
#define UARTAPP_LINECTRL_STP2_MASK			(1 << 3)
#define UARTAPP_LINECTRL_EPS_MASK				(1 << 2)
#define UARTAPP_LINECTRL_PEN_MASK				(1 << 1)
#define UARTAPP_LINECTRL_BRK_MASK				1

#define UARTAPP_LINECTRL2_BAUD_DIVINT_OFFSET		16
#define UARTAPP_LINECTRL2_BAUD_DIVINT_MASK		(0xFFFF << 16)
#define UARTAPP_LINECTRL2_EXTRACT_BAUD_DIVINT_OFFSET	6

#define UARTAPP_LINECTRL2_BAUD_DIVFRAC_OFFSET		8
#define UARTAPP_LINECTRL2_BAUD_DIVFRAC_MASK		(0x3F << 8)
#define UARTAPP_LINECTRL2_EXTRACT_BAUD_DIVFRAC_MASK	0x3F

#define UARTAPP_LINECTRL2_SPS_MASK			(1 << 7)
#define UARTAPP_LINECTRL2_WLEN_OFFSET			5
#define UARTAPP_LINECTRL2_WLEN_MASK			(0x03 << 5)
#define UARTAPP_LINECTRL2_WLEN_5BITS			(0x00 << 5)
#define UARTAPP_LINECTRL2_WLEN_6BITS			(0x01 << 5)
#define UARTAPP_LINECTRL2_WLEN_7BITS			(0x02 << 5)
#define UARTAPP_LINECTRL2_WLEN_8BITS			(0x03 << 5)

#define UARTAPP_LINECTRL2_FEN_MASK			(1 << 4)
#define UARTAPP_LINECTRL2_STP2_MASK			(1 << 3)
#define UARTAPP_LINECTRL2_EPS_MASK			(1 << 2)
#define UARTAPP_LINECTRL2_PEN_MASK			(1 << 1)

#define UARTAPP_INTR_ABDIEN_MASK				(1 << 27)
#define UARTAPP_INTR_OEIEN_MASK				(1 << 26)
#define UARTAPP_INTR_BEIEN_MASK				(1 << 25)
#define UARTAPP_INTR_PEIEN_MASK				(1 << 24)
#define UARTAPP_INTR_FEIEN_MASK				(1 << 23)
#define UARTAPP_INTR_RTIEN_MASK				(1 << 22)
#define UARTAPP_INTR_TXIEN_MASK				(1 << 21)
#define UARTAPP_INTR_RXIEN_MASK				(1 << 20)
#define UARTAPP_INTR_DSRMIEN_MASK				(1 << 19)
#define UARTAPP_INTR_DCDMIEN_MASK				(1 << 18)
#define UARTAPP_INTR_CTSMIEN_MASK				(1 << 17)
#define UARTAPP_INTR_RIMIEN_MASK				(1 << 16)

#define UARTAPP_INTR_ABDIS_MASK				(1 << 11)
#define UARTAPP_INTR_OEIS_MASK				(1 << 10)
#define UARTAPP_INTR_BEIS_MASK				(1 << 9)
#define UARTAPP_INTR_PEIS_MASK				(1 << 8)
#define UARTAPP_INTR_FEIS_MASK				(1 << 7)
#define UARTAPP_INTR_RTIS_MASK				(1 << 6)
#define UARTAPP_INTR_TXIS_MASK				(1 << 5)
#define UARTAPP_INTR_RXIS_MASK				(1 << 4)
#define UARTAPP_INTR_DSRMIS_MASK				(1 << 3)
#define UARTAPP_INTR_DCDMIS_MASK				(1 << 2)
#define UARTAPP_INTR_CTSMIS_MASK				(1 << 1)
#define UARTAPP_INTR_RIMIS_MASK				0x1

#define UARTAPP_DATA_DATA_OFFSET				0
#define UARTAPP_DATA_DATA_MASK				0xFFFFFFFF
#define UARTAPP_STAT_PRESENT_MASK				(1 << 31)
#define UARTAPP_STAT_PRESENT_UNAVAILABLE		(0x0 << 31)
#define UARTAPP_STAT_PRESENT_AVAILABLE			(0x1 << 31)

#define UARTAPP_STAT_HISPEED_MASK				(1 << 30)
#define UARTAPP_STAT_HISPEED_UNAVAILABLE		(0x0 << 30)
#define UARTAPP_STAT_HISPEED_AVAILABLE			(0x1 << 30)

#define UARTAPP_STAT_BUSY_MASK				(1 << 29)
#define UARTAPP_STAT_CTS_MASK				(1 << 28)
#define UARTAPP_STAT_TXFE_MASK				(1 << 27)
#define UARTAPP_STAT_RXFF_MASK				(1 << 26)
#define UARTAPP_STAT_TXFF_MASK				(1 << 25)
#define UARTAPP_STAT_RXFE_MASK				(1 << 24)
#define UARTAPP_STAT_RXBYTE_INVALID_OFFSET			20
#define UARTAPP_STAT_RXBYTE_INVALID_MASK		(0xF << 20)

#define UARTAPP_STAT_OERR_MASK				(1 << 19)
#define UARTAPP_STAT_BERR_MASK				(1 << 18)
#define UARTAPP_STAT_PERR_MASK				(1 << 17)
#define UARTAPP_STAT_FERR_MASK				(1 << 16)
#define UARTAPP_STAT_RXCOUNT_OFFSET				0
#define UARTAPP_STAT_RXCOUNT_MASK				0xFFFF

#define UARTAPP_DEBUG_RXIBAUD_DIV_OFFSET			16
#define UARTAPP_DEBUG_RXIBAUD_DIV_MASK				(0xFFFF << 16)

#define UARTAPP_DEBUG_RXFBAUD_DIV_OFFSET			10
#define UARTAPP_DEBUG_RXFBAUD_DIV_MASK				(0x3F << 10)

#define UARTAPP_DEBUG_TXDMARUN_MASK			(1 << 5)
#define UARTAPP_DEBUG_RXDMARUN_MASK			(1 << 4)
#define UARTAPP_DEBUG_TXCMDEND_MASK			(1 << 3)
#define UARTAPP_DEBUG_RXCMDEND_MASK			(1 << 2)
#define UARTAPP_DEBUG_TXDMARQ_MASK			(1 << 1)
#define UARTAPP_DEBUG_RXDMARQ_MASK			0x01

#define UARTAPP_VERSION_MAJOR_OFFSET			24
#define UARTAPP_VERSION_MAJOR_MASK			(0xFF << 24)

#define UARTAPP_VERSION_MINOR_OFFSET			16
#define UARTAPP_VERSION_MINOR_MASK			(0xFF << 16)

#define UARTAPP_VERSION_STEP_OFFSET				0
#define UARTAPP_VERSION_STEP_MASK				0xFFFF

#define UARTAPP_AUTOBAUD_REFCHAR1_OFFSET			24
#define UARTAPP_AUTOBAUD_REFCHAR1_MASK				(0xFF << 24)

#define UARTAPP_AUTOBAUD_REFCHAR0_OFFSET			16
#define UARTAPP_AUTOBAUD_REFCHAR0_MASK				(0xFF << 16)

#define UARTAPP_AUTOBAUD_UPDATE_TX_MASK			(1 << 4)
#define UARTAPP_AUTOBAUD_TWO_REF_CHARS_MASK		(1 << 3)
#define UARTAPP_AUTOBAUD_START_WITH_RUNBIT_MASK		(1 << 2)
#define UARTAPP_AUTOBAUD_START_BAUD_DETECT_MASK		(1 << 1)
#define UARTAPP_AUTOBAUD_BAUD_DETECT_ENABLE_MASK		0x01
#endif /* __ARCH_ARM___UARTAPP_H */
