/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors.output;

import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.processors.output.LongResultPrinter;
import amazon.fws.clicommando.processors.output.QuietResultPrinter;
import amazon.fws.clicommando.processors.output.ResultPrinter;
import amazon.fws.clicommando.processors.output.ShortResultPrinter;
import amazon.fws.clicommando.processors.output.StdOutResultPrinter;
import amazon.fws.clicommando.processors.output.XmlResultPrinter;

public class ResultPrinterFactory {
    public static ResultPrinter getPrinter(ResultPrinter.DisplayMethod outputMethod) {
        ResultPrinter resultPrinter;
        if (outputMethod == null) {
            throw new ConfigurationErrorException("Null argument OutputConfig");
        }
        switch (outputMethod) {
            case SHORT: {
                resultPrinter = new ShortResultPrinter();
                break;
            }
            case LONG: {
                resultPrinter = new LongResultPrinter();
                break;
            }
            case XML: {
                resultPrinter = new XmlResultPrinter();
                break;
            }
            case STDOUT: {
                resultPrinter = new StdOutResultPrinter();
                break;
            }
            case QUIET: {
                resultPrinter = new QuietResultPrinter();
                break;
            }
            default: {
                throw new ConfigurationErrorException("Illegal option: " + outputMethod.name());
            }
        }
        return resultPrinter;
    }
}

