/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.CommandConfig;
import amazon.fws.clicommando.config.importer.ImportCommand;
import amazon.fws.clicommando.config.importer.XmlImport;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.exceptions.InternalErrorException;
import amazon.fws.clicommando.exceptions.ServiceAccessException;
import amazon.fws.clicommando.exceptions.ServiceErrorException;
import amazon.fws.clicommando.exceptions.ServiceExecutionException;
import amazon.fws.clicommando.exceptions.UnknownErrorException;
import amazon.fws.clicommando.exceptions.UserAbortedException;
import amazon.fws.clicommando.files.ByExtensionFilesBrowser;
import amazon.fws.clicommando.files.JarFileUtils;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.processors.Argv0CommandProcessor;
import amazon.fws.clicommando.processors.CommandProcessor;
import amazon.fws.clicommando.processors.ConfirmationCommandProcessor;
import amazon.fws.clicommando.processors.CustomParamCommandProcessor;
import amazon.fws.clicommando.processors.DefaultCommandProcessor;
import amazon.fws.clicommando.processors.EncodeCommandProcessor;
import amazon.fws.clicommando.processors.EnvVarCommandProcessor;
import amazon.fws.clicommando.processors.ExecutionControlCommandProcessor;
import amazon.fws.clicommando.processors.LoadAWSCredentialFileCommandProcessor;
import amazon.fws.clicommando.processors.LoadCertPKFilesCommandProcessor;
import amazon.fws.clicommando.processors.MapValidatorCommandProcessor;
import amazon.fws.clicommando.processors.OutputFormatCommandProcessor;
import amazon.fws.clicommando.processors.ParameterMergeCommandProcessor;
import amazon.fws.clicommando.processors.ParametersValidatorCommandProcessor;
import amazon.fws.clicommando.processors.PosixCliCommandProcessor;
import amazon.fws.clicommando.processors.ReferenceLoaderCommandProcessor;
import amazon.fws.clicommando.processors.ServiceCommCommandProcessor;
import amazon.fws.clicommando.processors.SetSecurityKeysCommandProcessor;
import amazon.fws.clicommando.processors.StdInCommandProcessor;
import amazon.fws.clicommando.processors.output.ResultPrinter;
import amazon.fws.clicommando.util.HelpUtils;
import amazon.fws.clicommando.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;

public class Initializer {
    public static Locale DEFAULT_LOCALE = Locale.getDefault();
    private ExitStatus exitStatus = ExitStatus.OK;
    private Command resultCommand;

    public Command getResultCommand() {
        return this.resultCommand;
    }

    public void processCommandLine(String[] commandLine) {
        this.processCommandLine(commandLine, JarFileUtils.getJarFile("").getName(), "");
    }

    public void processCommandLine(String[] commandLine, String configPathRoot, String configPath, String helpPathRoot, String helpPath) {
        this.processCommandLine(commandLine, new XmlImport(), configPathRoot, configPath, helpPathRoot, helpPath);
    }

    public void processCommandLine(String[] commandLine, String configPathRoot, String helpPathRoot) {
        this.processCommandLine(commandLine, new XmlImport(), configPathRoot, "", helpPathRoot, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processCommandLine(String[] commandLine, ImportCommand importer, String configPathRoot, String configPath, String helpPathRoot, String helpPath) {
        Exception errorCase = null;
        String usage = "";
        try {
            try {
                this.runProcess(commandLine, importer, configPathRoot, configPath, helpPathRoot, helpPath);
            }
            catch (BadInputException e) {
                this.exitStatus = ExitStatus.BAD_INPUT;
                errorCase = e;
                usage = this.getUsage();
                Object var12_10 = null;
                if (errorCase == null) return;
                String showXmlString = this.getShowXml(this.resultCommand, errorCase);
                if (StringUtils.isEmpty(showXmlString)) {
                    if (this.resultCommand != null && (this.resultCommand.getCommandConfigMap().containsKey(this.resultCommand.getCommand()) || this.resultCommand.getCommandAliasMap().containsKey(this.resultCommand.getCommand()))) {
                        this.printRequest(this.resultCommand);
                    }
                    this.printDebugInfo(this.resultCommand, errorCase);
                    String err = StringUtils.formatTextColumn(errorCase.getMessage(), "", true);
                    String commandName = this.resultCommand.getCommand();
                    commandName = StringUtils.isEmpty(commandName) || !this.isValidCommandConfigFor(this.resultCommand) ? "" : commandName + ": ";
                    System.err.println(commandName + err);
                    System.err.println(usage);
                    return;
                }
                this.printDebugInfo(this.resultCommand, errorCase);
                System.out.println(showXmlString == null ? "" : showXmlString);
                return;
            }
            catch (UserAbortedException e) {
                this.exitStatus = ExitStatus.USER_ABORTED;
                errorCase = e;
                Object var12_11 = null;
                if (errorCase == null) return;
                String showXmlString = this.getShowXml(this.resultCommand, errorCase);
                if (StringUtils.isEmpty(showXmlString)) {
                    if (this.resultCommand != null && (this.resultCommand.getCommandConfigMap().containsKey(this.resultCommand.getCommand()) || this.resultCommand.getCommandAliasMap().containsKey(this.resultCommand.getCommand()))) {
                        this.printRequest(this.resultCommand);
                    }
                    this.printDebugInfo(this.resultCommand, errorCase);
                    String err = StringUtils.formatTextColumn(errorCase.getMessage(), "", true);
                    String commandName = this.resultCommand.getCommand();
                    commandName = StringUtils.isEmpty(commandName) || !this.isValidCommandConfigFor(this.resultCommand) ? "" : commandName + ": ";
                    System.err.println(commandName + err);
                    System.err.println(usage);
                    return;
                }
                this.printDebugInfo(this.resultCommand, errorCase);
                System.out.println(showXmlString == null ? "" : showXmlString);
                return;
            }
            catch (ServiceErrorException e) {
                this.exitStatus = ExitStatus.SERVICE_ERROR;
                if (e.getErrorCode() == ErrorMessages.ErrorCode.BAD_REQUEST || e.getErrorCode() == ErrorMessages.ErrorCode.SERVICE_NOT_FOUND) {
                    usage = this.getUsage();
                }
                errorCase = e;
                Object var12_12 = null;
                if (errorCase == null) return;
                String showXmlString = this.getShowXml(this.resultCommand, errorCase);
                if (StringUtils.isEmpty(showXmlString)) {
                    if (this.resultCommand != null && (this.resultCommand.getCommandConfigMap().containsKey(this.resultCommand.getCommand()) || this.resultCommand.getCommandAliasMap().containsKey(this.resultCommand.getCommand()))) {
                        this.printRequest(this.resultCommand);
                    }
                    this.printDebugInfo(this.resultCommand, errorCase);
                    String err = StringUtils.formatTextColumn(errorCase.getMessage(), "", true);
                    String commandName = this.resultCommand.getCommand();
                    commandName = StringUtils.isEmpty(commandName) || !this.isValidCommandConfigFor(this.resultCommand) ? "" : commandName + ": ";
                    System.err.println(commandName + err);
                    System.err.println(usage);
                    return;
                }
                this.printDebugInfo(this.resultCommand, errorCase);
                System.out.println(showXmlString == null ? "" : showXmlString);
                return;
            }
            catch (ServiceExecutionException e) {
                this.exitStatus = ExitStatus.SERVICE_EXECUTION_ERROR;
                errorCase = e;
                Object var12_13 = null;
                if (errorCase == null) return;
                String showXmlString = this.getShowXml(this.resultCommand, errorCase);
                if (StringUtils.isEmpty(showXmlString)) {
                    if (this.resultCommand != null && (this.resultCommand.getCommandConfigMap().containsKey(this.resultCommand.getCommand()) || this.resultCommand.getCommandAliasMap().containsKey(this.resultCommand.getCommand()))) {
                        this.printRequest(this.resultCommand);
                    }
                    this.printDebugInfo(this.resultCommand, errorCase);
                    String err = StringUtils.formatTextColumn(errorCase.getMessage(), "", true);
                    String commandName = this.resultCommand.getCommand();
                    commandName = StringUtils.isEmpty(commandName) || !this.isValidCommandConfigFor(this.resultCommand) ? "" : commandName + ": ";
                    System.err.println(commandName + err);
                    System.err.println(usage);
                    return;
                }
                this.printDebugInfo(this.resultCommand, errorCase);
                System.out.println(showXmlString == null ? "" : showXmlString);
                return;
            }
            catch (ServiceAccessException e) {
                this.exitStatus = ExitStatus.SERVICE_ACCESS_ERROR;
                errorCase = e;
                Object var12_14 = null;
                if (errorCase == null) return;
                String showXmlString = this.getShowXml(this.resultCommand, errorCase);
                if (StringUtils.isEmpty(showXmlString)) {
                    if (this.resultCommand != null && (this.resultCommand.getCommandConfigMap().containsKey(this.resultCommand.getCommand()) || this.resultCommand.getCommandAliasMap().containsKey(this.resultCommand.getCommand()))) {
                        this.printRequest(this.resultCommand);
                    }
                    this.printDebugInfo(this.resultCommand, errorCase);
                    String err = StringUtils.formatTextColumn(errorCase.getMessage(), "", true);
                    String commandName = this.resultCommand.getCommand();
                    commandName = StringUtils.isEmpty(commandName) || !this.isValidCommandConfigFor(this.resultCommand) ? "" : commandName + ": ";
                    System.err.println(commandName + err);
                    System.err.println(usage);
                    return;
                }
                this.printDebugInfo(this.resultCommand, errorCase);
                System.out.println(showXmlString == null ? "" : showXmlString);
                return;
            }
            catch (CliCommandoException e) {
                this.exitStatus = ExitStatus.INTERNAL_ERROR;
                errorCase = e;
                Object var12_15 = null;
                if (errorCase == null) return;
                String showXmlString = this.getShowXml(this.resultCommand, errorCase);
                if (StringUtils.isEmpty(showXmlString)) {
                    if (this.resultCommand != null && (this.resultCommand.getCommandConfigMap().containsKey(this.resultCommand.getCommand()) || this.resultCommand.getCommandAliasMap().containsKey(this.resultCommand.getCommand()))) {
                        this.printRequest(this.resultCommand);
                    }
                    this.printDebugInfo(this.resultCommand, errorCase);
                    String err = StringUtils.formatTextColumn(errorCase.getMessage(), "", true);
                    String commandName = this.resultCommand.getCommand();
                    commandName = StringUtils.isEmpty(commandName) || !this.isValidCommandConfigFor(this.resultCommand) ? "" : commandName + ": ";
                    System.err.println(commandName + err);
                    System.err.println(usage);
                    return;
                }
                this.printDebugInfo(this.resultCommand, errorCase);
                System.out.println(showXmlString == null ? "" : showXmlString);
                return;
            }
            catch (Exception e) {
                this.exitStatus = ExitStatus.UNKNOWN_ERROR;
                try {
                    errorCase = new UnknownErrorException(e);
                }
                catch (Exception ue) {
                    this.exitStatus = ExitStatus.CANNOT_CREATE_ERROR_MESSAGE;
                    errorCase = e;
                }
                Object var12_16 = null;
                if (errorCase == null) return;
                String showXmlString = this.getShowXml(this.resultCommand, errorCase);
                if (StringUtils.isEmpty(showXmlString)) {
                    if (this.resultCommand != null && (this.resultCommand.getCommandConfigMap().containsKey(this.resultCommand.getCommand()) || this.resultCommand.getCommandAliasMap().containsKey(this.resultCommand.getCommand()))) {
                        this.printRequest(this.resultCommand);
                    }
                    this.printDebugInfo(this.resultCommand, errorCase);
                    String err = StringUtils.formatTextColumn(errorCase.getMessage(), "", true);
                    String commandName = this.resultCommand.getCommand();
                    commandName = StringUtils.isEmpty(commandName) || !this.isValidCommandConfigFor(this.resultCommand) ? "" : commandName + ": ";
                    System.err.println(commandName + err);
                    System.err.println(usage);
                    return;
                }
                this.printDebugInfo(this.resultCommand, errorCase);
                System.out.println(showXmlString == null ? "" : showXmlString);
                return;
            }
            Object var12_9 = null;
            if (errorCase == null) return;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (errorCase == null) throw throwable;
            String showXmlString = this.getShowXml(this.resultCommand, errorCase);
            if (StringUtils.isEmpty(showXmlString)) {
                if (this.resultCommand != null && (this.resultCommand.getCommandConfigMap().containsKey(this.resultCommand.getCommand()) || this.resultCommand.getCommandAliasMap().containsKey(this.resultCommand.getCommand()))) {
                    this.printRequest(this.resultCommand);
                }
                this.printDebugInfo(this.resultCommand, errorCase);
                String err = StringUtils.formatTextColumn(errorCase.getMessage(), "", true);
                String commandName = this.resultCommand.getCommand();
                commandName = StringUtils.isEmpty(commandName) || !this.isValidCommandConfigFor(this.resultCommand) ? "" : commandName + ": ";
                System.err.println(commandName + err);
                System.err.println(usage);
                throw throwable;
            }
            this.printDebugInfo(this.resultCommand, errorCase);
            System.out.println(showXmlString == null ? "" : showXmlString);
            throw throwable;
        }
        String showXmlString = this.getShowXml(this.resultCommand, errorCase);
        if (StringUtils.isEmpty(showXmlString)) {
            if (this.resultCommand != null && (this.resultCommand.getCommandConfigMap().containsKey(this.resultCommand.getCommand()) || this.resultCommand.getCommandAliasMap().containsKey(this.resultCommand.getCommand()))) {
                this.printRequest(this.resultCommand);
            }
            this.printDebugInfo(this.resultCommand, errorCase);
            String err = StringUtils.formatTextColumn(errorCase.getMessage(), "", true);
            String commandName = this.resultCommand.getCommand();
            commandName = StringUtils.isEmpty(commandName) || !this.isValidCommandConfigFor(this.resultCommand) ? "" : commandName + ": ";
            System.err.println(commandName + err);
            System.err.println(usage);
            return;
        }
        this.printDebugInfo(this.resultCommand, errorCase);
        System.out.println(showXmlString == null ? "" : showXmlString);
    }

    private String getUsage() {
        String usage = "";
        if (this.resultCommand != null && this.isValidCommandConfigFor(this.resultCommand) && this.resultCommand.getCurrentCommandConfig() != null) {
            usage = "Usage:\n" + HelpUtils.getSynopsis(this.resultCommand.getCurrentCommandConfig()) + "\nFor more information and a full list of options, run \"" + this.resultCommand.getCurrentCommandConfig().getName() + " --help\"";
        }
        return usage;
    }

    void runProcess(String[] commandLine, ImportCommand importer, String configPathRoot, String configPath, String helpPathRoot, String helpPath) {
        Command command;
        this.resultCommand = null;
        this.resultCommand = importer.importCommandFrom(configPathRoot, configPath);
        this.resultCommand.setCommandLineArgs(commandLine);
        this.resultCommand.setHelpPathRoot(helpPathRoot);
        this.resultCommand.setHelpPath(helpPath);
        this.resultCommand.setImporter(importer);
        this.loadProperties(configPathRoot, configPath, this.resultCommand.getProperties());
        ArrayList<CommandProcessor> preProcessors = new ArrayList<CommandProcessor>();
        ArrayList<CommandProcessor> processors = new ArrayList<CommandProcessor>();
        ExecutionControlCommandProcessor executionController = new ExecutionControlCommandProcessor();
        preProcessors.add(new Argv0CommandProcessor());
        preProcessors.add(new DefaultCommandProcessor());
        preProcessors.add(new EnvVarCommandProcessor());
        preProcessors.add(new PosixCliCommandProcessor());
        preProcessors.add(new ReferenceLoaderCommandProcessor());
        preProcessors.add(new ParameterMergeCommandProcessor());
        preProcessors.add(new CustomParamCommandProcessor());
        preProcessors.add(new LoadAWSCredentialFileCommandProcessor());
        preProcessors.add(new LoadCertPKFilesCommandProcessor());
        preProcessors.add(new SetSecurityKeysCommandProcessor());
        preProcessors.add(new MapValidatorCommandProcessor());
        preProcessors.add(new ParametersValidatorCommandProcessor());
        preProcessors.add(new StdInCommandProcessor());
        preProcessors.add(new EncodeCommandProcessor());
        preProcessors.add(new ConfirmationCommandProcessor());
        processors.add(new ServiceCommCommandProcessor());
        processors.add(new OutputFormatCommandProcessor());
        for (CommandProcessor proc : preProcessors) {
            this.resultCommand = proc.process(this.resultCommand);
        }
        while ((command = executionController.process(this.resultCommand)).iterate()) {
            if (command.getIterationDelay() != null) {
                try {
                    Thread.sleep(command.getIterationDelay());
                }
                catch (InterruptedException e) {
                    throw new UserAbortedException(ErrorMessages.ErrorCode.ABORTING_COMMAND, command.getCurrentCommandConfig().getName());
                }
            }
            for (CommandProcessor proc : processors) {
                this.resultCommand = proc.process(this.resultCommand);
            }
        }
        while (this.resultCommand.iterate()) {
        }
    }

    private void loadProperties(String configPathRoot, String configPath, Properties properties) {
        ByExtensionFilesBrowser propertyFiles = new ByExtensionFilesBrowser(configPathRoot, configPath, "properties");
        for (InputStream is : propertyFiles) {
            try {
                properties.load(is);
            }
            catch (IOException ioe) {
                throw new InternalErrorException("Failed to load a property file from Jar: " + propertyFiles.getCurrentFilePath(), ioe);
            }
        }
    }

    public void exit() {
        System.exit(this.exitStatus.getExitStatus());
    }

    private void printRequest(Command resultCommand) {
        String requestUrl;
        CommandConfig commandConfig;
        if (this.isValidCommandConfigFor(resultCommand) && (commandConfig = resultCommand.getCurrentCommandConfig()).getParameterMap().containsKey("DisplayRequestUrl") && Boolean.parseBoolean(resultCommand.getCurrentCommandConfig().getParameter("DisplayRequestUrl").getValue()) && StringUtils.notEmpty(requestUrl = resultCommand.getCurrentCommandConfig().getRequestUrl())) {
            System.err.println(requestUrl);
        }
    }

    private void printDebugInfo(Command resultCommand, Exception e) {
        if (e instanceof CliCommandoException) {
            CliCommandoException cee = null;
            if (e instanceof ConfigurationErrorException || this.isDebugModeSet(resultCommand)) {
                cee = (CliCommandoException)e;
            }
            if (cee != null) {
                System.err.println(cee.getDebugInfo());
            }
        }
    }

    private String getShowXml(Command resultCommand, Exception e) {
        String retVal = null;
        try {
            OutputFormatCommandProcessor output = new OutputFormatCommandProcessor();
            if (output.getDisplayMethod(resultCommand) == ResultPrinter.DisplayMethod.XML) {
                output.setValueForDisplay(resultCommand);
                retVal = output.getValueForDisplay();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return retVal;
    }

    private boolean isValidCommandConfigFor(Command resultCommand) {
        try {
            if (resultCommand != null) {
                resultCommand.getCurrentCommandConfig();
                return true;
            }
            return false;
        }
        catch (BadInputException bie) {
            return false;
        }
    }

    private boolean isDebugModeSet(Command command) {
        boolean isValidCommandConfig = this.isValidCommandConfigFor(command);
        boolean isDebugModeConfigured = isValidCommandConfig && command.getCurrentCommandConfig().getParameterMap().containsKey("DebugMode");
        boolean isDebugModeSet = isDebugModeConfigured && Boolean.parseBoolean(command.getCurrentCommandConfig().getParameter("DebugMode").getValue());
        return isDebugModeSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ExitStatus {
        OK(0),
        BAD_INPUT(1),
        USER_ABORTED(2),
        INTERNAL_ERROR(99),
        SERVICE_ERROR(30),
        SERVICE_ACCESS_ERROR(31),
        SERVICE_EXECUTION_ERROR(32),
        UNKNOWN_ERROR(99),
        CANNOT_CREATE_ERROR_MESSAGE(100);

        private int exitStatus;

        private ExitStatus(int status) {
            this.exitStatus = status;
        }

        public int getExitStatus() {
            return this.exitStatus;
        }
    }
}

