/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.SnappyLoader;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class TempStreamFactory {
    private static SnappyLoader snappyLoader = null;

    private static synchronized SnappyLoader getSnappyLoader() {
        if (snappyLoader == null) {
            snappyLoader = new SnappyLoader();
        }
        return snappyLoader;
    }

    public InputStream wrapTempInputStream(InputStream inputStream, int bufferSize) {
        InputStream is = IOUtil.maybeBufferInputStream(inputStream, bufferSize);
        if (TempStreamFactory.getSnappyLoader().SnappyAvailable) {
            try {
                return TempStreamFactory.getSnappyLoader().wrapInputStream(is);
            }
            catch (Exception e) {
                throw new SAMException("Error creating SnappyInputStream", e);
            }
        }
        return is;
    }

    public OutputStream wrapTempOutputStream(OutputStream outputStream, int bufferSize) {
        OutputStream os = outputStream;
        if (bufferSize > 0) {
            os = new BufferedOutputStream(os, bufferSize);
        }
        if (TempStreamFactory.getSnappyLoader().SnappyAvailable) {
            try {
                os = TempStreamFactory.getSnappyLoader().wrapOutputStream(os);
            }
            catch (Exception e) {
                throw new SAMException("Error creating SnappyOutputStream", e);
            }
        }
        return os;
    }
}

