#!/usr/bin/perl 

package PortableH264LowRes;

use ExportBase;

our @ISA = qw(ExportBase);

my $description = "Low Resolution (480x320) Portable H264 Settings.";
my $devices = "Low Resolution Android Devices (example HTC Hero), iPod Classic, iPod Nano";
my $notes = "Requires AAC, <a href=\"https://help.ubuntu.com/community/Medibuntu\">activate Medibuntu</a>";
my $version = "1.0";

sub new{
    my $class = shift;
    my $self = $class->SUPER::new(shift, shift, $description, $devices, $notes, $version);
    bless $self, $class;
    return $self;
}

sub export{
    my( $self ) = @_;

    system("avconv -i \'$self->{_inputFile}\' -y -pass 1 -an -vcodec libx264 -pre slow_firstpass -pre ipod320 -b 1500k -bt 1000k -threads 0 -s 480x320 -aspect 16:9 -f ipod \'$self->{_outputFile}$self->{_extension}\' && avconv -i \'$self->{_inputFile}\' -y -pass 2 -vcodec libx264 -pre medium -pre ipod320 -b 1500k -bt 1000k -threads 0 -s 480x320 -acodec libfaac -ab 192kb -ac 2 -aspect 16:9 -f ipod \'$self->{_outputFile}$self->{_extension}\'");

}

1;
