#!/bin/bash

###############################################################################
# Linux Management Providers (LMP), Battery provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_Battery.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_Battery provider module";
Name = "Battery_OpenDRIM_BatteryModule";
Location = "cmpiBattery_OpenDRIM_BatteryProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_Battery provider";
Name = "Battery_OpenDRIM_BatteryProvider";
ProviderModuleName = "Battery_OpenDRIM_BatteryModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_Battery provider capabilities";
ProviderModuleName = "Battery_OpenDRIM_BatteryModule";
ProviderName = "Battery_OpenDRIM_BatteryProvider";
ClassName = "OpenDRIM_Battery";
ProviderType = {2, 5};
Namespaces = {"$1"};
SupportedProperties = {"Caption", "Description", "ElementName", "InstallDate", "Name", "OperationalStatus", "StatusDescriptions", "Status", "HealthState", "PrimaryStatus", "DetailedStatus", "OperatingStatus", "CommunicationStatus", "EnabledState", "OtherEnabledState", "RequestedState", "EnabledDefault", "TimeOfLastStateChange", "AvailableRequestedStates", "TransitioningToState", "SystemCreationClassName", "SystemName", "CreationClassName", "DeviceID", "PowerManagementSupported", "PowerManagementCapabilities", "Availability", "StatusInfo", "LastErrorCode", "ErrorDescription", "ErrorCleared", "OtherIdentifyingInfo", "PowerOnHours", "TotalPowerOnHours", "IdentifyingDescriptions", "AdditionalAvailability", "MaxQuiesceTime", "LocationIndicator", "MaxPowerProduced", "MaxPowerProducedUnits", "MaxPowerConsumed", "MaxPowerConsumedUnits", "BatteryStatus", "TimeOnBattery", "EstimatedRunTime", "EstimatedChargeRemaining", "Chemistry", "DesignCapacity", "FullChargeCapacity", "DesignVoltage", "SmartBatteryVersion", "TimeToFullCharge", "ExpectedLife", "MaxRechargeTime", "RechargeCount", "MaxRechargeCount", "RemainingCapacity", "RemainingCapacityMaxError"};
SupportedMethods = {"RequestStateChange", "SetPowerState", "Reset", "EnableDevice", "OnlineDevice", "QuiesceDevice", "SaveProperties", "RestoreProperties"};
CapabilityID = "Battery_OpenDRIM_Battery";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_Battery.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_Battery]   
   provider: Battery_OpenDRIM_BatteryProvider
   location: cmpiBattery_OpenDRIM_BatteryProvider
   type: instance method
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_Battery.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_Battery-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_Battery.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
