/*###############################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef PHYSICALASSET_COMMON_H_
#define PHYSICALASSET_COMMON_H_

#include <Common.h>
#include <SMBIOS.h>

// Define PhysicalType Constants
#define PT_UNKNOWN					0	// Unknown
#define PT_OTHER					1	// Other
#define PT_RACK						2	// Rack
#define PT_CHASSIS_FRAME			3	// Chassis/Frame
#define PT_CROSS_CONNECT_BACKPLANE	4	// Cross Connect/Backplane
#define PT_CONTAINER_FRAME_SLOT		5	// Container/Frame Slot
#define PT_POWER_SUPPLY				6	// Power Supply
#define PT_FAN						7	// Fan
#define PT_SENSOR					8	// Sensor
#define PT_MODULE_CARD				9	// Module/Card
#define PT_PORT_CONNECTOR			10	// Port/Connector
#define PT_BATTERY					11	// Battery
#define PT_PROCESSOR				12	// Processor
#define PT_MEMORY					13	// Memory
#define PT_POWER_SOURCE_GENERATOR	14	// Power Source/Generator
#define PT_STORAGE_MEDIA_PACKAGE	15	// Storage Media Package
#define PT_BLADE					16	// Blade
#define PT_BLADE_EXPANSION			17	// Blade Expansion

int CF_getComputerSystemPhysicalPackageTag(string& tag,string& errorMessage);
int CF_getSystemUUID(string& uuid,string& errorMessage);

#endif /*PHYSICALASSET_COMMON_H_*/
