/*###############################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "cmpiOpenDRIM_ConfigurationCapacity.h"

CMPIObjectPath* PhysicalAsset_OpenDRIM_ConfigurationCapacity_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_ConfigurationCapacity& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_ConfigurationCapacity_classnames[0], OpenDRIM_ConfigurationCapacity_NAMESPACE);

	if (!instance.Name_isNULL)
		op.addKey("Name", instance.Name);

	if (!instance.ObjectType_isNULL)
		op.addKey("ObjectType", instance.ObjectType);

	_L_;
	return op.getHdl();
}

CMPIInstance* PhysicalAsset_OpenDRIM_ConfigurationCapacity_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_ConfigurationCapacity& instance) {
	_E_;
	Objectpath op(broker, PhysicalAsset_OpenDRIM_ConfigurationCapacity_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.OtherTypeDescription_isNULL)
		ci.setProperty("OtherTypeDescription", instance.OtherTypeDescription);

	if (!instance.MinimumCapacity_isNULL)
		ci.setProperty("MinimumCapacity", instance.MinimumCapacity);

	if (!instance.MaximumCapacity_isNULL)
		ci.setProperty("MaximumCapacity", instance.MaximumCapacity);

	if (!instance.Increment_isNULL)
		ci.setProperty("Increment", instance.Increment);

	if (!instance.VendorCompatibilityStrings_isNULL)
		ci.setProperty("VendorCompatibilityStrings", instance.VendorCompatibilityStrings);

	_L_;
	return ci.getHdl();
}

void PhysicalAsset_OpenDRIM_ConfigurationCapacity_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_ConfigurationCapacity& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("Name", instance.Name) == OK)
		instance.Name_isNULL = false;

	if (op.getKey("ObjectType", instance.ObjectType) == OK)
		instance.ObjectType_isNULL = false;

	_L_;
}

void PhysicalAsset_OpenDRIM_ConfigurationCapacity_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_ConfigurationCapacity& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getProperty("Name", instance.Name) == OK)
		instance.Name_isNULL = false;

	if (inst.getProperty("ObjectType", instance.ObjectType) == OK)
		instance.ObjectType_isNULL = false;

	if (inst.getProperty("OtherTypeDescription", instance.OtherTypeDescription) == OK)
		instance.OtherTypeDescription_isNULL = false;

	if (inst.getProperty("MinimumCapacity", instance.MinimumCapacity) == OK)
		instance.MinimumCapacity_isNULL = false;

	if (inst.getProperty("MaximumCapacity", instance.MaximumCapacity) == OK)
		instance.MaximumCapacity_isNULL = false;

	if (inst.getProperty("Increment", instance.Increment) == OK)
		instance.Increment_isNULL = false;

	if (inst.getProperty("VendorCompatibilityStrings", instance.VendorCompatibilityStrings) == OK)
		instance.VendorCompatibilityStrings_isNULL = false;

	_L_;
}

