/*###############################################################################
# Linux Management Providers (LMP), Power Supply provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef POWERSUPPLY_COMMON_H_
#define POWERSUPPLY_COMMON_H_

#include <Common.h>
#include <SMBIOS.h>

typedef struct _system_power_supply
{
	BYTE type;                         // 39
	BYTE length;                       // Varies
	WORD handle;                       // Varies
	BYTE power_unit_group;             // Varies
	BYTE location;                     // STRING
	BYTE device_name;                  // STRING
	BYTE manufacturer;                 // STRING
	BYTE serial_number;                // STRING
	BYTE asset_tag_number;             // STRING
	BYTE model_part_number;            // STRING
	BYTE revision_level;               // STRING
	WORD max_power_capacity;           // Varies
	WORD power_supply_characteristics; // Varies
	WORD input_voltage_probe_handle;   // Varies
	WORD cooling_device_handle;        // Varies
	WORD input_current_probe_handle;   // Varies
}system_power_supply;

int SMBIOS_getPowerSupplyInformation(vector<system_power_supply>& power,vector< vector<string> >& dmi_strings,string& errorMessage);

#endif /*POWERSUPPLY_COMMON_H_*/
