#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Ghost of a Tale
# send your bug reports to contact@dotslashplay.it
###

script_version=20230328.3

GAME_ID='ghost-of-a-tale'
GAME_NAME='Ghost of a Tale'

ARCHIVE_BASE_0='setup_ghost_of_a_tale_833_(28317).exe'
ARCHIVE_BASE_0_MD5='ce98494f39f3908d33ef46e438d94da4'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1='setup_ghost_of_a_tale_833_(28317)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='e5a2d7c834572c438c324a5104692afb'
ARCHIVE_BASE_0_SIZE='5000000'
ARCHIVE_BASE_0_VERSION='8.33-gog28317'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/ghost_of_a_tale'

UNITY3D_NAME='goat'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES="
${UNITY3D_NAME}.exe
${UNITY3D_NAME}_data/mono
${UNITY3D_NAME}_data/plugins
goat_clearpreferences.cmd
goat_createreport.cmd
unityplayer.dll"
CONTENT_GAME_DATA_FILES="
${UNITY3D_NAME}_data
icon.ico
remote_config_cache_production_worldwide.json
steam_appid.txt"

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Documents/My Games/Ghost of a Tale'

APP_MAIN_EXE="${UNITY3D_NAME}.exe"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Set up a WINE virtual desktop on first launch, using the current desktop resolution

PKG_BIN_DEPS="$PKG_BIN_DEPS xrandr sed"
sed_expression='s/.*primary.* ([0-9]+x[0-9]+).*/\1/p'
sed_options="--regexp-extended --silent --expression='$sed_expression'"
APP_WINETRICKS="$APP_WINETRICKS vd=\$(LANG=C xrandr | sed $sed_options)"

# Load common functions

target_version='2.23'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
