      SUBROUTINE INITPOP
C
C INITIALIZES COMMON BLOCK /SYM/.
C
C  DESCRIPTION OF /SYM/
C
C         POP1   ...... NUMBER OF OCCUPIED ALPHA ORBITALS WITHIN EACH IRREP
C         POP2   ...... NUMBER OF OCCUPIED BETA ORBITALS WITIN EACH IRREP
C         VRT1   ...... NUMBER OF VIRTUAL ALPHA ORBITALS WITHIN EACH IRREP
C         VRT2   ...... NUMBER OF VIRTUAL BETA ORBITALS WITHIN EACH IRREP
C         NTAA   ...... LENGTH OF T1(A,I) ALPHA
C         NTBB   ...... LENGTH OF T1(A,I) BETA
C         NF1AA  ...... LENGTH OF F(M,I) ALPHA ( NOTE ALL Fs ARE NOT SYMMETRIC)
C         NF1BB  ...... LENGTH OF F(M,I) BETA
C         NF2AA  ...... LENGTH OF F(A,E) ALPHA
C         NF2BB  ...... LENGTH OF F(A,E) BETA
C
CEND
      IMPLICIT INTEGER (A-Z)
      COMMON/SYM/POP1(8),POP2(8),VRT1(8),VRT2(8),
     &           NTAA,NTBB,NF1AA,NF1BB,NF2AA,NF2BB
      COMMON/SYMINF/NSTART,NIRREP,IRREPA(255),IRREPB(255),DIRPRD(8,8)
C
      CALL GETREC(-1,'JOBARC','SYMPOPOA',NIRREP,POP1)
      CALL GETREC(-1,'JOBARC','SYMPOPOB',NIRREP,POP2)
      CALL GETREC(-1,'JOBARC','SYMPOPVA',NIRREP,VRT1)
      CALL GETREC(-1,'JOBARC','SYMPOPVB',NIRREP,VRT2)
C
      NTAA=0
      NTBB=0
      NF1AA=0
      NF1BB=0
      NF2AA=0
      NF2BB=0
      DO 100 IRREP=1,NIRREP
       POPA=POP1(IRREP)
       POPB=POP2(IRREP)
       VRTA=VRT1(IRREP)
       VRTB=VRT2(IRREP)
       NTAA=NTAA+POPA*VRTA
       NTBB=NTBB+POPB*VRTB
       NF1AA=NF1AA+POPA*POPA
       NF1BB=NF1BB+POPB*POPB
       NF2AA=NF2AA+VRTA*VRTA
       NF2BB=NF2BB+VRTB*VRTB
100   CONTINUE
      RETURN
      END
