//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _r2root_8.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <iostream>
#include <cassert>
#include <src/integral/rys/r2rootlist.h>

using namespace std;
using namespace bagel;

void R2RootList::r2root8(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[8] = {1.702802819153788e-01,9.037052243967045e-01,2.251095217743607e+00,4.266716447839822e+00,7.045932282957874e+00,
    1.075855705516558e+01,1.574073869493151e+01,2.286321896641308e+01};
  constexpr double aw[8] = {1.845949988836659e-01,2.093941891931090e-01,8.789782860074327e-02,1.667180971711020e-02,1.397273445984399e-03,
    4.538271689275045e-05,4.242889529944034e-07,5.240025838609234e-10};
  constexpr double x[4216] = {  1.921673699556425e-02,  5.943685183164107e-04,  1.364678518116933e-05,  2.747447886201551e-07,  5.092939108547573e-09,
  8.858221978408888e-11,  1.454169716771688e-12,  2.248963128538644e-14,  3.242315109285809e-16,  4.251338472413684e-18,  4.764590619094435e-20,  3.663404966506208e-22,
  1.679842638942367e-01,  4.782625359212809e-03,  9.238231637043146e-05,  1.341862330695208e-06,  1.276601206259359e-08, -6.966382311758092e-12, -3.524178773749721e-12,
 -8.839201720269046e-14, -1.258046508994691e-15, -5.796247860325171e-18,  2.519771426680815e-19,  8.833166832506411e-21,  4.404563110982569e-01,  1.058347658051355e-02,
  1.350712723533247e-04,  3.580304356339456e-07, -2.407517010199867e-08, -4.811569164075248e-10, -8.723198982929593e-13,  1.397683922185441e-13,  2.744306645515208e-15,
 -8.659521298747225e-19, -1.028346512692856e-18, -1.848381861509268e-20,  7.925755712979973e-01,  1.458444012033347e-02,  6.582157660024893e-05, -1.911728764393033e-06,
 -2.505664159278484e-08,  3.903292725666352e-10,  9.987796826079029e-12, -7.281620269967054e-14, -3.991672301194234e-15,  2.980127779074497e-18,  1.557553860139650e-18,
  8.493403745758602e-21,  1.170642892781684e+00,  1.462784235040928e-02, -5.972279695290334e-05, -1.915941965136680e-06,  2.337468597323872e-08,  3.886614099730549e-10,
 -9.372508530653195e-12, -7.161246866199080e-14,  3.709282345436226e-15,  2.898368343309705e-18, -1.420558765257450e-18,  8.051426462208410e-21,  1.520630513159132e+00,
  1.086930568653552e-02, -1.283980894637321e-04,  1.984009233861829e-07,  2.373152720556342e-08, -4.134431014043414e-10, -8.092638007257969e-14,  1.272168715700634e-13,
 -2.114030212984146e-15, -6.645136430862498e-18,  8.523968650751281e-19, -1.259695491684537e-20,  1.795501810374323e+00,  5.431340648187552e-03, -9.634386732849908e-05,
  1.237628941281933e-06, -8.903007833212161e-09, -7.022327552130379e-11,  3.805345208036648e-12, -7.244935414797011e-14,  7.071696637389435e-16,  3.575275123074060e-18,
 -3.045089289991156e-19,  6.679876329904293e-21,  1.960176595772441e+00,  1.149234193623316e-03, -2.439786272874518e-05,  4.481152290907910e-07, -7.438034208675184e-09,
  1.126923479687286e-10, -1.542935093908029e-12,  1.838236296274171e-14, -1.691589883198481e-16,  5.359184112053668e-19,  2.494154323235437e-20, -8.504080702936857e-22,
  2.183559036773144e-02,  7.182639490840268e-04,  1.749789147885032e-05,  3.725383474633265e-07,  7.271300363882499e-09,  1.323665402303703e-10,  2.254937659143504e-12,
  3.571078385009145e-14,  5.150609582057143e-16,  6.426300853873332e-18,  5.860673543751110e-20,  6.945347143557334e-24,  1.886997090116785e-01,  5.589520675391133e-03,
  1.096882175823672e-04,  1.539483417829299e-06,  1.155640132822723e-08, -1.258973286732345e-10, -6.575164146243967e-12, -1.291407984063673e-13, -1.169879311528149e-15,
  1.446670174244320e-17,  8.228563196092538e-19,  1.716584902575667e-20,  4.849683585829130e-01,  1.167395234563076e-02,  1.367392314440101e-04, -1.037892247476394e-07,
 -3.354066229500864e-08, -4.455570795976551e-10,  4.200695060320959e-12,  2.176794231011548e-13,  1.797371078084983e-15, -5.562579261165907e-17, -1.595843520013501e-18,
 -2.717787039326194e-21,  8.518124472473032e-01,  1.501310778436035e-02,  4.077269183101256e-05, -2.238105581991995e-06, -1.509071191424912e-08,  5.916737027900373e-10,
  6.264171374668371e-12, -1.866088061826116e-13, -2.754315164785363e-15,  6.372494434845863e-17,  1.249416980113444e-18, -2.249209780095165e-20,  1.228062737607384e+00,
  1.406496162486340e-02, -8.025449023635876e-05, -1.492425785140330e-06,  2.880447162660725e-08,  1.528008220613465e-10, -9.772508946917681e-12,  3.885452386747446e-14,
  2.931346346670377e-15, -4.109156063791610e-17, -6.769494115041131e-19,  2.196581545540219e-20,  1.562076735109506e+00,  9.857475522271867e-03, -1.240092898894337e-04,
  5.129217694531345e-07,  1.569209372542098e-08, -3.802981740877540e-10,  2.538549346699122e-12,  6.120390202765134e-14, -1.877071666937252e-15,  1.609538866462193e-17,
  2.975546935796656e-19, -1.101482257947568e-20,  1.815776208068347e+00,  4.717496545775053e-03, -8.237905431490433e-05,  1.088264352634532e-06, -9.545049055313693e-09,
 -6.329164492587417e-13,  2.099179418022507e-12, -4.960040033507854e-14,  6.777806480258179e-16, -3.782629277948570e-18, -8.826559631624323e-20,  3.293558210971208e-21,
  1.964414577672096e+00,  9.736967232014131e-04, -1.966621939092129e-05,  3.452897486074819e-07, -5.515866081893087e-09,  8.124985555434442e-11, -1.100095574260196e-12,
  1.341077455032001e-14, -1.389328342364792e-16,  9.953697734481557e-19,  2.180024222615581e-21, -2.731534780232727e-22,  2.502000908023804e-02,  8.783288501879346e-04,
  2.276429911943393e-05,  5.133746071994186e-07,  1.055139880128621e-08,  2.005759357068134e-10,  3.523500237334449e-12,  5.632724381527900e-14,  7.854491089433665e-16,
  8.390769684334273e-18,  2.576464754344368e-20, -1.943955290809393e-21,  2.129339113479525e-01,  6.543811508819551e-03,  1.291570434954306e-04,  1.694371421364330e-06,
  7.148654667998455e-09, -3.305758183655098e-10, -1.058251977007920e-11, -1.503061584454517e-13,  1.408598478196975e-16,  6.399907183366263e-17,  1.664592492453471e-18,
  1.820456416913904e-20,  5.338303930047007e-01,  1.275313026351114e-02,  1.320034165894121e-04, -7.040900047426888e-07, -4.092579377550923e-08, -2.673864062636682e-10,
  1.071366517661608e-11,  2.312121798207525e-13, -1.288157157224241e-15, -1.111427933525370e-16, -8.818057144450563e-19,  3.759000226590034e-20,  9.123425916627410e-01,
  1.522869854743746e-02,  1.287846085340347e-05, -2.378646302000731e-06, -2.218464719135603e-09,  6.717624396217874e-10,  2.055666890362382e-13, -2.307399792840059e-13,
  1.412091419426711e-16,  8.779353879643007e-17, -1.394147480774824e-19, -3.502205080169075e-20,  1.282936353825429e+00,  1.335927609163185e-02, -9.533737236419305e-05,
 -1.019307831518225e-06,  2.965165862095388e-08, -5.959162423880462e-11, -7.620113517750956e-12,  1.056306080986400e-13,  1.192609199029956e-15, -4.963085845939075e-17,
  2.010988296729269e-19,  1.553538191365025e-20,  1.599566764319769e+00,  8.893735573544694e-03, -1.165867472877199e-04,  7.069258655049823e-07,  8.801614821660081e-09,
 -3.050000019821620e-10,  3.509838200202496e-12,  1.186270100064596e-14, -1.184090782576382e-15,  2.009220465343314e-17, -5.187431694631309e-20, -4.818092604652979e-21,
  1.833407190655927e+00,  4.108119197631805e-03, -7.022894554772831e-05,  9.377497282951532e-07, -9.154334213294372e-09,  3.538849067891555e-11,  9.901015559978336e-13,
 -3.053326249418995e-14,  5.062452756227059e-16, -5.133312445683977e-18,  5.625210422177806e-21,  1.214809975188878e-21,  1.968018980798345e+00,  8.315553388219265e-04,
 -1.600295943767357e-05,  2.687204017044862e-07, -4.126931540100042e-09,  5.888442917658795e-11, -7.814390999474018e-13,  9.536756176705849e-15, -1.036596600237100e-16,
  9.229919170437574e-19, -4.208274847104278e-21, -5.149157395087126e-23,  2.894106453872282e-02,  1.088292813588441e-03,  3.008658812869404e-05,  7.194747179782137e-07,
  1.555217917987556e-08,  3.071867601719749e-10,  5.498024249928379e-12,  8.624671951035213e-14,  1.072825610684046e-15,  6.230970880647278e-18, -1.829720349741689e-19,
 -8.820164214458429e-21,  2.413064034898225e-01,  7.659743031248504e-03,  1.499090722211707e-04,  1.740668458363333e-06, -2.330110609273886e-09, -6.319277583977178e-10,
 -1.428232902276016e-11, -9.481871549440046e-14,  3.786861705029495e-15,  1.405096156696371e-16,  1.922843735114588e-18, -1.502094769598755e-20,  5.868853335939614e-01,
  1.376392421667380e-02,  1.194999455910108e-04, -1.385645584777114e-06, -4.321820363798574e-08,  5.892392790902750e-11,  1.598273788389697e-11,  1.231072032797751e-13,
 -5.420745482557524e-15, -1.023169189906791e-16,  1.524518579331574e-18,  6.412244692750198e-20,  9.732831475183846e-01,  1.521795986869312e-02, -1.543993597607452e-05,
 -2.308542693890995e-06,  1.075746243401963e-08,  6.024887238309824e-10, -5.740920621640091e-12, -1.795342943865172e-13,  2.864406004543768e-15,  5.561169676126586e-17,
 -1.313262734350284e-18, -1.407787851534357e-20,  1.334781784711470e+00,  1.255556568756695e-02, -1.047911351052404e-04, -5.632897545562227e-07,  2.688614767480216e-08,
 -2.042364346856067e-10, -4.379060311086030e-12,  1.178712910995968e-13, -3.188760742992855e-16, -3.168893902851030e-17,  6.032474629185453e-19,  2.973994112881608e-21,
  1.633332851425595e+00,  7.996934488301100e-03, -1.074450149252399e-04,  8.035727815192362e-07,  3.551508478693523e-09, -2.204141180835007e-10,  3.415481614800793e-12,
 -1.517392324568586e-14, -5.347922815248033e-16,  1.532080450101304e-17, -1.537750122860150e-19, -3.190309066845708e-22,  1.848783837908418e+00,  3.588870503082707e-03,
 -5.982794595669330e-05,  7.979737357307965e-07, -8.269440529417720e-09,  5.055532276245093e-11,  3.349969331834327e-13, -1.716317579233663e-14,  3.352725358899396e-16,
 -4.166987244260373e-18,  3.617677633514177e-20,  3.061859778055134e-22,  1.971108102994876e+00,  7.153910258894549e-04, -1.313870445049265e-05,  2.111764365592407e-07,
 -3.116970355129897e-09,  4.298887673864574e-11, -5.561015226983136e-13,  6.716363493376707e-15, -7.371363246641836e-17,  7.401965387673801e-19, -4.351644954415071e-21,
  2.849055207933958e-23,  3.383695291164860e-02,  1.368268368006124e-03,  4.044167678470247e-05,  1.025521734134605e-06,  2.323171935497349e-08,  4.721312265965399e-10,
  8.411643314916017e-12,  1.217508234114059e-13,  1.033485242933184e-15, -1.329655930498551e-17, -9.344263144055520e-19, -2.841562269015587e-20,  2.744738939927288e-01,
  8.940849116865102e-03,  1.700942692521465e-04,  1.583062438019898e-06, -1.851910750060864e-08, -9.877198026630674e-10, -1.438815285406002e-11,  1.195615501183951e-13,
  9.869864367427465e-15,  1.813404554904954e-16, -5.489706972728576e-19, -1.057816794910233e-19,  6.437314186181939e-01,  1.464188666244199e-02,  9.883192045189513e-05,
 -2.046086595080972e-06, -3.803844585091960e-08,  4.614217344039205e-10,  1.656208090686131e-11, -9.229949517867918e-14, -7.378733238277999e-15,  8.151425197727656e-18,
  3.674331993058839e-18,  1.981189777155801e-20,  1.033737766395953e+00,  1.498741584940550e-02, -4.174051626710200e-05, -2.049014118321643e-06,  2.108222466827287e-08,
  4.162082347100519e-10, -9.260289261886389e-12, -6.665046803924631e-14,  3.853240267753811e-15, -4.636298314954256e-19, -1.291697259847402e-18,  1.263857096269941e-20,
  1.383294454179803e+00,  1.169716963688762e-02, -1.091198451589349e-04, -1.704099631794169e-07,  2.200796131499578e-08, -2.717668057289690e-10, -1.359222977174316e-12,
  9.414906476943843e-14, -1.020477286997835e-15, -7.793301644195239e-18,  5.307654610444948e-19, -5.394456243352505e-21,  1.663663498173217e+00,  7.176604942137817e-03,
 -9.759270811130410e-05,  8.294113089996254e-07, -7.945878898899927e-11, -1.450075193540055e-10,  2.825520995890055e-12, -2.463713812321205e-14, -9.155553303659662e-17,
  9.475982553850540e-18, -1.300901089281845e-19,  8.410592776188681e-22,  1.862239647321625e+00,  3.146379340634029e-03, -5.101174348940738e-05,  6.740451198319548e-07,
 -7.211145570285749e-09,  5.391261573135929e-11, -1.582522564161553e-14, -8.538597885194457e-15,  2.131043069535956e-16, -2.608728729652441e-18,  3.788260035667946e-20,
 -2.323023660848328e-22,  1.973774380899898e+00,  6.196309741307906e-04, -1.087762885280807e-05,  1.675174230893115e-07, -2.376701712269247e-09,  3.165607682208412e-11,
 -3.972851027456370e-13,  4.752966420356077e-15, -4.987169834578617e-17,  5.925382189550707e-19, -3.191743037449823e-21,  6.348319037263744e-24,  4.004499707181178e-02,
  1.748140754624089e-03,  5.532863036748732e-05,  1.484956576271852e-06,  3.498553958814461e-08,  7.178841483010704e-10,  1.214311189721853e-11,  1.368821734683510e-13,
 -5.165652922731064e-16, -8.681963758932786e-17, -3.077207402142040e-18, -7.468518609249260e-20,  3.130698775301117e-01,  1.037093835732765e-02,  1.866053310829960e-04,
  1.111813461212711e-06, -4.124682976419626e-08, -1.251553206138167e-09, -5.729525895273817e-12,  5.246399253829942e-13,  1.460167100638671e-14,  3.652744413356793e-17,
 -7.281860594103345e-18, -1.826789799206780e-19,  7.037112605014855e-01,  1.532481881818759e-02,  7.099815857987848e-05, -2.560622449509809e-06, -2.517744585168442e-08,
  8.025156936686183e-10,  1.092038637860527e-11, -2.952646226219697e-13, -4.477202618914682e-15,  1.450612646156421e-16,  2.466193343417951e-18, -7.479798365524010e-20,
  1.092872684648084e+00,  1.456142544723234e-02, -6.407034744921883e-05, -1.657567915429555e-06,  2.710350110486754e-08,  1.851591133236690e-10, -9.466511088690415e-12,
  4.770301419126771e-14,  3.068614823711769e-15, -3.834923408738885e-17, -5.893773367365166e-19,  1.464654423359331e-20,  1.428332161074549e+00,  1.082159693479887e-02,
 -1.092348232262591e-04,  1.372902286247907e-07,  1.644026239503955e-08, -2.765700949540006e-10,  8.036652465648094e-13,  6.054611323023375e-14, -9.897794387370224e-16,
  7.237076849112566e-18,  1.911871107928787e-19, -9.451212306262669e-21,  1.690871177484790e+00,  6.435455758015993e-03, -8.773181748634269e-05,  8.083864396717422e-07,
 -2.357860296182799e-09, -8.552332516297034e-11,  2.139134655097988e-12, -2.305628303050772e-14,  1.622797743292192e-16,  4.703819460639050e-18, -1.193923529529143e-19,
 -6.004724007559660e-22,  1.874057542580302e+00,  2.768759589157448e-03, -4.358014750568504e-05,  5.672037354746189e-07, -6.152406694368803e-09,  5.135740928816379e-11,
 -1.716382640090853e-13, -2.960446274845267e-15,  1.423131355503946e-16, -1.485214608275300e-18,  1.348408917588832e-20, -8.823329093024748e-22,  1.976090740863644e+00,
  5.400492805057549e-04, -9.076251904535663e-06,  1.340793556888929e-07, -1.829000482542909e-09,  2.355670895168697e-11, -2.835180341098226e-13,  3.472669095412716e-15,
 -3.102213514587270e-17,  4.419505681070079e-19, -5.144314714228836e-21, -1.018596109037034e-22,  4.805068509630404e-02,  2.272764015442926e-03,  7.703519660795035e-05,
  2.176644070409986e-06,  5.254243815244388e-08,  1.049524325232288e-09,  1.506187750662139e-11,  3.891798922838052e-14, -6.841058383114903e-15, -2.970366744591798e-16,
 -8.004080466365914e-18, -1.517096780817773e-19,  3.576054408472879e-01,  1.190400665285106e-02,  1.951530924158935e-04,  2.500816826226972e-07, -6.619360540079655e-08,
 -1.161154802814074e-09,  1.521149807825974e-11,  9.418729685471885e-13,  8.897295772357843e-15, -3.931252591637148e-16, -1.302655087097706e-17, -1.931337080997055e-20,
  7.659439374968129e-01,  1.576434337835613e-02,  3.842120653930054e-05, -2.823854018078018e-06, -7.237196014379252e-09,  9.545299604876183e-10,  1.524686819439031e-12,
 -3.435663763714279e-13,  1.555595460443408e-15,  1.605641895488477e-16, -1.912141178263358e-18, -1.039913350927708e-19,  1.149977967135428e+00,  1.397687580594276e-02,
 -8.127532489150522e-05, -1.205994718615449e-06,  2.869434061237461e-08, -1.632398649247313e-11, -6.989860459748513e-12,  1.202956296140399e-13,  1.384312141831968e-15,
 -5.291422163436375e-17, -2.392810011205646e-19,  1.455876620061591e-21,  1.469886996282325e+00,  9.958369065423585e-03, -1.061867894900280e-04,  3.576466371321001e-07,
  1.122170910554040e-08, -2.402448065621352e-10,  2.100390275264710e-12,  3.368121610271324e-14, -6.948365169041699e-16,  6.320375860802224e-18, -2.317141589064692e-19,
 -8.640152388751634e-21,  1.715269673557508e+00,  5.771649515603126e-03, -7.830551512023139e-05,  7.595591022393646e-07, -3.603655300766941e-09, -4.122254119125375e-11,
  1.584695200025682e-12, -1.615751415292714e-14,  2.348346844078309e-16, -1.062716030420916e-18, -1.765131995954912e-19, -1.575728502000906e-21,  1.884476144496736e+00,
  2.445747238485467e-03, -3.733121888966622e-05,  4.767390602069183e-07, -5.170709090585511e-09,  4.671025199611812e-11, -1.985545829606900e-13,  7.574851971254342e-16,
  8.793058926484110e-17, -1.849400862312789e-18, -3.315849083349493e-20, -1.063573002003971e-21,  1.978115250023061e+00,  4.734111469857773e-04, -7.628447983019356e-06,
  1.082459279046956e-07, -1.418557943633766e-09,  1.781994798311347e-11, -1.981319358030242e-13,  2.684332925315685e-15, -2.014510598867983e-17,  1.212157792792655e-19,
 -1.123170222851581e-20, -1.446189881787375e-22,  5.856216903030587e-02,  3.009538446086095e-03,  1.089549228763305e-04,  3.204662177803921e-06,  7.705711849764748e-08,
  1.386914840800975e-09,  1.095774195525279e-11, -4.269652117578817e-13, -2.504935327971975e-14, -7.639198968709927e-16, -1.528553530912503e-17, -1.347980518009056e-19,
  4.083353964562992e-01,  1.345764074716950e-02,  1.911228352259496e-04, -9.656217853673301e-07, -8.353185108973211e-08, -4.640227431259906e-10,  4.275005495374920e-11,
  9.049970087591794e-13, -1.374330336887489e-14, -8.079942062542557e-16, -4.386866679623158e-18,  4.259315834165327e-19,  8.294005684197228e-01,  1.593564771312617e-02,
  4.468060023415196e-06, -2.788044143146037e-06,  1.148927005116688e-08,  8.859187700740554e-10, -6.681428112578563e-12, -2.239614291494884e-13,  5.026620615839485e-15,
  1.289855271602566e-17, -4.772047685201524e-18, -9.937862651394148e-21,  1.204504328153928e+00,  1.327651226152052e-02, -9.302960837789322e-05, -7.573997931294648e-07,
  2.698128861844611e-08, -1.404808914219432e-10, -3.300776966156773e-12,  1.322899449604540e-13, -6.911597476554952e-16, -6.237075953519226e-17, -2.185814994176789e-19,
  3.544074313977005e-21,  1.508052516888501e+00,  9.128748130737267e-03, -1.009666636404592e-04,  5.017710957270892e-07,  6.984915991900459e-09, -1.809012729028846e-10,
  2.749849868501898e-12,  1.266525173993730e-14, -7.081426841918744e-16, -8.487251257346628e-18, -4.414553530448840e-19,  5.227733364535655e-22,  1.737159659507125e+00,
  5.180634099853300e-03, -6.955765543847091e-05,  6.972319561011998e-07, -4.080373058903372e-09, -7.856643170417004e-12,  1.221351790741086e-12, -1.072846683610994e-14,
  5.692640220514453e-17, -8.989864195029961e-18, -1.988859674055684e-19,  1.279748019964705e-21,  1.893696172120828e+00,  2.168643902788872e-03, -3.207671662605278e-05,
  4.012344773010091e-07, -4.281096993838859e-09,  4.244469584903927e-11, -1.502558506233659e-13,  2.171407532749924e-15, -1.169644656705778e-17, -3.857307290199784e-18,
 -5.802165006836415e-20,  1.925156918195317e-22,  1.979894555152713e+00,  4.172190492768966e-04, -6.454687437355972e-06,  8.816609171167472e-08, -1.103994126091541e-09,
  1.389453188575074e-11, -1.320200938824626e-13,  2.012459327880693e-15, -2.505651896709323e-17, -4.131928211229087e-19, -1.391858725057790e-20,  6.938314160822967e-23,
  7.261960820645325e-02,  4.058134032834408e-03,  1.557541755823784e-04,  4.667708557697581e-06,  1.058649680762736e-07,  1.386049824149578e-09, -1.723293904758810e-11,
 -1.791816343314775e-12, -6.392814210750796e-14, -1.361327342974520e-15, -9.000675409657789e-18,  6.615143008694515e-19,  4.651180340683085e-01,  1.491724771528419e-02,
  1.714112656293336e-04, -2.313255606606504e-06, -8.087179669345060e-08,  7.892949093566850e-10,  5.756034788315813e-11,  8.334226099772173e-15, -4.065618274772575e-14,
 -5.289352936877028e-16,  1.895241896357584e-17,  4.991918456702362e-19,  8.930088614851562e-01,  1.584197186988249e-02, -2.733406812055381e-05, -2.472993821620493e-06,
  2.718717622374092e-08,  6.676233069557776e-10, -1.088684448770338e-11, -9.106905936548917e-14,  2.298224797421557e-15, -1.489537281501116e-16, -2.467204045919147e-18,
  1.049027174825411e-19,  1.256074392443647e+00,  1.250302359581503e-02, -9.963158817895851e-05, -3.512929622030514e-07,  2.365761759900288e-08, -1.798714687865283e-10,
 -2.526681089288500e-13,  7.316357361361920e-14, -3.009878280323958e-15, -6.274964355969940e-17,  3.445053587788097e-19,  2.294680914405035e-20,  1.542992526912943e+00,
  8.346748453514435e-03, -9.438242971916403e-05,  5.882410824320647e-07,  4.040720071576740e-09, -1.136086661857107e-10,  2.718427470537146e-12, -1.800861976169090e-14,
 -1.289618527490557e-15, -2.168138939954859e-17, -1.193334147875189e-19,  1.392091406140842e-20,  1.756820692856782e+00,  4.656528027055867e-03, -6.158289371191183e-05,
  6.321787994823281e-07, -3.969105037387596e-09,  1.770735786660260e-11,  8.879458950421906e-13, -1.541812131066965e-14, -3.822147884719098e-16, -1.425343968535256e-17,
 -2.427198314204145e-20,  6.696148632754092e-21,  1.901886453714895e+00,  1.930188302644309e-03, -2.764545862968817e-05,  3.393502612618197e-07, -3.464157831215390e-09,
  3.938261677559689e-11, -1.184889703758564e-13, -8.190776475726777e-16, -1.846335211540631e-16, -5.382178096707404e-18, -2.299059466627123e-21,  2.351448763353580e-21,
  1.981466459583027e+00,  3.695333247661951e-04, -5.494017067355687e-06,  7.257047334619464e-08, -8.537638049086857e-10,  1.129431174917272e-11, -8.983259728379293e-14,
  8.776467207375130e-16, -4.822508248766046e-17, -7.989563530675371e-19, -2.562972331034252e-21,  4.499624530875171e-22,  9.174207713203410e-02,  5.558869889576752e-03,
  2.227138098295222e-04,  6.539038471429797e-06,  1.239967937354087e-07,  9.355920802784452e-11, -1.033940485435347e-10, -4.595917727696903e-12, -1.063320427702406e-13,
 -4.303625464890497e-16,  7.848077772619431e-17,  3.803249425648322e-18,  5.273249260043733e-01,  1.615718086877674e-02,  1.366460510963415e-04, -3.408590658300614e-06,
 -5.206494969382024e-08,  2.015067059589472e-09,  3.796443429069533e-11, -1.417427487662196e-12, -4.224335609319586e-14,  4.962900453508480e-16,  2.706804127702037e-17,
 -1.936007180710110e-19,  9.557631131519806e-01,  1.551290915464023e-02, -5.400753706310873e-05, -1.946161419895674e-06,  3.774047530882111e-08,  3.786570309925174e-10,
 -1.329189218797946e-11, -1.123810045059051e-13, -3.590827460789215e-15, -1.416947830266713e-16,  2.996849892068692e-18,  1.299396603668063e-19,  1.304474407683418e+00,
  1.169527072880445e-02, -1.016943787629232e-04, -1.404657817143344e-09,  2.010089842953329e-08, -1.741734831904616e-10,  1.399008133880169e-13, -5.433520741586761e-14,
 -4.728190793543035e-15, -2.340916778500840e-17,  1.753224264580992e-18,  4.155485584825910e-20,  1.574915459668540e+00,  7.620872784635158e-03, -8.699981741043613e-05,
  6.379954069710715e-07,  2.352951324714379e-09, -5.980136252345320e-11,  1.520444231024705e-12, -7.129067734015621e-14, -1.978638593940907e-15, -1.095492625219382e-17,
  7.352930238101924e-19,  2.523494157838345e-20,  1.774508044046594e+00,  4.193163450350368e-03, -5.436281872662884e-05,  5.724865179461475e-07, -3.445947605203558e-09,
  3.199056254468817e-11,  2.103036668076104e-13, -3.538165455137879e-14, -8.283658665562083e-16, -7.850896911281661e-18,  3.827299058347024e-19,  1.213593564303160e-20,
  1.909189417514464e+00,  1.724429957591965e-03, -2.388037777094799e-05,  2.900483809465922e-07, -2.710994920433374e-09,  3.542203938784598e-11, -2.520463580592931e-13,
 -9.607190191623467e-15, -3.496806434911007e-16, -2.805227085248138e-18,  1.468046979095497e-19,  4.568402657047903e-21,  1.982861897828832e+00,  3.288487810428052e-04,
 -4.698043383707144e-06,  6.060507958935203e-08, -6.484600413111460e-10,  9.232629911735823e-12, -9.107260904092460e-14, -1.100414180887663e-15, -7.308524162896151e-17,
 -3.974981566992343e-19,  2.548834799450277e-20,  8.538428618485640e-22,  1.180843453672680e-01,  7.687202499842846e-03,  3.125749430753682e-04,  8.352563454877530e-06,
  8.869125738129090e-08, -4.299710326782403e-09, -2.754433397674298e-10, -7.235370443398046e-12, -1.338754545987954e-14,  7.274587573628117e-15,  3.270908472566762e-16,
  6.155613536032830e-18,  5.938652899559617e-01,  1.707588258861382e-02,  9.219214907965505e-05, -3.885675446876452e-06, -6.560964643436772e-09,  2.320575905336232e-09,
 -1.662028411402699e-11, -2.300979148446619e-12, -8.349502985209749e-15,  1.272199259078096e-15,  1.082420047498479e-17, -3.006158423662339e-19,  1.016817822415305e+00,
  1.499815502990943e-02, -7.354821656918340e-05, -1.300414828640217e-06,  4.178548361513330e-08,  5.299479495205776e-12, -1.858385717318862e-11, -2.744453770900405e-13,
 -5.127300470548836e-15,  9.713169762052206e-17,  9.258858539048899e-18,  1.750075347454687e-19,  1.349635640339862e+00,  1.088684832566805e-02, -9.989807653945174e-05,
  2.916950656904648e-07,  1.643818368669968e-08, -2.063660317297269e-10, -3.506512608339837e-12, -2.014449986727275e-13, -3.777653724547769e-15,  9.396799458192750e-17,
  4.478426210946200e-18,  9.120614754221611e-20,  1.604056236556185e+00,  6.956056109662334e-03, -7.915320531689869e-05,  6.672474488090796e-07,  1.322549087888020e-09,
 -5.452107733287400e-11, -1.366805169362329e-12, -1.327422475577276e-13, -1.524167070840963e-15,  4.672769881601940e-17,  2.345599895113576e-18,  5.199449310099160e-20,
  1.790453142524704e+00,  3.784851464020060e-03, -4.780284424768124e-05,  5.223512753495305e-07, -2.852021294959114e-09,  2.202752776880507e-11, -1.166066710083058e-12,
 -6.224535248396140e-14, -6.803076308406586e-16,  2.121626796237769e-17,  1.168505712598060e-18,  2.539452586488391e-20,  1.915726121584576e+00,  1.546623024086899e-03,
 -2.063804512025488e-05,  2.518963983795426e-07, -2.091582852302208e-09,  2.483858604849715e-11, -6.822093819890837e-13, -2.081949312599710e-14, -2.859834281828332e-16,
  8.309603297554113e-18,  4.471112162352115e-19,  9.729770306751653e-21,  1.984106498679737e+00,  2.940102870386357e-04, -4.027366017609102e-06,  5.157286602263144e-08,
 -4.895504259137723e-10,  6.408721859482660e-12, -1.548900898989858e-13, -3.385513265916552e-15, -5.804348042848386e-17,  1.598857523414229e-18,  8.133879837633123e-20,
  1.800479196565411e-21,  1.544912453797445e-01,  1.060364822218479e-02,  4.171371982833773e-04,  8.658811635116658e-06, -7.867951711955062e-08, -1.304736594123444e-08,
 -4.244125494565650e-10, -6.011048255068453e-13,  5.180739744810361e-13,  2.173574590603010e-14,  2.138294562247289e-16, -1.933536201399170e-17,  6.633504040794475e-01,
  1.762840025025240e-02,  4.633564202667860e-05, -3.662912078655028e-06,  3.067622171060264e-08,  1.163310500951287e-09, -7.738248378651152e-11, -1.762214859019921e-12,
  4.445555187394391e-14,  1.709107960894757e-15,  1.768027029388463e-17,  5.207136578091201e-19,  1.075550680300580e+00,  1.435855155337233e-02, -8.522458352601408e-05,
 -6.581091424575532e-07,  3.673741024563984e-08, -5.452720193581981e-10, -2.743351497834346e-11, -2.941887869519179e-13,  7.156178439475101e-15,  6.470027542929262e-16,
  1.823562375421833e-17,  1.472202237068235e-19,  1.391612681940438e+00,  1.010578254069659e-02, -9.497639977495219e-05,  5.150052823129480e-07,  1.096028063426303e-08,
 -3.672905228105506e-10, -1.003337608041670e-11, -2.247171894773483e-13,  3.945790456598656e-15,  3.670676984302769e-16,  9.083943760761774e-18,  6.417182870718978e-20,
  1.630665096505264e+00,  6.355117041061657e-03, -7.106466204688210e-05,  6.765668936936959e-07, -4.161086965829796e-10, -1.351147743191339e-10, -5.355977743377843e-12,
 -1.315343143047114e-13,  2.463847930549209e-15,  1.919289362357160e-16,  4.802636240647327e-18,  2.915131617125338e-20,  1.804866334340810e+00,  3.426746345070412e-03,
 -4.180050896935600e-05,  4.780986188207668e-07, -2.840855628576010e-09, -2.824564630109859e-11, -3.020775658079795e-12, -6.037192546469335e-14,  1.222873306050512e-15,
  9.264572918357821e-17,  2.332895640780270e-18,  1.216812749123815e-20,  1.921600787142945e+00,  1.393071711614852e-03, -1.780314432050818e-05,  2.213037662572606e-07,
 -1.809410315300393e-09,  8.582946729807183e-13, -1.318426911873827e-12, -2.081698044236300e-14,  4.485726591940242e-16,  3.556517546323418e-17,  8.854233642766434e-19,
  4.209434668394514e-21,  1.985221844502450e+00,  2.641419555633590e-04, -3.452008126986341e-06,  4.452840585653439e-08, -4.069919743803221e-10,  1.423707738054611e-12,
 -2.615860593027921e-13, -3.525139984771571e-15,  7.898462440864846e-17,  6.575490465142963e-18,  1.615759902415067e-19,  7.377857262903143e-22,  2.041773804077447e-01,
  1.431168154956133e-02,  5.031717689211880e-04,  4.796301822106653e-06, -4.300692090696293e-07, -2.083899097472129e-08, -9.416632964963325e-11,  2.750972761723694e-11,
  1.101902342357400e-12, -2.661412416941328e-15, -1.758698129650869e-15, -5.866742027221141e-17,  7.343401947217699e-01,  1.783265334208559e-02,  5.729358951815758e-06,
 -3.099970410870761e-06,  3.246665721852662e-08, -1.062629075984277e-09, -9.640068770093446e-11,  8.083887918465251e-13,  1.209529995708057e-13,  2.410121399072710e-15,
 -8.093948315274224e-18, -3.057318567414497e-18,  1.131583985145118e+00,  1.365408609077509e-02, -9.007668897407351e-05, -1.953365064983174e-07,  1.882443585861842e-08,
 -1.250017837927800e-09, -2.795301884029208e-11,  4.464276257512822e-13,  4.272578374126864e-14,  1.204639782123275e-15, -2.602783112476430e-18, -1.549761654089632e-18,
  1.430558684742324e+00,  9.373020549447744e-03, -8.803377810594017e-05,  6.168183641210898e-07,  8.315394190451371e-10, -6.546111500530686e-10, -1.207715186791448e-11,
  1.804543554783414e-13,  2.303425263385843e-14,  6.210470753844081e-16, -2.819816321428339e-18, -8.213899996825126e-19,  1.654999455018254e+00,  5.818705782156854e-03,
 -6.310043599500521e-05,  6.403094613775556e-07, -4.624211123045976e-09, -2.912489219554071e-10, -6.638692413125825e-12,  9.290923009309772e-14,  1.239753636768865e-14,
  3.190038606479104e-16, -1.865849861256503e-18, -4.392800295573714e-19,  1.817939664429769e+00,  3.114447395126982e-03, -3.636872959816575e-05,  4.237371009114954e-07,
 -4.229427185787492e-09, -1.128938295848475e-10, -3.537999347845834e-12,  4.892891700898303e-14,  5.999209483185080e-15,  1.519949871333460e-16, -1.021128384384470e-18,
 -2.142730351468984e-19,  1.926904334613990e+00,  1.260766307734745e-03, -1.532663844218729e-05,  1.906198317889263e-07, -2.141599584671288e-09, -3.473478177490906e-11,
 -1.461102936664158e-12,  2.035035335139457e-14,  2.269270278028183e-15,  5.750210611893572e-17, -4.192699515100189e-19, -8.192422945237915e-20,  1.986226407964646e+00,
  2.385523654182506e-04, -2.956976115291403e-06,  3.787803248197150e-08, -4.467295251264168e-10, -5.491030473120606e-12, -2.808101869121813e-13,  3.939930298418463e-15,
  4.136899094827785e-16,  1.052044033335411e-17, -7.998836821805722e-20, -1.504638724959543e-20,  2.696333685692773e-01,  1.841939671324602e-02,  5.061636770132744e-04,
 -5.215011338159772e-06, -7.889479896444396e-07, -1.054746323325970e-08,  1.035801123448734e-09,  4.405804123167549e-11, -6.341762254933633e-13, -9.269180475363816e-14,
 -1.378274855648088e-15,  1.231285928854719e-16,  8.055362774645428e-01,  1.773616213978119e-02, -2.941998269774277e-05, -2.859731610281253e-06, -7.525249824524889e-09,
 -2.598599939045045e-09, -9.239394015176962e-12,  5.592478501034292e-12,  1.470304562847542e-13, -2.996074605711174e-15, -3.055926400540643e-16, -8.004937231463743e-18,
  1.184748723256698e+00,  1.292711388929556e-02, -9.153731893236235e-05, -1.230964273265491e-07, -1.091988760003465e-08, -1.581366187650845e-09,  9.021124739742479e-12,
  2.299525881183575e-12,  5.966208525406314e-14, -1.114113848420579e-15, -1.267711334493119e-16, -3.038724266646084e-18,  1.466688001902946e+00,  8.697501922704265e-03,
 -8.102635604108455e-05,  5.130928349958168e-07, -1.424170262786826e-08, -7.828962256433239e-10,  5.962637828546997e-12,  1.157013081904056e-12,  3.083842406504089e-14,
 -6.085782406128730e-16, -6.412538054325749e-17, -1.403791003670569e-18,  1.677310914239012e+00,  5.342888520609422e-03, -5.607628515036147e-05,  5.128782206635073e-07,
 -1.156064724870808e-08, -3.656133312102533e-10,  2.857660839486683e-12,  6.083908576441291e-13,  1.600289315736061e-14, -3.341707182869393e-16, -3.316896171660423e-17,
 -6.821853878086149e-19,  1.829845875204561e+00,  2.842489064726463e-03, -3.177702406578552e-05,  3.343033934849948e-07, -7.094714158301417e-09, -1.554681422589623e-10,
  1.149517368118256e-12,  2.962090536423794e-13,  7.597404475847554e-15, -1.653443007157004e-16, -1.583908363647868e-17, -3.118757343915392e-19,  1.931715755137777e+00,
  1.146656900230207e-03, -1.327295789851249e-05,  1.492544534410350e-07, -3.091387771246370e-09, -5.317741742884346e-11,  3.615978734340103e-13,  1.136077743563343e-13,
  2.848678234284679e-15, -6.369441128337890e-17, -5.982592728476852e-18, -1.144783211472251e-19,  1.987135999367545e+00,  2.165827758334950e-04, -2.549959939622032e-06,
  2.955399948002748e-08, -6.059988125393885e-10, -9.122549025905657e-12,  5.787962171625881e-14,  2.092899402991790e-14,  5.175196016022608e-16, -1.173968474636612e-17,
 -1.092333806041362e-18, -2.058224986900331e-20,  3.507023685926214e-01,  2.199830807870332e-02,  3.662163067643873e-04, -1.783754217268712e-05, -6.766353742694430e-07,
  2.369503945882227e-08,  1.488254734432308e-09, -2.600510509059129e-11, -3.152229217209046e-12,  6.408633094298515e-15,  6.108004237313614e-15,  7.765065117291701e-17,
  8.757850308766221e-01,  1.735775604640275e-02, -6.604944578440862e-05, -3.347360635740524e-06, -4.705334457219511e-08, -6.053256046305545e-10,  1.776987586850304e-10,
  5.852390440744011e-12, -2.107420906565950e-13, -1.540902425853971e-14, -5.009069160426245e-17,  2.670093333913523e-17,  1.234976108372438e+00,  1.218373088635682e-02,
 -9.500102547333395e-05, -5.141528556660693e-07, -3.435137540111401e-08, -4.528600182414926e-10,  8.621361585668630e-11,  2.456589858592318e-12, -8.246706614992718e-14,
 -6.218102307431047e-15, -3.017185170110448e-17,  9.870974068027585e-18,  1.500213683498814e+00,  8.068967651035165e-03, -7.669399414168258e-05,  1.803086713638938e-07,
 -2.542506973693647e-08, -1.793568234656225e-10,  4.495791972407715e-11,  1.243344731372813e-12, -4.131666973328268e-14, -3.094996492131884e-15, -1.311018618321352e-17,
  4.773045075371273e-18,  1.697819124193599e+00,  4.915252565706013e-03, -5.124297842340699e-05,  2.797289973872198e-07, -1.659173441351075e-08, -5.588729838505237e-11,
  2.324849654327306e-11,  6.476926460501491e-13, -2.152207973331771e-14, -1.583377729038533e-15, -5.639642661103852e-18,  2.415619005828428e-18,  1.840729801485106e+00,
  2.602178720720431e-03, -2.853558167081631e-05,  2.006093579277352e-07, -9.155015784724030e-09, -1.113649112017213e-11,  1.100257720653473e-11,  3.115690018791890e-13,
 -1.036918020019726e-14, -7.497297387756339e-16, -2.288693456235814e-18,  1.139116420687216e-18,  1.936100076220368e+00,  1.046724801639686e-03, -1.180894048907259e-05,
  9.297765602305693e-08, -3.772740925657430e-09,  6.710245458459711e-14,  4.117303253577564e-12,  1.183435453274892e-13, -3.943775562302020e-15, -2.814956948929404e-16,
 -7.645946510549020e-19,  4.270690826870131e-19,  1.987963528185675e+00,  1.974245795068755e-04, -2.258656103292930e-06,  1.869861338228036e-08, -7.202610573178420e-10,
  4.538245785588778e-13,  7.472365746842051e-13,  2.167760335237960e-14, -7.229484026251735e-16, -5.122510486633905e-17, -1.299020077482527e-19,  7.768077305720800e-20,
  4.430005286891286e-01,  2.393441547512259e-02,  1.080034770759781e-04, -2.336507954456326e-05,  4.360160368421900e-08,  4.115771133416059e-08, -2.915267935170139e-10,
 -7.931974856518899e-11,  7.918260474598024e-13,  1.570244990988875e-13, -1.776378361948850e-15, -3.153657416502511e-16,  9.438877248858629e-01,  1.665667314946936e-02,
 -1.102782035475037e-04, -3.929523821126512e-06, -9.190678080552020e-09,  4.403702092780630e-09,  1.766303241669102e-10, -7.438444267399919e-12, -4.675850250418409e-13,
  9.405541566748960e-15,  1.071667887071542e-15, -4.140274927390950e-18,  1.282138866714782e+00,  1.138982721701406e-02, -1.043579101736028e-04, -1.008326140600551e-06,
 -1.951609773288411e-08,  1.953001207040690e-09,  8.857259449136449e-11, -2.979815266079534e-12, -2.021026602510636e-13,  2.838664444754142e-15,  4.196766201607938e-16,
  7.137543884785296e-19,  1.531266564265528e+00,  7.457306567555409e-03, -7.687647372554158e-05, -1.886773144884389e-07, -1.658680484878800e-08,  1.073244297681285e-09,
  4.658009640445041e-11, -1.476642408340364e-12, -1.020454929785380e-13,  1.279305900761033e-15,  2.024642671846209e-16,  5.426617729500692e-19,  1.716675299003006e+00,
  4.514357453320505e-03, -4.940565916563775e-05,  3.975777335368483e-08, -1.127329459592871e-08,  5.935781038543268e-10,  2.426017027326833e-11, -7.533617339739351e-13,
 -5.254698827903342e-14,  6.327604316782767e-16,  1.015425137899746e-16,  2.833104566527825e-19,  1.850693786394032e+00,  2.381120355615672e-03, -2.696221399970164e-05,
  6.868233563268085e-08, -6.323513557872063e-09,  2.973228330199951e-10,  1.155184293331654e-11, -3.560378132354110e-13, -2.498252771747125e-14,  2.964845395666793e-16,
  4.749391583794320e-17,  1.283287336128132e-19,  1.940103699134445e+00,  9.557291540512580e-04, -1.103574581873171e-05,  3.874969405315562e-08, -2.625730537853025e-09,
  1.158465390967473e-10,  4.342645158055202e-12, -1.335055969345441e-13, -9.404654613509498e-15,  1.110570793025027e-16,  1.770276866240564e-17,  4.593340435375728e-20,
  1.988718242341193e+00,  1.800647342038564e-04, -2.099556848896847e-06,  8.360083195729118e-09, -5.029527173279286e-10,  2.150520682508996e-11,  7.902262344706736e-13,
 -2.427699172700901e-14, -1.713840550971648e-15,  2.020874768375217e-17,  3.209623632688574e-18,  8.102771656952893e-21,  5.387825296320319e-01,  2.374553403626230e-02,
 -1.440708228141350e-04, -1.710849735916708e-05,  6.502328234645005e-07,  1.455041159324302e-08, -1.530526499704137e-09,  2.551127138705695e-12,  2.947468971003036e-12,
 -5.818960062390427e-14, -4.848113241386313e-15,  1.977719050448283e-16,  1.008457953161951e+00,  1.559106747740915e-02, -1.549149315272941e-04, -3.236283673992636e-06,
  9.794003015768767e-08,  5.017700719031418e-09, -1.424465242836255e-10, -1.088385862878044e-11,  3.335141497732545e-13,  2.174629443072175e-14, -7.815361149022463e-16,
 -4.328563982230388e-17,  1.325948954569780e+00,  1.050478812221107e-02, -1.167726154772592e-04, -9.318471495474217e-07,  3.105648614183459e-08,  2.545788445784440e-09,
 -4.994481898598887e-11, -5.184500024201367e-12,  1.099946236973492e-13,  9.868930193339854e-15, -2.304368616182338e-16, -1.905708828190241e-17,  1.559847592918965e+00,
  6.830659362177775e-03, -7.987998715922499e-05, -2.412393294643422e-07,  1.117193818011118e-08,  1.419747452482495e-09, -2.369571033749171e-11, -2.707444856594957e-12,
  4.914658997383688e-14,  4.997588663954954e-15, -9.700349297483546e-17, -9.335291569000842e-18,  1.733942321441226e+00,  4.119014242702677e-03, -4.954327302936391e-05,
 -2.406726961737060e-08,  3.915061510907474e-09,  7.795009832019119e-10, -1.197731348562644e-11, -1.414430752685663e-12,  2.366799297158080e-14,  2.563645704574353e-15,
 -4.523874202124215e-17, -4.678851446945237e-18,  1.859790355713710e+00,  2.167526586787272e-03, -2.651270522147623e-05,  2.537502815963204e-08,  1.207649527675970e-09,
  3.865314209395090e-10, -5.674695790048144e-12, -6.770339068410383e-13,  1.081740664987837e-14,  1.213685778015764e-15, -2.031168756486209e-17, -2.180958673095336e-18,
  1.943752248719111e+00,  8.687933623456618e-04, -1.073276744660637e-05,  1.914628016614680e-08,  2.872601319789024e-10,  1.493983037887114e-10, -2.138807482981899e-12,
 -2.556932677838986e-13,  3.979573398848657e-15,  4.554224777265068e-16, -7.400120884364915e-18, -8.104454077232741e-19,  1.989405400257193e+00,  1.635705982169213e-04,
 -2.030852301932181e-06,  4.458375036679258e-09,  3.559632543440384e-11,  2.760427367600238e-11, -3.903996220844445e-13, -4.666077851698249e-14,  7.168749115876947e-16,
  8.284062964735852e-17, -1.326875849577699e-18, -1.466690924965422e-19,  6.304227397449663e-01,  2.195855602358230e-02, -2.833577828397765e-04, -6.190706093085587e-06,
  6.232014390407780e-07, -1.347253026899506e-08, -6.108269718420333e-10,  4.477065792736660e-11, -3.502638189189620e-13, -7.083789466020879e-14,  2.863753012417946e-15,
  4.307277632641995e-17,  1.068143276948324e+00,  1.422906414736894e-02, -1.818540204038738e-04, -1.127437403926041e-06,  1.477414712034527e-07, -4.021804245878814e-10,
 -2.354612198591146e-10,  4.443404506727892e-12,  3.826554978967876e-13, -1.623811337743773e-14, -4.412144976386088e-16,  4.156265782072360e-17,  1.366045169108528e+00,
  9.537568365086178e-03, -1.236143100354445e-04, -1.316191188655041e-07,  6.134378061446754e-08,  2.375825928136100e-10, -1.117135644688654e-10,  1.203068887750678e-12,
  1.913876638494106e-13, -5.507934100811993e-15, -2.664388638965502e-16,  1.496928565981661e-17,  1.585880565422598e+00,  6.184927259974155e-03, -8.092427076757547e-05,
  1.129319998388519e-07,  2.921465781896966e-08,  2.431630175022241e-10, -5.919643168002331e-11,  4.508286873134028e-13,  1.011423347024442e-13, -2.417701644398195e-15,
 -1.458095478520678e-16,  6.703563454898621e-18,  1.749626724329894e+00,  3.723603732248263e-03, -4.902343105540417e-05,  1.366538349276618e-07,  1.415520057116898e-08,
  1.673114926824689e-10, -3.134818161383472e-11,  1.893502362834924e-13,  5.306987737661526e-14, -1.140421115895962e-15, -7.727295361269181e-17,  3.193562391728217e-18,
  1.868039331254459e+00,  1.957483278734979e-03, -2.587608835477570e-05,  9.383221418050571e-08,  6.381614582128320e-09,  9.303470592930080e-11, -1.516299541656089e-11,
  7.837076983864048e-14,  2.545326782337740e-14, -5.126574930646806e-16, -3.717760071772965e-17,  1.443737806056486e-18,  1.947057527078762e+00,  7.841268911319172e-04,
 -1.039153350205180e-05,  4.284432334959026e-08,  2.308631120338493e-09,  3.826729939404195e-11, -5.767686789589054e-12,  2.700147965042820e-14,  9.622588244005913e-15,
 -1.864751331551971e-16, -1.406786807897651e-17,  5.268601422027098e-19,  1.990027590331527e+00,  1.475842048082518e-04, -1.958400486738982e-06,  8.567555115162912e-09,
  4.110839273559103e-10,  7.287212427188564e-12, -1.056676058421537e-12,  4.695214549320423e-15,  1.756835378052900e-15, -3.338453874787403e-17, -2.568972382364289e-18,
  9.447725069915996e-20,  7.134609127620817e-01,  1.954034040443313e-02, -3.082310898019435e-04,  1.209543240475815e-06,  2.950655844667306e-07, -1.591648154379347e-08,
  2.591526282602657e-10,  1.418792460102290e-11, -1.011191977378567e-12,  1.888739300331048e-14,  8.631629062494900e-16, -6.594696776571100e-17,  1.122117944056032e+00,
  1.275797978113611e-02, -1.823008593610322e-04,  9.247781791970006e-07,  9.794629829889239e-08, -3.757038940454479e-09, -3.312233086591542e-11,  7.042043811505201e-12,
 -1.584541974402841e-13, -7.342053393324679e-15,  5.159736981568713e-16, -3.798808425189613e-18,  1.402230568722463e+00,  8.558534143330857e-03, -1.195646298393542e-04,
  7.633148439808622e-07,  4.464910384807562e-08, -1.571566496638231e-09, -2.923597554791947e-11,  3.376091121003765e-12, -4.630532104011389e-14, -4.413728174112179e-15,
  2.078299013927000e-16,  1.424238125148132e-18,  1.609345195528431e+00,  5.550811886589096e-03, -7.682928786576803e-05,  5.516478874667658e-07,  2.234462978161506e-08,
 -7.657902923324004e-10, -1.882224983421134e-11,  1.776909692945992e-12, -1.751032152906684e-14, -2.477371025395392e-15,  9.782779210501449e-17,  1.400783593099637e-18,
  1.763752611465029e+00,  3.341835417319704e-03, -4.603481008417175e-05,  3.536475492710099e-07,  1.118436853852775e-08, -3.813447743692334e-10, -1.095556281009791e-11,
  9.335346598456283e-13, -7.242100343980784e-15, -1.337169119376743e-15,  4.779793241554602e-17,  9.018997863059507e-19,  1.875464864727088e+00,  1.756736704855368e-03,
 -2.413471666452140e-05,  1.931608233780578e-07,  5.157845554992187e-09, -1.764038401270824e-10, -5.585729040195087e-12,  4.486327852190725e-13, -2.927922498203506e-15,
 -6.511644572454852e-16,  2.190741538379792e-17,  4.766022583570024e-19,  1.950031932080428e+00,  7.036918537283620e-04, -9.652901585118754e-06,  7.915953046786017e-08,
  1.894374222165957e-09, -6.511717956347773e-11, -2.189096329295733e-12,  1.698831296571304e-13, -9.868402126054021e-16, -2.482493205801257e-16,  8.054783235313683e-18,
  1.894778757520980e-19,  1.990587405806312e+00,  1.324428030321503e-04, -1.815424061617631e-06,  1.507253708636076e-08,  3.401389200405102e-10, -1.173564974026527e-11,
 -4.070276825520251e-13,  3.104623485945872e-14, -1.691697546631620e-16, -4.550962373909418e-17,  1.449594287531207e-18,  3.542494269590142e-20,  7.868672140229094e-01,
  1.719124593073089e-02, -2.745693505331287e-04,  3.800600079216101e-06,  5.536208449447491e-08, -7.836882477503773e-09,  3.264906793018253e-10, -5.026603347119468e-12,
 -2.140357062984025e-13,  1.676048261416937e-14, -4.745350232224358e-16, -1.227443442739331e-18,  1.170333409231291e+00,  1.136489639100617e-02, -1.642661057487135e-04,
  1.902478069521528e-06,  2.729618971062326e-08, -2.877497480116624e-09,  7.760267243855226e-11,  9.721190741951542e-13, -1.504552815318012e-13,  4.449891491522939e-15,
  4.941600109068165e-17, -8.680907521796803e-18,  1.434623541311967e+00,  7.648306809202148e-03, -1.072016807043232e-04,  1.215926809260208e-06,  1.257359696907488e-08,
 -1.397713787100069e-09,  3.152086912573168e-11,  8.272148911455980e-13, -7.638789412619962e-14,  1.602925950563713e-15,  5.347843706959198e-17, -4.371537269089509e-18,
  1.630368038101958e+00,  4.967487479795161e-03, -6.860763305670688e-05,  7.770835740528401e-07,  5.964668557379036e-09, -7.388796079675040e-10,  1.507046005316725e-11,
  5.295242602098682e-13, -4.100638461667502e-14,  6.973386511063033e-16,  3.488181884156825e-17, -2.272091072258069e-18,  1.776413736739204e+00,  2.992942352391475e-03,
 -4.099312497057410e-05,  4.652780414363505e-07,  2.771454349533947e-09, -3.875468426702123e-10,  7.421794592986979e-12,  3.070179667113132e-13, -2.172791699337771e-14,
  3.207464036411998e-16,  2.017889400328236e-17, -1.172235732468236e-18,  1.882121927820770e+00,  1.574037828372638e-03, -2.145092137031705e-05,  2.440440043189248e-07,
  1.183412630653610e-09, -1.855637501792456e-10,  3.411821253918874e-12,  1.560563582831928e-13, -1.048447148512502e-14,  1.405804444767855e-16,  1.020423426089855e-17,
 -5.549014821822992e-19,  1.952698851910115e+00,  6.306735167639847e-04, -8.569270634927904e-06,  9.766687311620199e-08,  4.071278134884373e-10, -7.002085311912684e-11,
  1.255261524050982e-12,  6.102673388989008e-14, -3.978063841668548e-15,  5.014524011790727e-17,  3.973198911221998e-18, -2.079234030121646e-19,  1.991089380169735e+00,
  1.187154917998700e-04, -1.610617812160461e-06,  1.837568130124173e-08,  7.013469919685570e-11, -1.276763401516677e-11,  2.258853626028282e-13,  1.133299742322969e-14,
 -7.276362559043299e-16,  8.875729575043665e-18,  7.359648036958301e-19, -3.777822421320415e-20,  8.515366395488410e-01,  1.518275921075820e-02, -2.275918578607812e-04,
  3.802347608254667e-06, -3.651360360195056e-08, -2.032031447713085e-09,  1.558981792211713e-10, -5.592369105865250e-12,  9.073632913418760e-14,  2.139467911000930e-15,
 -2.041238342795152e-16,  7.164244833129568e-18,  1.213314885350395e+00,  1.014580756752770e-02, -1.403813843171876e-04,  1.981389266270855e-06, -1.160546125231547e-08,
 -1.085051890826761e-09,  6.101208231330037e-11, -1.420057573689671e-12, -1.319360285919054e-14,  2.343682962519151e-15, -8.476404175723678e-17,  7.477487100857631e-19,
  1.463596342463350e+00,  6.850641941588673e-03, -9.218162507325379e-05,  1.238242989095597e-06, -7.112637632338538e-09, -5.791922083187856e-10,  3.030996227486874e-11,
 -5.735743362534698e-13, -1.375846231856546e-14,  1.294423914210482e-15, -3.644033660157210e-17, -1.055706032146894e-19,  1.649200313847936e+00,  4.456568816033597e-03,
 -5.912589892282483e-05,  7.766801905042100e-07, -4.641624314151929e-09, -3.189203393186673e-10,  1.626182086211933e-11, -2.711936875516484e-13, -9.281776754384462e-15,
  7.205891559877150e-16, -1.762424478490676e-17, -1.832012642602416e-19,  1.787765355632808e+00,  2.687567702776872e-03, -3.536320236387074e-05,  4.589744873330287e-07,
 -2.849653702790799e-09, -1.708060670022898e-10,  8.624515434042060e-12, -1.322899698784628e-13, -5.513268034714199e-15,  3.892625845279078e-16, -8.704808041042155e-18,
 -1.354367626100020e-19,  1.888093536718765e+00,  1.414218180483154e-03, -1.851425871415595e-05,  2.386199493983416e-07, -1.524383330033075e-09, -8.272439416412701e-11,
  4.163720596323177e-12, -6.038961243949746e-14, -2.839159501265618e-15,  1.899376468497542e-16, -4.005787499271340e-18, -7.657387283363282e-20,  1.955091892121441e+00,
  5.668242347367188e-04, -7.398068813062430e-06,  9.496550896314821e-08, -6.181938267017203e-10, -3.140992893165376e-11,  1.580027240491739e-12, -2.211593765793522e-14,
 -1.118316788882199e-15,  7.253030299418550e-17, -1.474651774104241e-18, -3.158335170798452e-20,  1.991539873004606e+00,  1.067145265353931e-04, -1.390657211269370e-06,
  1.781530734486381e-08, -1.171458312077485e-10, -5.744279753667535e-12,  2.890030194923937e-13, -3.969955116215169e-15, -2.084099616745850e-16,  1.330905543997766e-17,
 -2.654559082080529e-19, -6.011763438885737e-21,  9.088984637545066e-01,  1.353259884594995e-02, -1.862817981324579e-04,  3.049426769558065e-06, -5.058585848421126e-08,
  1.868350360587177e-10,  4.338244071116170e-11, -2.516610360094055e-12,  8.138550278409842e-14, -1.404253740712356e-15, -1.263306623500011e-17,  1.893967517671400e-18,
  1.251796536548297e+00,  9.113506318105999e-03, -1.182145124563612e-04,  1.688062702128126e-06, -2.187783142426408e-08, -8.869896148653082e-11,  2.392185008937930e-11,
 -1.046117395696757e-12,  2.303405800073015e-14,  6.924366979002328e-17, -2.731485465537871e-17,  1.136642931493121e-18,  1.489614506725295e+00,  6.170037255103693e-03,
 -7.827582644143425e-05,  1.065393637711819e-06, -1.283298176767402e-08, -6.086874140828475e-11,  1.318281072056599e-11, -5.296445479258014e-13,  9.595154901997307e-15,
  1.468356237291255e-16, -1.660631135649233e-17,  5.615542420651102e-19,  1.666137336997879e+00,  4.019218411138325e-03, -5.040106582833433e-05,  6.696653289303367e-07,
 -7.821918950104376e-09, -3.424971761151705e-11,  7.440724338743546e-12, -2.869974697039542e-13,  4.599311277484450e-15,  1.104816151976091e-16, -9.656076910254793e-18,
  2.936034130170559e-19,  1.797983343975116e+00,  2.425723986996721e-03, -3.020936941864355e-05,  3.958206793402943e-07, -4.553094750352842e-09, -1.774528527869789e-11,
  4.062518719780544e-12, -1.531714115665210e-13,  2.260448449434245e-15,  6.873733187141243e-17, -5.343940199871938e-18,  1.523300657198123e-19,  1.893471605624983e+00,
  1.277049411699746e-03, -1.583603268622065e-05,  2.057332411811799e-07, -2.347045067013307e-09, -8.203119665465448e-12,  1.996121957021965e-12, -7.425962629951651e-14,
  1.036544957201331e-15,  3.627484309272255e-17, -2.645443328577078e-18,  7.237995775176992e-20,  1.957247752352467e+00,  5.119942763947303e-04, -6.332577412947939e-06,
  8.185251039766251e-08, -9.295904951320280e-10, -2.987102627665055e-12,  7.654360555500805e-13, -2.825589018700877e-14,  3.806349763185383e-16,  1.448276067692887e-17,
 -1.018821721128471e-18,  2.718247942333277e-20,  1.991945780873418e+00,  9.640603169927131e-05, -1.190815086310463e-06,  1.535229445248368e-08, -1.739776637885887e-10,
 -5.319613206765028e-13,  1.407500636918000e-13, -5.175746014971037e-15,  6.842198623867714e-17,  2.716887869908347e-18, -1.877544829673139e-19,  4.944502897065277e-21,
  9.602613973190149e-01,  1.217550956364619e-02, -1.542924034647710e-04,  2.307246617126325e-06, -4.082495960660308e-08,  6.295668864164204e-10,  1.767317880336627e-12,
 -7.071162059411643e-13,  3.428776496649175e-14, -1.021654660736423e-15,  1.830348535032001e-17, -2.383115747128246e-21,  1.286479045708611e+00,  8.242890866632822e-03,
 -1.000391843788450e-04,  1.346531483253251e-06, -1.986359391433762e-08,  2.140600535089636e-10,  4.295564051097719e-12, -4.008379432690987e-13,  1.510485877345048e-14,
 -3.257285590257091e-16,  9.580964682353481e-19,  2.447386557809096e-19,  1.513118275896670e+00,  5.591475737069652e-03, -6.671977048488750e-05,  8.631255279717077e-07,
 -1.190087803599833e-08,  1.136252948857220e-10,  2.778012574312617e-12, -2.248769369477126e-13,  7.804522882973072e-15, -1.426339685930408e-16, -8.626887617141628e-19,
  1.652622848399245e-19,  1.681455680328349e+00,  3.646024983368114e-03, -4.311384768843945e-05,  5.463298929468360e-07, -7.278342669306766e-09,  6.611106307910467e-11,
  1.663926919622853e-12, -1.284171912451322e-13,  4.273004593735084e-15, -7.038131848926438e-17, -8.646746012763389e-19,  1.006621496662632e-19,  1.807231223748358e+00,
  2.201810849188795e-03, -2.589476116325175e-05,  3.241355376561521e-07, -4.232832094950404e-09,  3.757715527010371e-11,  9.340719856505425e-13, -7.068984469462673e-14,
  2.294660803661930e-15, -3.525187077299586e-17, -5.910597507681628e-19,  5.716631070688167e-20,  1.898341162160903e+00,  1.159599190960556e-03, -1.359128039777026e-05,
  1.688408954863118e-07, -2.178155617317437e-09,  1.912232760176925e-11,  4.654850326509426e-13, -3.493330525480217e-14,  1.116836352542617e-15, -1.637137276772957e-17,
 -3.263560762718911e-19,  2.874083297814491e-20,  1.959200272738071e+00,  4.650104526366082e-04, -5.438992914713566e-06,  6.725887007433902e-08, -8.614007101009092e-10,
  7.521165732733942e-12,  1.797892611521507e-13, -1.344612300247239e-14,  4.259784677086731e-16, -6.060691359485469e-18, -1.334469845196566e-19,  1.117055662201353e-20,
  1.992313452088220e+00,  8.756925920836391e-05, -1.023168239350297e-06,  1.262298315518558e-08, -1.610695387295092e-10,  1.402967986087648e-12,  3.316878896147059e-14,
 -2.477530877896175e-15,  7.812542484655784e-17, -1.094147189341574e-18, -2.532111808521588e-20,  2.068144564513391e-21,  1.006655680024612e+00,  1.104175997398543e-02,
 -1.301155364820933e-04,  1.752194648192299e-06, -2.889874555972064e-08,  5.292776062733846e-10, -7.235438153256245e-12, -6.533587055788142e-14,  9.517477951634665e-15,
 -4.044195052747092e-16,  1.123735502849629e-17, -2.041070231770681e-19,  1.317945146921616e+00,  7.502154348947227e-03, -8.563664015530687e-05,  1.065598641306515e-06,
 -1.522205510302718e-08,  2.268927000163340e-10, -1.788035372644571e-12, -8.435615646652539e-14,  5.538080999727390e-15, -1.878661009815523e-16,  3.997670178095955e-18,
 -2.952475147017895e-20,  1.534477936718832e+00,  5.096098026932905e-03, -5.742278175075825e-05,  6.928200721144634e-07, -9.345936059144654e-09,  1.282445312705776e-10,
 -7.814159396174536e-13, -5.414769231184211e-14,  3.151974692045603e-15, -9.910329198429806e-17,  1.843614374173713e-18, -2.080864002390184e-21,  1.695388828948461e+00,
  3.325467865121837e-03, -3.720868687140295e-05,  4.416484436276926e-07, -5.778429397622752e-09,  7.593500740388756e-11, -4.083488680995319e-13, -3.273704523155227e-14,
  1.815371585509135e-15, -5.485272717217318e-17,  9.387633010527418e-19,  2.882121766512343e-21,  1.815647241716481e+00,  2.009122176428078e-03, -2.238425406836004e-05,
  2.631010830653727e-07, -3.379808136364964e-09,  4.330055485066909e-11, -2.189029841708715e-13, -1.857367630682087e-14,  1.004880122984636e-15, -2.964907317076730e-17,
  4.801058861574133e-19,  2.884374928532662e-21,  1.902774135531306e+00,  1.058412480138768e-03, -1.176045566774172e-05,  1.373896028688213e-07, -1.744829191178087e-09,
  2.200867313115756e-11, -1.078974363525363e-13, -9.339525566443187e-15,  4.984308564484497e-16, -1.448952383244047e-17,  2.261158026166863e-19,  1.818718742429234e-21,
  1.960978087897151e+00,  4.245050568271028e-04, -4.709146658431295e-06,  5.481120797840000e-08, -6.912904191713079e-10,  8.639030519206890e-12, -4.172464166501469e-14,
 -3.630781290044580e-15,  1.923013918767684e-16, -5.540265044412804e-18,  8.446028972002819e-20,  7.908458675660507e-22,  1.992648258974510e+00,  7.994832088309924e-05,
 -8.861423643374876e-07,  1.029458809568895e-08, -1.293770401151729e-10,  1.609195232938324e-12, -7.721940901185126e-15, -6.722984751057933e-16,  3.547672584325238e-17,
 -1.017398152854191e-18,  1.532019815537620e-20,  1.542639511083035e-22,  1.048863923092416e+00,  1.007782268199268e-02, -1.115452493339049e-04,  1.364916173647210e-06,
 -2.006714033951325e-08,  3.573275848806919e-10, -6.466415345802898e-12,  7.683362576193319e-14,  1.100504385705772e-15, -1.098218254837830e-16,  4.205938591615453e-18,
 -1.098813614109210e-19,  1.346659150504866e+00,  6.864396521830092e-03, -7.417005816446462e-05,  8.555043851152713e-07, -1.122391070548917e-08,  1.704350825691082e-10,
 -2.484977412066479e-12,  1.209044908441130e-14,  1.217850170934947e-15, -6.550166814334367e-17,  2.046708030592123e-18, -4.289836911601310e-20,  1.553992876183743e+00,
  4.667615495133845e-03, -4.992580723249493e-05,  5.624374609707305e-07, -7.044683258600063e-09,  9.988720692115227e-11, -1.325269734371350e-12,  2.929879988361397e-15,
  7.822654103008045e-16, -3.776479718107883e-17,  1.101197574650087e-18, -2.071425064973479e-20,  1.708126854197940e+00,  3.047536583258720e-03, -3.241585567969308e-05,
  3.605962884878485e-07, -4.404863878635528e-09,  6.013005153053034e-11, -7.580270581275156e-13,  7.534613379742140e-16,  4.754318374895793e-16, -2.191187843131708e-17,
  6.160244289855010e-19, -1.084680019276048e-20,  1.823344363830189e+00,  1.841820998124318e-03, -1.952419961903159e-05,  2.155440230247648e-07, -2.593379877370270e-09,
  3.458630342693120e-11, -4.229006017068957e-13,  1.615066714880256e-16,  2.710576815695024e-16, -1.218570873588779e-17,  3.351270154375147e-19, -5.650471416919577e-21,
  1.906829432306114e+00,  9.704811520032296e-04, -1.026539116549336e-05,  1.127909890021618e-07, -1.344232983440195e-09,  1.766465648283558e-11, -2.119572469446787e-13,
  1.280715603266098e-17,  1.368181264708938e-16, -6.062498202664715e-18,  1.644419742422710e-19, -2.694107780307469e-21,  1.962604678684011e+00,  3.892874401045250e-04,
 -4.112319534055237e-06,  4.505421642736146e-08, -5.338598633880041e-10,  6.952570149983811e-12, -8.248593953857444e-14, -8.848017728805478e-18,  5.332913457318141e-17,
 -2.343385686722518e-18,  6.303198515071267e-20, -1.014180155793821e-21,  1.992954609801345e+00,  7.332048842115765e-05, -7.740108434776732e-07,  8.467474154429215e-09,
 -1.000359987639143e-10,  1.296752111950470e-12, -1.529646934295739e-14, -2.823706661944921e-18,  9.889193035753514e-18, -4.327429557122803e-19,  1.158973538685054e-20,
 -1.847175062787162e-22,  1.087487169372102e+00,  9.246010545913695e-03, -9.688208997449964e-05,  1.093348138472942e-06, -1.428964719330771e-08,  2.292316904652881e-10,
 -4.232039887234329e-12,  7.334162695714929e-14, -7.604742348626287e-16, -1.378681482845391e-17,  1.111060801616663e-18, -3.908684506636238e-20,  1.372991040029164e+00,
  6.309286183269541e-03, -6.487905612547718e-05,  7.001223137087886e-07, -8.368884592136436e-09,  1.175639286411912e-10, -1.862064540135860e-12,  2.585265111852177e-14,
 -5.854351609040374e-17, -1.443877054996801e-17,  6.783577953180210e-19, -1.979761689761428e-20,  1.571904751726873e+00,  4.293430779910171e-03, -4.379235067540360e-05,
  4.640416769544977e-07, -5.348098474428978e-09,  7.090003009299267e-11, -1.046172574565540e-12,  1.307515902107001e-14,  1.897008497504926e-17, -9.316791148221124e-18,
  3.958149888166897e-19, -1.084554537456574e-20,  1.719824173261595e+00,  2.804405345786916e-03, -2.847500650511146e-05,  2.987810680596570e-07, -3.376141010122663e-09,
  4.332876738846799e-11, -6.137473927264535e-13,  7.227311034279148e-15,  2.465130413493159e-17, -5.689386511582753e-18,  2.312203198005946e-19, -6.127671692336730e-21,
  1.830414710990784e+00,  1.695317167057498e-03, -1.716555820462594e-05,  1.790470866508811e-07, -1.999139035448583e-09,  2.514660727112317e-11, -3.471531454592354e-13,
  3.941680080901818e-15,  1.780495920082597e-17, -3.255553474957071e-18,  1.291297915625109e-19, -3.353836418117521e-21,  1.910555199757844e+00,  8.934314423792383e-04,
 -9.030165359677958e-06,  9.384005517877810e-08, -1.039932243065481e-09,  1.291485099763719e-11, -1.753638076198575e-13,  1.946186103759332e-15,  1.003865202538194e-17,
 -1.647581406613342e-18,  6.441665491096408e-20, -1.651998908130301e-21,  1.964099263515560e+00,  3.584161561038381e-04, -3.618672952421739e-06,  3.751984897497793e-08,
 -4.139028021592263e-10,  5.100104172195960e-12, -6.854742644773240e-14,  7.503195475331901e-16,  4.142268616671405e-18, -6.433112157027331e-19,  2.494086772744254e-20,
 -6.347077028255930e-22,  1.993236115133493e+00,  6.750947403921716e-05, -6.812122348975586e-07,  7.054892364609005e-09, -7.764438714900414e-11,  9.528652143381874e-13,
 -1.273915263228306e-14,  1.384625100659120e-16,  7.889313534276478e-19, -1.194054441722957e-19,  4.609691592422398e-21, -1.168449511571416e-22,  1.122999123538583e+00,
  8.519863583766097e-03, -8.499852082721102e-05,  8.965175800511787e-07, -1.056963435751353e-08,  1.493337126664395e-10, -2.548618391200310e-12,  4.697588661986202e-14,
 -7.682130758591864e-16,  7.094830840097525e-18,  1.420689503427403e-19, -9.997378369803171e-21,  1.397240332686576e+00,  5.821747380342739e-03, -5.721062141543481e-05,
  5.828399572306875e-07, -6.408436905725515e-09,  8.101972392845237e-11, -1.213565788351172e-12,  1.950155326277331e-14, -2.543304666449279e-16,  1.024727445588540e-19,
  1.469044399224178e-19, -6.244791316716590e-21,  1.588411142398869e+00,  3.964010809124335e-03, -3.869455674486163e-05,  3.885745471114222e-07, -4.152153349444900e-09,
  5.003291960508046e-11, -7.048316691169742e-13,  1.059489494845542e-14, -1.230359760717563e-16, -5.326364254607265e-19,  9.547265743619985e-20, -3.685354753245884e-21,
  1.730607686160951e+00,  2.590089476061504e-03, -2.518755105196070e-05,  2.509636059492495e-07, -2.640620851741054e-09,  3.097945825092849e-11, -4.210343624148835e-13,
  6.081940998621679e-15, -6.591915512732509e-17, -4.705791927975242e-19,  5.859497590810935e-20, -2.166650835033746e-21,  1.836934217554113e+00,  1.566078664639054e-03,
 -1.519367722435795e-05,  1.506692267953471e-07, -1.570601439082800e-09,  1.812477464351353e-11, -2.407671764868773e-13,  3.389959192673569e-15, -3.517434087697153e-17,
 -3.123759956148332e-19,  3.364421249705320e-20, -1.214805127400850e-21,  1.913991199514697e+00,  8.254298181346311e-04, -7.996084158917414e-06,  7.905746936757742e-08,
 -8.192989303243278e-10,  9.356205431784333e-12, -1.224586191883672e-13,  1.695570518846199e-15, -1.710924428467284e-17, -1.705550010925711e-19,  1.706634108626349e-20,
 -6.075356739256802e-22,  1.965477731475291e+00,  3.311623508831061e-04, -3.205073223371371e-06,  3.163123135270679e-08, -3.266426000202761e-10,  3.706341118469647e-12,
 -4.806641465336977e-14,  6.586221512410120e-16, -6.533324863144005e-18, -6.938146302372459e-20,  6.673553109938557e-21, -2.355894455894938e-22,  1.993495761771916e+00,
  6.237863875856897e-05, -6.034286707793745e-07,  5.949758081176008e-09, -6.132864214187792e-11,  6.935819085295099e-13, -8.951900381291529e-15,  1.219957195526931e-16,
 -1.199552776400764e-18, -1.313481466052112e-20,  1.239652562761351e-21, -4.357756662992710e-23,  1.155782952681606e+00,  7.880240744375858e-03, -7.516609114349824e-05,
  7.483739276242526e-07, -8.101355083138390e-09,  1.014311753105194e-10, -1.535080433604120e-12,  2.694228620917500e-14, -4.833076790106600e-16,  7.432563478691453e-18,
 -6.296946274189022e-20, -1.249825653853614e-21,  1.419653937719808e+00,  5.390409356421762e-03, -5.078293678402454e-05,  4.918550938999173e-07, -5.039695492996844e-09,
  5.755998853970746e-11, -7.753233167545048e-13,  1.214048574281686e-14, -1.931257984812927e-16,  2.363059602380726e-18,  1.439859589740027e-21, -1.311728304369793e-21,
  1.603676103281856e+00,  3.672047094523231e-03, -3.439996813204459e-05,  3.293190977573804e-07, -3.298925294646264e-09,  3.623403641282701e-11, -4.624157632747736e-13,
  6.839380958017455e-15, -1.024232434157505e-16,  1.105572990575358e-18,  6.709049098311698e-21, -8.606357479367299e-22,  1.740583160402980e+00,  2.399960863374686e-03,
 -2.241067168624027e-05,  2.131748952682285e-07, -2.109538181276270e-09,  2.267645483596739e-11, -2.804764515434662e-13,  4.006680590838985e-15, -5.783323304293511e-17,
  5.773317329579290e-19,  5.552767927155899e-21, -5.311774554720252e-22,  1.842966315063969e+00,  1.451359826713592e-03, -1.352539635943756e-05,  1.281555318035300e-07,
 -1.258876375422695e-09,  1.335491906500474e-11, -1.619419530587132e-13,  2.261357049871642e-15, -3.186447696712697e-17,  3.022483231050706e-19,  3.622082293824833e-21,
 -3.060871165562656e-22,  1.917170692732706e+00,  7.650463135300068e-04, -7.120348049863735e-06,  6.730098679959181e-08, -6.580495612833612e-10,  6.922990888405593e-12,
 -8.288023481446217e-14,  1.140063458916981e-15, -1.581103765398470e-17,  1.450348797196778e-19,  1.964696627181514e-21, -1.556276971738404e-22,  1.966753385200451e+00,
  3.069564731796627e-04, -2.854596909807078e-06,  2.694111586033229e-08, -2.626845270967277e-10,  2.749530818243832e-12, -3.265675749496378e-14,  4.449863153120041e-16,
 -6.110006817446262e-18,  5.489118571563839e-20,  7.970603413606093e-22, -6.094432428047832e-23,  1.993736051400677e+00,  5.782110023169789e-05, -5.374961933731794e-07,
  5.068880121617873e-09, -4.935205526214643e-11,  5.152162394763106e-13, -6.094164717092005e-15,  8.262948360997122e-17, -1.128644026578591e-18,  1.003011253296049e-20,
  1.507318791025465e-22, -1.132934161710098e-23,  1.186155211997549e+00,  7.312772721495501e-03, -6.690224203279150e-05,  6.332075194652264e-07, -6.388097531068134e-09,
  7.212242793336628e-11, -9.608160339731104e-13,  1.521634554451887e-14, -2.667111916351758e-16,  4.592243354497874e-18, -6.658986538880904e-20,  5.346854353222849e-22,
  1.440438601619945e+00,  5.006465558366682e-03, -4.532948407338152e-05,  4.195225490039306e-07, -4.050319837847291e-09,  4.240997078296831e-11, -5.095196162934351e-13,
  7.254704459193511e-15, -1.158237135213712e-16,  1.793989509800076e-18, -2.073769834869410e-20, -1.687120754621559e-23,  1.617837721675939e+00,  3.411808814481422e-03,
 -3.074271165971027e-05,  2.817896737516404e-07, -2.671468627163423e-09,  2.710092731150432e-11, -3.107689089246147e-13,  4.197430078560202e-15, -6.383201523073001e-17,
  9.365331210318278e-19, -9.498032012759354e-21, -6.226299453622702e-23,  1.749839867002992e+00,  2.230366357458331e-03, -2.004121116304867e-05,  1.827194107066373e-07,
 -1.715232928225493e-09,  1.710198607203293e-11, -1.909701976682863e-13,  2.498239347226275e-15, -3.684628227291792e-17,  5.227904899223725e-19, -4.870902947708950e-21,
 -5.131316617083668e-23,  1.848564629596818e+00,  1.348984733422397e-03, -1.210019778118464e-05,  1.099587140116917e-07, -1.026066183124508e-09,  1.012344383641364e-11,
 -1.111810621516032e-13,  1.424481788189582e-15, -2.058317879257199e-17,  2.856533265674912e-19, -2.513726285232169e-21, -3.350308430377758e-23,  1.920121827652161e+00,
  7.111448577328979e-04, -6.371662557636616e-06,  5.778168628065355e-08, -5.371692319656691e-10,  5.264857315322515e-12, -5.720842038229744e-14,  7.229771529221068e-16,
 -1.030377526094711e-17,  1.409074018944803e-19, -1.193415709089428e-21, -1.819888839996310e-23,  1.967937489381929e+00,  2.853453433928598e-04, -2.554833814011690e-06,
  2.313936741762507e-08, -2.146282779777234e-10,  2.095132861358422e-12, -2.261690524641321e-14,  2.833732241815431e-16, -4.003402649266720e-18,  5.424210692849079e-20,
 -4.484243614080509e-22, -7.391576814038417e-24,  1.993959103118091e+00,  5.375174829328400e-05, -4.810911458018341e-07,  4.354452775906011e-09, -4.034251437389369e-11,
  3.929946412730039e-13, -4.227951406523683e-15,  5.273473570277217e-17, -7.415840488664320e-19,  9.998830920603803e-21, -8.161681893419674e-23, -1.398747277371447e-24,
  1.214381672832923e+00,  6.806313324682249e-03, -5.987310888464682e-05,  5.414139373263738e-07, -5.146133203285868e-09,  5.334671892564877e-11, -6.327663695660276e-13,
  8.863176343590095e-15, -1.430550010980244e-16,  2.454194136719681e-18, -4.031732624221021e-20,  5.542715231384587e-22,  1.459769600435699e+00,  4.662925542409455e-03,
 -4.065803369396677e-05,  3.609008517285689e-07, -3.309883328222530e-09,  3.225430384063487e-11, -3.496849812727455e-13,  4.426531702531315e-15, -6.543114729596150e-17,
  1.041970175501529e-18, -1.557598440523827e-20,  1.719715778148205e-22,  1.631013514935643e+00,  3.178705129480183e-03, -2.760102263397303e-05,  2.430132610693983e-07,
 -2.195585263606691e-09,  2.085047786456258e-11, -2.173006150989464e-13,  2.619944136235592e-15, -3.698266353318618e-17,  5.660318782962885e-19, -8.057016736975166e-21,
  7.803539753717156e-23,  1.758453933447572e+00,  2.078365142703897e-03, -1.800270027078155e-05,  1.577845716664744e-07, -1.413979924781215e-09,  1.324086376093456e-11,
 -1.349769670374745e-13,  1.581020041211965e-15, -2.167797759646075e-17,  3.234276822030764e-19, -4.465282733785361e-21,  3.963599884925091e-23,  1.853774947395804e+00,
  1.257196587441500e-03, -1.087294964122866e-05,  9.502876252240415e-08, -8.473970375169530e-10,  7.868063518619294e-12, -7.911779384398823e-14,  9.096707343781160e-16,
 -1.223216474085297e-17,  1.793555026832305e-19, -2.426495040420672e-21,  2.028405858222424e-23,  1.922868655596245e+00,  6.628065177419844e-04, -5.726600094558214e-06,
  4.996102497410390e-08, -4.441363385898698e-10,  4.101852069728660e-12, -4.088915355141020e-14,  4.644601516683977e-16, -6.164228180167512e-18,  8.932184366602733e-20,
 -1.192180293527161e-21,  9.566607392351533e-24,  1.969039673561580e+00,  2.659619890286339e-04, -2.296471673848066e-06,  2.001350286116854e-08, -1.775786294208193e-10,
  1.634735311119595e-12, -1.620915041773967e-14,  1.827323620511651e-16, -2.405089587635736e-18,  3.458782045707488e-20, -4.577081257897776e-22,  3.578032651861425e-24,
  1.994166728845080e+00,  5.010162353944449e-05, -4.324678118571118e-07,  3.766796252789503e-09, -3.339026301249720e-11,  3.068693749803552e-13, -3.034379467681171e-15,
  3.407298551952711e-17, -4.464961585751141e-19,  6.395371746612893e-21, -8.425067166023716e-23,  6.495493739450765e-25,  1.240688228357206e+00,  6.351992685015279e-03,
 -5.383742417147282e-05,  4.668621697258487e-07, -4.213324988818302e-09,  4.069268366665451e-11, -4.373660772384703e-13,  5.431533109290622e-15, -7.845966662175553e-17,
  1.262441861521677e-18, -2.094603578299808e-20,  3.278158650511782e-22,  1.477796992677737e+00,  4.354130482834398e-03, -3.662505571667681e-05,  3.126857063127266e-07,
 -2.739772461132117e-09,  2.514330186839177e-11, -2.501893020711950e-13,  2.827093293649037e-15, -3.737624536307721e-17,  5.618222584703750e-19, -8.784796101018425e-21,
  1.263015532615608e-22,  1.643304384600107e+00,  2.968994352335683e-03, -2.488273340593531e-05,  2.109593698679477e-07, -1.825404608194881e-09,  1.639860873600063e-11,
 -1.578509847770706e-13,  1.707146495279865e-15, -2.157041347946907e-17,  3.124157888398451e-19, -4.731425785118798e-21,  6.506233635989950e-23,  1.766490824652242e+00,
  1.941551649467291e-03, -1.623682064805819e-05,  1.371171885086406e-07, -1.178335038669168e-09,  1.046386554305335e-11, -9.889494616169185e-14,  1.042705338919453e-15,
 -1.281086783424680e-17,  1.811005392402981e-19, -2.686161528841989e-21,  3.591963155046015e-23,  1.858636678308919e+00,  1.174555208098157e-03, -9.809073977343134e-06,
  8.263406496155617e-08, -7.071664745393956e-10,  6.235996312403576e-12, -5.827919197131570e-14,  6.046749358884589e-16, -7.292708259633502e-18,  1.013889639570436e-19,
 -1.482447507080516e-21,  1.945748684560937e-23,  1.925431890363958e+00,  6.192769499487336e-04, -5.167159183775695e-06,  4.346187606407607e-08, -3.709630157334740e-10,
  3.256945059642688e-12, -3.022293669469485e-14,  3.103386429539033e-16, -3.696920423240547e-18,  5.081472133720727e-20, -7.357222117092494e-22,  9.536843715486702e-24,
  1.970068233919793e+00,  2.485049179104963e-04, -2.072342323731545e-06,  1.741426241324476e-08, -1.484001801264212e-10,  1.299449366998184e-12, -1.200619929654960e-14,
  1.224936807600234e-16, -1.447875472403891e-18,  1.975591804295811e-20, -2.842342439685212e-22,  3.655411643369998e-24,  1.994360489893319e+00,  4.681404734862063e-05,
 -3.902811836153820e-07,  3.277992149199647e-09, -2.791137032662618e-11,  2.440692365312445e-13, -2.250040056956957e-15,  2.287955176374288e-17, -2.693291804431199e-19,
  3.660639505312012e-21, -5.248983494747986e-23,  6.722443773316444e-25,  1.265268741089535e+00,  5.942615036601454e-03, -4.861441753028964e-05,  4.054365640033027e-07,
 -3.493427499228525e-09,  3.177403077380102e-11, -3.146069088966774e-13,  3.511135380006682e-15, -4.512109621169062e-17,  6.589599142140229e-19, -1.040611101051663e-20,
  1.659133982193690e-22,  1.494650273627882e+00,  4.075429955618019e-03, -3.312023945456525e-05,  2.725707282892774e-07, -2.291167215006925e-09,  1.997002174023932e-11,
 -1.851607034789463e-13,  1.896604448351395e-15, -2.230401736984698e-17,  3.033945716978326e-19, -4.554639318119459e-21,  6.923453191569861e-23,  1.654797601502018e+00,
  2.779585688773420e-03, -2.251626219596249e-05,  1.841858059027677e-07, -1.531808207561731e-09,  1.311500299279410e-11, -1.182541873133397e-13,  1.165395871541110e-15,
 -1.311932099629022e-17,  1.717679061626825e-19, -2.506396584096684e-21,  3.712634839330629e-23,  1.774007230515945e+00,  1.817933315583248e-03, -1.469802085932593e-05,
  1.198182509413811e-07, -9.906439733069853e-10,  8.399766007681576e-12, -7.458962170539878e-14,  7.191545551754700e-16, -7.885666794110720e-18,  1.007350347541445e-19,
 -1.442087517247598e-21,  2.100081075511477e-23,  1.863183974502382e+00,  1.099865713880676e-03, -8.881468919647480e-06,  7.224648626956053e-08, -5.951854901757715e-10,
  5.017098361982128e-12, -4.413929532351887e-14,  4.197975159910796e-16, -4.525237197045288e-18,  5.684742821323841e-20, -8.029660941250841e-22,  1.155656610096290e-23,
  1.927829490490777e+00,  5.799296528576698e-04, -4.679199661391708e-06,  3.801090203578754e-08, -3.124363641989942e-10,  2.624006627138394e-12, -2.295073463857125e-14,
  2.163803437778380e-16, -2.306440300592222e-18,  2.864649112904863e-20, -4.008794437931263e-22,  5.723054036426259e-24,  1.971030365095131e+00,  2.327235779480310e-04,
 -1.876807693187562e-06,  1.523319499739064e-08, -1.250393961394889e-10,  1.047808980041271e-12, -9.132051132588143e-15,  8.563611750632764e-17, -9.064145452666430e-19,
  1.117623280969994e-20, -1.554577917837425e-22,  2.207780692504865e-24,  1.994541740459555e+00,  4.384190254825989e-05, -3.534726317488996e-07,  2.867728969429885e-09,
 -2.352266928070725e-11,  1.968905385118450e-13, -1.712837145706310e-15,  1.601757839016794e-17, -1.689148313729091e-19,  2.074726234268980e-21, -2.876562982358273e-23,
  4.073867672798665e-25, -2.005491845075950e+00,  3.379822867630585e-03, -7.820953237889831e-04,  1.832758575630879e-04, -4.348877999915197e-05,  1.044809277829263e-05,
 -2.541387424467104e-06,  6.258930262330026e-07, -1.560939911117353e-07,  3.942206761535958e-08, -1.004682740762724e-08,  2.436881609347789e-09, -2.004965078505924e+00,
  3.026200731883229e-03, -6.643491379096560e-04,  1.478656803101036e-04, -3.339115324827734e-05,  7.656091004415977e-06, -1.783647410866765e-06,  4.225214154937148e-07,
 -1.018437161925820e-07,  2.499086753933051e-08, -6.223936650394429e-09,  1.485339854406116e-09, -2.004655924517715e+00,  2.821594659907346e-03, -5.999088221164393e-04,
  1.295379336498825e-04, -2.844413440865505e-05,  6.359352068218516e-06, -1.449298022021443e-06,  3.370351096470409e-07, -8.004826077794519e-08,  1.942776018964673e-08,
 -4.803115959890301e-09,  1.141757163832718e-09, -2.004450642613663e+00,  2.686930525953256e-03, -5.589852368870558e-04,  1.183004744859620e-04, -2.551188608749972e-05,
  5.615001902785026e-06, -1.263022868071351e-06,  2.906878769975104e-07, -6.851432923485046e-08,  1.654453909858633e-08, -4.079211085457096e-09,  9.688601446258303e-10,
 -2.004308964245945e+00,  2.594546723715861e-03, -5.315977660241346e-04,  1.109586753783915e-04, -2.363937001159093e-05,  5.149645084227202e-06, -1.148792100919942e-06,
  2.627473697898571e-07, -6.166194772661826e-08,  1.485195247228193e-08, -3.658113866039129e-09,  8.688958944473379e-10, -2.004211968182994e+00,  2.531560802522633e-03,
 -5.132473371472833e-04,  1.061209573327184e-04, -2.242470147262232e-05,  4.852082002101111e-06, -1.076680535214229e-06,  2.453036152748919e-07, -5.742305133435225e-08,
  1.381243794902686e-08, -3.400833146803841e-09,  8.080134094218766e-10, -2.004149629191950e+00,  2.491192373997119e-03, -5.016239502915982e-04,  1.030909017243317e-04,
 -2.167180977966324e-05,  4.669381443501433e-06, -1.032772691235622e-06,  2.347573211625294e-07, -5.487492673455838e-08,  1.319026813049678e-08, -3.247303486748896e-09,
  7.717433856614707e-10, -2.004116497519837e+00,  2.469773303978697e-03, -4.955004285284370e-04,  1.015053330654665e-04, -2.128029017931725e-05,  4.574906379452762e-06,
 -1.010179015546057e-06,  2.293528188948315e-07, -5.357340450497972e-08,  1.287324942781949e-08, -3.169199581348766e-09,  7.533076416383328e-10, -2.002046605952626e+00,
  1.222694254623535e-03, -2.383322538046010e-04,  4.656338845540710e-05, -9.117784058397020e-06,  1.789381048300293e-06, -3.519417769026615e-07,  6.937114066064661e-08,
 -1.370287167658975e-08,  2.712256842649654e-09, -5.371737160343268e-10,  1.026871972493644e-10, -2.001960685481323e+00,  1.167100562518326e-03, -2.224166186283018e-04,
  4.248306839706395e-05, -8.133338746072989e-06,  1.560775250493400e-06, -3.002230611038001e-07,  5.788858112577021e-08, -1.118918559435531e-08,  2.167957808403357e-09,
 -4.205291579001472e-10,  7.887799146514457e-11, -2.001904931315065e+00,  1.131228023395984e-03, -2.123953258943694e-04,  3.997677869032846e-05, -7.543503243569317e-06,
  1.427166717034842e-06, -2.707358691747362e-07,  5.150132273542054e-08, -9.824770701066664e-09,  1.879605661582665e-09, -3.601940061143143e-10,  6.682859232692792e-11,
 -2.001865487480660e+00,  1.105945793452511e-03, -2.054500009347743e-04,  3.826880580294176e-05, -7.148237965052502e-06,  1.339111370671659e-06, -2.516200251296328e-07,
  4.742748779911668e-08, -8.968385936218810e-09,  1.701449934459688e-09, -3.234850631969496e-10,  5.959913783628524e-11, -2.001837055565953e+00,  1.087771234307591e-03,
 -2.005173834087633e-04,  3.707040280070001e-05, -6.874211208013994e-06,  1.278784748545328e-06, -2.386757741487068e-07,  4.470032864482469e-08, -8.401488619202327e-09,
  1.584800989464360e-09, -2.997029721607825e-10,  5.496010738201764e-11, -2.001816992735879e+00,  1.074971338569609e-03, -1.970737034466739e-04,  3.624100083584958e-05,
 -6.686185047614532e-06,  1.237739824717697e-06, -2.299415257075094e-07,  4.287500587810954e-08, -8.025040359437101e-09,  1.507931522636286e-09, -2.841461947486906e-10,
  5.194559155846587e-11, -2.001803833262851e+00,  1.066586897842529e-03, -1.948315196297158e-04,  3.570420315634518e-05, -6.565208921891683e-06,  1.211483956270229e-06,
 -2.243858666663052e-07,  4.172033790481596e-08, -7.788175451849150e-09,  1.459813865999011e-09, -2.744563089557924e-10,  5.007624481113341e-11, -2.001796753032013e+00,
  1.062079455284639e-03, -1.936305710597655e-04,  3.541773677358943e-05, -6.500881081923968e-06,  1.197571775715464e-06, -2.214521910429331e-07,  4.111264564154822e-08,
 -7.663917634912956e-09,  1.434650176369342e-09, -2.694039353983750e-10,  4.910414301041788e-11, -2.000904790558606e+00,  5.347918740106751e-04, -9.741153431932211e-05,
  1.775247278716823e-05, -3.236894594333927e-06,  5.904971462680054e-07, -1.077766998857884e-07,  1.968103997973600e-08, -3.595713204627492e-09,  6.572329833936475e-10,
 -1.200627489060180e-10,  2.125482575188386e-11, -2.000886843761819e+00,  5.233393405314638e-04, -9.432796454879837e-05,  1.701025119480182e-05, -3.068989699066874e-06,
  5.539821955006741e-07, -1.000490717311407e-07,  1.807791611868839e-08, -3.268153265098756e-09,  5.911019982723126e-10, -1.068576685122136e-10,  1.873244453211575e-11,
 -2.000874723870556e+00,  5.156247924593047e-04, -9.227468939816451e-05,  1.652176433124675e-05, -2.959774249128748e-06,  5.305085341751158e-07, -9.513954177003648e-08,
  1.707134981950480e-08, -3.064894833797224e-09,  5.505464916994238e-10, -9.885371868379945e-11,  1.722011828185625e-11, -2.000865913845675e+00,  5.100269599046800e-04,
 -9.079682894056135e-05,  1.617303691630947e-05, -2.882442490663701e-06,  5.140232026660923e-07, -9.171969479428588e-08,  1.637589533890559e-08, -2.925596401425911e-09,
  5.229767152536425e-10, -9.345605552013962e-11,  1.620781095131714e-11, -2.000859438458573e+00,  5.059178644496954e-04, -8.971845354182757e-05,  1.592009748781097e-05,
 -2.826687575873537e-06,  5.022084357736156e-07, -8.928330357786869e-08,  1.588336301227366e-08, -2.827522744094641e-09,  5.036794429912724e-10, -8.969980931827214e-11,
  1.550711738831044e-11, -2.000854804725253e+00,  5.029801976937031e-04, -8.895085337525677e-05,  1.574083825568473e-05, -2.787346002720637e-06,  4.939079087821450e-07,
 -8.757898687340247e-08,  1.554030054985355e-08, -2.759502266597275e-09,  4.903519880761472e-10, -8.711639852529281e-11,  1.502706505399278e-11, -2.000851735996652e+00,
  5.010359740487009e-04, -8.844437256176996e-05,  1.562291782650384e-05, -2.761544627377595e-06,  4.884805598728018e-07, -8.646794003754467e-08,  1.531732079161784e-08,
 -2.715421091517386e-09,  4.817401851339081e-10, -8.545186721831882e-11,  1.471858202258435e-11, -2.000850075181612e+00,  4.999841703225875e-04, -8.817088238255985e-05,
  1.555936193847949e-05, -2.747664268608081e-06,  4.855662092809537e-07, -8.587243034887454e-08,  1.519802332588351e-08, -2.691879505687263e-09,  4.771492460780705e-10,
 -8.456606624713092e-11,  1.455468569833064e-11, -2.000427245871125e+00,  2.513537357792169e-04, -4.439575528262926e-05,  7.842429018783864e-06, -1.385519327595428e-06,
  2.448089115470298e-07, -4.326077512872014e-08,  7.645635558975062e-09, -1.351401906337564e-09,  2.388882634021880e-10, -4.219469469934222e-11,  7.234512516352998e-12,
 -2.000423119549624e+00,  2.487367280848301e-04, -4.371073120540453e-05,  7.682209048749240e-06, -1.350312219541330e-06,  2.373736088419451e-07, -4.173312962015246e-08,
  7.338036702804241e-09, -1.290413721274020e-09,  2.269429171387388e-10, -3.988081803790030e-11,  6.804957454888490e-12, -2.000420282018529e+00,  2.469392762153491e-04,
 -4.324286683152015e-05,  7.573399773527581e-06, -1.326538164492337e-06,  2.323814430089245e-07, -4.071330249901704e-08,  7.133863017520748e-09, -1.250163328976159e-09,
  2.191044358288440e-10, -3.837110991875338e-11,  6.526183571836035e-12, -2.000418193088943e+00,  2.456171633306918e-04, -4.290010000101477e-05,  7.494004272262644e-06,
 -1.309260748571963e-06,  2.287681082756054e-07, -3.997813004009427e-08,  6.987272241448674e-09, -1.221381226992087e-09,  2.135218945258254e-10, -3.730020574609444e-11,
  6.329176660836293e-12, -2.000416643388893e+00,  2.446369569065159e-04, -4.264672479762903e-05,  7.435489335125261e-06, -1.296565175513191e-06,  2.261209232381392e-07,
 -3.944113647860945e-08,  6.880516292981342e-09, -1.200482693113350e-09,  2.094804557294583e-10, -3.652721552393847e-11,  6.187366058462048e-12, -2.000415526901882e+00,
  2.439310911696651e-04, -4.246466006835795e-05,  7.393534849301461e-06, -1.287482526591211e-06,  2.242312195557567e-07, -3.905863841997913e-08,  6.804640185072152e-09,
 -1.185661472486231e-09,  2.066204811649149e-10, -3.598137582038760e-11,  6.087428936327447e-12, -2.000414784012702e+00,  2.434615735301403e-04, -4.234374039265514e-05,
  7.365712984854715e-06, -1.281468623746392e-06,  2.229818974167240e-07, -3.880614605689226e-08,  6.754629346756038e-09, -1.175907418358359e-09,  2.047411306476787e-10,
 -3.562322962218059e-11,  6.021947979996981e-12, -2.000414380791974e+00,  2.432067825318806e-04, -4.227818284694463e-05,  7.350643349089690e-06, -1.278214279377973e-06,
  2.223064792405577e-07, -3.866976979090239e-08,  6.727642746550956e-09, -1.170648891586485e-09,  2.037288913659333e-10, -3.543050573566607e-11,  5.986741973807167e-12,
 -2.000207798369639e+00,  1.219822788295621e-04, -2.123045312340373e-05,  3.695172690688299e-06, -6.431661013314212e-07,  1.119500932173378e-07, -1.948671591637027e-08,
  3.392076941723750e-09, -5.904800414231110e-10,  1.027888922703509e-10, -1.787823198960630e-11,  3.020888019823056e-12, -2.000206807755233e+00,  1.213558360015961e-04,
 -2.106868657419778e-05,  3.657853849250413e-06, -6.350783993791672e-07,  1.102657040596923e-07, -1.914545551698995e-08,  3.324322073145897e-09, -5.772345406736258e-10,
  1.002311015230027e-10, -1.738974337356796e-11,  2.931401432847094e-12, -2.000206120621371e+00,  1.209215641846865e-04, -2.095685444789351e-05,  3.632126736556884e-06,
 -6.295184897484325e-07,  1.091110234229362e-07, -1.891217394396141e-08,  3.278136222751426e-09, -5.682310721369786e-10,  9.849738084428376e-11, -1.705956689060010e-11,
  2.871075437930216e-12, -2.000205611652996e+00,  1.206000292585632e-04, -2.087421754354195e-05,  3.613153952091330e-06, -6.254264755903080e-07,  1.082628996711752e-07,
 -1.874117041234508e-08,  3.244348366055981e-09, -5.616576943060076e-10,  9.723414264720906e-11, -1.681947156903824e-11,  2.827290102643986e-12, -2.000205232348881e+00,
  1.203604832088372e-04, -2.081274291457460e-05,  3.599060802546455e-06, -6.223914163888583e-07,  1.076347811872530e-07, -1.861471437445999e-08,  3.219399695534124e-09,
 -5.568111973833553e-10,  9.630415381235326e-11, -1.664297647847407e-11,  2.795147940560629e-12, -2.000204958165474e+00,  1.201873650464947e-04, -2.076836377366346e-05,
  3.588897936158884e-06, -6.202051697349688e-07,  1.071828242857690e-07, -1.852382386789016e-08,  3.201487445967415e-09, -5.533353969580787e-10,  9.563791585429236e-11,
 -1.651667407863332e-11,  2.772169973354801e-12, -2.000204775304074e+00,  1.200719257806071e-04, -2.073879315799168e-05,  3.582131415508280e-06, -6.187506647388588e-07,
  1.068823690566953e-07, -1.846344734881336e-08,  3.189597859435861e-09, -5.510300362389101e-10,  9.519636436177517e-11, -1.643303034631217e-11,  2.756963644976163e-12,
 -2.000204675909167e+00,  1.200091846347686e-04, -2.072272908440921e-05,  3.578457277683798e-06, -6.179612604715917e-07,  1.067193801060053e-07, -1.843071020997778e-08,
  3.183154181044201e-09, -5.497812137596721e-10,  9.495728712458860e-11, -1.638776284464332e-11,  2.748737681034381e-12, -2.000102495972752e+00,  6.010342484323914e-05,
 -1.038563261306439e-05,  1.794609214850649e-06, -3.101059009394360e-07,  5.358624970954868e-08, -9.259763389655230e-09,  1.600109102662722e-09, -2.765044748068860e-10,
  4.778009738213967e-11, -8.249552434207459e-12,  1.384246230342033e-12, -2.000102253209609e+00,  5.995012436390257e-05, -1.034630855225302e-05,  1.785598205019579e-06,
 -3.081662220990684e-07,  5.318501774942254e-08, -9.179025259889625e-09,  1.584188280752532e-09, -2.734133345875639e-10,  4.718726091514836e-11, -8.137104638669370e-12,
  1.363778760496755e-12, -2.000102084103872e+00,  5.984336835226398e-05, -1.031896152563193e-05,  1.779340399921792e-06, -3.068210660507642e-07,  5.290715437674471e-08,
 -9.123190248264651e-09,  1.573193539340594e-09, -2.712816179544939e-10,  4.677900098220752e-11, -8.059774944246408e-12,  1.349721815422694e-12, -2.000101958466034e+00,
  5.976407008084495e-05, -1.029866817549596e-05,  1.774701300275438e-06, -3.058248565022237e-07,  5.270157720078729e-08, -9.081922065828323e-09,  1.565075359723904e-09,
 -2.697092003573980e-10,  4.647815791598791e-11, -8.002848215096438e-12,  1.339383381665611e-12, -2.000101864624968e+00,  5.970485004996767e-05, -1.028352420038913e-05,
  1.771241922398637e-06, -3.050825350683302e-07,  5.254850628701672e-08, -9.051217047512337e-09,  1.559039643412194e-09, -2.685410084588953e-10,  4.625481995905562e-11,
 -7.960618664356888e-12,  1.331719427082313e-12, -2.000101796678817e+00,  5.966197637232269e-05, -1.027256631186905e-05,  1.768740150792509e-06, -3.045459933412774e-07,
  5.243792906315541e-08, -9.029048168174826e-09,  1.554684278582083e-09, -2.676985057903186e-10,  4.609383654697689e-11, -7.930195971126549e-12,  1.326201046394843e-12,
 -2.000101751310950e+00,  5.963335177819590e-05, -1.026525305660139e-05,  1.767071116584424e-06, -3.041881818750011e-07,  5.236421516351593e-08, -9.014275452987109e-09,
  1.551783103048655e-09, -2.671375176549754e-10,  4.598668546802068e-11, -7.909954274708162e-12,  1.322530715712797e-12, -2.000101726633463e+00,  5.961778243251960e-05,
 -1.026127620037684e-05,  1.766163731593505e-06, -3.039937007445376e-07,  5.232415900098889e-08, -9.006249862814221e-09,  1.550207352854772e-09, -2.668328938883177e-10,
  4.592851487729705e-11, -7.898967982337242e-12,  1.320539064769754e-12, -2.000050903520728e+00,  2.983407450237822e-05, -5.136867542093507e-06,  8.844737754839431e-07,
 -1.522903377165024e-07,  2.622168127063879e-08, -4.514914321407435e-09,  7.773905865887139e-10, -1.338534347716942e-10,  2.304676108857639e-11, -3.964892993360138e-12,
  6.630340684784932e-13, -2.000050843427553e+00,  2.979615331890843e-05, -5.127172187966248e-06,  8.822595009999970e-07, -1.518152936822046e-07,  2.612374544643857e-08,
 -4.495273308855261e-09,  7.735305851325896e-10, -1.331065123617475e-10,  2.290399501663164e-11, -3.937904475175536e-12,  6.581371759479090e-13, -2.000050801479643e+00,
  2.976968636005396e-05, -5.120409983253121e-06,  8.807161824858522e-07, -1.514844245790198e-07,  2.605558043269106e-08, -4.481612354528398e-09,  7.708477028824859e-10,
 -1.325877285173847e-10,  2.280490435792811e-11, -3.919185386458882e-12,  6.547429324211788e-13, -2.000050770267486e+00,  2.974999515440569e-05, -5.115381428877329e-06,
  8.795690994499520e-07, -1.512386261463962e-07,  2.600496678870283e-08, -4.471473939388633e-09,  7.688576094954003e-10, -1.322031004104853e-10,  2.273147495200288e-11,
 -3.905320841348916e-12,  6.522301144315339e-13, -2.000050746928526e+00,  2.973527215377363e-05, -5.111622985868938e-06,  8.787120637511530e-07, -1.510550476592944e-07,
  2.596717924943282e-08, -4.463907540204447e-09,  7.673729367851059e-10, -1.319162626432146e-10,  2.267673512852838e-11, -3.894988999438336e-12,  6.503582173416797e-13,
 -2.000050730015893e+00,  2.972460370688668e-05, -5.108900313831010e-06,  8.780913839277036e-07, -1.509221334498757e-07,  2.593982788844569e-08, -4.458432337781101e-09,
  7.662988924603081e-10, -1.317088150793360e-10,  2.263715693690026e-11, -3.887520877994215e-12,  6.490055092811566e-13, -2.000050718716754e+00,  2.971747652357004e-05,
 -5.107081745245414e-06,  8.776768893900388e-07, -1.508333894251832e-07,  2.592156947508545e-08, -4.454778068127382e-09,  7.655821899880034e-10, -1.315704134146688e-10,
  2.261075685838754e-11, -3.882540327966391e-12,  6.481035397212974e-13, -2.000050712568483e+00,  2.971359846182719e-05, -5.106092337007144e-06,  8.774514066995983e-07,
 -1.507851189149424e-07,  2.591163936434356e-08, -4.452790875822841e-09,  7.651924935472375e-10, -1.314951685132125e-10,  2.259640562509284e-11, -3.879833193779042e-12,
  6.476133366282144e-13, -2.000025366419503e+00,  1.486315216831799e-05, -2.554622896309603e-06,  4.390792108362853e-07, -7.546735831207239e-08,  1.297106451712560e-08,
 -2.229422033526945e-09,  3.831855713045280e-10, -6.586063183446955e-11,  1.131963155463927e-11, -1.943935139502025e-12,  3.245304686186294e-13, -2.000025351470075e+00,
  1.485372176496879e-05, -2.552215770570869e-06,  4.385303698420488e-07, -7.534980740069759e-08,  1.294687043749183e-08, -2.224578016158735e-09,  3.822351793135326e-10,
 -6.567703566323026e-11,  1.128459788960580e-11, -1.937323416348968e-12,  3.233326912114722e-13, -2.000025341023784e+00,  1.484713250879834e-05, -2.550534427294022e-06,
  4.381471445541189e-07, -7.526775656494495e-08,  1.292998877572246e-08, -2.221199230208589e-09,  3.815724952316742e-10, -6.554906332781058e-11,  1.126018682445495e-11,
 -1.932718040263515e-12,  3.224986544274144e-13, -2.000025333245210e+00,  1.484222623558078e-05, -2.549282828531445e-06,  4.378619408056012e-07, -7.520670792583733e-08,
  1.291743137172110e-08, -2.218686551704120e-09,  3.810798046251633e-10, -6.545394257230047e-11,  1.124204682084308e-11, -1.929296610522190e-12,  3.218791757885240e-13,
 -2.000025327425522e+00,  1.483855565647274e-05, -2.548346628983073e-06,  4.376486470266074e-07, -7.516106029006491e-08,  1.290804362516992e-08, -2.216808456880848e-09,
  3.807116129840837e-10, -6.538287132218958e-11,  1.122849570516670e-11, -1.926741176555107e-12,  3.214165735383993e-13, -2.000025323206537e+00,  1.483589474473643e-05,
 -2.547668041932461e-06,  4.374940660624314e-07, -7.512798249406072e-08,  1.290124188602477e-08, -2.215447900912485e-09,  3.804449190940400e-10, -6.533139905220327e-11,
  1.121868286676802e-11, -1.924890950752055e-12,  3.210816759737707e-13, -2.000025320387068e+00,  1.483411654275851e-05, -2.547214606975260e-06,  4.373907842501032e-07,
 -7.510588400146326e-08,  1.289669824273953e-08, -2.214539120836729e-09,  3.802667987368832e-10, -6.529702490707868e-11,  1.121213030192505e-11, -1.923655573257663e-12,
  3.208580883250292e-13, -2.000025318852620e+00,  1.483314879831251e-05, -2.546967850182837e-06,  4.373345821896705e-07, -7.509385955178245e-08,  1.289422605805456e-08,
 -2.214044685411122e-09,  3.801698954683925e-10, -6.527832537009735e-11,  1.120856591899854e-11, -1.922983607872089e-12,  3.207364778958068e-13, -2.000012661970465e+00,
  7.418169634681724e-06, -1.273880471420693e-06,  2.187563402451048e-07, -3.756580223169738e-08,  6.450965748747256e-09, -1.107788502825410e-09,  1.902343817887165e-10,
 -3.266787682945168e-11,  5.609735268947302e-12, -9.625160593626493e-13,  1.605530279772697e-13, -2.000012658242290e+00,  7.415818233413467e-06, -1.273280764007200e-06,
  2.186197159036468e-07, -3.753656427226020e-08,  6.444953056914999e-09, -1.106585673931836e-09,  1.899985844343948e-10, -3.262236361166845e-11,  5.601057718621483e-12,
 -9.608797505909667e-13,  1.602568258960472e-13, -2.000012655635780e+00,  7.414174338001642e-06, -1.272861572320326e-06,  2.185242328295783e-07, -3.751613418909488e-08,
  6.440752405619192e-09, -1.105745486735082e-09,  1.898339064281604e-10, -3.259058326420668e-11,  5.594999531853073e-12, -9.597375681099265e-13,  1.600501034037721e-13,
 -2.000012653694182e+00,  7.412949826931184e-06, -1.272549361522118e-06,  2.184531265679442e-07, -3.750092179496022e-08,  6.437624958765167e-09, -1.105120033019352e-09,
  1.897113318264744e-10, -3.256693118746538e-11,  5.590491374781503e-12, -9.588877268011148e-13,  1.598963094043786e-13, -2.000012652241135e+00,  7.412033448594780e-06,
 -1.272315736018603e-06,  2.183999230909297e-07, -3.748954055926551e-08,  6.435285359985007e-09, -1.104652183508525e-09,  1.896196525830001e-10, -3.254924234883834e-11,
  5.587120143196201e-12, -9.582522684999802e-13,  1.597813218634038e-13, -2.000012651187531e+00,  7.411368992776363e-06, -1.272146348198629e-06,  2.183613510795072e-07,
 -3.748128983803226e-08,  6.433589406055600e-09, -1.104313066963368e-09,  1.895532042736160e-10, -3.253642251670537e-11,  5.584677040585107e-12, -9.577917888923761e-13,
  1.596980024498522e-13, -2.000012650483326e+00,  7.410924889854967e-06, -1.272033139680604e-06,  2.183355731272470e-07, -3.747577608687059e-08,  6.432456096948890e-09,
 -1.104086465680402e-09,  1.895088049488818e-10, -3.252785699532830e-11,  5.583044769799112e-12, -9.574841508613958e-13,  1.596423407784919e-13, -2.000012650100040e+00,
  7.410683174291530e-06, -1.271971524553614e-06,  2.183215435756589e-07, -3.747277533821813e-08,  6.431839334543779e-09, -1.103963149824170e-09,  1.894846436677438e-10,
 -3.252319593818213e-11,  5.582156571653109e-12, -9.573167549828572e-13,  1.596120542939319e-13, -2.000006325687340e+00,  3.705741262653925e-06, -6.360851909315064e-07,
  1.091831169465896e-07, -1.874112703119594e-08,  3.216887942246781e-09, -5.521742798211335e-10,  9.477993734357565e-11, -1.626883165450019e-11,  2.792452937893861e-12,
 -4.789168235497283e-13,  7.985268959249104e-14, -2.000006324756440e+00,  3.705154184985397e-06, -6.359355223953265e-07,  1.091490337868735e-07, -1.873383616991502e-08,
  3.215389222662760e-09, -5.518745881034999e-10,  9.472121151808141e-11, -1.625750120971128e-11,  2.790293574483641e-12, -4.785098054293965e-13,  7.977904045884074e-14,
 -2.000006324105444e+00,  3.704743637416263e-06, -6.358308670644009e-07,  1.091252032819680e-07, -1.872873893524067e-08,  3.214341518911896e-09, -5.516651020399778e-10,
  9.468016542966249e-11, -1.624958254713459e-11,  2.788784561958523e-12, -4.782253964986809e-13,  7.972758139990142e-14, -2.000006323620425e+00,  3.704437766256264e-06,
 -6.357529002535585e-07,  1.091074509764482e-07, -1.872494203536232e-08,  3.213561139222224e-09, -5.515090765674224e-10,  9.464959616168144e-11, -1.624368545409332e-11,
  2.787660858122365e-12, -4.780136212335531e-13,  7.968926642850922e-14, -2.000006323257397e+00,  3.704208829669966e-06, -6.356945468002888e-07,  1.090941650612190e-07,
 -1.872210054818661e-08,  3.212977153385744e-09, -5.513923226015811e-10,  9.462672222375958e-11, -1.623927306671102e-11,  2.786820107358033e-12, -4.778551791750089e-13,
  7.966060189795620e-14, -2.000006322994138e+00,  3.704042812050548e-06, -6.356522321399763e-07,  1.090845311875808e-07, -1.872004020160462e-08,  3.212553723040561e-09,
 -5.513076707674871e-10,  9.461013816893096e-11, -1.623607410921099e-11,  2.786210588488157e-12, -4.777403174142358e-13,  7.963982236130195e-14, -2.000006322818170e+00,
  3.703931842163706e-06, -6.356239487460379e-07,  1.090780919980285e-07, -1.871866311864343e-08,  3.212270719844464e-09, -5.512510943738570e-10,  9.459905461259536e-11,
 -1.623393621410288e-11,  2.785803250801222e-12, -4.776635578564831e-13,  7.962593617273474e-14, -2.000006322722389e+00,  3.703871440790012e-06, -6.356085542022229e-07,
  1.090745872235559e-07, -1.871791359987533e-08,  3.212116689149426e-09, -5.512203018904752e-10,  9.459302232409374e-11, -1.623277266992444e-11,  2.785581561573929e-12,
 -4.776217829006358e-13,  7.961837897938156e-14, -2.000003161520684e+00,  1.852035747071727e-06, -3.178291705584656e-07,  5.454289018833295e-08, -9.360144275168472e-09,
  1.606301044405213e-09, -2.756584713008572e-10,  4.730594680248334e-11, -8.118201564969212e-12,  1.393135871241445e-12, -2.388757964284962e-13,  3.982091234986123e-14,
 -2.000003161288102e+00,  1.851889074092517e-06, -3.177917856558183e-07,  5.453437849464594e-08, -9.358323882668463e-09,  1.605926919618325e-09, -2.755836749104401e-10,
  4.729129318791524e-11, -8.115374913360296e-12,  1.392597278195502e-12, -2.387742981244688e-13,  3.980254999830424e-14, -2.000003161125432e+00,  1.851786490420575e-06,
 -3.177656396204108e-07,  5.452842589250463e-08, -9.357050857143722e-09,  1.605665300352686e-09, -2.755313733045858e-10,  4.728104704809713e-11, -8.113398540330225e-12,
  1.392220714458573e-12, -2.387033374502527e-13,  3.978971281904311e-14, -2.000003161004224e+00,  1.851710054672449e-06, -3.177461586399018e-07,  5.452399084396708e-08,
 -9.356102405633135e-09,  1.605470390310175e-09, -2.754924090856645e-10,  4.727341400566365e-11, -8.111926252376364e-12,  1.391940204183072e-12, -2.386504789901659e-13,
  3.978015070958238e-14, -2.000003160913496e+00,  1.851652840256442e-06, -3.177315768840992e-07,  5.452067123179998e-08, -9.355392510785053e-09,  1.605324507873388e-09,
 -2.754632465920252e-10,  4.726770124221672e-11, -8.110824380240361e-12,  1.391730272932311e-12, -2.386109211344119e-13,  3.977299483881077e-14, -2.000003160847700e+00,
  1.851611347882310e-06, -3.177210022512971e-07,  5.451826390301731e-08, -9.354877715404228e-09,  1.605218719931624e-09, -2.754420995149398e-10,  4.726355872368291e-11,
 -8.110025389136332e-12,  1.391578049903198e-12, -2.385822378709181e-13,  3.976780622527482e-14, -2.000003160803718e+00,  1.851583612384608e-06, -3.177139337421354e-07,
  5.451665476706559e-08, -9.354533613757978e-09,  1.605148009572108e-09, -2.754279646393867e-10,  4.726078986455717e-11, -8.109491349980335e-12,  1.391476306496966e-12,
 -2.385630666728864e-13,  3.976433832087697e-14, -2.000003160779777e+00,  1.851568515477629e-06, -3.177100862596171e-07,  5.451577889968849e-08, -9.354346317486069e-09,
  1.605109521851494e-09, -2.754202710696460e-10,  4.725928279421485e-11, -8.109200678434638e-12,  1.391420929111436e-12, -2.385526321595852e-13,  3.976245082057705e-14,
     0.998664063753816,     0.992909879517146,     0.982338368802167,     0.966523029269436,     0.944714317867243,     0.915577444886927,     0.876470045475693,
     0.820547192392332,     0.999333496501502,     0.996462746800532,     0.991188789248403,     0.983299130562974,     0.972420349588821,     0.957887491892144,
     0.938384281215499,     0.910501123679717,     0.999667091841792,     0.998233200847228,     0.995598964931797,     0.991658279986062,     0.986224686561898,
     0.978966155181619,      0.96922543390362,     0.955300013899808,      0.99983362936797,     0.999117043768713,     0.997800589015408,     0.995831243594735,
     0.993115831449821,     0.989488433284871,     0.984620611618889,     0.977661598295882,      0.99991683525855,     0.999558631135709,     0.998900566918078,
     0.997916138888737,     0.996558771384965,     0.994745526752668,     0.992312229710603,     0.988833608453485,     0.999958422738111,     0.999779342688574,
     0.999450351049103,     0.998958197649081,     0.998279597622265,     0.997373087417756,     0.996156589828085,     0.994417495935502,      0.99997921264198,
     0.999889678100811,     0.999725192358951,     0.999479130744181,     0.999139851549176,     0.998686624290394,     0.998078412919987,     0.997208919594473,
     0.999989606638689,     0.999944840736602,     0.999862600380244,      0.99973957333568,     0.999569938928779,     0.999343332237396,     0.999039235870123,
     0.998604502542991,     0.999994803398703,     0.999972420789484,     0.999931301239339,     0.999869788656705,     0.999784972749161,     0.999671671135126,
     0.999519625276224,     0.999302261937919,     0.999997401719183,     0.999986210499993,     0.999965650881852,     0.999934894825315,     0.999892487195302,
     0.999835836820844,     0.999759814471984,      0.99965113363307,     0.999998700864548,     0.999993105276303,     0.999982825506456,     0.999967447536866,
     0.999946243802773,     0.999917918723639,     0.999879907694283,     0.999825567482251  };
  constexpr double w[4216] = {  1.804494514912904e-01, -7.794430043891473e-02,  1.806012176877307e-02, -2.846479502189604e-03,  3.395906407867665e-04,
 -3.258540619885706e-05,  2.615058736301478e-06, -1.803679655563800e-07,  1.090856105247259e-08, -5.874680634511675e-10,  2.851613342244419e-11, -1.258085428316933e-12,
  1.809713949656040e-01, -7.343992825186842e-02,  1.599650973465341e-02, -2.383858206408770e-03,  2.705375970563656e-04, -2.483240642861412e-05,  1.915872724762085e-06,
 -1.276005733162801e-07,  7.481097877954522e-09, -3.919120122139388e-10,  1.856236235984833e-11, -8.013057450605954e-13,  1.811369387104399e-01, -6.439204200923559e-02,
  1.236522651650065e-02, -1.646406919136220e-03,  1.690889851487780e-04, -1.420583231065196e-05,  1.013201349579098e-06, -6.292907423820026e-08,  3.467101624604252e-09,
 -1.718449208928327e-10,  7.747115073735719e-12, -3.200618325978882e-13,  1.787002934120654e-01, -5.116111421347386e-02,  8.089641837347932e-03, -9.084563738246897e-04,
  8.032168377973985e-05, -5.911118223456899e-06,  3.748185649527496e-07, -2.096351104717504e-08,  1.051788782822880e-09, -4.794383648301044e-11,  2.005273035158494e-12,
 -7.747531889341641e-14,  1.694455604932853e-01, -3.523241600349558e-02,  4.263835439312943e-03, -3.806054889662367e-04,  2.753947240158600e-05, -1.697952945644634e-06,
  9.197748015167540e-08, -4.468374426163621e-09,  1.975628267740298e-10, -8.037343728371833e-12,  3.034282931884987e-13, -1.069095825156010e-14,  1.474857658235270e-01,
 -1.961715004382302e-02,  1.679921497025651e-03, -1.119514897281450e-04,  6.282100452742882e-06, -3.093532143115338e-07,  1.370889286513556e-08, -5.559542013663207e-10,
  2.088061882346859e-11, -7.327640400014274e-13,  2.419142014027331e-14, -7.547635320682848e-16,  1.077412119322030e-01, -7.923687046203868e-03,  4.381069447529716e-04,
 -2.026493678096940e-05,  8.272512600052767e-07, -3.070334074164077e-08,  1.055154773204388e-09, -3.398721912614386e-11,  1.034983411748627e-12, -2.998813110557531e-14,
  8.307963404471820e-16, -2.207857834450590e-17,  5.035739649419314e-02, -1.912658552205818e-03,  5.936634762888036e-05, -1.689825249719805e-06,  4.525672877007266e-08,
 -1.153928520177277e-09,  2.823341828188921e-11, -6.667802579691164e-13,  1.526747862498987e-14, -3.400953675698965e-16,  7.389919653816379e-18, -1.568978847005852e-19,
  2.654921008583874e-02, -1.142387441193993e-02,  2.636633693260583e-03, -4.140561859161068e-04,  4.923401030211085e-05, -4.709972355601532e-06,  3.769440072556392e-07,
 -2.593322790536201e-08,  1.564791125810220e-09, -8.409005862209185e-11,  4.073740835795488e-12, -1.793992383614597e-13,  3.101485844947435e-02, -1.233153471234580e-02,
  2.633912024824742e-03, -3.857196272058806e-04,  4.310444305699396e-05, -3.902983030813561e-06,  2.975101887107253e-07, -1.960315662180563e-08,  1.138358189779800e-09,
 -5.912593404846352e-11,  2.778933660268620e-12, -1.191347369521207e-13,  4.078656357486640e-02, -1.377509167457236e-02,  2.525107405090885e-03, -3.228133593875954e-04,
  3.199251753218533e-05, -2.604687484148386e-06,  1.806730946292711e-07, -1.094668618697399e-08,  5.898913495784728e-10, -2.866197255002087e-11,  1.269223851671023e-12,
 -5.159851796148913e-14,  5.650057756763049e-02, -1.478205825097162e-02,  2.164705391626455e-03, -2.275325945591513e-04,  1.898595994018325e-05, -1.327455896024907e-06,
  8.041094332617092e-08, -4.316440644391408e-09,  2.086885291644562e-10, -9.198716247163843e-12,  3.731868192090844e-13, -1.402433636402896e-14,  7.575842422621336e-02,
 -1.387050544119477e-02,  1.516832113479928e-03, -1.241456022723341e-04,  8.323185776848515e-06, -4.793675060352663e-07,  2.441782551021921e-08, -1.121693857801063e-09,
  4.712053688773313e-11, -1.829030511668870e-12,  6.612819318790844e-14, -2.238989723991715e-15,  8.929973651697512e-02, -1.021846687614464e-02,  7.815575723400237e-04,
 -4.724965456389466e-05,  2.431040405850700e-06, -1.106523569100364e-07,  4.561912456145494e-09, -1.730575060407090e-10,  6.108709756370693e-12, -2.023175979878952e-13,
  6.327287326452796e-15, -1.876552803219849e-16,  8.178175710643697e-02, -5.205637216920919e-03,  2.577906535351667e-04, -1.083260153600145e-05,  4.051529385945528e-07,
 -1.386461876177063e-08,  4.415688974061310e-10, -1.323831756598728e-11,  3.766339175154820e-13, -1.022968412876349e-14,  2.664763115377367e-16, -6.677826477030238e-18,
  4.354353039637134e-02, -1.508072260101736e-03,  4.277552220300399e-05, -1.119011487193515e-06,  2.768571506426423e-08, -6.547206621477850e-10,  1.490298591118417e-11,
 -3.282457748809440e-13,  7.024324597909984e-15, -1.465107311101507e-16,  2.985908071813215e-18, -5.955781227290180e-20,  3.944687877819304e-03, -1.689247397478894e-03,
  3.880030183981622e-04, -6.066258592094973e-05,  7.184318566503733e-06, -6.848014985992045e-07,  5.462572975878382e-08, -3.746976648351763e-09,  2.254751520228610e-10,
 -1.208662185958728e-11,  5.841977057938664e-13, -2.567282772348624e-14,  5.569547616774972e-03, -2.157129787696040e-03,  4.495117441660390e-04, -6.441071320855072e-05,
  7.061989006691849e-06, -6.288276793382429e-07,  4.723126515247836e-08, -3.071732544472413e-09,  1.763186465030990e-10, -9.063680015919949e-12,  4.220702642238196e-13,
 -1.794509097129620e-14,  1.006251731494795e-02, -3.191164556230503e-03,  5.532774087446463e-04, -6.739897455658782e-05,  6.404361508904671e-06, -5.024904042521416e-07,
  3.373383468522752e-08, -1.985303763692135e-09,  1.042403276042358e-10, -4.948290970401840e-12,  2.145802856612288e-13, -8.560564463803142e-15,  2.000759010459318e-02,
 -4.718225628116864e-03,  6.340212250812834e-04, -6.191236930324583e-05,  4.844464487596866e-06, -3.199769084469953e-07,  1.842170455208984e-08, -9.446520611912233e-10,
  4.382052284434318e-11, -1.860350767089124e-12,  7.293578091590300e-14, -2.656838780813102e-15,  3.755423073232374e-02, -5.995513996753481e-03,  5.896718725543148e-04,
 -4.407719710582453e-05,  2.728324706031115e-06, -1.462869258039873e-07,  6.983798500421540e-09, -3.023808626515583e-10,  1.203073018296983e-11, -4.441729782120972e-13,
  1.533243662564030e-14, -4.973700088637291e-16,  5.809192298238330e-02, -5.709109618223822e-03,  3.904770177411191e-04, -2.143049101901757e-05,  1.011235217891528e-06,
 -4.253886825051288e-08,  1.630865073981633e-09, -5.783029531873449e-11,  1.916691054879551e-12, -5.984010692282469e-14,  1.770424531159778e-15, -4.983783490574603e-17,
  6.439242749310609e-02, -3.570947897179381e-03,  1.591150442497309e-04, -6.097948075570088e-06,  2.096355187149698e-07, -6.631936126788673e-09,  1.961679712009000e-10,
 -5.483497703756939e-12,  1.459548717439020e-13, -3.720106166978972e-15,  9.118924502729140e-17, -2.155975331829661e-18,  3.812006620178231e-02, -1.212932889493562e-03,
  3.162848772324473e-05, -7.640850040969992e-07,  1.753678624826180e-08, -3.860999684489386e-10,  8.204936245604195e-12, -1.690947833358292e-13,  3.392157274558183e-15,
 -6.643974013568395e-17,  1.273112163562546e-18, -2.392678685559443e-20,  5.933269999547105e-04, -2.525378400103612e-04,  5.765593484356939e-05, -8.964970009497304e-06,
  1.056528014128611e-06, -1.002653058958636e-07,  7.966512538225860e-09, -5.445095209803748e-10,  3.266049560714936e-11, -1.745644077502487e-12,  8.414887867632285e-14,
 -3.688927950226900e-15,  1.059687148605135e-03, -3.967554969914427e-04,  8.013899210263408e-05, -1.117521921569959e-05,  1.196653300002194e-06, -1.043821835390572e-07,
  7.699831057387382e-09, -4.928624715408874e-10,  2.789503070879166e-11, -1.416124864753166e-12,  6.521366417808920e-14, -2.745220086119077e-15,  2.751750406586737e-03,
 -8.082659113885233e-04,  1.311877822563671e-04, -1.510146481322098e-05,  1.366184582572459e-06, -1.026748596932388e-07,  6.635669365741202e-09, -3.775410708117602e-10,
  1.923352121208400e-11, -8.886237115335227e-13,  3.760727972857071e-14, -1.467776747056374e-15,  7.946025036576021e-03, -1.665773187907073e-03,  2.036587449791788e-04,
 -1.834956239532940e-05,  1.338447145585262e-06, -8.307167640774348e-08,  4.523446557760467e-09, -2.205910864111978e-10,  9.776934425671685e-12, -3.981986278287091e-13,
  1.503096995030171e-14, -5.288974173722055e-16,  2.047181933832124e-02, -2.826592447164640e-03,  2.492908666410880e-04, -1.697376371953494e-05,  9.676086321856834e-07,
 -4.817910149531173e-08,  2.150299659622188e-09, -8.752804350956305e-11,  3.289751151729611e-12, -1.152228297945964e-13,  3.787487215595009e-15, -1.174035641525505e-16,
  4.019205160322686e-02, -3.392046214054671e-03,  2.079513864188238e-04, -1.037756690330584e-05,  4.495681862014232e-07, -1.748877052714937e-08,  6.236533105304840e-10,
 -2.067016742591313e-11,  6.430277432246091e-13, -1.891353890193976e-14,  5.289511926911769e-16, -1.411913091145096e-17,  5.226005992368164e-02, -2.542352243903978e-03,
  1.023934130501819e-04, -3.593163758780744e-06,  1.139218417752205e-07, -3.341094720172581e-09,  9.200289692404103e-11, -2.402661562949831e-12,  5.993082792338669e-14,
 -1.435422976231193e-15,  3.314653511742742e-17, -7.399998138029460e-19,  3.372235914971280e-02, -9.923356063819496e-04,  2.391890807331266e-05, -5.359875008179043e-07,
  1.145561223266170e-08, -2.356348693151254e-10,  4.690141585807775e-12, -9.072622208123087e-14,  1.710613339100407e-15, -3.157375684386945e-17,  5.692909381020587e-19,
 -1.012633728229960e-20,  9.064262002648483e-05, -3.827563355340919e-05,  8.671430444184765e-06, -1.339057937216945e-06,  1.568484550046240e-07, -1.480475142456353e-08,
  1.170655931779854e-09, -7.967072327613762e-11,  4.760342922334803e-12, -2.535460478755108e-13,  1.218362813864676e-14, -5.325764523694134e-16,  2.165007641212957e-04,
 -7.757614159184252e-05,  1.506375997196141e-05, -2.030558081037042e-06,  2.111717751351720e-07, -1.795939383240500e-08,  1.295833439592084e-09, -8.135321115525845e-11,
  4.526408312507301e-12, -2.263375947741041e-13,  1.028377065059689e-14, -4.277528298727849e-16,  8.426986513660634e-04, -2.257022395319481e-04,  3.391992230426767e-05,
 -3.657395239775291e-06,  3.126846231331801e-07, -2.236499381222062e-08,  1.383585794456884e-09, -7.571881608541640e-11,  3.725689926017519e-12, -1.668470517635635e-13,
  6.865486402328382e-15, -2.612542188248174e-16,  3.532460851440883e-03, -6.494990608498552e-04,  7.172560829288801e-05, -5.927600190048544e-06,  4.009785520454692e-07,
 -2.327602151698642e-08,  1.193514270690545e-09, -5.512255733930310e-11,  2.325159958132574e-12, -9.051317009981209e-14,  3.277922388535349e-15, -1.110385941618201e-16,
  1.215787800382188e-02, -1.442243030004358e-03,  1.139295978556861e-04, -7.056439942317492e-06,  3.699327397829457e-07, -1.707840537435513e-08,  7.113713409659706e-10,
 -2.717240456117470e-11,  9.628801878637328e-13, -3.192797336925190e-14,  9.972711167173625e-16, -2.947497681644801e-17,  2.930561883957934e-02, -2.126406361449574e-03,
  1.172187993679930e-04, -5.331212272016700e-06,  2.123856529282490e-07, -7.649525748941130e-09,  2.539331907522677e-10, -7.870210759043515e-12,  2.298499318194121e-13,
 -6.368758611946180e-15,  1.683177520711600e-16, -4.258091878622802e-18,  4.349377558025449e-02, -1.869088679145993e-03,  6.834115583906317e-05, -2.204524844625734e-06,
  6.467765247046971e-08, -1.763568654314690e-09,  4.532133688759412e-11, -1.108124553265615e-12,  2.594982123375492e-14, -5.849893050637061e-16,  1.274270291840660e-17,
 -2.689092659519976e-19,  3.009895625908067e-02, -8.239181239740364e-04,  1.844897037263770e-05, -3.850478297662466e-07,  7.690802806276714e-09, -1.482821717085181e-10,
  2.772215975658467e-12, -5.052064290676264e-14,  8.956184442215150e-16, -1.568790448470534e-17,  2.657755407410861e-19, -4.456978989871268e-21,  1.412931244114269e-05,
 -5.903756612208893e-06,  1.324145068138717e-06, -2.026776387574128e-07,  2.355789525163162e-08, -2.208639138719357e-09,  1.736088783139829e-10, -1.175320929989592e-11,
  6.989746152460132e-13, -3.707307105272768e-14,  1.774759143939630e-15, -7.731555933297810e-17,  4.824558575881474e-05, -1.632923162008839e-05,  3.017319464860908e-06,
 -3.899445958994213e-07,  3.911856363419655e-08, -3.225202392488156e-09,  2.265192724117645e-10, -1.388977969335041e-11,  7.569702991294311e-13, -3.716541291885820e-14,
  1.661471187959381e-15, -6.812117119598689e-17,  2.912368926416741e-04, -6.991514835031075e-05,  9.621660560826290e-06, -9.631995121753639e-07,  7.724131546425973e-08,
 -5.223768490838086e-09,  3.075484125420143e-10, -1.610479778228597e-11,  7.617322063320686e-13, -3.292183857533909e-14,  1.311935915096475e-15, -4.849875357627026e-17,
  1.749068776843212e-03, -2.785230451585382e-04,  2.762865161089156e-05, -2.084508003459692e-06,  1.302262976728547e-07, -7.042474581206601e-09,  3.387877412939882e-10,
 -1.476559907864155e-11,  5.907066183049643e-13, -2.190414914785902e-14,  7.585613013118130e-16, -2.465921767512183e-17,  7.789600623197799e-03, -7.898961278797253e-04,
  5.591789358318838e-05, -3.149796040753457e-06,  1.517862680879938e-07, -6.492429183772116e-09,  2.521470392487116e-10, -9.027406958865757e-12,  3.012042969414309e-13,
 -9.441462544536064e-15,  2.797756250372035e-16, -7.870740644735201e-18,  2.233886758287645e-02, -1.396580666050047e-03,  6.948335822000841e-05, -2.888127885701419e-06,
  1.060299436735052e-07, -3.541468287794968e-09,  1.095758943714005e-10, -3.178495176012947e-12,  8.720482918061904e-14, -2.276976855193478e-15,  5.687347285369877e-17,
 -1.363597011475476e-18,  3.696506456193167e-02, -1.412927254778750e-03,  4.709815191157861e-05, -1.401834228819059e-06,  3.818373339939149e-08, -9.707916729689927e-10,
  2.334047009965212e-11, -5.355139470301874e-13,  1.179589494162085e-14, -2.506967994290814e-16,  5.159705351207169e-18, -1.030472978530950e-19,  2.707188669534026e-02,
 -6.929208335172205e-04,  1.447936994862130e-05, -2.825338848623442e-07,  5.290672930555900e-09, -9.594229344007661e-11,  1.686657412754783e-12, -2.917304988915391e-14,
  4.832539267678716e-16, -8.098259125604474e-18,  1.317355353559411e-19, -1.956427588445343e-21,  2.261940190082201e-06, -9.315901654955079e-07,  2.061715958949015e-07,
 -3.119519654802668e-08,  3.590143780222116e-09, -3.337187413580619e-10,  2.603710826344807e-11, -1.751231835728322e-12,  1.035499200340493e-13, -5.464237966246576e-15,
  2.603943678650809e-16, -1.129764955858959e-17,  1.193181117989028e-05, -3.751314806586695e-06,  6.515488652412926e-07, -7.994561121645262e-08,  7.674644102172163e-09,
 -6.093000115668876e-10,  4.141725938671480e-11, -2.468268373973669e-12,  1.311956036711732e-13, -6.301030164585699e-15,  2.762473465956860e-16, -1.113226230448260e-17,
  1.140589560417870e-04, -2.410002272102497e-05,  3.005482812477209e-06, -2.770051415067093e-07,  2.068837589496238e-08, -1.314605063891497e-09,  7.323992994002231e-11,
 -3.650721288211408e-12,  1.651947258570307e-13, -6.860136066634717e-15,  2.636718578195832e-16, -9.433340805413055e-18,  9.574247996765242e-04, -1.305319242673351e-04,
  1.159082857537549e-05, -7.956691593707975e-07,  4.576672717478931e-08, -2.298862295881176e-09,  1.034470161999461e-10, -4.242112611502792e-12,  1.604826998622166e-13,
 -5.652159450248814e-15,  1.866384503151681e-16, -5.805829180901158e-18,  5.332844372853680e-03, -4.605486852618734e-04,  2.927677348001979e-05, -1.500928432587198e-06,
  6.651039462488915e-08, -2.635787897303178e-09,  9.542444612081280e-11, -3.200361718064225e-12,  1.004701124644528e-13, -2.974389555592278e-15,  8.352202015505097e-17,
 -2.233788159424180e-18,  1.767940950907209e-02, -9.550886405494825e-04,  4.305931134672637e-05, -1.640818862579473e-06,  5.564729462065147e-08, -1.726814917092728e-09,
  4.988433540837304e-11, -1.355685544253488e-12,  3.497847894499923e-14, -8.613580237132980e-16,  2.033551884230200e-17, -4.623564214781505e-19,  3.197332520738418e-02,
 -1.094344496259933e-03,  3.338735694118648e-05, -9.202102576958019e-07,  2.334468142640983e-08, -5.550062652487561e-10,  1.251371849664531e-11, -2.700396670173038e-13,
  5.606645143975673e-15, -1.124980784039782e-16,  2.191721870198355e-18, -4.149525763691608e-20,  2.451225651316061e-02, -5.893412424148011e-04,  1.153998042567426e-05,
 -2.112838952068688e-07,  3.718468696179821e-09, -6.375392285603822e-11,  1.048884010346268e-12, -1.749957816572627e-14,  2.695805703911492e-16, -4.152755501094640e-18,
  7.350574037297160e-20, -8.547439558931483e-22,  3.753889028735524e-07, -1.514997447140806e-07,  3.292441106192790e-08, -4.905747184657470e-09,  5.573081450051512e-10,
 -5.123535624541358e-11,  3.959731756875089e-12, -2.641512869253144e-13,  1.550775243441032e-14, -8.131963230624157e-16,  3.853714376856234e-17, -1.663756538123821e-18,
  3.333762577103068e-06, -9.535162843895592e-07,  1.534782381480636e-07, -1.768237148078452e-08,  1.609686206058616e-09, -1.221206011336039e-10,  7.981689432186345e-12,
 -4.596869634863277e-13,  2.371276396731104e-14, -1.109225620287606e-15,  4.750909659482919e-17, -1.875388331840888e-18,  5.061747420874176e-05, -9.240114641068238e-06,
  1.034951530907931e-06, -8.717089716705159e-08,  6.024980760670210e-09, -3.576535310303271e-10,  1.875632921864447e-11, -8.855968219504717e-13,  3.816190382136068e-14,
 -1.516180552354385e-15,  5.597915086666666e-17, -1.930904949813300e-18,  5.741487303888091e-04, -6.633187842115556e-05,  5.266510095765762e-06, -3.282541623312763e-07,
  1.735121942862510e-08, -8.078313941012037e-10,  3.393269693941129e-11, -1.306318237807136e-12,  4.662428088552548e-14, -1.555998059027547e-15,  4.887229517767596e-17,
 -1.451230222895160e-18,  3.866126397014832e-03, -2.836147125215333e-04,  1.624419896257459e-05, -7.590593144338024e-07,  3.096666921218499e-08, -1.137512997078614e-09,
  3.840933106330492e-11, -1.206636841011634e-12,  3.563021738664442e-14, -9.960301333340227e-16,  2.648261714174305e-17, -6.727986434931043e-19,  1.444167363903929e-02,
 -6.764954880757332e-04,  2.775214998303361e-05, -9.726526413542832e-07,  3.055830507033941e-08, -8.825064718113335e-10,  2.385863196205740e-11, -6.081428596371987e-13,
  1.476742065174511e-14, -3.437610186112825e-16,  7.666682122673178e-18, -1.653601398281980e-19,  2.806818065056214e-02, -8.658150048949763e-04,  2.426623704982599e-05,
 -6.214271145977282e-07,  1.472624511538531e-08, -3.283517780142540e-10,  6.958271965934041e-12, -1.415217577227234e-13,  2.777039440536906e-15, -5.266086671357957e-17,
  9.725124740831974e-19, -1.749713053932895e-20,  2.232478404684994e-02, -5.062403837560513e-04,  9.323483110441895e-06, -1.607719202574900e-07,  2.659953630600402e-09,
 -4.360525697862412e-11,  6.608585894248301e-13, -1.076204767492852e-14,  1.652597475600068e-16, -1.829383287146156e-18,  4.485647463092070e-20, -5.474172828286882e-22,
  6.547596350821954e-08, -2.565781693518653e-08,  5.436722152189840e-09, -7.933638915842586e-10,  8.858605174581576e-11, -8.027145897544570e-12,  6.128318372568071e-13,
 -4.045593234180304e-14,  2.353723470553460e-15, -1.224586165491705e-16,  5.763456294024904e-18, -2.473214166503237e-19,  1.069477576736469e-06, -2.713930801521066e-07,
  3.987016375123894e-08, -4.261724999722778e-09,  3.643028573192065e-10, -2.619169617890831e-11,  1.634165954476731e-12, -9.038252802312772e-14,  4.499756410681572e-15,
 -2.040051571752736e-16,  8.499166073641734e-18, -3.273698781337460e-19,  2.534706404979275e-05, -3.924269707076970e-06,  3.922592874723505e-07, -3.000710288506934e-08,
  1.909423681211639e-09, -1.053677416792685e-10,  5.177607923345494e-12, -2.305527408096212e-13,  9.421358943755182e-15, -3.566775327386741e-16,  1.260154744791584e-17,
 -4.175371007620691e-19,  3.734812538431810e-04, -3.622827023241872e-05,  2.575442813322868e-06, -1.455936946463015e-07,  7.068126528149938e-09, -3.046035785078590e-10,
  1.192870240604429e-11, -4.304846302237379e-13,  1.446956417689568e-14, -4.568034930285982e-16,  1.362113103425513e-17, -3.853180380606007e-19,  2.943847916947048e-03,
 -1.831255480999700e-04,  9.493162793328887e-06, -4.050405679898072e-07,  1.524590430483309e-08, -5.193176227278432e-10,  1.637486302010649e-11, -4.822427389862962e-13,
  1.338392567780194e-14, -3.536216893405159e-16,  8.899352430430007e-18, -2.145621068955317e-19,  1.211599401887106e-02, -4.940183290245729e-04,  1.851845146724686e-05,
 -5.987660919164234e-07,  1.748913865937494e-08, -4.704604429398231e-10,  1.193789762138353e-11, -2.861732982391122e-13,  6.522596875461315e-15, -1.443623103528422e-16,
  3.043214980585712e-18, -6.199443420247442e-20,  2.495101571774291e-02, -6.979542412999824e-04,  1.803222026770771e-05, -4.304565796043473e-07,  9.553557366589677e-09,
 -2.003790999496305e-10,  4.000702145307999e-12, -7.676298931036565e-14,  1.429192011243936e-15, -2.564037402028337e-17,  4.490912559918151e-19, -7.684478795102133e-21,
  2.043772009459038e-02, -4.387072122070170e-04,  7.623332078603613e-06, -1.244201142568178e-07,  1.924917700078296e-09, -3.081276091084826e-11,  4.258518844950306e-13,
 -6.228616252695343e-15,  1.258211894664454e-16, -5.282410473779794e-19,  1.953072575241025e-20, -6.334913275559350e-22,  1.224861803970430e-08, -4.592489244844529e-09,
  9.388246917359902e-10, -1.331179813648895e-10,  1.452118750035799e-11, -1.290795094476661e-12,  9.697882564132376e-14, -6.315983606691240e-15,  3.632465466470157e-16,
 -1.871202847274022e-17,  8.731136511295155e-19, -3.718647266804050e-20,  3.987009355327375e-07, -8.719791985297434e-08,  1.152057066301211e-08, -1.128702474647828e-09,
  8.970770670597990e-11, -6.059699125706325e-12,  3.582102615018125e-13, -1.889924908783081e-14,  9.026933968235727e-16, -3.945336731927639e-17,  1.591148912727077e-18,
 -5.954534349603035e-20,  1.421207179396577e-05, -1.832314786051478e-06,  1.630105792586836e-07, -1.126921544330627e-08,  6.578161060032386e-10, -3.361178095791068e-11,
  1.541759179537755e-12, -6.451236815000802e-14,  2.490761262913709e-15, -8.953687891313305e-17,  3.016526707747638e-18, -9.568280161658536e-20,  2.609202389923849e-04,
 -2.106973407048975e-05,  1.346914540854490e-06, -6.900536406790597e-08,  3.079980703311373e-09, -1.227556595158573e-10,  4.478649395678948e-12, -1.514910420865785e-13,
  4.786927944167618e-15, -1.428243054954571e-16,  4.038087590040850e-18, -1.086240841402338e-19,  2.337417593963349e-03, -1.231456568070220e-04,  5.811966376941500e-06,
 -2.266940413911231e-07,  7.903665097275325e-09, -2.496550863250665e-10,  7.354670920597244e-12, -2.039145232319840e-13,  5.300490976306703e-15, -1.326182098652504e-16,
  3.166292096068937e-18, -7.217259107680010e-20,  1.039659546655411e-02, -3.704803992998804e-04,  1.274559566769295e-05, -3.810007455095568e-07,  1.040018427056907e-08,
 -2.605966522577461e-10,  6.206938361413798e-12, -1.415538485445139e-13,  2.991120913151641e-15, -6.330863781318903e-17,  1.281369328118584e-18, -2.406431980535401e-20,
  2.241830526378257e-02, -5.720337947153932e-04,  1.366673703782833e-05, -3.050910317954527e-07,  6.355538816419640e-09, -1.257301824063620e-10,  2.374210844511723e-12,
 -4.289748927167103e-14,  7.620436838398864e-16, -1.295266803502294e-17,  2.152866244222396e-19, -3.520897202242303e-21,  1.879609027450231e-02, -3.832126328220735e-04,
  6.296402463564844e-06, -9.804745609378797e-08,  1.399032346761889e-09, -2.224374419282178e-11,  3.057048572622867e-13, -2.413244608680506e-15,  1.136974942091795e-16,
 -3.562709965075012e-19, -1.255674029210166e-20, -8.667599818657963e-22,  2.531833599805876e-09, -8.866037132894773e-10,  1.721646374688373e-10, -2.345295223672179e-11,
  2.478238447988463e-12, -2.146832710905309e-13,  1.579070871658991e-14, -1.010372290840018e-15,  5.724826891077194e-17, -2.911814981191064e-18,  1.343918719532693e-19,
 -5.670110492397710e-21,  1.737229712732745e-07, -3.168881263013812e-08,  3.721962841944299e-09, -3.303422153696022e-10,  2.418935046211701e-11, -1.522536942069265e-12,
  8.464096824518535e-14, -4.231545786976632e-15,  1.927171698847800e-16, -8.074873933623230e-18,  3.136470845601306e-19, -1.135104511029471e-20,  8.833153608865670e-06,
 -9.307569416986996e-07,  7.390158445663186e-08, -4.595039281634502e-09,  2.456823339900196e-10, -1.159164690984094e-11,  4.947338534248926e-13, -1.940775728558842e-14,
  7.056677877739553e-16, -2.401635086712425e-17,  7.693568144311718e-19, -2.328656026361352e-20,  1.939245955356288e-04, -1.292364352902059e-05,  7.491227655807694e-07,
 -3.470867995688905e-08,  1.428881778926840e-09, -5.269035120186040e-11,  1.786278658632088e-12, -5.682555613755664e-14,  1.683756512736452e-15, -4.741606063171079e-17,
  1.273425447975878e-18, -3.242096363707275e-20,  1.923200582045900e-03, -8.570702015656546e-05,  3.712101354906123e-06, -1.322351478561698e-07,  4.296293041195912e-09,
 -1.261613031838518e-10,  3.445936490255109e-12, -9.132152723863095e-14,  2.207902597178993e-15, -5.193709788518389e-17,  1.203535869453061e-18, -2.518687186982847e-20,
  9.093177703423636e-03, -2.843243255187320e-04,  9.022962523017355e-06, -2.493762757393962e-07,  6.404976003262500e-09, -1.501733072444412e-10,  3.301076097486675e-12,
 -7.413896421730807e-14,  1.430410118485150e-15, -2.784035178337332e-17,  6.002683018971698e-19, -9.008900992710740e-21,  2.032786260727331e-02, -4.757884006397275e-04,
  1.054181565344654e-05, -2.207870663535507e-07,  4.326061455055369e-09, -8.078530946283255e-11,  1.454670632442076e-12, -2.457397788899547e-14,  4.193244073653443e-16,
 -6.816941446413202e-18,  1.037444690326565e-19, -1.821195106562789e-21,  1.735702638629539e-02, -3.371984594606208e-04,  5.240705124923499e-06, -7.883907740579912e-08,
  1.024108816209555e-09, -1.532388251127947e-11,  2.859725819404017e-13,  8.385433052222294e-16,  8.108309565033291e-17, -1.803690507859800e-18, -6.572782817971995e-20,
 -1.664676098054759e-21,  6.033416333792012e-10, -1.895260448324620e-10,  3.421309932817048e-11, -4.407162298392545e-12,  4.458889757062509e-13, -3.730572829276756e-14,
  2.667473863701467e-15, -1.667462565126565e-16,  9.265895107061239e-18, -4.636237103307536e-19,  2.110144671415337e-20, -8.797107896602144e-22,  8.835921722002358e-08,
 -1.294608317388817e-08,  1.346698311893129e-09, -1.070420232683974e-10,  7.168752751841916e-12, -4.174333946677566e-13,  2.166955898170890e-14, -1.020325393845819e-15,
  4.404174126202834e-17, -1.759347666135716e-18,  6.548405416390806e-20, -2.280647995117436e-21,  6.018788554293040e-06, -5.074694070841931e-07,  3.637280659847093e-08,
 -2.020986580802982e-09,  9.900542508700179e-11, -4.314779704617260e-12,  1.704957807746299e-13, -6.272808888451812e-15,  2.142461732830336e-16, -6.876960830724695e-18,
  2.095146439277130e-19, -6.020990326636502e-21,  1.520374715838437e-04, -8.275280040634200e-06,  4.413083845618026e-07, -1.839638502491461e-08,  7.007630961875513e-10,
 -2.410879941710345e-11,  7.495875407127933e-13, -2.266179908332011e-14,  6.314730211407504e-16, -1.648982032713744e-17,  4.311685143994245e-19, -1.018805326716212e-20,
  1.631145328139285e-03, -6.135527669278744e-05,  2.466940789840625e-06, -7.993174875527083e-08,  2.427963469005632e-09, -6.760072204991371e-11,  1.652642361672637e-12,
 -4.306920603452463e-14,  9.954518182461677e-16, -1.989688298472972e-17,  5.137351668223901e-19, -9.154302552044794e-21,  8.083485131714150e-03, -2.225719925659254e-04,
  6.558426928862441e-06, -1.672428988636003e-07,  4.048972195712898e-09, -9.146268107848304e-11,  1.744600754813078e-12, -4.040061000665920e-14,  7.858058022670418e-16,
 -9.573380434872267e-18,  3.513093167702373e-19, -3.843992870978871e-21,  1.857811178100187e-02, -4.009864955620600e-04,  8.259919607369399e-06, -1.628081585939188e-07,
  3.010709097108752e-09, -5.281552802395423e-11,  9.224367054669356e-13, -1.442380634562179e-14,  2.313947547727787e-16, -4.048986692553275e-18,  3.911570436206900e-20,
 -1.179694578713627e-21,  1.608645773116710e-02, -2.987993483632630e-04,  4.384077245679877e-06, -6.451996785964975e-08,  7.893487917833106e-10, -7.967543615250036e-12,
  3.315012115274720e-13,  1.731052784231923e-15, -5.046943416029402e-17, -6.025954081219924e-18, -1.404456432353945e-19, -7.648531040989379e-22,  1.752963384821293e-10,
 -4.616668557529498e-11,  7.553258943115526e-12, -9.004055541160781e-13,  8.591868647830084e-14, -6.860957680684366e-15,  4.724553798503549e-16, -2.864034466346640e-17,
  1.551452649927713e-18, -7.599227159158665e-20,  3.397149752248498e-21, -1.394769925037394e-22,  5.208691476801101e-08, -5.850265460834827e-09,  5.454383250079637e-10,
 -3.832659487291926e-11,  2.334373614495129e-12, -1.252947520480530e-13,  6.025306414052493e-15, -2.660375048903219e-16,  1.082827979176888e-17, -4.097570562491980e-19,
  1.456508557173692e-20, -4.854977371257074e-22,  4.448167349978571e-06, -2.919274121955688e-07,  1.936287876672044e-08, -9.531659601506403e-10,  4.261086824533468e-11,
 -1.737418224359123e-12,  6.271917449297402e-14, -2.166220611145043e-15,  7.018768016369400e-17, -2.081019617603351e-18,  6.104960003863893e-20, -1.674421278751819e-21,
  1.248268066094153e-04, -5.468452240841209e-06,  2.745756269313336e-07, -1.024478740585076e-08,  3.569372510718607e-10, -1.189772586777180e-11,  3.281920425715618e-13,
 -9.337244468413658e-15,  2.642786997423433e-16, -5.712602010992293e-18,  1.522603600620948e-19, -3.935986147425481e-21,  1.419932765246975e-03, -4.488661834373321e-05,
  1.702228205225916e-06, -5.009788696061530e-08,  1.391156036986778e-09, -3.934662166074358e-11,  8.091984692616478e-13, -1.940031361243599e-14,  5.656112602359396e-16,
 -6.091926942558048e-18,  1.857843476050257e-19, -7.806422663509237e-21,  7.286809569912464e-03, -1.771568721685052e-04,  4.886282351545583e-06, -1.151551007789133e-07,
  2.560452924956130e-09, -6.055573847166065e-11,  9.308356487808269e-13, -1.843386616718053e-14,  6.450414900691866e-16, -3.671339308841957e-20,  6.953157557752520e-20,
 -1.145218638770371e-20,  1.709501044148407e-02, -3.419761084675523e-04,  6.563945362696783e-06, -1.220083382375976e-07,  2.146854867951129e-09, -3.481287024433960e-11,
  6.019568895004702e-13, -9.136027493348707e-15,  1.037080297465480e-16, -3.228048246660609e-18,  1.323147718938046e-20,  4.262383768981914e-22,  1.495679280898286e-02,
 -2.666182297784670e-04,  3.681787553985877e-06, -5.272266568593305e-08,  7.115508180878448e-10,  1.491691974881038e-13,  3.172956244665780e-13, -4.364116027038537e-15,
 -3.536836258701888e-16, -9.535084167202193e-18,  6.712148861657933e-20,  1.318676747165055e-20,  6.606864966071210e-11, -1.304957204967863e-11,  1.906264836122861e-12,
 -2.041759667154897e-13,  1.805130097214314e-14, -1.356773657860294e-15,  8.885886833204973e-17, -5.176193784589403e-18,  2.712522888174155e-19, -1.291933535232815e-20,
  5.644969327743174e-22, -2.272574450556282e-23,  3.519713775052438e-08, -2.841105179309984e-09,  2.468366316674569e-10, -1.513696238325348e-11,  8.275854024068451e-13,
 -4.136954334093310e-14,  1.820525237405143e-15, -7.477746662324608e-17,  2.892767460240243e-18, -1.020335255490807e-19,  3.445637162221082e-21, -1.115450382820875e-22,
  3.531267413495530e-06, -1.733821920346118e-07,  1.108675696838502e-08, -4.843950789657939e-10,  1.907153742874682e-11, -7.615984411224669e-13,  2.491638683808154e-14,
 -7.630873679563155e-16,  2.566036709766898e-17, -6.782892824305214e-19,  1.681808724417277e-20, -5.771401106118647e-22,  1.066838635411847e-04, -3.682193040802028e-06,
  1.792318495908988e-07, -6.083245936502306e-09,  1.808322987508817e-10, -6.358565212290780e-12,  1.608086610975632e-13, -3.302556042962547e-15,  1.310700533201796e-16,
 -2.620747389158021e-18,  1.048664342333379e-20, -2.653484476155828e-21,  1.264277543412850e-03, -3.334882352441932e-05,  1.211632847711241e-06, -3.322978355386207e-08,
  7.642701486364129e-10, -2.456868024686808e-11,  4.923317388791924e-13, -4.131476134843284e-15,  3.847298641534420e-16, -6.837746031616690e-18, -2.406078940863937e-19,
 -9.366995891912671e-21,  6.648481745684965e-03, -1.429824745928458e-04,  3.713811128109216e-06, -8.279653974000636e-08,  1.542958197868571e-09, -4.208789513948074e-11,
  7.004123136133021e-13,  1.504202888669680e-15,  5.383224534409443e-16, -1.075985572690977e-17, -6.394228951990526e-19, -1.439751215414120e-20,  1.582361705177543e-02,
 -2.947852260945951e-04,  5.285285236335388e-06, -9.252532045244917e-08,  1.575848622125201e-09, -2.316226020215285e-11,  3.763913326662277e-13, -7.473777425160144e-15,
  1.143083077056533e-17, -1.224111356149540e-18,  1.141426336034752e-19,  3.867037946823871e-21,  1.394549811108211e-02, -2.394984731530078e-04,  3.118686250372074e-06,
 -4.096839902549155e-08,  7.730098376122544e-10,  4.755286101696186e-12, -2.891604485227461e-15, -1.916412058902575e-14, -4.566304426506624e-16,  1.003293772092521e-17,
  9.687454458061878e-19,  1.875442391478664e-20,  3.378330147129985e-11, -4.187717632342158e-12,  5.672644694568889e-13, -5.248333587043336e-14,  4.190559291810176e-15,
 -2.943230468659225e-16,  1.801635787616236e-17, -9.943361567298170e-19,  5.019468297754107e-20, -2.301094921862561e-21,  9.725112629869554e-23, -3.844717194921505e-24,
  2.688246249217294e-08, -1.418238149673587e-09,  1.234561368849798e-10, -6.700173053553546e-12,  3.100053256237743e-13, -1.498035290235141e-14,  6.156003501855250e-16,
 -2.179195435133747e-17,  8.379050723871689e-19, -2.917303697970780e-20,  7.912358058360954e-22, -2.690694102768501e-23,  2.984338918189709e-06, -1.037283550201335e-07,
  6.691089533295986e-09, -2.744625239509710e-10,  8.486037305886018e-12, -3.462013698384180e-13,  1.205634324946973e-14, -2.436646301170317e-16,  8.570110760713700e-18,
 -3.661697816151612e-19,  2.566551631788118e-21, -4.674721972839726e-23,  9.441873379765403e-05, -2.499575676005159e-06,  1.200075678130032e-07, -4.021646002132113e-09,
  8.683910588431883e-11, -3.223954133063311e-12,  1.123628735905087e-13, -7.146728388854598e-16,  2.444374071517284e-17, -3.519796490689011e-18, -1.719811189189847e-20,
  2.519947440373156e-21,  1.147992277929756e-03, -2.507618832828931e-05,  8.720545299593777e-07, -2.430844184132946e-08,  3.876194051747471e-10, -1.305822943877616e-11,
  4.955659363888944e-13,  1.895767675583399e-15, -8.165972036242246e-17, -1.830898377542007e-17, -9.799646321462309e-20,  2.174739677710336e-20,  6.130196145613300e-03,
 -1.168843829449263e-04,  2.843666782359734e-06, -6.388707299404808e-08,  8.805461135790197e-10, -2.337855714515610e-11,  8.865541558904288e-13,  7.095255435949268e-15,
 -3.425170453941993e-16, -3.470784622104924e-17, -7.341854575175986e-20,  4.901132395942644e-20,  1.472257108444158e-02, -2.565478975182093e-04,  4.312372630661530e-06,
 -7.059744658442140e-08,  1.186167383696397e-09, -1.660030110770790e-11,  1.736425991057713e-13, -6.645932900410693e-15,  8.152173542959833e-17,  5.422284524707323e-18,
  1.427458271598602e-19, -6.440092187186308e-21,  1.303459471401649e-02, -2.162990069974341e-04,  2.703845705008753e-06, -2.804820810346590e-08,  8.178940734750185e-10,
 -2.780461251353745e-12, -6.318142938777013e-13, -1.991321311525763e-14,  6.372605334377407e-16,  4.568365937092698e-17,  1.460375688778470e-19, -6.860759956069132e-20,
  2.328681209592112e-11, -1.360187306706402e-12,  2.018935295961615e-13, -1.600302354928452e-14,  1.062659172017760e-15, -7.066004512316869e-17,  4.102533533204728e-18,
 -2.033843776224437e-19,  9.733848461208396e-21, -4.483332293946278e-22,  1.770528853754377e-23, -6.374790896689762e-25,  2.277014958806817e-08, -6.862769112746381e-10,
  6.506870787756074e-11, -3.497800197531273e-12,  1.209079855817948e-13, -5.294482382319125e-15,  2.564958404726352e-16, -7.302456503976891e-18,  1.740424402801243e-19,
 -1.045237496215659e-20,  3.503669886401942e-22,  7.938134002845330e-25,  2.658305340206856e-06, -6.149949421379833e-08,  4.029310380214197e-09, -1.802673109663618e-10,
  4.014214754783299e-12, -1.191034254352352e-13,  7.261785124325167e-15, -1.540764065929894e-16, -1.717494540250215e-18, -1.455143738676431e-19,  1.078616339657736e-20,
  2.301678179036288e-22,  8.606295206062095e-05, -1.712914894279773e-06,  7.841316035192762e-08, -3.008233708861113e-09,  4.767272905701371e-11, -7.932472684195227e-13,
  8.513315591400275e-14, -1.764605814047096e-15, -7.219234878228705e-17, -4.847106572347834e-19,  1.738552393640984e-19,  2.719505984401049e-21,  1.059920973716193e-03,
 -1.917673358931121e-05,  6.110593201614580e-07, -1.954452199402060e-08,  2.456609890336434e-10, -1.402548485937974e-12,  4.210000521788717e-13, -9.660324389780353e-15,
 -5.151632847082970e-16,  2.532756320150890e-18,  1.061793148923733e-18,  9.287891753786211e-21,  5.703602848635215e-03, -9.698994873913617e-05,  2.149969306698521e-06,
 -5.235162235804859e-08,  6.308485270447315e-10, -2.011046592479255e-12,  7.680690190271615e-13, -1.952524363321678e-14, -1.040486777340530e-15,  1.142961622019580e-17,
  2.080090801430855e-18,  6.295773659982255e-21,  1.376043577781228e-02, -2.251390015062170e-04,  3.568698040570976e-06, -5.410380683498576e-08,  8.831323335606651e-10,
 -1.417133505524997e-11,  5.643789941705490e-14, -6.883805474339950e-16,  2.647547134975838e-16,  8.694706227406513e-19, -4.068312934645507e-19, -9.848406282021619e-21,
  1.221082943908552e-02, -1.958023747399193e-04,  2.440903771237395e-06, -1.636023032545326e-08,  5.834558447849520e-10, -2.093771819172737e-11, -6.880087099797408e-13,
  2.107105597727802e-14,  1.541893060204443e-15, -1.712377295500574e-17, -2.871455056625831e-18, -9.491909544946875e-21,  2.016107616823152e-11, -3.043693600075313e-13,
  7.846338125083561e-14, -6.411039928589687e-15,  3.057382222068403e-16, -1.641861359236829e-17,  1.078044472159865e-18, -5.279826926789484e-20,  1.818774602427348e-21,
 -7.525645904028077e-23,  4.246222433841974e-24, -1.536415406982876e-25,  2.083848351431231e-08, -3.069209497490261e-10,  3.212087936309502e-11, -2.137607270624880e-12,
  6.214908727839722e-14, -1.212683483868080e-15,  9.290732745908534e-17, -5.039315822391530e-18,  4.581854477255513e-20,  2.314073752906558e-21,  1.813163603345089e-22,
 -1.187096668184359e-23,  2.464446727413949e-06, -3.695334581810050e-08,  2.199184396918498e-09, -1.272359551588028e-10,  2.984654150587663e-12, -4.404858506404907e-15,
  2.035969440418481e-15, -2.030195089036195e-16,  1.159735490061045e-18,  2.492334457235323e-19,  2.439222844828535e-21, -5.742851362049313e-22,  8.025477898618988e-05,
 -1.217624033137125e-06,  4.667032339301673e-08, -2.282591190283111e-09,  4.700018474855783e-11,  4.290487389895779e-13,  1.044795411345221e-14, -3.031382168834503e-15,
  2.550157006474284e-17,  4.597707980418462e-18, -1.525039574008804e-20, -9.112932583807993e-21,  9.916009166542894e-04, -1.515872163177781e-05,  4.006372854776218e-07,
 -1.541092899592348e-08,  2.885175529432236e-10,  3.960954411481366e-12, -1.120167716261856e-14, -1.725330202348684e-14,  2.031945492884132e-16,  2.790634875598101e-17,
 -2.876292749547288e-19, -5.199500547748132e-20,  5.346308838417765e-03, -8.212919527386432e-05,  1.583579018819295e-06, -4.182158524066652e-08,  7.148192746416800e-10,
  7.011141562995627e-12, -8.020597841433673e-14, -3.264142524847113e-14,  4.873905618653672e-16,  5.301281458516569e-17, -8.197745173519576e-19, -9.518584351908992e-20,
  1.291317841775365e-02, -1.989672151441942e-04,  2.995140339059643e-06, -4.215765819418173e-08,  6.163177592176809e-10, -1.218319767162824e-11,  1.363936021891350e-13,
  4.960646402503627e-15,  1.411075087985988e-18, -1.265680177302724e-17,  3.409702303863756e-21,  2.398243951247272e-20,  1.146560741133909e-02, -1.769380348159366e-04,
  2.284626309992057e-06, -1.098594310395795e-08,  7.104350654010800e-11, -2.609862434891154e-11,  3.580420548752631e-13,  4.174340330180648e-14, -6.191195832770073e-16,
 -7.465556769194708e-17,  1.140589313108667e-18,  1.325250969665495e-19,  1.980521128761502e-11,  8.084776812125970e-14,  2.345928662655319e-14, -3.147705677585166e-15,
  1.430160494381186e-16, -3.338132141844233e-18,  1.723140102826571e-19, -1.674165336016248e-20,  7.941663423447679e-22, -1.122148296432614e-23, -1.491591147361533e-25,
 -3.145936961262534e-26,  1.998443123761472e-08, -1.369324034345746e-10,  1.190680986214072e-11, -1.259827672975774e-12,  5.004336956283370e-14, -4.099908312255281e-16,
 -1.134603046624790e-17, -1.894922514042617e-18,  1.333886744211962e-19, -1.820738375389381e-22, -2.030071669924184e-22,  8.164060961139165e-25,  2.343298458565773e-06,
 -2.465374349239812e-08,  9.597001349291350e-10, -7.928537878550869e-11,  2.980208805377866e-12, -1.177794099172412e-14, -1.917046554291100e-15, -4.896175047084179e-17,
  6.595027429850627e-18, -4.145345773602116e-20, -1.085173127219258e-20,  1.828392870223746e-22,  7.597639115602487e-05, -9.404313574015283e-07,  2.404761350954696e-08,
 -1.473740451829441e-09,  5.226675629111082e-11, -1.151836301440423e-13, -4.291944217140956e-14, -3.380562903994952e-16,  1.057728455750549e-16, -1.210451035413666e-18,
 -1.683519212711638e-19,  4.198624703828486e-21,  9.363227176550034e-04, -1.260967043213535e-05,  2.455766614688996e-07, -1.031619832134196e-08,  3.330557863948083e-10,
 -6.151977121105518e-13, -2.892580115510948e-13, -3.541436466371145e-16,  6.156900549674140e-16, -9.448585264727168e-18, -9.344710884376532e-19,  2.891398668137860e-20,
  5.040236917696774e-03, -7.126493708829328e-05,  1.153900669951110e-06, -2.962731859013389e-08,  7.769867078546774e-10, -2.745598263985667e-12, -5.707633148061987e-13,
  1.237536267058942e-15,  1.158374730637892e-15, -2.143433664369817e-17, -1.667284334329338e-18,  6.028292899552947e-20,  1.216224179275049e-02, -1.768791673388334e-04,
  2.541068397841253e-06, -3.402571196012364e-08,  4.150360235098467e-10, -7.610907942368621e-12,  2.183608040291464e-13, -4.738559619279498e-16, -2.471025333537737e-16,
  2.056751721666641e-18,  4.585607940591648e-19, -9.986766445744040e-21,  1.079355526036623e-02, -1.592039486761093e-04,  2.144831776968267e-06, -1.322783766307984e-08,
 -2.905298359740454e-10, -7.658584019197218e-12,  9.594823633465580e-13, -3.996125088645151e-15, -1.581517817603396e-15,  2.923287348431226e-17,  2.334947706041701e-18,
 -8.377287358999603e-20,  2.031405596444974e-11,  1.521183703786414e-13, -2.381827321288129e-15, -1.282011936006649e-15,  9.264794492054486e-17, -2.397834029118297e-18,
 -1.497507516211657e-20,  3.701374700292851e-22,  2.392472394307550e-22, -1.599520121623859e-23,  2.498399426620471e-25,  1.681893215896837e-26,  1.954966826476320e-08,
 -8.931329758733941e-11,  1.244940975466988e-12, -5.494627111758958e-13,  3.710897170373748e-14, -8.911185643287835e-16, -1.488238801314444e-17,  1.064976291877213e-18,
  3.057333565188802e-20, -3.626228554126362e-21,  5.729534765141486e-23,  4.869548606422073e-24,  2.255112426977052e-06, -2.000607810548972e-08,  2.781745943853426e-10,
 -3.606584378445892e-11,  2.281918888530398e-12, -5.415473680888052e-14, -1.007824546544531e-15,  8.082789394827132e-17,  6.873144776437160e-19, -1.815479524565132e-19,
  3.846132780802218e-21,  2.133252767409471e-22,  7.250681518592449e-05, -8.051031022972656e-07,  1.112891787232782e-08, -7.090878610112115e-10,  4.056919751914321e-11,
 -9.514827947727970e-13, -1.805411387249546e-14,  1.535757512621251e-15,  1.970893981998713e-18, -2.849293397653126e-18,  7.267939082036788e-20,  2.895743555694998e-21,
  8.891529547152858e-04, -1.105290341912531e-05,  1.522021782343999e-07, -5.432229982539095e-09,  2.599946468075456e-10, -5.948742212430985e-12, -1.085570270537318e-13,
  9.714903778943032e-15, -2.310010017942330e-17, -1.619525756997798e-17,  4.649534631498727e-19,  1.445695688685929e-20,  4.771675059448944e-03, -6.325318933771147e-05,
  8.689272861163511e-07, -1.830446757696602e-08,  6.053109525508542e-10, -1.286717535433443e-11, -1.907753092956479e-13,  1.899619254553723e-14, -8.962697575731685e-17,
 -2.971426522609719e-17,  9.312533129076598e-19,  2.337107344055651e-20,  1.149294261782929e-02, -1.580807645981350e-04,  2.168455445630693e-06, -2.833682977792196e-08,
  3.101910947795104e-10, -3.257070996638630e-12,  1.238176540396835e-13, -4.885236843020078e-15,  1.685062612042679e-18,  7.269253757775353e-18, -1.742865341623212e-19,
 -8.194138597388168e-21,  1.018993412716343e-02, -1.427633155349634e-04,  1.956890366443071e-06, -1.797426459131889e-08, -2.462202555088724e-10,  9.721936652472079e-12,
  3.782353442058159e-13, -2.796993717003827e-14,  1.431341269283847e-16,  4.119555367837660e-17, -1.291895517857434e-18, -3.283903168490711e-20,  2.081767098746615e-11,
  9.301552868477811e-14, -1.048360898269873e-14, -1.896714675857274e-16,  4.448104745653558e-17, -2.207198429254068e-18,  3.490627264532308e-20,  1.535129155363352e-21,
 -7.644845342369887e-23, -1.644308575239865e-24,  2.657835906610508e-25, -9.442129773863152e-27,  1.918294563707190e-08, -9.706123587081528e-11, -2.407606858796458e-12,
 -1.069084302766138e-13,  1.827023945401451e-14, -8.779210126112625e-16,  1.364376667896486e-17,  6.258956535201387e-19, -3.540036903086792e-20, -3.755412414599116e-23,
  6.651332413507387e-23, -2.487902547877856e-24,  2.177559484036133e-06, -1.897824150741912e-08,  2.651650677609309e-11, -8.784444488005431e-12,  1.132278862505191e-12,
 -5.340378629609430e-14,  8.508687013069939e-16,  3.672248619590246e-17, -2.233990475859497e-18,  1.198376066324786e-20,  3.231382002245350e-21, -1.344265936518382e-22,
  6.942413890338717e-05, -7.406027842419891e-07,  5.848330588257957e-09, -2.219989955588699e-10,  2.040887476527553e-11, -9.330292500632707e-13,  1.510749180302180e-14,
  6.193174697313214e-16, -3.943258474628098e-17,  3.395798638270737e-19,  4.892984945240141e-20, -2.213813433495217e-21,  8.470510140554327e-04, -1.003484292349413e-05,
  1.078270290540787e-07, -2.280193099047635e-09,  1.348012235836342e-10, -5.769032339608852e-12,  9.406308079841056e-14,  3.647026979187355e-15, -2.402463651636648e-16,
  2.534582944357996e-18,  2.697968530095626e-19, -1.299426850596675e-20,  4.531379641529481e-03, -5.703607677698479e-05,  6.985433074300458e-07, -1.076193572407252e-08,
  3.404061918395872e-10, -1.209783354652494e-11,  1.954457639335748e-13,  6.704686701404472e-15, -4.613286481384946e-16,  5.516450432370712e-18,  4.814570373739787e-19,
 -2.442048785145128e-20,  1.089327488470676e-02, -1.420130400403145e-04,  1.856443995809131e-06, -2.377730652324147e-08,  2.645344314873220e-10, -1.737033596480920e-12,
  1.542685059943701e-14, -2.300435937338902e-15,  1.091625931005490e-16, -8.645838439826956e-19, -1.292587098276590e-19,  5.687675511596545e-21,  9.648752528530993e-03,
 -1.280211821906469e-04,  1.724901734534176e-06, -2.010825262693799e-08, -1.735521916558200e-11,  1.090367794766520e-11, -1.946923855910258e-13, -1.035328418690593e-14,
  6.555760902442098e-16, -7.818101324383972e-18, -6.705642099833043e-19,  3.402999577947944e-20,  2.102067398363707e-11,  9.133754891494975e-15, -9.771204186515066e-15,
  2.238965007167855e-16,  1.073971723601359e-17, -1.130803271509671e-18,  4.489197856356313e-20, -5.642852120681720e-22, -3.436578294755470e-23,  2.026981674850612e-24,
 -2.450511263314510e-26, -2.389077217435670e-27,  1.875348134849577e-08, -1.176824288745964e-10, -2.447374339937861e-12,  6.651799565501254e-14,  4.789145382846497e-15,
 -4.562169762699792e-16,  1.757641775031394e-17, -2.167813447632063e-19, -1.288494594399499e-20,  7.622885534629033e-22, -1.138771161369591e-23, -6.409784639842824e-25,
  2.101741477332349e-06, -1.895256423114729e-08, -1.220460212731649e-12,  2.112884105628015e-12,  3.140058138206667e-13, -2.770356638226184e-14,  1.058271154155221e-15,
 -1.350605784060169e-17, -7.313539421727884e-19,  4.468624634693216e-20, -7.567143482340867e-22, -3.014260327162641e-23,  6.654458181270673e-05, -7.001914279026273e-07,
  4.602059559354047e-09, -2.146909176442878e-11,  6.124602465049535e-12, -4.845395268683576e-13,  1.830176981152650e-14, -2.395734852275305e-16, -1.209807956671282e-17,
  7.587721884141536e-19, -1.384060776527013e-20, -4.371249227982479e-22,  8.085049274740817e-04, -9.252867736781647e-06,  9.005607350021555e-08, -9.030648073222489e-10,
  4.632352478628526e-11, -3.021514425049833e-12,  1.112656098409804e-13, -1.481438777288927e-15, -7.052550848616354e-17,  4.517211056604162e-18, -8.641970457619043e-20,
 -2.315166460380100e-21,  4.313702932214934e-03, -5.188823953951716e-05,  5.950292543117646e-07, -6.959140113334078e-09,  1.530498276758317e-10, -6.553438272041270e-12,
  2.219925424025567e-13, -2.986367191760944e-15, -1.301920909194177e-16,  8.547149503327390e-18, -1.696064495075508e-19, -3.973470374738768e-21,  1.035321691733251e-02,
 -1.282334370002524e-04,  1.595386264088347e-06, -1.981798978313771e-08,  2.301038996066256e-10, -1.798056308417394e-12, -9.250293575166980e-15,  1.393042800261359e-16,
  3.730691164852244e-17, -2.023136486865501e-18,  3.535642643649784e-20,  1.187689660945834e-21,  9.162750700353897e-03, -1.151772926845392e-04,  1.488134086454164e-06,
 -1.895575512890880e-08,  1.411997055484226e-10,  4.743713175484261e-12, -2.549610045236212e-13,  3.486481992591218e-15,  1.898279281598193e-16, -1.201378403115434e-17,
  2.373672355055153e-19,  5.542926675556998e-21,  2.092018273855476e-11, -5.673916953620188e-14, -6.628501129082049e-15,  2.665052953673366e-16, -2.773292444921595e-18,
 -3.096911492987637e-19,  2.264692366610174e-20, -7.887820143661950e-22,  1.046705771388651e-23,  4.512400306767441e-25, -3.178734813963263e-26,  8.246323398918766e-28,
  1.824974600219339e-08, -1.333230912251167e-10, -1.423284738367676e-12,  9.045416895754064e-14, -7.558769011231225e-16, -1.323987818314944e-16,  9.060957691758070e-18,
 -3.039860644761297e-19,  3.786480372962593e-21,  1.730259195720696e-22, -1.152788940839519e-23,  2.877786018646439e-25,  2.026147687117533e-06, -1.880941626598544e-08,
  4.003543531492830e-11,  3.924909821605982e-12, -2.495384876188607e-14, -8.245346285934018e-15,  5.451646369621821e-16, -1.812001559179396e-17,  2.283380202303289e-19,
  9.799866423255390e-21, -6.584358509952816e-22,  1.664121664324772e-23,  6.381737710509651e-05, -6.633345474090263e-07,  4.682397794838638e-09,  2.007737989644535e-11,
  1.483274252937985e-13, -1.485993240189656e-13,  9.418395724813794e-15, -3.109334375748331e-16,  3.975871171276554e-18,  1.613256039470123e-19, -1.098735404065569e-20,
  2.819187773782719e-22,  7.728785406878973e-04, -8.566899067621020e-06,  8.209624512740488e-08, -5.172632736059871e-10,  8.461528529494683e-12, -9.798955446281378e-13,
  5.739043632671647e-14, -1.872141697289075e-15,  2.421310665951579e-17,  9.369564250460837e-19, -6.464365070536219e-20,  1.679627571147819e-21,  4.115189354629889e-03,
 -4.742865959001546e-05,  5.227336621935531e-07, -5.303168626077830e-09,  6.707561729970944e-11, -2.466140236898964e-12,  1.161951803761055e-13, -3.643696883744374e-15,
  4.749768227459623e-17,  1.730133891112695e-18, -1.212742957768639e-19,  3.186903622940647e-21,  9.864387856843695e-03, -1.163618197759272e-04,  1.378442372453949e-06,
 -1.643307971869093e-08,  1.926904124138908e-10, -1.894559708510766e-12,  2.641186795214397e-15,  4.816407972460089e-16, -6.361319849404887e-18, -4.665061337240309e-19,
  2.900194333053331e-20, -7.293035600424584e-22,  8.724472286020489e-03, -1.041384402308859e-04,  1.276384737075798e-06, -1.622891941635326e-08,  1.848998339475125e-10,
  1.537517186645546e-13, -1.231700289538081e-13,  4.619811833923699e-15, -6.077725068286546e-17, -2.475589106625658e-18,  1.697989115501709e-19, -4.450565755489150e-21,
  2.060593892122874e-11, -9.804219923651575e-14, -3.824016120159966e-15,  1.954051468080728e-16, -5.087912837212928e-18,  1.460181411384549e-20,  6.339721022238321e-21,
 -3.718001943650672e-22,  1.192886617647927e-23, -1.818093521593576e-25, -3.728534851097294e-27,  3.480196856930241e-28,  1.770008058914768e-08, -1.407108427569208e-10,
 -4.667160048556523e-13,  6.639146139798990e-14, -1.833127801843073e-15, -2.111758281831743e-19,  2.686387906520438e-18, -1.485207066744770e-19,  4.556375771592271e-21,
 -6.353039450904516e-23, -1.579161258895712e-24,  1.290008500471975e-25,  1.951827633281785e-06, -1.831622514472982e-08,  8.117008325069119e-11,  2.762304728011186e-12,
 -9.501765467052855e-14, -2.454940662903738e-16,  1.648484470225353e-16, -8.898703700630947e-18,  2.695327098102433e-19, -3.713875397028830e-21, -9.126755894727045e-23,
  7.356943327161672e-24,  6.124032635865569e-05, -6.250308691685373e-07,  4.871906856873986e-09,  8.298455014707242e-12, -1.180541496540070e-12, -9.743888177904076e-15,
  2.895481573474317e-15, -1.528809794874420e-16,  4.598448044375090e-18, -6.338086603251112e-20, -1.511222360846503e-21,  1.222549705331823e-22,  7.398869711297179e-04,
 -7.933740598677037e-06,  7.625274213457508e-08, -4.798211801553950e-10, -1.077830819230531e-12, -1.272651893007313e-13,  1.812264286036602e-14, -9.221695147144559e-16,
  2.752076355422567e-17, -3.801744829352306e-19, -8.793218466859560e-21,  7.165367359262834e-22,  3.933457275923739e-03, -4.348601991450851e-05,  4.643117561386852e-07,
 -4.504160448567737e-09,  3.840666463370033e-11, -6.994464466058406e-13,  3.963461157178423e-14, -1.809568836252731e-15,  5.286726336921477e-17, -7.310642522641296e-19,
 -1.626354470013779e-20,  1.340008083459146e-21,  9.419816991437390e-03, -1.060734935846754e-04,  1.198515676730961e-06, -1.364567932065962e-08,  1.563650308122323e-10,
 -1.701353712421195e-12,  1.200161417349535e-14,  1.742214344565831e-16, -9.362010242740141e-18,  1.344058053535932e-19,  4.279325021391189e-21, -3.216091592294056e-22,
  8.327177522438663e-03, -9.465666766807240e-05,  1.099078436092464e-06, -1.336717565412775e-08,  1.675479512989153e-10, -1.514348753366737e-12, -2.718414307079275e-14,
  2.205278965024849e-15, -7.010344932512834e-17,  9.786465693617791e-19,  2.311867445595980e-20, -1.872996084203616e-21,  2.016556180794630e-11, -1.205775961571463e-13,
 -1.939161192169647e-15,  1.217555607200455e-16, -3.922159253015549e-18,  7.846761308192394e-20,  2.151935461939378e-22, -1.021112157368734e-22,  5.139307524894932e-24,
 -1.553364628127400e-25,  2.647230056910853e-27,  1.428660170326343e-29,  1.713413259225214e-08, -1.417398712369741e-10,  1.619951678353756e-13,  3.938363336523591e-14,
 -1.454149812974464e-15,  2.850407920211886e-17,  1.877259776625058e-19, -4.337282589467929e-20,  2.060615436179204e-21, -5.929317128248244e-23,  9.207868100334784e-25,
  8.691305903627705e-27,  1.880035734662960e-06, -1.755945054876188e-08,  1.055373212335815e-10,  1.348797893872457e-12, -7.608400497632497e-14,  1.559287648497501e-15,
  1.414018905500666e-17, -2.651904871079121e-18,  1.233420406160773e-19, -3.493200278561195e-21,  5.294869597191662e-23,  5.368056829544594e-25,  5.881833463702471e-05,
 -5.859747882989161e-07,  4.860635369959825e-09, -9.559181411072261e-12, -9.510839779146748e-13,  2.268980228522054e-14,  2.957501052321822e-16, -4.616122229656420e-17,
  2.114159733616132e-18, -5.938588911438474e-20,  8.922807690644301e-22,  9.102405058686701e-24,  7.093350654776325e-04, -7.347120077902696e-06,  7.036391132814454e-08,
 -5.009614160835247e-10, -9.093688304999919e-13,  8.348777374867026e-14,  2.365339479329448e-15, -2.829832337517843e-16,  1.269372585686345e-17, -3.541326775687172e-19,
  5.299345383877224e-21,  5.352274652843623e-23,  3.766613548597830e-03, -3.997807905197431e-05,  4.136151285982268e-07, -3.964006271084615e-09,  3.070187265747294e-11,
 -1.915954671889540e-13,  8.314837165840631e-15, -5.796173888359127e-16,  2.454171816117842e-17, -6.754969751540819e-19,  1.007114237295615e-20,  9.954270503168286e-23,
  9.013718966393943e-03, -9.710030788715024e-05,  1.048709574647508e-06, -1.139929143055045e-08,  1.254599925670301e-10, -1.383524877687020e-12,  1.352453752364498e-14,
 -3.534289639033673e-17, -3.780964942916229e-18,  1.351136543415649e-19, -2.104354970114217e-21, -2.598782547484338e-23,  7.965181321819533e-03, -8.646253640725148e-05,
  9.536900067867520e-07, -1.094726535819634e-08,  1.345791676924959e-10, -1.643534174040348e-12,  9.005643786852501e-15,  5.854856403815675e-16, -3.179803157557665e-17,
  9.154278357625066e-19, -1.375875125737308e-20, -1.416214915707565e-22,  1.966012719143831e-11, -1.311960283716147e-13, -8.039053139678209e-16,  7.113969597123984e-17,
 -2.455973501346813e-18,  6.346683649397546e-20, -1.038093107192382e-21, -7.162540524319986e-24,  1.361571007071938e-24, -6.107565043970945e-26,  1.755707608465568e-27,
 -3.204650530672161e-29,  1.657225697300510e-08, -1.389056931013250e-10,  5.137505485732983e-13,  2.062112012966559e-14, -9.062992316686742e-16,  2.417425380563813e-17,
 -3.729363774498200e-19, -4.413722568611784e-21,  5.829211260790511e-22, -2.467615560723660e-23,  6.741503290564624e-25, -1.127435519485082e-26,  1.811562978138837e-06,
 -1.666871208664177e-08,  1.154550738383249e-10,  3.808157081368399e-13, -4.565261773856266e-14,  1.352392528729972e-15, -2.078261019158003e-17, -3.019088938428755e-19,
  3.567415710181106e-20, -1.478948030708023e-21,  3.968726951991378e-23, -6.449037481565485e-25,  5.655116047288393e-05, -5.477719502601220e-07,  4.669925794296094e-09,
 -2.108523143548075e-11, -4.989543807996002e-13,  2.019956731860541e-14, -3.207718686284463e-16, -5.709327883992144e-18,  6.192963655722869e-19, -2.534081148802654e-20,
  6.737012739162270e-22, -1.080479538181846e-23,  6.810341651570877e-04, -6.808365843053887e-06,  6.432449552801551e-08, -5.010731939143311e-10,  8.789598420638831e-13,
  8.079374790395912e-14, -1.489616806373406e-15, -3.916680250519577e-17,  3.763906270756236e-18, -1.518614313358249e-19,  4.010204146018488e-21, -6.384514475573763e-23,
  3.613029277512804e-03, -3.685132202146410e-05,  3.688912968615757e-07, -3.496770188059735e-09,  2.792461512368301e-11, -1.176703776909640e-13, -9.081422670877637e-18,
 -1.043943007687571e-16,  7.473821290704976e-18, -2.914816491508111e-19,  7.620996792522043e-21, -1.205962243683349e-22,  8.641276287265486e-03, -8.922566302611434e-05,
  9.231048402302992e-07, -9.596190318003288e-09,  1.009014484770236e-10, -1.080590427485915e-12,  1.145246794978809e-14, -9.523736744200311e-17, -4.552268006482111e-19,
  5.348725104972106e-20, -1.616215116710452e-21,  2.666671691838125e-23,  7.633806730189202e-03, -7.932428092416528e-05,  8.342067535058081e-07, -9.041363931561162e-09,
  1.047184932641555e-10, -1.319103883929859e-12,  1.533248001024272e-14, -1.291462708310852e-17, -8.774281628700942e-18,  3.891590867230899e-19, -1.044419101139433e-20,
  1.662885131785847e-22,  1.912706014986103e-11, -1.347929714512806e-13, -1.485204600440218e-16,  4.064374972524298e-17, -1.433646068703026e-18,  3.945728967039949e-20,
 -8.776643492598071e-22,  1.221095225113437e-23,  1.171972157201025e-25, -1.550515264068254e-26,  6.348848621232630e-28, -1.743092068131201e-29,  1.602611775293609e-08,
 -1.340188890246577e-10,  6.885358603426413e-13,  9.488936237439679e-15, -5.143166831051517e-16,  1.519049805578330e-17, -3.372422334697806e-19,  4.303263342815274e-21,
  6.771424481564898e-23, -6.712412592743428e-24,  2.591759359620111e-25, -6.762812619691747e-27,  1.746749302370857e-06, -1.573733702052091e-08,  1.164435597078322e-10,
 -1.614304515970441e-13, -2.378385854080713e-14,  8.415807840030231e-16, -1.938620059494286e-17,  2.407327471733543e-19,  4.529248775672047e-21, -4.121356892225767e-22,
  1.557892520674224e-23, -3.988606714994761e-25,  5.443303429288305e-05, -5.115325034727655e-07,  4.380908430276870e-09, -2.627807058077512e-11, -1.762963843821426e-13,
  1.214253049277710e-14, -3.085008261604880e-16,  3.814815658007973e-18,  8.318294771180558e-20, -7.155645031470628e-21,  2.671743346247567e-22, -6.771893108098367e-24,
  6.547922943833110e-04, -6.317473179715381e-06,  5.844247845787930e-08, -4.762081901725239e-10,  2.100999771236271e-12,  4.141505145036002e-14, -1.532258875579113e-15,
  1.945141029139848e-17,  5.396505393135965e-19, -4.334322953548411e-20,  1.600491911040872e-21, -4.029023135959603e-23,  3.471270978682540e-03, -3.406062338930186e-05,
  3.295313386798647e-07, -3.069428595261561e-09,  2.543763343135261e-11, -1.337840795949403e-13, -8.005684516556801e-16,  1.566586632244382e-17,  1.249054879406649e-18,
 -8.476477956709564e-20,  3.061310304967851e-21, -7.643650897999899e-23,  8.298450699461227e-03, -8.227554627228376e-05,  8.169697741356925e-07, -8.140645016724293e-09,
  8.181983249422497e-11, -8.379881187017157e-13,  8.795383734477563e-15, -8.925064785630885e-17,  5.762452341306057e-19,  1.053567027173235e-20, -6.097985893137854e-22,
  1.670115243990171e-23,  7.329207500014175e-03, -7.305800650753300e-05,  7.349561173952179e-07, -7.557484620909261e-09,  8.186850506742206e-11, -9.767812281628134e-13,
  1.265222906201090e-14, -1.363091962189735e-16, -6.030643713194556e-19,  1.067849440462915e-19, -4.152674884605403e-21,  1.053919292736043e-22,  1.858812076653232e-11,
 -1.343670576739280e-13,  2.242336137489924e-16,  2.299283026107679e-17, -8.269112098105966e-19,  2.254711814119616e-20, -5.396497580040682e-22,  1.068507074872949e-23,
 -1.308403855303096e-25, -1.412465359600482e-27,  1.540215501920181e-28, -5.853073449815032e-30,  1.550160953468613e-08, -1.281745816881876e-10,  7.617474338314190e-13,
  3.293697692914980e-15, -2.811479190988890e-16,  8.623018124138435e-18, -2.113883530627745e-19,  4.115222347179326e-21, -4.516676423296514e-23, -8.117502759913534e-25,
  6.757232423796029e-26, -2.418613189223565e-27,  1.685643143880628e-06, -1.481887937404000e-08,  1.127033616222271e-10, -4.301518564210227e-13, -1.101926697360071e-14,
  4.634168480754700e-16, -1.216190596129657e-17,  2.395619205789902e-19, -2.519739465204195e-21, -5.415034477902669e-23,  4.168304196891688e-24, -1.459759059739254e-25,
  5.245495525986079e-05, -4.777784993863445e-07,  4.055464963395848e-09, -2.751899175593223e-11,  1.937481811091383e-15,  6.144045867504570e-15, -1.913719465519139e-16,
  3.924436186114203e-18, -4.042115337683036e-20, -9.857930032279938e-22,  7.249090474291070e-23, -2.507866639488933e-24,  6.304221641537663e-04, -5.872168894302432e-06,
  5.295109559794173e-08, -4.377583073874424e-10,  2.611002562668471e-12,  1.205194137982091e-14, -9.097948634622407e-16,  2.117242828395971e-17, -2.161477000173623e-19,
 -6.252981994278824e-21,  4.387201418484059e-22, -1.503120572208778e-23,  3.340077202549767e-03, -3.156499538320042e-05,  2.950490680823822e-07, -2.684674436574671e-09,
  2.261933012048510e-11, -1.453362376431084e-13, -1.257475183108288e-16,  2.486488118092504e-17, -2.590145282361136e-19, -1.348925823613324e-20,  8.515056480279165e-22,
 -2.870919705925936e-23,  7.981831170139817e-03, -7.610948732785945e-05,  7.266185929968272e-07, -6.954945703951675e-09,  6.698028707549905e-11, -6.545899247853100e-13,
  6.585182832721605e-15, -6.823856232360508e-17,  6.596826679006142e-19, -2.794510786851902e-21, -1.351994621870862e-22,  5.966519714257772e-24,  7.048190010197279e-03,
 -6.752023258837810e-05,  6.515308853414666e-07, -6.388676082429013e-09,  6.506054289678861e-11, -7.185037282938824e-13,  8.960428389169384e-15, -1.184709546070058e-16,
  1.161274832718774e-18,  1.113982343361342e-20, -1.112977321963915e-21,  3.929562219713545e-23,  1.805571019352284e-11, -1.316642836536303e-13,  4.336225351696791e-16,
  1.275902745796321e-17, -4.837747500243302e-19,  1.269774373401856e-20, -3.006176125462914e-22,  6.479772870528264e-24, -1.166414297973402e-25,  1.297674164854379e-27,
  1.374816627935564e-29, -1.353910143142924e-30,  1.500125677377400e-08, -1.219874790278657e-10,  7.791794128245891e-13, -6.459589773667069e-17, -1.509923292407389e-16,
  4.756416263644999e-18, -1.180578595918970e-19,  2.559444123365996e-21, -4.493484743294824e-23,  4.404562784984151e-25,  8.086482217991723e-27, -6.030310256033806e-28,
  1.628134769079135e-06, -1.394028504745526e-08,  1.067439782046119e-10, -5.460697565977423e-13, -4.177860374206843e-15,  2.420001216359113e-16, -6.706434333392638e-18,
  1.499479208170902e-19, -2.632400674566826e-21,  2.445542242830007e-23,  5.428771117657502e-25, -3.741075828903013e-26,  5.060664848501848e-05, -4.466472727970659e-07,
  3.728764937916116e-09, -2.672002291443400e-11,  8.695333775808282e-14,  2.706281039140176e-15, -1.019705811795925e-16,  2.451094939446294e-18, -4.377446004246580e-20,
  3.945569608667871e-22,  9.879088179270344e-24, -6.522854438874107e-25,  6.077484546873666e-04, -5.468850787051995e-06,  4.795327651618695e-08, -3.950545233709643e-10,
  2.677140229587545e-12, -3.564714114141432e-15, -4.296699113350480e-16,  1.301043389525155e-17, -2.458122049301778e-19,  2.168484433277035e-21,  6.211366981717281e-23,
 -3.949759542652101e-24,  3.218342365411047e-03, -2.932753563741278e-05,  2.649085749958948e-07, -2.345966923824589e-09,  1.973276177871344e-11, -1.412015192983159e-13,
  4.164838935159283e-16,  1.340894163795522e-17, -3.620216219091505e-19,  3.092699906663293e-21,  1.292829529583364e-22, -7.638294434499678e-24,  7.688515017621013e-03,
 -7.061309958254914e-05,  6.491834636884017e-07, -5.980016605359470e-09,  5.532599996205893e-11, -5.172079427861976e-13,  4.949897363432890e-15, -4.937886755669667e-17,
  5.086945660463387e-19, -4.666777243130512e-21,  8.465292254462446e-24,  1.361784586885916e-24,  6.788071667167926e-03, -6.259796698657751e-05,  5.806733264239432e-07,
 -5.452033585194213e-09,  5.259466568611884e-11, -5.389265794536792e-13,  6.178652224265432e-15, -8.079467507383274e-17,  1.075396054818625e-18, -9.563107282202936e-21,
 -1.316631242388875e-22,  1.019326137435091e-23,  1.753679751320386e-11, -1.276974256243145e-13,  5.475507217479282e-16,  6.712935818747870e-18, -2.892621972041728e-19,
  7.283060341482989e-21, -1.641683443253683e-22,  3.517264558228159e-24, -6.955773580571155e-26,  1.156048210881893e-27, -1.202461974396958e-29, -1.112679634623598e-31,
  1.452571924405112e-08, -1.157918748828369e-10,  7.666095336060820e-13, -1.851750201929025e-15, -7.916586057044669e-17,  2.636382950419538e-18, -6.392582861739180e-20,
  1.399687875472684e-21, -2.760740221050203e-23,  4.454220283177912e-25, -4.042203226686414e-27, -6.870396728003836e-29,  1.574038848197324e-06, -1.311336349403183e-08,
  9.992497153033166e-11, -5.816730747311840e-13, -6.527255847250702e-16,  1.228093594478756e-16, -3.539353727462400e-18,  8.161654294804029e-20, -1.633380059707467e-21,
  2.618449353698337e-23, -2.236189103803126e-25, -4.673221769063222e-27,  4.887772676457185e-05, -4.180727085103456e-07,  3.417884911007264e-09, -2.500806180437359e-11,
  1.214090216016235e-13,  9.390092607457376e-16, -5.052328152447013e-17,  1.312334326860013e-18, -2.722612391793530e-20,  4.390903809270807e-22, -3.619251136422172e-24,
 -8.542811055240244e-26,  5.866112967890198e-04, -5.103467514883356e-06,  4.346576224214578e-08, -3.532420188958744e-10,  2.527985493747454e-12, -1.031159295684098e-14,
 -1.618734212070945e-16,  6.620968334340736e-18, -1.519989648773378e-19,  2.520066412661444e-21, -2.023822657837832e-23, -5.360766421833051e-25,  3.105099766097675e-03,
 -2.731571669298482e-05,  2.385601787415400e-07, -2.052186221271338e-09,  1.703285714266349e-11, -1.278840584527316e-13,  6.506403544535033e-16,  4.114365301776159e-18,
 -2.139112233216313e-19,  4.111030087755371e-21, -3.178721755104947e-23, -1.095870265607290e-24,  7.416015332278782e-03, -6.569237042487297e-05,  5.824129025099845e-07,
 -5.171538150571803e-09,  4.606668879040819e-11, -4.133129447527489e-13,  3.770894167758442e-15, -3.564151163981763e-17,  3.560412926378878e-19, -3.667674590545241e-21,
  3.193227371321865e-23,  1.608088311898808e-26,  6.546575395837962e-03, -5.820074261045621e-05,  5.199664758372404e-07, -4.689393717411751e-09,  4.313443995665753e-11,
 -4.142344717862824e-13,  4.343095202351372e-15, -5.226038728015579e-17,  7.105098612691319e-19, -9.386022302321856e-21,  7.677672695718783e-23,  1.237298014933245e-24,
  1.703518075464735e-11, -1.230636493612222e-13,  6.045317582612659e-16,  3.065372923009857e-18, -1.761734090316636e-19,  4.308330816995208e-21, -9.127333010758430e-23,
  1.861621739077811e-24, -3.680522622354729e-26,  6.757898935948651e-28, -1.049669588394185e-29,  1.046177966219095e-31,  1.407465103815771e-08, -1.097658905312519e-10,
  7.382910743111005e-13, -2.768234928344622e-15, -3.906331698827200e-17,  1.486244830066038e-18, -3.493303346742053e-20,  7.387981712078193e-22, -1.476114646220927e-23,
  2.691634174382963e-25, -4.048042793391552e-27,  3.513787653539925e-29,  1.523139948536210e-06, -1.234190142321025e-08,  9.295022715196340e-11, -5.764012798585784e-13,
  1.112048908466731e-15,  6.018484935313156e-17, -1.857782434502224e-18,  4.249708471142614e-20, -8.729915982642150e-22,  1.601915558795770e-23, -2.384976755072277e-25,
  1.942556712748444e-27,  4.725826950785308e-05, -3.918959382246168e-07,  3.129880030332019e-09, -2.297025987872282e-11,  1.305891446927683e-13,  8.243675960980033e-17,
 -2.382329734132389e-17,  6.621433809976179e-19, -1.443350239178467e-20,  2.699758470456452e-22, -4.019598549942440e-24,  3.153160551578343e-26,  5.668669812243199e-04,
 -4.772026190495190e-06,  3.946220585857100e-08, -3.146010332195787e-10,  2.295412710194930e-12, -1.244403374462413e-14, -3.221891852507261e-17,  3.026980711986786e-18,
 -7.851011923521290e-20,  1.548066766514075e-21, -2.336725879661914e-23,  1.784417305993307e-25,  2.999504187490521e-03, -2.550129599234866e-05,  2.154875203437366e-07,
 -1.799246616768136e-09,  1.463720660602684e-11, -1.115333417769128e-13,  6.901675887093911e-16, -6.622746549183087e-19, -9.456456944109352e-20,  2.474997092194068e-21,
 -4.026579564138061e-23,  2.974133655998147e-25,  7.162188319744287e-03, -6.126936878098256e-05,  5.245191139558632e-07, -4.496001576275306e-09,  3.863077731335761e-11,
 -3.336128853288868e-13,  2.914316998309452e-15, -2.612022239645446e-17,  2.461055163207697e-19, -2.483608387652577e-21,  2.568618718367251e-23, -2.136292512894553e-25,
  6.321751272131841e-03, -5.425496427174074e-05,  4.675783515414685e-07, -4.060311870099440e-09,  3.578560247660836e-11, -3.252799165105051e-13,  3.151883782993553e-15,
 -3.428530563021115e-17,  4.331568733913491e-19, -6.029091527583770e-21,  7.821136569483966e-23, -6.041500028728167e-25,  1.655277173969814e-11, -1.181223219857423e-13,
  6.269047806678557e-16,  8.325003720579634e-19, -1.082924754108142e-19,  2.629998297008989e-21, -5.250371731722087e-23,  1.001270775931825e-24, -1.890503123436843e-26,
  3.487512375395089e-28, -5.996726783842926e-30,  8.790818251208999e-32,  1.364717739104619e-08, -1.040010679111605e-10,  7.021726763870966e-13, -3.194824124383529e-15,
 -1.628843001425839e-17,  8.506276403860357e-19, -1.960708061397061e-20,  3.934707830836604e-22, -7.584501890982893e-24,  1.406289813018454e-25, -2.395977902717210e-27,
  3.397189253572645e-29,  1.475216269991593e-06, -1.162558684853751e-08,  8.617302558842827e-11, -5.510474776866052e-13,  1.951982876291731e-15,  2.719187294426594e-17,
 -9.843400165641817e-19,  2.213078036794388e-20, -4.452056754724545e-22,  8.387879236602185e-24, -1.431571397107483e-25,  2.005166355391324e-27,  4.573906818693229e-05,
 -3.679239988861193e-07,  2.866742441709269e-09, -2.089323994680113e-11,  1.277866008396888e-13, -3.110889748756772e-16, -1.049224702155422e-17,  3.277733120776788e-19,
 -7.231396075469038e-21,  1.408503477012983e-22, -2.428915982959889e-24,  3.390693677238527e-26,  5.483872183865686e-04, -4.470824104424125e-06,  3.589907168532918e-08,
 -2.798831799598428e-10,  2.044393871324711e-12, -1.243864739030893e-14,  2.455558826215358e-17,  1.243324388381637e-18, -3.743511728475201e-20,  7.960331410481223e-22,
 -1.414459216507024e-23,  1.986954319279630e-25,  2.900815465579756e-03, -2.385994208352932e-05,  1.952310060937793e-07, -1.582008173200154e-09,  1.256922191876072e-11,
 -9.546185409223147e-14,  6.406078125470409e-16, -2.543773040019896e-18, -3.071835621956834e-20,  1.180942762192175e-21, -2.413849329462625e-23,  3.535894852027765e-25,
  6.925175649651764e-03, -5.727899994805259e-05,  4.740671321608144e-07, -3.927720577449903e-09,  3.260298801788738e-11, -2.716317347219702e-13,  2.281072281377932e-15,
 -1.949539011446030e-17,  1.729508473565545e-19, -1.639544386199019e-21,  1.682169264669413e-23, -1.750046347419002e-25,  6.111917206565386e-03, -5.069996798233043e-05,
  4.220878265585996e-07, -3.535977544663493e-09,  2.996601515114958e-11, -2.597686223775101e-13,  2.357299185733020e-15, -2.334984981225004e-17,  2.653943677958870e-19,
 -3.487993793040331e-21,  4.888770752059909e-23, -6.190473404806674e-25,  1.609033937646842e-11, -1.130929836906544e-13,  6.280361091321785e-16, -5.394084293549161e-19,
 -6.633205211048835e-20,  1.648095020535612e-21, -3.133997859805129e-23,  5.577318001243264e-25, -9.846147746541865e-27,  1.741562165798475e-28, -3.019645312999436e-30,
  4.894326535850527e-32,  1.324216033675666e-08, -9.854032488537416e-11,  6.627588573853016e-13, -3.341599833022975e-15, -3.213262303563001e-18,  4.889225738454965e-19,
 -1.134287227022716e-20,  2.159387207468226e-22, -3.925937998461464e-24,  7.037127780637517e-26, -1.222914799936530e-27,  1.961786580808302e-29,  1.430051606096239e-06,
 -1.096208805142522e-08,  7.976214801558158e-11, -5.165636922368941e-13,  2.302504428001892e-15,  9.637299558742849e-18, -5.256861243075676e-19,  1.176846912445070e-20,
 -2.272770031392516e-22,  4.180503717681847e-24, -7.334936850670668e-26,  1.175578706428510e-27,  4.431170053571589e-05, -3.459587248889938e-07,  2.628048950295824e-09,
 -1.890940653922799e-11,  1.196725919750020e-13, -4.748370849961936e-16, -3.909936826992091e-18,  1.614252448786360e-19, -3.586834854261106e-21,  6.946120890551663e-23,
 -1.243297871891912e-24,  2.003342362320868e-26,  5.310577964375473e-04, -4.196528497212565e-06,  3.272865670047258e-08, -2.491213360750315e-10,  1.803733974431817e-12,
 -1.154394830142238e-14,  4.621962912930710e-17,  4.104337921414436e-19, -1.706767332125118e-20,  3.815283271761437e-22, -7.180511284448090e-24,  1.177799422334774e-25,
  2.808383802679783e-03, -2.237075140030145e-05,  1.773931844206076e-07, -1.395364938350409e-09,  1.080753210183346e-11, -8.101972241579195e-14,  5.608473635124193e-16,
 -3.004899881492766e-18, -2.210406007391007e-21,  4.847812615599458e-22, -1.174585530601757e-23,  2.086397936416855e-25,  6.703358215679455e-03, -5.366651989876302e-05,
  4.298942489193102e-07, -3.446734328758740e-09,  2.767661157222906e-11, -2.228613064876352e-13,  1.804654636428396e-15, -1.478934347085980e-17,  1.243644494455174e-19,
 -1.100875450015916e-21,  1.058369988636563e-23, -1.107150728541329e-25,  5.915613015830438e-03, -4.748521745142089e-05,  3.823707746104212e-07, -3.095216752113570e-09,
  2.528794950420365e-11, -2.101830984199268e-13,  1.805925937304009e-15, -1.653794792218693e-17,  1.691087907121670e-19, -2.005690536814912e-21,  2.702449733938083e-23,
 -3.761172661780645e-25,  1.981196036469262e+00,  1.278315958398270e-02, -4.414670808523746e-03,  1.326628291701967e-03, -3.730038814249090e-04,  1.011424104982694e-04,
 -2.687129465976459e-05,  7.062407106328211e-06, -1.848224111122519e-06,  4.838265315721395e-07, -1.266641053085071e-07,  3.131483750716221e-08,  1.989750545368173e+00,
  7.022532131753748e-03, -2.475396251223160e-03,  7.391231296937265e-04, -2.047842970255327e-04,  5.456787417300168e-05, -1.424178969696757e-05,  3.680689431362988e-06,
 -9.489195045497893e-07,  2.453119939350675e-07, -6.360411587745171e-08,  1.562515015061484e-08,  1.994870808160575e+00,  3.613268232787520e-03, -1.376130168923777e-03,
  4.196061969240204e-04, -1.167978506601052e-04,  3.107366605128653e-05, -8.078120180296244e-06,  2.078388244715408e-06, -5.336568831063916e-07,  1.375326563270868e-07,
 -3.559277394762064e-08,  8.737935524681203e-09,  1.998310964985189e+00,  1.338902292546971e-03, -6.628639000103495e-04,  2.175874934360729e-04, -6.246569490902556e-05,
  1.686821732902582e-05, -4.418953531671116e-06,  1.141695059977026e-06, -2.938882663838996e-07,  7.588087974018666e-08, -1.967089255812185e-08,  4.836789860074839e-09,
  2.000703850189753e+00, -2.354246925195046e-04, -1.785536885251260e-04,  8.281237078140428e-05, -2.678237121519985e-05,  7.664341256527798e-06, -2.074903610196487e-06,
  5.470853446012068e-07, -1.427229612725365e-07,  3.719325889247436e-08, -9.706281978516556e-09,  2.397739501819568e-09,  2.002350801274546e+00, -1.315341690817052e-03,
  1.492042694054935e-04, -7.292646970623525e-06, -3.178530350719792e-06,  1.630693317524600e-06, -5.494440054683013e-07,  1.622990532998061e-07, -4.529221968747732e-08,
  1.232040295428154e-08, -3.307438949288588e-09,  8.317620065126902e-10,  2.003413027156328e+00, -2.010276341408309e-03,  3.582005137889069e-04, -6.428187708259911e-05,
  1.164574589377032e-05, -2.136628517170433e-06,  3.986168982648431e-07, -7.601323249984267e-08,  1.490731397086510e-08, -3.026703197634549e-09,  6.387358003537814e-10,
 -1.340571707941354e-10,  2.003978762936548e+00, -2.379891550552260e-03,  4.687473136538629e-04, -9.427870479721937e-05,  1.941609073249412e-05, -4.104547726082852e-06,
  8.925207605506238e-07, -1.999204264856068e-07,  4.616643074621484e-08, -1.099014524641755e-08,  2.685916485259636e-09, -6.351592129301873e-10,  1.997841234070779e+00,
  1.488338501580994e-03, -5.255220462024765e-04,  1.461561469663024e-04, -3.664307483862688e-05,  8.670141804053199e-06, -1.977547022025146e-06,  4.398632426789009e-07,
 -9.608247342038136e-08,  2.070443912966175e-08, -4.407708622340012e-09,  8.932450556091768e-10,  1.999182233780815e+00,  6.186644219221593e-04, -2.741309983904630e-04,
  8.113843910688728e-05, -2.083273566470477e-05,  4.973076221463783e-06, -1.136034913350904e-06,  2.520470483193924e-07, -5.478309702064654e-08,  1.172845392691860e-08,
 -2.478367253897881e-09,  4.985590407742979e-10,  2.000057896410049e+00,  5.356004418199396e-05, -1.141931929141554e-04,  4.063113065868979e-05, -1.118363746685208e-05,
  2.761935103996442e-06, -6.426145135914540e-07,  1.440330438570265e-07, -3.147636464145249e-08,  6.755419472266757e-09, -1.428309664277810e-09,  2.871617614145659e-10,
  2.000679981898256e+00, -3.465632756703488e-04, -2.579131454007565e-06,  1.276319799257964e-05, -4.637073908824780e-06,  1.281906460272797e-06, -3.166422730498557e-07,
  7.357278947429146e-08, -1.645727849591084e-08,  3.588139556071883e-09, -7.669806894503260e-10,  1.553406395937898e-10,  2.001129719023309e+00, -6.351417496793943e-04,
  7.707917382461468e-05, -6.922854363177581e-06, -5.833286567623660e-08,  2.566462090635685e-07, -9.290550820396043e-08,  2.563682161197546e-08, -6.325297445923666e-09,
  1.468561982000746e-09, -3.277513528724610e-10,  6.837143536187490e-11,  2.001447739948410e+00, -8.388533461466992e-04,  1.328864956675906e-04, -2.061315891368993e-05,
  3.103277996546157e-06, -4.464737868862128e-07,  5.953404656579907e-08, -6.821321452882650e-09,  4.949333768349712e-10,  4.969736462001805e-11, -3.525016089209642e-11,
  1.071682589197410e-11,  2.001656632876073e+00, -9.725042317621440e-04,  1.693094400743779e-04, -2.950294189614931e-05,  5.146267842112839e-06, -8.987052929774221e-07,
  1.571456279224506e-07, -2.751805631158519e-08,  4.826614837974060e-09, -8.481134680842720e-10,  1.491976604387425e-10, -2.553093330601354e-11,  2.001769122001433e+00,
 -1.044423649935859e-03,  1.888464539949481e-04, -3.425658541840360e-05,  6.235472036256671e-06, -1.139126094737098e-06,  2.088996672747660e-07, -3.846371975089532e-08,
  7.112010260231702e-09, -1.320745186213063e-09,  2.460963986666742e-10, -4.453972658652330e-11,  2.000004056941147e+00,  3.903529787723513e-05, -5.591654043849534e-05,
  1.887132997218829e-05, -4.984607718618241e-06,  1.183776641999201e-06, -2.648433734376123e-07,  5.703171122915506e-08, -1.195977686883700e-08,  2.459535308442339e-09,
 -4.976383642815356e-10,  9.591676332473356e-11,  2.000278605975154e+00, -1.363869062825882e-04, -8.416045484063524e-06,  7.375058083290246e-06, -2.370228151235251e-06,
  6.123544556504429e-07, -1.433331630656993e-07,  3.170878127076770e-08, -6.763172082624363e-09,  1.406072889495799e-09, -2.864655679642749e-10,  5.544080364001125e-11,
  2.000464499960570e+00, -2.548904699886118e-04,  2.334070446612759e-05, -2.313225144348577e-07, -6.582630270014200e-07,  2.419970990417996e-07, -6.537689159953474e-08,
  1.562583035832628e-08, -3.495597944261934e-09,  7.501974512328365e-10, -1.562686411786114e-10,  3.070945795591304e-11,  2.000599871902029e+00, -3.410487000101333e-04,
  4.626146450777709e-05, -5.681410098694317e-06,  5.595450932919085e-07, -1.957830950587054e-08, -1.070604209092935e-08,  4.425314251599467e-09, -1.235614652837362e-09,
  2.996399518213421e-10, -6.742333402131567e-11,  1.393617707198986e-11,  2.000699501493875e+00, -4.043839196516453e-04,  6.302026857662163e-05, -9.645029563220946e-06,
  1.440525816508700e-06, -2.078190869228050e-07,  2.843520873285243e-08, -3.553040629148023e-09,  3.662004757223999e-10, -1.813961302813748e-11, -5.060526782176056e-12,
  2.214334231040539e-12,  2.000770863590112e+00, -4.497104263951884e-04,  7.496685646092710e-05, -1.245949645004126e-05,  2.063679021301464e-06, -3.404642539933335e-07,
  5.591344148026051e-08, -9.133527674382652e-09,  1.482562200011681e-09, -2.388295172947377e-10,  3.809967543769427e-11, -5.872540960406408e-12,  2.000818154918304e+00,
 -4.797302177152104e-04,  8.285748646465244e-05, -1.431338805559731e-05,  2.473052252560492e-06, -4.273745848927097e-07,  7.387088612627522e-08, -1.277121104082848e-08,
  2.208462038817402e-09, -3.819810046740603e-10,  6.602936379641946e-11, -1.109434277225460e-11,  2.000843759635379e+00, -4.959777445890016e-04,  8.712092615006881e-05,
 -1.531340454371247e-05,  2.693510882404987e-06, -4.741024772573211e-07,  8.351050028604839e-08, -1.472089444586029e-08,  2.596929061355839e-09, -4.584748013230501e-10,
  8.093213275105553e-11, -1.387691196328056e-11,  2.000217700642262e+00, -1.185623221599691e-04,  9.765995955709159e-06,  2.266542113032951e-07, -3.809139792236306e-07,
  1.268322659195549e-07, -3.280802134168508e-08,  7.613459822711901e-09, -1.662657023900146e-09,  3.492362809214893e-10, -7.130254925738430e-11,  1.376196960829557e-11,
  2.000280203563805e+00, -1.582291354136723e-04,  2.018055819833159e-05, -2.216500779338222e-06,  1.575319170497537e-07,  1.279066677267923e-08, -9.310892774520687e-09,
  2.869087224237705e-09, -7.194307527567000e-10,  1.640029720160511e-10, -3.532925891576218e-11,  7.067997939023496e-12,  2.000323236243999e+00, -1.855090014816805e-04,
  2.730616093441392e-05, -3.879469005747806e-06,  5.221414646364816e-07, -6.403524656404204e-08,  6.437098887104351e-09, -2.943820886879280e-10, -9.370464660553099e-11,
  4.174392934646197e-11, -1.170514860598177e-11,  2.692538750372194e-12,  2.000354942783172e+00, -2.055930012207959e-04,  3.253301720364227e-05, -5.094834051337692e-06,
  7.876371435186367e-07, -1.197730651002693e-07,  1.782091564780768e-08, -2.572914773620099e-09,  3.553650131486235e-10, -4.568552369747869e-11,  5.129185911703763e-12,
 -4.151349816657977e-13,  2.000378479368259e+00, -2.204931813943558e-04,  3.640028062103264e-05, -5.991617811314088e-06,  9.830078779548961e-07, -1.606782979065071e-07,
  2.615294051437276e-08, -4.236171079704998e-09,  6.823040198206962e-10, -1.091701020215274e-10,  1.732124961825107e-11, -2.660398483340277e-12,  2.000395444124125e+00,
 -2.312283752359835e-04,  3.918099536115285e-05, -6.635153114523274e-06,  1.122927669059986e-06, -1.899156750588723e-07,  3.209662489795277e-08, -5.420346885403778e-09,
  9.146215721091384e-10, -1.541945741124165e-10,  2.595169420702830e-11, -4.246962270612390e-12,  2.000406735737953e+00, -2.383715064736723e-04,  4.102869015537653e-05,
 -7.062164946761664e-06,  1.215641145149173e-06, -2.092621597581116e-07,  3.602419255645049e-08, -6.201782245394922e-09,  1.067720693177259e-09, -1.838263870304307e-10,
  3.162412637742162e-11, -5.288467118129526e-12,  2.000412865729413e+00, -2.422486557193221e-04,  4.203072019401152e-05, -7.293539902701783e-06,  1.265834575928717e-06,
 -2.197270845131841e-07,  3.814690207622207e-08, -6.623766079470500e-09,  1.150327237649874e-09, -1.998014393799294e-10,  3.467975473500506e-11, -5.849082527570868e-12,
  2.000157204503931e+00, -9.000044346618240e-05,  1.298701749309309e-05, -1.796991745713290e-06,  2.325634672763158e-07, -2.659586540496582e-08,  2.226186973543750e-09,
  2.846000865835757e-11, -7.695333650560297e-11,  2.585548721355268e-11, -6.644594894418122e-12,  1.463634213549718e-12,  2.000172136305505e+00, -9.944613552476171e-05,
  1.542998157925654e-05, -2.361450962555664e-06,  3.550819228974878e-07, -5.215141918958417e-08,  7.411669626000780e-09, -1.002633151855292e-09,  1.249174255831196e-10,
 -1.318462172348141e-11,  8.221634738074306e-13,  9.394690239261554e-14,  2.000182499620811e+00, -1.059982668423753e-04,  1.712024272574954e-05, -2.750987624993993e-06,
  4.394142765422885e-07, -6.969649033058487e-08,  1.096256060328923e-08, -1.706881861553917e-09,  2.624430268013742e-10, -3.971268350343357e-11,  5.882951608390299e-12,
 -8.321823605659018e-13,  2.000190178998253e+00, -1.108516019188298e-04,  1.836997381677475e-05, -3.038469451201693e-06,  5.015375883244168e-07, -8.259722695069655e-08,
  1.356869673895616e-08, -2.222808500258988e-09,  3.630086470175197e-10, -5.907591582520843e-11,  9.570200771790673e-12, -1.505809838877736e-12,  2.000195903724570e+00,
 -1.144685555336000e-04,  1.930006980819622e-05, -3.252130867595967e-06,  5.476453856830453e-07, -9.215901543882309e-08,  1.549767743750394e-08, -2.604160896670661e-09,
  4.372417389711480e-10, -7.334964077183075e-11,  1.228462589904048e-11, -2.001088571823046e-12,  2.000200042819256e+00, -1.170831286414370e-04,  1.997173041482774e-05,
 -3.406268842645488e-06,  5.808745322736237e-07, -9.904309585158806e-08,  1.688506498507893e-08, -2.878167366122820e-09,  4.905258533762679e-10, -8.358504490026834e-11,
  1.422916390064883e-11, -2.355565176070569e-12,  2.000202803740707e+00, -1.188268800240511e-04,  2.041937010269778e-05, -3.508924147172181e-06,  6.029893785956879e-07,
 -1.036213958521103e-07,  1.780710663151593e-08, -3.060141221049796e-09,  5.258883116297006e-10, -9.037313204083998e-11,  1.551788529646443e-11, -2.590339326053632e-12,
  2.000204304593203e+00, -1.197747056074234e-04,  2.066258149728298e-05, -3.564674428523988e-06,  6.149943168024462e-07, -1.061056211307702e-07,  1.830719707493113e-08,
 -3.158796186989621e-09,  5.450513797487676e-10, -9.405004558847449e-11,  1.621565164391785e-11, -2.717405084041630e-12,  2.000090062342311e+00, -5.225334734997996e-05,
  8.373810353244659e-06, -1.334032861630253e-06,  2.110561433095325e-07, -3.311643885955692e-08,  5.144559334100137e-09, -7.893862951823021e-10,  1.192439319615422e-10,
 -1.764794018737740e-11,  2.539470888046417e-12, -3.458167301342230e-13,  2.000093712658154e+00, -5.455884201261414e-05,  8.965674128938605e-06, -1.469764595300370e-06,
  2.402964529677796e-07, -3.916971995958989e-08,  6.363593470585611e-09, -1.029957173455063e-09,  1.659889256408483e-10, -2.661992362549224e-11,  4.242564723198572e-12,
 -6.560321999935608e-13,  2.000096256138807e+00, -5.616483714315129e-05,  9.377436916576127e-06, -1.564072258958410e-06,  2.605866450923723e-07, -4.336473105490871e-08,
  7.207309279864154e-09, -1.196245451204671e-09,  1.982584308666990e-10, -3.280556656660910e-11,  5.415238105960498e-12, -8.693757859648716e-13,  2.000098146209686e+00,
 -5.735802677190917e-05,  9.683080169949369e-06, -1.634010345102541e-06,  2.756198266349519e-07, -4.646997409138800e-08,  7.831268943635282e-09, -1.319108161827046e-09,
  2.220788434001377e-10, -3.736741515851967e-11,  6.279279100200900e-12, -1.026435063631261e-12,  2.000099558148018e+00, -5.824924535424615e-05,  9.911215883983410e-06,
 -1.686177051634533e-06,  2.868253222426790e-07, -4.878297679497502e-08,  8.295717461277663e-09, -1.410498852197520e-09,  2.397853260663087e-10, -4.075605572841667e-11,
  6.920669295219816e-12, -1.142947925796854e-12,  2.000100580582921e+00, -5.889453962865676e-05,  1.007631634559197e-05, -1.723910635825118e-06,  2.949264381704328e-07,
 -5.045433294989035e-08,  8.631153465801765e-09, -1.476469921744100e-09,  2.525604062722382e-10, -4.319969441181173e-11,  7.382960089386152e-12, -1.226886626040512e-12,
  2.000101263318881e+00, -5.932540585017812e-05,  1.018651588065824e-05, -1.749087702488866e-06,  3.003298389997321e-07, -5.156872137879778e-08,  8.854728154546979e-09,
 -1.520425301845125e-09,  2.610691987925233e-10, -4.482669367840912e-11,  7.690649536799517e-12, -1.282735753891923e-12,  2.000101634705414e+00, -5.955977246311987e-05,
  1.024644506241581e-05, -1.762776592861243e-06,  3.032670465441797e-07, -5.217435276695830e-08,  8.976206488832640e-09, -1.544303017083697e-09,  2.656903836933327e-10,
 -4.571013484979864e-11,  7.857684860775421e-12, -1.313048384415434e-12,  2.000047821417552e+00, -2.788933368587966e-05,  4.639881222989236e-06, -7.710220356971772e-07,
  1.279620389515445e-07, -2.120845572182125e-08,  3.509981289988710e-09, -5.799855686103460e-10,  9.567275846235097e-11, -1.575234462941048e-11,  2.586595852699354e-12,
 -4.130598253727456e-13,  2.000048723911281e+00, -2.845889109907829e-05,  4.785558522228947e-06, -8.043058843579945e-07,  1.351055233460874e-07, -2.268175807950115e-08,
  3.805570116544924e-09, -6.381001536710288e-10,  1.069225984375833e-10, -1.790348442812714e-11,  2.993408369910384e-12, -4.869006282090785e-13,  2.000049353982964e+00,
 -2.885647113394206e-05,  4.887183830191420e-06, -8.275099370988866e-07,  1.400824328374803e-07, -2.370755277607539e-08,  4.011242192033210e-09, -6.785103686890367e-10,
  1.147401560374821e-10, -1.939735244518047e-11,  3.275739031233469e-12, -5.381157110212056e-13,  2.000049822846913e+00, -2.915229917935185e-05,  4.962765742246589e-06,
 -8.447595446130503e-07,  1.437804917347781e-07, -2.446940891517113e-08,  4.163923616304522e-09, -7.084951150445732e-10,  1.205381625887390e-10, -2.050478772643666e-11,
  3.484939976799255e-12, -5.760485689890231e-13,  2.000050173467113e+00, -2.937350575715466e-05,  5.019263118610410e-06, -8.576491604771275e-07,  1.465428782794261e-07,
 -2.503830544585631e-08,  4.277895086890379e-09, -7.308699570959190e-10,  1.248631814080773e-10, -2.133059263925633e-11,  3.640885634397415e-12, -6.043159227745610e-13,
  2.000050427558854e+00, -2.953380389673116e-05,  5.060193827862806e-06, -8.669849384146972e-07,  1.485431278698634e-07, -2.545013935485470e-08,  4.360379904003935e-09,
 -7.470592137366570e-10,  1.279917382061084e-10, -2.192779663431406e-11,  3.753633485673553e-12, -6.247482028808695e-13,  2.000050597321230e+00, -2.964089740233741e-05,
  5.087534374161861e-06, -8.732198600833004e-07,  1.498787604714806e-07, -2.572508520686063e-08,  4.415438016437443e-09, -7.578635094033170e-10,  1.300792833882901e-10,
 -2.232621275022218e-11,  3.828838224353446e-12, -6.383746104584206e-13,  2.000050689697275e+00, -2.969917088957872e-05,  5.102409737990341e-06, -8.766117638203034e-07,
  1.506052870227105e-07, -2.587462733739319e-08,  4.445380623722765e-09, -7.637386284814936e-10,  1.312143152133613e-10, -2.254281403896474e-11,  3.869719229987295e-12,
 -6.457811095768766e-13,  2.000024599148162e+00, -1.437916523629087e-05,  2.431112725090576e-06, -4.109245639946703e-07,  6.943858796679224e-08, -1.173052430124024e-08,
  1.981105105793685e-09, -3.344773545885190e-10,  5.645339952678479e-11, -9.524969810570704e-12,  1.605316475911938e-12, -2.631997830180170e-13,  2.000024823525822e+00,
 -1.452071320228772e-05,  2.467250276663153e-06, -4.191658280762183e-07,  7.120406012596227e-08, -1.209396338738316e-08,  2.053885744784571e-09, -3.487597332194533e-10,
  5.921301727408633e-11, -1.005166374741952e-11,  1.704736618818974e-12, -2.812140799184330e-13,  2.000024980326272e+00, -1.461962361718730e-05,  2.492494305179382e-06,
 -4.249209426058903e-07,  7.243654242664743e-08, -1.234759937976845e-08,  2.104661269866329e-09, -3.587206278538291e-10,  6.113702118414726e-11, -1.041875545967059e-11,
  1.774007464453194e-12, -2.937617189282913e-13,  2.000025097089694e+00, -1.469327493333039e-05,  2.511287376384919e-06, -4.292043829162856e-07,  7.335364671227581e-08,
 -1.253628900802825e-08,  2.142426366728944e-09, -3.661274773731828e-10,  6.256736390054898e-11, -1.069159527404532e-11,  1.825480893896841e-12, -3.030835313383256e-13,
  2.000025184451709e+00, -1.474837861829144e-05,  2.525345381998554e-06, -4.324080234879722e-07,  7.403944221080625e-08, -1.267736355234679e-08,  2.170656692736129e-09,
 -3.716633163745492e-10,  6.363620875879576e-11, -1.089544351340979e-11,  1.863931865028904e-12, -3.100458555484650e-13,  2.000025247786574e+00, -1.478832608761901e-05,
  2.535535461494676e-06, -4.347299172931875e-07,  7.453642083357007e-08, -1.277958361832143e-08,  2.191109257529169e-09, -3.756734579190778e-10,  6.441037688898579e-11,
 -1.104307261108470e-11,  1.891774923890432e-12, -3.150868006440202e-13,  2.000025290112896e+00, -1.481502224966456e-05,  2.542344702786452e-06, -4.362813206756611e-07,
  7.486845378120653e-08, -1.284787103141280e-08,  2.204771226211274e-09, -3.783519243318720e-10,  6.492741527374996e-11, -1.114165979714377e-11,  1.910366946308182e-12,
 -3.184525770785387e-13,  2.000025313148557e+00, -1.482955119055786e-05,  2.546050316045917e-06, -4.371255532725130e-07,  7.504912729634338e-08, -1.288502710956417e-08,
  2.212204469882828e-09, -3.798091511692518e-10,  6.520869576668591e-11, -1.119529046193785e-11,  1.920480303209099e-12, -3.202833372489358e-13,  2.000012470557360e+00,
 -7.297446200524005e-06,  1.243094378802475e-06, -2.117435142498561e-07,  3.606521354278521e-08, -6.142410397555687e-09,  1.046069704708788e-09, -1.781367051284047e-10,
  3.033307513174664e-11, -5.164633817234350e-12,  8.785938818724725e-13, -1.453632181799004e-13,  2.000012526496973e+00, -7.332728675348295e-06,  1.252093810280529e-06,
 -2.137939563445145e-07,  3.650405778661762e-08, -6.232666437323224e-09,  1.064127103321763e-09, -1.816769578963071e-10,  3.101647814262433e-11, -5.294944634715100e-12,
  9.031688161327972e-13, -1.498121551096060e-13,  2.000012565607855e+00, -7.357396029195052e-06,  1.258384661171471e-06, -2.152270413063724e-07,  3.681072311489647e-08,
 -6.295727350284941e-09,  1.076741567350970e-09, -1.841496923754158e-10,  3.149373224879006e-11, -5.385932364416555e-12,  9.203251540046849e-13, -1.529175919682451e-13,
  2.000012594742397e+00, -7.375770830255455e-06,  1.263070202546609e-06, -2.162943059969604e-07,  3.703908020695083e-08, -6.342679946547371e-09,  1.086132692798154e-09,
 -1.859903617114339e-10,  3.184895224473264e-11, -5.453646603347217e-12,  9.330916412778182e-13, -1.552281789128907e-13,  2.000012616546427e+00, -7.389522117802252e-06,
  1.266576456739024e-06, -2.170928857641997e-07,  3.720993338553796e-08, -6.377806092371263e-09,  1.093157765503574e-09, -1.873671628999165e-10,  3.211462995700239e-11,
 -5.504287336658210e-12,  9.426383533896349e-13, -1.569558835080327e-13,  2.000012632356730e+00, -7.399493170766499e-06,  1.269118679847893e-06, -2.176718622216126e-07,
  3.733379533108606e-08, -6.403269558310940e-09,  1.098250018786741e-09, -1.883650985744929e-10,  3.230718663033748e-11, -5.540988140424510e-12,  9.495566897366695e-13,
 -1.582078459976340e-13,  2.000012642924084e+00, -7.406157600717747e-06,  1.270817770044324e-06, -2.180588028005456e-07,  3.741657082808781e-08, -6.420285731968034e-09,
  1.101652806557382e-09, -1.890319174417972e-10,  3.243584687285641e-11, -5.565509346627145e-12,  9.541788869487062e-13, -1.590442572606592e-13,  2.000012648675735e+00,
 -7.409784928088164e-06,  1.271742528461396e-06, -2.182693958987334e-07,  3.746162028983601e-08, -6.429546300491314e-09,  1.103504625507542e-09, -1.893947944518804e-10,
  3.250586070552918e-11, -5.578852830316333e-12,  9.566940366277313e-13, -1.594993751955589e-13,  2.000006277884526e+00, -3.675594474197386e-06,  6.284000617512865e-07,
 -1.074331274910084e-07,  1.836680168196741e-08, -3.139945572827915e-09,  5.367893805739453e-10, -9.176537847031948e-11,  1.568724248418434e-11, -2.681619756342453e-12,
  4.580271035791619e-13, -7.607294119895962e-14,  2.000006291850136e+00, -3.684402069102192e-06,  6.306455665241424e-07, -1.079445092484648e-07,  1.847619888246790e-08,
 -3.162434554202084e-09,  5.412866218830785e-10, -9.264667617256564e-11,  1.585728695984907e-11, -2.714028587122365e-12,  4.641361486731309e-13, -7.717841339093191e-14,
  2.000006301616730e+00, -3.690561396485014e-06,  6.322157678551053e-07, -1.083020714884417e-07,  1.855268410730144e-08, -3.178156488492027e-09,  5.444303660583592e-10,
 -9.326268712770031e-11,  1.597613529495963e-11, -2.736678092041693e-12,  4.684052218601396e-13, -7.795087194889464e-14,  2.000006308893343e+00, -3.695150354686413e-06,
  6.333855670181429e-07, -1.085684397772300e-07,  1.860965896206081e-08, -3.189867284469207e-09,  5.467719102993580e-10, -9.372148175292945e-11,  1.606464638598256e-11,
 -2.753545098473093e-12,  4.715842012047474e-13, -7.852605445426874e-14,  2.000006314339800e+00, -3.698585104277242e-06,  6.342611024662694e-07, -1.087677943560299e-07,
  1.865229807039041e-08, -3.198631084495492e-09,  5.485241339950111e-10, -9.406479189067764e-11,  1.613087522146222e-11, -2.766165365762334e-12,  4.739626808770209e-13,
 -7.895638261710842e-14,  2.000006318289456e+00, -3.701075895001319e-06,  6.348959978847505e-07, -1.089123519258651e-07,  1.868321588924987e-08, -3.204985553675024e-09,
  5.497945982105963e-10, -9.431370374316779e-11,  1.617889190091981e-11, -2.775314913210215e-12,  4.756869959231842e-13, -7.926834621387897e-14,  2.000006320929520e+00,
 -3.702740803732531e-06,  6.353203689605649e-07, -1.090089736355767e-07,  1.870388077396183e-08, -3.209232665112604e-09,  5.506437142528238e-10, -9.448006048666424e-11,
  1.621098245218624e-11, -2.781429609465669e-12,  4.768393399468981e-13, -7.947682425653577e-14,  2.000006322366526e+00, -3.703647023399723e-06,  6.355513534845646e-07,
 -1.090615639566081e-07,  1.871512832736284e-08, -3.211544265162237e-09,  5.511058611485958e-10, -9.457060191809921e-11,  1.622844783356065e-11, -2.784757505375151e-12,
  4.774664892930537e-13, -7.959028444218267e-14,  2.000003149576280e+00, -1.844503302967939e-06,  3.159093101869665e-07, -5.410579418154063e-08,  9.266665437730170e-09,
 -1.587089948747591e-09,  2.718178307384126e-10, -4.655353577487688e-11,  7.973067276033503e-12, -1.365482642671385e-12,  2.336646737881875e-13, -3.887817873165020e-14,
  2.000003153065274e+00, -1.846703576259760e-06,  3.164701432677577e-07, -5.423348636584686e-08,  9.293975605697585e-09, -1.592702842744689e-09,  2.729400094693552e-10,
 -4.677339120627914e-11,  8.015478007623052e-12, -1.373563831720233e-12,  2.351876191035101e-13, -3.915370571488979e-14,  2.000003155505534e+00, -1.848242470476750e-06,
  3.168623801834766e-07, -5.432278846941497e-08,  9.313074323204187e-09, -1.596627928052666e-09,  2.737247149738626e-10, -4.692712319985470e-11,  8.045132139213961e-12,
 -1.379214074353033e-12,  2.362523959438716e-13, -3.934633484727636e-14,  2.000003157323810e+00, -1.849389117981783e-06,  3.171546319896503e-07, -5.438932465200696e-08,
  9.327303762883568e-09, -1.599552215580283e-09,  2.743093233514931e-10, -4.704165074445221e-11,  8.067223285463967e-12, -1.383423157324565e-12,  2.370455661373700e-13,
 -3.948982362607950e-14,  2.000003158684857e+00, -1.850247421773600e-06,  3.173733875137361e-07, -5.443912705949827e-08,  9.337954283838784e-09, -1.601740953190796e-09,
  2.747468749044318e-10, -4.712736729871939e-11,  8.083756738313920e-12, -1.386573250155518e-12,  2.376391647050767e-13, -3.959720663658261e-14,  2.000003159671906e+00,
 -1.850869873156724e-06,  3.175320289317386e-07, -5.447524316999776e-08,  9.345677790772868e-09, -1.603328148716784e-09,  2.750641668093158e-10, -4.718952393371721e-11,
  8.095745639385731e-12, -1.388857439978495e-12,  2.380695869786070e-13, -3.967506960418725e-14,  2.000003160331700e+00, -1.851285950654739e-06,  3.176380715814872e-07,
 -5.449938443974073e-08,  9.350840394667277e-09, -1.604389061819772e-09,  2.752762486519702e-10, -4.723106973131729e-11,  8.103758988997427e-12, -1.390384169186891e-12,
  2.383572736139228e-13, -3.972711128704712e-14,  2.000003160690838e+00, -1.851512429131030e-06,  3.176957921105979e-07, -5.451252478688612e-08,  9.353650434786942e-09,
 -1.604966519961512e-09,  2.753916846229509e-10, -4.725368291694638e-11,  8.108120587760140e-12, -1.391215149256219e-12,  2.385138568504593e-13, -3.975543655865521e-14,
   0.00144817174743628,   0.00164239775342482,  0.000689178007961501,  0.000130644705553395,   1.0940704457053e-05,  3.54958124620789e-07,  3.31342266909429e-09,
  4.08244465469088e-12,  0.000722525422278034,  0.000819554957203086,  0.000343997383700486,  6.52386149986105e-05,  5.46671750820335e-06,  1.77513536934838e-07,
  1.65905072965727e-09,  2.04795447115759e-12,  0.000360893314855902,  0.000409372622059247,  0.000171839733303899,  3.25923054041625e-05,  2.73146451106072e-06,
  8.87115498154913e-08,  8.29312453255198e-10,  1.02409838641742e-12,   0.00018035656256068,  0.000204585798303185,  8.58789781206824e-05,  1.62887690087699e-05,
  1.36515667755133e-06,  4.43389746259166e-08,  4.14523222868182e-10,  5.11928172510175e-13,  9.01560219854537e-05,   0.00010226785527173,  4.29291352908752e-05,
  8.14246588659772e-06,  6.82422780568255e-07,  2.21646633646634e-08,  2.07219396386342e-10,    2.559170876065e-13,  4.50724782275002e-05,  5.11276770085327e-05,
  2.14619634325276e-05,  4.07074457071683e-06,  3.41171104892414e-07,  1.10810513000062e-08,  1.03598080946048e-10,  1.27944822666776e-13,  2.25348598701645e-05,
  2.55622771285177e-05,   1.0730328732654e-05,  2.03524912451243e-06,  1.70575310334344e-07,  5.54019646940042e-09,  5.17960066218755e-11,  6.39687418099681e-14,
  1.12670856140024e-05,  1.27807483797366e-05,   5.3650008816312e-06,  1.01759363993229e-06,  8.52850735210056e-08,  2.77001481702468e-09,  2.58972288630047e-11,
  3.19834240571689e-14,  5.63345678773256e-06,  6.39027666361994e-06,  2.68245953994737e-06,  5.08789072954604e-07,  4.26418887232405e-08,  1.38498641458774e-09,
  1.29484188341784e-11,  1.59914716602756e-14,  2.81670689666026e-06,  3.19511395273038e-06,  1.34121954105447e-06,  2.54392597675789e-07,  2.13207820249633e-08,
  6.92487941424842e-10,  6.47416027038604e-12,  7.99567528269363e-15,  1.40834807497914e-06,  1.59755088190543e-06,  6.70607212835261e-07,  1.27195813881761e-07,
  1.06603503874542e-08,  3.46242652074817e-10,  3.23706781764529e-12,   3.9978224476694e-15  };
  int offset = -8;
  const int ibox0 = static_cast<int>(log(64.0) / log(2.0));
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 8;
    if (std::isnan(t)) {
      fill_n(rr+offset, 8, 0.5);
      fill_n(ww+offset, 8, 0.0);
    } else if (t >= 131072.0) {
      for (int r = 0; r != 8; ++r) {
        ww[offset+r] = aw[8-r-1] / t;
        rr[offset+r] = 1.0 - ax[8-r-1] / t;
      }
    } else {
      assert(t >= 0);
      int it;
      double bigT = 0.0;
      if (t >= 64.0 && t < 131072.0) {
        bigT = t;
        it = static_cast<int>(log(bigT) / log(2.0) + 32 - ibox0);
        t = (t - 1.5 * pow(2.0, it + ibox0 - 32))* 2/pow(2.0, it + ibox0 - 32);
      } else {
        it = static_cast<int>(t*   0.500000000000000);
        t = (t - it *2.000000000000000-   1.000000000000000) *   1.000000000000000;
      }
      const double t2 = t * 2.0;
      for (int j=1; j <=8; ++j) {
        const int boxof = it*96+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
        if (64.0 <= bigT && bigT < 131072.0) {
          const int iref = 4128 + (it - 32) * 8 + 8 - j;
          double rr_infty = x[iref];
          double ww_infty = w[iref];
          double Tref = pow(2.0, it + ibox0 + 1 - 32);
          ww[offset+j-1] = ww[offset+j-1] * ww_infty * Tref / bigT;
          rr[offset+j-1] = 1.0 + rr[offset+j-1] * (1.0 - rr_infty) * Tref /bigT;
        }
      }
    }
  }
}
