/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "DialogBookDelete.h"


DialogBookDelete::DialogBookDelete(Book* pbook, Gtk::Window &parent)
: book(pbook),
  image_question(Gtk::Stock::DIALOG_QUESTION,
                 Gtk::IconSize(Gtk::ICON_SIZE_DIALOG)),
  label_question("", 0, 0),
  button_cancel(Gtk::Stock::CANCEL),
  image_delete(Gtk::Stock::DELETE,
               Gtk::IconSize(Gtk::ICON_SIZE_BUTTON)),
  label_delete(_("Delete Book"))
{
  set_transient_for(parent);
  set_title("");
  
  // Prepare the window text.
  char text1[2000];
  char text2[2000];
  snprintf(text1, 2000,
                  "<span weight=\"bold\" size=\"larger\">%s</span>\n\n%s",
                  _("Delete the book \"%s\" by \"%s\"?"),
                  _("Deletion of a book will destroy its data and "
                    "can not be reversed."));
  snprintf(text2, 2000, text1, book->get_title().c_str(),
                               book->get_author().c_str());
  label_question.set_markup(text2);
  label_question.set_line_wrap();
  label_question.set_selectable();
  
  button_delete.set_size_request(-1, 35);
  button_delete.add(hbox_delete);
  hbox_delete.pack_start(image_delete);
  hbox_delete.pack_start(label_delete);
  vbox_icon.pack_start(image_question, FALSE, FALSE);
  vbox_icon.pack_start(fixed_icon,     TRUE,  TRUE);
  hbox_main.set_border_width(12);
  hbox_main.set_spacing(12);
  hbox_main.pack_start(vbox_icon,      FALSE, FALSE);
  hbox_main.pack_start(label_question, TRUE,  TRUE);
  get_vbox()->pack_start(hbox_main,    FALSE, FALSE);
  add_action_widget(button_cancel, DIALOGBOOKDELETE_RESPONSE_CANCEL);
  add_action_widget(button_delete, DIALOGBOOKDELETE_RESPONSE_DELETE);
  show_all();
  
  signal_response().connect(
                   sigc::mem_fun(*this, &DialogBookDelete::on_signal_response));
}


void DialogBookDelete::on_signal_response(int response)
{
  switch (response) {
  case DIALOGBOOKDELETE_RESPONSE_CANCEL:
    signal_button_cancel_clicked.emit(this);
    break;
  
  case DIALOGBOOKDELETE_RESPONSE_DELETE:
    signal_button_delete_clicked.emit(this, book);
    break;
  }
}
