//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Model/FitParameterHelper.h
//! @brief     Defines namespace FitParameterHelper
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_MODEL_FITPARAMETERHELPER_H
#define BORNAGAIN_GUI_MODEL_MODEL_FITPARAMETERHELPER_H

#include <QString>

class JobItem;
class ParameterItem;

//! Convenience static methods to handle various fitting items in given JobItem.

namespace FitParameterHelper {

//! Returns ParameterItem corresponding to given link.

ParameterItem* getParameterItem(JobItem* jobItem, const QString& link);

} // namespace FitParameterHelper

#endif // BORNAGAIN_GUI_MODEL_MODEL_FITPARAMETERHELPER_H
