/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/


#ifndef MMLCOMPONENT_H
#define MMLCOMPONENT_H

#include <Component.h>

#include <QObject>
class QDockWidget;

class MMLDisplay;
class MMLComponentPopup;
class MonitoringGuiManager;
class PMManagerDC;

/** This class manage an MML monitoring document ".mml".
 *
 *  
 */
class MMLComponent : public camitk::Component {
Q_OBJECT  
  
  public:
    
    /// Default constructor: give it the name of the file containing the data (.mml file)
    MMLComponent(const QString &) throw(camitk::AbortException);

    /// destructor
    virtual ~MMLComponent();

    ///@name Redefined from Extension
    ///@{
    
    /** save the current mml in the current file name.
      *  @return false if there was a problem during the saving procedure
      */
    bool save();
    
    void initRepresentation(){};
    
    /// get MonitoringGuiManager
    MonitoringGuiManager* getMonitoringGuiManager();
    /// get Physical model manager
    PMManagerDC* getPMManager();
    /// get the display
    MMLDisplay* getDisplay();
    /// connect pml
    void connectPml();
    
    /// Overriden method so that we actually can build a popup menu with different actions
    virtual QMenu * getPopupMenu(QWidget* parent);
    
    /// return true if mmlDock is visible
    bool isDockVisible();
    /// show or hide mmlDock
    void setDockVisible(bool visible);

    /// save the mml in the current filename (and the pml if needed)
    void saveMML();

    /// check if the mml or pml were modified in the UI
    virtual bool getModified() const;
    
  private:

    /// the mml GUI class is used directly
    MonitoringGuiManager *mmlGUI;
    
    /// to put the mmlGUI
    QDockWidget *mmlDock;
    
    /// physical model manager
    PMManagerDC* pmMgr;
    
    /// display manager
    MMLDisplay* display;
    
    /// when a .scn is loaded, name of the automatically exported mml file (empty string otherwise)
    QString exportedMml;
    
    /// the popup menu
    MMLComponentPopup * myPopupMenu;
};


#endif