#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <iostream>

#include "./canlxx.h"

int main(void) {

  AuthN::Context ctx(AuthN::Context::ClientMinimalContext);
  if((bool)ctx) {
    std::cout<<"Cert: "<<ctx.GetCertPath()<<std::endl;
    std::cout<<"Key: "<<ctx.GetKeyPath()<<std::endl;
    std::cout<<"CA: "<<ctx.GetCAPath()<<std::endl;
    AuthN::Credentials cred(ctx);  
    AuthN::Validator validator(ctx);
    validator.Validate(cred);
  }
  else {std::cout<<"Context is not valid"<<std::endl; }
  return 0;
}
