package Language::INTERCAL::InstallModule;

# This package helps installing an optional component of CLC-INTERCAL.

# This file is part of CLC-INTERCAL

# Copyright (c) 2008 Claudio Calvelli, all rights reserved.

# CLC-INTERCAL is copyrighted software. However, permission to use, modify,
# and distribute it is granted provided that the conditions set out in the
# licence agreement are met. See files README and COPYING in the distribution.

require 5.005;
use strict;
use vars qw($VERSION $PERVERSION);
($VERSION) = ($PERVERSION = "CLC-INTERCAL/Base INTERCAL/InstallModule.pm 1.-94.-2") =~ /\s(\S+)$/;

use Config qw(%Config);
use ExtUtils::MakeMaker;
use Carp;

import Language::INTERCAL::Exporter '1.-94.-2';

my $type = '';
my $has_distribute = 0;
my $pm_dir = 'INTERCAL';
my $iacc_dir = 'Include';
my $iacc_suffix = 'iacc';
my $sick_suffix = 'i';
my $iasm_suffix = 'iasm';
my $bin_dir = 'bin';
my $html_dir = 'doc/html';
my $html_suffix = 'html';
my $htmlgen_suffix = 'hgen';

my @iacc = ();
my @sick = ();
my @iasm = ();
my @bin = ();
my @htmlcopy = ();
my @htmlgen = ();

sub install {
    @_ == 3 || @_ == 4
	or croak "Usage: install Language::INTERCAL::InstallModule TYPE, HAS_DISTRIBUTE? [, PREREQ]";
    my ($class, $req) = @_;
    ($class, $type, $has_distribute, $req) = @_;

    open(MANIFEST, "MANIFEST")
	or die "Sorry, I can't function without file \"MANIFEST\"\n";

    while (<MANIFEST>) {
	chomp;
	s/\s+\S+$//;
	my $on = $_;
	if (s#^$pm_dir/*##o) {
	    if (s#^$iacc_dir/*##o) {
		push @iacc, $1 if /^(.*)\.$iacc_suffix$/o;
		push @sick, $1 if /^(.*)\.$sick_suffix$/o;
		push @iasm, $1 if /^(.*)\.$iasm_suffix$/o;
	    }
	} elsif (m#^$bin_dir/#o) {
	    s/\s+\S+$//;
	    push @bin, $_;
	} elsif (s#^$html_dir/##o) {
	    push @htmlcopy, $1 if /^(.*\.$html_suffix)$/o;
	    push @htmlgen, $1 if /^(.*)\.$htmlgen_suffix$/o;
	}
    }
    close MANIFEST;

    my %req = (
	'Carp' => 0,
	'Exporter' => 0,
    );
    if ($req) {
	$req{$_} = $req->{$_} for keys %$req;
    }

    my @filter = ();
    my $gpath = $ENV{CLC_INTERCAL_PATH} || '.';
    if (-f "Generate") {
	# that's correct - if Generate exists HERE, execute one THERE
	# you are not supposed to understand that
	@filter = (PM_FILTER => "\$(PERL) $gpath/Generate"),
    }

    WriteMakefile(NAME => "Language::INTERCAL",
		  DISTNAME => "CLC-INTERCAL-$type",
		  EXE_FILES => \@bin,
		  VERSION => $VERSION,
		  PERL_MALLOC_OK => 1,
		  @filter,
		  PREREQ_PM => \%req,
		  dist => {
		      COMPRESS => 'gzip',
		      SUFFIX => '.gz',
		      DIST_DEFAULT => 'ddsh_dist',
		  },
		  clean => { FILES => 'iacc_to_io sick_to_io' },
    );
}

sub MY::constants {
    package MY;
    my $i = shift->SUPER::constants(@_);
    if ($ENV{CLC_INTERCAL_PATH}) {
	$i =~ s/^(PERL\s*=.*)$/$1 "-I$ENV{CLC_INTERCAL_PATH}\/\$(INST_ARCHLIB)" "-I$ENV{CLC_INTERCAL_PATH}\/\$(INST_LIB)"/gm;
	$i =~ s/^(FULLPERL\s*=.*)$/$1 "-I$ENV{CLC_INTERCAL_PATH}\/\$(INST_ARCHLIB)" "-I$ENV{CLC_INTERCAL_PATH}\/\$(INST_LIB)"/gm;
    }
    $i .= "\n# Needed to run iacc\n";
    $i .= "INST_IACC = \$(INST_LIB)/Language/INTERCAL/Include\n";
    $i .= "INST_HTMLDOC = blib/htmldoc\n";
    $i .= "SICK_OPTIONS = --nouserrc --batch --bug=0 --ubug=0 --stdtrace=/dev/null --notrace\n";
#    $i .= "SICK_OPTIONS += -v\n";
    $i .= "SICK = \$(FULLPERL) -I\$(INST_ARCHLIB) -I\$(INST_LIB) \\\n";
    my $sick;
    if ($has_distribute || $ENV{CLC_INTERCAL_PATH}) {
	my $gpath = $ENV{CLC_INTERCAL_PATH} || '.';
	$sick = "-I$gpath/\$(INST_ARCHLIB) -I$gpath/\$(INST_LIB) $gpath/\$(INST_SCRIPT)/sick";
    } else {
	$sick = "-S sick";
    }
    $i .= "\t-I\$(INST_ARCHLIB) -I\$(INST_LIB) $sick \\\n";
    $i .= "\t\$(SICK_OPTIONS)\n";
    $i .= "CLC_INTERCAL_TYPE = $type\n";
    $i;
}

sub MY::test {
    package MY;
    my $i = shift->SUPER::test(@_);
    if ($ENV{CLC_INTERCAL_PATH}) {
	$i =~ s/('\$\(INST_ARCHLIB\)')/$1, '$ENV{CLC_INTERCAL_PATH}\/\$(INST_ARCHLIB)', '$ENV{CLC_INTERCAL_PATH}\/\$(INST_LIB)'/gm;
	$i =~ s/("-I\$\(INST_ARCHLIB\)")/$1 "-I$ENV{CLC_INTERCAL_PATH}\/\$(INST_ARCHLIB)" "-I$ENV{CLC_INTERCAL_PATH}\/\$(INST_LIB)"/gm;
    }
    $i;
}

sub MY::postamble {
    package MY;
    my $i = shift->SUPER::postamble(@_);
    $i .= <<EOI for @iacc;
pure_all :: pm_to_blib \$(INST_IACC)/$_.io
	\$(NOECHO) \$(NOOP)

\$(INST_IACC)/$_.io : \$(INST_IACC)/$_.$iacc_suffix
	\$(SICK) -lObject -piacc --output \$(INST_IACC)/$_.io \$(INST_IACC)/$_.$iacc_suffix

EOI

    $i .= <<EOI for @sick;
pure_all :: \$(INST_IACC)/$_.io
	\$(NOECHO) \$(NOOP)

\$(INST_IACC)/$_.io : \$(INST_IACC)/sick.io \\
		\$(INST_IACC)/postpre.io \\
		\$(INST_IACC)/$_.$sick_suffix
	\$(SICK) -lObject -psick --output \$(INST_IACC)/$_.io \$(INST_IACC)/$_.$sick_suffix

EOI

    $i .= <<EOI for @iasm;
pure_all :: \$(INST_IACC)/$_.io
	\$(NOECHO) \$(NOOP)

\$(INST_IACC)/$_.io : \$(INST_IACC)/asm.io \\
		\$(INST_IACC)/postpre.io \\
		\$(INST_IACC)/$_.$iasm_suffix
	\$(SICK) -lObject -pasm --output \$(INST_IACC)/$_.io \$(INST_IACC)/$_.$iasm_suffix

EOI

    $i .= <<EOI for @htmlcopy;
all :: \$(INST_HTMLDOC)/$_
	\$(NOECHO) \$(NOOP)

\$(INST_HTMLDOC)/$_ : \$(INST_HTMLDOC)/\$(DFSEP).exists $html_dir/$_
	\$(CP) $html_dir/$_ \$(INST_HTMLDOC)/$_

EOI

    my $gpath = $ENV{CLC_INTERCAL_PATH} || '.';

    $i .= <<EOI for @htmlgen;
all :: \$(INST_HTMLDOC)/$_.$html_suffix
	\$(NOECHO) \$(NOOP)

\$(INST_HTMLDOC)/$_.$html_suffix : \$(INST_HTMLDOC)/\$(DFSEP).exists $gpath/Generate $html_dir/$_.$htmlgen_suffix
	CLC_INTERCAL_PATH=$gpath \$(PERL) $gpath/Generate $html_dir/$_.$htmlgen_suffix \$(INST_HTMLDOC)/$_.$html_suffix

EOI

    $i .= "\$(INST_HTMLDOC)/\$(DFSEP).exists :: Makefile.PL\n"
	. "\t\$(NOECHO) \$(MKPATH) \$(INST_HTMLDOC)\n"
	. "\t\$(NOECHO) \$(CHMOD) 755 \$(INST_HTMLDOC)\n"
	. "\t\$(NOECHO) \$(TOUCH) \$(INST_HTMLDOC)/\$(DFSEP).exists\n\n";

    $i;
};

sub MY::dist_core {
    package MY;
    my $i = shift->SUPER::dist_core(@_);
    my $D;
    if ($has_distribute || $ENV{CLC_INTERCAL_PATH}) {
	my $gpath = $ENV{CLC_INTERCAL_PATH} || '.';
	$D ="-e 'require \"$gpath/INTERCAL/Distribute.pm\";'";
    } else {
	$D = '-MLanguage::INTERCAL::Distribute';
    }
    $i .= <<'EOF';

ddsh_dist :
	$(RM_F) $(DISTVNAME).ddsh $(DISTVNAME).ddsh$(SUFFIX)
EOF
    $i .= "\t\$(PERL) $D \\\n";
    $i .= <<'EOF';
		-e 'Language::INTERCAL::Distribute::makeddshdist()' \
		'$(CLC_INTERCAL_TYPE)' MANIFEST '$(DISTVNAME).ddsh' '$(VERSION)'
	$(COMPRESS) $(DISTVNAME).ddsh

EOF
    $i;
}

1;
