//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// copyright            : (C) 2008 by Eran Ifrah                            
// file name            : openwindowspanel.h              
//                                                                          
// -------------------------------------------------------------------------
// A                                                                        
//              _____           _      _     _ _                            
//             /  __ \         | |    | |   (_) |                           
//             | /  \/ ___   __| | ___| |    _| |_ ___                      
//             | |    / _ \ / _  |/ _ \ |   | | __/ _ )                     
//             | \__/\ (_) | (_| |  __/ |___| | ||  __/                     
//              \____/\___/ \__,_|\___\_____/_|\__\___|                     
//                                                                          
//                                                  F i l e                 
//                                                                          
//    This program is free software; you can redistribute it and/or modify  
//    it under the terms of the GNU General Public License as published by  
//    the Free Software Foundation; either version 2 of the License, or     
//    (at your option) any later version.                                   
//                                                                          
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
#ifndef __openwindowspanel__
#define __openwindowspanel__

/**
@file
Subclass of OpenWindowsPanelBase, which is generated by wxFormBuilder.
*/

#include "openwindowspanelbase.h"

class LEditor;

/** Implementing OpenWindowsPanelBase */
class OpenWindowsPanel : public OpenWindowsPanelBase
{
    wxString m_caption;
    wxMenu *m_rclickMenu;
    
    int  EditorItem(LEditor *editor);
	void DoOpenSelectedItem(int item);
    void DoCloseSelectedItem(int item);
    
protected:
	// Handlers for OpenWindowsPanelBase events.
	void OnKeyDown( wxKeyEvent& event );
	void OnItemDClicked( wxCommandEvent& event );
	void OnRightUp( wxMouseEvent& event );
    void OnChar( wxKeyEvent& event );
    
	// Handlers for workspace events
    void OnActiveEditorChanged(wxCommandEvent &e);
    void OnEditorClosing(wxCommandEvent &e);
    void OnAllEditorsClosed(wxCommandEvent &e);
    
public:
	/** Constructor */
	OpenWindowsPanel( wxWindow* parent, const wxString &caption );
    ~OpenWindowsPanel();
    const wxString &GetCaption() const { return m_caption; }
};

#endif // __openwindowspanel__
