/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DOMObjectModel;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Sender;
import net.sf.saxon.javax.xml.xquery.XQCommonHandler;
import net.sf.saxon.javax.xml.xquery.XQDataSource;
import net.sf.saxon.javax.xml.xquery.XQException;
import net.sf.saxon.javax.xml.xquery.XQItem;
import net.sf.saxon.javax.xml.xquery.XQItemAccessor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pull.PullSource;
import net.sf.saxon.pull.StaxBridge;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.xqj.SaxonDuration;
import net.sf.saxon.xqj.SaxonXMLGregorianCalendar;
import net.sf.saxon.xqj.SaxonXQDataSource;
import net.sf.saxon.xqj.SaxonXQItem;
import org.w3c.dom.Node;

public class StandardDOMHandler
implements XQCommonHandler {
    Configuration config;

    public StandardDOMHandler(XQDataSource xQDataSource) {
        this.config = ((SaxonXQDataSource)xQDataSource).getConfiguration();
    }

    public XQItem fromObject(Object object) throws XQException {
        return new SaxonXQItem(this.convertToItem(object), this.config);
    }

    public Object toObject(XQItemAccessor xQItemAccessor) throws XQException {
        if (xQItemAccessor instanceof AtomicValue) {
            AtomicValue atomicValue = ((AtomicValue)((Object)xQItemAccessor)).getPrimitiveValue();
            int n = atomicValue.getItemType(this.config.getTypeHierarchy()).getPrimitiveType();
            switch (n) {
                case 529: {
                    return atomicValue.getStringValue();
                }
                case 528: {
                    return ((Base64BinaryValue)atomicValue).getBinaryValue();
                }
                case 514: {
                    return ((BooleanValue)atomicValue).getBooleanValue();
                }
                case 521: {
                    return new SaxonXMLGregorianCalendar((CalendarValue)atomicValue);
                }
                case 519: {
                    return new SaxonXMLGregorianCalendar((CalendarValue)atomicValue);
                }
                case 515: {
                    return ((DecimalValue)atomicValue).getValue();
                }
                case 517: {
                    return new Double(((DoubleValue)atomicValue).getDoubleValue());
                }
                case 518: {
                    return new SaxonDuration((DurationValue)atomicValue);
                }
                case 516: {
                    return new Float(((FloatValue)atomicValue).getFloatValue());
                }
                case 522: 
                case 523: 
                case 524: 
                case 525: 
                case 526: {
                    return new SaxonXMLGregorianCalendar((CalendarValue)atomicValue);
                }
                case 527: {
                    return ((HexBinaryValue)atomicValue).getBinaryValue();
                }
                case 532: {
                    if (atomicValue instanceof BigIntegerValue) {
                        return ((BigIntegerValue)atomicValue).getBigInteger();
                    }
                    int n2 = ((AtomicType)atomicValue.getItemType(null)).getFingerprint();
                    switch (n2) {
                        case 532: 
                        case 533: 
                        case 534: 
                        case 539: 
                        case 540: 
                        case 541: {
                            return BigInteger.valueOf(((IntegerValue)atomicValue).longValue());
                        }
                        case 538: {
                            return new Byte((byte)((IntegerValue)atomicValue).longValue());
                        }
                        case 536: 
                        case 543: {
                            return new Integer((int)((IntegerValue)atomicValue).longValue());
                        }
                        case 535: 
                        case 542: {
                            return new Long(((IntegerValue)atomicValue).longValue());
                        }
                        case 537: 
                        case 544: {
                            return new Short((short)((IntegerValue)atomicValue).longValue());
                        }
                    }
                    throw new XQException("Unrecognized integer subtype " + n2);
                }
                case 530: {
                    return ((QNameValue)atomicValue).makeQName(this.config);
                }
                case 513: {
                    return atomicValue.getStringValue();
                }
                case 520: {
                    return new SaxonXMLGregorianCalendar((CalendarValue)atomicValue);
                }
                case 645: {
                    return new SaxonDuration((DurationValue)atomicValue);
                }
                case 644: {
                    return new SaxonDuration((DurationValue)atomicValue);
                }
            }
            throw new XQException("unsupported type");
        }
        return NodeOverNodeInfo.wrap((NodeInfo)((NodeInfo)((Object)xQItemAccessor)));
    }

    public Item convertToItem(Object object) throws XQException {
        try {
            if (object instanceof Boolean) {
                return BooleanValue.get((Boolean)object);
            }
            if (object instanceof byte[]) {
                return new HexBinaryValue((byte[])object);
            }
            if (object instanceof Byte) {
                return new IntegerValue(((Byte)object).byteValue(), (AtomicType)BuiltInSchemaFactory.getSchemaType(538));
            }
            if (object instanceof Float) {
                return new FloatValue(((Float)object).floatValue());
            }
            if (object instanceof Double) {
                return new DoubleValue((Double)object);
            }
            if (object instanceof Integer) {
                return new IntegerValue(((Integer)object).intValue(), (AtomicType)BuiltInSchemaFactory.getSchemaType(536));
            }
            if (object instanceof Long) {
                return new IntegerValue((Long)object, (AtomicType)BuiltInSchemaFactory.getSchemaType(535));
            }
            if (object instanceof Short) {
                return new IntegerValue(((Short)object).shortValue(), (AtomicType)BuiltInSchemaFactory.getSchemaType(537));
            }
            if (object instanceof String) {
                return new UntypedAtomicValue((String)object);
            }
            if (object instanceof BigDecimal) {
                return new DecimalValue((BigDecimal)object);
            }
            if (object instanceof BigInteger) {
                return new BigIntegerValue((BigInteger)object);
            }
            if (object instanceof Duration) {
                return new DurationValue(((Duration)object).toString());
            }
            if (object instanceof XMLGregorianCalendar) {
                XMLGregorianCalendar xMLGregorianCalendar = (XMLGregorianCalendar)object;
                QName qName = xMLGregorianCalendar.getXMLSchemaType();
                if (qName.equals(DatatypeConstants.DATETIME)) {
                    return new DateTimeValue(qName.toString());
                }
                if (qName.equals(DatatypeConstants.DATE)) {
                    return new DateValue(qName.toString());
                }
                if (qName.equals(DatatypeConstants.TIME)) {
                    return new TimeValue(qName.toString());
                }
                if (qName.equals(DatatypeConstants.GYEAR)) {
                    return new GYearValue(qName.toString());
                }
                if (qName.equals(DatatypeConstants.GYEARMONTH)) {
                    return new GYearMonthValue(qName.toString());
                }
                if (qName.equals(DatatypeConstants.GMONTH)) {
                    return new GMonthValue(qName.toString());
                }
                if (qName.equals(DatatypeConstants.GMONTHDAY)) {
                    return new GMonthDayValue(qName.toString());
                }
                if (qName.equals(DatatypeConstants.GDAY)) {
                    return new GDayValue(qName.toString());
                }
                throw new AssertionError((Object)"Unknown Gregorian date type");
            }
            if (object instanceof QName) {
                QName qName = (QName)object;
                return new QNameValue(qName.getPrefix(), qName.getNamespaceURI(), qName.getLocalPart(), null);
            }
            if (object instanceof Node) {
                return (Item)((Object)new DOMObjectModel().convertObjectToXPathValue(object, this.config));
            }
            if (object instanceof Source) {
                TinyBuilder tinyBuilder = new TinyBuilder();
                PipelineConfiguration pipelineConfiguration = this.config.makePipelineConfiguration();
                tinyBuilder.setPipelineConfiguration(pipelineConfiguration);
                new Sender(pipelineConfiguration).send((Source)object, tinyBuilder);
                return tinyBuilder.getCurrentRoot();
            }
            if (object instanceof XMLStreamReader) {
                StaxBridge staxBridge = new StaxBridge();
                staxBridge.setXMLStreamReader((XMLStreamReader)object);
                TinyBuilder tinyBuilder = new TinyBuilder();
                PipelineConfiguration pipelineConfiguration = this.config.makePipelineConfiguration();
                tinyBuilder.setPipelineConfiguration(pipelineConfiguration);
                new Sender(pipelineConfiguration).send(new PullSource(staxBridge), tinyBuilder);
                return tinyBuilder.getCurrentRoot();
            }
            throw new DynamicError("Java object cannot be converted to an XQuery value");
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }
}

