struct cpuinfo_mock_file filesystem[] = {
#if CPUINFO_ARCH_ARM64
	{
		.path = "/proc/cpuinfo",
		.size = 554,
		.content =
			"Processor\t: AArch64 Processor rev 2 (aarch64)\n"
			"processor\t: 4\n"
			"model name\t: AArch64 Processor rev 2 (aarch64)\n"
			"BogoMIPS\t: 26.00\n"
			"BogoMIPS\t: 26.00\n"
			"Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32\n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 8\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd03\n"
			"CPU revision\t: 2\n"
			"\n"
			"processor\t: 5\n"
			"model name\t: AArch64 Processor rev 2 (aarch64)\n"
			"BogoMIPS\t: 26.00\n"
			"BogoMIPS\t: 26.00\n"
			"Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32\n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 8\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd03\n"
			"CPU revision\t: 2\n"
			"\n"
			"Hardware\t: MT6738\n",
	},
#elif CPUINFO_ARCH_ARM
	{
		.path = "/proc/cpuinfo",
		.size = 367,
		.content =
			"Processor\t: AArch64 Processor rev 2 (aarch64)\n"
			"processor\t: 4\n"
			"model name\t: AArch64 Processor rev 2 (aarch64)\n"
			"BogoMIPS\t: 26.00\n"
			"BogoMIPS\t: 26.00\n"
			"Features\t: half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt lpae evtstrm aes pmull sha1 sha2 crc32\n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 8\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd03\n"
			"CPU revision\t: 2\n"
			"\n"
			"Hardware\t: MT6738\n",
	},
#endif
	{
		.path = "/system/build.prop",
		.size = 9423,
		.content =
			"\n"
			"# begin build properties\n"
			"# autogenerated by buildinfo.sh\n"
			"ro.build.id=NRD90M\n"
			"ro.build.display.id=Android N\n"
			"ro.build.version.incremental=v6H7J-0\n"
			"ro.build.version.sdk=24\n"
			"ro.build.version.preview_sdk=0\n"
			"ro.build.version.codename=REL\n"
			"ro.build.version.all_codenames=REL\n"
			"ro.build.version.release=7.0\n"
			"ro.build.version.security_patch=2017-07-01\n"
			"ro.build.version.base_os=\n"
			"ro.build.date=Wed Aug  2 13:58:19 CST 2017\n"
			"ro.build.date.utc=1501653499\n"
			"ro.build.type=user\n"
			"ro.build.user=android-bld\n"
			"ro.build.host=Perso41\n"
			"ro.build.tags=release-keys\n"
			"ro.build.flavor=Mickey6TTMO-user\n"
			"ro.product.model=5049W\n"
			"ro.product.brand=TCL\n"
			"ro.product.name=5049W\n"
			"ro.product.device=Mickey6TTMO\n"
			"ro.product.board=\n"
			"# ro.product.cpu.abi and ro.product.cpu.abi2 are obsolete,\n"
			"# use ro.product.cpu.abilist instead.\n"
			"ro.product.cpu.abi=arm64-v8a\n"
			"ro.product.cpu.abilist=arm64-v8a,armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist32=armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist64=arm64-v8a\n"
			"ro.product.manufacturer=AlcatelOneTouch\n"
			"ro.wifi.channels=\n"
			"ro.board.platform=mt6750\n"
			"# ro.build.product is obsolete; use ro.product.device\n"
			"ro.build.product=Mickey6TTMO\n"
			"# Do not try to parse description, fingerprint, or thumbprint\n"
			"ro.build.description=Mickey6TTMO-user 7.0 NRD90M v6H7J-0 release-keys\n"
			"ro.build.fingerprint=TCL/5049W/Mickey6TTMO:7.0/NRD90M/v6H7J-0:user/release-keys\n"
			"ro.build.characteristics=default\n"
			"persist.disable.temperature=false\n"
			"ro.product.locales=\n"
			"ro.product.display.model=5049W\n"
			"ro.tct.sys.ver=Y6H7J0J0CM00\n"
			"ro.tct.boot.ver=B6H7J0J0CM00\n"
			"ro.tct.cust.ver=C6H7UMJ3CM00\n"
			"ro.tct.reco.ver=R6H7J0J0CM00\n"
			"# end build properties\n"
			"#\n"
			"#jrd sys properties\n"
			"#\n"
			"\n"
			"Modem.FD.supported.for.perso=true\n"
			"ro.product.locale.language=en\n"
			"ro.product.locale.region=US\n"
			"ro.com.google.clientidbase=android-alcatel\n"
			"ro.com.google.clientidbase.am=android-tmobile-us\n"
			"ro.com.google.clientidbase.ms=android-hms-tmobile-us\n"
			"gsm.version.baseband=c1-00006-8909_GEN_PACK-1.32621.1\n"
			"ro.def.software.svn=010 04\n"
			"def.israel.on=false\n"
			"def.settings.separate.volume=true\n"
			"persist.sys.phone.minmatch.len=10\n"
			"persist.sys.recovery.showtext=true\n"
			"ro.mtk_oma_drm_support=1\n"
			"ro.drm_popup_dialog=1\n"
			"persist.sys.phone.assistedstat=false\n"
			"ro.usb.product=T-Mobile Revvl\n"
			"ro.x.wap.profile=http://www-ccpp.tcl-ta.com/files/5049W.xml\n"
			"persist.sys.pwringtone.enable=1\n"
			"persist.sys.ringtonemode=2\n"
			"ro.config.power_on=Jumping_on_default.mp3\n"
			"ro.config.power_off=\n"
			"ro.config.ringtone=T-Jingle.mp3\n"
			"ro.config.alarm_alert=Galactic.mp3\n"
			"ro.bluetooth.name=T-Mobile Revvl\n"
			"ro.config.notification_sound=Success.mp3\n"
			"ro.setupwizard.require_network=\n"
			"feature_tctfw_mtp_on=0\n"
			"persist.radio.hotspot.support=0\n"
			"ro_set_nl_cb_on=false\n"
			"persist.sys.ssshot.threePointer=1\n"
			"ro.headset.sound.mode=0\n"
			"persist.sys.phone.refercountry=United States of America\n"
			"persist.sys.phone.countrycode=1\n"
			"persist.sys.phone.iddcode=011\n"
			"persist.sys.phone.nddcode=1\n"
			"persist.sys.phone.areasettings=Washington\n"
			"persist.sys.phone.citycode=206\n"
			"persist.sys.phone.numberlen=null\n"
			"ro.config.number.format=false\n"
			"ro.start.nextradio.service=true\n"
			"ro.config.videocall.show=true\n"
			"ecc.list.for.perso=911,112\n"
			"ecc.list.for.perso.no_sim=000,110,118,119,999,112,911\n"
			"ro.jrd.wfc.manager.operator=1\n"
			"ro.tcl_sar_support=1\n"
			"ro.def.software.version=H7JUMJ3\n"
			"ro.config.support_softsim=0\n"
			"persist.net.wo.keep_timer=300\n"
			"persist.net.wo.dpd_timer=300\n"
			"#\n"
			"# from device/jrdcsz/Mickey6TTMO/system.prop\n"
			"#\n"
			"#\n"
			"# system.prop for generic sdk\n"
			"#\n"
			"\n"
			"rild.libpath=mtk-ril.so\n"
			"rild.libargs=-d /dev/ttyC0\n"
			"\n"
			"\n"
			"# MTK, Infinity, 20090720 {\n"
			"wifi.interface=wlan0\n"
			"# MTK, Infinity, 20090720 }\n"
			"\n"
			"# MTK, mtk03034, 20101210 {\n"
			"ro.mediatek.wlan.wsc=1\n"
			"# MTK, mtk03034 20101210}\n"
			"# MTK, mtk03034, 20110318 {\n"
			"ro.mediatek.wlan.p2p=1\n"
			"# MTK, mtk03034 20110318}\n"
			"\n"
			"# MTK, mtk03034, 20101213 {\n"
			"mediatek.wlan.ctia=0\n"
			"# MTK, mtk03034 20101213}\n"
			"\n"
			"\n"
			"#\n"
			"wifi.tethering.interface=ap0\n"
			"#\n"
			"\n"
			"#Modify by hua.lei@tcl.com for cts Tetst\n"
			"#this value should be the same as Opengl Driver (Eg.3.2)\n"
			"ro.opengles.version=196610\n"
			"#ro.kernel.qemu=1\n"
			"#ro.kernel.qemu.gles=0\n"
			"\n"
			"wifi.direct.interface=p2p0\n"
			"dalvik.vm.heapgrowthlimit=256m\n"
			"dalvik.vm.heapsize=512m\n"
			"\n"
			"# USB MTP WHQL\n"
			"ro.sys.usb.mtp.whql.enable=0\n"
			"\n"
			"# Power off opt in IPO\n"
			"sys.ipo.pwrdncap=2\n"
			"\n"
			"ro.sys.usb.storage.type=mtp\n"
			"\n"
			"# USB BICR function\n"
			"ro.sys.usb.bicr=no\n"
			"\n"
			"# USB Charge only function\n"
			"ro.sys.usb.charging.only=yes\n"
			"\n"
			"# audio\n"
			"ro.camera.sound.forced=0\n"
			"ro.audio.silent=0\n"
			"\n"
			"ro.zygote.preload.enable=0\n"
			"\n"
			"# temporary enables NAV bar (soft keys)\n"
			"qemu.hw.mainkeys=0\n"
			"\n"
			"ro.kernel.zio=38,108,105,16\n"
			"#ro.kernel.qemu=1\n"
			"#ro.kernel.qemu.gles=0\n"
			"#ro.boot.selinux=disable\n"
			"\n"
			"\n"
			"ro.sf.lcd_density=480\n"
			"\n"
			"# performance\n"
			"ro.mtk_perf_simple_start_win=1\n"
			"ro.mtk_perf_fast_start_win=1\n"
			"ro.mtk_perf_response_time=1\n"
			"\n"
			"# MAL\n"
			"persist.mal.mode=0\n"
			"\n"
			"#add  by kai.yan@tcl.com for Defect 4355270 at 20170315\n"
			"persist.mtk_wfc_support=1\n"
			"persist.mtk.wfc.enable=1\n"
			"persist.dbg.wfc_avail_ovr=1\n"
			"\n"
			"#custom Dialer show video calling button\n"
			"ro.config.videocall.show=false\n"
			"\n"
			"#\n"
			"# ADDITIONAL_BUILD_PROPERTIES\n"
			"#\n"
			"ro.product.first_api_level=24\n"
			"ro.config.ringtone=Ring_Synth_04.ogg\n"
			"ro.config.notification_sound=pixiedust.ogg\n"
			"ro.carrier=unknown\n"
			"ro.config.alarm_alert=Alarm_Classic.ogg\n"
			"ro.setupwizard.require_network=ro.setupwizard.mode=OPTIONAL\n"
			"ro.com.google.gmsversion=7.0_r7\n"
			"dalvik.vm.heapgrowthlimit=256m\n"
			"dalvik.vm.heapsize=512m\n"
			"ro.mediatek.chip_ver=S01\n"
			"ro.mediatek.platform=MT6755\n"
			"ro.telephony.sim.count=2\n"
			"persist.radio.default.sim=0\n"
			"ro.feature_private_mode=true\n"
			"ril.specific.sm_cause=0\n"
			"bgw.current3gband=0\n"
			"ril.external.md=0\n"
			"ro.mtk_cam_lomo_support=1\n"
			"ro.sf.hwrotation=0\n"
			"ro.operator.optr=OP08\n"
			"ro.operator.spec=SPEC0200\n"
			"ro.operator.seg=SEGDEFAULT\n"
			"persist.operator.optr=OP08\n"
			"persist.operator.spec=SPEC0200\n"
			"persist.operator.seg=SEGDEFAULT\n"
			"persist.radio.fd.counter=150\n"
			"persist.radio.fd.off.counter=50\n"
			"persist.radio.fd.r8.counter=150\n"
			"persist.radio.fd.off.r8.counter=50\n"
			"drm.service.enabled=true\n"
			"fmradio.driver.enable=1\n"
			"ro.mtk_rebootmeta_support=0\n"
			"mtk.eccci.c2k=enabled\n"
			"ril.first.md=1\n"
			"ril.flightmode.poweroffMD=0\n"
			"ril.telephony.mode=0\n"
			"dalvik.vm.mtk-stack-trace-file=/data/anr/mtk_traces.txt\n"
			"mediatek.wlan.chip=CONSYS_MT6755\n"
			"mediatek.wlan.module.postfix=_consys_mt6755\n"
			"ril.radiooff.poweroffMD=0\n"
			"ro.frp.pst=/dev/block/platform/mtk-msdc.0/11230000.msdc0/by-name/frp\n"
			"ro.mtk_protocol1_rat_config=Lf/W/G\n"
			"ro.mediatek.version.branch=alps-mp-n0.mp7\n"
			"ro.mediatek.version.release=alps-mp-n0.mp7-V1.92_jrdsz6750.66.tm.n_P140\n"
			"ro.mediatek.version.sdk=4\n"
			"ro.num_md_protocol=2\n"
			"persist.radio.multisim.config=ss\n"
			"ro.mtk_besloudness_support=1\n"
			"ro.mtk_wapi_support=1\n"
			"ro.mtk_bt_support=1\n"
			"ro.mtk_wappush_support=1\n"
			"ro.mtk_agps_app=1\n"
			"ro.mtk_audio_tuning_tool_ver=V2.2\n"
			"ro.mtk_matv_analog_support=1\n"
			"ro.mtk_wlan_support=1\n"
			"ro.mtk_ipo_support=1\n"
			"ro.mtk_gps_support=1\n"
			"ro.mtk_omacp_support=1\n"
			"ro.mtk_search_db_support=1\n"
			"ro.mtk_dialer_search_support=1\n"
			"ro.mtk_dhcpv6c_wifi=1\n"
			"ro.have_aacencode_feature=1\n"
			"ro.mtk_fd_support=1\n"
			"ro.mtk_widevine_drm_l3_support=1\n"
			"ro.mtk_disable_cap_switch=1\n"
			"ro.mtk_eap_sim_aka=1\n"
			"ro.mtk_fm_recording_support=1\n"
			"ro.mtk_send_rr_support=1\n"
			"ro.mtk_emmc_support=1\n"
			"ro.mtk_tetheringipv6_support=1\n"
			"ro.telephony.default_network=9\n"
			"ro.mtk_shared_sdcard=1\n"
			"ro.mtk_enable_md1=1\n"
			"ro.mtk_afw_support=1\n"
			"ro.mtk_aal_support=1\n"
			"ro.mtk_pq_support=2\n"
			"ro.mtk_pq_color_mode=1\n"
			"ro.mtk_miravision_support=1\n"
			"ro.mtk_blulight_def_support=1\n"
			"ro.mtk_wfd_support=1\n"
			"ro.mtk_wifi_mcc_support=1\n"
			"ro.mtk_sim_hot_swap=1\n"
			"ro.mtk_bip_scws=1\n"
			"ro.mtk_world_phone_policy=0\n"
			"ro.mtk_md_world_mode_support=1\n"
			"ro.mtk_perfservice_support=1\n"
			"ro.mtk_cam_mfb_support=3\n"
			"ro.mtk_slow_motion_support=1\n"
			"ro.mtk_lte_support=1\n"
			"ro.sim_refresh_reset_by_modem=1\n"
			"ro.mtk_external_sim_only_slots=0\n"
			"ro.mtk_bg_power_saving_support=1\n"
			"ro.mtk_bg_power_saving_ui=1\n"
			"ro.have_aee_feature=1\n"
			"ro.sim_me_lock_mode=0\n"
			"ro.mtk_dual_mic_support=1\n"
			"ro.mtk_is_tablet=0\n"
			"ro.mtk_pow_perf_support=1\n"
			"persist.mtk_nlp_switch_support=1\n"
			"persist.mtk_ims_support=1\n"
			"ro.mtk_multiple_ims_support=1\n"
			"persist.mtk_wfc_support=1\n"
			"persist.mtk_vilte_support=1\n"
			"ro.mtk_vilte_ut_support=0\n"
			"persist.mtk_ussi_support=1\n"
			"wfd.dummy.enable=1\n"
			"wfd.iframesize.level=0\n"
			"ro.mediatek.project.path=device/jrdcsz/Mickey6TTMO\n"
			"ro.mtk_trustonic_tee_support=1\n"
			"persist.mtk.wcn.combo.chipid=-1\n"
			"persist.mtk.wcn.patch.version=-1\n"
			"persist.mtk.wcn.dynamic.dump=0\n"
			"service.wcn.driver.ready=no\n"
			"service.wcn.coredump.mode=0\n"
			"persist.mtk.connsys.poweron.ctl=0\n"
			"persist.mtk_epdg_support=1\n"
			"ro.com.android.mobiledata=true\n"
			"persist.radio.mobile.data=0,0\n"
			"persist.meta.dumpdata=0\n"
			"ro.mtk_deinterlace_support=1\n"
			"ro.mtk_md_sbp_custom_value=8\n"
			"ro.mtk_modem_monitor_support=1\n"
			"persist.radio.mtk_ps2_rat=W/G\n"
			"persist.radio.mtk_ps3_rat=G\n"
			"ro.boot.opt_c2k_lte_mode=0\n"
			"ro.boot.opt_md1_support=14\n"
			"ro.boot.opt_lte_support=1\n"
			"persist.log.tag.AT=I\n"
			"persist.log.tag.RILMUXD=I\n"
			"persist.log.tag.RILC-MTK=I\n"
			"persist.log.tag.RILC=I\n"
			"persist.log.tag.RfxMainThread=I\n"
			"persist.log.tag.RfxRoot=I\n"
			"persist.log.tag.RfxRilAdapter=I\n"
			"persist.log.tag.RfxController=I\n"
			"persist.log.tag.RILC-RP=I\n"
			"persist.log.tag.RIL-DATA=D\n"
			"ro.boot.opt_eccci_c2k=1\n"
			"ro.boot.opt_using_default=1\n"
			"mtk.vdec.waitkeyframeforplay=1\n"
			"ro.sys.sdcardfs=1\n"
			"persist.mtk.datashaping.support=1\n"
			"persist.datashaping.alarmgroup=1\n"
			"ro.media.maxmem=500000000\n"
			"ro.feature_amazon_support=0\n"
			"persist.mtk_rcs_ua_support=1\n"
			"persist.mtk_uce_ua_support=1\n"
			"persist.service.rcs.geolocation=1\n"
			"persist.mtk_volte_support=1\n"
			"persist.mtk.volte.enable=1\n"
			"persist.sys.dalvik.vm.lib.2=libart.so\n"
			"dalvik.vm.isa.arm64.variant=cortex-a53\n"
			"dalvik.vm.isa.arm64.features=default\n"
			"dalvik.vm.isa.arm.variant=cortex-a53\n"
			"dalvik.vm.isa.arm.features=default\n"
			"net.bt.name=Android\n"
			"dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			"persist.sys.usb.config=\n"
			"ro.expect.recovery_id=0x2f97b67aa16de7e155850b81d8d0b574e2e580c0000000000000000000000000\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "7\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 6,
		.content = "0,4-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 4,
		.content = "4-6\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 6,
		.content = "0-3,7\n",
	},
	{
		.path = "/sys/devices/system/cpu/modalias",
		.size = 66,
		.content = "cpu:type:aarch64:feature:,0000,0001,0002,0003,0004,0005,0006,0007\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/all_time_in_state",
		.size = 219,
		.content =
			"freq\t\tcpu0\t\tcpu1\t\tcpu2\t\tcpu3\t\tcpu4\t\tcpu5\t\tcpu6\t\tcpu7\t\t\n"
			"286000\t\t7\t\t7\t\t7\t\t\n"
			"663000\t\t0\t\t0\t\t0\t\t\n"
			"871000\t\t0\t\t0\t\t0\t\t\n"
			"1027000\t\t0\t\t0\t\t0\t\t\n"
			"1196000\t\t23\t\t23\t\t23\t\t\n"
			"1352000\t\t31\t\t31\t\t31\t\t\n"
			"1430000\t\t0\t\t0\t\t0\t\t\n"
			"1508000\t\t4673\t\t4673\t\t4673\t\t\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/current_in_state",
		.size = 664,
		.content =
			"CPU0:1508000=0 1430000=0 1352000=0 1196000=0 1027000=0 871000=0 663000=0 286000=0 \n"
			"CPU1:1508000=0 1430000=0 1352000=0 1196000=0 1027000=0 871000=0 663000=0 286000=0 \n"
			"CPU2:1508000=0 1430000=0 1352000=0 1196000=0 1027000=0 871000=0 663000=0 286000=0 \n"
			"CPU3:1508000=0 1430000=0 1352000=0 1196000=0 1027000=0 871000=0 663000=0 286000=0 \n"
			"CPU4:1508000=0 1430000=0 1352000=0 1196000=0 1027000=0 871000=0 663000=0 286000=0 \n"
			"CPU5:1508000=0 1430000=0 1352000=0 1196000=0 1027000=0 871000=0 663000=0 286000=0 \n"
			"CPU6:1508000=0 1430000=0 1352000=0 1196000=0 1027000=0 871000=0 663000=0 286000=0 \n"
			"CPU7:1508000=0 1430000=0 1352000=0 1196000=0 1027000=0 871000=0 663000=0 286000=0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_driver",
		.size = 18,
		.content = "mt67xx_v2_cpuidle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_governor_ro",
		.size = 13,
		.content = "mtk_governor\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/cpus_per_cluster",
		.size = 25,
		.content =
			"cluster0: f\n"
			"cluster1: f0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/glbinfo",
		.size = 72,
		.content =
			"big/little arch: yes\n"
			"nr_cups: 8\n"
			"nr_clusters: 2\n"
			"cluster0: f\n"
			"cluster1: f0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/is_big_little",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/is_multi_cluster",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/nr_clusters",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/affected_cpus",
		.size = 6,
		.content = "4 5 6\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1508000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "286000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/cpuinfo_transition_latency",
		.size = 5,
		.content = "1000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/related_cpus",
		.size = 8,
		.content = "4 5 6 7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_available_frequencies",
		.size = 62,
		.content = "1508000 1430000 1352000 1196000 1027000 871000 663000 286000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "ondemand userspace powersave interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1508000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_driver",
		.size = 11,
		.content = "mt-cpufreq\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1508000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "286000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/stats/time_in_state",
		.size = 88,
		.content =
			"1508000 5013\n"
			"1430000 12\n"
			"1352000 186\n"
			"1196000 25\n"
			"1027000 0\n"
			"871000 12\n"
			"663000 28\n"
			"286000 155\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/stats/total_trans",
		.size = 3,
		.content = "48\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpufreq/stats/trans_table",
		.size = 845,
		.content =
			"   From  :    To\n"
			"         :   1508000   1430000   1352000   1196000   1027000    871000    663000    286000 \n"
			"  1508000:         0         0         2         1         0         0         1         4 \n"
			"  1430000:         1         0         0         0         0         0         0         0 \n"
			"  1352000:         8         1         0         1         0         0         3         4 \n"
			"  1196000:         0         0         3         0         0         0         0         0 \n"
			"  1027000:         0         0         0         0         0         0         0         0 \n"
			"   871000:         0         0         1         1         0         0         0         1 \n"
			"   663000:         0         0         3         0         0         2         0         1 \n"
			"   286000:         0         0         8         0         0         0         2         0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/core_siblings",
		.size = 3,
		.content = "f0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/core_siblings_list",
		.size = 4,
		.content = "4-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/physical_package_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/thread_siblings",
		.size = 3,
		.content = "10\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/topology/thread_siblings_list",
		.size = 2,
		.content = "4\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "ondemand userspace powersave interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1352000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_driver",
		.size = 11,
		.content = "mt-cpufreq\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1508000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "286000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/cpufreq/cpuinfo_transition_latency",
		.size = 5,
		.content = "1000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/cpufreq/related_cpus",
		.size = 8,
		.content = "4 5 6 7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/cpufreq/scaling_available_frequencies",
		.size = 62,
		.content = "1508000 1430000 1352000 1196000 1027000 871000 663000 286000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "ondemand userspace powersave interactive performance \n",
	},
	{ NULL },
};
#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "Modem.FD.supported.for.perso",
		.value = "true",
	},
	{
		.key = "af.music.outputid",
		.value = "3",
	},
	{
		.key = "bgw.current3gband",
		.value = "0",
	},
	{
		.key = "camera.disable_zsl_mode",
		.value = "1",
	},
	{
		.key = "cdma.ril.ecclist",
		.value = "",
	},
	{
		.key = "dalvik.vm.appimageformat",
		.value = "lz4",
	},
	{
		.key = "dalvik.vm.dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.dex2oat-Xmx",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "256m",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xmx",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.isa.arm.features",
		.value = "default",
	},
	{
		.key = "dalvik.vm.isa.arm.variant",
		.value = "cortex-a53",
	},
	{
		.key = "dalvik.vm.isa.arm64.features",
		.value = "default",
	},
	{
		.key = "dalvik.vm.isa.arm64.variant",
		.value = "cortex-a53",
	},
	{
		.key = "dalvik.vm.mtk-stack-trace-file",
		.value = "/data/anr/mtk_traces.txt",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "dalvik.vm.usejit",
		.value = "true",
	},
	{
		.key = "dalvik.vm.usejitprofiles",
		.value = "true",
	},
	{
		.key = "debug.MB.running",
		.value = "0",
	},
	{
		.key = "debug.atrace.tags.enableflags",
		.value = "0",
	},
	{
		.key = "debug.force_rtl",
		.value = "0",
	},
	{
		.key = "debug.hwc.bq_count",
		.value = "4",
	},
	{
		.key = "debug.hwc.compose_level",
		.value = "0",
	},
	{
		.key = "debug.mdlogger.Running",
		.value = "0",
	},
	{
		.key = "debug.mdlogger.log2sd.path",
		.value = "internal_sd",
	},
	{
		.key = "debug.mtk.aee.status",
		.value = "free",
	},
	{
		.key = "debug.mtk.aee.status64",
		.value = "free",
	},
	{
		.key = "debug.mtklog.netlog.Running",
		.value = "0",
	},
	{
		.key = "def.israel.on",
		.value = "false",
	},
	{
		.key = "def.settings.separate.volume",
		.value = "true",
	},
	{
		.key = "dev.bootcomplete",
		.value = "1",
	},
	{
		.key = "drm.service.enabled",
		.value = "true",
	},
	{
		.key = "ecc.list.for.perso",
		.value = "911,112",
	},
	{
		.key = "ecc.list.for.perso.no_sim",
		.value = "000,110,118,119,999,112,911",
	},
	{
		.key = "feature_tctfw_mtp_on",
		.value = "0",
	},
	{
		.key = "fmradio.driver.enable",
		.value = "1",
	},
	{
		.key = "gps.clock.type",
		.value = "20",
	},
	{
		.key = "gps.gps.version",
		.value = "0x6755",
	},
	{
		.key = "gsm.baseband.capability",
		.value = "1023",
	},
	{
		.key = "gsm.current.phone-type",
		.value = "1",
	},
	{
		.key = "gsm.gcf.testmode",
		.value = "0",
	},
	{
		.key = "gsm.lte.ca.support",
		.value = "1",
	},
	{
		.key = "gsm.network.type",
		.value = "Unknown",
	},
	{
		.key = "gsm.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.operator.iso-country",
		.value = "",
	},
	{
		.key = "gsm.operator.isroaming",
		.value = "false",
	},
	{
		.key = "gsm.operator.numeric",
		.value = "",
	},
	{
		.key = "gsm.project.baseband",
		.value = "JRDSZ6750_66_TM_N(LWCTG_MP5)",
	},
	{
		.key = "gsm.ril.ct3g",
		.value = "0",
	},
	{
		.key = "gsm.ril.eboot",
		.value = "-1",
	},
	{
		.key = "gsm.ril.init",
		.value = "1",
	},
	{
		.key = "gsm.ril.uicctype",
		.value = "USIM",
	},
	{
		.key = "gsm.serial",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.iso-country",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.numeric",
		.value = "",
	},
	{
		.key = "gsm.sim.retry.pin1",
		.value = "",
	},
	{
		.key = "gsm.sim.retry.pin2",
		.value = "",
	},
	{
		.key = "gsm.sim.retry.puk1",
		.value = "",
	},
	{
		.key = "gsm.sim.retry.puk2",
		.value = "",
	},
	{
		.key = "gsm.sim.ril.mcc.mnc",
		.value = "",
	},
	{
		.key = "gsm.sim.ril.phbready",
		.value = "",
	},
	{
		.key = "gsm.sim.state",
		.value = "ABSENT",
	},
	{
		.key = "gsm.version.baseband",
		.value = "MOLY.LR11.W1630.MD.MP.V16.3.T200323, 2017/07/31 14:52",
	},
	{
		.key = "gsm.version.ril-impl",
		.value = "android reference-ril 1.0",
	},
	{
		.key = "gsm.wfc.status",
		.value = "98",
	},
	{
		.key = "init.svc.MtkCodecService",
		.value = "running",
	},
	{
		.key = "init.svc.NvRAMAgent",
		.value = "running",
	},
	{
		.key = "init.svc.aal",
		.value = "running",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.agpsd",
		.value = "running",
	},
	{
		.key = "init.svc.akmd09916",
		.value = "running",
	},
	{
		.key = "init.svc.audioserver",
		.value = "running",
	},
	{
		.key = "init.svc.bootanim",
		.value = "stopped",
	},
	{
		.key = "init.svc.bootlogoupdater",
		.value = "stopped",
	},
	{
		.key = "init.svc.cameraserver",
		.value = "running",
	},
	{
		.key = "init.svc.ccci3_fsd",
		.value = "stopped",
	},
	{
		.key = "init.svc.ccci3_mdinit",
		.value = "stopped",
	},
	{
		.key = "init.svc.ccci_fsd",
		.value = "running",
	},
	{
		.key = "init.svc.ccci_mdinit",
		.value = "running",
	},
	{
		.key = "init.svc.clear-bcb",
		.value = "stopped",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.debuggerd64",
		.value = "running",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.emdlogger1",
		.value = "running",
	},
	{
		.key = "init.svc.enableswap",
		.value = "stopped",
	},
	{
		.key = "init.svc.epdg_wod",
		.value = "running",
	},
	{
		.key = "init.svc.fingerprintd",
		.value = "running",
	},
	{
		.key = "init.svc.flash_recovery",
		.value = "stopped",
	},
	{
		.key = "init.svc.forcc",
		.value = "running",
	},
	{
		.key = "init.svc.fuelgauged",
		.value = "running",
	},
	{
		.key = "init.svc.fuelgauged_nvram",
		.value = "stopped",
	},
	{
		.key = "init.svc.gatekeeperd",
		.value = "running",
	},
	{
		.key = "init.svc.ged_srv",
		.value = "running",
	},
	{
		.key = "init.svc.goodixfpd",
		.value = "running",
	},
	{
		.key = "init.svc.gsm0710muxd",
		.value = "running",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.ipsec_mon",
		.value = "running",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.lmkd",
		.value = "running",
	},
	{
		.key = "init.svc.logd",
		.value = "running",
	},
	{
		.key = "init.svc.logd-reinit",
		.value = "stopped",
	},
	{
		.key = "init.svc.mal-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.md_monitor",
		.value = "running",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.mediacodec",
		.value = "running",
	},
	{
		.key = "init.svc.mediadrm",
		.value = "running",
	},
	{
		.key = "init.svc.mediaextractor",
		.value = "running",
	},
	{
		.key = "init.svc.mnld",
		.value = "running",
	},
	{
		.key = "init.svc.mobicore",
		.value = "running",
	},
	{
		.key = "init.svc.mobile_log_d",
		.value = "running",
	},
	{
		.key = "init.svc.msensord",
		.value = "stopped",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.netdiag",
		.value = "running",
	},
	{
		.key = "init.svc.nvram_daemon",
		.value = "stopped",
	},
	{
		.key = "init.svc.otp_status",
		.value = "stopped",
	},
	{
		.key = "init.svc.pq",
		.value = "running",
	},
	{
		.key = "init.svc.program_binary",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon-mtk",
		.value = "running",
	},
	{
		.key = "init.svc.ril-proxy",
		.value = "running",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.slpd",
		.value = "running",
	},
	{
		.key = "init.svc.sn",
		.value = "running",
	},
	{
		.key = "init.svc.spm_script",
		.value = "stopped",
	},
	{
		.key = "init.svc.start_modem",
		.value = "stopped",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.sysenv_daemon",
		.value = "running",
	},
	{
		.key = "init.svc.terservice",
		.value = "stopped",
	},
	{
		.key = "init.svc.thermal",
		.value = "running",
	},
	{
		.key = "init.svc.thermal_manager",
		.value = "stopped",
	},
	{
		.key = "init.svc.thermald",
		.value = "running",
	},
	{
		.key = "init.svc.thermalloadalgod",
		.value = "running",
	},
	{
		.key = "init.svc.traceability",
		.value = "stopped",
	},
	{
		.key = "init.svc.tsdaemon",
		.value = "running",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.volte_imcb",
		.value = "running",
	},
	{
		.key = "init.svc.volte_stack",
		.value = "running",
	},
	{
		.key = "init.svc.volte_ua",
		.value = "running",
	},
	{
		.key = "init.svc.vtservice",
		.value = "running",
	},
	{
		.key = "init.svc.wfca",
		.value = "running",
	},
	{
		.key = "init.svc.wifi2agps",
		.value = "running",
	},
	{
		.key = "init.svc.wmt_launcher",
		.value = "running",
	},
	{
		.key = "init.svc.wmt_loader",
		.value = "stopped",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "init.svc.zygote_secondary",
		.value = "running",
	},
	{
		.key = "log.tag",
		.value = "E",
	},
	{
		.key = "media.wfd.portrait",
		.value = "0",
	},
	{
		.key = "media.wfd.video-format",
		.value = "5",
	},
	{
		.key = "mediatek.wlan.chip",
		.value = "CONSYS_MT6755",
	},
	{
		.key = "mediatek.wlan.ctia",
		.value = "0",
	},
	{
		.key = "mediatek.wlan.module.postfix",
		.value = "_consys_mt6755",
	},
	{
		.key = "mtk.eccci.c2k",
		.value = "enabled",
	},
	{
		.key = "mtk.md1.status",
		.value = "ready",
	},
	{
		.key = "mtk.vdec.waitkeyframeforplay",
		.value = "1",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.qtaguid_enabled",
	},
	{
		.key = "net.hostname",
		.value = "android-5ead78d5af20d7b2",
	},
	{
		.key = "net.ims.ipsec.version",
		.value = "2.0",
	},
	{
		.key = "net.nsiot_pending",
		.value = "false",
	},
	{
		.key = "net.perf.cpu.core",
		.value = "4,4,0,0",
	},
	{
		.key = "net.perf.cpu.freq",
		.value = "1144000,1144000,0,0",
	},
	{
		.key = "net.perf.rps",
		.value = "ff",
	},
	{
		.key = "net.qtaguid_enabled",
		.value = "1",
	},
	{
		.key = "net.tcp.default_init_rwnd",
		.value = "60",
	},
	{
		.key = "partition.custpack.verified",
		.value = "2",
	},
	{
		.key = "partition.system.verified",
		.value = "2",
	},
	{
		.key = "persist.af.hac_on",
		.value = "0",
	},
	{
		.key = "persist.datashaping.alarmgroup",
		.value = "1",
	},
	{
		.key = "persist.dbg.wfc_avail_ovr",
		.value = "1",
	},
	{
		.key = "persist.log.tag.AT",
		.value = "I",
	},
	{
		.key = "persist.log.tag.RIL-DATA",
		.value = "D",
	},
	{
		.key = "persist.log.tag.RILC",
		.value = "I",
	},
	{
		.key = "persist.log.tag.RILC-MTK",
		.value = "I",
	},
	{
		.key = "persist.log.tag.RILC-RP",
		.value = "I",
	},
	{
		.key = "persist.log.tag.RILMUXD",
		.value = "I",
	},
	{
		.key = "persist.log.tag.RfxController",
		.value = "I",
	},
	{
		.key = "persist.log.tag.RfxMainThread",
		.value = "I",
	},
	{
		.key = "persist.log.tag.RfxRilAdapter",
		.value = "I",
	},
	{
		.key = "persist.log.tag.RfxRoot",
		.value = "I",
	},
	{
		.key = "persist.mal.mode",
		.value = "0",
	},
	{
		.key = "persist.meta.dumpdata",
		.value = "0",
	},
	{
		.key = "persist.mtk.connsys.poweron.ctl",
		.value = "0",
	},
	{
		.key = "persist.mtk.datashaping.support",
		.value = "1",
	},
	{
		.key = "persist.mtk.ims.video.enable",
		.value = "1",
	},
	{
		.key = "persist.mtk.volte.enable",
		.value = "1",
	},
	{
		.key = "persist.mtk.wcn.combo.chipid",
		.value = "0x6755",
	},
	{
		.key = "persist.mtk.wcn.dynamic.dump",
		.value = "0",
	},
	{
		.key = "persist.mtk.wcn.patch.version",
		.value = "20170220100539a",
	},
	{
		.key = "persist.mtk.wfc.enable",
		.value = "1",
	},
	{
		.key = "persist.mtk_epdg_support",
		.value = "1",
	},
	{
		.key = "persist.mtk_ims_support",
		.value = "1",
	},
	{
		.key = "persist.mtk_nlp_switch_support",
		.value = "1",
	},
	{
		.key = "persist.mtk_rcs_ua_support",
		.value = "1",
	},
	{
		.key = "persist.mtk_uce_ua_support",
		.value = "1",
	},
	{
		.key = "persist.mtk_ussi_support",
		.value = "1",
	},
	{
		.key = "persist.mtk_vilte_support",
		.value = "1",
	},
	{
		.key = "persist.mtk_volte_support",
		.value = "1",
	},
	{
		.key = "persist.mtk_wfc_support",
		.value = "1",
	},
	{
		.key = "persist.net.wo.dpd_timer",
		.value = "300",
	},
	{
		.key = "persist.net.wo.keep_timer",
		.value = "300",
	},
	{
		.key = "persist.operator.optr",
		.value = "OP08",
	},
	{
		.key = "persist.operator.seg",
		.value = "SEGDEFAULT",
	},
	{
		.key = "persist.operator.spec",
		.value = "SPEC0200",
	},
	{
		.key = "persist.radio.default.sim",
		.value = "0",
	},
	{
		.key = "persist.radio.fd.counter",
		.value = "150",
	},
	{
		.key = "persist.radio.fd.off.counter",
		.value = "50",
	},
	{
		.key = "persist.radio.fd.off.r8.counter",
		.value = "50",
	},
	{
		.key = "persist.radio.fd.r8.counter",
		.value = "150",
	},
	{
		.key = "persist.radio.hotspot.support",
		.value = "0",
	},
	{
		.key = "persist.radio.mobile.data",
		.value = "0,0",
	},
	{
		.key = "persist.radio.mtk_ps2_rat",
		.value = "W/G",
	},
	{
		.key = "persist.radio.mtk_ps3_rat",
		.value = "G",
	},
	{
		.key = "persist.radio.multisim.config",
		.value = "ss",
	},
	{
		.key = "persist.radio.reset_on_switch",
		.value = "false",
	},
	{
		.key = "persist.radio.simswitch",
		.value = "1",
	},
	{
		.key = "persist.service.acm.enable",
		.value = "0",
	},
	{
		.key = "persist.service.bdroid.bdaddr",
		.value = "22:22:4c:ad:26:6d",
	},
	{
		.key = "persist.service.rcs.geolocation",
		.value = "1",
	},
	{
		.key = "persist.service.stk.shutdown",
		.value = "0",
	},
	{
		.key = "persist.sys.dalvik.vm.lib.2",
		.value = "libart.so",
	},
	{
		.key = "persist.sys.first_time_boot",
		.value = "false",
	},
	{
		.key = "persist.sys.fp.navigation",
		.value = "1",
	},
	{
		.key = "persist.sys.google.enabled",
		.value = "1",
	},
	{
		.key = "persist.sys.init.locationmode",
		.value = "true",
	},
	{
		.key = "persist.sys.locale",
		.value = "en-US",
	},
	{
		.key = "persist.sys.mute.state",
		.value = "2",
	},
	{
		.key = "persist.sys.nlp.enabled",
		.value = "0",
	},
	{
		.key = "persist.sys.overlaystate",
		.value = "0",
	},
	{
		.key = "persist.sys.phone.areasettings",
		.value = "Washington",
	},
	{
		.key = "persist.sys.phone.assistedstat",
		.value = "false",
	},
	{
		.key = "persist.sys.phone.citycode",
		.value = "206",
	},
	{
		.key = "persist.sys.phone.countrycode",
		.value = "1",
	},
	{
		.key = "persist.sys.phone.iddcode",
		.value = "011",
	},
	{
		.key = "persist.sys.phone.minmatch.len",
		.value = "10",
	},
	{
		.key = "persist.sys.phone.nddcode",
		.value = "1",
	},
	{
		.key = "persist.sys.phone.numberlen",
		.value = "null",
	},
	{
		.key = "persist.sys.phone.refercountry",
		.value = "United States of America",
	},
	{
		.key = "persist.sys.pq.adl.idx",
		.value = "0",
	},
	{
		.key = "persist.sys.pq.iso.shp.en",
		.value = "1",
	},
	{
		.key = "persist.sys.pq.log.en",
		.value = "0",
	},
	{
		.key = "persist.sys.pq.mdp.color.dbg",
		.value = "1",
	},
	{
		.key = "persist.sys.pq.mdp.color.idx",
		.value = "0",
	},
	{
		.key = "persist.sys.pq.shp.idx",
		.value = "2",
	},
	{
		.key = "persist.sys.pq.ultrares.en",
		.value = "1",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.pwringtone.enable",
		.value = "1",
	},
	{
		.key = "persist.sys.recovery.showtext",
		.value = "true",
	},
	{
		.key = "persist.sys.ringtonemode",
		.value = "2",
	},
	{
		.key = "persist.sys.sd.defaultpath",
		.value = "/storage/emulated/0",
	},
	{
		.key = "persist.sys.ssshot.threePointer",
		.value = "1",
	},
	{
		.key = "persist.sys.timezone",
		.value = "America/New_York",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "persist.sys.webview.vmsize",
		.value = "112775696",
	},
	{
		.key = "pm.dexopt.ab-ota",
		.value = "speed-profile",
	},
	{
		.key = "pm.dexopt.bg-dexopt",
		.value = "speed-profile",
	},
	{
		.key = "pm.dexopt.boot",
		.value = "verify-profile",
	},
	{
		.key = "pm.dexopt.core-app",
		.value = "speed",
	},
	{
		.key = "pm.dexopt.first-boot",
		.value = "interpret-only",
	},
	{
		.key = "pm.dexopt.forced-dexopt",
		.value = "speed",
	},
	{
		.key = "pm.dexopt.install",
		.value = "interpret-only",
	},
	{
		.key = "pm.dexopt.nsys-library",
		.value = "speed",
	},
	{
		.key = "pm.dexopt.shared-apk",
		.value = "speed",
	},
	{
		.key = "qemu.hw.mainkeys",
		.value = "0",
	},
	{
		.key = "ril.active.md",
		.value = "14",
	},
	{
		.key = "ril.apc.support",
		.value = "1",
	},
	{
		.key = "ril.cdma.card.type.1",
		.value = "",
	},
	{
		.key = "ril.cdma.switching",
		.value = "0",
	},
	{
		.key = "ril.ecc.service.category.list",
		.value = "",
	},
	{
		.key = "ril.ecclist",
		.value = "",
	},
	{
		.key = "ril.external.md",
		.value = "0",
	},
	{
		.key = "ril.fd.mode",
		.value = "1",
	},
	{
		.key = "ril.first.md",
		.value = "1",
	},
	{
		.key = "ril.flightmode.poweroffMD",
		.value = "0",
	},
	{
		.key = "ril.ia.iccid",
		.value = "",
	},
	{
		.key = "ril.imsi.status.sim1",
		.value = "0",
	},
	{
		.key = "ril.ipo.radiooff",
		.value = "0",
	},
	{
		.key = "ril.mal.flag",
		.value = "0",
	},
	{
		.key = "ril.mal.socket",
		.value = "rilproxy-mal",
	},
	{
		.key = "ril.md_changed_apn_class.iccid0",
		.value = "",
	},
	{
		.key = "ril.md_changed_apn_class0",
		.value = "",
	},
	{
		.key = "ril.mux.ee.md1",
		.value = "0",
	},
	{
		.key = "ril.mux.report.case",
		.value = "0",
	},
	{
		.key = "ril.nw.worldmode.activemode",
		.value = "1",
	},
	{
		.key = "ril.phone1.mapped.md",
		.value = "MD1",
	},
	{
		.key = "ril.pid.1",
		.value = "1342",
	},
	{
		.key = "ril.radiooff.poweroffMD",
		.value = "0",
	},
	{
		.key = "ril.rilproxy",
		.value = "1",
	},
	{
		.key = "ril.specific.sm_cause",
		.value = "0",
	},
	{
		.key = "ril.telephony.mode",
		.value = "0",
	},
	{
		.key = "ril.volte.mal.latency",
		.value = "65535",
	},
	{
		.key = "ril.volte.mal.opkey",
		.value = "0x0039",
	},
	{
		.key = "ril.volte.mal.pkterrth",
		.value = "99",
	},
	{
		.key = "ril.volte.mal.rb_hoddc_t",
		.value = "3",
	},
	{
		.key = "ril.volte.mal.rb_hol2w_t",
		.value = "10",
	},
	{
		.key = "ril.volte.mal.rb_how2l_t",
		.value = "150",
	},
	{
		.key = "ril.volte.mal.retranth",
		.value = "99",
	},
	{
		.key = "ril.volte.mal.throupt",
		.value = "65535",
	},
	{
		.key = "ril.volte.mal.vijit",
		.value = "3",
	},
	{
		.key = "ril.volte.mal.vojit",
		.value = "26",
	},
	{
		.key = "rild.libargs",
		.value = "-d /dev/ttyC0",
	},
	{
		.key = "rild.libpath",
		.value = "mtk-ril.so",
	},
	{
		.key = "rild.mark_switchuser",
		.value = "0",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.audio.silent",
		.value = "0",
	},
	{
		.key = "ro.baseband",
		.value = "unknown",
	},
	{
		.key = "ro.bluetooth.name",
		.value = "T-Mobile Revvl",
	},
	{
		.key = "ro.board.platform",
		.value = "mt6750",
	},
	{
		.key = "ro.board_info",
		.value = "PROTO",
	},
	{
		.key = "ro.boot.bootreason",
		.value = "wdt_by_pass_pwk",
	},
	{
		.key = "ro.boot.efuse_status",
		.value = "1",
	},
	{
		.key = "ro.boot.flash.locked",
		.value = "1",
	},
	{
		.key = "ro.boot.hardware",
		.value = "mt6755",
	},
	{
		.key = "ro.boot.mode",
		.value = "normal",
	},
	{
		.key = "ro.boot.opt_c2k_lte_mode",
		.value = "0",
	},
	{
		.key = "ro.boot.opt_c2k_support",
		.value = "0",
	},
	{
		.key = "ro.boot.opt_eccci_c2k",
		.value = "1",
	},
	{
		.key = "ro.boot.opt_irat_support",
		.value = "0",
	},
	{
		.key = "ro.boot.opt_lte_support",
		.value = "1",
	},
	{
		.key = "ro.boot.opt_md1_support",
		.value = "14",
	},
	{
		.key = "ro.boot.opt_md3_support",
		.value = "0",
	},
	{
		.key = "ro.boot.opt_using_default",
		.value = "1",
	},
	{
		.key = "ro.boot.serialno",
		.value = "EIBUB6EIZ5ORSGY5",
	},
	{
		.key = "ro.boot.verifiedbootstate",
		.value = "green",
	},
	{
		.key = "ro.bootimage.build.date",
		.value = "Mon Jul 31 14:57:05 CST 2017",
	},
	{
		.key = "ro.bootimage.build.date.utc",
		.value = "1501484225",
	},
	{
		.key = "ro.bootimage.build.fingerprint",
		.value = "TCL/5049Z/Mickey6TTMO:7.0/NRD90M/v6H7J-0:user/release-keys",
	},
	{
		.key = "ro.bootloader",
		.value = "unknown",
	},
	{
		.key = "ro.bootmode",
		.value = "normal",
	},
	{
		.key = "ro.build.characteristics",
		.value = "default",
	},
	{
		.key = "ro.build.date",
		.value = "Wed Aug  2 13:58:19 CST 2017",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1501653499",
	},
	{
		.key = "ro.build.description",
		.value = "Mickey6TTMO-user 7.0 NRD90M v6H7J-0 release-keys",
	},
	{
		.key = "ro.build.display.id",
		.value = "Android N",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "TCL/5049W/Mickey6TTMO:7.0/NRD90M/v6H7J-0:user/release-keys",
	},
	{
		.key = "ro.build.flavor",
		.value = "Mickey6TTMO-user",
	},
	{
		.key = "ro.build.host",
		.value = "Perso41",
	},
	{
		.key = "ro.build.id",
		.value = "NRD90M",
	},
	{
		.key = "ro.build.product",
		.value = "Mickey6TTMO",
	},
	{
		.key = "ro.build.tags",
		.value = "release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.user",
		.value = "android-bld",
	},
	{
		.key = "ro.build.version.all_codenames",
		.value = "REL",
	},
	{
		.key = "ro.build.version.base_os",
		.value = "",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "v6H7J-0",
	},
	{
		.key = "ro.build.version.preview_sdk",
		.value = "0",
	},
	{
		.key = "ro.build.version.release",
		.value = "7.0",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "24",
	},
	{
		.key = "ro.build.version.security_patch",
		.value = "2017-07-01",
	},
	{
		.key = "ro.camera.sound.forced",
		.value = "0",
	},
	{
		.key = "ro.carrier",
		.value = "unknown",
	},
	{
		.key = "ro.com.android.mobiledata",
		.value = "true",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-alcatel",
	},
	{
		.key = "ro.com.google.clientidbase.am",
		.value = "android-tmobile-us",
	},
	{
		.key = "ro.com.google.clientidbase.ms",
		.value = "android-hms-tmobile-us",
	},
	{
		.key = "ro.com.google.gmsversion",
		.value = "7.0_r7",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "Galactic.mp3",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "Success.mp3",
	},
	{
		.key = "ro.config.number.format",
		.value = "false",
	},
	{
		.key = "ro.config.power_off",
		.value = "",
	},
	{
		.key = "ro.config.power_on",
		.value = "Jumping_on_default.mp3",
	},
	{
		.key = "ro.config.ringtone",
		.value = "T-Jingle.mp3",
	},
	{
		.key = "ro.config.support_softsim",
		.value = "0",
	},
	{
		.key = "ro.config.videocall.show",
		.value = "true",
	},
	{
		.key = "ro.crypto.fs_crypto_blkdev",
		.value = "/dev/block/dm-2",
	},
	{
		.key = "ro.crypto.state",
		.value = "encrypted",
	},
	{
		.key = "ro.crypto.type",
		.value = "block",
	},
	{
		.key = "ro.dalvik.vm.native.bridge",
		.value = "0",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.def.software.svn",
		.value = "010 04",
	},
	{
		.key = "ro.def.software.version",
		.value = "H7JUMJ3",
	},
	{
		.key = "ro.drm_popup_dialog",
		.value = "1",
	},
	{
		.key = "ro.expect.recovery_id",
		.value = "0x2f97b67aa16de7e155850b81d8d0b574e2e580c0000000000000000000000000",
	},
	{
		.key = "ro.feature_amazon_support",
		.value = "0",
	},
	{
		.key = "ro.feature_private_mode",
		.value = "true",
	},
	{
		.key = "ro.frp.pst",
		.value = "/dev/block/platform/mtk-msdc.0/11230000.msdc0/by-name/frp",
	},
	{
		.key = "ro.hardware",
		.value = "mt6755",
	},
	{
		.key = "ro.have_aacencode_feature",
		.value = "1",
	},
	{
		.key = "ro.have_aee_feature",
		.value = "1",
	},
	{
		.key = "ro.headset.sound.mode",
		.value = "0",
	},
	{
		.key = "ro.jrd.wfc.manager.operator",
		.value = "1",
	},
	{
		.key = "ro.kernel.zio",
		.value = "38,108,105,16",
	},
	{
		.key = "ro.media.maxmem",
		.value = "500000000",
	},
	{
		.key = "ro.mediatek.chip_ver",
		.value = "S01",
	},
	{
		.key = "ro.mediatek.platform",
		.value = "MT6755",
	},
	{
		.key = "ro.mediatek.project.path",
		.value = "device/jrdcsz/Mickey6TTMO",
	},
	{
		.key = "ro.mediatek.version.branch",
		.value = "alps-mp-n0.mp7",
	},
	{
		.key = "ro.mediatek.version.release",
		.value = "alps-mp-n0.mp7-V1.92_jrdsz6750.66.tm.n_P140",
	},
	{
		.key = "ro.mediatek.version.sdk",
		.value = "4",
	},
	{
		.key = "ro.mediatek.wlan.p2p",
		.value = "1",
	},
	{
		.key = "ro.mediatek.wlan.wsc",
		.value = "1",
	},
	{
		.key = "ro.mount.fs",
		.value = "EXT4",
	},
	{
		.key = "ro.mtk_aal_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_afw_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_agps_app",
		.value = "1",
	},
	{
		.key = "ro.mtk_audio_tuning_tool_ver",
		.value = "V2.2",
	},
	{
		.key = "ro.mtk_besloudness_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_bg_power_saving_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_bg_power_saving_ui",
		.value = "1",
	},
	{
		.key = "ro.mtk_bip_scws",
		.value = "1",
	},
	{
		.key = "ro.mtk_blulight_def_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_bt_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_cam_lomo_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_cam_mfb_support",
		.value = "3",
	},
	{
		.key = "ro.mtk_deinterlace_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_dhcpv6c_wifi",
		.value = "1",
	},
	{
		.key = "ro.mtk_dialer_search_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_disable_cap_switch",
		.value = "1",
	},
	{
		.key = "ro.mtk_dual_mic_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_eap_sim_aka",
		.value = "1",
	},
	{
		.key = "ro.mtk_emmc_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_enable_md1",
		.value = "1",
	},
	{
		.key = "ro.mtk_external_sim_only_slots",
		.value = "0",
	},
	{
		.key = "ro.mtk_fd_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_fm_recording_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_gps_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_ipo_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_is_tablet",
		.value = "0",
	},
	{
		.key = "ro.mtk_lte_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_matv_analog_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_md_sbp_custom_value",
		.value = "8",
	},
	{
		.key = "ro.mtk_md_world_mode_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_miravision_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_modem_monitor_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_multiple_ims_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_oma_drm_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_omacp_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_perf_fast_start_win",
		.value = "1",
	},
	{
		.key = "ro.mtk_perf_response_time",
		.value = "1",
	},
	{
		.key = "ro.mtk_perf_simple_start_win",
		.value = "1",
	},
	{
		.key = "ro.mtk_perfservice_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_pow_perf_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_pq_color_mode",
		.value = "1",
	},
	{
		.key = "ro.mtk_pq_support",
		.value = "2",
	},
	{
		.key = "ro.mtk_protocol1_rat_config",
		.value = "Lf/W/G",
	},
	{
		.key = "ro.mtk_rebootmeta_support",
		.value = "0",
	},
	{
		.key = "ro.mtk_search_db_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_send_rr_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_shared_sdcard",
		.value = "1",
	},
	{
		.key = "ro.mtk_sim_hot_swap",
		.value = "1",
	},
	{
		.key = "ro.mtk_slow_motion_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_tetheringipv6_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_trustonic_tee_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_vilte_ut_support",
		.value = "0",
	},
	{
		.key = "ro.mtk_wapi_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wappush_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wfd_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_widevine_drm_l3_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wifi_mcc_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wlan_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_world_phone_policy",
		.value = "0",
	},
	{
		.key = "ro.num_md_protocol",
		.value = "2",
	},
	{
		.key = "ro.oem_unlock_supported",
		.value = "1",
	},
	{
		.key = "ro.opengles.version",
		.value = "196610",
	},
	{
		.key = "ro.operator.optr",
		.value = "OP08",
	},
	{
		.key = "ro.operator.seg",
		.value = "SEGDEFAULT",
	},
	{
		.key = "ro.operator.spec",
		.value = "SPEC0200",
	},
	{
		.key = "ro.product.board",
		.value = "",
	},
	{
		.key = "ro.product.brand",
		.value = "TCL",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "arm64-v8a",
	},
	{
		.key = "ro.product.cpu.abilist",
		.value = "arm64-v8a,armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist32",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist64",
		.value = "arm64-v8a",
	},
	{
		.key = "ro.product.device",
		.value = "Mickey6TTMO",
	},
	{
		.key = "ro.product.display.model",
		.value = "5049W",
	},
	{
		.key = "ro.product.first_api_level",
		.value = "24",
	},
	{
		.key = "ro.product.locale.language",
		.value = "en",
	},
	{
		.key = "ro.product.locale.region",
		.value = "US",
	},
	{
		.key = "ro.product.locales",
		.value = "",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "AlcatelOneTouch",
	},
	{
		.key = "ro.product.model",
		.value = "5049W",
	},
	{
		.key = "ro.product.name",
		.value = "5049W",
	},
	{
		.key = "ro.recovery_id",
		.value = "0x294c9e599eff5fc56fb0225a2d95ec89886daa53000000000000000000000000",
	},
	{
		.key = "ro.revision",
		.value = "0",
	},
	{
		.key = "ro.runtime.firstboot",
		.value = "1483538518059",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.serialno",
		.value = "EIBUB6EIZ5ORSGY5",
	},
	{
		.key = "ro.setupwizard.require_network",
		.value = "",
	},
	{
		.key = "ro.sf.hwrotation",
		.value = "0",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "320",
	},
	{
		.key = "ro.sim_me_lock_mode",
		.value = "0",
	},
	{
		.key = "ro.sim_refresh_reset_by_modem",
		.value = "1",
	},
	{
		.key = "ro.start.nextradio.service",
		.value = "true",
	},
	{
		.key = "ro.sys.sdcardfs",
		.value = "1",
	},
	{
		.key = "ro.sys.usb.bicr",
		.value = "no",
	},
	{
		.key = "ro.sys.usb.charging.only",
		.value = "yes",
	},
	{
		.key = "ro.sys.usb.mtp.whql.enable",
		.value = "0",
	},
	{
		.key = "ro.sys.usb.storage.type",
		.value = "mtp",
	},
	{
		.key = "ro.tcl_sar_support",
		.value = "1",
	},
	{
		.key = "ro.telephony.default_network",
		.value = "9",
	},
	{
		.key = "ro.telephony.sim.count",
		.value = "2",
	},
	{
		.key = "ro.usb.product",
		.value = "T-Mobile Revvl",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "ro.wlan.mtk.wifi.5g",
		.value = "0",
	},
	{
		.key = "ro.x.wap.profile",
		.value = "http://www-ccpp.tcl-ta.com/files/5049W.xml",
	},
	{
		.key = "ro.zygote",
		.value = "zygote64_32",
	},
	{
		.key = "ro.zygote.preload.enable",
		.value = "0",
	},
	{
		.key = "ro_set_nl_cb_on",
		.value = "false",
	},
	{
		.key = "security.perf_harden",
		.value = "1",
	},
	{
		.key = "selinux.reload_policy",
		.value = "1",
	},
	{
		.key = "service.bootanim.exit",
		.value = "1",
	},
	{
		.key = "service.nvram_init",
		.value = "Ready",
	},
	{
		.key = "service.wcn.coredump.mode",
		.value = "0",
	},
	{
		.key = "service.wcn.driver.ready",
		.value = "yes",
	},
	{
		.key = "sys.boot.reason",
		.value = "0",
	},
	{
		.key = "sys.boot_completed",
		.value = "1",
	},
	{
		.key = "sys.ipo.pwrdncap",
		.value = "2",
	},
	{
		.key = "sys.ipowin.done",
		.value = "1",
	},
	{
		.key = "sys.lowstorage_flag",
		.value = "0",
	},
	{
		.key = "sys.oem_unlock_allowed",
		.value = "0",
	},
	{
		.key = "sys.sysctl.extra_free_kbytes",
		.value = "10800",
	},
	{
		.key = "sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.configfs",
		.value = "0",
	},
	{
		.key = "sys.usb.ffs.ready",
		.value = "1",
	},
	{
		.key = "sys.usb.state",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.vid",
		.value = "0E8D",
	},
	{
		.key = "vold.decrypt",
		.value = "trigger_restart_framework",
	},
	{
		.key = "vold.emmc_size",
		.value = "31268536320",
	},
	{
		.key = "vold.encryption.type",
		.value = "default",
	},
	{
		.key = "vold.has_adoptable",
		.value = "1",
	},
	{
		.key = "vold.path.internal_storage",
		.value = "/storage/emulated/0",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "vold.support_external_sd",
		.value = "1",
	},
	{
		.key = "wfd.dummy.enable",
		.value = "1",
	},
	{
		.key = "wfd.iframesize.level",
		.value = "0",
	},
	{
		.key = "wifi.direct.interface",
		.value = "p2p0",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{
		.key = "wifi.tethering.interface",
		.value = "ap0",
	},
	{
		.key = "wlan.driver.status",
		.value = "unloaded",
	},
	{
		.key = "wlan.wfd.security.image",
		.value = "1",
	},
	{ NULL },
};
#endif /* __ANDROID__ */
