/*
 * CRRCsim - the Charles River Radio Control Club Flight Simulator Project
 *
 * Copyright (C) 2005, 2006, 2008 Jens Wilhelm Wulf (original author)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
  

#ifndef THERMALPROFILE_H
#define THERMALPROFILE_H

// Choices for THERMPROF:
// 0: The original profile for the new thermal simulation.
// 1: As proposed by "Das Thermikbuch fr Modellflieger", written by Markus Lisken and
//    Ulf Gerber, Verlag fr Technik und Handwerk, Baden-Baden.
// 2: Very much like old thermal simulation.
// 3: Very much like old thermal simulation, but downwind area not that big in 
//    diameter.
#define THERMPROF 0


#if (THERMPROF == 0)
const double ThermalRadius       = 0.5;
const int    ThermalProfile_bits = 6;
const double ThermalProfile[]    = {
   1,
   0.998919,
   0.995691,
   0.990335,
   0.982871,
   0.97332,
   0.961702,
   0.948036,
   0.932344,
   0.914644,
   0.894958,
   0.873306,
   0.849707,
   0.824182,
   0.79675,
   0.767433,
   0.73625,
   0.703221,
   0.668367,
   0.631707,
   0.593262,
   0.553051,
   0.511096,
   0.467416,
   0.422031,
   0.374962,
   0.326228,
   0.27585,
   0.223848,
   0.170241,
   0.115051,
   0.0582974,
   -0,
   -0.0559993,
   -0.105958,
   -0.150016,
   -0.188326,
   -0.221057,
   -0.248391,
   -0.270523,
   -0.287666,
   -0.300044,
   -0.307896,
   -0.311476,
   -0.311051,
   -0.306903,
   -0.299329,
   -0.288639,
   -0.275157,
   -0.259223,
   -0.241189,
   -0.221424,
   -0.200309,
   -0.178239,
   -0.155626,
   -0.132893,
   -0.110479,
   -0.0888371,
   -0.0684345,
   -0.0497525,
   -0.0332869,
   -0.0195475,
   -0.00905861,
   -0.00235855,
   0};
#endif

#if (THERMPROF == 1)
const double ThermalRadius       = 0.383;
const int    ThermalProfile_bits = 6;
const double ThermalProfile[]    = {
   0.9999,
   0.997135,
   0.988865,
   0.975171,
   0.956184,
   0.932087,
   0.903113,
   0.86954,
   0.831691,
   0.789932,
   0.744664,
   0.696323,
   0.645375,
   0.59231,
   0.53764,
   0.481891,
   0.4256,
   0.369309,
   0.31356,
   0.25889,
   0.205825,
   0.154877,
   0.106536,
   0.0612679,
   0.0195086,
   -0.0183399,
   -0.051913,
   -0.0808874,
   -0.104984,
   -0.123971,
   -0.137665,
   -0.145935,
   -0.1486,
   -0.148242,
   -0.147172,
   -0.145401,
   -0.142944,
   -0.139827,
   -0.136078,
   -0.131735,
   -0.126838,
   -0.121435,
   -0.115579,
   -0.109325,
   -0.102733,
   -0.0958682,
   -0.0887952,
   -0.0815827,
   -0.0743,
   -0.0670173,
   -0.0598048,
   -0.0527318,
   -0.0458666,
   -0.0392752,
   -0.0330211,
   -0.0271646,
   -0.021762,
   -0.0168653,
   -0.0125218,
   -0.00877325,
   -0.00565575,
   -0.00319933,
   -0.00142765,
   -0.000357775,
   0};
#endif

#if (THERMPROF == 2)
const double ThermalRadius       = 0.2;
const int    ThermalProfile_bits = 6;
const double ThermalProfile[]    = {
   1,
   1,
   1,
   0.999999,
   0.999991,
   0.999917,
   0.999488,
   0.997607,
   0.990905,
   0.970466,
   0.915297,
   0.780301,
   0.47554,
   -0,
   -0.00602672,
   -0.011884,
   -0.0175493,
   -0.0230016,
   -0.0282211,
   -0.0331901,
   -0.0378918,
   -0.0423113,
   -0.0464351,
   -0.0502513,
   -0.0537493,
   -0.0569203,
   -0.0597568,
   -0.0622529,
   -0.0644043,
   -0.066208,
   -0.0676627,
   -0.0687686,
   -0.0695273,
   -0.0699421,
   -0.0700177,
   -0.0697603,
   -0.0691776,
   -0.068279,
   -0.0670751,
   -0.0655784,
   -0.0638026,
   -0.061763,
   -0.0594765,
   -0.0569616,
   -0.054238,
   -0.0513271,
   -0.048252,
   -0.045037,
   -0.041708,
   -0.0382926,
   -0.0348198,
   -0.03132,
   -0.0278253,
   -0.0243692,
   -0.0209867,
   -0.0177145,
   -0.0145907,
   -0.0116548,
   -0.0089479,
   -0.00651275,
   -0.00439348,
   -0.00263574,
   -0.00128674,
   -0.000395197,
   -1.13262e-05,
   0};
#endif

#if (THERMPROF == 3)
const double ThermalRadius       = 0.27;
const int    ThermalProfile_bits = 6;
const double ThermalProfile[]    = {
   1,
   1,
   1,
   1,
   1,
   0.999996,
   0.999975,
   0.999881,
   0.999548,
   0.998531,
   0.995787,
   0.989073,
   0.973916,
   0.941924,
   0.878145,
   0.757073,
   0.536807,
   0.150718,
   -0,
   -0.0174094,
   -0.0334861,
   -0.0482569,
   -0.0617498,
   -0.073994,
   -0.0850193,
   -0.0948569,
   -0.103539,
   -0.111099,
   -0.11757,
   -0.122989,
   -0.127391,
   -0.130813,
   -0.133295,
   -0.134875,
   -0.135595,
   -0.135495,
   -0.134618,
   -0.133008,
   -0.130709,
   -0.127767,
   -0.124229,
   -0.120143,
   -0.115557,
   -0.110521,
   -0.105087,
   -0.0993049,
   -0.0932294,
   -0.0869139,
   -0.0804136,
   -0.0737845,
   -0.0670839,
   -0.0603698,
   -0.0537016,
   -0.0471396,
   -0.040745,
   -0.0345802,
   -0.0287086,
   -0.0231947,
   -0.018104,
   -0.013503,
   -0.00945927,
   -0.00604144,
   -0.00331918,
   -0.00136319,
   -0.000245215,
   0};
#endif

#endif
