DACS_AUTH_AGENT(8)         DACS Web Services Manual         DACS_AUTH_AGENT(8)



[1mNAME[0m
       dacs_auth_agent - [1mDACS [22mdelegated authentication service

[1mSYNOPSIS[0m
       [1mdacs_auth_agent [22m[[34m[1mdacsoptions[0m[1m[22m[1]]

[1mDESCRIPTION[0m
       This web service is part of the [1mDACS [22msuite.

       The [1mdacs_auth_agent [22mweb service is used to request [1mDACS [22mcredentials
       outside of the usual [1mDACS [22mauthentication procedure (see
       [34m[1mdacs_authenticate(8)[0m[1m[22m[2]). The client making the service request,
       whether a user agent or middleware, is considered to be an "agent"
       trusted by the jurisdiction that receives the request by virtue of
       having obtained [1mDACS [22mcredentials and satisfying [1mDACS [22maccess control
       rules that grant it access to this service. In other words, an agent
       simply requests credentials for a given identity from [1mdacs_auth_agent[0m
       and they are returned if an access control rule grants access and
       [1mdacs_auth_agent [22mis configured appropriately.

       The agent's [1mDACS [22mcredentials can be obtained through
       [34m[1mdacs_authenticate(8)[0m[1m[22m[2], [34m[1mdacs_auth_transfer(8)[0m[1m[22m[3], [34m[1mdacscred(1)[0m[1m[22m[4],
       [34m[1mdacscookie(1)[0m[1m[22m[5], or even [1mdacs_auth_agent[22m.

       If the request is successful, credentials are returned to the client
       within an HTTP cookie. Credentials generated by this service can be
       distinguished from those created by one of the other methods.

           [1mSecurity[0m
           Access control rules are responsible for expressing restrictions on
           the types of operations to be granted to various trusted agents.
           Access to this web service must not be granted without establishing
           and testing carefully crafted access control rules and appropriate
           configuration. By default, all access to this service is denied.

       Much like Unix's [34m[1msu(1)[0m[1m[22m[6] command lets the superuser assume the Unix
       identity of any other user, this service provides a way for a
       privileged client to request credentials for a user known to the
       receiving jurisdiction. Any other credentials in the possession of the
       client remain in effect. Help desk personnel and system administrators
       can use this capability to assist users by temporarily impersonating a
       user without having to know the user's password, obtaining the user's
       client certificate, or following the user's usual authentication
       procedure.

       The service can also be invoked to effectively import an identity that
       is recognized by the agent but possibly not known to the receiving
       jurisdiction. This provides a way to convert foreign credentials,
       whether from a non-[1mDACS [22mbased system or a different [1mDACS [22mfederation,
       into credentials understood by the federation of the receiving
       jurisdiction. It is only necessary for the agent to understand the
       foreign credentials; [1mDACS [22mnever sees them.

       Another use of this service is in conjunction with middleware that does
       its own authentication. Having authenticated a user, an application can
       ask [1mdacs_auth_agent [22mfor [1mDACS [22mcredentials for the user.

   [1mWeb Service Arguments[0m
       In addition to the [34m[1mstandard CGI arguments[0m[1m[22m[7], [1mdacs_auth_agent[0m
       understands the following CGI arguments:

       [4mUSERNAME[0m
           If present, the agent asserts that [4mUSERNAME[24m is in some sense known
           to this jurisdiction.

       [4mALIEN_FEDERATION[0m
           If present, the agent asserts that [4mALIEN_USERNAME[24m, which must be
           provided, is associated with the named external system. This can be
           any string comprised of characters allowed in a [1mDACS [22musername;
           presumably the agent and [1mDACS [22mjurisdiction have agreed on the name
           to use. This name, or a string mapped from it, will be incorporated
           into the resulting [1mDACS [22musername and credentials.

       [4mALIEN_USERNAME[0m
           If present, the [4mALIEN_FEDERATION[24m argument must also be given. The
           agent asserts that the given name, relative to [4mALIEN_FEDERATION[24m,
           has been authenticated. This can be any string comprised of
           characters allowed in a [1mDACS [22musername. This name, or a string
           mapped from it, will be incorporated into the resulting [1mDACS[0m
           username and credentials.

       [4mDACS_JURISDICTION[0m
           This identifies the receiving jurisdiction.

       [4mDACS_BROWSER[0m
           This optional parameter is as described for the
           [34m[1mdacs_authenticate(8)[0m[1m[22m[2] service.

       [4mOPERATION[0m
           This optional parameter is as described for the
           [34m[1mdacs_authenticate(8)[0m[1m[22m[2] service.

       [4mCOOKIE_SYNTAX[0m
           This optional parameter is as described for the
           [34m[1mdacs_authenticate(8)[0m[1m[22m[2] service.

   [1mOperation[0m
       There are two modes of operation. In local mode, the [4mUSERNAME[24m argument
       is provided and is purported to be the [1mDACS [22musername of a user known to
       the receiving jurisdiction.

       The second mode, called alien mode, is selected if both an
       [4mALIEN_FEDERATION[24m argument and an [4mALIEN_USERNAME[24m argument are present.
       It is an error if only one of these arguments is given, and the
       [4mUSERNAME[24m is ignored. The mode checks that the [4mALIEN_FEDERATION[24m and the
       [4mALIEN_USERNAME[24m relative to it are satisfactory. This is done by
       requiring the [4mALIEN_FEDERATION[24m to be recognized by the receiving
       jurisdiction; it may optionally be mapped to a different string.
       Similarly, the [4mALIEN_USERNAME[24m argument must be recognized, relative to
       [4mALIEN_FEDERATION[24m or the string mapped from it.

       Credentials that have been designated as an [34m[1mADMIN_IDENTITY[0m[1m[22m[8] will be
       returned only if the [34m[1mAUTH_AGENT_ALLOW_ADMIN_IDENTITY[0m[1m[22m[9] configuration
       directive has the value "yes". Refer to [34m[1mdacs.conf(5)[0m[1m[22m[10] for a
       description of these configuration directives.

       A revocation test is always performed on the [1mDACS [22midentity; see
       [34m[1mdacs.acls(5)[0m[1m[22m[11] for a description of how authentication revocation
       works.

       [1mLocal Mode[0m
           If the [4mUSERNAME[24m argument is provided, it must consist of printable
           characters, as determined by [34m[1misprint(3)[0m[1m[22m[12].

           By default, [1mdacs_auth_agent [22mwill blindly accept the trusted
           client's assertion that [4mUSERNAME[24m is known to the receiving
           jurisdiction. An administrator can constrain [4mUSERNAME[24m, however, and
           optionally map it into a replacement that is a valid [1mDACS [22musername.

           If the virtual filestore item type "auth_agent_local" is
           configured, it is expected to name a file consisting of
           expressions, one per line (a continued line ends with a backslash).
           Each expression is evaluated in turn until one returns a non-empty
           string value; this value, which must be a syntactically correct
           [1mDACS [22musername, becomes the mapped username. An evaluation error is
           fatal. The value of the [4mUSERNAME[24m argument is available to each
           expression as [4m${Expr::_}[24m (reminiscent of Perl's [4m$_[24m variable).

           For example, consider the configuration directive:

               VFS "[auth_agent_local]dacs-fs:/usr/local/dacs/auth_agent_local_users"

           and the file /usr/local/dacs/auth_agent_local_users, which
           contains:

               regsub(${Expr::_}, "^auggie doggie$", "auggie")
               regsub(${Expr::_}, "^julia$", "sara")
               strtr(regsub(${Expr::_}, \
                   "\([^:]*\)://\([^.]*\)\\.\(.*\)", '${1}-${2}@${3}'), \
                     "A-Z", "a-z")

           If [4mUSERNAME[24m is "auggie doggie", credentials will be issued for
           "auggie". If [4mUSERNAME[24m is "julia", credentials will be issued for
           "sara". If [4mUSERNAME[24m is "https://Bob.Example.com", the third
           expression will return the string "https-bob@example.com", which
           will become the mapped name (this example is apropos of mapping
           [34m[1mOpenID[0m[1m[22m[13] names).

           When configured, roles are obtained for [4mUSERNAME[24m in the same way as
           is done for [34m[1mdacs_authenticate(8)[0m[1m[22m[2].

       [1mAlien Mode[0m
           The alien mode of operation proceeds as follows:

            1. It looks up [4mALIEN_FEDERATION[24m using item type
               auth_agent_federations. When forming a key, the lookup
               operation will percent-encode any ':' and '%' characters in
               [4mALIEN_FEDERATION[24m, so the same encoding is required for keys
               that appear in auth_agent_federations. If it is not found,
               authentication fails. If found, it may optionally have a value;
               that value will be used within the resulting [1mDACS [22mcredentials
               instead of the [4mALIEN_FEDERATION[24m argument. In any case, the
               resulting value must be valid for a [1mDACS [22musername.

            2. It looks up [4mALIEN_USERNAME[24m using an item type constructed by
               prepending the string "auth_agent_federation_" to the
               federation name derived during the previous step. When forming
               a key, the lookup operation will percent-encode any ':' and '%'
               characters in [4mALIEN_USERNAME[24m, so the same encoding is required
               for stored keys. If it is not found, authentication fails. If
               found, it may optionally have a value; that value will be used
               within the resulting [1mDACS [22mcredentials instead of the
               [4mALIEN_USERNAME[24m argument. In any case, the resulting string must
               be valid for a [1mDACS [22musername.

            3. A [1mDACS [22musername will be formed using the federation name and
               username strings derived in the previous steps.


[1mEXAMPLES[0m
       The following is an example of local mode operation. Assume the
       following configuration directive is in effect:

           VFS "[auth_agent_local]dacs-fs:/usr/local/dacs/auth_agent_local_users"

       Also assume that the file /usr/local/dacs/auth_agent_local_users
       contains the expression:

           regsub(${Expr::_}, \
               "\([^:]*\)://\([^.]*\)\\.\(.*\)", '${1}-${2}@${3}')

       If a request is made with [4mUSERNAME[24m equal to "http://Bob.Example.com",
       new credentials will be issued for "http-Bob@Example.com" relative to
       the current jurisdiction.

       The following is an example of alien mode operation. Assume the
       following configuration directives are in effect:

           VFS "[auth_agent_federations]dacs-kwv-fs:/usr/local/dacs/auth_agent_feds"
           VFS "[auth_agent_federation_mars]dacs-kwv-fs:/usr/local/dacs/auth_agent_fed_mars"

       Also assume that the file /usr/local/dacs/auth_agent_feds consists of
       the line

           MARS:

       and the file /usr/local/dacs/auth_agent_fed_mars consists of the line

           gazoo:

       If a request is made with [4mALIEN_FEDERATION[24m equal to "MARS" and
       [4mALIEN_USERNAME[24m equal to "gazoo", the request will satisfy alien mode's
       rules of operation with the strings "MARS" and "gazoo" being used to
       form the [1mDACS [22musername relative to the current jurisdiction
       ([4mDACS_JURISDICTION[24m).

       If instead [4mALIEN_FEDERATION[24m were "http://example.com" and the file
       /usr/local/dacs/auth_agent_feds looked like:

           http%3A//example.com:example

       then the string "example" would be used with "gazoo" to form the [1mDACS[0m
       username.

[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mNOTES[0m
       The word "alien" is used because it sounds cooler than "foreign" and is
       arguably easier to spell.

       A superficially similar feature called "affiliated [1mDACS [22mfederations",
       which provides single sign-on across federation boundaries, is
       sometimes a more appropriate solution; see [34m[1mdacs_auth_transfer(8)[0m[1m[22m[3].

[1mBUGS[0m
       It should be possible for keys that are matched against [4mUSERNAME[24m to be
       regular expressions and for the corresponding replacement values to
       interpolate matched substrings.

[1mSEE ALSO[0m
       [34m[1mdacs_authenticate(8)[0m[1m[22m[2], [34m[1mdacs_auth_transfer(8)[0m[1m[22m[3],
       [34m[1mdacs_current_credentials(8)[0m[1m[22m[14], [34m[1mdacs_signout(8)[0m[1m[22m[15],
       [34m[1mdacs.exprs(5)[0m[1m[22m[16], [34m[1mdacscred(1)[0m[1m[22m[4], [34m[1mdacscookie(1)[0m[1m[22m[5].

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[17])

[1mCOPYING[0m
       Copyright (C) 2003-2018 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[18] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

        3. dacs_auth_transfer(8)
           http://dacs.dss.ca/man/dacs_auth_transfer.8.html

        4. dacscred(1)
           http://dacs.dss.ca/man/dacscred.1.html

        5. dacscookie(1)
           http://dacs.dss.ca/man/dacscookie.1.html

        6. su(1)
           https://www.freebsd.org/cgi/man.cgi?query=su&apropos=0&sektion=1&manpath=FreeBSD+10.3-RELEASE&format=html

        7. standard CGI arguments
           http://dacs.dss.ca/man/dacs.services.8.html#standard_cgi_args

        8. ADMIN_IDENTITY
           http://dacs.dss.ca/man/dacs.conf.5.html#ADMIN_IDENTITY

        9. AUTH_AGENT_ALLOW_ADMIN_IDENTITY
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_AGENT_ALLOW_ADMIN_IDENTITY

       10. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

       11. dacs.acls(5)
           http://dacs.dss.ca/man/dacs.acls.5.html

       12. isprint(3)
           https://www.freebsd.org/cgi/man.cgi?query=isprint&apropos=0&sektion=3&manpath=FreeBSD+10.3-RELEASE&format=html

       13. OpenID
           http://openid.net/

       14. dacs_current_credentials(8)
           http://dacs.dss.ca/man/dacs_current_credentials.8.html

       15. dacs_signout(8)
           http://dacs.dss.ca/man/dacs_signout.8.html

       16. dacs.exprs(5)
           http://dacs.dss.ca/man/dacs.exprs.5.html

       17. www.dss.ca
           http://www.dss.ca

       18. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.40                       02/01/2018                DACS_AUTH_AGENT(8)
