/*
insts.c

diStorm3 - Powerful disassembler for X86/AMD64
http://ragestorm.net/distorm/
distorm at gmail dot com
Copyright (C) 2003-2012 Gil Dabah

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/


#include "config.h"
#include "insts.h"
#include "instructions.h"


/*
 * GENERATED BY disOps at Sat Dec 13 21:47:42 2014
 */

_InstInfo II_MOVSXD =	/*II*/ {0x1d0, 10005};
_InstInfo II_NOP =	/*II*/ {0x53, 581};
_InstInfo II_PAUSE =	/*II*/ {0x88, 10013};
_InstInfo II_WAIT =	/*II*/ {0x53, 10020};
_InstInfo II_RDRAND =	/*II*/ {0x1d1, 10026};
_InstInfo II_3DNOW =	/*II*/ {0x1d2, 10034};

_iflags FlagsTable[100] = {
0x80000011,
0x80000000,
0x800400,
0x80800400,
0x800080,
0x800100,
0x80800100,
0x800200,
0x80800200,
0x800000,
0x1,
0x0,
0x80800000,
0x1000000,
0x81000000,
0x808000,
0x800001,
0x80020001,
0x1002000,
0x60,
0x64,
0x80000001,
0x4010000,
0x1008000,
0x80000060,
0x83000064,
0x3000064,
0x83000000,
0x3008000,
0x200,
0xc000,
0x4014000,
0x8,
0x81000009,
0x9,
0x80000009,
0x1000808,
0x81000808,
0x80020009,
0x1001008,
0x81001008,
0x80000019,
0x3000009,
0x83000009,
0x83000008,
0xc0000011,
0x40000001,
0xc0800011,
0x40800001,
0xc0000019,
0xc1000001,
0xc0000001,
0x40000000,
0x40000008,
0x40000009,
0x41000001,
0x43000001,
0xc0000003,
0x40000003,
0x48000000,
0x200009,
0x20000009,
0x60020009,
0x60000009,
0x80090009,
0x200b0009,
0x20020009,
0x80100009,
0x21100009,
0x87000009,
0x20009,
0x20000008,
0x1000009,
0x10020009,
0x160009,
0x100009,
0x47000009,
0x47090009,
0x40090009,
0x80002009,
0xc0000009,
0x2001,
0x80002001,
0x410009,
0x20420009,
0x20060009,
0x120009,
0x21020009,
0xc7000019,
0x20100009,
0xc0002009,
0x40002008,
0xc0000000,
0xc0002008,
0x4020009,
0x40100009,
0x60120009,
0x41000009,
0x83000001,
0x200001
};

_InstNode Table_0F = 256;
_InstNode Table_0F_0F = 1312;
_InstNode Table_0F_38 = 1768;
_InstNode Table_0F_3A = 2024;

_InstInfo InstInfos[1243] = {
	/*II_00*/ {0x0, 11},
	/*II_01*/ {0x1, 11},
	/*II_02*/ {0x2, 11},
	/*II_03*/ {0x3, 11},
	/*II_04*/ {0x4, 11},
	/*II_05*/ {0x5, 11},
	/*II_06*/ {0x6, 16},
	/*II_07*/ {0x7, 22},
	/*II_08*/ {0x8, 27},
	/*II_09*/ {0x9, 27},
	/*II_0A*/ {0xa, 27},
	/*II_0B*/ {0xb, 27},
	/*II_0C*/ {0xc, 27},
	/*II_0D*/ {0xd, 27},
	/*II_0E*/ {0xe, 16},
	/*II_10*/ {0xf, 31},
	/*II_11*/ {0x10, 31},
	/*II_12*/ {0x11, 31},
	/*II_13*/ {0x12, 31},
	/*II_14*/ {0x13, 31},
	/*II_15*/ {0x14, 31},
	/*II_16*/ {0x15, 16},
	/*II_17*/ {0x16, 22},
	/*II_18*/ {0xf, 36},
	/*II_19*/ {0x10, 36},
	/*II_1A*/ {0x11, 36},
	/*II_1B*/ {0x12, 36},
	/*II_1C*/ {0x13, 36},
	/*II_1D*/ {0x14, 36},
	/*II_1E*/ {0x17, 16},
	/*II_1F*/ {0x18, 22},
	/*II_20*/ {0x19, 41},
	/*II_21*/ {0x1a, 41},
	/*II_22*/ {0x1b, 41},
	/*II_23*/ {0x1c, 41},
	/*II_24*/ {0x1d, 41},
	/*II_25*/ {0x1e, 41},
	/*II_27*/ {0x1f, 46},
	/*II_28*/ {0x0, 51},
	/*II_29*/ {0x1, 51},
	/*II_2A*/ {0x2, 51},
	/*II_2B*/ {0x3, 51},
	/*II_2C*/ {0x4, 51},
	/*II_2D*/ {0x5, 51},
	/*II_2F*/ {0x1f, 56},
	/*II_30*/ {0x20, 61},
	/*II_31*/ {0x21, 61},
	/*II_32*/ {0x22, 61},
	/*II_33*/ {0x23, 61},
	/*II_34*/ {0x24, 61},
	/*II_35*/ {0x25, 61},
	/*II_37*/ {0x26, 66},
	/*II_38*/ {0x27, 71},
	/*II_39*/ {0x28, 71},
	/*II_3A*/ {0x29, 71},
	/*II_3B*/ {0x2a, 71},
	/*II_3C*/ {0x2b, 71},
	/*II_3D*/ {0x2c, 71},
	/*II_3F*/ {0x26, 76},
	/*II_40*/ {0x2d, 81},
	/*II_40*/ {0x2d, 81},
	/*II_40*/ {0x2d, 81},
	/*II_40*/ {0x2d, 81},
	/*II_40*/ {0x2d, 81},
	/*II_40*/ {0x2d, 81},
	/*II_40*/ {0x2d, 81},
	/*II_40*/ {0x2d, 81},
	/*II_48*/ {0x2d, 86},
	/*II_48*/ {0x2d, 86},
	/*II_48*/ {0x2d, 86},
	/*II_48*/ {0x2d, 86},
	/*II_48*/ {0x2d, 86},
	/*II_48*/ {0x2d, 86},
	/*II_48*/ {0x2d, 86},
	/*II_48*/ {0x2d, 86},
	/*II_50*/ {0x2e, 16},
	/*II_50*/ {0x2e, 16},
	/*II_50*/ {0x2e, 16},
	/*II_50*/ {0x2e, 16},
	/*II_50*/ {0x2e, 16},
	/*II_50*/ {0x2e, 16},
	/*II_50*/ {0x2e, 16},
	/*II_50*/ {0x2e, 16},
	/*II_58*/ {0x2f, 22},
	/*II_58*/ {0x2f, 22},
	/*II_58*/ {0x2f, 22},
	/*II_58*/ {0x2f, 22},
	/*II_58*/ {0x2f, 22},
	/*II_58*/ {0x2f, 22},
	/*II_58*/ {0x2f, 22},
	/*II_58*/ {0x2f, 22},
	/*II_60*/ {0x30, 91},
	/*II_61*/ {0x30, 98},
	/*II_62*/ {0x31, 104},
	/*II_63*/ {0x32, 111},
	/*II_68*/ {0x33, 16},
	/*II_6A*/ {0x35, 16},
	/*II_6C*/ {0x36, 32891},
	/*II_6D*/ {0x37, 32891},
	/*II_6E*/ {0x38, 32896},
	/*II_6F*/ {0x39, 32896},
	/*II_70*/ {0x3a, 134},
	/*II_71*/ {0x3a, 138},
	/*II_72*/ {0x3b, 143},
	/*II_73*/ {0x3b, 147},
	/*II_74*/ {0x3c, 152},
	/*II_75*/ {0x3c, 156},
	/*II_76*/ {0x3d, 161},
	/*II_77*/ {0x3d, 166},
	/*II_78*/ {0x3e, 170},
	/*II_79*/ {0x3e, 174},
	/*II_7A*/ {0x3f, 179},
	/*II_7B*/ {0x3f, 183},
	/*II_7C*/ {0x40, 188},
	/*II_7D*/ {0x40, 192},
	/*II_7E*/ {0x41, 197},
	/*II_7F*/ {0x41, 202},
	/*II_84*/ {0x42, 206},
	/*II_85*/ {0x43, 206},
	/*II_86*/ {0x44, 212},
	/*II_87*/ {0x45, 212},
	/*II_88*/ {0x46, 218},
	/*II_89*/ {0x47, 218},
	/*II_8A*/ {0x48, 218},
	/*II_8B*/ {0x49, 218},
	/*II_8C*/ {0x4a, 218},
	/*II_8D*/ {0x4b, 223},
	/*II_8E*/ {0x4c, 218},
	/*II_90*/ {0x4d, 212},
	/*II_91*/ {0x4d, 212},
	/*II_92*/ {0x4d, 212},
	/*II_93*/ {0x4d, 212},
	/*II_94*/ {0x4d, 212},
	/*II_95*/ {0x4d, 212},
	/*II_96*/ {0x4d, 212},
	/*II_97*/ {0x4d, 212},
	/*II_9A*/ {0x4f, 260},
	/*II_9C*/ {0x50, 270},
	/*II_9D*/ {0x51, 277},
	/*II_9E*/ {0x52, 283},
	/*II_9F*/ {0x53, 289},
	/*II_A0*/ {0x54, 218},
	/*II_A1*/ {0x55, 218},
	/*II_A2*/ {0x56, 218},
	/*II_A3*/ {0x57, 218},
	/*II_A4*/ {0x58, 295},
	/*II_A5*/ {0x59, 295},
	/*II_A6*/ {0x5a, 301},
	/*II_A7*/ {0x5b, 301},
	/*II_A8*/ {0x5c, 206},
	/*II_A9*/ {0x5d, 206},
	/*II_AA*/ {0x5e, 307},
	/*II_AB*/ {0x5f, 307},
	/*II_AC*/ {0x60, 313},
	/*II_AD*/ {0x61, 313},
	/*II_AE*/ {0x62, 319},
	/*II_AF*/ {0x63, 319},
	/*II_B0*/ {0x64, 218},
	/*II_B0*/ {0x64, 218},
	/*II_B0*/ {0x64, 218},
	/*II_B0*/ {0x64, 218},
	/*II_B0*/ {0x64, 218},
	/*II_B0*/ {0x64, 218},
	/*II_B0*/ {0x64, 218},
	/*II_B0*/ {0x64, 218},
	/*II_B8*/ {0x65, 218},
	/*II_B8*/ {0x65, 218},
	/*II_B8*/ {0x65, 218},
	/*II_B8*/ {0x65, 218},
	/*II_B8*/ {0x65, 218},
	/*II_B8*/ {0x65, 218},
	/*II_B8*/ {0x65, 218},
	/*II_B8*/ {0x65, 218},
	/*II_C2*/ {0x66, 325},
	/*II_C3*/ {0x67, 325},
	/*II_C4*/ {0x68, 330},
	/*II_C5*/ {0x68, 335},
	/*II_C8*/ {0x69, 340},
	/*II_C9*/ {0x6a, 347},
	/*II_CA*/ {0x6b, 354},
	/*II_CB*/ {0x6c, 354},
	/*II_CC*/ {0x6d, 360},
	/*II_CD*/ {0x6e, 367},
	/*II_CE*/ {0x6f, 372},
	/*II_CF*/ {0x70, 33146},
	/*II_D4*/ {0x71, 384},
	/*II_D5*/ {0x71, 389},
	/*II_D6*/ {0x72, 394},
	/*II_D7*/ {0x73, 400},
	/*II_E0*/ {0x74, 406},
	/*II_E1*/ {0x74, 414},
	/*II_E2*/ {0x75, 421},
	/*II_E4*/ {0x77, 33215},
	/*II_E5*/ {0x78, 33215},
	/*II_E6*/ {0x79, 33219},
	/*II_E7*/ {0x7a, 33219},
	/*II_E8*/ {0x7b, 456},
	/*II_E9*/ {0x7c, 462},
	/*II_EA*/ {0x7d, 467},
	/*II_EB*/ {0x7e, 462},
	/*II_EC*/ {0x7f, 33215},
	/*II_ED*/ {0x80, 33215},
	/*II_EE*/ {0x81, 33219},
	/*II_EF*/ {0x82, 33219},
	/*II_F1*/ {0x6d, 476},
	/*II_F4*/ {0x53, 33250},
	/*II_F5*/ {0x83, 487},
	/*II_F8*/ {0x83, 492},
	/*II_F9*/ {0x83, 497},
	/*II_FA*/ {0x84, 33270},
	/*II_FB*/ {0x84, 33275},
	/*II_FC*/ {0x85, 512},
	/*II_FD*/ {0x85, 517},
	/*II_0F_02*/ {0x86, 522},
	/*II_0F_03*/ {0x86, 527},
	/*II_0F_05*/ {0x87, 532},
	/*II_0F_06*/ {0x88, 33309},
	/*II_0F_07*/ {0x87, 547},
	/*II_0F_08*/ {0x88, 33323},
	/*II_0F_09*/ {0x88, 33329},
	/*II_0F_0B*/ {0x89, 569},
	/*II_0F_0E*/ {0x8a, 574},
	/*II_0F_1F*/ {0x8b, 581},
	/*II_0F_20*/ {0x8c, 32986},
	/*II_0F_21*/ {0x8d, 32986},
	/*II_0F_22*/ {0x8e, 32986},
	/*II_0F_23*/ {0x8f, 32986},
	/*II_0F_30*/ {0x88, 33354},
	/*II_0F_31*/ {0x88, 33361},
	/*II_0F_32*/ {0x88, 33368},
	/*II_0F_33*/ {0x88, 33375},
	/*II_0F_34*/ {0x87, 614},
	/*II_0F_35*/ {0x87, 624},
	/*II_0F_37*/ {0x90, 633},
	/*II_0F_40*/ {0x91, 641},
	/*II_0F_41*/ {0x91, 648},
	/*II_0F_42*/ {0x92, 656},
	/*II_0F_43*/ {0x92, 663},
	/*II_0F_44*/ {0x93, 671},
	/*II_0F_45*/ {0x93, 678},
	/*II_0F_46*/ {0x94, 686},
	/*II_0F_47*/ {0x94, 694},
	/*II_0F_48*/ {0x95, 701},
	/*II_0F_49*/ {0x95, 708},
	/*II_0F_4A*/ {0x96, 716},
	/*II_0F_4B*/ {0x96, 723},
	/*II_0F_4C*/ {0x97, 731},
	/*II_0F_4D*/ {0x97, 738},
	/*II_0F_4E*/ {0x98, 746},
	/*II_0F_4F*/ {0x98, 754},
	/*II_0F_80*/ {0x99, 134},
	/*II_0F_81*/ {0x99, 138},
	/*II_0F_82*/ {0x9a, 143},
	/*II_0F_83*/ {0x9a, 147},
	/*II_0F_84*/ {0x9b, 152},
	/*II_0F_85*/ {0x9b, 156},
	/*II_0F_86*/ {0x9c, 161},
	/*II_0F_87*/ {0x9c, 166},
	/*II_0F_88*/ {0x9d, 170},
	/*II_0F_89*/ {0x9d, 174},
	/*II_0F_8A*/ {0x9e, 179},
	/*II_0F_8B*/ {0x9e, 183},
	/*II_0F_8C*/ {0x9f, 188},
	/*II_0F_8D*/ {0x9f, 192},
	/*II_0F_8E*/ {0xa0, 197},
	/*II_0F_8F*/ {0xa0, 202},
	/*II_0F_90*/ {0xa1, 761},
	/*II_0F_91*/ {0xa1, 767},
	/*II_0F_92*/ {0xa2, 774},
	/*II_0F_93*/ {0xa2, 780},
	/*II_0F_94*/ {0xa3, 787},
	/*II_0F_95*/ {0xa3, 793},
	/*II_0F_96*/ {0xa4, 800},
	/*II_0F_97*/ {0xa4, 807},
	/*II_0F_98*/ {0xa5, 813},
	/*II_0F_99*/ {0xa5, 819},
	/*II_0F_9A*/ {0xa6, 826},
	/*II_0F_9B*/ {0xa6, 832},
	/*II_0F_9C*/ {0xa7, 839},
	/*II_0F_9D*/ {0xa7, 845},
	/*II_0F_9E*/ {0xa8, 852},
	/*II_0F_9F*/ {0xa8, 859},
	/*II_0F_A0*/ {0xa9, 16},
	/*II_0F_A1*/ {0xaa, 22},
	/*II_0F_A2*/ {0x88, 865},
	/*II_0F_A3*/ {0xab, 872},
	/*II_0F_A8*/ {0xad, 16},
	/*II_0F_A9*/ {0xae, 22},
	/*II_0F_AA*/ {0xaf, 882},
	/*II_0F_AB*/ {0xb0, 887},
	/*II_0F_AF*/ {0xb1, 117},
	/*II_0F_B0*/ {0xb2, 898},
	/*II_0F_B1*/ {0xb3, 898},
	/*II_0F_B2*/ {0xb4, 907},
	/*II_0F_B3*/ {0xb0, 912},
	/*II_0F_B4*/ {0xb4, 917},
	/*II_0F_B5*/ {0xb4, 922},
	/*II_0F_B6*/ {0xb5, 927},
	/*II_0F_B7*/ {0xb6, 927},
	/*II_0F_B9*/ {0x89, 569},
	/*II_0F_BB*/ {0xb0, 934},
	/*II_0F_BE*/ {0xb5, 939},
	/*II_0F_BF*/ {0xb6, 939},
	/*II_0F_C0*/ {0xb2, 946},
	/*II_0F_C1*/ {0xb3, 946},
	/*II_0F_C3*/ {0xb7, 952},
	/*II_0F_C8*/ {0xb8, 960},
	/*II_0F_C8*/ {0xb8, 960},
	/*II_0F_C8*/ {0xb8, 960},
	/*II_0F_C8*/ {0xb8, 960},
	/*II_0F_C8*/ {0xb8, 960},
	/*II_0F_C8*/ {0xb8, 960},
	/*II_0F_C8*/ {0xb8, 960},
	/*II_0F_C8*/ {0xb8, 960},
	/*II_80_00*/ {0xb9, 11},
	/*II_80_01*/ {0xba, 27},
	/*II_80_02*/ {0xbb, 31},
	/*II_80_03*/ {0xbb, 36},
	/*II_80_04*/ {0xbc, 41},
	/*II_80_05*/ {0xb9, 51},
	/*II_80_06*/ {0xbd, 61},
	/*II_80_07*/ {0xbe, 71},
	/*II_81_00*/ {0xbf, 11},
	/*II_81_01*/ {0xc0, 27},
	/*II_81_02*/ {0xc1, 31},
	/*II_81_03*/ {0xc1, 36},
	/*II_81_04*/ {0xc2, 41},
	/*II_81_05*/ {0xbf, 51},
	/*II_81_06*/ {0xc3, 61},
	/*II_81_07*/ {0xc4, 71},
	/*II_82_00*/ {0xc5, 11},
	/*II_82_01*/ {0xc6, 27},
	/*II_82_02*/ {0xc7, 31},
	/*II_82_03*/ {0xc7, 36},
	/*II_82_04*/ {0xc8, 41},
	/*II_82_05*/ {0xc5, 51},
	/*II_82_06*/ {0xc9, 61},
	/*II_82_07*/ {0xca, 71},
	/*II_83_00*/ {0xcb, 11},
	/*II_83_01*/ {0xcc, 27},
	/*II_83_02*/ {0xcd, 31},
	/*II_83_03*/ {0xcd, 36},
	/*II_83_04*/ {0xce, 41},
	/*II_83_05*/ {0xcb, 51},
	/*II_83_06*/ {0xcf, 61},
	/*II_83_07*/ {0xd0, 71},
	/*II_8F_00*/ {0xd1, 22},
	/*II_C0_00*/ {0xd2, 967},
	/*II_C0_01*/ {0xd2, 972},
	/*II_C0_02*/ {0xd3, 977},
	/*II_C0_03*/ {0xd3, 982},
	/*II_C0_04*/ {0xd4, 987},
	/*II_C0_05*/ {0xd4, 992},
	/*II_C0_06*/ {0xd4, 997},
	/*II_C0_07*/ {0xd4, 1002},
	/*II_C1_00*/ {0xd5, 967},
	/*II_C1_01*/ {0xd5, 972},
	/*II_C1_02*/ {0xd6, 977},
	/*II_C1_03*/ {0xd6, 982},
	/*II_C1_04*/ {0xd7, 987},
	/*II_C1_05*/ {0xd7, 992},
	/*II_C1_06*/ {0xd7, 997},
	/*II_C1_07*/ {0xd7, 1002},
	/*II_C6_00*/ {0xd8, 218},
	/*II_C7_00*/ {0xd9, 218},
	/*II_D0_00*/ {0xda, 967},
	/*II_D0_01*/ {0xda, 972},
	/*II_D0_02*/ {0xdb, 977},
	/*II_D0_03*/ {0xdb, 982},
	/*II_D0_04*/ {0xdc, 987},
	/*II_D0_05*/ {0xdc, 992},
	/*II_D0_06*/ {0xdc, 997},
	/*II_D0_07*/ {0xdc, 1002},
	/*II_D1_00*/ {0xdd, 967},
	/*II_D1_01*/ {0xdd, 972},
	/*II_D1_02*/ {0xde, 977},
	/*II_D1_03*/ {0xde, 982},
	/*II_D1_04*/ {0xdf, 987},
	/*II_D1_05*/ {0xdf, 992},
	/*II_D1_06*/ {0xdf, 997},
	/*II_D1_07*/ {0xdf, 1002},
	/*II_D2_00*/ {0xe0, 967},
	/*II_D2_01*/ {0xe0, 972},
	/*II_D2_02*/ {0xe1, 977},
	/*II_D2_03*/ {0xe1, 982},
	/*II_D2_04*/ {0xe2, 987},
	/*II_D2_05*/ {0xe2, 992},
	/*II_D2_06*/ {0xe2, 997},
	/*II_D2_07*/ {0xe2, 1002},
	/*II_D3_00*/ {0xe3, 967},
	/*II_D3_01*/ {0xe3, 972},
	/*II_D3_02*/ {0xe4, 977},
	/*II_D3_03*/ {0xe4, 982},
	/*II_D3_04*/ {0xe5, 987},
	/*II_D3_05*/ {0xe5, 992},
	/*II_D3_06*/ {0xe5, 997},
	/*II_D3_07*/ {0xe5, 1002},
	/*II_D8_00*/ {0xe6, 1007},
	/*II_D8_01*/ {0xe6, 1013},
	/*II_D8_02*/ {0xe6, 1019},
	/*II_D8_03*/ {0xe6, 1025},
	/*II_D8_04*/ {0xe6, 1032},
	/*II_D8_05*/ {0xe6, 1038},
	/*II_D8_06*/ {0xe6, 1045},
	/*II_D8_07*/ {0xe6, 1051},
	/*II_D8_C0*/ {0xe7, 1007},
	/*II_D8_C0*/ {0xe7, 1007},
	/*II_D8_C0*/ {0xe7, 1007},
	/*II_D8_C0*/ {0xe7, 1007},
	/*II_D8_C0*/ {0xe7, 1007},
	/*II_D8_C0*/ {0xe7, 1007},
	/*II_D8_C0*/ {0xe7, 1007},
	/*II_D8_C0*/ {0xe7, 1007},
	/*II_D8_C8*/ {0xe7, 1013},
	/*II_D8_C8*/ {0xe7, 1013},
	/*II_D8_C8*/ {0xe7, 1013},
	/*II_D8_C8*/ {0xe7, 1013},
	/*II_D8_C8*/ {0xe7, 1013},
	/*II_D8_C8*/ {0xe7, 1013},
	/*II_D8_C8*/ {0xe7, 1013},
	/*II_D8_C8*/ {0xe7, 1013},
	/*II_D8_D0*/ {0xe8, 1019},
	/*II_D8_D0*/ {0xe8, 1019},
	/*II_D8_D0*/ {0xe8, 1019},
	/*II_D8_D0*/ {0xe8, 1019},
	/*II_D8_D0*/ {0xe8, 1019},
	/*II_D8_D0*/ {0xe8, 1019},
	/*II_D8_D0*/ {0xe8, 1019},
	/*II_D8_D0*/ {0xe8, 1019},
	/*II_D8_D8*/ {0xe8, 1025},
	/*II_D8_D9*/ {0xe9, 1025},
	/*II_D8_D8*/ {0xe8, 1025},
	/*II_D8_D8*/ {0xe8, 1025},
	/*II_D8_D8*/ {0xe8, 1025},
	/*II_D8_D8*/ {0xe8, 1025},
	/*II_D8_D8*/ {0xe8, 1025},
	/*II_D8_D8*/ {0xe8, 1025},
	/*II_D8_E0*/ {0xe7, 1032},
	/*II_D8_E0*/ {0xe7, 1032},
	/*II_D8_E0*/ {0xe7, 1032},
	/*II_D8_E0*/ {0xe7, 1032},
	/*II_D8_E0*/ {0xe7, 1032},
	/*II_D8_E0*/ {0xe7, 1032},
	/*II_D8_E0*/ {0xe7, 1032},
	/*II_D8_E0*/ {0xe7, 1032},
	/*II_D8_E8*/ {0xe7, 1038},
	/*II_D8_E8*/ {0xe7, 1038},
	/*II_D8_E8*/ {0xe7, 1038},
	/*II_D8_E8*/ {0xe7, 1038},
	/*II_D8_E8*/ {0xe7, 1038},
	/*II_D8_E8*/ {0xe7, 1038},
	/*II_D8_E8*/ {0xe7, 1038},
	/*II_D8_E8*/ {0xe7, 1038},
	/*II_D8_F0*/ {0xe7, 1045},
	/*II_D8_F0*/ {0xe7, 1045},
	/*II_D8_F0*/ {0xe7, 1045},
	/*II_D8_F0*/ {0xe7, 1045},
	/*II_D8_F0*/ {0xe7, 1045},
	/*II_D8_F0*/ {0xe7, 1045},
	/*II_D8_F0*/ {0xe7, 1045},
	/*II_D8_F0*/ {0xe7, 1045},
	/*II_D8_F8*/ {0xe7, 1051},
	/*II_D8_F8*/ {0xe7, 1051},
	/*II_D8_F8*/ {0xe7, 1051},
	/*II_D8_F8*/ {0xe7, 1051},
	/*II_D8_F8*/ {0xe7, 1051},
	/*II_D8_F8*/ {0xe7, 1051},
	/*II_D8_F8*/ {0xe7, 1051},
	/*II_D8_F8*/ {0xe7, 1051},
	/*II_D9_00*/ {0xe6, 1058},
	/*II_D9_02*/ {0xea, 1063},
	/*II_D9_03*/ {0xea, 1068},
	/*II_D9_04*/ {0xeb, 1074},
	/*II_D9_05*/ {0xec, 1082},
	/*II_D9_C0*/ {0xe8, 1058},
	/*II_D9_C0*/ {0xe8, 1058},
	/*II_D9_C0*/ {0xe8, 1058},
	/*II_D9_C0*/ {0xe8, 1058},
	/*II_D9_C0*/ {0xe8, 1058},
	/*II_D9_C0*/ {0xe8, 1058},
	/*II_D9_C0*/ {0xe8, 1058},
	/*II_D9_C0*/ {0xe8, 1058},
	/*II_D9_C8*/ {0xe8, 1089},
	/*II_D9_C9*/ {0xe9, 1089},
	/*II_D9_C8*/ {0xe8, 1089},
	/*II_D9_C8*/ {0xe8, 1089},
	/*II_D9_C8*/ {0xe8, 1089},
	/*II_D9_C8*/ {0xe8, 1089},
	/*II_D9_C8*/ {0xe8, 1089},
	/*II_D9_C8*/ {0xe8, 1089},
	/*II_D9_D0*/ {0xe9, 1095},
	/*II_D9_E0*/ {0xe9, 1101},
	/*II_D9_E1*/ {0xe9, 1107},
	/*II_D9_E4*/ {0xe9, 1113},
	/*II_D9_E5*/ {0xe9, 1119},
	/*II_D9_E8*/ {0xe9, 1125},
	/*II_D9_E9*/ {0xe9, 1131},
	/*II_D9_EA*/ {0xe9, 1139},
	/*II_D9_EB*/ {0xe9, 1147},
	/*II_D9_EC*/ {0xe9, 1154},
	/*II_D9_ED*/ {0xe9, 1162},
	/*II_D9_EE*/ {0xe9, 1170},
	/*II_D9_F0*/ {0xe9, 1176},
	/*II_D9_F1*/ {0xe9, 1183},
	/*II_D9_F2*/ {0xe9, 1190},
	/*II_D9_F3*/ {0xe9, 1197},
	/*II_D9_F4*/ {0xe9, 1205},
	/*II_D9_F5*/ {0xe9, 1214},
	/*II_D9_F6*/ {0xe9, 1222},
	/*II_D9_F7*/ {0xe9, 1231},
	/*II_D9_F8*/ {0xe9, 1240},
	/*II_D9_F9*/ {0xe9, 1247},
	/*II_D9_FA*/ {0xe9, 1256},
	/*II_D9_FB*/ {0xe9, 1263},
	/*II_D9_FC*/ {0xe9, 1272},
	/*II_D9_FD*/ {0xe9, 1281},
	/*II_D9_FE*/ {0xe9, 1289},
	/*II_D9_FF*/ {0xe9, 1295},
	/*II_DA_00*/ {0xe6, 1301},
	/*II_DA_01*/ {0xe6, 1308},
	/*II_DA_02*/ {0xe6, 1315},
	/*II_DA_03*/ {0xe6, 1322},
	/*II_DA_04*/ {0xe6, 1330},
	/*II_DA_05*/ {0xe6, 1337},
	/*II_DA_06*/ {0xe6, 1345},
	/*II_DA_07*/ {0xe6, 1352},
	/*II_DA_C0*/ {0xed, 1360},
	/*II_DA_C0*/ {0xed, 1360},
	/*II_DA_C0*/ {0xed, 1360},
	/*II_DA_C0*/ {0xed, 1360},
	/*II_DA_C0*/ {0xed, 1360},
	/*II_DA_C0*/ {0xed, 1360},
	/*II_DA_C0*/ {0xed, 1360},
	/*II_DA_C0*/ {0xed, 1360},
	/*II_DA_C8*/ {0xee, 1368},
	/*II_DA_C8*/ {0xee, 1368},
	/*II_DA_C8*/ {0xee, 1368},
	/*II_DA_C8*/ {0xee, 1368},
	/*II_DA_C8*/ {0xee, 1368},
	/*II_DA_C8*/ {0xee, 1368},
	/*II_DA_C8*/ {0xee, 1368},
	/*II_DA_C8*/ {0xee, 1368},
	/*II_DA_D0*/ {0xef, 1376},
	/*II_DA_D0*/ {0xef, 1376},
	/*II_DA_D0*/ {0xef, 1376},
	/*II_DA_D0*/ {0xef, 1376},
	/*II_DA_D0*/ {0xef, 1376},
	/*II_DA_D0*/ {0xef, 1376},
	/*II_DA_D0*/ {0xef, 1376},
	/*II_DA_D0*/ {0xef, 1376},
	/*II_DA_D8*/ {0xf0, 1385},
	/*II_DA_D8*/ {0xf0, 1385},
	/*II_DA_D8*/ {0xf0, 1385},
	/*II_DA_D8*/ {0xf0, 1385},
	/*II_DA_D8*/ {0xf0, 1385},
	/*II_DA_D8*/ {0xf0, 1385},
	/*II_DA_D8*/ {0xf0, 1385},
	/*II_DA_D8*/ {0xf0, 1385},
	/*II_DA_E9*/ {0xe9, 1393},
	/*II_DB_00*/ {0xe6, 1402},
	/*II_DB_01*/ {0xf1, 1408},
	/*II_DB_02*/ {0xea, 1416},
	/*II_DB_03*/ {0xea, 1422},
	/*II_DB_05*/ {0xf2, 1058},
	/*II_DB_07*/ {0xf3, 1068},
	/*II_DB_C0*/ {0xed, 1429},
	/*II_DB_C0*/ {0xed, 1429},
	/*II_DB_C0*/ {0xed, 1429},
	/*II_DB_C0*/ {0xed, 1429},
	/*II_DB_C0*/ {0xed, 1429},
	/*II_DB_C0*/ {0xed, 1429},
	/*II_DB_C0*/ {0xed, 1429},
	/*II_DB_C0*/ {0xed, 1429},
	/*II_DB_C8*/ {0xee, 1438},
	/*II_DB_C8*/ {0xee, 1438},
	/*II_DB_C8*/ {0xee, 1438},
	/*II_DB_C8*/ {0xee, 1438},
	/*II_DB_C8*/ {0xee, 1438},
	/*II_DB_C8*/ {0xee, 1438},
	/*II_DB_C8*/ {0xee, 1438},
	/*II_DB_C8*/ {0xee, 1438},
	/*II_DB_D0*/ {0xef, 1447},
	/*II_DB_D0*/ {0xef, 1447},
	/*II_DB_D0*/ {0xef, 1447},
	/*II_DB_D0*/ {0xef, 1447},
	/*II_DB_D0*/ {0xef, 1447},
	/*II_DB_D0*/ {0xef, 1447},
	/*II_DB_D0*/ {0xef, 1447},
	/*II_DB_D0*/ {0xef, 1447},
	/*II_DB_D8*/ {0xf0, 1457},
	/*II_DB_D8*/ {0xf0, 1457},
	/*II_DB_D8*/ {0xf0, 1457},
	/*II_DB_D8*/ {0xf0, 1457},
	/*II_DB_D8*/ {0xf0, 1457},
	/*II_DB_D8*/ {0xf0, 1457},
	/*II_DB_D8*/ {0xf0, 1457},
	/*II_DB_D8*/ {0xf0, 1457},
	/*II_DB_E0*/ {0xe9, 1466},
	/*II_DB_E1*/ {0xe9, 1472},
	/*II_DB_E4*/ {0xe9, 1480},
	/*II_DB_E8*/ {0xf4, 1488},
	/*II_DB_E8*/ {0xf4, 1488},
	/*II_DB_E8*/ {0xf4, 1488},
	/*II_DB_E8*/ {0xf4, 1488},
	/*II_DB_E8*/ {0xf4, 1488},
	/*II_DB_E8*/ {0xf4, 1488},
	/*II_DB_E8*/ {0xf4, 1488},
	/*II_DB_E8*/ {0xf4, 1488},
	/*II_DB_F0*/ {0xf5, 1496},
	/*II_DB_F0*/ {0xf5, 1496},
	/*II_DB_F0*/ {0xf5, 1496},
	/*II_DB_F0*/ {0xf5, 1496},
	/*II_DB_F0*/ {0xf5, 1496},
	/*II_DB_F0*/ {0xf5, 1496},
	/*II_DB_F0*/ {0xf5, 1496},
	/*II_DB_F0*/ {0xf5, 1496},
	/*II_DC_00*/ {0xf6, 1007},
	/*II_DC_01*/ {0xf6, 1013},
	/*II_DC_02*/ {0xf6, 1019},
	/*II_DC_03*/ {0xf6, 1025},
	/*II_DC_04*/ {0xf6, 1032},
	/*II_DC_05*/ {0xf6, 1038},
	/*II_DC_06*/ {0xf6, 1045},
	/*II_DC_07*/ {0xf6, 1051},
	/*II_DC_C0*/ {0xf7, 1007},
	/*II_DC_C0*/ {0xf7, 1007},
	/*II_DC_C0*/ {0xf7, 1007},
	/*II_DC_C0*/ {0xf7, 1007},
	/*II_DC_C0*/ {0xf7, 1007},
	/*II_DC_C0*/ {0xf7, 1007},
	/*II_DC_C0*/ {0xf7, 1007},
	/*II_DC_C0*/ {0xf7, 1007},
	/*II_DC_C8*/ {0xf7, 1013},
	/*II_DC_C8*/ {0xf7, 1013},
	/*II_DC_C8*/ {0xf7, 1013},
	/*II_DC_C8*/ {0xf7, 1013},
	/*II_DC_C8*/ {0xf7, 1013},
	/*II_DC_C8*/ {0xf7, 1013},
	/*II_DC_C8*/ {0xf7, 1013},
	/*II_DC_C8*/ {0xf7, 1013},
	/*II_DC_E0*/ {0xf7, 1038},
	/*II_DC_E0*/ {0xf7, 1038},
	/*II_DC_E0*/ {0xf7, 1038},
	/*II_DC_E0*/ {0xf7, 1038},
	/*II_DC_E0*/ {0xf7, 1038},
	/*II_DC_E0*/ {0xf7, 1038},
	/*II_DC_E0*/ {0xf7, 1038},
	/*II_DC_E0*/ {0xf7, 1038},
	/*II_DC_E8*/ {0xf7, 1032},
	/*II_DC_E8*/ {0xf7, 1032},
	/*II_DC_E8*/ {0xf7, 1032},
	/*II_DC_E8*/ {0xf7, 1032},
	/*II_DC_E8*/ {0xf7, 1032},
	/*II_DC_E8*/ {0xf7, 1032},
	/*II_DC_E8*/ {0xf7, 1032},
	/*II_DC_E8*/ {0xf7, 1032},
	/*II_DC_F0*/ {0xf7, 1051},
	/*II_DC_F0*/ {0xf7, 1051},
	/*II_DC_F0*/ {0xf7, 1051},
	/*II_DC_F0*/ {0xf7, 1051},
	/*II_DC_F0*/ {0xf7, 1051},
	/*II_DC_F0*/ {0xf7, 1051},
	/*II_DC_F0*/ {0xf7, 1051},
	/*II_DC_F0*/ {0xf7, 1051},
	/*II_DC_F8*/ {0xf7, 1045},
	/*II_DC_F8*/ {0xf7, 1045},
	/*II_DC_F8*/ {0xf7, 1045},
	/*II_DC_F8*/ {0xf7, 1045},
	/*II_DC_F8*/ {0xf7, 1045},
	/*II_DC_F8*/ {0xf7, 1045},
	/*II_DC_F8*/ {0xf7, 1045},
	/*II_DC_F8*/ {0xf7, 1045},
	/*II_DD_00*/ {0xf6, 1058},
	/*II_DD_01*/ {0xf8, 1408},
	/*II_DD_02*/ {0xf9, 1063},
	/*II_DD_03*/ {0xf9, 1068},
	/*II_DD_04*/ {0xeb, 1503},
	/*II_DD_C0*/ {0xe8, 1511},
	/*II_DD_C0*/ {0xe8, 1511},
	/*II_DD_C0*/ {0xe8, 1511},
	/*II_DD_C0*/ {0xe8, 1511},
	/*II_DD_C0*/ {0xe8, 1511},
	/*II_DD_C0*/ {0xe8, 1511},
	/*II_DD_C0*/ {0xe8, 1511},
	/*II_DD_C0*/ {0xe8, 1511},
	/*II_DD_D0*/ {0xe8, 1063},
	/*II_DD_D0*/ {0xe8, 1063},
	/*II_DD_D0*/ {0xe8, 1063},
	/*II_DD_D0*/ {0xe8, 1063},
	/*II_DD_D0*/ {0xe8, 1063},
	/*II_DD_D0*/ {0xe8, 1063},
	/*II_DD_D0*/ {0xe8, 1063},
	/*II_DD_D0*/ {0xe8, 1063},
	/*II_DD_D8*/ {0xe8, 1068},
	/*II_DD_D8*/ {0xe8, 1068},
	/*II_DD_D8*/ {0xe8, 1068},
	/*II_DD_D8*/ {0xe8, 1068},
	/*II_DD_D8*/ {0xe8, 1068},
	/*II_DD_D8*/ {0xe8, 1068},
	/*II_DD_D8*/ {0xe8, 1068},
	/*II_DD_D8*/ {0xe8, 1068},
	/*II_DD_E0*/ {0xf7, 1518},
	/*II_DD_E1*/ {0xe9, 1518},
	/*II_DD_E0*/ {0xf7, 1518},
	/*II_DD_E0*/ {0xf7, 1518},
	/*II_DD_E0*/ {0xf7, 1518},
	/*II_DD_E0*/ {0xf7, 1518},
	/*II_DD_E0*/ {0xf7, 1518},
	/*II_DD_E0*/ {0xf7, 1518},
	/*II_DD_E8*/ {0xe8, 1525},
	/*II_DD_E9*/ {0xe9, 1525},
	/*II_DD_E8*/ {0xe8, 1525},
	/*II_DD_E8*/ {0xe8, 1525},
	/*II_DD_E8*/ {0xe8, 1525},
	/*II_DD_E8*/ {0xe8, 1525},
	/*II_DD_E8*/ {0xe8, 1525},
	/*II_DD_E8*/ {0xe8, 1525},
	/*II_DE_00*/ {0xec, 1301},
	/*II_DE_01*/ {0xec, 1308},
	/*II_DE_02*/ {0xec, 1315},
	/*II_DE_03*/ {0xec, 1322},
	/*II_DE_04*/ {0xec, 1330},
	/*II_DE_05*/ {0xec, 1337},
	/*II_DE_06*/ {0xec, 1345},
	/*II_DE_07*/ {0xec, 1352},
	/*II_DE_C0*/ {0xf7, 1533},
	/*II_DE_C1*/ {0xe9, 1533},
	/*II_DE_C0*/ {0xf7, 1533},
	/*II_DE_C0*/ {0xf7, 1533},
	/*II_DE_C0*/ {0xf7, 1533},
	/*II_DE_C0*/ {0xf7, 1533},
	/*II_DE_C0*/ {0xf7, 1533},
	/*II_DE_C0*/ {0xf7, 1533},
	/*II_DE_C8*/ {0xf7, 1540},
	/*II_DE_C9*/ {0xe9, 1540},
	/*II_DE_C8*/ {0xf7, 1540},
	/*II_DE_C8*/ {0xf7, 1540},
	/*II_DE_C8*/ {0xf7, 1540},
	/*II_DE_C8*/ {0xf7, 1540},
	/*II_DE_C8*/ {0xf7, 1540},
	/*II_DE_C8*/ {0xf7, 1540},
	/*II_DE_D9*/ {0xe9, 1547},
	/*II_DE_E0*/ {0xf7, 1555},
	/*II_DE_E1*/ {0xe9, 1555},
	/*II_DE_E0*/ {0xf7, 1555},
	/*II_DE_E0*/ {0xf7, 1555},
	/*II_DE_E0*/ {0xf7, 1555},
	/*II_DE_E0*/ {0xf7, 1555},
	/*II_DE_E0*/ {0xf7, 1555},
	/*II_DE_E0*/ {0xf7, 1555},
	/*II_DE_E8*/ {0xf7, 1563},
	/*II_DE_E9*/ {0xe9, 1563},
	/*II_DE_E8*/ {0xf7, 1563},
	/*II_DE_E8*/ {0xf7, 1563},
	/*II_DE_E8*/ {0xf7, 1563},
	/*II_DE_E8*/ {0xf7, 1563},
	/*II_DE_E8*/ {0xf7, 1563},
	/*II_DE_E8*/ {0xf7, 1563},
	/*II_DE_F0*/ {0xf7, 1570},
	/*II_DE_F1*/ {0xe9, 1570},
	/*II_DE_F0*/ {0xf7, 1570},
	/*II_DE_F0*/ {0xf7, 1570},
	/*II_DE_F0*/ {0xf7, 1570},
	/*II_DE_F0*/ {0xf7, 1570},
	/*II_DE_F0*/ {0xf7, 1570},
	/*II_DE_F0*/ {0xf7, 1570},
	/*II_DE_F8*/ {0xf7, 1578},
	/*II_DE_F9*/ {0xe9, 1578},
	/*II_DE_F8*/ {0xf7, 1578},
	/*II_DE_F8*/ {0xf7, 1578},
	/*II_DE_F8*/ {0xf7, 1578},
	/*II_DE_F8*/ {0xf7, 1578},
	/*II_DE_F8*/ {0xf7, 1578},
	/*II_DE_F8*/ {0xf7, 1578},
	/*II_DF_00*/ {0xec, 1402},
	/*II_DF_01*/ {0xfa, 1408},
	/*II_DF_02*/ {0xfb, 1416},
	/*II_DF_03*/ {0xfb, 1422},
	/*II_DF_04*/ {0xf2, 1585},
	/*II_DF_05*/ {0xf6, 1402},
	/*II_DF_06*/ {0xf3, 1591},
	/*II_DF_07*/ {0xf9, 1422},
	/*II_DF_E8*/ {0xf4, 1598},
	/*II_DF_E8*/ {0xf4, 1598},
	/*II_DF_E8*/ {0xf4, 1598},
	/*II_DF_E8*/ {0xf4, 1598},
	/*II_DF_E8*/ {0xf4, 1598},
	/*II_DF_E8*/ {0xf4, 1598},
	/*II_DF_E8*/ {0xf4, 1598},
	/*II_DF_E8*/ {0xf4, 1598},
	/*II_DF_F0*/ {0xf4, 1607},
	/*II_DF_F0*/ {0xf4, 1607},
	/*II_DF_F0*/ {0xf4, 1607},
	/*II_DF_F0*/ {0xf4, 1607},
	/*II_DF_F0*/ {0xf4, 1607},
	/*II_DF_F0*/ {0xf4, 1607},
	/*II_DF_F0*/ {0xf4, 1607},
	/*II_DF_F0*/ {0xf4, 1607},
	/*II_F6_00*/ {0xfc, 206},
	/*II_F6_02*/ {0xfd, 1615},
	/*II_F6_03*/ {0xfe, 1620},
	/*II_F6_04*/ {0xff, 1625},
	/*II_F6_05*/ {0xff, 117},
	/*II_F6_06*/ {0x100, 1630},
	/*II_F6_07*/ {0x100, 1635},
	/*II_F7_00*/ {0x101, 206},
	/*II_F7_02*/ {0x102, 1615},
	/*II_F7_03*/ {0x103, 1620},
	/*II_F7_04*/ {0x104, 1625},
	/*II_F7_05*/ {0x104, 117},
	/*II_F7_06*/ {0x105, 1630},
	/*II_F7_07*/ {0x105, 1635},
	/*II_FE_00*/ {0x106, 81},
	/*II_FE_01*/ {0x106, 86},
	/*II_FF_00*/ {0x107, 81},
	/*II_FF_01*/ {0x107, 86},
	/*II_FF_02*/ {0x108, 456},
	/*II_FF_03*/ {0x109, 260},
	/*II_FF_04*/ {0x10a, 462},
	/*II_FF_05*/ {0x10b, 467},
	/*II_FF_06*/ {0x10c, 16},
	/*II_0F_00_00*/ {0x10d, 1641},
	/*II_0F_00_01*/ {0x10e, 1647},
	/*II_0F_00_02*/ {0x10e, 34420},
	/*II_0F_00_03*/ {0x10f, 34426},
	/*II_0F_00_04*/ {0x110, 1663},
	/*II_0F_00_05*/ {0x110, 1669},
	/*II_0F_01_00*/ {0x111, 1675},
	/*II_0F_01_01*/ {0x111, 1681},
	/*II_0F_01_02*/ {0x111, 34455},
	/*II_0F_01_03*/ {0x111, 34461},
	/*II_0F_01_04*/ {0x112, 1699},
	/*II_0F_01_06*/ {0x113, 34473},
	/*II_0F_01_07*/ {0x114, 34479},
	/*II_0F_01_C1*/ {0x115, 1719},
	/*II_0F_01_C2*/ {0x115, 1727},
	/*II_0F_01_C3*/ {0x115, 1737},
	/*II_0F_01_C4*/ {0x115, 1747},
	/*II_0F_01_C8*/ {0x116, 1755},
	/*II_0F_01_C9*/ {0x116, 1764},
	/*II_0F_01_D0*/ {0x88, 1771},
	/*II_0F_01_D1*/ {0x88, 1779},
	/*II_0F_01_D4*/ {0x115, 1787},
	/*II_0F_01_D8*/ {0x117, 1795},
	/*II_0F_01_D9*/ {0x118, 1802},
	/*II_0F_01_DA*/ {0x119, 1811},
	/*II_0F_01_DB*/ {0x119, 1819},
	/*II_0F_01_DC*/ {0x118, 1827},
	/*II_0F_01_DD*/ {0x118, 1833},
	/*II_0F_01_DE*/ {0x119, 1839},
	/*II_0F_01_DF*/ {0x11a, 1847},
	/*II_0F_01_F8*/ {0x11b, 1856},
	/*II_0F_01_F9*/ {0x11b, 1864},
	/*II_0F_0D_00*/ {0x11c, 1872},
	/*II_0F_0D_01*/ {0x11c, 1882},
	/*II_0F_0F_0C*/ {0x11d, 1893},
	/*II_0F_0F_0D*/ {0x11e, 1900},
	/*II_0F_0F_1C*/ {0x11d, 1907},
	/*II_0F_0F_1D*/ {0x11e, 1914},
	/*II_0F_0F_8A*/ {0x11d, 1921},
	/*II_0F_0F_8E*/ {0x11d, 1929},
	/*II_0F_0F_90*/ {0x11e, 1938},
	/*II_0F_0F_94*/ {0x11e, 1947},
	/*II_0F_0F_96*/ {0x11e, 1954},
	/*II_0F_0F_97*/ {0x11e, 1961},
	/*II_0F_0F_9A*/ {0x11e, 1970},
	/*II_0F_0F_9E*/ {0x11e, 1977},
	/*II_0F_0F_A0*/ {0x11e, 1984},
	/*II_0F_0F_A4*/ {0x11e, 1993},
	/*II_0F_0F_A6*/ {0x11e, 2000},
	/*II_0F_0F_A7*/ {0x11e, 2010},
	/*II_0F_0F_AA*/ {0x11e, 2020},
	/*II_0F_0F_AE*/ {0x11e, 2028},
	/*II_0F_0F_B0*/ {0x11e, 2035},
	/*II_0F_0F_B4*/ {0x11e, 2044},
	/*II_0F_0F_B6*/ {0x11e, 2051},
	/*II_0F_0F_B7*/ {0x11e, 2061},
	/*II_0F_0F_BB*/ {0x11d, 2070},
	/*II_0F_0F_BF*/ {0x11e, 2078},
	/*II_0F_10*/ {0x11f, 2087},
	/*II_66_0F_10*/ {0x120, 2095},
	/*II_F3_0F_10*/ {0x121, 2103},
	/*II_F2_0F_10*/ {0x122, 2110},
	/*II_0F_11*/ {0x127, 2087},
	/*II_66_0F_11*/ {0x128, 2095},
	/*II_F3_0F_11*/ {0x129, 2103},
	/*II_F2_0F_11*/ {0x12a, 2110},
	/*II_66_0F_12*/ {0x12f, 2168},
	/*II_F3_0F_12*/ {0x130, 2176},
	/*II_F2_0F_12*/ {0x130, 2186},
	/*II_0F_13*/ {0x134, 2160},
	/*II_66_0F_13*/ {0x135, 2168},
	/*II_0F_14*/ {0x137, 2244},
	/*II_66_0F_14*/ {0x138, 2254},
	/*II_0F_15*/ {0x137, 2286},
	/*II_66_0F_15*/ {0x138, 2296},
	/*II_66_0F_16*/ {0x12f, 2345},
	/*II_F3_0F_16*/ {0x13a, 2353},
	/*II_0F_17*/ {0x134, 2337},
	/*II_66_0F_17*/ {0x135, 2345},
	/*II_0F_18_00*/ {0x13b, 2402},
	/*II_0F_18_01*/ {0x13b, 2415},
	/*II_0F_18_02*/ {0x13b, 2427},
	/*II_0F_18_03*/ {0x13b, 2439},
	/*II_0F_28*/ {0x11f, 2451},
	/*II_66_0F_28*/ {0x120, 2459},
	/*II_0F_29*/ {0x127, 2451},
	/*II_66_0F_29*/ {0x128, 2459},
	/*II_0F_2A*/ {0x13c, 2485},
	/*II_66_0F_2A*/ {0x13d, 2495},
	/*II_F3_0F_2A*/ {0x13e, 2505},
	/*II_F2_0F_2A*/ {0x13f, 2515},
	/*II_0F_2B*/ {0x140, 2547},
	/*II_66_0F_2B*/ {0x141, 2556},
	/*II_F3_0F_2B*/ {0x142, 2565},
	/*II_F2_0F_2B*/ {0x143, 2574},
	/*II_0F_2C*/ {0x145, 2603},
	/*II_66_0F_2C*/ {0x146, 2614},
	/*II_F3_0F_2C*/ {0x147, 2625},
	/*II_F2_0F_2C*/ {0x148, 2636},
	/*II_0F_2D*/ {0x145, 2671},
	/*II_66_0F_2D*/ {0x138, 2681},
	/*II_F3_0F_2D*/ {0x147, 2691},
	/*II_F2_0F_2D*/ {0x148, 2701},
	/*II_0F_2E*/ {0x14a, 2733},
	/*II_66_0F_2E*/ {0x14b, 2742},
	/*II_0F_2F*/ {0x14a, 2771},
	/*II_66_0F_2F*/ {0x14b, 2779},
	/*II_0F_50*/ {0x14e, 2805},
	/*II_66_0F_50*/ {0x14f, 2815},
	/*II_0F_51*/ {0x137, 2847},
	/*II_66_0F_51*/ {0x138, 2855},
	/*II_F3_0F_51*/ {0x151, 2863},
	/*II_F2_0F_51*/ {0x14b, 2871},
	/*II_0F_52*/ {0x137, 2915},
	/*II_F3_0F_52*/ {0x151, 2924},
	/*II_0F_53*/ {0x137, 2953},
	/*II_F3_0F_53*/ {0x151, 2960},
	/*II_0F_54*/ {0x137, 2983},
	/*II_66_0F_54*/ {0x138, 2990},
	/*II_0F_55*/ {0x137, 3013},
	/*II_66_0F_55*/ {0x138, 3021},
	/*II_0F_56*/ {0x137, 3047},
	/*II_66_0F_56*/ {0x138, 3053},
	/*II_0F_57*/ {0x137, 3073},
	/*II_66_0F_57*/ {0x138, 3080},
	/*II_0F_58*/ {0x137, 3103},
	/*II_66_0F_58*/ {0x138, 3110},
	/*II_F3_0F_58*/ {0x151, 3117},
	/*II_F2_0F_58*/ {0x14b, 3124},
	/*II_0F_59*/ {0x137, 3163},
	/*II_66_0F_59*/ {0x138, 3170},
	/*II_F3_0F_59*/ {0x151, 3177},
	/*II_F2_0F_59*/ {0x14b, 3184},
	/*II_0F_5A*/ {0x14b, 3223},
	/*II_66_0F_5A*/ {0x138, 3233},
	/*II_F3_0F_5A*/ {0x152, 3243},
	/*II_F2_0F_5A*/ {0x14b, 3253},
	/*II_0F_5B*/ {0x138, 3307},
	/*II_66_0F_5B*/ {0x138, 3317},
	/*II_F3_0F_5B*/ {0x138, 3327},
	/*II_0F_5C*/ {0x137, 3372},
	/*II_66_0F_5C*/ {0x138, 3379},
	/*II_F3_0F_5C*/ {0x151, 3386},
	/*II_F2_0F_5C*/ {0x14b, 3393},
	/*II_0F_5D*/ {0x137, 3432},
	/*II_66_0F_5D*/ {0x138, 3439},
	/*II_F3_0F_5D*/ {0x151, 3446},
	/*II_F2_0F_5D*/ {0x14b, 3453},
	/*II_0F_5E*/ {0x137, 3492},
	/*II_66_0F_5E*/ {0x138, 3499},
	/*II_F3_0F_5E*/ {0x151, 3506},
	/*II_F2_0F_5E*/ {0x14b, 3513},
	/*II_0F_5F*/ {0x137, 3552},
	/*II_66_0F_5F*/ {0x138, 3559},
	/*II_F3_0F_5F*/ {0x151, 3566},
	/*II_F2_0F_5F*/ {0x14b, 3573},
	/*II_0F_60*/ {0x155, 3612},
	/*II_66_0F_60*/ {0x138, 3612},
	/*II_0F_61*/ {0x155, 3635},
	/*II_66_0F_61*/ {0x138, 3635},
	/*II_0F_62*/ {0x155, 3658},
	/*II_66_0F_62*/ {0x138, 3658},
	/*II_0F_63*/ {0x156, 3681},
	/*II_66_0F_63*/ {0x138, 3681},
	/*II_0F_64*/ {0x156, 3702},
	/*II_66_0F_64*/ {0x138, 3702},
	/*II_0F_65*/ {0x156, 3721},
	/*II_66_0F_65*/ {0x138, 3721},
	/*II_0F_66*/ {0x156, 3740},
	/*II_66_0F_66*/ {0x138, 3740},
	/*II_0F_67*/ {0x156, 3759},
	/*II_66_0F_67*/ {0x138, 3759},
	/*II_0F_68*/ {0x156, 3780},
	/*II_66_0F_68*/ {0x138, 3780},
	/*II_0F_69*/ {0x156, 3803},
	/*II_66_0F_69*/ {0x138, 3803},
	/*II_0F_6A*/ {0x156, 3826},
	/*II_66_0F_6A*/ {0x138, 3826},
	/*II_0F_6B*/ {0x156, 3849},
	/*II_66_0F_6B*/ {0x138, 3849},
	/*II_66_0F_6C*/ {0x138, 3870},
	/*II_66_0F_6D*/ {0x138, 3895},
	/*II_0F_6F*/ {0x15a, 3926},
	/*II_66_0F_6F*/ {0x120, 3946},
	/*II_F3_0F_6F*/ {0x120, 3954},
	/*II_0F_74*/ {0x156, 4043},
	/*II_66_0F_74*/ {0x138, 4043},
	/*II_0F_75*/ {0x156, 4062},
	/*II_66_0F_75*/ {0x138, 4062},
	/*II_0F_76*/ {0x156, 4081},
	/*II_66_0F_76*/ {0x138, 4081},
	/*II_0F_77*/ {0x15e, 4100},
	/*II_0F_78*/ {0x160, 4128},
	/*II_0F_79*/ {0x163, 4152},
	/*II_66_0F_79*/ {0x164, 4136},
	/*II_F2_0F_79*/ {0x165, 4143},
	/*II_0F_7A_30*/ {0x166, 4161},
	/*II_0F_7A_31*/ {0x167, 4171},
	/*II_66_0F_7C*/ {0x168, 4181},
	/*II_F2_0F_7C*/ {0x168, 4189},
	/*II_66_0F_7D*/ {0x168, 4215},
	/*II_F2_0F_7D*/ {0x168, 4223},
	/*II_F3_0F_7E*/ {0x122, 3926},
	/*II_0F_7F*/ {0x16c, 3926},
	/*II_66_0F_7F*/ {0x128, 3946},
	/*II_F3_0F_7F*/ {0x128, 3954},
	/*II_F3_0F_B8*/ {0x170, 4338},
	/*II_0F_BA_04*/ {0x171, 872},
	/*II_0F_BA_05*/ {0x172, 887},
	/*II_0F_BA_06*/ {0x172, 912},
	/*II_0F_BA_07*/ {0x172, 934},
	/*II_0F_BC*/ {0x173, 4346},
	/*II_F3_0F_BC*/ {0x174, 4351},
	/*II_0F_BD*/ {0x173, 4358},
	/*II_F3_0F_BD*/ {0x175, 4363},
	/*II_0F_C7_07*/ {0x185, 6385},
	/*II_66_0F_D0*/ {0x168, 6394},
	/*II_F2_0F_D0*/ {0x168, 6404},
	/*II_0F_D1*/ {0x156, 6436},
	/*II_66_0F_D1*/ {0x138, 6436},
	/*II_0F_D2*/ {0x156, 6451},
	/*II_66_0F_D2*/ {0x138, 6451},
	/*II_0F_D3*/ {0x156, 6466},
	/*II_66_0F_D3*/ {0x138, 6466},
	/*II_0F_D4*/ {0x14b, 6481},
	/*II_66_0F_D4*/ {0x138, 6481},
	/*II_0F_D5*/ {0x156, 6496},
	/*II_66_0F_D5*/ {0x138, 6496},
	/*II_66_0F_D6*/ {0x12a, 3926},
	/*II_F3_0F_D6*/ {0x186, 6513},
	/*II_F2_0F_D6*/ {0x187, 6522},
	/*II_0F_D7*/ {0x189, 6531},
	/*II_66_0F_D7*/ {0x18a, 6531},
	/*II_0F_D8*/ {0x156, 6552},
	/*II_66_0F_D8*/ {0x138, 6552},
	/*II_0F_D9*/ {0x156, 6571},
	/*II_66_0F_D9*/ {0x138, 6571},
	/*II_0F_DA*/ {0x18c, 6590},
	/*II_66_0F_DA*/ {0x138, 6590},
	/*II_0F_DB*/ {0x156, 6607},
	/*II_66_0F_DB*/ {0x138, 6607},
	/*II_0F_DC*/ {0x156, 6620},
	/*II_66_0F_DC*/ {0x138, 6620},
	/*II_0F_DD*/ {0x156, 6639},
	/*II_66_0F_DD*/ {0x138, 6639},
	/*II_0F_DE*/ {0x18c, 6648},
	/*II_66_0F_DE*/ {0x138, 6648},
	/*II_0F_DF*/ {0x156, 6665},
	/*II_66_0F_DF*/ {0x138, 6665},
	/*II_0F_E0*/ {0x18c, 6680},
	/*II_66_0F_E0*/ {0x138, 6680},
	/*II_0F_E1*/ {0x156, 6695},
	/*II_66_0F_E1*/ {0x138, 6695},
	/*II_0F_E2*/ {0x156, 6710},
	/*II_66_0F_E2*/ {0x138, 6710},
	/*II_0F_E3*/ {0x18c, 6725},
	/*II_66_0F_E3*/ {0x138, 6725},
	/*II_0F_E4*/ {0x18c, 6740},
	/*II_66_0F_E4*/ {0x138, 6740},
	/*II_0F_E5*/ {0x156, 6759},
	/*II_66_0F_E5*/ {0x138, 6759},
	/*II_66_0F_E6*/ {0x138, 6776},
	/*II_F3_0F_E6*/ {0x14b, 6787},
	/*II_F2_0F_E6*/ {0x138, 6797},
	/*II_0F_E7*/ {0x18d, 6841},
	/*II_66_0F_E7*/ {0x141, 6849},
	/*II_0F_E8*/ {0x156, 6868},
	/*II_66_0F_E8*/ {0x138, 6868},
	/*II_0F_E9*/ {0x156, 6885},
	/*II_66_0F_E9*/ {0x138, 6885},
	/*II_0F_EA*/ {0x18c, 6902},
	/*II_66_0F_EA*/ {0x138, 6902},
	/*II_0F_EB*/ {0x156, 6919},
	/*II_66_0F_EB*/ {0x138, 6919},
	/*II_0F_EC*/ {0x156, 6930},
	/*II_66_0F_EC*/ {0x138, 6930},
	/*II_0F_ED*/ {0x156, 6947},
	/*II_66_0F_ED*/ {0x138, 6947},
	/*II_0F_EE*/ {0x18c, 6964},
	/*II_66_0F_EE*/ {0x138, 6964},
	/*II_0F_EF*/ {0x156, 6981},
	/*II_66_0F_EF*/ {0x138, 6981},
	/*II_F2_0F_F0*/ {0x18e, 6994},
	/*II_0F_F1*/ {0x156, 7009},
	/*II_66_0F_F1*/ {0x138, 7009},
	/*II_0F_F2*/ {0x156, 7024},
	/*II_66_0F_F2*/ {0x138, 7024},
	/*II_0F_F3*/ {0x156, 7039},
	/*II_66_0F_F3*/ {0x138, 7039},
	/*II_0F_F4*/ {0x190, 7054},
	/*II_66_0F_F4*/ {0x138, 7054},
	/*II_0F_F5*/ {0x156, 7073},
	/*II_66_0F_F5*/ {0x138, 7073},
	/*II_0F_F6*/ {0x18c, 7092},
	/*II_66_0F_F6*/ {0x138, 7092},
	/*II_0F_F7*/ {0x191, 7109},
	/*II_66_0F_F7*/ {0x192, 7119},
	/*II_0F_F8*/ {0x156, 7144},
	/*II_66_0F_F8*/ {0x138, 7144},
	/*II_0F_F9*/ {0x156, 7159},
	/*II_66_0F_F9*/ {0x138, 7159},
	/*II_0F_FA*/ {0x156, 7174},
	/*II_66_0F_FA*/ {0x138, 7174},
	/*II_0F_FB*/ {0x190, 7189},
	/*II_66_0F_FB*/ {0x138, 7189},
	/*II_0F_FC*/ {0x156, 7204},
	/*II_66_0F_FC*/ {0x138, 7204},
	/*II_0F_FD*/ {0x156, 7219},
	/*II_66_0F_FD*/ {0x138, 7219},
	/*II_0F_FE*/ {0x156, 7234},
	/*II_66_0F_FE*/ {0x138, 7234},
	/*II_D9_06*/ {0x194, 7249},
	/*II_9B_D9_06*/ {0x195, 7258},
	/*II_D9_07*/ {0xfb, 7266},
	/*II_9B_D9_07*/ {0x196, 7274},
	/*II_DB_E2*/ {0xe9, 7281},
	/*II_9B_DB_E2*/ {0x197, 7289},
	/*II_DB_E3*/ {0xe9, 7296},
	/*II_9B_DB_E3*/ {0x197, 7304},
	/*II_DD_06*/ {0x194, 7311},
	/*II_9B_DD_06*/ {0x195, 7319},
	/*II_DD_07*/ {0xfb, 7326},
	/*II_9B_DD_07*/ {0x196, 7334},
	/*II_DF_E0*/ {0x198, 7326},
	/*II_9B_DF_E0*/ {0x199, 7334},
	/*II_0F_38_00*/ {0x19a, 7341},
	/*II_66_0F_38_00*/ {0x19b, 7341},
	/*II_0F_38_01*/ {0x19a, 7358},
	/*II_66_0F_38_01*/ {0x19b, 7358},
	/*II_0F_38_02*/ {0x19a, 7375},
	/*II_66_0F_38_02*/ {0x19b, 7375},
	/*II_0F_38_03*/ {0x19a, 7392},
	/*II_66_0F_38_03*/ {0x19b, 7392},
	/*II_0F_38_04*/ {0x19a, 7411},
	/*II_66_0F_38_04*/ {0x19b, 7411},
	/*II_0F_38_05*/ {0x19a, 7434},
	/*II_66_0F_38_05*/ {0x19b, 7434},
	/*II_0F_38_06*/ {0x19a, 7451},
	/*II_66_0F_38_06*/ {0x19b, 7451},
	/*II_0F_38_07*/ {0x19a, 7468},
	/*II_66_0F_38_07*/ {0x19b, 7468},
	/*II_0F_38_08*/ {0x19a, 7487},
	/*II_66_0F_38_08*/ {0x19b, 7487},
	/*II_0F_38_09*/ {0x19a, 7504},
	/*II_66_0F_38_09*/ {0x19b, 7504},
	/*II_0F_38_0A*/ {0x19a, 7521},
	/*II_66_0F_38_0A*/ {0x19b, 7521},
	/*II_0F_38_0B*/ {0x19a, 7538},
	/*II_66_0F_38_0B*/ {0x19b, 7538},
	/*II_66_0F_38_17*/ {0x19d, 7629},
	/*II_0F_38_1C*/ {0x19a, 7688},
	/*II_66_0F_38_1C*/ {0x19b, 7688},
	/*II_0F_38_1D*/ {0x19a, 7703},
	/*II_66_0F_38_1D*/ {0x19b, 7703},
	/*II_0F_38_1E*/ {0x19a, 7718},
	/*II_66_0F_38_1E*/ {0x19b, 7718},
	/*II_66_0F_38_20*/ {0x1a2, 7733},
	/*II_66_0F_38_21*/ {0x1a3, 7754},
	/*II_66_0F_38_22*/ {0x1a4, 7775},
	/*II_66_0F_38_23*/ {0x1a2, 7796},
	/*II_66_0F_38_24*/ {0x1a3, 7817},
	/*II_66_0F_38_25*/ {0x1a2, 7838},
	/*II_66_0F_38_28*/ {0x1a6, 7859},
	/*II_66_0F_38_29*/ {0x1a6, 7876},
	/*II_66_0F_38_2A*/ {0x1a7, 7895},
	/*II_66_0F_38_2B*/ {0x1a6, 7916},
	/*II_66_0F_38_30*/ {0x1a2, 7961},
	/*II_66_0F_38_31*/ {0x1a3, 7982},
	/*II_66_0F_38_32*/ {0x1a4, 8003},
	/*II_66_0F_38_33*/ {0x1a2, 8024},
	/*II_66_0F_38_34*/ {0x1a3, 8045},
	/*II_66_0F_38_35*/ {0x1a2, 8066},
	/*II_66_0F_38_37*/ {0x19d, 8087},
	/*II_66_0F_38_38*/ {0x1a6, 8106},
	/*II_66_0F_38_39*/ {0x1a6, 8123},
	/*II_66_0F_38_3A*/ {0x1a6, 8140},
	/*II_66_0F_38_3B*/ {0x1a6, 8157},
	/*II_66_0F_38_3C*/ {0x1a6, 8174},
	/*II_66_0F_38_3D*/ {0x1a6, 8191},
	/*II_66_0F_38_3E*/ {0x1a6, 8208},
	/*II_66_0F_38_3F*/ {0x1a6, 8225},
	/*II_66_0F_38_40*/ {0x1a6, 8242},
	/*II_66_0F_38_41*/ {0x1a6, 8259},
	/*II_66_0F_38_80*/ {0x1aa, 8284},
	/*II_66_0F_38_81*/ {0x1aa, 8292},
	/*II_66_0F_38_82*/ {0x1aa, 8301},
	/*II_66_0F_38_DB*/ {0x1ad, 9150},
	/*II_66_0F_38_DC*/ {0x1ad, 9167},
	/*II_66_0F_38_DD*/ {0x1ad, 9184},
	/*II_66_0F_38_DE*/ {0x1ad, 9209},
	/*II_66_0F_38_DF*/ {0x1ad, 9226},
	/*II_0F_38_F0*/ {0x1b0, 9251},
	/*II_F2_0F_38_F0*/ {0x1b1, 9258},
	/*II_0F_38_F1*/ {0x1b2, 9251},
	/*II_F2_0F_38_F1*/ {0x1b3, 9258},
	/*II_0F_71_02*/ {0x1ca, 6436},
	/*II_66_0F_71_02*/ {0x1cb, 6436},
	/*II_0F_71_04*/ {0x1ca, 6695},
	/*II_66_0F_71_04*/ {0x1cb, 6695},
	/*II_0F_71_06*/ {0x1ca, 7009},
	/*II_66_0F_71_06*/ {0x1cb, 7009},
	/*II_0F_72_02*/ {0x1ca, 6451},
	/*II_66_0F_72_02*/ {0x1cb, 6451},
	/*II_0F_72_04*/ {0x1ca, 6710},
	/*II_66_0F_72_04*/ {0x1cb, 6710},
	/*II_0F_72_06*/ {0x1ca, 7024},
	/*II_66_0F_72_06*/ {0x1cb, 7024},
	/*II_0F_73_02*/ {0x1ca, 6466},
	/*II_66_0F_73_02*/ {0x1cb, 6466},
	/*II_66_0F_73_03*/ {0x1cb, 9830},
	/*II_0F_73_06*/ {0x1ca, 7039},
	/*II_66_0F_73_06*/ {0x1cb, 7039},
	/*II_66_0F_73_07*/ {0x1cb, 9847},
	/*II_F3_0F_AE_00*/ {0x1cd, 9882},
	/*II_F3_0F_AE_01*/ {0x1cd, 9912},
	/*II_0F_AE_02*/ {0x114, 9922},
	/*II_F3_0F_AE_02*/ {0x1cd, 9931},
	/*II_0F_AE_03*/ {0x114, 9951},
	/*II_F3_0F_AE_03*/ {0x1cd, 9960},
	/*II_0F_C7_06*/ {0x1cf, 9980},
	/*II_66_0F_C7_06*/ {0x185, 9989},
	/*II_F3_0F_C7_06*/ {0x185, 9998}
};

_InstInfoEx InstInfosEx[381] = {
	/*II_69*/ {0x34, 117, 0x0, 3, 0, 0, 0},
	/*II_6B*/ {0x34, 117, 0x0, 5, 0, 0, 0},
	/*II_98*/ {0x4e, 228, 0x0, 0, 0, 233, 239},
	/*II_99*/ {0x4e, 245, 0x0, 0, 0, 250, 255},
	/*II_E3*/ {0x76, 427, 0x0, 0, 0, 433, 440},
	/*II_0F_A4*/ {0xac, 876, 0x0, 1, 0, 0, 0},
	/*II_0F_A5*/ {0xac, 876, 0x0, 52, 0, 0, 0},
	/*II_0F_AC*/ {0xac, 892, 0x0, 1, 0, 0, 0},
	/*II_0F_AD*/ {0xac, 892, 0x0, 52, 0, 0, 0},
	/*II_V_0F_10*/ {0x123, 2117, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_10*/ {0x123, 2126, 0x41, 0, 0, 0, 0},
	/*II_V_F3_0F_10*/ {0x124, 2135, 0x20, 69, 0, 0, 0},
	/*II_V_F2_0F_10*/ {0x124, 2143, 0x20, 69, 0, 0, 0},
	/*II_VRR_F3_0F_10*/ {0x125, 2135, 0x60, 0, 0, 0, 0},
	/*II_VRR_F2_0F_10*/ {0x126, 2143, 0x60, 0, 0, 0, 0},
	/*II_V_0F_11*/ {0x12b, 2117, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_11*/ {0x12b, 2126, 0x41, 0, 0, 0, 0},
	/*II_V_F3_0F_11*/ {0x124, 2135, 0x20, 69, 0, 0, 0},
	/*II_V_F2_0F_11*/ {0x124, 2143, 0x20, 69, 0, 0, 0},
	/*II_VRR_F3_0F_11*/ {0x12c, 2135, 0x60, 0, 0, 0, 0},
	/*II_VRR_F2_0F_11*/ {0x12d, 2143, 0x60, 0, 0, 0, 0},
	/*II_0F_12*/ {0x12e, 2151, 0x0, 0, 0, 2160, 0},
	/*II_V_0F_12*/ {0x131, 2195, 0x0, 72, 0, 2205, 0},
	/*II_V_66_0F_12*/ {0x132, 2214, 0x0, 46, 0, 0, 0},
	/*II_V_F3_0F_12*/ {0x123, 2223, 0x41, 0, 0, 0, 0},
	/*II_V_F2_0F_12*/ {0x133, 2234, 0x41, 0, 0, 0, 0},
	/*II_V_0F_13*/ {0x136, 2205, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_13*/ {0x136, 2214, 0x40, 0, 0, 0, 0},
	/*II_V_0F_14*/ {0x139, 2264, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_14*/ {0x139, 2275, 0x1, 90, 0, 0, 0},
	/*II_V_0F_15*/ {0x139, 2306, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_15*/ {0x139, 2317, 0x1, 90, 0, 0, 0},
	/*II_0F_16*/ {0x12e, 2328, 0x0, 0, 0, 2337, 0},
	/*II_V_0F_16*/ {0x131, 2363, 0x0, 72, 0, 2373, 0},
	/*II_V_66_0F_16*/ {0x132, 2382, 0x0, 46, 0, 0, 0},
	/*II_V_F3_0F_16*/ {0x123, 2391, 0x41, 0, 0, 0, 0},
	/*II_V_0F_17*/ {0x136, 2373, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_17*/ {0x136, 2382, 0x40, 0, 0, 0, 0},
	/*II_V_0F_28*/ {0x123, 2467, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_28*/ {0x123, 2476, 0x41, 0, 0, 0, 0},
	/*II_V_0F_29*/ {0x12b, 2467, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_29*/ {0x12b, 2476, 0x41, 0, 0, 0, 0},
	/*II_V_F3_0F_2A*/ {0x132, 2525, 0x2, 79, 0, 0, 0},
	/*II_V_F2_0F_2A*/ {0x132, 2536, 0x2, 79, 0, 0, 0},
	/*II_V_0F_2B*/ {0x144, 2583, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_2B*/ {0x144, 2593, 0x41, 0, 0, 0, 0},
	/*II_V_F3_0F_2C*/ {0x149, 2647, 0x42, 0, 0, 0, 0},
	/*II_V_F2_0F_2C*/ {0x149, 2659, 0x42, 0, 0, 0, 0},
	/*II_V_F3_0F_2D*/ {0x149, 2711, 0x42, 0, 0, 0, 0},
	/*II_V_F2_0F_2D*/ {0x149, 2722, 0x42, 0, 0, 0, 0},
	/*II_V_0F_2E*/ {0x14c, 2751, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_2E*/ {0x14d, 2761, 0x40, 0, 0, 0, 0},
	/*II_V_0F_2F*/ {0x14c, 2787, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_2F*/ {0x14d, 2796, 0x40, 0, 0, 0, 0},
	/*II_V_0F_50*/ {0x150, 2825, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_50*/ {0x150, 2836, 0x41, 0, 0, 0, 0},
	/*II_V_0F_51*/ {0x123, 2879, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_51*/ {0x123, 2888, 0x41, 0, 0, 0, 0},
	/*II_V_F3_0F_51*/ {0x132, 2897, 0x0, 71, 0, 0, 0},
	/*II_V_F2_0F_51*/ {0x132, 2906, 0x0, 72, 0, 0, 0},
	/*II_V_0F_52*/ {0x123, 2933, 0x41, 0, 0, 0, 0},
	/*II_V_F3_0F_52*/ {0x132, 2943, 0x0, 71, 0, 0, 0},
	/*II_V_0F_53*/ {0x123, 2967, 0x41, 0, 0, 0, 0},
	/*II_V_F3_0F_53*/ {0x132, 2975, 0x0, 71, 0, 0, 0},
	/*II_V_0F_54*/ {0x139, 2997, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_54*/ {0x139, 3005, 0x1, 90, 0, 0, 0},
	/*II_V_0F_55*/ {0x139, 3029, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_55*/ {0x139, 3038, 0x1, 90, 0, 0, 0},
	/*II_V_0F_56*/ {0x139, 3059, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_56*/ {0x139, 3066, 0x1, 90, 0, 0, 0},
	/*II_V_0F_57*/ {0x139, 3087, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_57*/ {0x139, 3095, 0x1, 90, 0, 0, 0},
	/*II_V_0F_58*/ {0x139, 3131, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_58*/ {0x139, 3139, 0x1, 90, 0, 0, 0},
	/*II_V_F3_0F_58*/ {0x132, 3147, 0x0, 71, 0, 0, 0},
	/*II_V_F2_0F_58*/ {0x132, 3155, 0x0, 72, 0, 0, 0},
	/*II_V_0F_59*/ {0x139, 3191, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_59*/ {0x139, 3199, 0x1, 90, 0, 0, 0},
	/*II_V_F3_0F_59*/ {0x132, 3207, 0x0, 71, 0, 0, 0},
	/*II_V_F2_0F_59*/ {0x132, 3215, 0x0, 72, 0, 0, 0},
	/*II_V_0F_5A*/ {0x153, 3263, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_5A*/ {0x154, 3274, 0x41, 0, 0, 0, 0},
	/*II_V_F3_0F_5A*/ {0x132, 3285, 0x0, 71, 0, 0, 0},
	/*II_V_F2_0F_5A*/ {0x132, 3296, 0x0, 72, 0, 0, 0},
	/*II_V_0F_5B*/ {0x123, 3338, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_5B*/ {0x123, 3349, 0x41, 0, 0, 0, 0},
	/*II_V_F3_0F_5B*/ {0x123, 3360, 0x41, 0, 0, 0, 0},
	/*II_V_0F_5C*/ {0x139, 3400, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_5C*/ {0x139, 3408, 0x1, 90, 0, 0, 0},
	/*II_V_F3_0F_5C*/ {0x132, 3416, 0x0, 71, 0, 0, 0},
	/*II_V_F2_0F_5C*/ {0x132, 3424, 0x0, 72, 0, 0, 0},
	/*II_V_0F_5D*/ {0x139, 3460, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_5D*/ {0x139, 3468, 0x1, 90, 0, 0, 0},
	/*II_V_F3_0F_5D*/ {0x132, 3476, 0x0, 71, 0, 0, 0},
	/*II_V_F2_0F_5D*/ {0x132, 3484, 0x0, 72, 0, 0, 0},
	/*II_V_0F_5E*/ {0x139, 3520, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_5E*/ {0x139, 3528, 0x1, 90, 0, 0, 0},
	/*II_V_F3_0F_5E*/ {0x132, 3536, 0x0, 71, 0, 0, 0},
	/*II_V_F2_0F_5E*/ {0x132, 3544, 0x0, 72, 0, 0, 0},
	/*II_V_0F_5F*/ {0x139, 3580, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_5F*/ {0x139, 3588, 0x1, 90, 0, 0, 0},
	/*II_V_F3_0F_5F*/ {0x132, 3596, 0x0, 71, 0, 0, 0},
	/*II_V_F2_0F_5F*/ {0x132, 3604, 0x0, 72, 0, 0, 0},
	/*II_V_66_0F_60*/ {0x132, 3623, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_61*/ {0x132, 3646, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_62*/ {0x132, 3669, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_63*/ {0x132, 3691, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_64*/ {0x132, 3711, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_65*/ {0x132, 3730, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_66*/ {0x132, 3749, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_67*/ {0x132, 3769, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_68*/ {0x132, 3791, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_69*/ {0x132, 3814, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_6A*/ {0x132, 3837, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_6B*/ {0x132, 3859, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_6C*/ {0x132, 3882, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_6D*/ {0x132, 3907, 0x0, 73, 0, 0, 0},
	/*II_0F_6E*/ {0x157, 3920, 0x0, 0, 0, 0, 3926},
	/*II_66_0F_6E*/ {0x158, 3920, 0x0, 0, 0, 0, 3926},
	/*II_V_66_0F_6E*/ {0x159, 3932, 0x46, 0, 0, 3939, 0},
	/*II_V_66_0F_6F*/ {0x123, 3962, 0x41, 0, 0, 0, 0},
	/*II_V_F3_0F_6F*/ {0x123, 3971, 0x41, 0, 0, 0, 0},
	/*II_0F_70*/ {0x15b, 3980, 0x0, 1, 0, 0, 0},
	/*II_66_0F_70*/ {0x15c, 3988, 0x0, 1, 0, 0, 0},
	/*II_F3_0F_70*/ {0x15c, 3996, 0x0, 1, 0, 0, 0},
	/*II_F2_0F_70*/ {0x15c, 4005, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_70*/ {0x15d, 4014, 0x40, 1, 0, 0, 0},
	/*II_V_F3_0F_70*/ {0x15d, 4023, 0x40, 1, 0, 0, 0},
	/*II_V_F2_0F_70*/ {0x15d, 4033, 0x40, 1, 0, 0, 0},
	/*II_V_66_0F_74*/ {0x132, 4052, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_75*/ {0x132, 4071, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_76*/ {0x132, 4090, 0x0, 73, 0, 0, 0},
	/*II_V_0F_77*/ {0x15f, 4106, 0x49, 0, 0, 4118, 0},
	/*II_66_0F_78*/ {0x161, 4136, 0x0, 8, 0, 0, 0},
	/*II_F2_0F_78*/ {0x162, 4143, 0x0, 7, 8, 0, 0},
	/*II_V_66_0F_7C*/ {0x139, 4197, 0x1, 90, 0, 0, 0},
	/*II_V_F2_0F_7C*/ {0x139, 4206, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_7D*/ {0x139, 4231, 0x1, 90, 0, 0, 0},
	/*II_V_F2_0F_7D*/ {0x139, 4240, 0x1, 90, 0, 0, 0},
	/*II_0F_7E*/ {0x169, 3920, 0x0, 0, 0, 0, 3926},
	/*II_66_0F_7E*/ {0x16a, 3920, 0x0, 0, 0, 0, 3926},
	/*II_V_66_0F_7E*/ {0x16b, 3932, 0x46, 0, 0, 3939, 0},
	/*II_V_F3_0F_7E*/ {0x14d, 3939, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_7F*/ {0x12b, 3962, 0x41, 0, 0, 0, 0},
	/*II_V_F3_0F_7F*/ {0x12b, 3971, 0x41, 0, 0, 0, 0},
	/*II_0F_AE_04*/ {0x16d, 4249, 0x0, 0, 0, 0, 4256},
	/*II_0F_AE_05*/ {0x16e, 4265, 0x0, 0, 0, 4273, 4281},
	/*II_0F_AE_06*/ {0x16e, 4291, 0x0, 0, 0, 4299, 4309},
	/*II_0F_AE_07*/ {0x16f, 4321, 0x0, 0, 0, 4329, 0},
	/*II_0F_C2*/ {0x176, 4370, 0x0, 0, 0, 4379, 4388},
	/*II_66_0F_C2*/ {0x177, 4449, 0x0, 0, 0, 4458, 4467},
	/*II_F3_0F_C2*/ {0x178, 4528, 0x0, 0, 0, 4537, 4546},
	/*II_F2_0F_C2*/ {0x179, 4607, 0x0, 0, 0, 4616, 4625},
	/*II_V_0F_C2*/ {0x17a, 4686, 0x1, 90, 0, 4696, 4706},
	/*II_V_66_0F_C2*/ {0x17a, 5088, 0x1, 90, 0, 5098, 5108},
	/*II_V_F3_0F_C2*/ {0x17b, 5490, 0x0, 71, 0, 5500, 5510},
	/*II_V_F2_0F_C2*/ {0x17b, 5892, 0x0, 72, 0, 5902, 5912},
	/*II_0F_C4*/ {0x17c, 6294, 0x0, 1, 0, 0, 0},
	/*II_66_0F_C4*/ {0x17d, 6294, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_C4*/ {0x17e, 6302, 0x0, 25, 1, 0, 0},
	/*II_0F_C5*/ {0x17f, 6311, 0x0, 1, 0, 0, 0},
	/*II_66_0F_C5*/ {0x180, 6311, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_C5*/ {0x181, 6319, 0x40, 1, 0, 0, 0},
	/*II_0F_C6*/ {0x182, 6328, 0x0, 1, 0, 0, 0},
	/*II_66_0F_C6*/ {0x15c, 6336, 0x0, 1, 0, 0, 0},
	/*II_V_0F_C6*/ {0x183, 6344, 0x1, 90, 1, 0, 0},
	/*II_V_66_0F_C6*/ {0x183, 6353, 0x1, 90, 1, 0, 0},
	/*II_0F_C7_01*/ {0x184, 6362, 0x0, 0, 0, 0, 6373},
	/*II_V_66_0F_D0*/ {0x139, 6414, 0x1, 90, 0, 0, 0},
	/*II_V_F2_0F_D0*/ {0x139, 6425, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_D1*/ {0x132, 6443, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_D2*/ {0x132, 6458, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_D3*/ {0x132, 6473, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_D4*/ {0x132, 6488, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_D5*/ {0x132, 6504, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_D6*/ {0x188, 3939, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_D7*/ {0x18b, 6541, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_D8*/ {0x132, 6561, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_D9*/ {0x132, 6580, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_DA*/ {0x132, 6598, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_DB*/ {0x132, 6613, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_DC*/ {0x132, 6629, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_DD*/ {0x132, 6629, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_DE*/ {0x132, 6656, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_DF*/ {0x132, 6672, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_E0*/ {0x132, 6687, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_E1*/ {0x132, 6702, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_E2*/ {0x132, 6717, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_E3*/ {0x132, 6732, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_E4*/ {0x132, 6749, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_E5*/ {0x132, 6767, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_E6*/ {0x154, 6807, 0x41, 0, 0, 0, 0},
	/*II_V_F3_0F_E6*/ {0x153, 6819, 0x41, 0, 0, 0, 0},
	/*II_V_F2_0F_E6*/ {0x154, 6830, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_E7*/ {0x144, 6858, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_E8*/ {0x132, 6876, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_E9*/ {0x132, 6893, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_EA*/ {0x132, 6910, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_EB*/ {0x132, 6924, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_EC*/ {0x132, 6938, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_ED*/ {0x132, 6955, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_EE*/ {0x132, 6972, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_EF*/ {0x132, 6987, 0x0, 73, 0, 0, 0},
	/*II_V_F2_0F_F0*/ {0x18f, 7001, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_F1*/ {0x132, 7016, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_F2*/ {0x132, 7031, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_F3*/ {0x132, 7046, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_F4*/ {0x132, 7063, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_F5*/ {0x132, 7082, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_F6*/ {0x132, 7100, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_F7*/ {0x193, 7131, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_F8*/ {0x132, 7151, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_F9*/ {0x132, 7166, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_FA*/ {0x132, 7181, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_FB*/ {0x132, 7196, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_FC*/ {0x132, 7211, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_FD*/ {0x132, 7226, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_FE*/ {0x132, 7241, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_00*/ {0x132, 7349, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_01*/ {0x132, 7366, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_02*/ {0x132, 7383, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_03*/ {0x132, 7401, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_04*/ {0x132, 7422, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_05*/ {0x132, 7442, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_06*/ {0x132, 7459, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_07*/ {0x132, 7477, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_08*/ {0x132, 7495, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_09*/ {0x132, 7512, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_0A*/ {0x132, 7529, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_0B*/ {0x132, 7548, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_0C*/ {0x139, 7559, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_38_0D*/ {0x139, 7570, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_38_0E*/ {0x123, 7581, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_38_0F*/ {0x123, 7590, 0x41, 0, 0, 0, 0},
	/*II_66_0F_38_10*/ {0x19c, 7599, 0x0, 74, 0, 0, 0},
	/*II_66_0F_38_14*/ {0x19c, 7609, 0x0, 74, 0, 0, 0},
	/*II_66_0F_38_15*/ {0x19c, 7619, 0x0, 74, 0, 0, 0},
	/*II_V_66_0F_38_17*/ {0x123, 7636, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_38_18*/ {0x19e, 7644, 0x41, 0, 0, 0, 0},
	/*II_V_66_0F_38_19*/ {0x19f, 7658, 0x50, 0, 0, 0, 0},
	/*II_V_66_0F_38_1A*/ {0x1a0, 7672, 0x50, 0, 0, 0, 0},
	/*II_V_66_0F_38_1C*/ {0x1a1, 7695, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_1D*/ {0x1a1, 7710, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_1E*/ {0x1a1, 7725, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_20*/ {0x14d, 7743, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_21*/ {0x14c, 7764, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_22*/ {0x1a5, 7785, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_23*/ {0x14d, 7806, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_24*/ {0x14c, 7827, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_25*/ {0x14d, 7848, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_28*/ {0x132, 7867, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_29*/ {0x132, 7885, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_2A*/ {0x1a8, 7905, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_2B*/ {0x132, 7926, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_2C*/ {0x139, 7937, 0x1, 92, 0, 0, 0},
	/*II_V_66_0F_38_2D*/ {0x139, 7949, 0x1, 92, 0, 0, 0},
	/*II_V_66_0F_38_2E*/ {0x1a9, 7937, 0x1, 83, 0, 0, 0},
	/*II_V_66_0F_38_2F*/ {0x1a9, 7949, 0x1, 83, 0, 0, 0},
	/*II_V_66_0F_38_30*/ {0x14d, 7971, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_31*/ {0x14c, 7992, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_32*/ {0x1a5, 8013, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_33*/ {0x14d, 8034, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_34*/ {0x14c, 8055, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_35*/ {0x14d, 8076, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_37*/ {0x132, 8096, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_38*/ {0x132, 8114, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_39*/ {0x132, 8131, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_3A*/ {0x132, 8148, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_3B*/ {0x132, 8165, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_3C*/ {0x132, 8182, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_3D*/ {0x132, 8199, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_3E*/ {0x132, 8216, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_3F*/ {0x132, 8233, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_40*/ {0x132, 8250, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_41*/ {0x1a1, 8271, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_96*/ {0x1ab, 8310, 0x7, 90, 0, 8326, 0},
	/*II_V_66_0F_38_97*/ {0x1ab, 8342, 0x7, 90, 0, 8358, 0},
	/*II_V_66_0F_38_98*/ {0x1ab, 8374, 0x7, 90, 0, 8387, 0},
	/*II_V_66_0F_38_99*/ {0x1ac, 8400, 0x6, 80, 0, 8413, 0},
	/*II_V_66_0F_38_9A*/ {0x1ab, 8426, 0x7, 90, 0, 8439, 0},
	/*II_V_66_0F_38_9B*/ {0x1ac, 8452, 0x6, 80, 0, 8465, 0},
	/*II_V_66_0F_38_9C*/ {0x1ab, 8478, 0x7, 90, 0, 8492, 0},
	/*II_V_66_0F_38_9D*/ {0x1ac, 8506, 0x6, 80, 0, 8520, 0},
	/*II_V_66_0F_38_9E*/ {0x1ab, 8534, 0x7, 90, 0, 8548, 0},
	/*II_V_66_0F_38_9F*/ {0x1ac, 8562, 0x6, 80, 0, 8576, 0},
	/*II_V_66_0F_38_A6*/ {0x1ab, 8590, 0x7, 90, 0, 8606, 0},
	/*II_V_66_0F_38_A7*/ {0x1ab, 8622, 0x7, 90, 0, 8638, 0},
	/*II_V_66_0F_38_A8*/ {0x1ab, 8654, 0x7, 90, 0, 8667, 0},
	/*II_V_66_0F_38_A9*/ {0x1ac, 8680, 0x6, 80, 0, 8693, 0},
	/*II_V_66_0F_38_AA*/ {0x1ab, 8706, 0x7, 90, 0, 8719, 0},
	/*II_V_66_0F_38_AB*/ {0x1ac, 8732, 0x6, 80, 0, 8745, 0},
	/*II_V_66_0F_38_AC*/ {0x1ab, 8758, 0x7, 90, 0, 8772, 0},
	/*II_V_66_0F_38_AD*/ {0x1ac, 8786, 0x6, 80, 0, 8800, 0},
	/*II_V_66_0F_38_AE*/ {0x1ab, 8814, 0x7, 90, 0, 8828, 0},
	/*II_V_66_0F_38_AF*/ {0x1ac, 8842, 0x6, 80, 0, 8856, 0},
	/*II_V_66_0F_38_B6*/ {0x1ab, 8870, 0x7, 90, 0, 8886, 0},
	/*II_V_66_0F_38_B7*/ {0x1ab, 8902, 0x7, 90, 0, 8918, 0},
	/*II_V_66_0F_38_B8*/ {0x1ab, 8934, 0x7, 90, 0, 8947, 0},
	/*II_V_66_0F_38_B9*/ {0x1ac, 8960, 0x6, 80, 0, 8973, 0},
	/*II_V_66_0F_38_BA*/ {0x1ab, 8986, 0x7, 90, 0, 8999, 0},
	/*II_V_66_0F_38_BB*/ {0x1ac, 9012, 0x6, 80, 0, 9025, 0},
	/*II_V_66_0F_38_BC*/ {0x1ab, 9038, 0x7, 90, 0, 9052, 0},
	/*II_V_66_0F_38_BD*/ {0x1ac, 9066, 0x6, 80, 0, 9080, 0},
	/*II_V_66_0F_38_BE*/ {0x1ab, 9094, 0x7, 90, 0, 9108, 0},
	/*II_V_66_0F_38_BF*/ {0x1ac, 9122, 0x6, 80, 0, 9136, 0},
	/*II_V_66_0F_38_DB*/ {0x1ae, 9158, 0x40, 0, 0, 0, 0},
	/*II_V_66_0F_38_DC*/ {0x1af, 9175, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_DD*/ {0x1af, 9196, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_DE*/ {0x1af, 9217, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_DF*/ {0x1af, 9238, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_3A_04*/ {0x1b4, 7559, 0x41, 1, 0, 0, 0},
	/*II_V_66_0F_3A_05*/ {0x1b4, 7570, 0x41, 1, 0, 0, 0},
	/*II_V_66_0F_3A_06*/ {0x1b5, 9265, 0x10, 86, 1, 0, 0},
	/*II_66_0F_3A_08*/ {0x19c, 9277, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_08*/ {0x1b4, 9286, 0x41, 1, 0, 0, 0},
	/*II_66_0F_3A_09*/ {0x19c, 9296, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_09*/ {0x1b4, 9305, 0x41, 1, 0, 0, 0},
	/*II_66_0F_3A_0A*/ {0x1b6, 9315, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_0A*/ {0x17e, 9324, 0x0, 71, 1, 0, 0},
	/*II_66_0F_3A_0B*/ {0x1b7, 9334, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_0B*/ {0x17e, 9343, 0x0, 72, 1, 0, 0},
	/*II_66_0F_3A_0C*/ {0x19c, 9353, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_0C*/ {0x183, 9362, 0x1, 90, 1, 0, 0},
	/*II_66_0F_3A_0D*/ {0x19c, 9372, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_0D*/ {0x183, 9381, 0x1, 90, 1, 0, 0},
	/*II_66_0F_3A_0E*/ {0x19c, 9391, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_0E*/ {0x17e, 9400, 0x0, 73, 1, 0, 0},
	/*II_0F_3A_0F*/ {0x1b8, 9410, 0x0, 1, 0, 0, 0},
	/*II_66_0F_3A_0F*/ {0x1b9, 9410, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_0F*/ {0x17e, 9419, 0x0, 73, 1, 0, 0},
	/*II_66_0F_3A_14*/ {0x1ba, 9429, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_14*/ {0x1bb, 9437, 0x40, 1, 0, 0, 0},
	/*II_66_0F_3A_15*/ {0x1bc, 6311, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_15*/ {0x1bd, 6319, 0x40, 1, 0, 0, 0},
	/*II_66_0F_3A_16*/ {0x1be, 9446, 0x0, 1, 0, 0, 9454},
	/*II_V_66_0F_3A_16*/ {0x1bf, 9462, 0x46, 1, 0, 9471, 0},
	/*II_66_0F_3A_17*/ {0x1c0, 9480, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_17*/ {0x1c1, 9491, 0x40, 1, 0, 0, 0},
	/*II_V_66_0F_3A_18*/ {0x1b5, 9503, 0x10, 73, 1, 0, 0},
	/*II_V_66_0F_3A_19*/ {0x1c2, 9516, 0x50, 1, 0, 0, 0},
	/*II_66_0F_3A_20*/ {0x1c3, 9530, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_20*/ {0x17e, 9538, 0x0, 76, 1, 0, 0},
	/*II_66_0F_3A_21*/ {0x1b6, 9547, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_21*/ {0x17e, 9557, 0x0, 71, 1, 0, 0},
	/*II_66_0F_3A_22*/ {0x1c4, 9568, 0x0, 1, 0, 0, 9576},
	/*II_V_66_0F_3A_22*/ {0x17e, 9584, 0x6, 79, 1, 9593, 0},
	/*II_66_0F_3A_40*/ {0x19c, 9602, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_40*/ {0x183, 9608, 0x1, 90, 1, 0, 0},
	/*II_66_0F_3A_41*/ {0x19c, 9615, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_41*/ {0x17e, 9621, 0x0, 73, 1, 0, 0},
	/*II_66_0F_3A_42*/ {0x19c, 9628, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_42*/ {0x17e, 9637, 0x0, 73, 1, 0, 0},
	/*II_66_0F_3A_44*/ {0x1c5, 9647, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_44*/ {0x1c6, 9658, 0x0, 73, 1, 0, 0},
	/*II_V_66_0F_3A_4A*/ {0x183, 9670, 0x1, 90, 84, 0, 0},
	/*II_V_66_0F_3A_4B*/ {0x183, 9681, 0x1, 90, 84, 0, 0},
	/*II_V_66_0F_3A_4C*/ {0x17e, 9692, 0x0, 73, 82, 0, 0},
	/*II_66_0F_3A_60*/ {0x1c7, 9703, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_60*/ {0x15d, 9714, 0x40, 1, 0, 0, 0},
	/*II_66_0F_3A_61*/ {0x1c7, 9726, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_61*/ {0x15d, 9737, 0x40, 1, 0, 0, 0},
	/*II_66_0F_3A_62*/ {0x1c7, 9749, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_62*/ {0x15d, 9760, 0x40, 1, 0, 0, 0},
	/*II_66_0F_3A_63*/ {0x1c7, 9772, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_63*/ {0x15d, 9783, 0x40, 1, 0, 0, 0},
	/*II_66_0F_3A_DF*/ {0x1c8, 9795, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_DF*/ {0x1c9, 9812, 0x40, 1, 0, 0, 0},
	/*II_V_66_0F_71_02*/ {0x1cc, 6443, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_71_04*/ {0x1cc, 6702, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_71_06*/ {0x1cc, 7016, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_72_02*/ {0x1cc, 6458, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_72_04*/ {0x1cc, 6717, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_72_06*/ {0x1cc, 7031, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_73_02*/ {0x1cc, 6473, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_73_03*/ {0x1cc, 9838, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_73_06*/ {0x1cc, 7046, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_73_07*/ {0x1cc, 9855, 0x0, 1, 0, 0, 0},
	/*II_0F_AE_00*/ {0x16d, 9864, 0x0, 0, 0, 0, 9872},
	/*II_0F_AE_01*/ {0x16d, 9892, 0x0, 0, 0, 0, 9901},
	/*II_V_0F_AE_02*/ {0x1ce, 9941, 0x40, 0, 0, 0, 0},
	/*II_V_0F_AE_03*/ {0x1ce, 9970, 0x40, 0, 0, 0, 0}
};

_InstNode InstructionsTree[5560] = {
/* 0 - _00 */  0x2000,
/* 1 - _01 */  0x2001,
/* 2 - _02 */  0x2002,
/* 3 - _03 */  0x2003,
/* 4 - _04 */  0x2004,
/* 5 - _05 */  0x2005,
/* 6 - _06 */  0x2006,
/* 7 - _07 */  0x2007,
/* 8 - _08 */  0x2008,
/* 9 - _09 */  0x2009,
/* a - _0A */  0x200a,
/* b - _0B */  0x200b,
/* c - _0C */  0x200c,
/* d - _0D */  0x200d,
/* e - _0E */  0x200e,
/* f - _0F */  0x8100,
/* 10 - _10 */  0x200f,
/* 11 - _11 */  0x2010,
/* 12 - _12 */  0x2011,
/* 13 - _13 */  0x2012,
/* 14 - _14 */  0x2013,
/* 15 - _15 */  0x2014,
/* 16 - _16 */  0x2015,
/* 17 - _17 */  0x2016,
/* 18 - _18 */  0x2017,
/* 19 - _19 */  0x2018,
/* 1a - _1A */  0x2019,
/* 1b - _1B */  0x201a,
/* 1c - _1C */  0x201b,
/* 1d - _1D */  0x201c,
/* 1e - _1E */  0x201d,
/* 1f - _1F */  0x201e,
/* 20 - _20 */  0x201f,
/* 21 - _21 */  0x2020,
/* 22 - _22 */  0x2021,
/* 23 - _23 */  0x2022,
/* 24 - _24 */  0x2023,
/* 25 - _25 */  0x2024,
/* 26 -  */  0,
/* 27 - _27 */  0x2025,
/* 28 - _28 */  0x2026,
/* 29 - _29 */  0x2027,
/* 2a - _2A */  0x2028,
/* 2b - _2B */  0x2029,
/* 2c - _2C */  0x202a,
/* 2d - _2D */  0x202b,
/* 2e -  */  0,
/* 2f - _2F */  0x202c,
/* 30 - _30 */  0x202d,
/* 31 - _31 */  0x202e,
/* 32 - _32 */  0x202f,
/* 33 - _33 */  0x2030,
/* 34 - _34 */  0x2031,
/* 35 - _35 */  0x2032,
/* 36 -  */  0,
/* 37 - _37 */  0x2033,
/* 38 - _38 */  0x2034,
/* 39 - _39 */  0x2035,
/* 3a - _3A */  0x2036,
/* 3b - _3B */  0x2037,
/* 3c - _3C */  0x2038,
/* 3d - _3D */  0x2039,
/* 3e -  */  0,
/* 3f - _3F */  0x203a,
/* 40 - _40 */  0x203b,
/* 41 - _40 */  0x203c,
/* 42 - _40 */  0x203d,
/* 43 - _40 */  0x203e,
/* 44 - _40 */  0x203f,
/* 45 - _40 */  0x2040,
/* 46 - _40 */  0x2041,
/* 47 - _40 */  0x2042,
/* 48 - _48 */  0x2043,
/* 49 - _48 */  0x2044,
/* 4a - _48 */  0x2045,
/* 4b - _48 */  0x2046,
/* 4c - _48 */  0x2047,
/* 4d - _48 */  0x2048,
/* 4e - _48 */  0x2049,
/* 4f - _48 */  0x204a,
/* 50 - _50 */  0x204b,
/* 51 - _50 */  0x204c,
/* 52 - _50 */  0x204d,
/* 53 - _50 */  0x204e,
/* 54 - _50 */  0x204f,
/* 55 - _50 */  0x2050,
/* 56 - _50 */  0x2051,
/* 57 - _50 */  0x2052,
/* 58 - _58 */  0x2053,
/* 59 - _58 */  0x2054,
/* 5a - _58 */  0x2055,
/* 5b - _58 */  0x2056,
/* 5c - _58 */  0x2057,
/* 5d - _58 */  0x2058,
/* 5e - _58 */  0x2059,
/* 5f - _58 */  0x205a,
/* 60 - _60 */  0x205b,
/* 61 - _61 */  0x205c,
/* 62 - _62 */  0x205d,
/* 63 - _63 */  0x205e,
/* 64 -  */  0,
/* 65 -  */  0,
/* 66 -  */  0,
/* 67 -  */  0,
/* 68 - _68 */  0x205f,
/* 69 - _69 */  0x4000,
/* 6a - _6A */  0x2060,
/* 6b - _6B */  0x4001,
/* 6c - _6C */  0x2061,
/* 6d - _6D */  0x2062,
/* 6e - _6E */  0x2063,
/* 6f - _6F */  0x2064,
/* 70 - _70 */  0x2065,
/* 71 - _71 */  0x2066,
/* 72 - _72 */  0x2067,
/* 73 - _73 */  0x2068,
/* 74 - _74 */  0x2069,
/* 75 - _75 */  0x206a,
/* 76 - _76 */  0x206b,
/* 77 - _77 */  0x206c,
/* 78 - _78 */  0x206d,
/* 79 - _79 */  0x206e,
/* 7a - _7A */  0x206f,
/* 7b - _7B */  0x2070,
/* 7c - _7C */  0x2071,
/* 7d - _7D */  0x2072,
/* 7e - _7E */  0x2073,
/* 7f - _7F */  0x2074,
/* 80 - _80 */  0x6200,
/* 81 - _81 */  0x6208,
/* 82 - _82 */  0x6210,
/* 83 - _83 */  0x6218,
/* 84 - _84 */  0x2075,
/* 85 - _85 */  0x2076,
/* 86 - _86 */  0x2077,
/* 87 - _87 */  0x2078,
/* 88 - _88 */  0x2079,
/* 89 - _89 */  0x207a,
/* 8a - _8A */  0x207b,
/* 8b - _8B */  0x207c,
/* 8c - _8C */  0x207d,
/* 8d - _8D */  0x207e,
/* 8e - _8E */  0x207f,
/* 8f - _8F */  0x6220,
/* 90 - _90 */  0x2080,
/* 91 - _91 */  0x2081,
/* 92 - _92 */  0x2082,
/* 93 - _93 */  0x2083,
/* 94 - _94 */  0x2084,
/* 95 - _95 */  0x2085,
/* 96 - _96 */  0x2086,
/* 97 - _97 */  0x2087,
/* 98 - _98 */  0x4002,
/* 99 - _99 */  0x4003,
/* 9a - _9A */  0x2088,
/* 9b -  */  0,
/* 9c - _9C */  0x2089,
/* 9d - _9D */  0x208a,
/* 9e - _9E */  0x208b,
/* 9f - _9F */  0x208c,
/* a0 - _A0 */  0x208d,
/* a1 - _A1 */  0x208e,
/* a2 - _A2 */  0x208f,
/* a3 - _A3 */  0x2090,
/* a4 - _A4 */  0x2091,
/* a5 - _A5 */  0x2092,
/* a6 - _A6 */  0x2093,
/* a7 - _A7 */  0x2094,
/* a8 - _A8 */  0x2095,
/* a9 - _A9 */  0x2096,
/* aa - _AA */  0x2097,
/* ab - _AB */  0x2098,
/* ac - _AC */  0x2099,
/* ad - _AD */  0x209a,
/* ae - _AE */  0x209b,
/* af - _AF */  0x209c,
/* b0 - _B0 */  0x209d,
/* b1 - _B0 */  0x209e,
/* b2 - _B0 */  0x209f,
/* b3 - _B0 */  0x20a0,
/* b4 - _B0 */  0x20a1,
/* b5 - _B0 */  0x20a2,
/* b6 - _B0 */  0x20a3,
/* b7 - _B0 */  0x20a4,
/* b8 - _B8 */  0x20a5,
/* b9 - _B8 */  0x20a6,
/* ba - _B8 */  0x20a7,
/* bb - _B8 */  0x20a8,
/* bc - _B8 */  0x20a9,
/* bd - _B8 */  0x20aa,
/* be - _B8 */  0x20ab,
/* bf - _B8 */  0x20ac,
/* c0 - _C0 */  0x6228,
/* c1 - _C1 */  0x6230,
/* c2 - _C2 */  0x20ad,
/* c3 - _C3 */  0x20ae,
/* c4 - _C4 */  0x20af,
/* c5 - _C5 */  0x20b0,
/* c6 - _C6 */  0x6238,
/* c7 - _C7 */  0x6240,
/* c8 - _C8 */  0x20b1,
/* c9 - _C9 */  0x20b2,
/* ca - _CA */  0x20b3,
/* cb - _CB */  0x20b4,
/* cc - _CC */  0x20b5,
/* cd - _CD */  0x20b6,
/* ce - _CE */  0x20b7,
/* cf - _CF */  0x20b8,
/* d0 - _D0 */  0x6248,
/* d1 - _D1 */  0x6250,
/* d2 - _D2 */  0x6258,
/* d3 - _D3 */  0x6260,
/* d4 - _D4 */  0x20b9,
/* d5 - _D5 */  0x20ba,
/* d6 - _D6 */  0x20bb,
/* d7 - _D7 */  0x20bc,
/* d8 - _D8 */  0xa268,
/* d9 - _D9 */  0xa2b0,
/* da - _DA */  0xa2f8,
/* db - _DB */  0xa340,
/* dc - _DC */  0xa388,
/* dd - _DD */  0xa3d0,
/* de - _DE */  0xa418,
/* df - _DF */  0xa460,
/* e0 - _E0 */  0x20bd,
/* e1 - _E1 */  0x20be,
/* e2 - _E2 */  0x20bf,
/* e3 - _E3 */  0x4004,
/* e4 - _E4 */  0x20c0,
/* e5 - _E5 */  0x20c1,
/* e6 - _E6 */  0x20c2,
/* e7 - _E7 */  0x20c3,
/* e8 - _E8 */  0x20c4,
/* e9 - _E9 */  0x20c5,
/* ea - _EA */  0x20c6,
/* eb - _EB */  0x20c7,
/* ec - _EC */  0x20c8,
/* ed - _ED */  0x20c9,
/* ee - _EE */  0x20ca,
/* ef - _EF */  0x20cb,
/* f0 -  */  0,
/* f1 - _F1 */  0x20cc,
/* f2 -  */  0,
/* f3 -  */  0,
/* f4 - _F4 */  0x20cd,
/* f5 - _F5 */  0x20ce,
/* f6 - _F6 */  0x64a8,
/* f7 - _F7 */  0x64b0,
/* f8 - _F8 */  0x20cf,
/* f9 - _F9 */  0x20d0,
/* fa - _FA */  0x20d1,
/* fb - _FB */  0x20d2,
/* fc - _FC */  0x20d3,
/* fd - _FD */  0x20d4,
/* fe - _FE */  0x64b8,
/* ff - _FF */  0x64c0,
/* 100 - _0F_00 */  0x64c8,
/* 101 - _0F_01 */  0xa4d0,
/* 102 - _0F_02 */  0x20d5,
/* 103 - _0F_03 */  0x20d6,
/* 104 -  */  0,
/* 105 - _0F_05 */  0x20d7,
/* 106 - _0F_06 */  0x20d8,
/* 107 - _0F_07 */  0x20d9,
/* 108 - _0F_08 */  0x20da,
/* 109 - _0F_09 */  0x20db,
/* 10a -  */  0,
/* 10b - _0F_0B */  0x20dc,
/* 10c -  */  0,
/* 10d - _0F_0D */  0x6518,
/* 10e - _0F_0E */  0x20dd,
/* 10f - _0F_0F */  0x8520,
/* 110 - _0F_10 */  0xc620,
/* 111 - _0F_11 */  0xc62c,
/* 112 - _0F_12 */  0xc638,
/* 113 - _0F_13 */  0xc644,
/* 114 - _0F_14 */  0xc650,
/* 115 - _0F_15 */  0xc65c,
/* 116 - _0F_16 */  0xc668,
/* 117 - _0F_17 */  0xc674,
/* 118 - _0F_18 */  0x6680,
/* 119 -  */  0,
/* 11a -  */  0,
/* 11b -  */  0,
/* 11c -  */  0,
/* 11d -  */  0,
/* 11e -  */  0,
/* 11f - _0F_1F */  0x20de,
/* 120 - _0F_20 */  0x20df,
/* 121 - _0F_21 */  0x20e0,
/* 122 - _0F_22 */  0x20e1,
/* 123 - _0F_23 */  0x20e2,
/* 124 -  */  0,
/* 125 -  */  0,
/* 126 -  */  0,
/* 127 -  */  0,
/* 128 - _0F_28 */  0xc688,
/* 129 - _0F_29 */  0xc694,
/* 12a - _0F_2A */  0xc6a0,
/* 12b - _0F_2B */  0xc6ac,
/* 12c - _0F_2C */  0xc6b8,
/* 12d - _0F_2D */  0xc6c4,
/* 12e - _0F_2E */  0xc6d0,
/* 12f - _0F_2F */  0xc6dc,
/* 130 - _0F_30 */  0x20e3,
/* 131 - _0F_31 */  0x20e4,
/* 132 - _0F_32 */  0x20e5,
/* 133 - _0F_33 */  0x20e6,
/* 134 - _0F_34 */  0x20e7,
/* 135 - _0F_35 */  0x20e8,
/* 136 -  */  0,
/* 137 - _0F_37 */  0x20e9,
/* 138 - _0F_38 */  0x86e8,
/* 139 -  */  0,
/* 13a - _0F_3A */  0x87e8,
/* 13b -  */  0,
/* 13c -  */  0,
/* 13d -  */  0,
/* 13e -  */  0,
/* 13f -  */  0,
/* 140 - _0F_40 */  0x20ea,
/* 141 - _0F_41 */  0x20eb,
/* 142 - _0F_42 */  0x20ec,
/* 143 - _0F_43 */  0x20ed,
/* 144 - _0F_44 */  0x20ee,
/* 145 - _0F_45 */  0x20ef,
/* 146 - _0F_46 */  0x20f0,
/* 147 - _0F_47 */  0x20f1,
/* 148 - _0F_48 */  0x20f2,
/* 149 - _0F_49 */  0x20f3,
/* 14a - _0F_4A */  0x20f4,
/* 14b - _0F_4B */  0x20f5,
/* 14c - _0F_4C */  0x20f6,
/* 14d - _0F_4D */  0x20f7,
/* 14e - _0F_4E */  0x20f8,
/* 14f - _0F_4F */  0x20f9,
/* 150 - _0F_50 */  0xc8e8,
/* 151 - _0F_51 */  0xc8f4,
/* 152 - _0F_52 */  0xc900,
/* 153 - _0F_53 */  0xc90c,
/* 154 - _0F_54 */  0xc918,
/* 155 - _0F_55 */  0xc924,
/* 156 - _0F_56 */  0xc930,
/* 157 - _0F_57 */  0xc93c,
/* 158 - _0F_58 */  0xc948,
/* 159 - _0F_59 */  0xc954,
/* 15a - _0F_5A */  0xc960,
/* 15b - _0F_5B */  0xc96c,
/* 15c - _0F_5C */  0xc978,
/* 15d - _0F_5D */  0xc984,
/* 15e - _0F_5E */  0xc990,
/* 15f - _0F_5F */  0xc99c,
/* 160 - _0F_60 */  0xc9a8,
/* 161 - _0F_61 */  0xc9b4,
/* 162 - _0F_62 */  0xc9c0,
/* 163 - _0F_63 */  0xc9cc,
/* 164 - _0F_64 */  0xc9d8,
/* 165 - _0F_65 */  0xc9e4,
/* 166 - _0F_66 */  0xc9f0,
/* 167 - _0F_67 */  0xc9fc,
/* 168 - _0F_68 */  0xca08,
/* 169 - _0F_69 */  0xca14,
/* 16a - _0F_6A */  0xca20,
/* 16b - _0F_6B */  0xca2c,
/* 16c - _0F_6C */  0xca38,
/* 16d - _0F_6D */  0xca44,
/* 16e - _0F_6E */  0xca50,
/* 16f - _0F_6F */  0xca5c,
/* 170 - _0F_70 */  0xca68,
/* 171 - _0F_71 */  0x6a74,
/* 172 - _0F_72 */  0x6a7c,
/* 173 - _0F_73 */  0x6a84,
/* 174 - _0F_74 */  0xca8c,
/* 175 - _0F_75 */  0xca98,
/* 176 - _0F_76 */  0xcaa4,
/* 177 - _0F_77 */  0xcab0,
/* 178 - _0F_78 */  0xcabc,
/* 179 - _0F_79 */  0xcac8,
/* 17a - _0F_7A */  0x8ad4,
/* 17b -  */  0,
/* 17c - _0F_7C */  0xcbd4,
/* 17d - _0F_7D */  0xcbe0,
/* 17e - _0F_7E */  0xcbec,
/* 17f - _0F_7F */  0xcbf8,
/* 180 - _0F_80 */  0x20fa,
/* 181 - _0F_81 */  0x20fb,
/* 182 - _0F_82 */  0x20fc,
/* 183 - _0F_83 */  0x20fd,
/* 184 - _0F_84 */  0x20fe,
/* 185 - _0F_85 */  0x20ff,
/* 186 - _0F_86 */  0x2100,
/* 187 - _0F_87 */  0x2101,
/* 188 - _0F_88 */  0x2102,
/* 189 - _0F_89 */  0x2103,
/* 18a - _0F_8A */  0x2104,
/* 18b - _0F_8B */  0x2105,
/* 18c - _0F_8C */  0x2106,
/* 18d - _0F_8D */  0x2107,
/* 18e - _0F_8E */  0x2108,
/* 18f - _0F_8F */  0x2109,
/* 190 - _0F_90 */  0x210a,
/* 191 - _0F_91 */  0x210b,
/* 192 - _0F_92 */  0x210c,
/* 193 - _0F_93 */  0x210d,
/* 194 - _0F_94 */  0x210e,
/* 195 - _0F_95 */  0x210f,
/* 196 - _0F_96 */  0x2110,
/* 197 - _0F_97 */  0x2111,
/* 198 - _0F_98 */  0x2112,
/* 199 - _0F_99 */  0x2113,
/* 19a - _0F_9A */  0x2114,
/* 19b - _0F_9B */  0x2115,
/* 19c - _0F_9C */  0x2116,
/* 19d - _0F_9D */  0x2117,
/* 19e - _0F_9E */  0x2118,
/* 19f - _0F_9F */  0x2119,
/* 1a0 - _0F_A0 */  0x211a,
/* 1a1 - _0F_A1 */  0x211b,
/* 1a2 - _0F_A2 */  0x211c,
/* 1a3 - _0F_A3 */  0x211d,
/* 1a4 - _0F_A4 */  0x4005,
/* 1a5 - _0F_A5 */  0x4006,
/* 1a6 -  */  0,
/* 1a7 -  */  0,
/* 1a8 - _0F_A8 */  0x211e,
/* 1a9 - _0F_A9 */  0x211f,
/* 1aa - _0F_AA */  0x2120,
/* 1ab - _0F_AB */  0x2121,
/* 1ac - _0F_AC */  0x4007,
/* 1ad - _0F_AD */  0x4008,
/* 1ae - _0F_AE */  0x6c04,
/* 1af - _0F_AF */  0x2122,
/* 1b0 - _0F_B0 */  0x2123,
/* 1b1 - _0F_B1 */  0x2124,
/* 1b2 - _0F_B2 */  0x2125,
/* 1b3 - _0F_B3 */  0x2126,
/* 1b4 - _0F_B4 */  0x2127,
/* 1b5 - _0F_B5 */  0x2128,
/* 1b6 - _0F_B6 */  0x2129,
/* 1b7 - _0F_B7 */  0x212a,
/* 1b8 - _0F_B8 */  0xcc0c,
/* 1b9 - _0F_B9 */  0x212b,
/* 1ba - _0F_BA */  0x6c18,
/* 1bb - _0F_BB */  0x212c,
/* 1bc - _0F_BC */  0xcc20,
/* 1bd - _0F_BD */  0xcc2c,
/* 1be - _0F_BE */  0x212d,
/* 1bf - _0F_BF */  0x212e,
/* 1c0 - _0F_C0 */  0x212f,
/* 1c1 - _0F_C1 */  0x2130,
/* 1c2 - _0F_C2 */  0xcc38,
/* 1c3 - _0F_C3 */  0x2131,
/* 1c4 - _0F_C4 */  0xcc44,
/* 1c5 - _0F_C5 */  0xcc50,
/* 1c6 - _0F_C6 */  0xcc5c,
/* 1c7 - _0F_C7 */  0x6c68,
/* 1c8 - _0F_C8 */  0x2132,
/* 1c9 - _0F_C8 */  0x2133,
/* 1ca - _0F_C8 */  0x2134,
/* 1cb - _0F_C8 */  0x2135,
/* 1cc - _0F_C8 */  0x2136,
/* 1cd - _0F_C8 */  0x2137,
/* 1ce - _0F_C8 */  0x2138,
/* 1cf - _0F_C8 */  0x2139,
/* 1d0 - _0F_D0 */  0xcc70,
/* 1d1 - _0F_D1 */  0xcc7c,
/* 1d2 - _0F_D2 */  0xcc88,
/* 1d3 - _0F_D3 */  0xcc94,
/* 1d4 - _0F_D4 */  0xcca0,
/* 1d5 - _0F_D5 */  0xccac,
/* 1d6 - _0F_D6 */  0xccb8,
/* 1d7 - _0F_D7 */  0xccc4,
/* 1d8 - _0F_D8 */  0xccd0,
/* 1d9 - _0F_D9 */  0xccdc,
/* 1da - _0F_DA */  0xcce8,
/* 1db - _0F_DB */  0xccf4,
/* 1dc - _0F_DC */  0xcd00,
/* 1dd - _0F_DD */  0xcd0c,
/* 1de - _0F_DE */  0xcd18,
/* 1df - _0F_DF */  0xcd24,
/* 1e0 - _0F_E0 */  0xcd30,
/* 1e1 - _0F_E1 */  0xcd3c,
/* 1e2 - _0F_E2 */  0xcd48,
/* 1e3 - _0F_E3 */  0xcd54,
/* 1e4 - _0F_E4 */  0xcd60,
/* 1e5 - _0F_E5 */  0xcd6c,
/* 1e6 - _0F_E6 */  0xcd78,
/* 1e7 - _0F_E7 */  0xcd84,
/* 1e8 - _0F_E8 */  0xcd90,
/* 1e9 - _0F_E9 */  0xcd9c,
/* 1ea - _0F_EA */  0xcda8,
/* 1eb - _0F_EB */  0xcdb4,
/* 1ec - _0F_EC */  0xcdc0,
/* 1ed - _0F_ED */  0xcdcc,
/* 1ee - _0F_EE */  0xcdd8,
/* 1ef - _0F_EF */  0xcde4,
/* 1f0 - _0F_F0 */  0xcdf0,
/* 1f1 - _0F_F1 */  0xcdfc,
/* 1f2 - _0F_F2 */  0xce08,
/* 1f3 - _0F_F3 */  0xce14,
/* 1f4 - _0F_F4 */  0xce20,
/* 1f5 - _0F_F5 */  0xce2c,
/* 1f6 - _0F_F6 */  0xce38,
/* 1f7 - _0F_F7 */  0xce44,
/* 1f8 - _0F_F8 */  0xce50,
/* 1f9 - _0F_F9 */  0xce5c,
/* 1fa - _0F_FA */  0xce68,
/* 1fb - _0F_FB */  0xce74,
/* 1fc - _0F_FC */  0xce80,
/* 1fd - _0F_FD */  0xce8c,
/* 1fe - _0F_FE */  0xce98,
/* 1ff -  */  0,
/* 200 - _80_00 */  0x213a,
/* 201 - _80_01 */  0x213b,
/* 202 - _80_02 */  0x213c,
/* 203 - _80_03 */  0x213d,
/* 204 - _80_04 */  0x213e,
/* 205 - _80_05 */  0x213f,
/* 206 - _80_06 */  0x2140,
/* 207 - _80_07 */  0x2141,
/* 208 - _81_00 */  0x2142,
/* 209 - _81_01 */  0x2143,
/* 20a - _81_02 */  0x2144,
/* 20b - _81_03 */  0x2145,
/* 20c - _81_04 */  0x2146,
/* 20d - _81_05 */  0x2147,
/* 20e - _81_06 */  0x2148,
/* 20f - _81_07 */  0x2149,
/* 210 - _82_00 */  0x214a,
/* 211 - _82_01 */  0x214b,
/* 212 - _82_02 */  0x214c,
/* 213 - _82_03 */  0x214d,
/* 214 - _82_04 */  0x214e,
/* 215 - _82_05 */  0x214f,
/* 216 - _82_06 */  0x2150,
/* 217 - _82_07 */  0x2151,
/* 218 - _83_00 */  0x2152,
/* 219 - _83_01 */  0x2153,
/* 21a - _83_02 */  0x2154,
/* 21b - _83_03 */  0x2155,
/* 21c - _83_04 */  0x2156,
/* 21d - _83_05 */  0x2157,
/* 21e - _83_06 */  0x2158,
/* 21f - _83_07 */  0x2159,
/* 220 - _8F_00 */  0x215a,
/* 221 -  */  0,
/* 222 -  */  0,
/* 223 -  */  0,
/* 224 -  */  0,
/* 225 -  */  0,
/* 226 -  */  0,
/* 227 -  */  0,
/* 228 - _C0_00 */  0x215b,
/* 229 - _C0_01 */  0x215c,
/* 22a - _C0_02 */  0x215d,
/* 22b - _C0_03 */  0x215e,
/* 22c - _C0_04 */  0x215f,
/* 22d - _C0_05 */  0x2160,
/* 22e - _C0_06 */  0x2161,
/* 22f - _C0_07 */  0x2162,
/* 230 - _C1_00 */  0x2163,
/* 231 - _C1_01 */  0x2164,
/* 232 - _C1_02 */  0x2165,
/* 233 - _C1_03 */  0x2166,
/* 234 - _C1_04 */  0x2167,
/* 235 - _C1_05 */  0x2168,
/* 236 - _C1_06 */  0x2169,
/* 237 - _C1_07 */  0x216a,
/* 238 - _C6_00 */  0x216b,
/* 239 -  */  0,
/* 23a -  */  0,
/* 23b -  */  0,
/* 23c -  */  0,
/* 23d -  */  0,
/* 23e -  */  0,
/* 23f -  */  0,
/* 240 - _C7_00 */  0x216c,
/* 241 -  */  0,
/* 242 -  */  0,
/* 243 -  */  0,
/* 244 -  */  0,
/* 245 -  */  0,
/* 246 -  */  0,
/* 247 -  */  0,
/* 248 - _D0_00 */  0x216d,
/* 249 - _D0_01 */  0x216e,
/* 24a - _D0_02 */  0x216f,
/* 24b - _D0_03 */  0x2170,
/* 24c - _D0_04 */  0x2171,
/* 24d - _D0_05 */  0x2172,
/* 24e - _D0_06 */  0x2173,
/* 24f - _D0_07 */  0x2174,
/* 250 - _D1_00 */  0x2175,
/* 251 - _D1_01 */  0x2176,
/* 252 - _D1_02 */  0x2177,
/* 253 - _D1_03 */  0x2178,
/* 254 - _D1_04 */  0x2179,
/* 255 - _D1_05 */  0x217a,
/* 256 - _D1_06 */  0x217b,
/* 257 - _D1_07 */  0x217c,
/* 258 - _D2_00 */  0x217d,
/* 259 - _D2_01 */  0x217e,
/* 25a - _D2_02 */  0x217f,
/* 25b - _D2_03 */  0x2180,
/* 25c - _D2_04 */  0x2181,
/* 25d - _D2_05 */  0x2182,
/* 25e - _D2_06 */  0x2183,
/* 25f - _D2_07 */  0x2184,
/* 260 - _D3_00 */  0x2185,
/* 261 - _D3_01 */  0x2186,
/* 262 - _D3_02 */  0x2187,
/* 263 - _D3_03 */  0x2188,
/* 264 - _D3_04 */  0x2189,
/* 265 - _D3_05 */  0x218a,
/* 266 - _D3_06 */  0x218b,
/* 267 - _D3_07 */  0x218c,
/* 268 - _D8_00 */  0x218d,
/* 269 - _D8_01 */  0x218e,
/* 26a - _D8_02 */  0x218f,
/* 26b - _D8_03 */  0x2190,
/* 26c - _D8_04 */  0x2191,
/* 26d - _D8_05 */  0x2192,
/* 26e - _D8_06 */  0x2193,
/* 26f - _D8_07 */  0x2194,
/* 270 - _D8_C0 */  0x2195,
/* 271 - _D8_C0 */  0x2196,
/* 272 - _D8_C0 */  0x2197,
/* 273 - _D8_C0 */  0x2198,
/* 274 - _D8_C0 */  0x2199,
/* 275 - _D8_C0 */  0x219a,
/* 276 - _D8_C0 */  0x219b,
/* 277 - _D8_C0 */  0x219c,
/* 278 - _D8_C8 */  0x219d,
/* 279 - _D8_C8 */  0x219e,
/* 27a - _D8_C8 */  0x219f,
/* 27b - _D8_C8 */  0x21a0,
/* 27c - _D8_C8 */  0x21a1,
/* 27d - _D8_C8 */  0x21a2,
/* 27e - _D8_C8 */  0x21a3,
/* 27f - _D8_C8 */  0x21a4,
/* 280 - _D8_D0 */  0x21a5,
/* 281 - _D8_D0 */  0x21a6,
/* 282 - _D8_D0 */  0x21a7,
/* 283 - _D8_D0 */  0x21a8,
/* 284 - _D8_D0 */  0x21a9,
/* 285 - _D8_D0 */  0x21aa,
/* 286 - _D8_D0 */  0x21ab,
/* 287 - _D8_D0 */  0x21ac,
/* 288 - _D8_D8 */  0x21ad,
/* 289 - _D8_D9 */  0x21ae,
/* 28a - _D8_D8 */  0x21af,
/* 28b - _D8_D8 */  0x21b0,
/* 28c - _D8_D8 */  0x21b1,
/* 28d - _D8_D8 */  0x21b2,
/* 28e - _D8_D8 */  0x21b3,
/* 28f - _D8_D8 */  0x21b4,
/* 290 - _D8_E0 */  0x21b5,
/* 291 - _D8_E0 */  0x21b6,
/* 292 - _D8_E0 */  0x21b7,
/* 293 - _D8_E0 */  0x21b8,
/* 294 - _D8_E0 */  0x21b9,
/* 295 - _D8_E0 */  0x21ba,
/* 296 - _D8_E0 */  0x21bb,
/* 297 - _D8_E0 */  0x21bc,
/* 298 - _D8_E8 */  0x21bd,
/* 299 - _D8_E8 */  0x21be,
/* 29a - _D8_E8 */  0x21bf,
/* 29b - _D8_E8 */  0x21c0,
/* 29c - _D8_E8 */  0x21c1,
/* 29d - _D8_E8 */  0x21c2,
/* 29e - _D8_E8 */  0x21c3,
/* 29f - _D8_E8 */  0x21c4,
/* 2a0 - _D8_F0 */  0x21c5,
/* 2a1 - _D8_F0 */  0x21c6,
/* 2a2 - _D8_F0 */  0x21c7,
/* 2a3 - _D8_F0 */  0x21c8,
/* 2a4 - _D8_F0 */  0x21c9,
/* 2a5 - _D8_F0 */  0x21ca,
/* 2a6 - _D8_F0 */  0x21cb,
/* 2a7 - _D8_F0 */  0x21cc,
/* 2a8 - _D8_F8 */  0x21cd,
/* 2a9 - _D8_F8 */  0x21ce,
/* 2aa - _D8_F8 */  0x21cf,
/* 2ab - _D8_F8 */  0x21d0,
/* 2ac - _D8_F8 */  0x21d1,
/* 2ad - _D8_F8 */  0x21d2,
/* 2ae - _D8_F8 */  0x21d3,
/* 2af - _D8_F8 */  0x21d4,
/* 2b0 - _D9_00 */  0x21d5,
/* 2b1 -  */  0,
/* 2b2 - _D9_02 */  0x21d6,
/* 2b3 - _D9_03 */  0x21d7,
/* 2b4 - _D9_04 */  0x21d8,
/* 2b5 - _D9_05 */  0x21d9,
/* 2b6 - _D9_06 */  0xcea4,
/* 2b7 - _D9_07 */  0xceb0,
/* 2b8 - _D9_C0 */  0x21da,
/* 2b9 - _D9_C0 */  0x21db,
/* 2ba - _D9_C0 */  0x21dc,
/* 2bb - _D9_C0 */  0x21dd,
/* 2bc - _D9_C0 */  0x21de,
/* 2bd - _D9_C0 */  0x21df,
/* 2be - _D9_C0 */  0x21e0,
/* 2bf - _D9_C0 */  0x21e1,
/* 2c0 - _D9_C8 */  0x21e2,
/* 2c1 - _D9_C9 */  0x21e3,
/* 2c2 - _D9_C8 */  0x21e4,
/* 2c3 - _D9_C8 */  0x21e5,
/* 2c4 - _D9_C8 */  0x21e6,
/* 2c5 - _D9_C8 */  0x21e7,
/* 2c6 - _D9_C8 */  0x21e8,
/* 2c7 - _D9_C8 */  0x21e9,
/* 2c8 - _D9_D0 */  0x21ea,
/* 2c9 -  */  0,
/* 2ca -  */  0,
/* 2cb -  */  0,
/* 2cc -  */  0,
/* 2cd -  */  0,
/* 2ce -  */  0,
/* 2cf -  */  0,
/* 2d0 -  */  0,
/* 2d1 -  */  0,
/* 2d2 -  */  0,
/* 2d3 -  */  0,
/* 2d4 -  */  0,
/* 2d5 -  */  0,
/* 2d6 -  */  0,
/* 2d7 -  */  0,
/* 2d8 - _D9_E0 */  0x21eb,
/* 2d9 - _D9_E1 */  0x21ec,
/* 2da -  */  0,
/* 2db -  */  0,
/* 2dc - _D9_E4 */  0x21ed,
/* 2dd - _D9_E5 */  0x21ee,
/* 2de -  */  0,
/* 2df -  */  0,
/* 2e0 - _D9_E8 */  0x21ef,
/* 2e1 - _D9_E9 */  0x21f0,
/* 2e2 - _D9_EA */  0x21f1,
/* 2e3 - _D9_EB */  0x21f2,
/* 2e4 - _D9_EC */  0x21f3,
/* 2e5 - _D9_ED */  0x21f4,
/* 2e6 - _D9_EE */  0x21f5,
/* 2e7 -  */  0,
/* 2e8 - _D9_F0 */  0x21f6,
/* 2e9 - _D9_F1 */  0x21f7,
/* 2ea - _D9_F2 */  0x21f8,
/* 2eb - _D9_F3 */  0x21f9,
/* 2ec - _D9_F4 */  0x21fa,
/* 2ed - _D9_F5 */  0x21fb,
/* 2ee - _D9_F6 */  0x21fc,
/* 2ef - _D9_F7 */  0x21fd,
/* 2f0 - _D9_F8 */  0x21fe,
/* 2f1 - _D9_F9 */  0x21ff,
/* 2f2 - _D9_FA */  0x2200,
/* 2f3 - _D9_FB */  0x2201,
/* 2f4 - _D9_FC */  0x2202,
/* 2f5 - _D9_FD */  0x2203,
/* 2f6 - _D9_FE */  0x2204,
/* 2f7 - _D9_FF */  0x2205,
/* 2f8 - _DA_00 */  0x2206,
/* 2f9 - _DA_01 */  0x2207,
/* 2fa - _DA_02 */  0x2208,
/* 2fb - _DA_03 */  0x2209,
/* 2fc - _DA_04 */  0x220a,
/* 2fd - _DA_05 */  0x220b,
/* 2fe - _DA_06 */  0x220c,
/* 2ff - _DA_07 */  0x220d,
/* 300 - _DA_C0 */  0x220e,
/* 301 - _DA_C0 */  0x220f,
/* 302 - _DA_C0 */  0x2210,
/* 303 - _DA_C0 */  0x2211,
/* 304 - _DA_C0 */  0x2212,
/* 305 - _DA_C0 */  0x2213,
/* 306 - _DA_C0 */  0x2214,
/* 307 - _DA_C0 */  0x2215,
/* 308 - _DA_C8 */  0x2216,
/* 309 - _DA_C8 */  0x2217,
/* 30a - _DA_C8 */  0x2218,
/* 30b - _DA_C8 */  0x2219,
/* 30c - _DA_C8 */  0x221a,
/* 30d - _DA_C8 */  0x221b,
/* 30e - _DA_C8 */  0x221c,
/* 30f - _DA_C8 */  0x221d,
/* 310 - _DA_D0 */  0x221e,
/* 311 - _DA_D0 */  0x221f,
/* 312 - _DA_D0 */  0x2220,
/* 313 - _DA_D0 */  0x2221,
/* 314 - _DA_D0 */  0x2222,
/* 315 - _DA_D0 */  0x2223,
/* 316 - _DA_D0 */  0x2224,
/* 317 - _DA_D0 */  0x2225,
/* 318 - _DA_D8 */  0x2226,
/* 319 - _DA_D8 */  0x2227,
/* 31a - _DA_D8 */  0x2228,
/* 31b - _DA_D8 */  0x2229,
/* 31c - _DA_D8 */  0x222a,
/* 31d - _DA_D8 */  0x222b,
/* 31e - _DA_D8 */  0x222c,
/* 31f - _DA_D8 */  0x222d,
/* 320 -  */  0,
/* 321 -  */  0,
/* 322 -  */  0,
/* 323 -  */  0,
/* 324 -  */  0,
/* 325 -  */  0,
/* 326 -  */  0,
/* 327 -  */  0,
/* 328 -  */  0,
/* 329 - _DA_E9 */  0x222e,
/* 32a -  */  0,
/* 32b -  */  0,
/* 32c -  */  0,
/* 32d -  */  0,
/* 32e -  */  0,
/* 32f -  */  0,
/* 330 -  */  0,
/* 331 -  */  0,
/* 332 -  */  0,
/* 333 -  */  0,
/* 334 -  */  0,
/* 335 -  */  0,
/* 336 -  */  0,
/* 337 -  */  0,
/* 338 -  */  0,
/* 339 -  */  0,
/* 33a -  */  0,
/* 33b -  */  0,
/* 33c -  */  0,
/* 33d -  */  0,
/* 33e -  */  0,
/* 33f -  */  0,
/* 340 - _DB_00 */  0x222f,
/* 341 - _DB_01 */  0x2230,
/* 342 - _DB_02 */  0x2231,
/* 343 - _DB_03 */  0x2232,
/* 344 -  */  0,
/* 345 - _DB_05 */  0x2233,
/* 346 -  */  0,
/* 347 - _DB_07 */  0x2234,
/* 348 - _DB_C0 */  0x2235,
/* 349 - _DB_C0 */  0x2236,
/* 34a - _DB_C0 */  0x2237,
/* 34b - _DB_C0 */  0x2238,
/* 34c - _DB_C0 */  0x2239,
/* 34d - _DB_C0 */  0x223a,
/* 34e - _DB_C0 */  0x223b,
/* 34f - _DB_C0 */  0x223c,
/* 350 - _DB_C8 */  0x223d,
/* 351 - _DB_C8 */  0x223e,
/* 352 - _DB_C8 */  0x223f,
/* 353 - _DB_C8 */  0x2240,
/* 354 - _DB_C8 */  0x2241,
/* 355 - _DB_C8 */  0x2242,
/* 356 - _DB_C8 */  0x2243,
/* 357 - _DB_C8 */  0x2244,
/* 358 - _DB_D0 */  0x2245,
/* 359 - _DB_D0 */  0x2246,
/* 35a - _DB_D0 */  0x2247,
/* 35b - _DB_D0 */  0x2248,
/* 35c - _DB_D0 */  0x2249,
/* 35d - _DB_D0 */  0x224a,
/* 35e - _DB_D0 */  0x224b,
/* 35f - _DB_D0 */  0x224c,
/* 360 - _DB_D8 */  0x224d,
/* 361 - _DB_D8 */  0x224e,
/* 362 - _DB_D8 */  0x224f,
/* 363 - _DB_D8 */  0x2250,
/* 364 - _DB_D8 */  0x2251,
/* 365 - _DB_D8 */  0x2252,
/* 366 - _DB_D8 */  0x2253,
/* 367 - _DB_D8 */  0x2254,
/* 368 - _DB_E0 */  0x2255,
/* 369 - _DB_E1 */  0x2256,
/* 36a - _DB_E2 */  0xcebc,
/* 36b - _DB_E3 */  0xcec8,
/* 36c - _DB_E4 */  0x2257,
/* 36d -  */  0,
/* 36e -  */  0,
/* 36f -  */  0,
/* 370 - _DB_E8 */  0x2258,
/* 371 - _DB_E8 */  0x2259,
/* 372 - _DB_E8 */  0x225a,
/* 373 - _DB_E8 */  0x225b,
/* 374 - _DB_E8 */  0x225c,
/* 375 - _DB_E8 */  0x225d,
/* 376 - _DB_E8 */  0x225e,
/* 377 - _DB_E8 */  0x225f,
/* 378 - _DB_F0 */  0x2260,
/* 379 - _DB_F0 */  0x2261,
/* 37a - _DB_F0 */  0x2262,
/* 37b - _DB_F0 */  0x2263,
/* 37c - _DB_F0 */  0x2264,
/* 37d - _DB_F0 */  0x2265,
/* 37e - _DB_F0 */  0x2266,
/* 37f - _DB_F0 */  0x2267,
/* 380 -  */  0,
/* 381 -  */  0,
/* 382 -  */  0,
/* 383 -  */  0,
/* 384 -  */  0,
/* 385 -  */  0,
/* 386 -  */  0,
/* 387 -  */  0,
/* 388 - _DC_00 */  0x2268,
/* 389 - _DC_01 */  0x2269,
/* 38a - _DC_02 */  0x226a,
/* 38b - _DC_03 */  0x226b,
/* 38c - _DC_04 */  0x226c,
/* 38d - _DC_05 */  0x226d,
/* 38e - _DC_06 */  0x226e,
/* 38f - _DC_07 */  0x226f,
/* 390 - _DC_C0 */  0x2270,
/* 391 - _DC_C0 */  0x2271,
/* 392 - _DC_C0 */  0x2272,
/* 393 - _DC_C0 */  0x2273,
/* 394 - _DC_C0 */  0x2274,
/* 395 - _DC_C0 */  0x2275,
/* 396 - _DC_C0 */  0x2276,
/* 397 - _DC_C0 */  0x2277,
/* 398 - _DC_C8 */  0x2278,
/* 399 - _DC_C8 */  0x2279,
/* 39a - _DC_C8 */  0x227a,
/* 39b - _DC_C8 */  0x227b,
/* 39c - _DC_C8 */  0x227c,
/* 39d - _DC_C8 */  0x227d,
/* 39e - _DC_C8 */  0x227e,
/* 39f - _DC_C8 */  0x227f,
/* 3a0 -  */  0,
/* 3a1 -  */  0,
/* 3a2 -  */  0,
/* 3a3 -  */  0,
/* 3a4 -  */  0,
/* 3a5 -  */  0,
/* 3a6 -  */  0,
/* 3a7 -  */  0,
/* 3a8 -  */  0,
/* 3a9 -  */  0,
/* 3aa -  */  0,
/* 3ab -  */  0,
/* 3ac -  */  0,
/* 3ad -  */  0,
/* 3ae -  */  0,
/* 3af -  */  0,
/* 3b0 - _DC_E0 */  0x2280,
/* 3b1 - _DC_E0 */  0x2281,
/* 3b2 - _DC_E0 */  0x2282,
/* 3b3 - _DC_E0 */  0x2283,
/* 3b4 - _DC_E0 */  0x2284,
/* 3b5 - _DC_E0 */  0x2285,
/* 3b6 - _DC_E0 */  0x2286,
/* 3b7 - _DC_E0 */  0x2287,
/* 3b8 - _DC_E8 */  0x2288,
/* 3b9 - _DC_E8 */  0x2289,
/* 3ba - _DC_E8 */  0x228a,
/* 3bb - _DC_E8 */  0x228b,
/* 3bc - _DC_E8 */  0x228c,
/* 3bd - _DC_E8 */  0x228d,
/* 3be - _DC_E8 */  0x228e,
/* 3bf - _DC_E8 */  0x228f,
/* 3c0 - _DC_F0 */  0x2290,
/* 3c1 - _DC_F0 */  0x2291,
/* 3c2 - _DC_F0 */  0x2292,
/* 3c3 - _DC_F0 */  0x2293,
/* 3c4 - _DC_F0 */  0x2294,
/* 3c5 - _DC_F0 */  0x2295,
/* 3c6 - _DC_F0 */  0x2296,
/* 3c7 - _DC_F0 */  0x2297,
/* 3c8 - _DC_F8 */  0x2298,
/* 3c9 - _DC_F8 */  0x2299,
/* 3ca - _DC_F8 */  0x229a,
/* 3cb - _DC_F8 */  0x229b,
/* 3cc - _DC_F8 */  0x229c,
/* 3cd - _DC_F8 */  0x229d,
/* 3ce - _DC_F8 */  0x229e,
/* 3cf - _DC_F8 */  0x229f,
/* 3d0 - _DD_00 */  0x22a0,
/* 3d1 - _DD_01 */  0x22a1,
/* 3d2 - _DD_02 */  0x22a2,
/* 3d3 - _DD_03 */  0x22a3,
/* 3d4 - _DD_04 */  0x22a4,
/* 3d5 -  */  0,
/* 3d6 - _DD_06 */  0xced4,
/* 3d7 - _DD_07 */  0xcee0,
/* 3d8 - _DD_C0 */  0x22a5,
/* 3d9 - _DD_C0 */  0x22a6,
/* 3da - _DD_C0 */  0x22a7,
/* 3db - _DD_C0 */  0x22a8,
/* 3dc - _DD_C0 */  0x22a9,
/* 3dd - _DD_C0 */  0x22aa,
/* 3de - _DD_C0 */  0x22ab,
/* 3df - _DD_C0 */  0x22ac,
/* 3e0 -  */  0,
/* 3e1 -  */  0,
/* 3e2 -  */  0,
/* 3e3 -  */  0,
/* 3e4 -  */  0,
/* 3e5 -  */  0,
/* 3e6 -  */  0,
/* 3e7 -  */  0,
/* 3e8 - _DD_D0 */  0x22ad,
/* 3e9 - _DD_D0 */  0x22ae,
/* 3ea - _DD_D0 */  0x22af,
/* 3eb - _DD_D0 */  0x22b0,
/* 3ec - _DD_D0 */  0x22b1,
/* 3ed - _DD_D0 */  0x22b2,
/* 3ee - _DD_D0 */  0x22b3,
/* 3ef - _DD_D0 */  0x22b4,
/* 3f0 - _DD_D8 */  0x22b5,
/* 3f1 - _DD_D8 */  0x22b6,
/* 3f2 - _DD_D8 */  0x22b7,
/* 3f3 - _DD_D8 */  0x22b8,
/* 3f4 - _DD_D8 */  0x22b9,
/* 3f5 - _DD_D8 */  0x22ba,
/* 3f6 - _DD_D8 */  0x22bb,
/* 3f7 - _DD_D8 */  0x22bc,
/* 3f8 - _DD_E0 */  0x22bd,
/* 3f9 - _DD_E1 */  0x22be,
/* 3fa - _DD_E0 */  0x22bf,
/* 3fb - _DD_E0 */  0x22c0,
/* 3fc - _DD_E0 */  0x22c1,
/* 3fd - _DD_E0 */  0x22c2,
/* 3fe - _DD_E0 */  0x22c3,
/* 3ff - _DD_E0 */  0x22c4,
/* 400 - _DD_E8 */  0x22c5,
/* 401 - _DD_E9 */  0x22c6,
/* 402 - _DD_E8 */  0x22c7,
/* 403 - _DD_E8 */  0x22c8,
/* 404 - _DD_E8 */  0x22c9,
/* 405 - _DD_E8 */  0x22ca,
/* 406 - _DD_E8 */  0x22cb,
/* 407 - _DD_E8 */  0x22cc,
/* 408 -  */  0,
/* 409 -  */  0,
/* 40a -  */  0,
/* 40b -  */  0,
/* 40c -  */  0,
/* 40d -  */  0,
/* 40e -  */  0,
/* 40f -  */  0,
/* 410 -  */  0,
/* 411 -  */  0,
/* 412 -  */  0,
/* 413 -  */  0,
/* 414 -  */  0,
/* 415 -  */  0,
/* 416 -  */  0,
/* 417 -  */  0,
/* 418 - _DE_00 */  0x22cd,
/* 419 - _DE_01 */  0x22ce,
/* 41a - _DE_02 */  0x22cf,
/* 41b - _DE_03 */  0x22d0,
/* 41c - _DE_04 */  0x22d1,
/* 41d - _DE_05 */  0x22d2,
/* 41e - _DE_06 */  0x22d3,
/* 41f - _DE_07 */  0x22d4,
/* 420 - _DE_C0 */  0x22d5,
/* 421 - _DE_C1 */  0x22d6,
/* 422 - _DE_C0 */  0x22d7,
/* 423 - _DE_C0 */  0x22d8,
/* 424 - _DE_C0 */  0x22d9,
/* 425 - _DE_C0 */  0x22da,
/* 426 - _DE_C0 */  0x22db,
/* 427 - _DE_C0 */  0x22dc,
/* 428 - _DE_C8 */  0x22dd,
/* 429 - _DE_C9 */  0x22de,
/* 42a - _DE_C8 */  0x22df,
/* 42b - _DE_C8 */  0x22e0,
/* 42c - _DE_C8 */  0x22e1,
/* 42d - _DE_C8 */  0x22e2,
/* 42e - _DE_C8 */  0x22e3,
/* 42f - _DE_C8 */  0x22e4,
/* 430 -  */  0,
/* 431 -  */  0,
/* 432 -  */  0,
/* 433 -  */  0,
/* 434 -  */  0,
/* 435 -  */  0,
/* 436 -  */  0,
/* 437 -  */  0,
/* 438 -  */  0,
/* 439 - _DE_D9 */  0x22e5,
/* 43a -  */  0,
/* 43b -  */  0,
/* 43c -  */  0,
/* 43d -  */  0,
/* 43e -  */  0,
/* 43f -  */  0,
/* 440 - _DE_E0 */  0x22e6,
/* 441 - _DE_E1 */  0x22e7,
/* 442 - _DE_E0 */  0x22e8,
/* 443 - _DE_E0 */  0x22e9,
/* 444 - _DE_E0 */  0x22ea,
/* 445 - _DE_E0 */  0x22eb,
/* 446 - _DE_E0 */  0x22ec,
/* 447 - _DE_E0 */  0x22ed,
/* 448 - _DE_E8 */  0x22ee,
/* 449 - _DE_E9 */  0x22ef,
/* 44a - _DE_E8 */  0x22f0,
/* 44b - _DE_E8 */  0x22f1,
/* 44c - _DE_E8 */  0x22f2,
/* 44d - _DE_E8 */  0x22f3,
/* 44e - _DE_E8 */  0x22f4,
/* 44f - _DE_E8 */  0x22f5,
/* 450 - _DE_F0 */  0x22f6,
/* 451 - _DE_F1 */  0x22f7,
/* 452 - _DE_F0 */  0x22f8,
/* 453 - _DE_F0 */  0x22f9,
/* 454 - _DE_F0 */  0x22fa,
/* 455 - _DE_F0 */  0x22fb,
/* 456 - _DE_F0 */  0x22fc,
/* 457 - _DE_F0 */  0x22fd,
/* 458 - _DE_F8 */  0x22fe,
/* 459 - _DE_F9 */  0x22ff,
/* 45a - _DE_F8 */  0x2300,
/* 45b - _DE_F8 */  0x2301,
/* 45c - _DE_F8 */  0x2302,
/* 45d - _DE_F8 */  0x2303,
/* 45e - _DE_F8 */  0x2304,
/* 45f - _DE_F8 */  0x2305,
/* 460 - _DF_00 */  0x2306,
/* 461 - _DF_01 */  0x2307,
/* 462 - _DF_02 */  0x2308,
/* 463 - _DF_03 */  0x2309,
/* 464 - _DF_04 */  0x230a,
/* 465 - _DF_05 */  0x230b,
/* 466 - _DF_06 */  0x230c,
/* 467 - _DF_07 */  0x230d,
/* 468 -  */  0,
/* 469 -  */  0,
/* 46a -  */  0,
/* 46b -  */  0,
/* 46c -  */  0,
/* 46d -  */  0,
/* 46e -  */  0,
/* 46f -  */  0,
/* 470 -  */  0,
/* 471 -  */  0,
/* 472 -  */  0,
/* 473 -  */  0,
/* 474 -  */  0,
/* 475 -  */  0,
/* 476 -  */  0,
/* 477 -  */  0,
/* 478 -  */  0,
/* 479 -  */  0,
/* 47a -  */  0,
/* 47b -  */  0,
/* 47c -  */  0,
/* 47d -  */  0,
/* 47e -  */  0,
/* 47f -  */  0,
/* 480 -  */  0,
/* 481 -  */  0,
/* 482 -  */  0,
/* 483 -  */  0,
/* 484 -  */  0,
/* 485 -  */  0,
/* 486 -  */  0,
/* 487 -  */  0,
/* 488 - _DF_E0 */  0xceec,
/* 489 -  */  0,
/* 48a -  */  0,
/* 48b -  */  0,
/* 48c -  */  0,
/* 48d -  */  0,
/* 48e -  */  0,
/* 48f -  */  0,
/* 490 - _DF_E8 */  0x230e,
/* 491 - _DF_E8 */  0x230f,
/* 492 - _DF_E8 */  0x2310,
/* 493 - _DF_E8 */  0x2311,
/* 494 - _DF_E8 */  0x2312,
/* 495 - _DF_E8 */  0x2313,
/* 496 - _DF_E8 */  0x2314,
/* 497 - _DF_E8 */  0x2315,
/* 498 - _DF_F0 */  0x2316,
/* 499 - _DF_F0 */  0x2317,
/* 49a - _DF_F0 */  0x2318,
/* 49b - _DF_F0 */  0x2319,
/* 49c - _DF_F0 */  0x231a,
/* 49d - _DF_F0 */  0x231b,
/* 49e - _DF_F0 */  0x231c,
/* 49f - _DF_F0 */  0x231d,
/* 4a0 -  */  0,
/* 4a1 -  */  0,
/* 4a2 -  */  0,
/* 4a3 -  */  0,
/* 4a4 -  */  0,
/* 4a5 -  */  0,
/* 4a6 -  */  0,
/* 4a7 -  */  0,
/* 4a8 - _F6_00 */  0x231e,
/* 4a9 -  */  0,
/* 4aa - _F6_02 */  0x231f,
/* 4ab - _F6_03 */  0x2320,
/* 4ac - _F6_04 */  0x2321,
/* 4ad - _F6_05 */  0x2322,
/* 4ae - _F6_06 */  0x2323,
/* 4af - _F6_07 */  0x2324,
/* 4b0 - _F7_00 */  0x2325,
/* 4b1 -  */  0,
/* 4b2 - _F7_02 */  0x2326,
/* 4b3 - _F7_03 */  0x2327,
/* 4b4 - _F7_04 */  0x2328,
/* 4b5 - _F7_05 */  0x2329,
/* 4b6 - _F7_06 */  0x232a,
/* 4b7 - _F7_07 */  0x232b,
/* 4b8 - _FE_00 */  0x232c,
/* 4b9 - _FE_01 */  0x232d,
/* 4ba -  */  0,
/* 4bb -  */  0,
/* 4bc -  */  0,
/* 4bd -  */  0,
/* 4be -  */  0,
/* 4bf -  */  0,
/* 4c0 - _FF_00 */  0x232e,
/* 4c1 - _FF_01 */  0x232f,
/* 4c2 - _FF_02 */  0x2330,
/* 4c3 - _FF_03 */  0x2331,
/* 4c4 - _FF_04 */  0x2332,
/* 4c5 - _FF_05 */  0x2333,
/* 4c6 - _FF_06 */  0x2334,
/* 4c7 -  */  0,
/* 4c8 - _0F_00_00 */  0x2335,
/* 4c9 - _0F_00_01 */  0x2336,
/* 4ca - _0F_00_02 */  0x2337,
/* 4cb - _0F_00_03 */  0x2338,
/* 4cc - _0F_00_04 */  0x2339,
/* 4cd - _0F_00_05 */  0x233a,
/* 4ce -  */  0,
/* 4cf -  */  0,
/* 4d0 - _0F_01_00 */  0x233b,
/* 4d1 - _0F_01_01 */  0x233c,
/* 4d2 - _0F_01_02 */  0x233d,
/* 4d3 - _0F_01_03 */  0x233e,
/* 4d4 - _0F_01_04 */  0x233f,
/* 4d5 -  */  0,
/* 4d6 - _0F_01_06 */  0x2340,
/* 4d7 - _0F_01_07 */  0x2341,
/* 4d8 -  */  0,
/* 4d9 - _0F_01_C1 */  0x2342,
/* 4da - _0F_01_C2 */  0x2343,
/* 4db - _0F_01_C3 */  0x2344,
/* 4dc - _0F_01_C4 */  0x2345,
/* 4dd -  */  0,
/* 4de -  */  0,
/* 4df -  */  0,
/* 4e0 - _0F_01_C8 */  0x2346,
/* 4e1 - _0F_01_C9 */  0x2347,
/* 4e2 -  */  0,
/* 4e3 -  */  0,
/* 4e4 -  */  0,
/* 4e5 -  */  0,
/* 4e6 -  */  0,
/* 4e7 -  */  0,
/* 4e8 - _0F_01_D0 */  0x2348,
/* 4e9 - _0F_01_D1 */  0x2349,
/* 4ea -  */  0,
/* 4eb -  */  0,
/* 4ec - _0F_01_D4 */  0x234a,
/* 4ed -  */  0,
/* 4ee -  */  0,
/* 4ef -  */  0,
/* 4f0 - _0F_01_D8 */  0x234b,
/* 4f1 - _0F_01_D9 */  0x234c,
/* 4f2 - _0F_01_DA */  0x234d,
/* 4f3 - _0F_01_DB */  0x234e,
/* 4f4 - _0F_01_DC */  0x234f,
/* 4f5 - _0F_01_DD */  0x2350,
/* 4f6 - _0F_01_DE */  0x2351,
/* 4f7 - _0F_01_DF */  0x2352,
/* 4f8 -  */  0,
/* 4f9 -  */  0,
/* 4fa -  */  0,
/* 4fb -  */  0,
/* 4fc -  */  0,
/* 4fd -  */  0,
/* 4fe -  */  0,
/* 4ff -  */  0,
/* 500 -  */  0,
/* 501 -  */  0,
/* 502 -  */  0,
/* 503 -  */  0,
/* 504 -  */  0,
/* 505 -  */  0,
/* 506 -  */  0,
/* 507 -  */  0,
/* 508 -  */  0,
/* 509 -  */  0,
/* 50a -  */  0,
/* 50b -  */  0,
/* 50c -  */  0,
/* 50d -  */  0,
/* 50e -  */  0,
/* 50f -  */  0,
/* 510 - _0F_01_F8 */  0x2353,
/* 511 - _0F_01_F9 */  0x2354,
/* 512 -  */  0,
/* 513 -  */  0,
/* 514 -  */  0,
/* 515 -  */  0,
/* 516 -  */  0,
/* 517 -  */  0,
/* 518 - _0F_0D_00 */  0x2355,
/* 519 - _0F_0D_01 */  0x2356,
/* 51a -  */  0,
/* 51b -  */  0,
/* 51c -  */  0,
/* 51d -  */  0,
/* 51e -  */  0,
/* 51f -  */  0,
/* 520 -  */  0,
/* 521 -  */  0,
/* 522 -  */  0,
/* 523 -  */  0,
/* 524 -  */  0,
/* 525 -  */  0,
/* 526 -  */  0,
/* 527 -  */  0,
/* 528 -  */  0,
/* 529 -  */  0,
/* 52a -  */  0,
/* 52b -  */  0,
/* 52c - _0F_0F_0C */  0x2357,
/* 52d - _0F_0F_0D */  0x2358,
/* 52e -  */  0,
/* 52f -  */  0,
/* 530 -  */  0,
/* 531 -  */  0,
/* 532 -  */  0,
/* 533 -  */  0,
/* 534 -  */  0,
/* 535 -  */  0,
/* 536 -  */  0,
/* 537 -  */  0,
/* 538 -  */  0,
/* 539 -  */  0,
/* 53a -  */  0,
/* 53b -  */  0,
/* 53c - _0F_0F_1C */  0x2359,
/* 53d - _0F_0F_1D */  0x235a,
/* 53e -  */  0,
/* 53f -  */  0,
/* 540 -  */  0,
/* 541 -  */  0,
/* 542 -  */  0,
/* 543 -  */  0,
/* 544 -  */  0,
/* 545 -  */  0,
/* 546 -  */  0,
/* 547 -  */  0,
/* 548 -  */  0,
/* 549 -  */  0,
/* 54a -  */  0,
/* 54b -  */  0,
/* 54c -  */  0,
/* 54d -  */  0,
/* 54e -  */  0,
/* 54f -  */  0,
/* 550 -  */  0,
/* 551 -  */  0,
/* 552 -  */  0,
/* 553 -  */  0,
/* 554 -  */  0,
/* 555 -  */  0,
/* 556 -  */  0,
/* 557 -  */  0,
/* 558 -  */  0,
/* 559 -  */  0,
/* 55a -  */  0,
/* 55b -  */  0,
/* 55c -  */  0,
/* 55d -  */  0,
/* 55e -  */  0,
/* 55f -  */  0,
/* 560 -  */  0,
/* 561 -  */  0,
/* 562 -  */  0,
/* 563 -  */  0,
/* 564 -  */  0,
/* 565 -  */  0,
/* 566 -  */  0,
/* 567 -  */  0,
/* 568 -  */  0,
/* 569 -  */  0,
/* 56a -  */  0,
/* 56b -  */  0,
/* 56c -  */  0,
/* 56d -  */  0,
/* 56e -  */  0,
/* 56f -  */  0,
/* 570 -  */  0,
/* 571 -  */  0,
/* 572 -  */  0,
/* 573 -  */  0,
/* 574 -  */  0,
/* 575 -  */  0,
/* 576 -  */  0,
/* 577 -  */  0,
/* 578 -  */  0,
/* 579 -  */  0,
/* 57a -  */  0,
/* 57b -  */  0,
/* 57c -  */  0,
/* 57d -  */  0,
/* 57e -  */  0,
/* 57f -  */  0,
/* 580 -  */  0,
/* 581 -  */  0,
/* 582 -  */  0,
/* 583 -  */  0,
/* 584 -  */  0,
/* 585 -  */  0,
/* 586 -  */  0,
/* 587 -  */  0,
/* 588 -  */  0,
/* 589 -  */  0,
/* 58a -  */  0,
/* 58b -  */  0,
/* 58c -  */  0,
/* 58d -  */  0,
/* 58e -  */  0,
/* 58f -  */  0,
/* 590 -  */  0,
/* 591 -  */  0,
/* 592 -  */  0,
/* 593 -  */  0,
/* 594 -  */  0,
/* 595 -  */  0,
/* 596 -  */  0,
/* 597 -  */  0,
/* 598 -  */  0,
/* 599 -  */  0,
/* 59a -  */  0,
/* 59b -  */  0,
/* 59c -  */  0,
/* 59d -  */  0,
/* 59e -  */  0,
/* 59f -  */  0,
/* 5a0 -  */  0,
/* 5a1 -  */  0,
/* 5a2 -  */  0,
/* 5a3 -  */  0,
/* 5a4 -  */  0,
/* 5a5 -  */  0,
/* 5a6 -  */  0,
/* 5a7 -  */  0,
/* 5a8 -  */  0,
/* 5a9 -  */  0,
/* 5aa - _0F_0F_8A */  0x235b,
/* 5ab -  */  0,
/* 5ac -  */  0,
/* 5ad -  */  0,
/* 5ae - _0F_0F_8E */  0x235c,
/* 5af -  */  0,
/* 5b0 - _0F_0F_90 */  0x235d,
/* 5b1 -  */  0,
/* 5b2 -  */  0,
/* 5b3 -  */  0,
/* 5b4 - _0F_0F_94 */  0x235e,
/* 5b5 -  */  0,
/* 5b6 - _0F_0F_96 */  0x235f,
/* 5b7 - _0F_0F_97 */  0x2360,
/* 5b8 -  */  0,
/* 5b9 -  */  0,
/* 5ba - _0F_0F_9A */  0x2361,
/* 5bb -  */  0,
/* 5bc -  */  0,
/* 5bd -  */  0,
/* 5be - _0F_0F_9E */  0x2362,
/* 5bf -  */  0,
/* 5c0 - _0F_0F_A0 */  0x2363,
/* 5c1 -  */  0,
/* 5c2 -  */  0,
/* 5c3 -  */  0,
/* 5c4 - _0F_0F_A4 */  0x2364,
/* 5c5 -  */  0,
/* 5c6 - _0F_0F_A6 */  0x2365,
/* 5c7 - _0F_0F_A7 */  0x2366,
/* 5c8 -  */  0,
/* 5c9 -  */  0,
/* 5ca - _0F_0F_AA */  0x2367,
/* 5cb -  */  0,
/* 5cc -  */  0,
/* 5cd -  */  0,
/* 5ce - _0F_0F_AE */  0x2368,
/* 5cf -  */  0,
/* 5d0 - _0F_0F_B0 */  0x2369,
/* 5d1 -  */  0,
/* 5d2 -  */  0,
/* 5d3 -  */  0,
/* 5d4 - _0F_0F_B4 */  0x236a,
/* 5d5 -  */  0,
/* 5d6 - _0F_0F_B6 */  0x236b,
/* 5d7 - _0F_0F_B7 */  0x236c,
/* 5d8 -  */  0,
/* 5d9 -  */  0,
/* 5da -  */  0,
/* 5db - _0F_0F_BB */  0x236d,
/* 5dc -  */  0,
/* 5dd -  */  0,
/* 5de -  */  0,
/* 5df - _0F_0F_BF */  0x236e,
/* 5e0 -  */  0,
/* 5e1 -  */  0,
/* 5e2 -  */  0,
/* 5e3 -  */  0,
/* 5e4 -  */  0,
/* 5e5 -  */  0,
/* 5e6 -  */  0,
/* 5e7 -  */  0,
/* 5e8 -  */  0,
/* 5e9 -  */  0,
/* 5ea -  */  0,
/* 5eb -  */  0,
/* 5ec -  */  0,
/* 5ed -  */  0,
/* 5ee -  */  0,
/* 5ef -  */  0,
/* 5f0 -  */  0,
/* 5f1 -  */  0,
/* 5f2 -  */  0,
/* 5f3 -  */  0,
/* 5f4 -  */  0,
/* 5f5 -  */  0,
/* 5f6 -  */  0,
/* 5f7 -  */  0,
/* 5f8 -  */  0,
/* 5f9 -  */  0,
/* 5fa -  */  0,
/* 5fb -  */  0,
/* 5fc -  */  0,
/* 5fd -  */  0,
/* 5fe -  */  0,
/* 5ff -  */  0,
/* 600 -  */  0,
/* 601 -  */  0,
/* 602 -  */  0,
/* 603 -  */  0,
/* 604 -  */  0,
/* 605 -  */  0,
/* 606 -  */  0,
/* 607 -  */  0,
/* 608 -  */  0,
/* 609 -  */  0,
/* 60a -  */  0,
/* 60b -  */  0,
/* 60c -  */  0,
/* 60d -  */  0,
/* 60e -  */  0,
/* 60f -  */  0,
/* 610 -  */  0,
/* 611 -  */  0,
/* 612 -  */  0,
/* 613 -  */  0,
/* 614 -  */  0,
/* 615 -  */  0,
/* 616 -  */  0,
/* 617 -  */  0,
/* 618 -  */  0,
/* 619 -  */  0,
/* 61a -  */  0,
/* 61b -  */  0,
/* 61c -  */  0,
/* 61d -  */  0,
/* 61e -  */  0,
/* 61f -  */  0,
/* 620 - _0F_10 */  0x236f,
/* 621 - _66_0F_10 */  0x2370,
/* 622 - _F3_0F_10 */  0x2371,
/* 623 - _F2_0F_10 */  0x2372,
/* 624 - _V_0F_10 */  0x4009,
/* 625 - _V_66_0F_10 */  0x400a,
/* 626 - _V_F3_0F_10 */  0x400b,
/* 627 - _V_F2_0F_10 */  0x400c,
/* 628 -  */  0,
/* 629 -  */  0,
/* 62a - _VRR_F3_0F_10 */  0x400d,
/* 62b - _VRR_F2_0F_10 */  0x400e,
/* 62c - _0F_11 */  0x2373,
/* 62d - _66_0F_11 */  0x2374,
/* 62e - _F3_0F_11 */  0x2375,
/* 62f - _F2_0F_11 */  0x2376,
/* 630 - _V_0F_11 */  0x400f,
/* 631 - _V_66_0F_11 */  0x4010,
/* 632 - _V_F3_0F_11 */  0x4011,
/* 633 - _V_F2_0F_11 */  0x4012,
/* 634 -  */  0,
/* 635 -  */  0,
/* 636 - _VRR_F3_0F_11 */  0x4013,
/* 637 - _VRR_F2_0F_11 */  0x4014,
/* 638 - _0F_12 */  0x4015,
/* 639 - _66_0F_12 */  0x2377,
/* 63a - _F3_0F_12 */  0x2378,
/* 63b - _F2_0F_12 */  0x2379,
/* 63c - _V_0F_12 */  0x4016,
/* 63d - _V_66_0F_12 */  0x4017,
/* 63e - _V_F3_0F_12 */  0x4018,
/* 63f - _V_F2_0F_12 */  0x4019,
/* 640 -  */  0,
/* 641 -  */  0,
/* 642 -  */  0,
/* 643 -  */  0,
/* 644 - _0F_13 */  0x237a,
/* 645 - _66_0F_13 */  0x237b,
/* 646 -  */  0,
/* 647 -  */  0,
/* 648 - _V_0F_13 */  0x401a,
/* 649 - _V_66_0F_13 */  0x401b,
/* 64a -  */  0,
/* 64b -  */  0,
/* 64c -  */  0,
/* 64d -  */  0,
/* 64e -  */  0,
/* 64f -  */  0,
/* 650 - _0F_14 */  0x237c,
/* 651 - _66_0F_14 */  0x237d,
/* 652 -  */  0,
/* 653 -  */  0,
/* 654 - _V_0F_14 */  0x401c,
/* 655 - _V_66_0F_14 */  0x401d,
/* 656 -  */  0,
/* 657 -  */  0,
/* 658 -  */  0,
/* 659 -  */  0,
/* 65a -  */  0,
/* 65b -  */  0,
/* 65c - _0F_15 */  0x237e,
/* 65d - _66_0F_15 */  0x237f,
/* 65e -  */  0,
/* 65f -  */  0,
/* 660 - _V_0F_15 */  0x401e,
/* 661 - _V_66_0F_15 */  0x401f,
/* 662 -  */  0,
/* 663 -  */  0,
/* 664 -  */  0,
/* 665 -  */  0,
/* 666 -  */  0,
/* 667 -  */  0,
/* 668 - _0F_16 */  0x4020,
/* 669 - _66_0F_16 */  0x2380,
/* 66a - _F3_0F_16 */  0x2381,
/* 66b -  */  0,
/* 66c - _V_0F_16 */  0x4021,
/* 66d - _V_66_0F_16 */  0x4022,
/* 66e - _V_F3_0F_16 */  0x4023,
/* 66f -  */  0,
/* 670 -  */  0,
/* 671 -  */  0,
/* 672 -  */  0,
/* 673 -  */  0,
/* 674 - _0F_17 */  0x2382,
/* 675 - _66_0F_17 */  0x2383,
/* 676 -  */  0,
/* 677 -  */  0,
/* 678 - _V_0F_17 */  0x4024,
/* 679 - _V_66_0F_17 */  0x4025,
/* 67a -  */  0,
/* 67b -  */  0,
/* 67c -  */  0,
/* 67d -  */  0,
/* 67e -  */  0,
/* 67f -  */  0,
/* 680 - _0F_18_00 */  0x2384,
/* 681 - _0F_18_01 */  0x2385,
/* 682 - _0F_18_02 */  0x2386,
/* 683 - _0F_18_03 */  0x2387,
/* 684 -  */  0,
/* 685 -  */  0,
/* 686 -  */  0,
/* 687 -  */  0,
/* 688 - _0F_28 */  0x2388,
/* 689 - _66_0F_28 */  0x2389,
/* 68a -  */  0,
/* 68b -  */  0,
/* 68c - _V_0F_28 */  0x4026,
/* 68d - _V_66_0F_28 */  0x4027,
/* 68e -  */  0,
/* 68f -  */  0,
/* 690 -  */  0,
/* 691 -  */  0,
/* 692 -  */  0,
/* 693 -  */  0,
/* 694 - _0F_29 */  0x238a,
/* 695 - _66_0F_29 */  0x238b,
/* 696 -  */  0,
/* 697 -  */  0,
/* 698 - _V_0F_29 */  0x4028,
/* 699 - _V_66_0F_29 */  0x4029,
/* 69a -  */  0,
/* 69b -  */  0,
/* 69c -  */  0,
/* 69d -  */  0,
/* 69e -  */  0,
/* 69f -  */  0,
/* 6a0 - _0F_2A */  0x238c,
/* 6a1 - _66_0F_2A */  0x238d,
/* 6a2 - _F3_0F_2A */  0x238e,
/* 6a3 - _F2_0F_2A */  0x238f,
/* 6a4 -  */  0,
/* 6a5 -  */  0,
/* 6a6 - _V_F3_0F_2A */  0x402a,
/* 6a7 - _V_F2_0F_2A */  0x402b,
/* 6a8 -  */  0,
/* 6a9 -  */  0,
/* 6aa -  */  0,
/* 6ab -  */  0,
/* 6ac - _0F_2B */  0x2390,
/* 6ad - _66_0F_2B */  0x2391,
/* 6ae - _F3_0F_2B */  0x2392,
/* 6af - _F2_0F_2B */  0x2393,
/* 6b0 - _V_0F_2B */  0x402c,
/* 6b1 - _V_66_0F_2B */  0x402d,
/* 6b2 -  */  0,
/* 6b3 -  */  0,
/* 6b4 -  */  0,
/* 6b5 -  */  0,
/* 6b6 -  */  0,
/* 6b7 -  */  0,
/* 6b8 - _0F_2C */  0x2394,
/* 6b9 - _66_0F_2C */  0x2395,
/* 6ba - _F3_0F_2C */  0x2396,
/* 6bb - _F2_0F_2C */  0x2397,
/* 6bc -  */  0,
/* 6bd -  */  0,
/* 6be - _V_F3_0F_2C */  0x402e,
/* 6bf - _V_F2_0F_2C */  0x402f,
/* 6c0 -  */  0,
/* 6c1 -  */  0,
/* 6c2 -  */  0,
/* 6c3 -  */  0,
/* 6c4 - _0F_2D */  0x2398,
/* 6c5 - _66_0F_2D */  0x2399,
/* 6c6 - _F3_0F_2D */  0x239a,
/* 6c7 - _F2_0F_2D */  0x239b,
/* 6c8 -  */  0,
/* 6c9 -  */  0,
/* 6ca - _V_F3_0F_2D */  0x4030,
/* 6cb - _V_F2_0F_2D */  0x4031,
/* 6cc -  */  0,
/* 6cd -  */  0,
/* 6ce -  */  0,
/* 6cf -  */  0,
/* 6d0 - _0F_2E */  0x239c,
/* 6d1 - _66_0F_2E */  0x239d,
/* 6d2 -  */  0,
/* 6d3 -  */  0,
/* 6d4 - _V_0F_2E */  0x4032,
/* 6d5 - _V_66_0F_2E */  0x4033,
/* 6d6 -  */  0,
/* 6d7 -  */  0,
/* 6d8 -  */  0,
/* 6d9 -  */  0,
/* 6da -  */  0,
/* 6db -  */  0,
/* 6dc - _0F_2F */  0x239e,
/* 6dd - _66_0F_2F */  0x239f,
/* 6de -  */  0,
/* 6df -  */  0,
/* 6e0 - _V_0F_2F */  0x4034,
/* 6e1 - _V_66_0F_2F */  0x4035,
/* 6e2 -  */  0,
/* 6e3 -  */  0,
/* 6e4 -  */  0,
/* 6e5 -  */  0,
/* 6e6 -  */  0,
/* 6e7 -  */  0,
/* 6e8 - _0F_38_00 */  0xcef8,
/* 6e9 - _0F_38_01 */  0xcf04,
/* 6ea - _0F_38_02 */  0xcf10,
/* 6eb - _0F_38_03 */  0xcf1c,
/* 6ec - _0F_38_04 */  0xcf28,
/* 6ed - _0F_38_05 */  0xcf34,
/* 6ee - _0F_38_06 */  0xcf40,
/* 6ef - _0F_38_07 */  0xcf4c,
/* 6f0 - _0F_38_08 */  0xcf58,
/* 6f1 - _0F_38_09 */  0xcf64,
/* 6f2 - _0F_38_0A */  0xcf70,
/* 6f3 - _0F_38_0B */  0xcf7c,
/* 6f4 - _0F_38_0C */  0xcf88,
/* 6f5 - _0F_38_0D */  0xcf94,
/* 6f6 - _0F_38_0E */  0xcfa0,
/* 6f7 - _0F_38_0F */  0xcfac,
/* 6f8 - _0F_38_10 */  0xcfb8,
/* 6f9 -  */  0,
/* 6fa -  */  0,
/* 6fb -  */  0,
/* 6fc - _0F_38_14 */  0xcfc4,
/* 6fd - _0F_38_15 */  0xcfd0,
/* 6fe -  */  0,
/* 6ff - _0F_38_17 */  0xcfdc,
/* 700 - _0F_38_18 */  0xcfe8,
/* 701 - _0F_38_19 */  0xcff4,
/* 702 - _0F_38_1A */  0xd000,
/* 703 -  */  0,
/* 704 - _0F_38_1C */  0xd00c,
/* 705 - _0F_38_1D */  0xd018,
/* 706 - _0F_38_1E */  0xd024,
/* 707 -  */  0,
/* 708 - _0F_38_20 */  0xd030,
/* 709 - _0F_38_21 */  0xd03c,
/* 70a - _0F_38_22 */  0xd048,
/* 70b - _0F_38_23 */  0xd054,
/* 70c - _0F_38_24 */  0xd060,
/* 70d - _0F_38_25 */  0xd06c,
/* 70e -  */  0,
/* 70f -  */  0,
/* 710 - _0F_38_28 */  0xd078,
/* 711 - _0F_38_29 */  0xd084,
/* 712 - _0F_38_2A */  0xd090,
/* 713 - _0F_38_2B */  0xd09c,
/* 714 - _0F_38_2C */  0xd0a8,
/* 715 - _0F_38_2D */  0xd0b4,
/* 716 - _0F_38_2E */  0xd0c0,
/* 717 - _0F_38_2F */  0xd0cc,
/* 718 - _0F_38_30 */  0xd0d8,
/* 719 - _0F_38_31 */  0xd0e4,
/* 71a - _0F_38_32 */  0xd0f0,
/* 71b - _0F_38_33 */  0xd0fc,
/* 71c - _0F_38_34 */  0xd108,
/* 71d - _0F_38_35 */  0xd114,
/* 71e -  */  0,
/* 71f - _0F_38_37 */  0xd120,
/* 720 - _0F_38_38 */  0xd12c,
/* 721 - _0F_38_39 */  0xd138,
/* 722 - _0F_38_3A */  0xd144,
/* 723 - _0F_38_3B */  0xd150,
/* 724 - _0F_38_3C */  0xd15c,
/* 725 - _0F_38_3D */  0xd168,
/* 726 - _0F_38_3E */  0xd174,
/* 727 - _0F_38_3F */  0xd180,
/* 728 - _0F_38_40 */  0xd18c,
/* 729 - _0F_38_41 */  0xd198,
/* 72a -  */  0,
/* 72b -  */  0,
/* 72c -  */  0,
/* 72d -  */  0,
/* 72e -  */  0,
/* 72f -  */  0,
/* 730 -  */  0,
/* 731 -  */  0,
/* 732 -  */  0,
/* 733 -  */  0,
/* 734 -  */  0,
/* 735 -  */  0,
/* 736 -  */  0,
/* 737 -  */  0,
/* 738 -  */  0,
/* 739 -  */  0,
/* 73a -  */  0,
/* 73b -  */  0,
/* 73c -  */  0,
/* 73d -  */  0,
/* 73e -  */  0,
/* 73f -  */  0,
/* 740 -  */  0,
/* 741 -  */  0,
/* 742 -  */  0,
/* 743 -  */  0,
/* 744 -  */  0,
/* 745 -  */  0,
/* 746 -  */  0,
/* 747 -  */  0,
/* 748 -  */  0,
/* 749 -  */  0,
/* 74a -  */  0,
/* 74b -  */  0,
/* 74c -  */  0,
/* 74d -  */  0,
/* 74e -  */  0,
/* 74f -  */  0,
/* 750 -  */  0,
/* 751 -  */  0,
/* 752 -  */  0,
/* 753 -  */  0,
/* 754 -  */  0,
/* 755 -  */  0,
/* 756 -  */  0,
/* 757 -  */  0,
/* 758 -  */  0,
/* 759 -  */  0,
/* 75a -  */  0,
/* 75b -  */  0,
/* 75c -  */  0,
/* 75d -  */  0,
/* 75e -  */  0,
/* 75f -  */  0,
/* 760 -  */  0,
/* 761 -  */  0,
/* 762 -  */  0,
/* 763 -  */  0,
/* 764 -  */  0,
/* 765 -  */  0,
/* 766 -  */  0,
/* 767 -  */  0,
/* 768 - _0F_38_80 */  0xd1a4,
/* 769 - _0F_38_81 */  0xd1b0,
/* 76a - _0F_38_82 */  0xd1bc,
/* 76b -  */  0,
/* 76c -  */  0,
/* 76d -  */  0,
/* 76e -  */  0,
/* 76f -  */  0,
/* 770 -  */  0,
/* 771 -  */  0,
/* 772 -  */  0,
/* 773 -  */  0,
/* 774 -  */  0,
/* 775 -  */  0,
/* 776 -  */  0,
/* 777 -  */  0,
/* 778 -  */  0,
/* 779 -  */  0,
/* 77a -  */  0,
/* 77b -  */  0,
/* 77c -  */  0,
/* 77d -  */  0,
/* 77e - _0F_38_96 */  0xd1c8,
/* 77f - _0F_38_97 */  0xd1d4,
/* 780 - _0F_38_98 */  0xd1e0,
/* 781 - _0F_38_99 */  0xd1ec,
/* 782 - _0F_38_9A */  0xd1f8,
/* 783 - _0F_38_9B */  0xd204,
/* 784 - _0F_38_9C */  0xd210,
/* 785 - _0F_38_9D */  0xd21c,
/* 786 - _0F_38_9E */  0xd228,
/* 787 - _0F_38_9F */  0xd234,
/* 788 -  */  0,
/* 789 -  */  0,
/* 78a -  */  0,
/* 78b -  */  0,
/* 78c -  */  0,
/* 78d -  */  0,
/* 78e - _0F_38_A6 */  0xd240,
/* 78f - _0F_38_A7 */  0xd24c,
/* 790 - _0F_38_A8 */  0xd258,
/* 791 - _0F_38_A9 */  0xd264,
/* 792 - _0F_38_AA */  0xd270,
/* 793 - _0F_38_AB */  0xd27c,
/* 794 - _0F_38_AC */  0xd288,
/* 795 - _0F_38_AD */  0xd294,
/* 796 - _0F_38_AE */  0xd2a0,
/* 797 - _0F_38_AF */  0xd2ac,
/* 798 -  */  0,
/* 799 -  */  0,
/* 79a -  */  0,
/* 79b -  */  0,
/* 79c -  */  0,
/* 79d -  */  0,
/* 79e - _0F_38_B6 */  0xd2b8,
/* 79f - _0F_38_B7 */  0xd2c4,
/* 7a0 - _0F_38_B8 */  0xd2d0,
/* 7a1 - _0F_38_B9 */  0xd2dc,
/* 7a2 - _0F_38_BA */  0xd2e8,
/* 7a3 - _0F_38_BB */  0xd2f4,
/* 7a4 - _0F_38_BC */  0xd300,
/* 7a5 - _0F_38_BD */  0xd30c,
/* 7a6 - _0F_38_BE */  0xd318,
/* 7a7 - _0F_38_BF */  0xd324,
/* 7a8 -  */  0,
/* 7a9 -  */  0,
/* 7aa -  */  0,
/* 7ab -  */  0,
/* 7ac -  */  0,
/* 7ad -  */  0,
/* 7ae -  */  0,
/* 7af -  */  0,
/* 7b0 -  */  0,
/* 7b1 -  */  0,
/* 7b2 -  */  0,
/* 7b3 -  */  0,
/* 7b4 -  */  0,
/* 7b5 -  */  0,
/* 7b6 -  */  0,
/* 7b7 -  */  0,
/* 7b8 -  */  0,
/* 7b9 -  */  0,
/* 7ba -  */  0,
/* 7bb -  */  0,
/* 7bc -  */  0,
/* 7bd -  */  0,
/* 7be -  */  0,
/* 7bf -  */  0,
/* 7c0 -  */  0,
/* 7c1 -  */  0,
/* 7c2 -  */  0,
/* 7c3 - _0F_38_DB */  0xd330,
/* 7c4 - _0F_38_DC */  0xd33c,
/* 7c5 - _0F_38_DD */  0xd348,
/* 7c6 - _0F_38_DE */  0xd354,
/* 7c7 - _0F_38_DF */  0xd360,
/* 7c8 -  */  0,
/* 7c9 -  */  0,
/* 7ca -  */  0,
/* 7cb -  */  0,
/* 7cc -  */  0,
/* 7cd -  */  0,
/* 7ce -  */  0,
/* 7cf -  */  0,
/* 7d0 -  */  0,
/* 7d1 -  */  0,
/* 7d2 -  */  0,
/* 7d3 -  */  0,
/* 7d4 -  */  0,
/* 7d5 -  */  0,
/* 7d6 -  */  0,
/* 7d7 -  */  0,
/* 7d8 - _0F_38_F0 */  0xd36c,
/* 7d9 - _0F_38_F1 */  0xd378,
/* 7da -  */  0,
/* 7db -  */  0,
/* 7dc -  */  0,
/* 7dd -  */  0,
/* 7de -  */  0,
/* 7df -  */  0,
/* 7e0 -  */  0,
/* 7e1 -  */  0,
/* 7e2 -  */  0,
/* 7e3 -  */  0,
/* 7e4 -  */  0,
/* 7e5 -  */  0,
/* 7e6 -  */  0,
/* 7e7 -  */  0,
/* 7e8 -  */  0,
/* 7e9 -  */  0,
/* 7ea -  */  0,
/* 7eb -  */  0,
/* 7ec - _0F_3A_04 */  0xd384,
/* 7ed - _0F_3A_05 */  0xd390,
/* 7ee - _0F_3A_06 */  0xd39c,
/* 7ef -  */  0,
/* 7f0 - _0F_3A_08 */  0xd3a8,
/* 7f1 - _0F_3A_09 */  0xd3b4,
/* 7f2 - _0F_3A_0A */  0xd3c0,
/* 7f3 - _0F_3A_0B */  0xd3cc,
/* 7f4 - _0F_3A_0C */  0xd3d8,
/* 7f5 - _0F_3A_0D */  0xd3e4,
/* 7f6 - _0F_3A_0E */  0xd3f0,
/* 7f7 - _0F_3A_0F */  0xd3fc,
/* 7f8 -  */  0,
/* 7f9 -  */  0,
/* 7fa -  */  0,
/* 7fb -  */  0,
/* 7fc - _0F_3A_14 */  0xd408,
/* 7fd - _0F_3A_15 */  0xd414,
/* 7fe - _0F_3A_16 */  0xd420,
/* 7ff - _0F_3A_17 */  0xd42c,
/* 800 - _0F_3A_18 */  0xd438,
/* 801 - _0F_3A_19 */  0xd444,
/* 802 -  */  0,
/* 803 -  */  0,
/* 804 -  */  0,
/* 805 -  */  0,
/* 806 -  */  0,
/* 807 -  */  0,
/* 808 - _0F_3A_20 */  0xd450,
/* 809 - _0F_3A_21 */  0xd45c,
/* 80a - _0F_3A_22 */  0xd468,
/* 80b -  */  0,
/* 80c -  */  0,
/* 80d -  */  0,
/* 80e -  */  0,
/* 80f -  */  0,
/* 810 -  */  0,
/* 811 -  */  0,
/* 812 -  */  0,
/* 813 -  */  0,
/* 814 -  */  0,
/* 815 -  */  0,
/* 816 -  */  0,
/* 817 -  */  0,
/* 818 -  */  0,
/* 819 -  */  0,
/* 81a -  */  0,
/* 81b -  */  0,
/* 81c -  */  0,
/* 81d -  */  0,
/* 81e -  */  0,
/* 81f -  */  0,
/* 820 -  */  0,
/* 821 -  */  0,
/* 822 -  */  0,
/* 823 -  */  0,
/* 824 -  */  0,
/* 825 -  */  0,
/* 826 -  */  0,
/* 827 -  */  0,
/* 828 - _0F_3A_40 */  0xd474,
/* 829 - _0F_3A_41 */  0xd480,
/* 82a - _0F_3A_42 */  0xd48c,
/* 82b -  */  0,
/* 82c - _0F_3A_44 */  0xd498,
/* 82d -  */  0,
/* 82e -  */  0,
/* 82f -  */  0,
/* 830 -  */  0,
/* 831 -  */  0,
/* 832 - _0F_3A_4A */  0xd4a4,
/* 833 - _0F_3A_4B */  0xd4b0,
/* 834 - _0F_3A_4C */  0xd4bc,
/* 835 -  */  0,
/* 836 -  */  0,
/* 837 -  */  0,
/* 838 -  */  0,
/* 839 -  */  0,
/* 83a -  */  0,
/* 83b -  */  0,
/* 83c -  */  0,
/* 83d -  */  0,
/* 83e -  */  0,
/* 83f -  */  0,
/* 840 -  */  0,
/* 841 -  */  0,
/* 842 -  */  0,
/* 843 -  */  0,
/* 844 -  */  0,
/* 845 -  */  0,
/* 846 -  */  0,
/* 847 -  */  0,
/* 848 - _0F_3A_60 */  0xd4c8,
/* 849 - _0F_3A_61 */  0xd4d4,
/* 84a - _0F_3A_62 */  0xd4e0,
/* 84b - _0F_3A_63 */  0xd4ec,
/* 84c -  */  0,
/* 84d -  */  0,
/* 84e -  */  0,
/* 84f -  */  0,
/* 850 -  */  0,
/* 851 -  */  0,
/* 852 -  */  0,
/* 853 -  */  0,
/* 854 -  */  0,
/* 855 -  */  0,
/* 856 -  */  0,
/* 857 -  */  0,
/* 858 -  */  0,
/* 859 -  */  0,
/* 85a -  */  0,
/* 85b -  */  0,
/* 85c -  */  0,
/* 85d -  */  0,
/* 85e -  */  0,
/* 85f -  */  0,
/* 860 -  */  0,
/* 861 -  */  0,
/* 862 -  */  0,
/* 863 -  */  0,
/* 864 -  */  0,
/* 865 -  */  0,
/* 866 -  */  0,
/* 867 -  */  0,
/* 868 -  */  0,
/* 869 -  */  0,
/* 86a -  */  0,
/* 86b -  */  0,
/* 86c -  */  0,
/* 86d -  */  0,
/* 86e -  */  0,
/* 86f -  */  0,
/* 870 -  */  0,
/* 871 -  */  0,
/* 872 -  */  0,
/* 873 -  */  0,
/* 874 -  */  0,
/* 875 -  */  0,
/* 876 -  */  0,
/* 877 -  */  0,
/* 878 -  */  0,
/* 879 -  */  0,
/* 87a -  */  0,
/* 87b -  */  0,
/* 87c -  */  0,
/* 87d -  */  0,
/* 87e -  */  0,
/* 87f -  */  0,
/* 880 -  */  0,
/* 881 -  */  0,
/* 882 -  */  0,
/* 883 -  */  0,
/* 884 -  */  0,
/* 885 -  */  0,
/* 886 -  */  0,
/* 887 -  */  0,
/* 888 -  */  0,
/* 889 -  */  0,
/* 88a -  */  0,
/* 88b -  */  0,
/* 88c -  */  0,
/* 88d -  */  0,
/* 88e -  */  0,
/* 88f -  */  0,
/* 890 -  */  0,
/* 891 -  */  0,
/* 892 -  */  0,
/* 893 -  */  0,
/* 894 -  */  0,
/* 895 -  */  0,
/* 896 -  */  0,
/* 897 -  */  0,
/* 898 -  */  0,
/* 899 -  */  0,
/* 89a -  */  0,
/* 89b -  */  0,
/* 89c -  */  0,
/* 89d -  */  0,
/* 89e -  */  0,
/* 89f -  */  0,
/* 8a0 -  */  0,
/* 8a1 -  */  0,
/* 8a2 -  */  0,
/* 8a3 -  */  0,
/* 8a4 -  */  0,
/* 8a5 -  */  0,
/* 8a6 -  */  0,
/* 8a7 -  */  0,
/* 8a8 -  */  0,
/* 8a9 -  */  0,
/* 8aa -  */  0,
/* 8ab -  */  0,
/* 8ac -  */  0,
/* 8ad -  */  0,
/* 8ae -  */  0,
/* 8af -  */  0,
/* 8b0 -  */  0,
/* 8b1 -  */  0,
/* 8b2 -  */  0,
/* 8b3 -  */  0,
/* 8b4 -  */  0,
/* 8b5 -  */  0,
/* 8b6 -  */  0,
/* 8b7 -  */  0,
/* 8b8 -  */  0,
/* 8b9 -  */  0,
/* 8ba -  */  0,
/* 8bb -  */  0,
/* 8bc -  */  0,
/* 8bd -  */  0,
/* 8be -  */  0,
/* 8bf -  */  0,
/* 8c0 -  */  0,
/* 8c1 -  */  0,
/* 8c2 -  */  0,
/* 8c3 -  */  0,
/* 8c4 -  */  0,
/* 8c5 -  */  0,
/* 8c6 -  */  0,
/* 8c7 - _0F_3A_DF */  0xd4f8,
/* 8c8 -  */  0,
/* 8c9 -  */  0,
/* 8ca -  */  0,
/* 8cb -  */  0,
/* 8cc -  */  0,
/* 8cd -  */  0,
/* 8ce -  */  0,
/* 8cf -  */  0,
/* 8d0 -  */  0,
/* 8d1 -  */  0,
/* 8d2 -  */  0,
/* 8d3 -  */  0,
/* 8d4 -  */  0,
/* 8d5 -  */  0,
/* 8d6 -  */  0,
/* 8d7 -  */  0,
/* 8d8 -  */  0,
/* 8d9 -  */  0,
/* 8da -  */  0,
/* 8db -  */  0,
/* 8dc -  */  0,
/* 8dd -  */  0,
/* 8de -  */  0,
/* 8df -  */  0,
/* 8e0 -  */  0,
/* 8e1 -  */  0,
/* 8e2 -  */  0,
/* 8e3 -  */  0,
/* 8e4 -  */  0,
/* 8e5 -  */  0,
/* 8e6 -  */  0,
/* 8e7 -  */  0,
/* 8e8 - _0F_50 */  0x23a0,
/* 8e9 - _66_0F_50 */  0x23a1,
/* 8ea -  */  0,
/* 8eb -  */  0,
/* 8ec - _V_0F_50 */  0x4036,
/* 8ed - _V_66_0F_50 */  0x4037,
/* 8ee -  */  0,
/* 8ef -  */  0,
/* 8f0 -  */  0,
/* 8f1 -  */  0,
/* 8f2 -  */  0,
/* 8f3 -  */  0,
/* 8f4 - _0F_51 */  0x23a2,
/* 8f5 - _66_0F_51 */  0x23a3,
/* 8f6 - _F3_0F_51 */  0x23a4,
/* 8f7 - _F2_0F_51 */  0x23a5,
/* 8f8 - _V_0F_51 */  0x4038,
/* 8f9 - _V_66_0F_51 */  0x4039,
/* 8fa - _V_F3_0F_51 */  0x403a,
/* 8fb - _V_F2_0F_51 */  0x403b,
/* 8fc -  */  0,
/* 8fd -  */  0,
/* 8fe -  */  0,
/* 8ff -  */  0,
/* 900 - _0F_52 */  0x23a6,
/* 901 -  */  0,
/* 902 - _F3_0F_52 */  0x23a7,
/* 903 -  */  0,
/* 904 - _V_0F_52 */  0x403c,
/* 905 -  */  0,
/* 906 - _V_F3_0F_52 */  0x403d,
/* 907 -  */  0,
/* 908 -  */  0,
/* 909 -  */  0,
/* 90a -  */  0,
/* 90b -  */  0,
/* 90c - _0F_53 */  0x23a8,
/* 90d -  */  0,
/* 90e - _F3_0F_53 */  0x23a9,
/* 90f -  */  0,
/* 910 - _V_0F_53 */  0x403e,
/* 911 -  */  0,
/* 912 - _V_F3_0F_53 */  0x403f,
/* 913 -  */  0,
/* 914 -  */  0,
/* 915 -  */  0,
/* 916 -  */  0,
/* 917 -  */  0,
/* 918 - _0F_54 */  0x23aa,
/* 919 - _66_0F_54 */  0x23ab,
/* 91a -  */  0,
/* 91b -  */  0,
/* 91c - _V_0F_54 */  0x4040,
/* 91d - _V_66_0F_54 */  0x4041,
/* 91e -  */  0,
/* 91f -  */  0,
/* 920 -  */  0,
/* 921 -  */  0,
/* 922 -  */  0,
/* 923 -  */  0,
/* 924 - _0F_55 */  0x23ac,
/* 925 - _66_0F_55 */  0x23ad,
/* 926 -  */  0,
/* 927 -  */  0,
/* 928 - _V_0F_55 */  0x4042,
/* 929 - _V_66_0F_55 */  0x4043,
/* 92a -  */  0,
/* 92b -  */  0,
/* 92c -  */  0,
/* 92d -  */  0,
/* 92e -  */  0,
/* 92f -  */  0,
/* 930 - _0F_56 */  0x23ae,
/* 931 - _66_0F_56 */  0x23af,
/* 932 -  */  0,
/* 933 -  */  0,
/* 934 - _V_0F_56 */  0x4044,
/* 935 - _V_66_0F_56 */  0x4045,
/* 936 -  */  0,
/* 937 -  */  0,
/* 938 -  */  0,
/* 939 -  */  0,
/* 93a -  */  0,
/* 93b -  */  0,
/* 93c - _0F_57 */  0x23b0,
/* 93d - _66_0F_57 */  0x23b1,
/* 93e -  */  0,
/* 93f -  */  0,
/* 940 - _V_0F_57 */  0x4046,
/* 941 - _V_66_0F_57 */  0x4047,
/* 942 -  */  0,
/* 943 -  */  0,
/* 944 -  */  0,
/* 945 -  */  0,
/* 946 -  */  0,
/* 947 -  */  0,
/* 948 - _0F_58 */  0x23b2,
/* 949 - _66_0F_58 */  0x23b3,
/* 94a - _F3_0F_58 */  0x23b4,
/* 94b - _F2_0F_58 */  0x23b5,
/* 94c - _V_0F_58 */  0x4048,
/* 94d - _V_66_0F_58 */  0x4049,
/* 94e - _V_F3_0F_58 */  0x404a,
/* 94f - _V_F2_0F_58 */  0x404b,
/* 950 -  */  0,
/* 951 -  */  0,
/* 952 -  */  0,
/* 953 -  */  0,
/* 954 - _0F_59 */  0x23b6,
/* 955 - _66_0F_59 */  0x23b7,
/* 956 - _F3_0F_59 */  0x23b8,
/* 957 - _F2_0F_59 */  0x23b9,
/* 958 - _V_0F_59 */  0x404c,
/* 959 - _V_66_0F_59 */  0x404d,
/* 95a - _V_F3_0F_59 */  0x404e,
/* 95b - _V_F2_0F_59 */  0x404f,
/* 95c -  */  0,
/* 95d -  */  0,
/* 95e -  */  0,
/* 95f -  */  0,
/* 960 - _0F_5A */  0x23ba,
/* 961 - _66_0F_5A */  0x23bb,
/* 962 - _F3_0F_5A */  0x23bc,
/* 963 - _F2_0F_5A */  0x23bd,
/* 964 - _V_0F_5A */  0x4050,
/* 965 - _V_66_0F_5A */  0x4051,
/* 966 - _V_F3_0F_5A */  0x4052,
/* 967 - _V_F2_0F_5A */  0x4053,
/* 968 -  */  0,
/* 969 -  */  0,
/* 96a -  */  0,
/* 96b -  */  0,
/* 96c - _0F_5B */  0x23be,
/* 96d - _66_0F_5B */  0x23bf,
/* 96e - _F3_0F_5B */  0x23c0,
/* 96f -  */  0,
/* 970 - _V_0F_5B */  0x4054,
/* 971 - _V_66_0F_5B */  0x4055,
/* 972 - _V_F3_0F_5B */  0x4056,
/* 973 -  */  0,
/* 974 -  */  0,
/* 975 -  */  0,
/* 976 -  */  0,
/* 977 -  */  0,
/* 978 - _0F_5C */  0x23c1,
/* 979 - _66_0F_5C */  0x23c2,
/* 97a - _F3_0F_5C */  0x23c3,
/* 97b - _F2_0F_5C */  0x23c4,
/* 97c - _V_0F_5C */  0x4057,
/* 97d - _V_66_0F_5C */  0x4058,
/* 97e - _V_F3_0F_5C */  0x4059,
/* 97f - _V_F2_0F_5C */  0x405a,
/* 980 -  */  0,
/* 981 -  */  0,
/* 982 -  */  0,
/* 983 -  */  0,
/* 984 - _0F_5D */  0x23c5,
/* 985 - _66_0F_5D */  0x23c6,
/* 986 - _F3_0F_5D */  0x23c7,
/* 987 - _F2_0F_5D */  0x23c8,
/* 988 - _V_0F_5D */  0x405b,
/* 989 - _V_66_0F_5D */  0x405c,
/* 98a - _V_F3_0F_5D */  0x405d,
/* 98b - _V_F2_0F_5D */  0x405e,
/* 98c -  */  0,
/* 98d -  */  0,
/* 98e -  */  0,
/* 98f -  */  0,
/* 990 - _0F_5E */  0x23c9,
/* 991 - _66_0F_5E */  0x23ca,
/* 992 - _F3_0F_5E */  0x23cb,
/* 993 - _F2_0F_5E */  0x23cc,
/* 994 - _V_0F_5E */  0x405f,
/* 995 - _V_66_0F_5E */  0x4060,
/* 996 - _V_F3_0F_5E */  0x4061,
/* 997 - _V_F2_0F_5E */  0x4062,
/* 998 -  */  0,
/* 999 -  */  0,
/* 99a -  */  0,
/* 99b -  */  0,
/* 99c - _0F_5F */  0x23cd,
/* 99d - _66_0F_5F */  0x23ce,
/* 99e - _F3_0F_5F */  0x23cf,
/* 99f - _F2_0F_5F */  0x23d0,
/* 9a0 - _V_0F_5F */  0x4063,
/* 9a1 - _V_66_0F_5F */  0x4064,
/* 9a2 - _V_F3_0F_5F */  0x4065,
/* 9a3 - _V_F2_0F_5F */  0x4066,
/* 9a4 -  */  0,
/* 9a5 -  */  0,
/* 9a6 -  */  0,
/* 9a7 -  */  0,
/* 9a8 - _0F_60 */  0x23d1,
/* 9a9 - _66_0F_60 */  0x23d2,
/* 9aa -  */  0,
/* 9ab -  */  0,
/* 9ac -  */  0,
/* 9ad - _V_66_0F_60 */  0x4067,
/* 9ae -  */  0,
/* 9af -  */  0,
/* 9b0 -  */  0,
/* 9b1 -  */  0,
/* 9b2 -  */  0,
/* 9b3 -  */  0,
/* 9b4 - _0F_61 */  0x23d3,
/* 9b5 - _66_0F_61 */  0x23d4,
/* 9b6 -  */  0,
/* 9b7 -  */  0,
/* 9b8 -  */  0,
/* 9b9 - _V_66_0F_61 */  0x4068,
/* 9ba -  */  0,
/* 9bb -  */  0,
/* 9bc -  */  0,
/* 9bd -  */  0,
/* 9be -  */  0,
/* 9bf -  */  0,
/* 9c0 - _0F_62 */  0x23d5,
/* 9c1 - _66_0F_62 */  0x23d6,
/* 9c2 -  */  0,
/* 9c3 -  */  0,
/* 9c4 -  */  0,
/* 9c5 - _V_66_0F_62 */  0x4069,
/* 9c6 -  */  0,
/* 9c7 -  */  0,
/* 9c8 -  */  0,
/* 9c9 -  */  0,
/* 9ca -  */  0,
/* 9cb -  */  0,
/* 9cc - _0F_63 */  0x23d7,
/* 9cd - _66_0F_63 */  0x23d8,
/* 9ce -  */  0,
/* 9cf -  */  0,
/* 9d0 -  */  0,
/* 9d1 - _V_66_0F_63 */  0x406a,
/* 9d2 -  */  0,
/* 9d3 -  */  0,
/* 9d4 -  */  0,
/* 9d5 -  */  0,
/* 9d6 -  */  0,
/* 9d7 -  */  0,
/* 9d8 - _0F_64 */  0x23d9,
/* 9d9 - _66_0F_64 */  0x23da,
/* 9da -  */  0,
/* 9db -  */  0,
/* 9dc -  */  0,
/* 9dd - _V_66_0F_64 */  0x406b,
/* 9de -  */  0,
/* 9df -  */  0,
/* 9e0 -  */  0,
/* 9e1 -  */  0,
/* 9e2 -  */  0,
/* 9e3 -  */  0,
/* 9e4 - _0F_65 */  0x23db,
/* 9e5 - _66_0F_65 */  0x23dc,
/* 9e6 -  */  0,
/* 9e7 -  */  0,
/* 9e8 -  */  0,
/* 9e9 - _V_66_0F_65 */  0x406c,
/* 9ea -  */  0,
/* 9eb -  */  0,
/* 9ec -  */  0,
/* 9ed -  */  0,
/* 9ee -  */  0,
/* 9ef -  */  0,
/* 9f0 - _0F_66 */  0x23dd,
/* 9f1 - _66_0F_66 */  0x23de,
/* 9f2 -  */  0,
/* 9f3 -  */  0,
/* 9f4 -  */  0,
/* 9f5 - _V_66_0F_66 */  0x406d,
/* 9f6 -  */  0,
/* 9f7 -  */  0,
/* 9f8 -  */  0,
/* 9f9 -  */  0,
/* 9fa -  */  0,
/* 9fb -  */  0,
/* 9fc - _0F_67 */  0x23df,
/* 9fd - _66_0F_67 */  0x23e0,
/* 9fe -  */  0,
/* 9ff -  */  0,
/* a00 -  */  0,
/* a01 - _V_66_0F_67 */  0x406e,
/* a02 -  */  0,
/* a03 -  */  0,
/* a04 -  */  0,
/* a05 -  */  0,
/* a06 -  */  0,
/* a07 -  */  0,
/* a08 - _0F_68 */  0x23e1,
/* a09 - _66_0F_68 */  0x23e2,
/* a0a -  */  0,
/* a0b -  */  0,
/* a0c -  */  0,
/* a0d - _V_66_0F_68 */  0x406f,
/* a0e -  */  0,
/* a0f -  */  0,
/* a10 -  */  0,
/* a11 -  */  0,
/* a12 -  */  0,
/* a13 -  */  0,
/* a14 - _0F_69 */  0x23e3,
/* a15 - _66_0F_69 */  0x23e4,
/* a16 -  */  0,
/* a17 -  */  0,
/* a18 -  */  0,
/* a19 - _V_66_0F_69 */  0x4070,
/* a1a -  */  0,
/* a1b -  */  0,
/* a1c -  */  0,
/* a1d -  */  0,
/* a1e -  */  0,
/* a1f -  */  0,
/* a20 - _0F_6A */  0x23e5,
/* a21 - _66_0F_6A */  0x23e6,
/* a22 -  */  0,
/* a23 -  */  0,
/* a24 -  */  0,
/* a25 - _V_66_0F_6A */  0x4071,
/* a26 -  */  0,
/* a27 -  */  0,
/* a28 -  */  0,
/* a29 -  */  0,
/* a2a -  */  0,
/* a2b -  */  0,
/* a2c - _0F_6B */  0x23e7,
/* a2d - _66_0F_6B */  0x23e8,
/* a2e -  */  0,
/* a2f -  */  0,
/* a30 -  */  0,
/* a31 - _V_66_0F_6B */  0x4072,
/* a32 -  */  0,
/* a33 -  */  0,
/* a34 -  */  0,
/* a35 -  */  0,
/* a36 -  */  0,
/* a37 -  */  0,
/* a38 -  */  0,
/* a39 - _66_0F_6C */  0x23e9,
/* a3a -  */  0,
/* a3b -  */  0,
/* a3c -  */  0,
/* a3d - _V_66_0F_6C */  0x4073,
/* a3e -  */  0,
/* a3f -  */  0,
/* a40 -  */  0,
/* a41 -  */  0,
/* a42 -  */  0,
/* a43 -  */  0,
/* a44 -  */  0,
/* a45 - _66_0F_6D */  0x23ea,
/* a46 -  */  0,
/* a47 -  */  0,
/* a48 -  */  0,
/* a49 - _V_66_0F_6D */  0x4074,
/* a4a -  */  0,
/* a4b -  */  0,
/* a4c -  */  0,
/* a4d -  */  0,
/* a4e -  */  0,
/* a4f -  */  0,
/* a50 - _0F_6E */  0x4075,
/* a51 - _66_0F_6E */  0x4076,
/* a52 -  */  0,
/* a53 -  */  0,
/* a54 -  */  0,
/* a55 - _V_66_0F_6E */  0x4077,
/* a56 -  */  0,
/* a57 -  */  0,
/* a58 -  */  0,
/* a59 -  */  0,
/* a5a -  */  0,
/* a5b -  */  0,
/* a5c - _0F_6F */  0x23eb,
/* a5d - _66_0F_6F */  0x23ec,
/* a5e - _F3_0F_6F */  0x23ed,
/* a5f -  */  0,
/* a60 -  */  0,
/* a61 - _V_66_0F_6F */  0x4078,
/* a62 - _V_F3_0F_6F */  0x4079,
/* a63 -  */  0,
/* a64 -  */  0,
/* a65 -  */  0,
/* a66 -  */  0,
/* a67 -  */  0,
/* a68 - _0F_70 */  0x407a,
/* a69 - _66_0F_70 */  0x407b,
/* a6a - _F3_0F_70 */  0x407c,
/* a6b - _F2_0F_70 */  0x407d,
/* a6c -  */  0,
/* a6d - _V_66_0F_70 */  0x407e,
/* a6e - _V_F3_0F_70 */  0x407f,
/* a6f - _V_F2_0F_70 */  0x4080,
/* a70 -  */  0,
/* a71 -  */  0,
/* a72 -  */  0,
/* a73 -  */  0,
/* a74 -  */  0,
/* a75 -  */  0,
/* a76 - _0F_71_02 */  0xd504,
/* a77 -  */  0,
/* a78 - _0F_71_04 */  0xd510,
/* a79 -  */  0,
/* a7a - _0F_71_06 */  0xd51c,
/* a7b -  */  0,
/* a7c -  */  0,
/* a7d -  */  0,
/* a7e - _0F_72_02 */  0xd528,
/* a7f -  */  0,
/* a80 - _0F_72_04 */  0xd534,
/* a81 -  */  0,
/* a82 - _0F_72_06 */  0xd540,
/* a83 -  */  0,
/* a84 -  */  0,
/* a85 -  */  0,
/* a86 - _0F_73_02 */  0xd54c,
/* a87 - _0F_73_03 */  0xd558,
/* a88 -  */  0,
/* a89 -  */  0,
/* a8a - _0F_73_06 */  0xd564,
/* a8b - _0F_73_07 */  0xd570,
/* a8c - _0F_74 */  0x23ee,
/* a8d - _66_0F_74 */  0x23ef,
/* a8e -  */  0,
/* a8f -  */  0,
/* a90 -  */  0,
/* a91 - _V_66_0F_74 */  0x4081,
/* a92 -  */  0,
/* a93 -  */  0,
/* a94 -  */  0,
/* a95 -  */  0,
/* a96 -  */  0,
/* a97 -  */  0,
/* a98 - _0F_75 */  0x23f0,
/* a99 - _66_0F_75 */  0x23f1,
/* a9a -  */  0,
/* a9b -  */  0,
/* a9c -  */  0,
/* a9d - _V_66_0F_75 */  0x4082,
/* a9e -  */  0,
/* a9f -  */  0,
/* aa0 -  */  0,
/* aa1 -  */  0,
/* aa2 -  */  0,
/* aa3 -  */  0,
/* aa4 - _0F_76 */  0x23f2,
/* aa5 - _66_0F_76 */  0x23f3,
/* aa6 -  */  0,
/* aa7 -  */  0,
/* aa8 -  */  0,
/* aa9 - _V_66_0F_76 */  0x4083,
/* aaa -  */  0,
/* aab -  */  0,
/* aac -  */  0,
/* aad -  */  0,
/* aae -  */  0,
/* aaf -  */  0,
/* ab0 - _0F_77 */  0x23f4,
/* ab1 -  */  0,
/* ab2 -  */  0,
/* ab3 -  */  0,
/* ab4 - _V_0F_77 */  0x4084,
/* ab5 -  */  0,
/* ab6 -  */  0,
/* ab7 -  */  0,
/* ab8 -  */  0,
/* ab9 -  */  0,
/* aba -  */  0,
/* abb -  */  0,
/* abc - _0F_78 */  0x23f5,
/* abd - _66_0F_78 */  0x4085,
/* abe -  */  0,
/* abf - _F2_0F_78 */  0x4086,
/* ac0 -  */  0,
/* ac1 -  */  0,
/* ac2 -  */  0,
/* ac3 -  */  0,
/* ac4 -  */  0,
/* ac5 -  */  0,
/* ac6 -  */  0,
/* ac7 -  */  0,
/* ac8 - _0F_79 */  0x23f6,
/* ac9 - _66_0F_79 */  0x23f7,
/* aca -  */  0,
/* acb - _F2_0F_79 */  0x23f8,
/* acc -  */  0,
/* acd -  */  0,
/* ace -  */  0,
/* acf -  */  0,
/* ad0 -  */  0,
/* ad1 -  */  0,
/* ad2 -  */  0,
/* ad3 -  */  0,
/* ad4 -  */  0,
/* ad5 -  */  0,
/* ad6 -  */  0,
/* ad7 -  */  0,
/* ad8 -  */  0,
/* ad9 -  */  0,
/* ada -  */  0,
/* adb -  */  0,
/* adc -  */  0,
/* add -  */  0,
/* ade -  */  0,
/* adf -  */  0,
/* ae0 -  */  0,
/* ae1 -  */  0,
/* ae2 -  */  0,
/* ae3 -  */  0,
/* ae4 -  */  0,
/* ae5 -  */  0,
/* ae6 -  */  0,
/* ae7 -  */  0,
/* ae8 -  */  0,
/* ae9 -  */  0,
/* aea -  */  0,
/* aeb -  */  0,
/* aec -  */  0,
/* aed -  */  0,
/* aee -  */  0,
/* aef -  */  0,
/* af0 -  */  0,
/* af1 -  */  0,
/* af2 -  */  0,
/* af3 -  */  0,
/* af4 -  */  0,
/* af5 -  */  0,
/* af6 -  */  0,
/* af7 -  */  0,
/* af8 -  */  0,
/* af9 -  */  0,
/* afa -  */  0,
/* afb -  */  0,
/* afc -  */  0,
/* afd -  */  0,
/* afe -  */  0,
/* aff -  */  0,
/* b00 -  */  0,
/* b01 -  */  0,
/* b02 -  */  0,
/* b03 -  */  0,
/* b04 - _0F_7A_30 */  0x23f9,
/* b05 - _0F_7A_31 */  0x23fa,
/* b06 -  */  0,
/* b07 -  */  0,
/* b08 -  */  0,
/* b09 -  */  0,
/* b0a -  */  0,
/* b0b -  */  0,
/* b0c -  */  0,
/* b0d -  */  0,
/* b0e -  */  0,
/* b0f -  */  0,
/* b10 -  */  0,
/* b11 -  */  0,
/* b12 -  */  0,
/* b13 -  */  0,
/* b14 -  */  0,
/* b15 -  */  0,
/* b16 -  */  0,
/* b17 -  */  0,
/* b18 -  */  0,
/* b19 -  */  0,
/* b1a -  */  0,
/* b1b -  */  0,
/* b1c -  */  0,
/* b1d -  */  0,
/* b1e -  */  0,
/* b1f -  */  0,
/* b20 -  */  0,
/* b21 -  */  0,
/* b22 -  */  0,
/* b23 -  */  0,
/* b24 -  */  0,
/* b25 -  */  0,
/* b26 -  */  0,
/* b27 -  */  0,
/* b28 -  */  0,
/* b29 -  */  0,
/* b2a -  */  0,
/* b2b -  */  0,
/* b2c -  */  0,
/* b2d -  */  0,
/* b2e -  */  0,
/* b2f -  */  0,
/* b30 -  */  0,
/* b31 -  */  0,
/* b32 -  */  0,
/* b33 -  */  0,
/* b34 -  */  0,
/* b35 -  */  0,
/* b36 -  */  0,
/* b37 -  */  0,
/* b38 -  */  0,
/* b39 -  */  0,
/* b3a -  */  0,
/* b3b -  */  0,
/* b3c -  */  0,
/* b3d -  */  0,
/* b3e -  */  0,
/* b3f -  */  0,
/* b40 -  */  0,
/* b41 -  */  0,
/* b42 -  */  0,
/* b43 -  */  0,
/* b44 -  */  0,
/* b45 -  */  0,
/* b46 -  */  0,
/* b47 -  */  0,
/* b48 -  */  0,
/* b49 -  */  0,
/* b4a -  */  0,
/* b4b -  */  0,
/* b4c -  */  0,
/* b4d -  */  0,
/* b4e -  */  0,
/* b4f -  */  0,
/* b50 -  */  0,
/* b51 -  */  0,
/* b52 -  */  0,
/* b53 -  */  0,
/* b54 -  */  0,
/* b55 -  */  0,
/* b56 -  */  0,
/* b57 -  */  0,
/* b58 -  */  0,
/* b59 -  */  0,
/* b5a -  */  0,
/* b5b -  */  0,
/* b5c -  */  0,
/* b5d -  */  0,
/* b5e -  */  0,
/* b5f -  */  0,
/* b60 -  */  0,
/* b61 -  */  0,
/* b62 -  */  0,
/* b63 -  */  0,
/* b64 -  */  0,
/* b65 -  */  0,
/* b66 -  */  0,
/* b67 -  */  0,
/* b68 -  */  0,
/* b69 -  */  0,
/* b6a -  */  0,
/* b6b -  */  0,
/* b6c -  */  0,
/* b6d -  */  0,
/* b6e -  */  0,
/* b6f -  */  0,
/* b70 -  */  0,
/* b71 -  */  0,
/* b72 -  */  0,
/* b73 -  */  0,
/* b74 -  */  0,
/* b75 -  */  0,
/* b76 -  */  0,
/* b77 -  */  0,
/* b78 -  */  0,
/* b79 -  */  0,
/* b7a -  */  0,
/* b7b -  */  0,
/* b7c -  */  0,
/* b7d -  */  0,
/* b7e -  */  0,
/* b7f -  */  0,
/* b80 -  */  0,
/* b81 -  */  0,
/* b82 -  */  0,
/* b83 -  */  0,
/* b84 -  */  0,
/* b85 -  */  0,
/* b86 -  */  0,
/* b87 -  */  0,
/* b88 -  */  0,
/* b89 -  */  0,
/* b8a -  */  0,
/* b8b -  */  0,
/* b8c -  */  0,
/* b8d -  */  0,
/* b8e -  */  0,
/* b8f -  */  0,
/* b90 -  */  0,
/* b91 -  */  0,
/* b92 -  */  0,
/* b93 -  */  0,
/* b94 -  */  0,
/* b95 -  */  0,
/* b96 -  */  0,
/* b97 -  */  0,
/* b98 -  */  0,
/* b99 -  */  0,
/* b9a -  */  0,
/* b9b -  */  0,
/* b9c -  */  0,
/* b9d -  */  0,
/* b9e -  */  0,
/* b9f -  */  0,
/* ba0 -  */  0,
/* ba1 -  */  0,
/* ba2 -  */  0,
/* ba3 -  */  0,
/* ba4 -  */  0,
/* ba5 -  */  0,
/* ba6 -  */  0,
/* ba7 -  */  0,
/* ba8 -  */  0,
/* ba9 -  */  0,
/* baa -  */  0,
/* bab -  */  0,
/* bac -  */  0,
/* bad -  */  0,
/* bae -  */  0,
/* baf -  */  0,
/* bb0 -  */  0,
/* bb1 -  */  0,
/* bb2 -  */  0,
/* bb3 -  */  0,
/* bb4 -  */  0,
/* bb5 -  */  0,
/* bb6 -  */  0,
/* bb7 -  */  0,
/* bb8 -  */  0,
/* bb9 -  */  0,
/* bba -  */  0,
/* bbb -  */  0,
/* bbc -  */  0,
/* bbd -  */  0,
/* bbe -  */  0,
/* bbf -  */  0,
/* bc0 -  */  0,
/* bc1 -  */  0,
/* bc2 -  */  0,
/* bc3 -  */  0,
/* bc4 -  */  0,
/* bc5 -  */  0,
/* bc6 -  */  0,
/* bc7 -  */  0,
/* bc8 -  */  0,
/* bc9 -  */  0,
/* bca -  */  0,
/* bcb -  */  0,
/* bcc -  */  0,
/* bcd -  */  0,
/* bce -  */  0,
/* bcf -  */  0,
/* bd0 -  */  0,
/* bd1 -  */  0,
/* bd2 -  */  0,
/* bd3 -  */  0,
/* bd4 -  */  0,
/* bd5 - _66_0F_7C */  0x23fb,
/* bd6 -  */  0,
/* bd7 - _F2_0F_7C */  0x23fc,
/* bd8 -  */  0,
/* bd9 - _V_66_0F_7C */  0x4087,
/* bda -  */  0,
/* bdb - _V_F2_0F_7C */  0x4088,
/* bdc -  */  0,
/* bdd -  */  0,
/* bde -  */  0,
/* bdf -  */  0,
/* be0 -  */  0,
/* be1 - _66_0F_7D */  0x23fd,
/* be2 -  */  0,
/* be3 - _F2_0F_7D */  0x23fe,
/* be4 -  */  0,
/* be5 - _V_66_0F_7D */  0x4089,
/* be6 -  */  0,
/* be7 - _V_F2_0F_7D */  0x408a,
/* be8 -  */  0,
/* be9 -  */  0,
/* bea -  */  0,
/* beb -  */  0,
/* bec - _0F_7E */  0x408b,
/* bed - _66_0F_7E */  0x408c,
/* bee - _F3_0F_7E */  0x23ff,
/* bef -  */  0,
/* bf0 -  */  0,
/* bf1 - _V_66_0F_7E */  0x408d,
/* bf2 - _V_F3_0F_7E */  0x408e,
/* bf3 -  */  0,
/* bf4 -  */  0,
/* bf5 -  */  0,
/* bf6 -  */  0,
/* bf7 -  */  0,
/* bf8 - _0F_7F */  0x2400,
/* bf9 - _66_0F_7F */  0x2401,
/* bfa - _F3_0F_7F */  0x2402,
/* bfb -  */  0,
/* bfc -  */  0,
/* bfd - _V_66_0F_7F */  0x408f,
/* bfe - _V_F3_0F_7F */  0x4090,
/* bff -  */  0,
/* c00 -  */  0,
/* c01 -  */  0,
/* c02 -  */  0,
/* c03 -  */  0,
/* c04 - _0F_AE_00 */  0xd57c,
/* c05 - _0F_AE_01 */  0xd588,
/* c06 - _0F_AE_02 */  0xd594,
/* c07 - _0F_AE_03 */  0xd5a0,
/* c08 - _0F_AE_04 */  0x4091,
/* c09 - _0F_AE_05 */  0x4092,
/* c0a - _0F_AE_06 */  0x4093,
/* c0b - _0F_AE_07 */  0x4094,
/* c0c -  */  0,
/* c0d -  */  0,
/* c0e - _F3_0F_B8 */  0x2403,
/* c0f -  */  0,
/* c10 -  */  0,
/* c11 -  */  0,
/* c12 -  */  0,
/* c13 -  */  0,
/* c14 -  */  0,
/* c15 -  */  0,
/* c16 -  */  0,
/* c17 -  */  0,
/* c18 -  */  0,
/* c19 -  */  0,
/* c1a -  */  0,
/* c1b -  */  0,
/* c1c - _0F_BA_04 */  0x2404,
/* c1d - _0F_BA_05 */  0x2405,
/* c1e - _0F_BA_06 */  0x2406,
/* c1f - _0F_BA_07 */  0x2407,
/* c20 - _0F_BC */  0x2408,
/* c21 -  */  0,
/* c22 - _F3_0F_BC */  0x2409,
/* c23 -  */  0,
/* c24 -  */  0,
/* c25 -  */  0,
/* c26 -  */  0,
/* c27 -  */  0,
/* c28 -  */  0,
/* c29 -  */  0,
/* c2a -  */  0,
/* c2b -  */  0,
/* c2c - _0F_BD */  0x240a,
/* c2d -  */  0,
/* c2e - _F3_0F_BD */  0x240b,
/* c2f -  */  0,
/* c30 -  */  0,
/* c31 -  */  0,
/* c32 -  */  0,
/* c33 -  */  0,
/* c34 -  */  0,
/* c35 -  */  0,
/* c36 -  */  0,
/* c37 -  */  0,
/* c38 - _0F_C2 */  0x4095,
/* c39 - _66_0F_C2 */  0x4096,
/* c3a - _F3_0F_C2 */  0x4097,
/* c3b - _F2_0F_C2 */  0x4098,
/* c3c - _V_0F_C2 */  0x4099,
/* c3d - _V_66_0F_C2 */  0x409a,
/* c3e - _V_F3_0F_C2 */  0x409b,
/* c3f - _V_F2_0F_C2 */  0x409c,
/* c40 -  */  0,
/* c41 -  */  0,
/* c42 -  */  0,
/* c43 -  */  0,
/* c44 - _0F_C4 */  0x409d,
/* c45 - _66_0F_C4 */  0x409e,
/* c46 -  */  0,
/* c47 -  */  0,
/* c48 -  */  0,
/* c49 - _V_66_0F_C4 */  0x409f,
/* c4a -  */  0,
/* c4b -  */  0,
/* c4c -  */  0,
/* c4d -  */  0,
/* c4e -  */  0,
/* c4f -  */  0,
/* c50 - _0F_C5 */  0x40a0,
/* c51 - _66_0F_C5 */  0x40a1,
/* c52 -  */  0,
/* c53 -  */  0,
/* c54 -  */  0,
/* c55 - _V_66_0F_C5 */  0x40a2,
/* c56 -  */  0,
/* c57 -  */  0,
/* c58 -  */  0,
/* c59 -  */  0,
/* c5a -  */  0,
/* c5b -  */  0,
/* c5c - _0F_C6 */  0x40a3,
/* c5d - _66_0F_C6 */  0x40a4,
/* c5e -  */  0,
/* c5f -  */  0,
/* c60 - _V_0F_C6 */  0x40a5,
/* c61 - _V_66_0F_C6 */  0x40a6,
/* c62 -  */  0,
/* c63 -  */  0,
/* c64 -  */  0,
/* c65 -  */  0,
/* c66 -  */  0,
/* c67 -  */  0,
/* c68 -  */  0,
/* c69 - _0F_C7_01 */  0x40a7,
/* c6a -  */  0,
/* c6b -  */  0,
/* c6c -  */  0,
/* c6d -  */  0,
/* c6e - _0F_C7_06 */  0xd5ac,
/* c6f - _0F_C7_07 */  0x240c,
/* c70 -  */  0,
/* c71 - _66_0F_D0 */  0x240d,
/* c72 -  */  0,
/* c73 - _F2_0F_D0 */  0x240e,
/* c74 -  */  0,
/* c75 - _V_66_0F_D0 */  0x40a8,
/* c76 -  */  0,
/* c77 - _V_F2_0F_D0 */  0x40a9,
/* c78 -  */  0,
/* c79 -  */  0,
/* c7a -  */  0,
/* c7b -  */  0,
/* c7c - _0F_D1 */  0x240f,
/* c7d - _66_0F_D1 */  0x2410,
/* c7e -  */  0,
/* c7f -  */  0,
/* c80 -  */  0,
/* c81 - _V_66_0F_D1 */  0x40aa,
/* c82 -  */  0,
/* c83 -  */  0,
/* c84 -  */  0,
/* c85 -  */  0,
/* c86 -  */  0,
/* c87 -  */  0,
/* c88 - _0F_D2 */  0x2411,
/* c89 - _66_0F_D2 */  0x2412,
/* c8a -  */  0,
/* c8b -  */  0,
/* c8c -  */  0,
/* c8d - _V_66_0F_D2 */  0x40ab,
/* c8e -  */  0,
/* c8f -  */  0,
/* c90 -  */  0,
/* c91 -  */  0,
/* c92 -  */  0,
/* c93 -  */  0,
/* c94 - _0F_D3 */  0x2413,
/* c95 - _66_0F_D3 */  0x2414,
/* c96 -  */  0,
/* c97 -  */  0,
/* c98 -  */  0,
/* c99 - _V_66_0F_D3 */  0x40ac,
/* c9a -  */  0,
/* c9b -  */  0,
/* c9c -  */  0,
/* c9d -  */  0,
/* c9e -  */  0,
/* c9f -  */  0,
/* ca0 - _0F_D4 */  0x2415,
/* ca1 - _66_0F_D4 */  0x2416,
/* ca2 -  */  0,
/* ca3 -  */  0,
/* ca4 -  */  0,
/* ca5 - _V_66_0F_D4 */  0x40ad,
/* ca6 -  */  0,
/* ca7 -  */  0,
/* ca8 -  */  0,
/* ca9 -  */  0,
/* caa -  */  0,
/* cab -  */  0,
/* cac - _0F_D5 */  0x2417,
/* cad - _66_0F_D5 */  0x2418,
/* cae -  */  0,
/* caf -  */  0,
/* cb0 -  */  0,
/* cb1 - _V_66_0F_D5 */  0x40ae,
/* cb2 -  */  0,
/* cb3 -  */  0,
/* cb4 -  */  0,
/* cb5 -  */  0,
/* cb6 -  */  0,
/* cb7 -  */  0,
/* cb8 -  */  0,
/* cb9 - _66_0F_D6 */  0x2419,
/* cba - _F3_0F_D6 */  0x241a,
/* cbb - _F2_0F_D6 */  0x241b,
/* cbc -  */  0,
/* cbd - _V_66_0F_D6 */  0x40af,
/* cbe -  */  0,
/* cbf -  */  0,
/* cc0 -  */  0,
/* cc1 -  */  0,
/* cc2 -  */  0,
/* cc3 -  */  0,
/* cc4 - _0F_D7 */  0x241c,
/* cc5 - _66_0F_D7 */  0x241d,
/* cc6 -  */  0,
/* cc7 -  */  0,
/* cc8 -  */  0,
/* cc9 - _V_66_0F_D7 */  0x40b0,
/* cca -  */  0,
/* ccb -  */  0,
/* ccc -  */  0,
/* ccd -  */  0,
/* cce -  */  0,
/* ccf -  */  0,
/* cd0 - _0F_D8 */  0x241e,
/* cd1 - _66_0F_D8 */  0x241f,
/* cd2 -  */  0,
/* cd3 -  */  0,
/* cd4 -  */  0,
/* cd5 - _V_66_0F_D8 */  0x40b1,
/* cd6 -  */  0,
/* cd7 -  */  0,
/* cd8 -  */  0,
/* cd9 -  */  0,
/* cda -  */  0,
/* cdb -  */  0,
/* cdc - _0F_D9 */  0x2420,
/* cdd - _66_0F_D9 */  0x2421,
/* cde -  */  0,
/* cdf -  */  0,
/* ce0 -  */  0,
/* ce1 - _V_66_0F_D9 */  0x40b2,
/* ce2 -  */  0,
/* ce3 -  */  0,
/* ce4 -  */  0,
/* ce5 -  */  0,
/* ce6 -  */  0,
/* ce7 -  */  0,
/* ce8 - _0F_DA */  0x2422,
/* ce9 - _66_0F_DA */  0x2423,
/* cea -  */  0,
/* ceb -  */  0,
/* cec -  */  0,
/* ced - _V_66_0F_DA */  0x40b3,
/* cee -  */  0,
/* cef -  */  0,
/* cf0 -  */  0,
/* cf1 -  */  0,
/* cf2 -  */  0,
/* cf3 -  */  0,
/* cf4 - _0F_DB */  0x2424,
/* cf5 - _66_0F_DB */  0x2425,
/* cf6 -  */  0,
/* cf7 -  */  0,
/* cf8 -  */  0,
/* cf9 - _V_66_0F_DB */  0x40b4,
/* cfa -  */  0,
/* cfb -  */  0,
/* cfc -  */  0,
/* cfd -  */  0,
/* cfe -  */  0,
/* cff -  */  0,
/* d00 - _0F_DC */  0x2426,
/* d01 - _66_0F_DC */  0x2427,
/* d02 -  */  0,
/* d03 -  */  0,
/* d04 -  */  0,
/* d05 - _V_66_0F_DC */  0x40b5,
/* d06 -  */  0,
/* d07 -  */  0,
/* d08 -  */  0,
/* d09 -  */  0,
/* d0a -  */  0,
/* d0b -  */  0,
/* d0c - _0F_DD */  0x2428,
/* d0d - _66_0F_DD */  0x2429,
/* d0e -  */  0,
/* d0f -  */  0,
/* d10 -  */  0,
/* d11 - _V_66_0F_DD */  0x40b6,
/* d12 -  */  0,
/* d13 -  */  0,
/* d14 -  */  0,
/* d15 -  */  0,
/* d16 -  */  0,
/* d17 -  */  0,
/* d18 - _0F_DE */  0x242a,
/* d19 - _66_0F_DE */  0x242b,
/* d1a -  */  0,
/* d1b -  */  0,
/* d1c -  */  0,
/* d1d - _V_66_0F_DE */  0x40b7,
/* d1e -  */  0,
/* d1f -  */  0,
/* d20 -  */  0,
/* d21 -  */  0,
/* d22 -  */  0,
/* d23 -  */  0,
/* d24 - _0F_DF */  0x242c,
/* d25 - _66_0F_DF */  0x242d,
/* d26 -  */  0,
/* d27 -  */  0,
/* d28 -  */  0,
/* d29 - _V_66_0F_DF */  0x40b8,
/* d2a -  */  0,
/* d2b -  */  0,
/* d2c -  */  0,
/* d2d -  */  0,
/* d2e -  */  0,
/* d2f -  */  0,
/* d30 - _0F_E0 */  0x242e,
/* d31 - _66_0F_E0 */  0x242f,
/* d32 -  */  0,
/* d33 -  */  0,
/* d34 -  */  0,
/* d35 - _V_66_0F_E0 */  0x40b9,
/* d36 -  */  0,
/* d37 -  */  0,
/* d38 -  */  0,
/* d39 -  */  0,
/* d3a -  */  0,
/* d3b -  */  0,
/* d3c - _0F_E1 */  0x2430,
/* d3d - _66_0F_E1 */  0x2431,
/* d3e -  */  0,
/* d3f -  */  0,
/* d40 -  */  0,
/* d41 - _V_66_0F_E1 */  0x40ba,
/* d42 -  */  0,
/* d43 -  */  0,
/* d44 -  */  0,
/* d45 -  */  0,
/* d46 -  */  0,
/* d47 -  */  0,
/* d48 - _0F_E2 */  0x2432,
/* d49 - _66_0F_E2 */  0x2433,
/* d4a -  */  0,
/* d4b -  */  0,
/* d4c -  */  0,
/* d4d - _V_66_0F_E2 */  0x40bb,
/* d4e -  */  0,
/* d4f -  */  0,
/* d50 -  */  0,
/* d51 -  */  0,
/* d52 -  */  0,
/* d53 -  */  0,
/* d54 - _0F_E3 */  0x2434,
/* d55 - _66_0F_E3 */  0x2435,
/* d56 -  */  0,
/* d57 -  */  0,
/* d58 -  */  0,
/* d59 - _V_66_0F_E3 */  0x40bc,
/* d5a -  */  0,
/* d5b -  */  0,
/* d5c -  */  0,
/* d5d -  */  0,
/* d5e -  */  0,
/* d5f -  */  0,
/* d60 - _0F_E4 */  0x2436,
/* d61 - _66_0F_E4 */  0x2437,
/* d62 -  */  0,
/* d63 -  */  0,
/* d64 -  */  0,
/* d65 - _V_66_0F_E4 */  0x40bd,
/* d66 -  */  0,
/* d67 -  */  0,
/* d68 -  */  0,
/* d69 -  */  0,
/* d6a -  */  0,
/* d6b -  */  0,
/* d6c - _0F_E5 */  0x2438,
/* d6d - _66_0F_E5 */  0x2439,
/* d6e -  */  0,
/* d6f -  */  0,
/* d70 -  */  0,
/* d71 - _V_66_0F_E5 */  0x40be,
/* d72 -  */  0,
/* d73 -  */  0,
/* d74 -  */  0,
/* d75 -  */  0,
/* d76 -  */  0,
/* d77 -  */  0,
/* d78 -  */  0,
/* d79 - _66_0F_E6 */  0x243a,
/* d7a - _F3_0F_E6 */  0x243b,
/* d7b - _F2_0F_E6 */  0x243c,
/* d7c -  */  0,
/* d7d - _V_66_0F_E6 */  0x40bf,
/* d7e - _V_F3_0F_E6 */  0x40c0,
/* d7f - _V_F2_0F_E6 */  0x40c1,
/* d80 -  */  0,
/* d81 -  */  0,
/* d82 -  */  0,
/* d83 -  */  0,
/* d84 - _0F_E7 */  0x243d,
/* d85 - _66_0F_E7 */  0x243e,
/* d86 -  */  0,
/* d87 -  */  0,
/* d88 -  */  0,
/* d89 - _V_66_0F_E7 */  0x40c2,
/* d8a -  */  0,
/* d8b -  */  0,
/* d8c -  */  0,
/* d8d -  */  0,
/* d8e -  */  0,
/* d8f -  */  0,
/* d90 - _0F_E8 */  0x243f,
/* d91 - _66_0F_E8 */  0x2440,
/* d92 -  */  0,
/* d93 -  */  0,
/* d94 -  */  0,
/* d95 - _V_66_0F_E8 */  0x40c3,
/* d96 -  */  0,
/* d97 -  */  0,
/* d98 -  */  0,
/* d99 -  */  0,
/* d9a -  */  0,
/* d9b -  */  0,
/* d9c - _0F_E9 */  0x2441,
/* d9d - _66_0F_E9 */  0x2442,
/* d9e -  */  0,
/* d9f -  */  0,
/* da0 -  */  0,
/* da1 - _V_66_0F_E9 */  0x40c4,
/* da2 -  */  0,
/* da3 -  */  0,
/* da4 -  */  0,
/* da5 -  */  0,
/* da6 -  */  0,
/* da7 -  */  0,
/* da8 - _0F_EA */  0x2443,
/* da9 - _66_0F_EA */  0x2444,
/* daa -  */  0,
/* dab -  */  0,
/* dac -  */  0,
/* dad - _V_66_0F_EA */  0x40c5,
/* dae -  */  0,
/* daf -  */  0,
/* db0 -  */  0,
/* db1 -  */  0,
/* db2 -  */  0,
/* db3 -  */  0,
/* db4 - _0F_EB */  0x2445,
/* db5 - _66_0F_EB */  0x2446,
/* db6 -  */  0,
/* db7 -  */  0,
/* db8 -  */  0,
/* db9 - _V_66_0F_EB */  0x40c6,
/* dba -  */  0,
/* dbb -  */  0,
/* dbc -  */  0,
/* dbd -  */  0,
/* dbe -  */  0,
/* dbf -  */  0,
/* dc0 - _0F_EC */  0x2447,
/* dc1 - _66_0F_EC */  0x2448,
/* dc2 -  */  0,
/* dc3 -  */  0,
/* dc4 -  */  0,
/* dc5 - _V_66_0F_EC */  0x40c7,
/* dc6 -  */  0,
/* dc7 -  */  0,
/* dc8 -  */  0,
/* dc9 -  */  0,
/* dca -  */  0,
/* dcb -  */  0,
/* dcc - _0F_ED */  0x2449,
/* dcd - _66_0F_ED */  0x244a,
/* dce -  */  0,
/* dcf -  */  0,
/* dd0 -  */  0,
/* dd1 - _V_66_0F_ED */  0x40c8,
/* dd2 -  */  0,
/* dd3 -  */  0,
/* dd4 -  */  0,
/* dd5 -  */  0,
/* dd6 -  */  0,
/* dd7 -  */  0,
/* dd8 - _0F_EE */  0x244b,
/* dd9 - _66_0F_EE */  0x244c,
/* dda -  */  0,
/* ddb -  */  0,
/* ddc -  */  0,
/* ddd - _V_66_0F_EE */  0x40c9,
/* dde -  */  0,
/* ddf -  */  0,
/* de0 -  */  0,
/* de1 -  */  0,
/* de2 -  */  0,
/* de3 -  */  0,
/* de4 - _0F_EF */  0x244d,
/* de5 - _66_0F_EF */  0x244e,
/* de6 -  */  0,
/* de7 -  */  0,
/* de8 -  */  0,
/* de9 - _V_66_0F_EF */  0x40ca,
/* dea -  */  0,
/* deb -  */  0,
/* dec -  */  0,
/* ded -  */  0,
/* dee -  */  0,
/* def -  */  0,
/* df0 -  */  0,
/* df1 -  */  0,
/* df2 -  */  0,
/* df3 - _F2_0F_F0 */  0x244f,
/* df4 -  */  0,
/* df5 -  */  0,
/* df6 -  */  0,
/* df7 - _V_F2_0F_F0 */  0x40cb,
/* df8 -  */  0,
/* df9 -  */  0,
/* dfa -  */  0,
/* dfb -  */  0,
/* dfc - _0F_F1 */  0x2450,
/* dfd - _66_0F_F1 */  0x2451,
/* dfe -  */  0,
/* dff -  */  0,
/* e00 -  */  0,
/* e01 - _V_66_0F_F1 */  0x40cc,
/* e02 -  */  0,
/* e03 -  */  0,
/* e04 -  */  0,
/* e05 -  */  0,
/* e06 -  */  0,
/* e07 -  */  0,
/* e08 - _0F_F2 */  0x2452,
/* e09 - _66_0F_F2 */  0x2453,
/* e0a -  */  0,
/* e0b -  */  0,
/* e0c -  */  0,
/* e0d - _V_66_0F_F2 */  0x40cd,
/* e0e -  */  0,
/* e0f -  */  0,
/* e10 -  */  0,
/* e11 -  */  0,
/* e12 -  */  0,
/* e13 -  */  0,
/* e14 - _0F_F3 */  0x2454,
/* e15 - _66_0F_F3 */  0x2455,
/* e16 -  */  0,
/* e17 -  */  0,
/* e18 -  */  0,
/* e19 - _V_66_0F_F3 */  0x40ce,
/* e1a -  */  0,
/* e1b -  */  0,
/* e1c -  */  0,
/* e1d -  */  0,
/* e1e -  */  0,
/* e1f -  */  0,
/* e20 - _0F_F4 */  0x2456,
/* e21 - _66_0F_F4 */  0x2457,
/* e22 -  */  0,
/* e23 -  */  0,
/* e24 -  */  0,
/* e25 - _V_66_0F_F4 */  0x40cf,
/* e26 -  */  0,
/* e27 -  */  0,
/* e28 -  */  0,
/* e29 -  */  0,
/* e2a -  */  0,
/* e2b -  */  0,
/* e2c - _0F_F5 */  0x2458,
/* e2d - _66_0F_F5 */  0x2459,
/* e2e -  */  0,
/* e2f -  */  0,
/* e30 -  */  0,
/* e31 - _V_66_0F_F5 */  0x40d0,
/* e32 -  */  0,
/* e33 -  */  0,
/* e34 -  */  0,
/* e35 -  */  0,
/* e36 -  */  0,
/* e37 -  */  0,
/* e38 - _0F_F6 */  0x245a,
/* e39 - _66_0F_F6 */  0x245b,
/* e3a -  */  0,
/* e3b -  */  0,
/* e3c -  */  0,
/* e3d - _V_66_0F_F6 */  0x40d1,
/* e3e -  */  0,
/* e3f -  */  0,
/* e40 -  */  0,
/* e41 -  */  0,
/* e42 -  */  0,
/* e43 -  */  0,
/* e44 - _0F_F7 */  0x245c,
/* e45 - _66_0F_F7 */  0x245d,
/* e46 -  */  0,
/* e47 -  */  0,
/* e48 -  */  0,
/* e49 - _V_66_0F_F7 */  0x40d2,
/* e4a -  */  0,
/* e4b -  */  0,
/* e4c -  */  0,
/* e4d -  */  0,
/* e4e -  */  0,
/* e4f -  */  0,
/* e50 - _0F_F8 */  0x245e,
/* e51 - _66_0F_F8 */  0x245f,
/* e52 -  */  0,
/* e53 -  */  0,
/* e54 -  */  0,
/* e55 - _V_66_0F_F8 */  0x40d3,
/* e56 -  */  0,
/* e57 -  */  0,
/* e58 -  */  0,
/* e59 -  */  0,
/* e5a -  */  0,
/* e5b -  */  0,
/* e5c - _0F_F9 */  0x2460,
/* e5d - _66_0F_F9 */  0x2461,
/* e5e -  */  0,
/* e5f -  */  0,
/* e60 -  */  0,
/* e61 - _V_66_0F_F9 */  0x40d4,
/* e62 -  */  0,
/* e63 -  */  0,
/* e64 -  */  0,
/* e65 -  */  0,
/* e66 -  */  0,
/* e67 -  */  0,
/* e68 - _0F_FA */  0x2462,
/* e69 - _66_0F_FA */  0x2463,
/* e6a -  */  0,
/* e6b -  */  0,
/* e6c -  */  0,
/* e6d - _V_66_0F_FA */  0x40d5,
/* e6e -  */  0,
/* e6f -  */  0,
/* e70 -  */  0,
/* e71 -  */  0,
/* e72 -  */  0,
/* e73 -  */  0,
/* e74 - _0F_FB */  0x2464,
/* e75 - _66_0F_FB */  0x2465,
/* e76 -  */  0,
/* e77 -  */  0,
/* e78 -  */  0,
/* e79 - _V_66_0F_FB */  0x40d6,
/* e7a -  */  0,
/* e7b -  */  0,
/* e7c -  */  0,
/* e7d -  */  0,
/* e7e -  */  0,
/* e7f -  */  0,
/* e80 - _0F_FC */  0x2466,
/* e81 - _66_0F_FC */  0x2467,
/* e82 -  */  0,
/* e83 -  */  0,
/* e84 -  */  0,
/* e85 - _V_66_0F_FC */  0x40d7,
/* e86 -  */  0,
/* e87 -  */  0,
/* e88 -  */  0,
/* e89 -  */  0,
/* e8a -  */  0,
/* e8b -  */  0,
/* e8c - _0F_FD */  0x2468,
/* e8d - _66_0F_FD */  0x2469,
/* e8e -  */  0,
/* e8f -  */  0,
/* e90 -  */  0,
/* e91 - _V_66_0F_FD */  0x40d8,
/* e92 -  */  0,
/* e93 -  */  0,
/* e94 -  */  0,
/* e95 -  */  0,
/* e96 -  */  0,
/* e97 -  */  0,
/* e98 - _0F_FE */  0x246a,
/* e99 - _66_0F_FE */  0x246b,
/* e9a -  */  0,
/* e9b -  */  0,
/* e9c -  */  0,
/* e9d - _V_66_0F_FE */  0x40d9,
/* e9e -  */  0,
/* e9f -  */  0,
/* ea0 -  */  0,
/* ea1 -  */  0,
/* ea2 -  */  0,
/* ea3 -  */  0,
/* ea4 - _D9_06 */  0x246c,
/* ea5 - _9B_D9_06 */  0x246d,
/* ea6 -  */  0,
/* ea7 -  */  0,
/* ea8 -  */  0,
/* ea9 -  */  0,
/* eaa -  */  0,
/* eab -  */  0,
/* eac -  */  0,
/* ead -  */  0,
/* eae -  */  0,
/* eaf -  */  0,
/* eb0 - _D9_07 */  0x246e,
/* eb1 - _9B_D9_07 */  0x246f,
/* eb2 -  */  0,
/* eb3 -  */  0,
/* eb4 -  */  0,
/* eb5 -  */  0,
/* eb6 -  */  0,
/* eb7 -  */  0,
/* eb8 -  */  0,
/* eb9 -  */  0,
/* eba -  */  0,
/* ebb -  */  0,
/* ebc - _DB_E2 */  0x2470,
/* ebd - _9B_DB_E2 */  0x2471,
/* ebe -  */  0,
/* ebf -  */  0,
/* ec0 -  */  0,
/* ec1 -  */  0,
/* ec2 -  */  0,
/* ec3 -  */  0,
/* ec4 -  */  0,
/* ec5 -  */  0,
/* ec6 -  */  0,
/* ec7 -  */  0,
/* ec8 - _DB_E3 */  0x2472,
/* ec9 - _9B_DB_E3 */  0x2473,
/* eca -  */  0,
/* ecb -  */  0,
/* ecc -  */  0,
/* ecd -  */  0,
/* ece -  */  0,
/* ecf -  */  0,
/* ed0 -  */  0,
/* ed1 -  */  0,
/* ed2 -  */  0,
/* ed3 -  */  0,
/* ed4 - _DD_06 */  0x2474,
/* ed5 - _9B_DD_06 */  0x2475,
/* ed6 -  */  0,
/* ed7 -  */  0,
/* ed8 -  */  0,
/* ed9 -  */  0,
/* eda -  */  0,
/* edb -  */  0,
/* edc -  */  0,
/* edd -  */  0,
/* ede -  */  0,
/* edf -  */  0,
/* ee0 - _DD_07 */  0x2476,
/* ee1 - _9B_DD_07 */  0x2477,
/* ee2 -  */  0,
/* ee3 -  */  0,
/* ee4 -  */  0,
/* ee5 -  */  0,
/* ee6 -  */  0,
/* ee7 -  */  0,
/* ee8 -  */  0,
/* ee9 -  */  0,
/* eea -  */  0,
/* eeb -  */  0,
/* eec - _DF_E0 */  0x2478,
/* eed - _9B_DF_E0 */  0x2479,
/* eee -  */  0,
/* eef -  */  0,
/* ef0 -  */  0,
/* ef1 -  */  0,
/* ef2 -  */  0,
/* ef3 -  */  0,
/* ef4 -  */  0,
/* ef5 -  */  0,
/* ef6 -  */  0,
/* ef7 -  */  0,
/* ef8 - _0F_38_00 */  0x247a,
/* ef9 - _66_0F_38_00 */  0x247b,
/* efa -  */  0,
/* efb -  */  0,
/* efc -  */  0,
/* efd - _V_66_0F_38_00 */  0x40da,
/* efe -  */  0,
/* eff -  */  0,
/* f00 -  */  0,
/* f01 -  */  0,
/* f02 -  */  0,
/* f03 -  */  0,
/* f04 - _0F_38_01 */  0x247c,
/* f05 - _66_0F_38_01 */  0x247d,
/* f06 -  */  0,
/* f07 -  */  0,
/* f08 -  */  0,
/* f09 - _V_66_0F_38_01 */  0x40db,
/* f0a -  */  0,
/* f0b -  */  0,
/* f0c -  */  0,
/* f0d -  */  0,
/* f0e -  */  0,
/* f0f -  */  0,
/* f10 - _0F_38_02 */  0x247e,
/* f11 - _66_0F_38_02 */  0x247f,
/* f12 -  */  0,
/* f13 -  */  0,
/* f14 -  */  0,
/* f15 - _V_66_0F_38_02 */  0x40dc,
/* f16 -  */  0,
/* f17 -  */  0,
/* f18 -  */  0,
/* f19 -  */  0,
/* f1a -  */  0,
/* f1b -  */  0,
/* f1c - _0F_38_03 */  0x2480,
/* f1d - _66_0F_38_03 */  0x2481,
/* f1e -  */  0,
/* f1f -  */  0,
/* f20 -  */  0,
/* f21 - _V_66_0F_38_03 */  0x40dd,
/* f22 -  */  0,
/* f23 -  */  0,
/* f24 -  */  0,
/* f25 -  */  0,
/* f26 -  */  0,
/* f27 -  */  0,
/* f28 - _0F_38_04 */  0x2482,
/* f29 - _66_0F_38_04 */  0x2483,
/* f2a -  */  0,
/* f2b -  */  0,
/* f2c -  */  0,
/* f2d - _V_66_0F_38_04 */  0x40de,
/* f2e -  */  0,
/* f2f -  */  0,
/* f30 -  */  0,
/* f31 -  */  0,
/* f32 -  */  0,
/* f33 -  */  0,
/* f34 - _0F_38_05 */  0x2484,
/* f35 - _66_0F_38_05 */  0x2485,
/* f36 -  */  0,
/* f37 -  */  0,
/* f38 -  */  0,
/* f39 - _V_66_0F_38_05 */  0x40df,
/* f3a -  */  0,
/* f3b -  */  0,
/* f3c -  */  0,
/* f3d -  */  0,
/* f3e -  */  0,
/* f3f -  */  0,
/* f40 - _0F_38_06 */  0x2486,
/* f41 - _66_0F_38_06 */  0x2487,
/* f42 -  */  0,
/* f43 -  */  0,
/* f44 -  */  0,
/* f45 - _V_66_0F_38_06 */  0x40e0,
/* f46 -  */  0,
/* f47 -  */  0,
/* f48 -  */  0,
/* f49 -  */  0,
/* f4a -  */  0,
/* f4b -  */  0,
/* f4c - _0F_38_07 */  0x2488,
/* f4d - _66_0F_38_07 */  0x2489,
/* f4e -  */  0,
/* f4f -  */  0,
/* f50 -  */  0,
/* f51 - _V_66_0F_38_07 */  0x40e1,
/* f52 -  */  0,
/* f53 -  */  0,
/* f54 -  */  0,
/* f55 -  */  0,
/* f56 -  */  0,
/* f57 -  */  0,
/* f58 - _0F_38_08 */  0x248a,
/* f59 - _66_0F_38_08 */  0x248b,
/* f5a -  */  0,
/* f5b -  */  0,
/* f5c -  */  0,
/* f5d - _V_66_0F_38_08 */  0x40e2,
/* f5e -  */  0,
/* f5f -  */  0,
/* f60 -  */  0,
/* f61 -  */  0,
/* f62 -  */  0,
/* f63 -  */  0,
/* f64 - _0F_38_09 */  0x248c,
/* f65 - _66_0F_38_09 */  0x248d,
/* f66 -  */  0,
/* f67 -  */  0,
/* f68 -  */  0,
/* f69 - _V_66_0F_38_09 */  0x40e3,
/* f6a -  */  0,
/* f6b -  */  0,
/* f6c -  */  0,
/* f6d -  */  0,
/* f6e -  */  0,
/* f6f -  */  0,
/* f70 - _0F_38_0A */  0x248e,
/* f71 - _66_0F_38_0A */  0x248f,
/* f72 -  */  0,
/* f73 -  */  0,
/* f74 -  */  0,
/* f75 - _V_66_0F_38_0A */  0x40e4,
/* f76 -  */  0,
/* f77 -  */  0,
/* f78 -  */  0,
/* f79 -  */  0,
/* f7a -  */  0,
/* f7b -  */  0,
/* f7c - _0F_38_0B */  0x2490,
/* f7d - _66_0F_38_0B */  0x2491,
/* f7e -  */  0,
/* f7f -  */  0,
/* f80 -  */  0,
/* f81 - _V_66_0F_38_0B */  0x40e5,
/* f82 -  */  0,
/* f83 -  */  0,
/* f84 -  */  0,
/* f85 -  */  0,
/* f86 -  */  0,
/* f87 -  */  0,
/* f88 -  */  0,
/* f89 -  */  0,
/* f8a -  */  0,
/* f8b -  */  0,
/* f8c -  */  0,
/* f8d - _V_66_0F_38_0C */  0x40e6,
/* f8e -  */  0,
/* f8f -  */  0,
/* f90 -  */  0,
/* f91 -  */  0,
/* f92 -  */  0,
/* f93 -  */  0,
/* f94 -  */  0,
/* f95 -  */  0,
/* f96 -  */  0,
/* f97 -  */  0,
/* f98 -  */  0,
/* f99 - _V_66_0F_38_0D */  0x40e7,
/* f9a -  */  0,
/* f9b -  */  0,
/* f9c -  */  0,
/* f9d -  */  0,
/* f9e -  */  0,
/* f9f -  */  0,
/* fa0 -  */  0,
/* fa1 -  */  0,
/* fa2 -  */  0,
/* fa3 -  */  0,
/* fa4 -  */  0,
/* fa5 - _V_66_0F_38_0E */  0x40e8,
/* fa6 -  */  0,
/* fa7 -  */  0,
/* fa8 -  */  0,
/* fa9 -  */  0,
/* faa -  */  0,
/* fab -  */  0,
/* fac -  */  0,
/* fad -  */  0,
/* fae -  */  0,
/* faf -  */  0,
/* fb0 -  */  0,
/* fb1 - _V_66_0F_38_0F */  0x40e9,
/* fb2 -  */  0,
/* fb3 -  */  0,
/* fb4 -  */  0,
/* fb5 -  */  0,
/* fb6 -  */  0,
/* fb7 -  */  0,
/* fb8 -  */  0,
/* fb9 - _66_0F_38_10 */  0x40ea,
/* fba -  */  0,
/* fbb -  */  0,
/* fbc -  */  0,
/* fbd -  */  0,
/* fbe -  */  0,
/* fbf -  */  0,
/* fc0 -  */  0,
/* fc1 -  */  0,
/* fc2 -  */  0,
/* fc3 -  */  0,
/* fc4 -  */  0,
/* fc5 - _66_0F_38_14 */  0x40eb,
/* fc6 -  */  0,
/* fc7 -  */  0,
/* fc8 -  */  0,
/* fc9 -  */  0,
/* fca -  */  0,
/* fcb -  */  0,
/* fcc -  */  0,
/* fcd -  */  0,
/* fce -  */  0,
/* fcf -  */  0,
/* fd0 -  */  0,
/* fd1 - _66_0F_38_15 */  0x40ec,
/* fd2 -  */  0,
/* fd3 -  */  0,
/* fd4 -  */  0,
/* fd5 -  */  0,
/* fd6 -  */  0,
/* fd7 -  */  0,
/* fd8 -  */  0,
/* fd9 -  */  0,
/* fda -  */  0,
/* fdb -  */  0,
/* fdc -  */  0,
/* fdd - _66_0F_38_17 */  0x2492,
/* fde -  */  0,
/* fdf -  */  0,
/* fe0 -  */  0,
/* fe1 - _V_66_0F_38_17 */  0x40ed,
/* fe2 -  */  0,
/* fe3 -  */  0,
/* fe4 -  */  0,
/* fe5 -  */  0,
/* fe6 -  */  0,
/* fe7 -  */  0,
/* fe8 -  */  0,
/* fe9 -  */  0,
/* fea -  */  0,
/* feb -  */  0,
/* fec -  */  0,
/* fed - _V_66_0F_38_18 */  0x40ee,
/* fee -  */  0,
/* fef -  */  0,
/* ff0 -  */  0,
/* ff1 -  */  0,
/* ff2 -  */  0,
/* ff3 -  */  0,
/* ff4 -  */  0,
/* ff5 -  */  0,
/* ff6 -  */  0,
/* ff7 -  */  0,
/* ff8 -  */  0,
/* ff9 - _V_66_0F_38_19 */  0x40ef,
/* ffa -  */  0,
/* ffb -  */  0,
/* ffc -  */  0,
/* ffd -  */  0,
/* ffe -  */  0,
/* fff -  */  0,
/* 1000 -  */  0,
/* 1001 -  */  0,
/* 1002 -  */  0,
/* 1003 -  */  0,
/* 1004 -  */  0,
/* 1005 - _V_66_0F_38_1A */  0x40f0,
/* 1006 -  */  0,
/* 1007 -  */  0,
/* 1008 -  */  0,
/* 1009 -  */  0,
/* 100a -  */  0,
/* 100b -  */  0,
/* 100c - _0F_38_1C */  0x2493,
/* 100d - _66_0F_38_1C */  0x2494,
/* 100e -  */  0,
/* 100f -  */  0,
/* 1010 -  */  0,
/* 1011 - _V_66_0F_38_1C */  0x40f1,
/* 1012 -  */  0,
/* 1013 -  */  0,
/* 1014 -  */  0,
/* 1015 -  */  0,
/* 1016 -  */  0,
/* 1017 -  */  0,
/* 1018 - _0F_38_1D */  0x2495,
/* 1019 - _66_0F_38_1D */  0x2496,
/* 101a -  */  0,
/* 101b -  */  0,
/* 101c -  */  0,
/* 101d - _V_66_0F_38_1D */  0x40f2,
/* 101e -  */  0,
/* 101f -  */  0,
/* 1020 -  */  0,
/* 1021 -  */  0,
/* 1022 -  */  0,
/* 1023 -  */  0,
/* 1024 - _0F_38_1E */  0x2497,
/* 1025 - _66_0F_38_1E */  0x2498,
/* 1026 -  */  0,
/* 1027 -  */  0,
/* 1028 -  */  0,
/* 1029 - _V_66_0F_38_1E */  0x40f3,
/* 102a -  */  0,
/* 102b -  */  0,
/* 102c -  */  0,
/* 102d -  */  0,
/* 102e -  */  0,
/* 102f -  */  0,
/* 1030 -  */  0,
/* 1031 - _66_0F_38_20 */  0x2499,
/* 1032 -  */  0,
/* 1033 -  */  0,
/* 1034 -  */  0,
/* 1035 - _V_66_0F_38_20 */  0x40f4,
/* 1036 -  */  0,
/* 1037 -  */  0,
/* 1038 -  */  0,
/* 1039 -  */  0,
/* 103a -  */  0,
/* 103b -  */  0,
/* 103c -  */  0,
/* 103d - _66_0F_38_21 */  0x249a,
/* 103e -  */  0,
/* 103f -  */  0,
/* 1040 -  */  0,
/* 1041 - _V_66_0F_38_21 */  0x40f5,
/* 1042 -  */  0,
/* 1043 -  */  0,
/* 1044 -  */  0,
/* 1045 -  */  0,
/* 1046 -  */  0,
/* 1047 -  */  0,
/* 1048 -  */  0,
/* 1049 - _66_0F_38_22 */  0x249b,
/* 104a -  */  0,
/* 104b -  */  0,
/* 104c -  */  0,
/* 104d - _V_66_0F_38_22 */  0x40f6,
/* 104e -  */  0,
/* 104f -  */  0,
/* 1050 -  */  0,
/* 1051 -  */  0,
/* 1052 -  */  0,
/* 1053 -  */  0,
/* 1054 -  */  0,
/* 1055 - _66_0F_38_23 */  0x249c,
/* 1056 -  */  0,
/* 1057 -  */  0,
/* 1058 -  */  0,
/* 1059 - _V_66_0F_38_23 */  0x40f7,
/* 105a -  */  0,
/* 105b -  */  0,
/* 105c -  */  0,
/* 105d -  */  0,
/* 105e -  */  0,
/* 105f -  */  0,
/* 1060 -  */  0,
/* 1061 - _66_0F_38_24 */  0x249d,
/* 1062 -  */  0,
/* 1063 -  */  0,
/* 1064 -  */  0,
/* 1065 - _V_66_0F_38_24 */  0x40f8,
/* 1066 -  */  0,
/* 1067 -  */  0,
/* 1068 -  */  0,
/* 1069 -  */  0,
/* 106a -  */  0,
/* 106b -  */  0,
/* 106c -  */  0,
/* 106d - _66_0F_38_25 */  0x249e,
/* 106e -  */  0,
/* 106f -  */  0,
/* 1070 -  */  0,
/* 1071 - _V_66_0F_38_25 */  0x40f9,
/* 1072 -  */  0,
/* 1073 -  */  0,
/* 1074 -  */  0,
/* 1075 -  */  0,
/* 1076 -  */  0,
/* 1077 -  */  0,
/* 1078 -  */  0,
/* 1079 - _66_0F_38_28 */  0x249f,
/* 107a -  */  0,
/* 107b -  */  0,
/* 107c -  */  0,
/* 107d - _V_66_0F_38_28 */  0x40fa,
/* 107e -  */  0,
/* 107f -  */  0,
/* 1080 -  */  0,
/* 1081 -  */  0,
/* 1082 -  */  0,
/* 1083 -  */  0,
/* 1084 -  */  0,
/* 1085 - _66_0F_38_29 */  0x24a0,
/* 1086 -  */  0,
/* 1087 -  */  0,
/* 1088 -  */  0,
/* 1089 - _V_66_0F_38_29 */  0x40fb,
/* 108a -  */  0,
/* 108b -  */  0,
/* 108c -  */  0,
/* 108d -  */  0,
/* 108e -  */  0,
/* 108f -  */  0,
/* 1090 -  */  0,
/* 1091 - _66_0F_38_2A */  0x24a1,
/* 1092 -  */  0,
/* 1093 -  */  0,
/* 1094 -  */  0,
/* 1095 - _V_66_0F_38_2A */  0x40fc,
/* 1096 -  */  0,
/* 1097 -  */  0,
/* 1098 -  */  0,
/* 1099 -  */  0,
/* 109a -  */  0,
/* 109b -  */  0,
/* 109c -  */  0,
/* 109d - _66_0F_38_2B */  0x24a2,
/* 109e -  */  0,
/* 109f -  */  0,
/* 10a0 -  */  0,
/* 10a1 - _V_66_0F_38_2B */  0x40fd,
/* 10a2 -  */  0,
/* 10a3 -  */  0,
/* 10a4 -  */  0,
/* 10a5 -  */  0,
/* 10a6 -  */  0,
/* 10a7 -  */  0,
/* 10a8 -  */  0,
/* 10a9 -  */  0,
/* 10aa -  */  0,
/* 10ab -  */  0,
/* 10ac -  */  0,
/* 10ad - _V_66_0F_38_2C */  0x40fe,
/* 10ae -  */  0,
/* 10af -  */  0,
/* 10b0 -  */  0,
/* 10b1 -  */  0,
/* 10b2 -  */  0,
/* 10b3 -  */  0,
/* 10b4 -  */  0,
/* 10b5 -  */  0,
/* 10b6 -  */  0,
/* 10b7 -  */  0,
/* 10b8 -  */  0,
/* 10b9 - _V_66_0F_38_2D */  0x40ff,
/* 10ba -  */  0,
/* 10bb -  */  0,
/* 10bc -  */  0,
/* 10bd -  */  0,
/* 10be -  */  0,
/* 10bf -  */  0,
/* 10c0 -  */  0,
/* 10c1 -  */  0,
/* 10c2 -  */  0,
/* 10c3 -  */  0,
/* 10c4 -  */  0,
/* 10c5 - _V_66_0F_38_2E */  0x4100,
/* 10c6 -  */  0,
/* 10c7 -  */  0,
/* 10c8 -  */  0,
/* 10c9 -  */  0,
/* 10ca -  */  0,
/* 10cb -  */  0,
/* 10cc -  */  0,
/* 10cd -  */  0,
/* 10ce -  */  0,
/* 10cf -  */  0,
/* 10d0 -  */  0,
/* 10d1 - _V_66_0F_38_2F */  0x4101,
/* 10d2 -  */  0,
/* 10d3 -  */  0,
/* 10d4 -  */  0,
/* 10d5 -  */  0,
/* 10d6 -  */  0,
/* 10d7 -  */  0,
/* 10d8 -  */  0,
/* 10d9 - _66_0F_38_30 */  0x24a3,
/* 10da -  */  0,
/* 10db -  */  0,
/* 10dc -  */  0,
/* 10dd - _V_66_0F_38_30 */  0x4102,
/* 10de -  */  0,
/* 10df -  */  0,
/* 10e0 -  */  0,
/* 10e1 -  */  0,
/* 10e2 -  */  0,
/* 10e3 -  */  0,
/* 10e4 -  */  0,
/* 10e5 - _66_0F_38_31 */  0x24a4,
/* 10e6 -  */  0,
/* 10e7 -  */  0,
/* 10e8 -  */  0,
/* 10e9 - _V_66_0F_38_31 */  0x4103,
/* 10ea -  */  0,
/* 10eb -  */  0,
/* 10ec -  */  0,
/* 10ed -  */  0,
/* 10ee -  */  0,
/* 10ef -  */  0,
/* 10f0 -  */  0,
/* 10f1 - _66_0F_38_32 */  0x24a5,
/* 10f2 -  */  0,
/* 10f3 -  */  0,
/* 10f4 -  */  0,
/* 10f5 - _V_66_0F_38_32 */  0x4104,
/* 10f6 -  */  0,
/* 10f7 -  */  0,
/* 10f8 -  */  0,
/* 10f9 -  */  0,
/* 10fa -  */  0,
/* 10fb -  */  0,
/* 10fc -  */  0,
/* 10fd - _66_0F_38_33 */  0x24a6,
/* 10fe -  */  0,
/* 10ff -  */  0,
/* 1100 -  */  0,
/* 1101 - _V_66_0F_38_33 */  0x4105,
/* 1102 -  */  0,
/* 1103 -  */  0,
/* 1104 -  */  0,
/* 1105 -  */  0,
/* 1106 -  */  0,
/* 1107 -  */  0,
/* 1108 -  */  0,
/* 1109 - _66_0F_38_34 */  0x24a7,
/* 110a -  */  0,
/* 110b -  */  0,
/* 110c -  */  0,
/* 110d - _V_66_0F_38_34 */  0x4106,
/* 110e -  */  0,
/* 110f -  */  0,
/* 1110 -  */  0,
/* 1111 -  */  0,
/* 1112 -  */  0,
/* 1113 -  */  0,
/* 1114 -  */  0,
/* 1115 - _66_0F_38_35 */  0x24a8,
/* 1116 -  */  0,
/* 1117 -  */  0,
/* 1118 -  */  0,
/* 1119 - _V_66_0F_38_35 */  0x4107,
/* 111a -  */  0,
/* 111b -  */  0,
/* 111c -  */  0,
/* 111d -  */  0,
/* 111e -  */  0,
/* 111f -  */  0,
/* 1120 -  */  0,
/* 1121 - _66_0F_38_37 */  0x24a9,
/* 1122 -  */  0,
/* 1123 -  */  0,
/* 1124 -  */  0,
/* 1125 - _V_66_0F_38_37 */  0x4108,
/* 1126 -  */  0,
/* 1127 -  */  0,
/* 1128 -  */  0,
/* 1129 -  */  0,
/* 112a -  */  0,
/* 112b -  */  0,
/* 112c -  */  0,
/* 112d - _66_0F_38_38 */  0x24aa,
/* 112e -  */  0,
/* 112f -  */  0,
/* 1130 -  */  0,
/* 1131 - _V_66_0F_38_38 */  0x4109,
/* 1132 -  */  0,
/* 1133 -  */  0,
/* 1134 -  */  0,
/* 1135 -  */  0,
/* 1136 -  */  0,
/* 1137 -  */  0,
/* 1138 -  */  0,
/* 1139 - _66_0F_38_39 */  0x24ab,
/* 113a -  */  0,
/* 113b -  */  0,
/* 113c -  */  0,
/* 113d - _V_66_0F_38_39 */  0x410a,
/* 113e -  */  0,
/* 113f -  */  0,
/* 1140 -  */  0,
/* 1141 -  */  0,
/* 1142 -  */  0,
/* 1143 -  */  0,
/* 1144 -  */  0,
/* 1145 - _66_0F_38_3A */  0x24ac,
/* 1146 -  */  0,
/* 1147 -  */  0,
/* 1148 -  */  0,
/* 1149 - _V_66_0F_38_3A */  0x410b,
/* 114a -  */  0,
/* 114b -  */  0,
/* 114c -  */  0,
/* 114d -  */  0,
/* 114e -  */  0,
/* 114f -  */  0,
/* 1150 -  */  0,
/* 1151 - _66_0F_38_3B */  0x24ad,
/* 1152 -  */  0,
/* 1153 -  */  0,
/* 1154 -  */  0,
/* 1155 - _V_66_0F_38_3B */  0x410c,
/* 1156 -  */  0,
/* 1157 -  */  0,
/* 1158 -  */  0,
/* 1159 -  */  0,
/* 115a -  */  0,
/* 115b -  */  0,
/* 115c -  */  0,
/* 115d - _66_0F_38_3C */  0x24ae,
/* 115e -  */  0,
/* 115f -  */  0,
/* 1160 -  */  0,
/* 1161 - _V_66_0F_38_3C */  0x410d,
/* 1162 -  */  0,
/* 1163 -  */  0,
/* 1164 -  */  0,
/* 1165 -  */  0,
/* 1166 -  */  0,
/* 1167 -  */  0,
/* 1168 -  */  0,
/* 1169 - _66_0F_38_3D */  0x24af,
/* 116a -  */  0,
/* 116b -  */  0,
/* 116c -  */  0,
/* 116d - _V_66_0F_38_3D */  0x410e,
/* 116e -  */  0,
/* 116f -  */  0,
/* 1170 -  */  0,
/* 1171 -  */  0,
/* 1172 -  */  0,
/* 1173 -  */  0,
/* 1174 -  */  0,
/* 1175 - _66_0F_38_3E */  0x24b0,
/* 1176 -  */  0,
/* 1177 -  */  0,
/* 1178 -  */  0,
/* 1179 - _V_66_0F_38_3E */  0x410f,
/* 117a -  */  0,
/* 117b -  */  0,
/* 117c -  */  0,
/* 117d -  */  0,
/* 117e -  */  0,
/* 117f -  */  0,
/* 1180 -  */  0,
/* 1181 - _66_0F_38_3F */  0x24b1,
/* 1182 -  */  0,
/* 1183 -  */  0,
/* 1184 -  */  0,
/* 1185 - _V_66_0F_38_3F */  0x4110,
/* 1186 -  */  0,
/* 1187 -  */  0,
/* 1188 -  */  0,
/* 1189 -  */  0,
/* 118a -  */  0,
/* 118b -  */  0,
/* 118c -  */  0,
/* 118d - _66_0F_38_40 */  0x24b2,
/* 118e -  */  0,
/* 118f -  */  0,
/* 1190 -  */  0,
/* 1191 - _V_66_0F_38_40 */  0x4111,
/* 1192 -  */  0,
/* 1193 -  */  0,
/* 1194 -  */  0,
/* 1195 -  */  0,
/* 1196 -  */  0,
/* 1197 -  */  0,
/* 1198 -  */  0,
/* 1199 - _66_0F_38_41 */  0x24b3,
/* 119a -  */  0,
/* 119b -  */  0,
/* 119c -  */  0,
/* 119d - _V_66_0F_38_41 */  0x4112,
/* 119e -  */  0,
/* 119f -  */  0,
/* 11a0 -  */  0,
/* 11a1 -  */  0,
/* 11a2 -  */  0,
/* 11a3 -  */  0,
/* 11a4 -  */  0,
/* 11a5 - _66_0F_38_80 */  0x24b4,
/* 11a6 -  */  0,
/* 11a7 -  */  0,
/* 11a8 -  */  0,
/* 11a9 -  */  0,
/* 11aa -  */  0,
/* 11ab -  */  0,
/* 11ac -  */  0,
/* 11ad -  */  0,
/* 11ae -  */  0,
/* 11af -  */  0,
/* 11b0 -  */  0,
/* 11b1 - _66_0F_38_81 */  0x24b5,
/* 11b2 -  */  0,
/* 11b3 -  */  0,
/* 11b4 -  */  0,
/* 11b5 -  */  0,
/* 11b6 -  */  0,
/* 11b7 -  */  0,
/* 11b8 -  */  0,
/* 11b9 -  */  0,
/* 11ba -  */  0,
/* 11bb -  */  0,
/* 11bc -  */  0,
/* 11bd - _66_0F_38_82 */  0x24b6,
/* 11be -  */  0,
/* 11bf -  */  0,
/* 11c0 -  */  0,
/* 11c1 -  */  0,
/* 11c2 -  */  0,
/* 11c3 -  */  0,
/* 11c4 -  */  0,
/* 11c5 -  */  0,
/* 11c6 -  */  0,
/* 11c7 -  */  0,
/* 11c8 -  */  0,
/* 11c9 -  */  0,
/* 11ca -  */  0,
/* 11cb -  */  0,
/* 11cc -  */  0,
/* 11cd - _V_66_0F_38_96 */  0x4113,
/* 11ce -  */  0,
/* 11cf -  */  0,
/* 11d0 -  */  0,
/* 11d1 -  */  0,
/* 11d2 -  */  0,
/* 11d3 -  */  0,
/* 11d4 -  */  0,
/* 11d5 -  */  0,
/* 11d6 -  */  0,
/* 11d7 -  */  0,
/* 11d8 -  */  0,
/* 11d9 - _V_66_0F_38_97 */  0x4114,
/* 11da -  */  0,
/* 11db -  */  0,
/* 11dc -  */  0,
/* 11dd -  */  0,
/* 11de -  */  0,
/* 11df -  */  0,
/* 11e0 -  */  0,
/* 11e1 -  */  0,
/* 11e2 -  */  0,
/* 11e3 -  */  0,
/* 11e4 -  */  0,
/* 11e5 - _V_66_0F_38_98 */  0x4115,
/* 11e6 -  */  0,
/* 11e7 -  */  0,
/* 11e8 -  */  0,
/* 11e9 -  */  0,
/* 11ea -  */  0,
/* 11eb -  */  0,
/* 11ec -  */  0,
/* 11ed -  */  0,
/* 11ee -  */  0,
/* 11ef -  */  0,
/* 11f0 -  */  0,
/* 11f1 - _V_66_0F_38_99 */  0x4116,
/* 11f2 -  */  0,
/* 11f3 -  */  0,
/* 11f4 -  */  0,
/* 11f5 -  */  0,
/* 11f6 -  */  0,
/* 11f7 -  */  0,
/* 11f8 -  */  0,
/* 11f9 -  */  0,
/* 11fa -  */  0,
/* 11fb -  */  0,
/* 11fc -  */  0,
/* 11fd - _V_66_0F_38_9A */  0x4117,
/* 11fe -  */  0,
/* 11ff -  */  0,
/* 1200 -  */  0,
/* 1201 -  */  0,
/* 1202 -  */  0,
/* 1203 -  */  0,
/* 1204 -  */  0,
/* 1205 -  */  0,
/* 1206 -  */  0,
/* 1207 -  */  0,
/* 1208 -  */  0,
/* 1209 - _V_66_0F_38_9B */  0x4118,
/* 120a -  */  0,
/* 120b -  */  0,
/* 120c -  */  0,
/* 120d -  */  0,
/* 120e -  */  0,
/* 120f -  */  0,
/* 1210 -  */  0,
/* 1211 -  */  0,
/* 1212 -  */  0,
/* 1213 -  */  0,
/* 1214 -  */  0,
/* 1215 - _V_66_0F_38_9C */  0x4119,
/* 1216 -  */  0,
/* 1217 -  */  0,
/* 1218 -  */  0,
/* 1219 -  */  0,
/* 121a -  */  0,
/* 121b -  */  0,
/* 121c -  */  0,
/* 121d -  */  0,
/* 121e -  */  0,
/* 121f -  */  0,
/* 1220 -  */  0,
/* 1221 - _V_66_0F_38_9D */  0x411a,
/* 1222 -  */  0,
/* 1223 -  */  0,
/* 1224 -  */  0,
/* 1225 -  */  0,
/* 1226 -  */  0,
/* 1227 -  */  0,
/* 1228 -  */  0,
/* 1229 -  */  0,
/* 122a -  */  0,
/* 122b -  */  0,
/* 122c -  */  0,
/* 122d - _V_66_0F_38_9E */  0x411b,
/* 122e -  */  0,
/* 122f -  */  0,
/* 1230 -  */  0,
/* 1231 -  */  0,
/* 1232 -  */  0,
/* 1233 -  */  0,
/* 1234 -  */  0,
/* 1235 -  */  0,
/* 1236 -  */  0,
/* 1237 -  */  0,
/* 1238 -  */  0,
/* 1239 - _V_66_0F_38_9F */  0x411c,
/* 123a -  */  0,
/* 123b -  */  0,
/* 123c -  */  0,
/* 123d -  */  0,
/* 123e -  */  0,
/* 123f -  */  0,
/* 1240 -  */  0,
/* 1241 -  */  0,
/* 1242 -  */  0,
/* 1243 -  */  0,
/* 1244 -  */  0,
/* 1245 - _V_66_0F_38_A6 */  0x411d,
/* 1246 -  */  0,
/* 1247 -  */  0,
/* 1248 -  */  0,
/* 1249 -  */  0,
/* 124a -  */  0,
/* 124b -  */  0,
/* 124c -  */  0,
/* 124d -  */  0,
/* 124e -  */  0,
/* 124f -  */  0,
/* 1250 -  */  0,
/* 1251 - _V_66_0F_38_A7 */  0x411e,
/* 1252 -  */  0,
/* 1253 -  */  0,
/* 1254 -  */  0,
/* 1255 -  */  0,
/* 1256 -  */  0,
/* 1257 -  */  0,
/* 1258 -  */  0,
/* 1259 -  */  0,
/* 125a -  */  0,
/* 125b -  */  0,
/* 125c -  */  0,
/* 125d - _V_66_0F_38_A8 */  0x411f,
/* 125e -  */  0,
/* 125f -  */  0,
/* 1260 -  */  0,
/* 1261 -  */  0,
/* 1262 -  */  0,
/* 1263 -  */  0,
/* 1264 -  */  0,
/* 1265 -  */  0,
/* 1266 -  */  0,
/* 1267 -  */  0,
/* 1268 -  */  0,
/* 1269 - _V_66_0F_38_A9 */  0x4120,
/* 126a -  */  0,
/* 126b -  */  0,
/* 126c -  */  0,
/* 126d -  */  0,
/* 126e -  */  0,
/* 126f -  */  0,
/* 1270 -  */  0,
/* 1271 -  */  0,
/* 1272 -  */  0,
/* 1273 -  */  0,
/* 1274 -  */  0,
/* 1275 - _V_66_0F_38_AA */  0x4121,
/* 1276 -  */  0,
/* 1277 -  */  0,
/* 1278 -  */  0,
/* 1279 -  */  0,
/* 127a -  */  0,
/* 127b -  */  0,
/* 127c -  */  0,
/* 127d -  */  0,
/* 127e -  */  0,
/* 127f -  */  0,
/* 1280 -  */  0,
/* 1281 - _V_66_0F_38_AB */  0x4122,
/* 1282 -  */  0,
/* 1283 -  */  0,
/* 1284 -  */  0,
/* 1285 -  */  0,
/* 1286 -  */  0,
/* 1287 -  */  0,
/* 1288 -  */  0,
/* 1289 -  */  0,
/* 128a -  */  0,
/* 128b -  */  0,
/* 128c -  */  0,
/* 128d - _V_66_0F_38_AC */  0x4123,
/* 128e -  */  0,
/* 128f -  */  0,
/* 1290 -  */  0,
/* 1291 -  */  0,
/* 1292 -  */  0,
/* 1293 -  */  0,
/* 1294 -  */  0,
/* 1295 -  */  0,
/* 1296 -  */  0,
/* 1297 -  */  0,
/* 1298 -  */  0,
/* 1299 - _V_66_0F_38_AD */  0x4124,
/* 129a -  */  0,
/* 129b -  */  0,
/* 129c -  */  0,
/* 129d -  */  0,
/* 129e -  */  0,
/* 129f -  */  0,
/* 12a0 -  */  0,
/* 12a1 -  */  0,
/* 12a2 -  */  0,
/* 12a3 -  */  0,
/* 12a4 -  */  0,
/* 12a5 - _V_66_0F_38_AE */  0x4125,
/* 12a6 -  */  0,
/* 12a7 -  */  0,
/* 12a8 -  */  0,
/* 12a9 -  */  0,
/* 12aa -  */  0,
/* 12ab -  */  0,
/* 12ac -  */  0,
/* 12ad -  */  0,
/* 12ae -  */  0,
/* 12af -  */  0,
/* 12b0 -  */  0,
/* 12b1 - _V_66_0F_38_AF */  0x4126,
/* 12b2 -  */  0,
/* 12b3 -  */  0,
/* 12b4 -  */  0,
/* 12b5 -  */  0,
/* 12b6 -  */  0,
/* 12b7 -  */  0,
/* 12b8 -  */  0,
/* 12b9 -  */  0,
/* 12ba -  */  0,
/* 12bb -  */  0,
/* 12bc -  */  0,
/* 12bd - _V_66_0F_38_B6 */  0x4127,
/* 12be -  */  0,
/* 12bf -  */  0,
/* 12c0 -  */  0,
/* 12c1 -  */  0,
/* 12c2 -  */  0,
/* 12c3 -  */  0,
/* 12c4 -  */  0,
/* 12c5 -  */  0,
/* 12c6 -  */  0,
/* 12c7 -  */  0,
/* 12c8 -  */  0,
/* 12c9 - _V_66_0F_38_B7 */  0x4128,
/* 12ca -  */  0,
/* 12cb -  */  0,
/* 12cc -  */  0,
/* 12cd -  */  0,
/* 12ce -  */  0,
/* 12cf -  */  0,
/* 12d0 -  */  0,
/* 12d1 -  */  0,
/* 12d2 -  */  0,
/* 12d3 -  */  0,
/* 12d4 -  */  0,
/* 12d5 - _V_66_0F_38_B8 */  0x4129,
/* 12d6 -  */  0,
/* 12d7 -  */  0,
/* 12d8 -  */  0,
/* 12d9 -  */  0,
/* 12da -  */  0,
/* 12db -  */  0,
/* 12dc -  */  0,
/* 12dd -  */  0,
/* 12de -  */  0,
/* 12df -  */  0,
/* 12e0 -  */  0,
/* 12e1 - _V_66_0F_38_B9 */  0x412a,
/* 12e2 -  */  0,
/* 12e3 -  */  0,
/* 12e4 -  */  0,
/* 12e5 -  */  0,
/* 12e6 -  */  0,
/* 12e7 -  */  0,
/* 12e8 -  */  0,
/* 12e9 -  */  0,
/* 12ea -  */  0,
/* 12eb -  */  0,
/* 12ec -  */  0,
/* 12ed - _V_66_0F_38_BA */  0x412b,
/* 12ee -  */  0,
/* 12ef -  */  0,
/* 12f0 -  */  0,
/* 12f1 -  */  0,
/* 12f2 -  */  0,
/* 12f3 -  */  0,
/* 12f4 -  */  0,
/* 12f5 -  */  0,
/* 12f6 -  */  0,
/* 12f7 -  */  0,
/* 12f8 -  */  0,
/* 12f9 - _V_66_0F_38_BB */  0x412c,
/* 12fa -  */  0,
/* 12fb -  */  0,
/* 12fc -  */  0,
/* 12fd -  */  0,
/* 12fe -  */  0,
/* 12ff -  */  0,
/* 1300 -  */  0,
/* 1301 -  */  0,
/* 1302 -  */  0,
/* 1303 -  */  0,
/* 1304 -  */  0,
/* 1305 - _V_66_0F_38_BC */  0x412d,
/* 1306 -  */  0,
/* 1307 -  */  0,
/* 1308 -  */  0,
/* 1309 -  */  0,
/* 130a -  */  0,
/* 130b -  */  0,
/* 130c -  */  0,
/* 130d -  */  0,
/* 130e -  */  0,
/* 130f -  */  0,
/* 1310 -  */  0,
/* 1311 - _V_66_0F_38_BD */  0x412e,
/* 1312 -  */  0,
/* 1313 -  */  0,
/* 1314 -  */  0,
/* 1315 -  */  0,
/* 1316 -  */  0,
/* 1317 -  */  0,
/* 1318 -  */  0,
/* 1319 -  */  0,
/* 131a -  */  0,
/* 131b -  */  0,
/* 131c -  */  0,
/* 131d - _V_66_0F_38_BE */  0x412f,
/* 131e -  */  0,
/* 131f -  */  0,
/* 1320 -  */  0,
/* 1321 -  */  0,
/* 1322 -  */  0,
/* 1323 -  */  0,
/* 1324 -  */  0,
/* 1325 -  */  0,
/* 1326 -  */  0,
/* 1327 -  */  0,
/* 1328 -  */  0,
/* 1329 - _V_66_0F_38_BF */  0x4130,
/* 132a -  */  0,
/* 132b -  */  0,
/* 132c -  */  0,
/* 132d -  */  0,
/* 132e -  */  0,
/* 132f -  */  0,
/* 1330 -  */  0,
/* 1331 - _66_0F_38_DB */  0x24b7,
/* 1332 -  */  0,
/* 1333 -  */  0,
/* 1334 -  */  0,
/* 1335 - _V_66_0F_38_DB */  0x4131,
/* 1336 -  */  0,
/* 1337 -  */  0,
/* 1338 -  */  0,
/* 1339 -  */  0,
/* 133a -  */  0,
/* 133b -  */  0,
/* 133c -  */  0,
/* 133d - _66_0F_38_DC */  0x24b8,
/* 133e -  */  0,
/* 133f -  */  0,
/* 1340 -  */  0,
/* 1341 - _V_66_0F_38_DC */  0x4132,
/* 1342 -  */  0,
/* 1343 -  */  0,
/* 1344 -  */  0,
/* 1345 -  */  0,
/* 1346 -  */  0,
/* 1347 -  */  0,
/* 1348 -  */  0,
/* 1349 - _66_0F_38_DD */  0x24b9,
/* 134a -  */  0,
/* 134b -  */  0,
/* 134c -  */  0,
/* 134d - _V_66_0F_38_DD */  0x4133,
/* 134e -  */  0,
/* 134f -  */  0,
/* 1350 -  */  0,
/* 1351 -  */  0,
/* 1352 -  */  0,
/* 1353 -  */  0,
/* 1354 -  */  0,
/* 1355 - _66_0F_38_DE */  0x24ba,
/* 1356 -  */  0,
/* 1357 -  */  0,
/* 1358 -  */  0,
/* 1359 - _V_66_0F_38_DE */  0x4134,
/* 135a -  */  0,
/* 135b -  */  0,
/* 135c -  */  0,
/* 135d -  */  0,
/* 135e -  */  0,
/* 135f -  */  0,
/* 1360 -  */  0,
/* 1361 - _66_0F_38_DF */  0x24bb,
/* 1362 -  */  0,
/* 1363 -  */  0,
/* 1364 -  */  0,
/* 1365 - _V_66_0F_38_DF */  0x4135,
/* 1366 -  */  0,
/* 1367 -  */  0,
/* 1368 -  */  0,
/* 1369 -  */  0,
/* 136a -  */  0,
/* 136b -  */  0,
/* 136c - _0F_38_F0 */  0x24bc,
/* 136d -  */  0,
/* 136e -  */  0,
/* 136f - _F2_0F_38_F0 */  0x24bd,
/* 1370 -  */  0,
/* 1371 -  */  0,
/* 1372 -  */  0,
/* 1373 -  */  0,
/* 1374 -  */  0,
/* 1375 -  */  0,
/* 1376 -  */  0,
/* 1377 -  */  0,
/* 1378 - _0F_38_F1 */  0x24be,
/* 1379 -  */  0,
/* 137a -  */  0,
/* 137b - _F2_0F_38_F1 */  0x24bf,
/* 137c -  */  0,
/* 137d -  */  0,
/* 137e -  */  0,
/* 137f -  */  0,
/* 1380 -  */  0,
/* 1381 -  */  0,
/* 1382 -  */  0,
/* 1383 -  */  0,
/* 1384 -  */  0,
/* 1385 -  */  0,
/* 1386 -  */  0,
/* 1387 -  */  0,
/* 1388 -  */  0,
/* 1389 - _V_66_0F_3A_04 */  0x4136,
/* 138a -  */  0,
/* 138b -  */  0,
/* 138c -  */  0,
/* 138d -  */  0,
/* 138e -  */  0,
/* 138f -  */  0,
/* 1390 -  */  0,
/* 1391 -  */  0,
/* 1392 -  */  0,
/* 1393 -  */  0,
/* 1394 -  */  0,
/* 1395 - _V_66_0F_3A_05 */  0x4137,
/* 1396 -  */  0,
/* 1397 -  */  0,
/* 1398 -  */  0,
/* 1399 -  */  0,
/* 139a -  */  0,
/* 139b -  */  0,
/* 139c -  */  0,
/* 139d -  */  0,
/* 139e -  */  0,
/* 139f -  */  0,
/* 13a0 -  */  0,
/* 13a1 - _V_66_0F_3A_06 */  0x4138,
/* 13a2 -  */  0,
/* 13a3 -  */  0,
/* 13a4 -  */  0,
/* 13a5 -  */  0,
/* 13a6 -  */  0,
/* 13a7 -  */  0,
/* 13a8 -  */  0,
/* 13a9 - _66_0F_3A_08 */  0x4139,
/* 13aa -  */  0,
/* 13ab -  */  0,
/* 13ac -  */  0,
/* 13ad - _V_66_0F_3A_08 */  0x413a,
/* 13ae -  */  0,
/* 13af -  */  0,
/* 13b0 -  */  0,
/* 13b1 -  */  0,
/* 13b2 -  */  0,
/* 13b3 -  */  0,
/* 13b4 -  */  0,
/* 13b5 - _66_0F_3A_09 */  0x413b,
/* 13b6 -  */  0,
/* 13b7 -  */  0,
/* 13b8 -  */  0,
/* 13b9 - _V_66_0F_3A_09 */  0x413c,
/* 13ba -  */  0,
/* 13bb -  */  0,
/* 13bc -  */  0,
/* 13bd -  */  0,
/* 13be -  */  0,
/* 13bf -  */  0,
/* 13c0 -  */  0,
/* 13c1 - _66_0F_3A_0A */  0x413d,
/* 13c2 -  */  0,
/* 13c3 -  */  0,
/* 13c4 -  */  0,
/* 13c5 - _V_66_0F_3A_0A */  0x413e,
/* 13c6 -  */  0,
/* 13c7 -  */  0,
/* 13c8 -  */  0,
/* 13c9 -  */  0,
/* 13ca -  */  0,
/* 13cb -  */  0,
/* 13cc -  */  0,
/* 13cd - _66_0F_3A_0B */  0x413f,
/* 13ce -  */  0,
/* 13cf -  */  0,
/* 13d0 -  */  0,
/* 13d1 - _V_66_0F_3A_0B */  0x4140,
/* 13d2 -  */  0,
/* 13d3 -  */  0,
/* 13d4 -  */  0,
/* 13d5 -  */  0,
/* 13d6 -  */  0,
/* 13d7 -  */  0,
/* 13d8 -  */  0,
/* 13d9 - _66_0F_3A_0C */  0x4141,
/* 13da -  */  0,
/* 13db -  */  0,
/* 13dc -  */  0,
/* 13dd - _V_66_0F_3A_0C */  0x4142,
/* 13de -  */  0,
/* 13df -  */  0,
/* 13e0 -  */  0,
/* 13e1 -  */  0,
/* 13e2 -  */  0,
/* 13e3 -  */  0,
/* 13e4 -  */  0,
/* 13e5 - _66_0F_3A_0D */  0x4143,
/* 13e6 -  */  0,
/* 13e7 -  */  0,
/* 13e8 -  */  0,
/* 13e9 - _V_66_0F_3A_0D */  0x4144,
/* 13ea -  */  0,
/* 13eb -  */  0,
/* 13ec -  */  0,
/* 13ed -  */  0,
/* 13ee -  */  0,
/* 13ef -  */  0,
/* 13f0 -  */  0,
/* 13f1 - _66_0F_3A_0E */  0x4145,
/* 13f2 -  */  0,
/* 13f3 -  */  0,
/* 13f4 -  */  0,
/* 13f5 - _V_66_0F_3A_0E */  0x4146,
/* 13f6 -  */  0,
/* 13f7 -  */  0,
/* 13f8 -  */  0,
/* 13f9 -  */  0,
/* 13fa -  */  0,
/* 13fb -  */  0,
/* 13fc - _0F_3A_0F */  0x4147,
/* 13fd - _66_0F_3A_0F */  0x4148,
/* 13fe -  */  0,
/* 13ff -  */  0,
/* 1400 -  */  0,
/* 1401 - _V_66_0F_3A_0F */  0x4149,
/* 1402 -  */  0,
/* 1403 -  */  0,
/* 1404 -  */  0,
/* 1405 -  */  0,
/* 1406 -  */  0,
/* 1407 -  */  0,
/* 1408 -  */  0,
/* 1409 - _66_0F_3A_14 */  0x414a,
/* 140a -  */  0,
/* 140b -  */  0,
/* 140c -  */  0,
/* 140d - _V_66_0F_3A_14 */  0x414b,
/* 140e -  */  0,
/* 140f -  */  0,
/* 1410 -  */  0,
/* 1411 -  */  0,
/* 1412 -  */  0,
/* 1413 -  */  0,
/* 1414 -  */  0,
/* 1415 - _66_0F_3A_15 */  0x414c,
/* 1416 -  */  0,
/* 1417 -  */  0,
/* 1418 -  */  0,
/* 1419 - _V_66_0F_3A_15 */  0x414d,
/* 141a -  */  0,
/* 141b -  */  0,
/* 141c -  */  0,
/* 141d -  */  0,
/* 141e -  */  0,
/* 141f -  */  0,
/* 1420 -  */  0,
/* 1421 - _66_0F_3A_16 */  0x414e,
/* 1422 -  */  0,
/* 1423 -  */  0,
/* 1424 -  */  0,
/* 1425 - _V_66_0F_3A_16 */  0x414f,
/* 1426 -  */  0,
/* 1427 -  */  0,
/* 1428 -  */  0,
/* 1429 -  */  0,
/* 142a -  */  0,
/* 142b -  */  0,
/* 142c -  */  0,
/* 142d - _66_0F_3A_17 */  0x4150,
/* 142e -  */  0,
/* 142f -  */  0,
/* 1430 -  */  0,
/* 1431 - _V_66_0F_3A_17 */  0x4151,
/* 1432 -  */  0,
/* 1433 -  */  0,
/* 1434 -  */  0,
/* 1435 -  */  0,
/* 1436 -  */  0,
/* 1437 -  */  0,
/* 1438 -  */  0,
/* 1439 -  */  0,
/* 143a -  */  0,
/* 143b -  */  0,
/* 143c -  */  0,
/* 143d - _V_66_0F_3A_18 */  0x4152,
/* 143e -  */  0,
/* 143f -  */  0,
/* 1440 -  */  0,
/* 1441 -  */  0,
/* 1442 -  */  0,
/* 1443 -  */  0,
/* 1444 -  */  0,
/* 1445 -  */  0,
/* 1446 -  */  0,
/* 1447 -  */  0,
/* 1448 -  */  0,
/* 1449 - _V_66_0F_3A_19 */  0x4153,
/* 144a -  */  0,
/* 144b -  */  0,
/* 144c -  */  0,
/* 144d -  */  0,
/* 144e -  */  0,
/* 144f -  */  0,
/* 1450 -  */  0,
/* 1451 - _66_0F_3A_20 */  0x4154,
/* 1452 -  */  0,
/* 1453 -  */  0,
/* 1454 -  */  0,
/* 1455 - _V_66_0F_3A_20 */  0x4155,
/* 1456 -  */  0,
/* 1457 -  */  0,
/* 1458 -  */  0,
/* 1459 -  */  0,
/* 145a -  */  0,
/* 145b -  */  0,
/* 145c -  */  0,
/* 145d - _66_0F_3A_21 */  0x4156,
/* 145e -  */  0,
/* 145f -  */  0,
/* 1460 -  */  0,
/* 1461 - _V_66_0F_3A_21 */  0x4157,
/* 1462 -  */  0,
/* 1463 -  */  0,
/* 1464 -  */  0,
/* 1465 -  */  0,
/* 1466 -  */  0,
/* 1467 -  */  0,
/* 1468 -  */  0,
/* 1469 - _66_0F_3A_22 */  0x4158,
/* 146a -  */  0,
/* 146b -  */  0,
/* 146c -  */  0,
/* 146d - _V_66_0F_3A_22 */  0x4159,
/* 146e -  */  0,
/* 146f -  */  0,
/* 1470 -  */  0,
/* 1471 -  */  0,
/* 1472 -  */  0,
/* 1473 -  */  0,
/* 1474 -  */  0,
/* 1475 - _66_0F_3A_40 */  0x415a,
/* 1476 -  */  0,
/* 1477 -  */  0,
/* 1478 -  */  0,
/* 1479 - _V_66_0F_3A_40 */  0x415b,
/* 147a -  */  0,
/* 147b -  */  0,
/* 147c -  */  0,
/* 147d -  */  0,
/* 147e -  */  0,
/* 147f -  */  0,
/* 1480 -  */  0,
/* 1481 - _66_0F_3A_41 */  0x415c,
/* 1482 -  */  0,
/* 1483 -  */  0,
/* 1484 -  */  0,
/* 1485 - _V_66_0F_3A_41 */  0x415d,
/* 1486 -  */  0,
/* 1487 -  */  0,
/* 1488 -  */  0,
/* 1489 -  */  0,
/* 148a -  */  0,
/* 148b -  */  0,
/* 148c -  */  0,
/* 148d - _66_0F_3A_42 */  0x415e,
/* 148e -  */  0,
/* 148f -  */  0,
/* 1490 -  */  0,
/* 1491 - _V_66_0F_3A_42 */  0x415f,
/* 1492 -  */  0,
/* 1493 -  */  0,
/* 1494 -  */  0,
/* 1495 -  */  0,
/* 1496 -  */  0,
/* 1497 -  */  0,
/* 1498 -  */  0,
/* 1499 - _66_0F_3A_44 */  0x4160,
/* 149a -  */  0,
/* 149b -  */  0,
/* 149c -  */  0,
/* 149d - _V_66_0F_3A_44 */  0x4161,
/* 149e -  */  0,
/* 149f -  */  0,
/* 14a0 -  */  0,
/* 14a1 -  */  0,
/* 14a2 -  */  0,
/* 14a3 -  */  0,
/* 14a4 -  */  0,
/* 14a5 -  */  0,
/* 14a6 -  */  0,
/* 14a7 -  */  0,
/* 14a8 -  */  0,
/* 14a9 - _V_66_0F_3A_4A */  0x4162,
/* 14aa -  */  0,
/* 14ab -  */  0,
/* 14ac -  */  0,
/* 14ad -  */  0,
/* 14ae -  */  0,
/* 14af -  */  0,
/* 14b0 -  */  0,
/* 14b1 -  */  0,
/* 14b2 -  */  0,
/* 14b3 -  */  0,
/* 14b4 -  */  0,
/* 14b5 - _V_66_0F_3A_4B */  0x4163,
/* 14b6 -  */  0,
/* 14b7 -  */  0,
/* 14b8 -  */  0,
/* 14b9 -  */  0,
/* 14ba -  */  0,
/* 14bb -  */  0,
/* 14bc -  */  0,
/* 14bd -  */  0,
/* 14be -  */  0,
/* 14bf -  */  0,
/* 14c0 -  */  0,
/* 14c1 - _V_66_0F_3A_4C */  0x4164,
/* 14c2 -  */  0,
/* 14c3 -  */  0,
/* 14c4 -  */  0,
/* 14c5 -  */  0,
/* 14c6 -  */  0,
/* 14c7 -  */  0,
/* 14c8 -  */  0,
/* 14c9 - _66_0F_3A_60 */  0x4165,
/* 14ca -  */  0,
/* 14cb -  */  0,
/* 14cc -  */  0,
/* 14cd - _V_66_0F_3A_60 */  0x4166,
/* 14ce -  */  0,
/* 14cf -  */  0,
/* 14d0 -  */  0,
/* 14d1 -  */  0,
/* 14d2 -  */  0,
/* 14d3 -  */  0,
/* 14d4 -  */  0,
/* 14d5 - _66_0F_3A_61 */  0x4167,
/* 14d6 -  */  0,
/* 14d7 -  */  0,
/* 14d8 -  */  0,
/* 14d9 - _V_66_0F_3A_61 */  0x4168,
/* 14da -  */  0,
/* 14db -  */  0,
/* 14dc -  */  0,
/* 14dd -  */  0,
/* 14de -  */  0,
/* 14df -  */  0,
/* 14e0 -  */  0,
/* 14e1 - _66_0F_3A_62 */  0x4169,
/* 14e2 -  */  0,
/* 14e3 -  */  0,
/* 14e4 -  */  0,
/* 14e5 - _V_66_0F_3A_62 */  0x416a,
/* 14e6 -  */  0,
/* 14e7 -  */  0,
/* 14e8 -  */  0,
/* 14e9 -  */  0,
/* 14ea -  */  0,
/* 14eb -  */  0,
/* 14ec -  */  0,
/* 14ed - _66_0F_3A_63 */  0x416b,
/* 14ee -  */  0,
/* 14ef -  */  0,
/* 14f0 -  */  0,
/* 14f1 - _V_66_0F_3A_63 */  0x416c,
/* 14f2 -  */  0,
/* 14f3 -  */  0,
/* 14f4 -  */  0,
/* 14f5 -  */  0,
/* 14f6 -  */  0,
/* 14f7 -  */  0,
/* 14f8 -  */  0,
/* 14f9 - _66_0F_3A_DF */  0x416d,
/* 14fa -  */  0,
/* 14fb -  */  0,
/* 14fc -  */  0,
/* 14fd - _V_66_0F_3A_DF */  0x416e,
/* 14fe -  */  0,
/* 14ff -  */  0,
/* 1500 -  */  0,
/* 1501 -  */  0,
/* 1502 -  */  0,
/* 1503 -  */  0,
/* 1504 - _0F_71_02 */  0x24c0,
/* 1505 - _66_0F_71_02 */  0x24c1,
/* 1506 -  */  0,
/* 1507 -  */  0,
/* 1508 -  */  0,
/* 1509 - _V_66_0F_71_02 */  0x416f,
/* 150a -  */  0,
/* 150b -  */  0,
/* 150c -  */  0,
/* 150d -  */  0,
/* 150e -  */  0,
/* 150f -  */  0,
/* 1510 - _0F_71_04 */  0x24c2,
/* 1511 - _66_0F_71_04 */  0x24c3,
/* 1512 -  */  0,
/* 1513 -  */  0,
/* 1514 -  */  0,
/* 1515 - _V_66_0F_71_04 */  0x4170,
/* 1516 -  */  0,
/* 1517 -  */  0,
/* 1518 -  */  0,
/* 1519 -  */  0,
/* 151a -  */  0,
/* 151b -  */  0,
/* 151c - _0F_71_06 */  0x24c4,
/* 151d - _66_0F_71_06 */  0x24c5,
/* 151e -  */  0,
/* 151f -  */  0,
/* 1520 -  */  0,
/* 1521 - _V_66_0F_71_06 */  0x4171,
/* 1522 -  */  0,
/* 1523 -  */  0,
/* 1524 -  */  0,
/* 1525 -  */  0,
/* 1526 -  */  0,
/* 1527 -  */  0,
/* 1528 - _0F_72_02 */  0x24c6,
/* 1529 - _66_0F_72_02 */  0x24c7,
/* 152a -  */  0,
/* 152b -  */  0,
/* 152c -  */  0,
/* 152d - _V_66_0F_72_02 */  0x4172,
/* 152e -  */  0,
/* 152f -  */  0,
/* 1530 -  */  0,
/* 1531 -  */  0,
/* 1532 -  */  0,
/* 1533 -  */  0,
/* 1534 - _0F_72_04 */  0x24c8,
/* 1535 - _66_0F_72_04 */  0x24c9,
/* 1536 -  */  0,
/* 1537 -  */  0,
/* 1538 -  */  0,
/* 1539 - _V_66_0F_72_04 */  0x4173,
/* 153a -  */  0,
/* 153b -  */  0,
/* 153c -  */  0,
/* 153d -  */  0,
/* 153e -  */  0,
/* 153f -  */  0,
/* 1540 - _0F_72_06 */  0x24ca,
/* 1541 - _66_0F_72_06 */  0x24cb,
/* 1542 -  */  0,
/* 1543 -  */  0,
/* 1544 -  */  0,
/* 1545 - _V_66_0F_72_06 */  0x4174,
/* 1546 -  */  0,
/* 1547 -  */  0,
/* 1548 -  */  0,
/* 1549 -  */  0,
/* 154a -  */  0,
/* 154b -  */  0,
/* 154c - _0F_73_02 */  0x24cc,
/* 154d - _66_0F_73_02 */  0x24cd,
/* 154e -  */  0,
/* 154f -  */  0,
/* 1550 -  */  0,
/* 1551 - _V_66_0F_73_02 */  0x4175,
/* 1552 -  */  0,
/* 1553 -  */  0,
/* 1554 -  */  0,
/* 1555 -  */  0,
/* 1556 -  */  0,
/* 1557 -  */  0,
/* 1558 -  */  0,
/* 1559 - _66_0F_73_03 */  0x24ce,
/* 155a -  */  0,
/* 155b -  */  0,
/* 155c -  */  0,
/* 155d - _V_66_0F_73_03 */  0x4176,
/* 155e -  */  0,
/* 155f -  */  0,
/* 1560 -  */  0,
/* 1561 -  */  0,
/* 1562 -  */  0,
/* 1563 -  */  0,
/* 1564 - _0F_73_06 */  0x24cf,
/* 1565 - _66_0F_73_06 */  0x24d0,
/* 1566 -  */  0,
/* 1567 -  */  0,
/* 1568 -  */  0,
/* 1569 - _V_66_0F_73_06 */  0x4177,
/* 156a -  */  0,
/* 156b -  */  0,
/* 156c -  */  0,
/* 156d -  */  0,
/* 156e -  */  0,
/* 156f -  */  0,
/* 1570 -  */  0,
/* 1571 - _66_0F_73_07 */  0x24d1,
/* 1572 -  */  0,
/* 1573 -  */  0,
/* 1574 -  */  0,
/* 1575 - _V_66_0F_73_07 */  0x4178,
/* 1576 -  */  0,
/* 1577 -  */  0,
/* 1578 -  */  0,
/* 1579 -  */  0,
/* 157a -  */  0,
/* 157b -  */  0,
/* 157c - _0F_AE_00 */  0x4179,
/* 157d -  */  0,
/* 157e - _F3_0F_AE_00 */  0x24d2,
/* 157f -  */  0,
/* 1580 -  */  0,
/* 1581 -  */  0,
/* 1582 -  */  0,
/* 1583 -  */  0,
/* 1584 -  */  0,
/* 1585 -  */  0,
/* 1586 -  */  0,
/* 1587 -  */  0,
/* 1588 - _0F_AE_01 */  0x417a,
/* 1589 -  */  0,
/* 158a - _F3_0F_AE_01 */  0x24d3,
/* 158b -  */  0,
/* 158c -  */  0,
/* 158d -  */  0,
/* 158e -  */  0,
/* 158f -  */  0,
/* 1590 -  */  0,
/* 1591 -  */  0,
/* 1592 -  */  0,
/* 1593 -  */  0,
/* 1594 - _0F_AE_02 */  0x24d4,
/* 1595 -  */  0,
/* 1596 - _F3_0F_AE_02 */  0x24d5,
/* 1597 -  */  0,
/* 1598 - _V_0F_AE_02 */  0x417b,
/* 1599 -  */  0,
/* 159a -  */  0,
/* 159b -  */  0,
/* 159c -  */  0,
/* 159d -  */  0,
/* 159e -  */  0,
/* 159f -  */  0,
/* 15a0 - _0F_AE_03 */  0x24d6,
/* 15a1 -  */  0,
/* 15a2 - _F3_0F_AE_03 */  0x24d7,
/* 15a3 -  */  0,
/* 15a4 - _V_0F_AE_03 */  0x417c,
/* 15a5 -  */  0,
/* 15a6 -  */  0,
/* 15a7 -  */  0,
/* 15a8 -  */  0,
/* 15a9 -  */  0,
/* 15aa -  */  0,
/* 15ab -  */  0,
/* 15ac - _0F_C7_06 */  0x24d8,
/* 15ad - _66_0F_C7_06 */  0x24d9,
/* 15ae - _F3_0F_C7_06 */  0x24da,
/* 15af -  */  0,
/* 15b0 -  */  0,
/* 15b1 -  */  0,
/* 15b2 -  */  0,
/* 15b3 -  */  0,
/* 15b4 -  */  0,
/* 15b5 -  */  0,
/* 15b6 -  */  0,
/* 15b7 -  */  0
};

_InstSharedInfo InstSharedInfoTable[467] = {
{0, 9, 15, 8, 245, 0, 0},
{0, 11, 17, 8, 245, 0, 0},
{0, 15, 9, 8, 245, 0, 0},
{0, 17, 11, 8, 245, 0, 0},
{1, 1, 33, 8, 245, 0, 0},
{1, 3, 35, 8, 245, 0, 0},
{2, 0, 32, 8, 0, 0, 0},
{3, 0, 32, 8, 0, 0, 0},
{0, 9, 15, 8, 196, 16, 0},
{0, 11, 17, 8, 196, 16, 0},
{0, 15, 9, 8, 196, 16, 0},
{0, 17, 11, 8, 196, 16, 0},
{1, 1, 33, 8, 196, 16, 0},
{1, 3, 35, 8, 196, 16, 0},
{4, 0, 32, 8, 0, 0, 0},
{0, 9, 15, 8, 245, 1, 0},
{0, 11, 17, 8, 245, 1, 0},
{0, 15, 9, 8, 245, 1, 0},
{0, 17, 11, 8, 245, 1, 0},
{1, 1, 33, 8, 245, 1, 0},
{1, 3, 35, 8, 245, 1, 0},
{5, 0, 32, 8, 0, 0, 0},
{6, 0, 32, 8, 0, 0, 0},
{7, 0, 32, 8, 0, 0, 0},
{8, 0, 32, 8, 0, 0, 0},
{0, 9, 15, 8, 229, 0, 16},
{0, 11, 17, 8, 229, 0, 16},
{0, 15, 9, 8, 229, 0, 16},
{0, 17, 11, 8, 229, 0, 16},
{1, 1, 33, 8, 229, 0, 16},
{1, 3, 35, 8, 229, 0, 16},
{9, 0, 0, 8, 213, 17, 32},
{0, 9, 15, 8, 196, 0, 16},
{0, 11, 17, 8, 196, 0, 16},
{0, 15, 9, 8, 196, 0, 16},
{0, 17, 11, 8, 196, 0, 16},
{1, 1, 33, 8, 196, 0, 16},
{1, 3, 35, 8, 196, 0, 16},
{9, 0, 0, 8, 17, 16, 228},
{10, 9, 15, 8, 245, 0, 0},
{10, 11, 17, 8, 245, 0, 0},
{10, 15, 9, 8, 245, 0, 0},
{10, 17, 11, 8, 245, 0, 0},
{11, 1, 33, 8, 245, 0, 0},
{11, 3, 35, 8, 245, 0, 0},
{12, 0, 54, 8, 244, 0, 0},
{13, 0, 54, 8, 0, 0, 0},
{14, 0, 54, 8, 0, 0, 0},
{15, 0, 0, 8, 0, 0, 0},
{16, 42, 11, 8, 0, 0, 0},
{10, 10, 16, 8, 64, 0, 0},
{13, 0, 3, 8, 0, 0, 0},
{17, 17, 11, 8, 33, 0, 212},
{18, 0, 5, 8, 0, 0, 0},
{19, 59, 56, 8, 0, 8, 0},
{20, 59, 56, 8, 0, 8, 0},
{19, 55, 59, 8, 0, 8, 0},
{20, 55, 59, 8, 0, 8, 0},
{13, 0, 40, 13, 0, 32, 0},
{13, 0, 40, 13, 0, 1, 0},
{13, 0, 40, 13, 0, 64, 0},
{13, 0, 40, 13, 0, 65, 0},
{13, 0, 40, 13, 0, 128, 0},
{13, 0, 40, 13, 0, 4, 0},
{13, 0, 40, 13, 0, 160, 0},
{13, 0, 40, 13, 0, 224, 0},
{10, 9, 15, 8, 196, 0, 16},
{10, 11, 17, 8, 196, 0, 16},
{0, 9, 15, 8, 0, 0, 0},
{0, 11, 17, 8, 0, 0, 0},
{21, 9, 15, 8, 0, 0, 0},
{21, 11, 17, 8, 0, 0, 0},
{21, 15, 9, 8, 0, 0, 0},
{21, 17, 11, 8, 0, 0, 0},
{21, 31, 28, 8, 0, 0, 0},
{21, 42, 11, 8, 0, 0, 0},
{21, 28, 31, 8, 0, 0, 0},
{1, 35, 54, 8, 0, 0, 0},
{22, 0, 0, 8, 0, 0, 0},
{9, 0, 38, 9, 0, 0, 0},
{23, 0, 0, 8, 0, 0, 0},
{23, 0, 0, 8, 255, 0, 0},
{11, 0, 0, 8, 213, 0, 0},
{11, 0, 0, 8, 0, 0, 0},
{1, 49, 33, 8, 0, 0, 0},
{1, 50, 35, 8, 0, 0, 0},
{1, 33, 49, 8, 0, 0, 0},
{1, 35, 50, 8, 0, 0, 0},
{24, 55, 56, 8, 0, 8, 0},
{25, 55, 56, 8, 0, 8, 0},
{19, 56, 55, 8, 245, 8, 0},
{26, 56, 55, 8, 245, 8, 0},
{11, 1, 33, 8, 196, 0, 16},
{11, 3, 35, 8, 196, 0, 16},
{19, 33, 56, 8, 0, 8, 0},
{26, 35, 56, 8, 0, 8, 0},
{19, 55, 33, 8, 0, 8, 0},
{26, 55, 35, 8, 0, 8, 0},
{19, 33, 56, 8, 245, 8, 0},
{26, 35, 56, 8, 245, 8, 0},
{1, 1, 53, 8, 0, 0, 0},
{27, 3, 54, 8, 0, 0, 0},
{13, 0, 2, 10, 0, 0, 0},
{13, 0, 0, 10, 0, 0, 0},
{16, 37, 11, 8, 0, 0, 0},
{13, 8, 6, 8, 0, 0, 0},
{13, 0, 0, 8, 0, 0, 0},
{28, 0, 2, 10, 0, 0, 0},
{28, 0, 0, 10, 0, 0, 0},
{11, 0, 0, 14, 0, 0, 0},
{11, 0, 1, 14, 0, 0, 0},
{9, 0, 0, 14, 0, 0, 0},
{28, 0, 0, 10, 255, 0, 0},
{9, 0, 1, 8, 196, 0, 49},
{9, 0, 0, 8, 0, 0, 0},
{29, 0, 57, 8, 0, 0, 0},
{30, 0, 40, 13, 0, 64, 0},
{30, 0, 40, 13, 0, 0, 0},
{31, 0, 40, 13, 0, 0, 0},
{1, 1, 33, 8, 0, 0, 0},
{1, 1, 36, 8, 0, 0, 0},
{11, 33, 1, 8, 0, 0, 0},
{11, 36, 1, 8, 0, 0, 0},
{13, 0, 41, 9, 0, 0, 0},
{13, 0, 41, 12, 0, 0, 0},
{9, 0, 38, 12, 0, 0, 0},
{13, 0, 40, 12, 0, 0, 0},
{1, 59, 33, 8, 0, 0, 0},
{1, 59, 36, 8, 0, 0, 0},
{11, 33, 59, 8, 0, 0, 0},
{11, 36, 59, 8, 0, 0, 0},
{11, 0, 0, 8, 1, 0, 0},
{11, 0, 0, 8, 2, 0, 0},
{11, 0, 0, 8, 8, 0, 0},
{10, 16, 11, 8, 64, 0, 0},
{32, 0, 0, 27, 0, 0, 0},
{32, 0, 0, 8, 0, 0, 0},
{32, 0, 0, 14, 0, 0, 0},
{11, 0, 0, 96, 0, 0, 0},
{10, 0, 17, 8, 0, 0, 0},
{33, 29, 14, 8, 0, 0, 0},
{33, 30, 14, 8, 0, 0, 0},
{33, 14, 29, 8, 0, 0, 0},
{33, 14, 30, 8, 0, 0, 0},
{34, 0, 0, 8, 0, 0, 0},
{35, 17, 11, 31, 0, 32, 0},
{35, 17, 11, 31, 0, 1, 0},
{35, 17, 11, 31, 0, 64, 0},
{35, 17, 11, 31, 0, 65, 0},
{35, 17, 11, 31, 0, 128, 0},
{35, 17, 11, 31, 0, 4, 0},
{35, 17, 11, 31, 0, 160, 0},
{35, 17, 11, 31, 0, 224, 0},
{32, 0, 41, 13, 0, 32, 0},
{32, 0, 41, 13, 0, 1, 0},
{32, 0, 41, 13, 0, 64, 0},
{32, 0, 41, 13, 0, 65, 0},
{32, 0, 41, 13, 0, 128, 0},
{32, 0, 41, 13, 0, 4, 0},
{32, 0, 41, 13, 0, 160, 0},
{32, 0, 41, 13, 0, 224, 0},
{35, 0, 15, 8, 0, 32, 0},
{35, 0, 15, 8, 0, 1, 0},
{35, 0, 15, 8, 0, 64, 0},
{35, 0, 15, 8, 0, 65, 0},
{35, 0, 15, 8, 0, 128, 0},
{35, 0, 15, 8, 0, 4, 0},
{35, 0, 15, 8, 0, 160, 0},
{35, 0, 15, 8, 0, 224, 0},
{36, 0, 32, 8, 0, 0, 0},
{37, 0, 32, 8, 0, 0, 0},
{35, 11, 17, 8, 1, 0, 244},
{38, 11, 17, 8, 197, 0, 48},
{39, 0, 32, 8, 0, 0, 0},
{40, 0, 32, 8, 0, 0, 0},
{32, 0, 0, 8, 255, 0, 0},
{41, 11, 17, 8, 1, 0, 244},
{35, 17, 11, 8, 33, 0, 212},
{41, 9, 15, 8, 245, 0, 0},
{41, 11, 17, 8, 245, 0, 0},
{42, 37, 11, 8, 0, 0, 0},
{35, 15, 11, 8, 0, 0, 0},
{43, 16, 11, 8, 0, 0, 0},
{43, 13, 45, 48, 0, 0, 0},
{44, 0, 54, 8, 0, 0, 0},
{45, 1, 15, 8, 245, 0, 0},
{45, 1, 15, 8, 196, 16, 0},
{45, 1, 15, 8, 245, 1, 0},
{45, 1, 15, 8, 229, 0, 16},
{45, 1, 15, 8, 196, 0, 16},
{46, 1, 15, 8, 245, 0, 0},
{45, 3, 17, 8, 245, 0, 0},
{45, 3, 17, 8, 196, 16, 0},
{45, 3, 17, 8, 245, 1, 0},
{45, 3, 17, 8, 229, 0, 16},
{45, 3, 17, 8, 196, 0, 16},
{46, 3, 17, 8, 245, 0, 0},
{47, 1, 15, 8, 245, 0, 0},
{47, 1, 15, 8, 196, 16, 0},
{47, 1, 15, 8, 245, 1, 0},
{47, 1, 15, 8, 229, 0, 16},
{47, 1, 15, 8, 196, 0, 16},
{48, 1, 15, 8, 245, 0, 0},
{45, 5, 17, 8, 245, 0, 0},
{49, 5, 17, 8, 196, 16, 0},
{45, 5, 17, 8, 245, 1, 0},
{49, 5, 17, 8, 229, 0, 16},
{49, 5, 17, 8, 196, 0, 16},
{46, 5, 17, 8, 245, 0, 0},
{50, 0, 17, 8, 0, 0, 0},
{51, 1, 15, 8, 1, 0, 32},
{51, 1, 15, 8, 1, 1, 32},
{51, 1, 15, 8, 197, 0, 48},
{51, 1, 17, 8, 1, 0, 32},
{51, 1, 17, 8, 1, 1, 32},
{51, 1, 17, 8, 197, 0, 48},
{51, 1, 15, 8, 0, 0, 0},
{51, 3, 17, 8, 0, 0, 0},
{51, 51, 15, 8, 33, 0, 0},
{51, 51, 15, 8, 33, 1, 0},
{51, 51, 15, 8, 229, 0, 16},
{51, 51, 17, 8, 33, 0, 0},
{51, 51, 17, 8, 33, 1, 0},
{51, 51, 17, 8, 229, 0, 16},
{51, 52, 15, 8, 1, 0, 32},
{51, 52, 15, 8, 1, 1, 32},
{51, 52, 15, 8, 197, 0, 48},
{51, 52, 17, 8, 1, 0, 32},
{51, 52, 17, 8, 1, 1, 32},
{51, 52, 17, 8, 197, 0, 48},
{46, 0, 21, 16, 0, 0, 0},
{52, 0, 62, 16, 0, 0, 0},
{52, 0, 61, 16, 0, 0, 0},
{52, 0, 0, 16, 0, 0, 0},
{51, 0, 21, 16, 0, 0, 0},
{46, 0, 42, 16, 0, 0, 0},
{46, 0, 20, 16, 0, 0, 0},
{53, 0, 62, 24, 0, 1, 0},
{53, 0, 62, 24, 0, 64, 0},
{53, 0, 62, 24, 0, 65, 0},
{53, 0, 62, 24, 0, 4, 0},
{54, 0, 21, 56, 0, 0, 0},
{46, 0, 23, 16, 0, 0, 0},
{51, 0, 23, 16, 0, 0, 0},
{53, 0, 62, 16, 69, 0, 0},
{53, 0, 62, 24, 69, 0, 0},
{46, 0, 22, 16, 0, 0, 0},
{52, 0, 63, 16, 0, 0, 0},
{54, 0, 22, 56, 0, 0, 0},
{51, 0, 22, 16, 0, 0, 0},
{54, 0, 20, 56, 0, 0, 0},
{51, 0, 20, 16, 0, 0, 0},
{46, 1, 15, 8, 196, 0, 16},
{45, 0, 15, 8, 0, 0, 0},
{45, 0, 15, 8, 245, 0, 0},
{51, 0, 15, 8, 33, 0, 212},
{51, 0, 15, 8, 0, 0, 245},
{46, 3, 17, 8, 196, 0, 16},
{45, 0, 17, 8, 0, 0, 0},
{45, 0, 17, 8, 245, 0, 0},
{51, 0, 17, 8, 33, 0, 212},
{51, 0, 17, 8, 0, 0, 245},
{45, 0, 15, 8, 244, 0, 0},
{45, 0, 17, 8, 244, 0, 0},
{55, 0, 17, 9, 0, 0, 0},
{56, 0, 37, 9, 0, 0, 0},
{55, 0, 17, 12, 0, 0, 0},
{56, 0, 37, 12, 0, 0, 0},
{55, 0, 17, 8, 0, 0, 0},
{46, 0, 17, 8, 0, 0, 0},
{46, 0, 16, 8, 0, 0, 0},
{54, 0, 16, 8, 0, 0, 0},
{46, 0, 16, 8, 64, 0, 0},
{55, 0, 39, 8, 0, 0, 0},
{57, 0, 28, 8, 0, 0, 0},
{58, 0, 16, 8, 0, 0, 0},
{54, 0, 42, 8, 0, 0, 0},
{53, 0, 0, 112, 0, 0, 0},
{53, 0, 0, 8, 0, 0, 0},
{54, 0, 58, 120, 0, 0, 0},
{53, 0, 0, 120, 0, 0, 0},
{53, 0, 58, 120, 0, 0, 0},
{53, 60, 58, 120, 0, 0, 0},
{59, 0, 0, 8, 0, 0, 0},
{54, 0, 42, 96, 0, 0, 0},
{60, 67, 64, 104, 0, 0, 0},
{60, 67, 64, 96, 0, 0, 0},
{35, 73, 68, 40, 0, 0, 0},
{35, 73, 68, 48, 0, 0, 0},
{35, 71, 68, 40, 0, 0, 0},
{35, 72, 68, 48, 0, 0, 0},
{61, 90, 83, 128, 0, 0, 0},
{62, 81, 68, 128, 0, 0, 0},
{63, 44, 68, 128, 0, 0, 0},
{63, 46, 68, 128, 0, 0, 0},
{35, 68, 73, 40, 0, 0, 0},
{35, 68, 73, 48, 0, 0, 0},
{35, 68, 71, 40, 0, 0, 0},
{35, 68, 72, 48, 0, 0, 0},
{61, 83, 90, 128, 0, 0, 0},
{63, 68, 44, 128, 0, 0, 0},
{63, 68, 46, 128, 0, 0, 0},
{64, 72, 68, 40, 0, 0, 0},
{35, 46, 68, 48, 0, 0, 0},
{35, 72, 68, 56, 0, 0, 0},
{65, 81, 68, 128, 0, 0, 0},
{66, 81, 68, 128, 0, 0, 0},
{61, 89, 83, 128, 0, 0, 0},
{35, 68, 46, 40, 0, 0, 0},
{35, 68, 46, 48, 0, 0, 0},
{61, 68, 46, 128, 0, 0, 0},
{34, 73, 68, 40, 0, 0, 0},
{34, 73, 68, 48, 0, 0, 0},
{66, 88, 83, 128, 0, 0, 0},
{35, 73, 68, 56, 0, 0, 0},
{54, 0, 42, 40, 0, 0, 0},
{34, 67, 68, 40, 0, 0, 0},
{34, 67, 68, 48, 0, 0, 0},
{42, 18, 68, 40, 0, 0, 0},
{42, 18, 68, 48, 0, 0, 0},
{35, 68, 47, 40, 0, 0, 0},
{35, 68, 47, 48, 0, 0, 0},
{35, 68, 44, 88, 0, 0, 0},
{35, 68, 46, 88, 0, 0, 0},
{61, 83, 92, 128, 0, 0, 0},
{34, 72, 64, 40, 0, 0, 0},
{34, 73, 64, 48, 0, 0, 0},
{42, 71, 13, 40, 0, 0, 0},
{42, 72, 13, 48, 0, 0, 0},
{61, 80, 78, 128, 0, 0, 0},
{34, 71, 68, 40, 69, 0, 0},
{34, 72, 68, 48, 0, 0, 0},
{61, 71, 68, 128, 0, 0, 0},
{61, 72, 68, 128, 0, 0, 0},
{67, 69, 12, 40, 0, 0, 0},
{67, 69, 12, 48, 0, 0, 0},
{68, 83, 13, 128, 0, 0, 0},
{34, 71, 68, 40, 0, 0, 0},
{34, 71, 68, 48, 0, 0, 0},
{61, 91, 83, 128, 0, 0, 0},
{61, 90, 68, 128, 0, 0, 0},
{34, 66, 64, 32, 0, 0, 0},
{34, 67, 64, 32, 0, 0, 0},
{69, 18, 64, 32, 0, 0, 0},
{69, 18, 68, 48, 0, 0, 0},
{61, 79, 68, 128, 0, 0, 0},
{35, 67, 64, 32, 0, 0, 0},
{70, 67, 64, 40, 0, 0, 0},
{70, 73, 68, 48, 0, 0, 0},
{66, 73, 68, 128, 0, 0, 0},
{32, 0, 0, 32, 0, 0, 0},
{71, 0, 0, 128, 0, 0, 0},
{72, 13, 18, 112, 0, 0, 0},
{73, 7, 69, 88, 0, 0, 0},
{74, 69, 68, 88, 0, 0, 0},
{72, 18, 13, 112, 0, 0, 0},
{34, 69, 68, 88, 0, 0, 0},
{75, 69, 68, 88, 0, 0, 0},
{32, 72, 68, 112, 0, 0, 0},
{32, 68, 72, 112, 0, 0, 0},
{34, 73, 68, 56, 0, 0, 0},
{69, 64, 18, 32, 0, 0, 0},
{69, 68, 18, 48, 0, 0, 0},
{61, 68, 79, 128, 0, 0, 0},
{35, 64, 67, 32, 0, 0, 0},
{76, 0, 42, 8, 0, 0, 0},
{77, 0, 43, 8, 0, 0, 0},
{78, 0, 43, 8, 0, 0, 0},
{79, 17, 11, 80, 64, 0, 0},
{80, 1, 17, 8, 1, 0, 244},
{49, 1, 17, 8, 1, 0, 244},
{34, 17, 11, 8, 64, 0, 245},
{81, 17, 11, 112, 0, 0, 0},
{82, 17, 11, 8, 65, 0, 180},
{83, 73, 68, 40, 0, 0, 0},
{83, 73, 68, 48, 0, 0, 0},
{83, 71, 68, 40, 0, 0, 0},
{83, 72, 68, 48, 0, 0, 0},
{84, 88, 83, 128, 0, 0, 0},
{84, 81, 68, 128, 0, 0, 0},
{70, 25, 64, 40, 0, 0, 0},
{70, 25, 68, 48, 0, 0, 0},
{85, 81, 68, 128, 0, 0, 0},
{86, 65, 12, 40, 0, 0, 0},
{70, 69, 12, 48, 0, 0, 0},
{87, 68, 13, 128, 0, 0, 0},
{70, 73, 68, 40, 0, 0, 0},
{85, 88, 83, 128, 0, 0, 0},
{88, 0, 48, 8, 64, 0, 0},
{54, 0, 46, 112, 0, 0, 0},
{67, 65, 68, 48, 0, 0, 0},
{67, 69, 64, 48, 0, 0, 0},
{61, 68, 72, 128, 0, 0, 0},
{75, 65, 12, 40, 0, 0, 0},
{75, 69, 12, 48, 0, 0, 0},
{68, 68, 13, 128, 0, 0, 0},
{34, 67, 64, 40, 0, 0, 0},
{35, 64, 46, 40, 0, 0, 0},
{34, 42, 68, 56, 0, 0, 0},
{61, 92, 83, 128, 0, 0, 0},
{34, 67, 64, 48, 0, 0, 0},
{75, 65, 64, 40, 0, 0, 0},
{75, 69, 68, 48, 0, 0, 0},
{89, 69, 68, 128, 0, 0, 0},
{51, 0, 42, 16, 0, 0, 0},
{90, 0, 42, 16, 0, 0, 0},
{90, 0, 20, 16, 0, 0, 0},
{91, 0, 0, 16, 0, 0, 0},
{92, 0, 34, 16, 0, 0, 0},
{93, 0, 34, 16, 0, 0, 0},
{34, 67, 64, 64, 0, 0, 0},
{34, 73, 68, 64, 0, 0, 0},
{70, 73, 68, 72, 0, 0, 0},
{34, 73, 68, 80, 0, 0, 0},
{61, 44, 83, 128, 0, 0, 0},
{61, 46, 85, 128, 0, 0, 0},
{61, 47, 85, 128, 0, 0, 0},
{61, 73, 68, 128, 0, 0, 0},
{34, 72, 68, 72, 0, 0, 0},
{34, 71, 68, 72, 0, 0, 0},
{34, 70, 68, 72, 0, 0, 0},
{61, 70, 68, 128, 0, 0, 0},
{34, 73, 68, 72, 0, 0, 0},
{35, 47, 68, 72, 0, 0, 0},
{61, 47, 68, 128, 0, 0, 0},
{66, 88, 92, 128, 0, 0, 0},
{72, 47, 13, 112, 0, 0, 0},
{66, 88, 83, 136, 0, 0, 0},
{66, 81, 68, 136, 0, 0, 0},
{34, 73, 68, 152, 0, 0, 0},
{61, 73, 68, 152, 0, 0, 0},
{66, 81, 68, 152, 0, 0, 0},
{35, 17, 11, 8, 0, 0, 0},
{35, 15, 13, 80, 0, 0, 0},
{35, 11, 17, 8, 0, 0, 0},
{35, 17, 13, 80, 0, 0, 0},
{66, 90, 83, 128, 0, 0, 0},
{85, 87, 85, 128, 0, 0, 0},
{70, 71, 68, 72, 0, 0, 0},
{70, 72, 68, 72, 0, 0, 0},
{70, 67, 64, 64, 0, 0, 0},
{70, 73, 68, 64, 0, 0, 0},
{70, 68, 26, 72, 0, 0, 0},
{87, 68, 76, 128, 0, 0, 0},
{70, 68, 27, 72, 0, 0, 0},
{87, 68, 77, 128, 0, 0, 0},
{94, 68, 18, 72, 0, 0, 0},
{66, 68, 79, 128, 0, 0, 0},
{70, 68, 18, 72, 0, 0, 0},
{66, 68, 75, 128, 0, 0, 0},
{66, 85, 73, 128, 0, 0, 0},
{70, 24, 68, 72, 0, 0, 0},
{94, 18, 68, 72, 0, 0, 0},
{70, 73, 68, 144, 0, 0, 0},
{85, 81, 68, 144, 0, 0, 0},
{70, 73, 68, 80, 0, 0, 0},
{70, 73, 68, 152, 0, 0, 0},
{66, 73, 68, 152, 0, 0, 0},
{95, 1, 65, 32, 0, 0, 0},
{54, 1, 69, 48, 0, 0, 0},
{96, 69, 81, 128, 0, 0, 0},
{97, 0, 13, 112, 0, 0, 0},
{63, 0, 44, 128, 0, 0, 0},
{54, 0, 42, 112, 0, 0, 0},
{98, 75, 13, 8, 0, 0, 0},
{97, 0, 17, 8, 0, 0, 0},
{99, 67, 64, 96, 0, 0, 0}
};

uint16_t CmpMnemonicOffsets[8] = {
0, 9, 18, 27, 39, 49, 59, 69
};
uint16_t VCmpMnemonicOffsets[32] = {
0, 10, 20, 30, 43, 54, 65, 76, 87, 100, 111, 122, 135, 149, 159, 169, 181, 194, 207, 220, 235, 249, 263, 277, 290, 303, 317, 331, 347, 361, 374, 387
};
