package sliceutil

func Deref[T any](slice []*T) []T {
	if slice == nil {
		return nil
	}
	out := make([]T, 0, len(slice))
	for _, p := range slice {
		if p != nil {
			out = append(out, *p)
		}
	}
	return out
}

func Dedup[T comparable](slice []T) []T {
	keys := make(map[T]struct{})
	out := make([]T, 0, len(slice))
	for _, s := range slice {
		if _, ok := keys[s]; !ok {
			out = append(out, s)
			keys[s] = struct{}{}
		}
	}
	return out
}

func Map[S ~[]In, In, Out any](s S, fn func(In) Out) []Out {
	if s == nil {
		return nil
	}
	res := make([]Out, len(s))
	for i, v := range s {
		res[i] = fn(v)
	}
	return res
}

func Mapper[In, Out any](fn func(In) Out) func([]In) []Out {
	return func(s []In) []Out {
		return Map(s, fn)
	}
}
