// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.


//---------------------------------------------------------------------------

//
// This file is automatically generated.  Please do not edit it directly.
//
// File name: generated_resource_factory.cpp
//---------------------------------------------------------------------------

#include "precomp.hpp"

/// <summary>
///   Given a composition object and a resource type, creates
///   a new empty resource object.
/// </summary>
HRESULT CResourceFactory::Create(
    __in_ecount(1) CComposition* pComposition,
    __in_ecount(1) CMilSlaveHandleTable *pHTable,                        
    MIL_RESOURCE_TYPE type,
    __deref_out_ecount(1) CMilSlaveResource** ppResource
    )
{
    HRESULT hr = S_OK;

    CMilSlaveResource* pResource = NULL;

    switch (type) 
    {
    case TYPE_MEDIAPLAYER:
        pResource = new CMilSlaveVideo(pComposition);
        break;

    case TYPE_AXISANGLEROTATION3D:
        pResource = new CMilAxisAngleRotation3DDuce(pComposition);
        break;

    case TYPE_QUATERNIONROTATION3D:
        pResource = new CMilQuaternionRotation3DDuce(pComposition);
        break;

    case TYPE_PERSPECTIVECAMERA:
        pResource = new CMilPerspectiveCameraDuce(pComposition);
        break;

    case TYPE_ORTHOGRAPHICCAMERA:
        pResource = new CMilOrthographicCameraDuce(pComposition);
        break;

    case TYPE_MATRIXCAMERA:
        pResource = new CMilMatrixCameraDuce(pComposition);
        break;

    case TYPE_MODEL3DGROUP:
        pResource = new CMilModel3DGroupDuce(pComposition);
        break;

    case TYPE_AMBIENTLIGHT:
        pResource = new CMilAmbientLightDuce(pComposition);
        break;

    case TYPE_DIRECTIONALLIGHT:
        pResource = new CMilDirectionalLightDuce(pComposition);
        break;

    case TYPE_POINTLIGHT:
        pResource = new CMilPointLightDuce(pComposition);
        break;

    case TYPE_SPOTLIGHT:
        pResource = new CMilSpotLightDuce(pComposition);
        break;

    case TYPE_GEOMETRYMODEL3D:
        pResource = new CMilGeometryModel3DDuce(pComposition);
        break;

    case TYPE_MESHGEOMETRY3D:
        pResource = new CMilMeshGeometry3DDuce(pComposition);
        break;

    case TYPE_MATERIALGROUP:
        pResource = new CMilMaterialGroupDuce(pComposition, pHTable);
        break;

    case TYPE_DIFFUSEMATERIAL:
        pResource = new CMilDiffuseMaterialDuce(pComposition);
        break;

    case TYPE_SPECULARMATERIAL:
        pResource = new CMilSpecularMaterialDuce(pComposition);
        break;

    case TYPE_EMISSIVEMATERIAL:
        pResource = new CMilEmissiveMaterialDuce(pComposition);
        break;

    case TYPE_TRANSFORM3DGROUP:
        pResource = new CMilTransform3DGroupDuce(pComposition, pHTable);
        break;

    case TYPE_TRANSLATETRANSFORM3D:
        pResource = new CMilTranslateTransform3DDuce(pComposition);
        break;

    case TYPE_SCALETRANSFORM3D:
        pResource = new CMilScaleTransform3DDuce(pComposition);
        break;

    case TYPE_ROTATETRANSFORM3D:
        pResource = new CMilRotateTransform3DDuce(pComposition);
        break;

    case TYPE_MATRIXTRANSFORM3D:
        pResource = new CMilMatrixTransform3DDuce(pComposition);
        break;

    case TYPE_PIXELSHADER:
        pResource = new CMilPixelShaderDuce(pComposition);
        break;

    case TYPE_IMPLICITINPUTBRUSH:
        pResource = new CMilImplicitInputBrushDuce(pComposition);
        break;

    case TYPE_BLUREFFECT:
        pResource = new CMilBlurEffectDuce(pComposition);
        break;

    case TYPE_DROPSHADOWEFFECT:
        pResource = new CMilDropShadowEffectDuce(pComposition);
        break;

    case TYPE_SHADEREFFECT:
        pResource = new CMilShaderEffectDuce(pComposition);
        break;

    case TYPE_VISUAL:
        pResource = new CMilVisual(pComposition);
        break;

    case TYPE_VIEWPORT3DVISUAL:
        pResource = new CMilViewport3DVisual(pComposition);
        break;

    case TYPE_VISUAL3D:
        pResource = new CMilVisual3D(pComposition);
        break;

    case TYPE_GLYPHRUN:
        pResource = new CGlyphRunResource(pComposition);
        break;

    case TYPE_RENDERDATA:
        pResource = new CMilSlaveRenderData(pComposition);
        break;

    case TYPE_HWNDRENDERTARGET:
        pResource = new CSlaveHWndRenderTarget(pComposition);
        break;

    case TYPE_GENERICRENDERTARGET:
        pResource = new CSlaveGenericRenderTarget(pComposition);
        break;

    case TYPE_ETWEVENTRESOURCE:
        pResource = new CSlaveEtwEventResource(pComposition);
        break;

    case TYPE_DOUBLERESOURCE:
        pResource = new CMilSlaveDouble(pComposition);
        break;

    case TYPE_COLORRESOURCE:
        pResource = new CMilSlaveColor(pComposition);
        break;

    case TYPE_POINTRESOURCE:
        pResource = new CMilSlavePoint(pComposition);
        break;

    case TYPE_RECTRESOURCE:
        pResource = new CMilSlaveRect(pComposition);
        break;

    case TYPE_SIZERESOURCE:
        pResource = new CMilSlaveSize(pComposition);
        break;

    case TYPE_MATRIXRESOURCE:
        pResource = new CMilSlaveMatrix(pComposition);
        break;

    case TYPE_POINT3DRESOURCE:
        pResource = new CMilSlavePoint3D(pComposition);
        break;

    case TYPE_VECTOR3DRESOURCE:
        pResource = new CMilSlaveVector3D(pComposition);
        break;

    case TYPE_QUATERNIONRESOURCE:
        pResource = new CMilSlaveQuaternion(pComposition);
        break;

    case TYPE_DRAWINGIMAGE:
        pResource = new CMilDrawingImageDuce(pComposition);
        break;

    case TYPE_TRANSFORMGROUP:
        pResource = new CMilTransformGroupDuce(pComposition, pHTable);
        break;

    case TYPE_TRANSLATETRANSFORM:
        pResource = new CMilTranslateTransformDuce(pComposition);
        break;

    case TYPE_SCALETRANSFORM:
        pResource = new CMilScaleTransformDuce(pComposition);
        break;

    case TYPE_SKEWTRANSFORM:
        pResource = new CMilSkewTransformDuce(pComposition);
        break;

    case TYPE_ROTATETRANSFORM:
        pResource = new CMilRotateTransformDuce(pComposition);
        break;

    case TYPE_MATRIXTRANSFORM:
        pResource = new CMilMatrixTransformDuce(pComposition);
        break;

    case TYPE_LINEGEOMETRY:
        pResource = new CMilLineGeometryDuce(pComposition);
        break;

    case TYPE_RECTANGLEGEOMETRY:
        pResource = new CMilRectangleGeometryDuce(pComposition);
        break;

    case TYPE_ELLIPSEGEOMETRY:
        pResource = new CMilEllipseGeometryDuce(pComposition);
        break;

    case TYPE_GEOMETRYGROUP:
        pResource = new CMilGeometryGroupDuce(pComposition, pHTable);
        break;

    case TYPE_COMBINEDGEOMETRY:
        pResource = new CMilCombinedGeometryDuce(pComposition, pHTable);
        break;

    case TYPE_PATHGEOMETRY:
        pResource = new CMilPathGeometryDuce(pComposition);
        break;

    case TYPE_SOLIDCOLORBRUSH:
        pResource = new CMilSolidColorBrushDuce(pComposition);
        break;

    case TYPE_LINEARGRADIENTBRUSH:
        pResource = new CMilLinearGradientBrushDuce(pComposition);
        break;

    case TYPE_RADIALGRADIENTBRUSH:
        pResource = new CMilRadialGradientBrushDuce(pComposition);
        break;

    case TYPE_IMAGEBRUSH:
        pResource = new CMilImageBrushDuce(pComposition);
        break;

    case TYPE_DRAWINGBRUSH:
        pResource = new CMilDrawingBrushDuce(pComposition);
        break;

    case TYPE_VISUALBRUSH:
        pResource = new CMilVisualBrushDuce(pComposition, pHTable);
        break;

    case TYPE_BITMAPCACHEBRUSH:
        pResource = new CMilBitmapCacheBrushDuce(pComposition, pHTable);
        break;

    case TYPE_DASHSTYLE:
        pResource = new CMilDashStyleDuce(pComposition);
        break;

    case TYPE_PEN:
        pResource = new CMilPenDuce(pComposition);
        break;

    case TYPE_GEOMETRYDRAWING:
        pResource = new CMilGeometryDrawingDuce(pComposition);
        break;

    case TYPE_GLYPHRUNDRAWING:
        pResource = new CMilGlyphRunDrawingDuce(pComposition);
        break;

    case TYPE_IMAGEDRAWING:
        pResource = new CMilImageDrawingDuce(pComposition);
        break;

    case TYPE_VIDEODRAWING:
        pResource = new CMilVideoDrawingDuce(pComposition);
        break;

    case TYPE_DRAWINGGROUP:
        pResource = new CMilDrawingGroupDuce(pComposition, pHTable);
        break;

    case TYPE_GUIDELINESET:
        pResource = new CMilGuidelineSetDuce(pComposition);
        break;

    case TYPE_BITMAPCACHE:
        pResource = new CMilBitmapCacheDuce(pComposition);
        break;

    case TYPE_BITMAPSOURCE:
        pResource = new CMilSlaveBitmap(pComposition);
        break;

    case TYPE_DOUBLEBUFFEREDBITMAP:
        pResource = new CMilSlaveDoubleBufferedBitmap(pComposition);
        break;

    case TYPE_D3DIMAGE:
        pResource = new CMilD3DImageDuce(pComposition);
        break;

    default:
        RIP("Invalid resource type.");
        IFC(WGXERR_UCE_MALFORMEDPACKET);
    }

    IFCOOM(pResource);

    pResource->AddRef();

    *ppResource = pResource;

Cleanup:
    RRETURN(hr);
}

