% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateDoubletRateFromCellSelectionPrototype.R
\name{estimateEmptyCount}
\alias{estimateEmptyCount}
\title{Estimate the number of empty cell barcodes in an experiment}
\usage{
estimateEmptyCount(
  cellMetricsFile,
  minPctIntronic = 0.28,
  maxPctIntronic = 0.5,
  minUMIs = 2.8,
  maxUMIs = 3.3
)
}
\arguments{
\item{cellMetricsFile}{A file containing one entry per cell.  The file is tab separated,
and the required columns are:
1. cell_barcode - the string identifying the cell in the experiment.  Usually 12-16 bases long.
2. num_transcripts - the total number of UMIs assigned to each cell.
3. pct_intronic - the fraction of reads or UMIs that are intronic.}

\item{minPctIntronic}{The minimum PCT intronic for the ambient cell barcodes}

\item{maxPctIntronic}{The maximum PCT intronic for the ambient cell barcodes}

\item{minUMIs}{The minimum number of UMIs (in log10) for the ambient cell barcodes}

\item{maxUMIs}{The maximum number of UMIs (in log10) for the ambient cell barcodes}
}
\value{
The number of empty barcodes captured by the bounding box.
}
\description{
Manually draw thresholds around the ambient peak, and count the number of cells
}
