/* The following code was generated by JFlex 1.2.2 on 10/31/17 6:40 PM */

/*******************************************************************************
 * Copyright (c) 2004, 2017 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*nlsXXX*/
package org.eclipse.wst.html.core.internal.contenttype;
import java.io.IOException;
import java.io.Reader;

import org.eclipse.wst.xml.core.internal.contenttype.EncodingParserConstants;
import org.eclipse.wst.xml.core.internal.contenttype.XMLHeadTokenizerConstants;




/**
 * This class is a scanner generated by 
 * <a href="http://www.informatik.tu-muenchen.de/~kleing/jflex/">JFlex</a> 1.2.2
 * on 10/31/17 6:40 PM from the specification file
 * <tt>file:/Users/nitin/cve/webtools.sourceediting/bundles/org.eclipse.wst.sse.core/DevTimeSupport/HeadParsers/HTMLHeadTokenizer/HTMLHeadTokenizer.jFlex</tt>
 */
public class HTMLHeadTokenizer {

  /** this character denotes the end of file */
  final public static int YYEOF = -1;

  /** lexical states */
  final public static int UnDelimitedString = 14;
  final public static int ST_XMLDecl = 2;
  final public static int SQ_STRING = 12;
  final public static int UnDelimitedCharset = 16;
  final public static int ST_XMLNameSpace = 6;
  final public static int ST_META_TAG = 4;
  final public static int DQ_STRING = 10;
  final public static int YYINITIAL = 0;
  final public static int QuotedAttributeValue = 8;

  /**
   * YY_LEXSTATE[l] is the state in the DFA for the lexical state l
   * YY_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private final static int YY_LEXSTATE[] = { 
     0,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,  8,  8, 
     9, 9
  };

  /** 
   * Translates characters to character classes
   */
  final private static String yycmap_packed = 
    "\1\16\10\0\1\6\1\7\2\0\1\15\22\0\1\6\1\0\1\32"+
    "\2\0\1\56\1\0\1\33\5\0\1\13\1\12\1\36\1\11\1\44"+
    "\1\11\1\40\5\11\1\45\1\14\1\57\1\20\1\17\1\46\1\21"+
    "\1\0\1\27\1\10\1\47\1\50\1\25\1\10\1\43\1\34\1\51"+
    "\2\10\1\24\1\23\1\30\1\41\1\35\1\52\1\42\1\31\1\26"+
    "\1\53\1\54\1\37\1\22\1\55\1\10\4\0\1\10\1\0\1\27"+
    "\1\10\1\47\1\50\1\25\1\10\1\43\1\34\1\51\2\10\1\24"+
    "\1\23\1\30\1\41\1\35\1\52\1\42\1\31\1\26\1\53\1\54"+
    "\1\37\1\22\1\55\1\10\74\0\1\11\3\0\1\4\3\0\1\5"+
    "\17\10\1\3\7\10\1\0\6\10\1\1\20\10\1\3\7\10\1\0"+
    "\6\10\1\1\1\2\62\10\2\0\13\10\2\0\10\10\1\0\56\10"+
    "\1\2\6\10\1\0\104\10\11\0\44\10\3\0\2\10\4\0\36\10"+
    "\70\0\131\10\22\0\7\10\16\0\2\11\56\0\106\11\32\0\2\11"+
    "\44\0\1\10\1\11\3\10\1\0\1\10\1\0\24\10\1\0\54\10"+
    "\1\0\7\10\3\0\1\10\1\0\1\10\1\0\1\10\1\0\1\10"+
    "\1\0\22\10\15\0\14\10\1\0\102\10\1\0\14\10\1\0\44\10"+
    "\1\0\4\11\11\0\65\10\2\0\2\10\2\0\2\10\3\0\34\10"+
    "\2\0\10\10\2\0\2\10\67\0\46\10\2\0\1\10\7\0\46\10"+
    "\12\0\21\11\1\0\27\11\1\0\3\11\1\0\1\11\1\0\2\11"+
    "\1\0\1\11\13\0\33\10\5\0\3\10\56\0\32\10\5\0\1\11"+
    "\12\10\10\11\15\0\12\11\6\0\1\11\107\10\2\0\5\10\1\0"+
    "\17\10\1\0\4\10\1\0\1\10\17\11\2\10\2\11\1\0\4\11"+
    "\2\0\12\11\u0207\0\3\11\1\0\65\10\2\0\1\11\1\10\20\11"+
    "\3\0\4\11\3\0\12\10\2\11\2\0\12\11\21\0\3\11\1\0"+
    "\10\10\2\0\2\10\2\0\26\10\1\0\7\10\1\0\1\10\3\0"+
    "\4\10\2\0\1\11\1\0\7\11\2\0\2\11\2\0\3\11\11\0"+
    "\1\11\4\0\2\10\1\0\3\10\2\11\2\0\12\11\2\10\20\0"+
    "\1\11\2\0\6\10\4\0\2\10\2\0\26\10\1\0\7\10\1\0"+
    "\2\10\1\0\2\10\1\0\2\10\2\0\1\11\1\0\5\11\4\0"+
    "\2\11\2\0\3\11\13\0\4\10\1\0\1\10\7\0\12\11\2\11"+
    "\3\10\14\0\3\11\1\0\7\10\1\0\1\10\1\0\3\10\1\0"+
    "\26\10\1\0\7\10\1\0\2\10\1\0\5\10\2\0\1\11\1\10"+
    "\10\11\1\0\3\11\1\0\3\11\22\0\1\10\5\0\12\11\21\0"+
    "\3\11\1\0\10\10\2\0\2\10\2\0\26\10\1\0\7\10\1\0"+
    "\2\10\2\0\4\10\2\0\1\11\1\10\6\11\3\0\2\11\2\0"+
    "\3\11\10\0\2\11\4\0\2\10\1\0\3\10\4\0\12\11\22\0"+
    "\2\11\1\0\6\10\3\0\3\10\1\0\4\10\3\0\2\10\1\0"+
    "\1\10\1\0\2\10\3\0\2\10\3\0\3\10\3\0\10\10\1\0"+
    "\3\10\4\0\5\11\3\0\3\11\1\0\4\11\11\0\1\11\17\0"+
    "\11\11\21\0\3\11\1\0\10\10\1\0\3\10\1\0\27\10\1\0"+
    "\12\10\1\0\5\10\4\0\7\11\1\0\3\11\1\0\4\11\7\0"+
    "\2\11\11\0\2\10\4\0\12\11\22\0\2\11\1\0\10\10\1\0"+
    "\3\10\1\0\27\10\1\0\12\10\1\0\5\10\4\0\7\11\1\0"+
    "\3\11\1\0\4\11\7\0\2\11\7\0\1\10\1\0\2\10\4\0"+
    "\12\11\22\0\2\11\1\0\10\10\1\0\3\10\1\0\27\10\1\0"+
    "\20\10\4\0\6\11\2\0\3\11\1\0\4\11\11\0\1\11\10\0"+
    "\2\10\4\0\12\11\221\0\56\10\1\0\1\10\1\11\2\10\7\11"+
    "\5\0\6\10\1\11\10\11\1\0\12\11\47\0\2\10\1\0\1\10"+
    "\2\0\2\10\1\0\1\10\2\0\1\10\6\0\4\10\1\0\7\10"+
    "\1\0\3\10\1\0\1\10\1\0\1\10\2\0\2\10\1\0\2\10"+
    "\1\0\1\10\1\11\2\10\6\11\1\0\2\11\1\10\2\0\5\10"+
    "\1\0\1\11\1\0\6\11\2\0\12\11\76\0\2\11\6\0\12\11"+
    "\13\0\1\11\1\0\1\11\1\0\1\11\4\0\2\11\10\10\1\0"+
    "\41\10\7\0\24\11\1\0\6\11\4\0\6\11\1\0\1\11\1\0"+
    "\25\11\3\0\7\11\1\0\1\11\346\0\46\10\12\0\47\10\11\0"+
    "\1\10\1\0\2\10\1\0\3\10\1\0\1\10\1\0\2\10\1\0"+
    "\5\10\51\0\1\10\1\0\1\10\1\0\1\10\13\0\1\10\1\0"+
    "\1\10\1\0\1\10\3\0\2\10\3\0\1\10\5\0\3\10\1\0"+
    "\1\10\1\0\1\10\1\0\1\10\1\0\1\10\3\0\2\10\3\0"+
    "\2\10\1\0\1\10\50\0\1\10\11\0\1\10\2\0\1\10\2\0"+
    "\2\10\7\0\2\10\1\0\1\10\1\0\7\10\50\0\1\10\4\0"+
    "\1\10\10\0\1\10\u0c06\0\234\10\4\0\132\10\6\0\26\10\2\0"+
    "\6\10\2\0\46\10\2\0\6\10\2\0\10\10\1\0\1\10\1\0"+
    "\1\10\1\0\1\10\1\0\37\10\2\0\65\10\1\0\7\10\1\0"+
    "\1\10\3\0\3\10\1\0\7\10\3\0\4\10\2\0\6\10\4\0"+
    "\15\10\5\0\3\10\1\0\7\10\323\0\15\11\4\0\1\11\104\0"+
    "\1\10\3\0\2\10\2\0\1\10\121\0\3\10\u0e82\0\1\11\1\0"+
    "\1\10\31\0\11\10\6\11\1\0\5\11\13\0\124\10\4\0\2\11"+
    "\2\0\2\11\2\0\132\10\1\0\3\11\6\0\50\10\u1cd3\0\u51a6\10"+
    "\u0c5a\0\u2ba4\10\u285c\0";

  /** 
   * Translates characters to character classes
   */
  final private static char [] yycmap = yy_unpack_cmap(yycmap_packed);


  /* error codes */
  final private static int YY_UNKNOWN_ERROR = 0;
  final private static int YY_ILLEGAL_STATE = 1;
  final private static int YY_NO_MATCH = 2;
  final private static int YY_PUSHBACK_2BIG = 3;

  /* error messages for the codes above */
  final private static String YY_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Internal error: unknown state",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /** the input device */
  private java.io.Reader yy_reader;

  /** the current state of the DFA */
  private int yy_state;

  /** the current lexical state */
  private int yy_lexical_state = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char yy_buffer[] = new char[16384];

  /** the textposition at the last accepting state */
  private int yy_markedPos;

  /** the textposition at the last state to be included in yytext */
  private int yy_pushbackPos;

  /** the current text position in the buffer */
  private int yy_currentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int yy_startRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int yy_endRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn; 

  /** 
   * yy_atBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean yy_atBOL;

  /** yy_atEOF == true <=> the scanner has returned a value for EOF */
  private boolean yy_atEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean yy_eof_done;

  /* user code: */


	private boolean hasMore = true;
	private boolean hasCharsetAttr = false;
	private final static int MAX_TO_SCAN = 8000;
	StringBuffer string = new StringBuffer();
	// state stack for easier state handling
	private IntStack fStateStack = new IntStack();
	private String valueText = null;
	boolean foundContentTypeValue = false;
	private boolean isXHTML;
	private boolean isDocumentRootElementChecked = false;


	public HTMLHeadTokenizer() {
		super();
	}

	  public void reset (Reader in) {
	  	/* the input device */
	  	yy_reader = in;

  		/* the current state of the DFA */
  		yy_state = 0;

  		/* the current lexical state */
  		yy_lexical_state = YYINITIAL;

  		/* this buffer contains the current text to be matched and is
  		 the source of the yytext() string */
  		java.util.Arrays.fill(yy_buffer, (char)0);

  		/* the textposition at the last accepting state */
  		yy_markedPos = 0;

  		/* the textposition at the last state to be included in yytext */
  		yy_pushbackPos = 0;

  		/* the current text position in the buffer */
  		yy_currentPos = 0;

  		/* startRead marks the beginning of the yytext() string in the buffer */
  		yy_startRead = 0;

  		/** 
  		 * endRead marks the last character in the buffer, that has been read
  		 * from input 
  		 */
  		yy_endRead = 0;

  		/* number of newlines encountered up to the start of the matched text */
  		// yyline = 0;

  		/* the number of characters up to the start of the matched text */
  		yychar = 0;

  		/**
  		 * the number of characters from the last newline up to the start
  		 * of the matched text
  		 */
  		// yycolumn = 0; 

  		/** 
  		 * yy_atBOL == true <=> the scanner is currently at the beginning 
  		 * of a line
  		 */
  		yy_atBOL = false;

  		/* yy_atEOF == true <=> the scanner has returned a value for EOF */
  		yy_atEOF = false;

  		/* denotes if the user-EOF-code has already been executed */
  		yy_eof_done = false;


  		fStateStack.clear();
  		
  		hasMore = true;
  		hasCharsetAttr = false;
  		isXHTML = false;
		isDocumentRootElementChecked = false;

		// its a little wasteful to "throw away" first char array generated
		// by class init (via auto generated code), but we really do want
		// a small buffer for our head parsers.
		if (yy_buffer.length != MAX_TO_SCAN) {
			yy_buffer = new char[MAX_TO_SCAN];
		}
  		

  	}


	public final HeadParserToken getNextToken() throws IOException {
		String context = null;
		HeadParserToken result = null;
		try {
			context = primGetNextToken();
		}
		catch (IllegalStateException e) {
			hasMore = false;
			result = createToken(HTMLHeadTokenizerConstants.UNDEFINED, yychar, yytext());
			while(yy_advance() != YYEOF) {}
			return result;
		}
		if (valueText != null) {
			result = createToken(context, yychar, valueText);
			valueText = null;
		} else {
			result = createToken(context, yychar, yytext());
		}
		return result;
	}

	public final boolean hasMoreTokens() {
		return hasMore && yychar < MAX_TO_SCAN;
	}
	private void pushCurrentState() {
		fStateStack.push(yystate());

	}
	public final boolean hasCharsetAttr() {
		return hasCharsetAttr;
	}

	private void popState() {
		yybegin(fStateStack.pop());
	}
	private HeadParserToken createToken(String context, int start, String text) {
		return new HeadParserToken(context, start, text);
	}
	
	/* Is this file XHTML, for the purposes of its description (encoding, etc.) */
    public boolean isXHTML() {
       return isXHTML;
    }

	public boolean isDocumentRootElementChecked(){
		return isDocumentRootElementChecked;
	}


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public HTMLHeadTokenizer(java.io.Reader in) {
    this.yy_reader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public HTMLHeadTokenizer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] yy_unpack_cmap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1386) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Gets the next input character.
   *
   * @return      the next character of the input stream, EOF if the
   *              end of the stream is reached.
   * @exception   IOException  if any I/O-Error occurs
   */
  private int yy_advance() throws java.io.IOException {

    /* standard case */
    if (yy_currentPos < yy_endRead) return yy_buffer[yy_currentPos++];

    /* if the eof is reached, we don't need to work hard */ 
    if (yy_atEOF) return YYEOF;

    /* otherwise: need to refill the buffer */

    /* first: make room (if you can) */
    if (yy_startRead > 0) {
      System.arraycopy(yy_buffer, yy_startRead, 
                       yy_buffer, 0, 
                       yy_endRead-yy_startRead);

      /* translate stored positions */
      yy_endRead-= yy_startRead;
      yy_currentPos-= yy_startRead;
      yy_markedPos-= yy_startRead;
      yy_pushbackPos-= yy_startRead;
      yy_startRead = 0;
    }

    /* is the buffer big enough? */
    if (yy_currentPos >= yy_buffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[yy_currentPos*2];
      System.arraycopy(yy_buffer, 0, newBuffer, 0, yy_buffer.length);
      yy_buffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = yy_reader.read(yy_buffer, yy_endRead, 
                                            yy_buffer.length-yy_endRead);

    if ( numRead == -1 ) return YYEOF;

    yy_endRead+= numRead;

    return yy_buffer[yy_currentPos++];
  }


  /**
   * Closes the input stream.
   */
  final public void yyclose() throws java.io.IOException {
    yy_atEOF = true;            /* indicate end of file */
    yy_endRead = yy_startRead;  /* invalidate buffer    */
    yy_reader.close();
  }


  /**
   * Returns the current lexical state.
   */
  final public int yystate() {
    return yy_lexical_state;
  }

  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  final public void yybegin(int newState) {
    yy_lexical_state = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  final public String yytext() {
    return new String( yy_buffer, yy_startRead, yy_markedPos-yy_startRead );
  }

  /**
   * Returns the length of the matched text region.
   */
  final public int yylength() {
    return yy_markedPos-yy_startRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void yy_ScanError(int errorCode) {
    try {
      System.out.println(YY_ERROR_MSG[errorCode]);
    }
    catch (ArrayIndexOutOfBoundsException e) {
      System.out.println(YY_ERROR_MSG[YY_UNKNOWN_ERROR]);
    }

    System.exit(1);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  private void yypushback(int number) {
    if ( number > yylength() )
      yy_ScanError(YY_PUSHBACK_2BIG);

    yy_markedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void yy_do_eof() {
    if (!yy_eof_done) {
      yy_eof_done = true;
    	hasMore=false;

    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   IOException  if any I/O-Error occurs
   */
  public String primGetNextToken() throws java.io.IOException {
    int yy_input;
    int yy_action;

    yy_pushbackPos = -1;
    boolean yy_was_pushback;

    while (true) {

      yychar+= yylength();

      yy_atBOL = yy_markedPos <= 0 || yy_buffer[yy_markedPos-1] == '\n';
      if (!yy_atBOL && yy_buffer[yy_markedPos-1] == '\r') {
        yy_atBOL = yy_advance() != '\n';
        if (!yy_atEOF) yy_currentPos--;
      }

      yy_action = -1;

      yy_currentPos = yy_startRead = yy_markedPos;

      if (yy_atBOL)
        yy_state = YY_LEXSTATE[yy_lexical_state+1];
      else
        yy_state = YY_LEXSTATE[yy_lexical_state];

      yy_was_pushback = false;

      yy_forAction: {
        while (true) {

          yy_input = yy_advance();

          if ( yy_input == YYEOF ) break yy_forAction;

          yy_input = yycmap[yy_input];

          boolean yy_pushback = false;
          boolean yy_isFinal = false;
          boolean yy_noLookAhead = false;

          yy_forNext: { switch (yy_state) {
            case 0:
              switch (yy_input) {
                case 1: yy_isFinal = true; yy_state = 11; break yy_forNext;
                case 2: yy_isFinal = true; yy_state = 12; break yy_forNext;
                case 3: yy_isFinal = true; yy_state = 13; break yy_forNext;
                case 14: yy_isFinal = true; yy_state = 14; break yy_forNext;
                case 16: yy_isFinal = true; yy_state = 15; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 10; break yy_forNext;
              }

            case 1:
              switch (yy_input) {
                case 1: yy_isFinal = true; yy_state = 11; break yy_forNext;
                case 2: yy_isFinal = true; yy_state = 12; break yy_forNext;
                case 3: yy_isFinal = true; yy_state = 13; break yy_forNext;
                case 6: 
                case 7: 
                case 13: yy_isFinal = true; yy_state = 16; break yy_forNext;
                case 14: yy_isFinal = true; yy_state = 17; break yy_forNext;
                case 16: yy_isFinal = true; yy_state = 18; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 10; break yy_forNext;
              }

            case 2:
              switch (yy_input) {
                case 14: yy_isFinal = true; yy_state = 19; break yy_forNext;
                case 17: yy_isFinal = true; yy_state = 20; break yy_forNext;
                case 21: yy_isFinal = true; yy_state = 21; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 10; break yy_forNext;
              }

            case 3:
              switch (yy_input) {
                case 14: yy_isFinal = true; yy_state = 22; break yy_forNext;
                case 28: yy_isFinal = true; yy_state = 23; break yy_forNext;
                case 30: yy_isFinal = true; yy_state = 24; break yy_forNext;
                case 38: yy_isFinal = true; yy_state = 25; break yy_forNext;
                case 39: yy_isFinal = true; yy_state = 26; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 10; break yy_forNext;
              }

            case 4:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_isFinal = true; yy_state = 27; break yy_forNext;
                case 14: yy_isFinal = true; yy_state = 28; break yy_forNext;
                case 30: yy_isFinal = true; yy_state = 29; break yy_forNext;
                case 38: yy_isFinal = true; yy_state = 30; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 10; break yy_forNext;
              }

            case 5:
              switch (yy_input) {
                case 6: 
                case 13: yy_isFinal = true; yy_state = 32; break yy_forNext;
                case 7: yy_isFinal = true; yy_state = 33; break yy_forNext;
                case 14: yy_isFinal = true; yy_state = 34; break yy_forNext;
                case 26: yy_isFinal = true; yy_state = 35; break yy_forNext;
                case 27: yy_isFinal = true; yy_state = 36; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 31; break yy_forNext;
              }

            case 6:
              switch (yy_input) {
                case 7: 
                case 13: 
                case 16: 
                case 38: yy_isFinal = true; yy_state = 38; break yy_forNext;
                case 14: yy_isFinal = true; yy_state = 39; break yy_forNext;
                case 17: 
                case 30: yy_isFinal = true; yy_state = 40; break yy_forNext;
                case 26: yy_isFinal = true; yy_state = 41; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 37; break yy_forNext;
              }

            case 7:
              switch (yy_input) {
                case 7: 
                case 13: 
                case 16: 
                case 38: yy_isFinal = true; yy_state = 38; break yy_forNext;
                case 30: yy_isFinal = true; yy_state = 40; break yy_forNext;
                case 27: yy_isFinal = true; yy_state = 41; break yy_forNext;
                case 14: yy_isFinal = true; yy_state = 42; break yy_forNext;
                case 46: yy_isFinal = true; yy_state = 43; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 37; break yy_forNext;
              }

            case 8:
              switch (yy_input) {
                case 16: 
                case 38: yy_isFinal = true; yy_state = 38; break yy_forNext;
                case 30: yy_isFinal = true; yy_state = 40; break yy_forNext;
                case 17: yy_isFinal = true; yy_state = 43; break yy_forNext;
                case 6: 
                case 7: 
                case 13: yy_isFinal = true; yy_state = 44; break yy_forNext;
                case 14: yy_isFinal = true; yy_state = 45; break yy_forNext;
                case 26: 
                case 27: yy_isFinal = true; yy_state = 46; break yy_forNext;
                case 47: yy_isFinal = true; yy_pushbackPos = yy_currentPos; yy_pushback = true; yy_state = 47; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 37; break yy_forNext;
              }

            case 9:
              switch (yy_input) {
                case 14: yy_isFinal = true; yy_noLookAhead = true; yy_state = 10; break yy_forNext;
                case 6: 
                case 7: 
                case 13: yy_isFinal = true; yy_noLookAhead = true; yy_state = 37; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 48; break yy_forNext;
              }

            case 11:
              switch (yy_input) {
                case 2: yy_isFinal = true; yy_noLookAhead = true; yy_state = 49; break yy_forNext;
                default: break yy_forAction;
              }

            case 12:
              switch (yy_input) {
                case 1: yy_isFinal = true; yy_noLookAhead = true; yy_state = 50; break yy_forNext;
                default: break yy_forAction;
              }

            case 13:
              switch (yy_input) {
                case 4: yy_state = 51; break yy_forNext;
                default: break yy_forAction;
              }

            case 14:
              switch (yy_input) {
                case 16: yy_state = 52; break yy_forNext;
                default: break yy_forAction;
              }

            case 15:
              switch (yy_input) {
                case 14: yy_state = 54; break yy_forNext;
                case 19: yy_isFinal = true; yy_state = 55; break yy_forNext;
                case 0: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 26: 
                case 27: 
                case 30: 
                case 32: 
                case 36: 
                case 37: 
                case 38: 
                case 46: 
                case 47: break yy_forAction;
                default: yy_isFinal = true; yy_state = 53; break yy_forNext;
              }

            case 16:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 56; break yy_forNext;
                case 14: yy_state = 57; break yy_forNext;
                case 16: yy_state = 58; break yy_forNext;
                default: break yy_forAction;
              }

            case 17:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 56; break yy_forNext;
                case 16: yy_state = 59; break yy_forNext;
                default: break yy_forAction;
              }

            case 18:
              switch (yy_input) {
                case 19: yy_isFinal = true; yy_state = 55; break yy_forNext;
                case 14: yy_state = 60; break yy_forNext;
                case 17: yy_state = 61; break yy_forNext;
                case 0: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 15: 
                case 16: 
                case 26: 
                case 27: 
                case 30: 
                case 32: 
                case 36: 
                case 37: 
                case 38: 
                case 46: 
                case 47: break yy_forAction;
                default: yy_isFinal = true; yy_state = 53; break yy_forNext;
              }

            case 19:
              switch (yy_input) {
                case 17: yy_state = 62; break yy_forNext;
                case 21: yy_state = 63; break yy_forNext;
                default: break yy_forAction;
              }

            case 20:
              switch (yy_input) {
                case 14: yy_state = 64; break yy_forNext;
                case 38: yy_isFinal = true; yy_state = 65; break yy_forNext;
                default: break yy_forAction;
              }

            case 21:
              switch (yy_input) {
                case 14: yy_state = 66; break yy_forNext;
                case 24: yy_state = 67; break yy_forNext;
                default: break yy_forAction;
              }

            case 22:
              switch (yy_input) {
                case 38: yy_isFinal = true; yy_state = 25; break yy_forNext;
                case 28: yy_state = 68; break yy_forNext;
                case 30: yy_state = 69; break yy_forNext;
                case 39: yy_state = 70; break yy_forNext;
                default: break yy_forAction;
              }

            case 23:
              switch (yy_input) {
                case 14: yy_state = 71; break yy_forNext;
                case 22: yy_state = 72; break yy_forNext;
                default: break yy_forAction;
              }

            case 24:
              switch (yy_input) {
                case 14: yy_state = 73; break yy_forNext;
                case 38: yy_isFinal = true; yy_state = 74; break yy_forNext;
                default: break yy_forAction;
              }

            case 25:
              switch (yy_input) {
                case 14: yy_isFinal = true; yy_noLookAhead = true; yy_state = 75; break yy_forNext;
                default: break yy_forAction;
              }

            case 26:
              switch (yy_input) {
                case 14: yy_state = 76; break yy_forNext;
                case 28: yy_state = 77; break yy_forNext;
                default: break yy_forAction;
              }

            case 27:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 78; break yy_forNext;
                case 14: yy_state = 79; break yy_forNext;
                case 18: yy_state = 80; break yy_forNext;
                default: break yy_forAction;
              }

            case 28:
              switch (yy_input) {
                case 38: yy_isFinal = true; yy_state = 30; break yy_forNext;
                case 6: 
                case 7: 
                case 13: yy_state = 78; break yy_forNext;
                case 30: yy_state = 81; break yy_forNext;
                default: break yy_forAction;
              }

            case 29:
              switch (yy_input) {
                case 38: yy_isFinal = true; yy_state = 30; break yy_forNext;
                case 14: yy_state = 82; break yy_forNext;
                default: break yy_forAction;
              }

            case 30:
              switch (yy_input) {
                case 14: yy_isFinal = true; yy_noLookAhead = true; yy_state = 83; break yy_forNext;
                default: break yy_forAction;
              }

            case 32:
              switch (yy_input) {
                case 6: 
                case 13: yy_isFinal = true; yy_state = 32; break yy_forNext;
                case 7: yy_state = 84; break yy_forNext;
                case 14: yy_isFinal = true; yy_state = 85; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 31; break yy_forNext;
              }

            case 33:
              switch (yy_input) {
                case 6: 
                case 13: yy_isFinal = true; yy_state = 32; break yy_forNext;
                case 7: yy_state = 84; break yy_forNext;
                case 14: yy_isFinal = true; yy_state = 85; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 31; break yy_forNext;
              }

            case 34:
              switch (yy_input) {
                case 26: yy_isFinal = true; yy_state = 35; break yy_forNext;
                case 27: yy_isFinal = true; yy_state = 36; break yy_forNext;
                case 6: 
                case 7: 
                case 13: yy_state = 84; break yy_forNext;
                default: break yy_forAction;
              }

            case 35:
              switch (yy_input) {
                case 14: yy_isFinal = true; yy_noLookAhead = true; yy_state = 86; break yy_forNext;
                default: break yy_forAction;
              }

            case 36:
              switch (yy_input) {
                case 14: yy_isFinal = true; yy_noLookAhead = true; yy_state = 87; break yy_forNext;
                default: break yy_forAction;
              }

            case 38:
              switch (yy_input) {
                case 14: yy_isFinal = true; yy_noLookAhead = true; yy_state = 88; break yy_forNext;
                default: break yy_forAction;
              }

            case 39:
              switch (yy_input) {
                case 7: 
                case 13: 
                case 16: 
                case 38: yy_isFinal = true; yy_state = 38; break yy_forNext;
                case 26: yy_isFinal = true; yy_state = 41; break yy_forNext;
                case 17: 
                case 30: yy_state = 89; break yy_forNext;
                default: break yy_forAction;
              }

            case 40:
              switch (yy_input) {
                case 14: yy_state = 90; break yy_forNext;
                case 38: yy_isFinal = true; yy_state = 91; break yy_forNext;
                default: break yy_forAction;
              }

            case 41:
              switch (yy_input) {
                case 14: yy_isFinal = true; yy_noLookAhead = true; yy_state = 92; break yy_forNext;
                default: break yy_forAction;
              }

            case 42:
              switch (yy_input) {
                case 7: 
                case 13: 
                case 16: 
                case 38: yy_isFinal = true; yy_state = 38; break yy_forNext;
                case 27: yy_isFinal = true; yy_state = 41; break yy_forNext;
                case 30: yy_state = 89; break yy_forNext;
                case 46: yy_state = 93; break yy_forNext;
                default: break yy_forAction;
              }

            case 43:
              switch (yy_input) {
                case 38: yy_isFinal = true; yy_state = 38; break yy_forNext;
                case 14: yy_state = 94; break yy_forNext;
                default: break yy_forAction;
              }

            case 44:
              switch (yy_input) {
                case 14: yy_isFinal = true; yy_noLookAhead = true; yy_state = 95; break yy_forNext;
                default: break yy_forAction;
              }

            case 45:
              switch (yy_input) {
                case 16: 
                case 38: yy_isFinal = true; yy_state = 38; break yy_forNext;
                case 6: 
                case 7: 
                case 13: yy_isFinal = true; yy_state = 44; break yy_forNext;
                case 26: 
                case 27: yy_isFinal = true; yy_state = 46; break yy_forNext;
                case 30: yy_state = 89; break yy_forNext;
                case 17: yy_state = 93; break yy_forNext;
                default: break yy_forAction;
              }

            case 46:
              switch (yy_input) {
                case 14: yy_isFinal = true; yy_noLookAhead = true; yy_state = 96; break yy_forNext;
                default: break yy_forAction;
              }

            case 47:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_isFinal = true; yy_pushback = true; yy_state = 97; break yy_forNext;
                case 14: yy_state = 98; break yy_forNext;
                default: break yy_forAction;
              }

            case 51:
              switch (yy_input) {
                case 5: yy_isFinal = true; yy_noLookAhead = true; yy_state = 99; break yy_forNext;
                default: break yy_forAction;
              }

            case 52:
              switch (yy_input) {
                case 14: yy_state = 54; break yy_forNext;
                case 19: yy_isFinal = true; yy_state = 55; break yy_forNext;
                case 0: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 26: 
                case 27: 
                case 30: 
                case 32: 
                case 36: 
                case 37: 
                case 38: 
                case 46: 
                case 47: break yy_forAction;
                default: yy_isFinal = true; yy_state = 53; break yy_forNext;
              }

            case 53:
              switch (yy_input) {
                case 0: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 26: 
                case 27: 
                case 30: 
                case 38: 
                case 46: 
                case 47: break yy_forAction;
                default: yy_isFinal = true; yy_state = 53; break yy_forNext;
              }

            case 54:
              switch (yy_input) {
                case 19: yy_state = 100; break yy_forNext;
                default: break yy_forAction;
              }

            case 55:
              switch (yy_input) {
                case 14: yy_state = 101; break yy_forNext;
                case 21: yy_isFinal = true; yy_state = 102; break yy_forNext;
                case 0: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 26: 
                case 27: 
                case 30: 
                case 38: 
                case 46: 
                case 47: break yy_forAction;
                default: yy_isFinal = true; yy_state = 53; break yy_forNext;
              }

            case 56:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 56; break yy_forNext;
                case 14: yy_state = 57; break yy_forNext;
                case 16: yy_state = 58; break yy_forNext;
                default: break yy_forAction;
              }

            case 57:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 56; break yy_forNext;
                case 16: yy_state = 58; break yy_forNext;
                case 14: yy_state = 103; break yy_forNext;
                default: break yy_forAction;
              }

            case 58:
              switch (yy_input) {
                case 17: yy_state = 61; break yy_forNext;
                case 14: yy_state = 104; break yy_forNext;
                default: break yy_forAction;
              }

            case 59:
              switch (yy_input) {
                case 19: yy_isFinal = true; yy_state = 55; break yy_forNext;
                case 14: yy_state = 60; break yy_forNext;
                case 17: yy_state = 61; break yy_forNext;
                case 0: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 15: 
                case 16: 
                case 26: 
                case 27: 
                case 30: 
                case 32: 
                case 36: 
                case 37: 
                case 38: 
                case 46: 
                case 47: break yy_forAction;
                default: yy_isFinal = true; yy_state = 53; break yy_forNext;
              }

            case 60:
              switch (yy_input) {
                case 17: yy_state = 61; break yy_forNext;
                case 19: yy_state = 100; break yy_forNext;
                default: break yy_forAction;
              }

            case 61:
              switch (yy_input) {
                case 14: yy_state = 105; break yy_forNext;
                case 18: yy_state = 106; break yy_forNext;
                default: break yy_forAction;
              }

            case 62:
              switch (yy_input) {
                case 14: yy_state = 64; break yy_forNext;
                case 38: yy_isFinal = true; yy_state = 65; break yy_forNext;
                default: break yy_forAction;
              }

            case 63:
              switch (yy_input) {
                case 14: yy_state = 66; break yy_forNext;
                case 24: yy_state = 67; break yy_forNext;
                default: break yy_forAction;
              }

            case 64:
              switch (yy_input) {
                case 38: yy_isFinal = true; yy_state = 65; break yy_forNext;
                default: break yy_forAction;
              }

            case 65:
              switch (yy_input) {
                case 14: yy_isFinal = true; yy_noLookAhead = true; yy_state = 107; break yy_forNext;
                default: break yy_forAction;
              }

            case 66:
              switch (yy_input) {
                case 24: yy_state = 67; break yy_forNext;
                default: break yy_forAction;
              }

            case 67:
              switch (yy_input) {
                case 14: yy_state = 108; break yy_forNext;
                case 39: yy_state = 109; break yy_forNext;
                default: break yy_forAction;
              }

            case 68:
              switch (yy_input) {
                case 14: yy_state = 71; break yy_forNext;
                case 22: yy_state = 72; break yy_forNext;
                default: break yy_forAction;
              }

            case 69:
              switch (yy_input) {
                case 14: yy_state = 73; break yy_forNext;
                case 38: yy_isFinal = true; yy_state = 74; break yy_forNext;
                default: break yy_forAction;
              }

            case 70:
              switch (yy_input) {
                case 14: yy_state = 76; break yy_forNext;
                case 28: yy_state = 77; break yy_forNext;
                default: break yy_forAction;
              }

            case 71:
              switch (yy_input) {
                case 22: yy_state = 72; break yy_forNext;
                default: break yy_forAction;
              }

            case 72:
              switch (yy_input) {
                case 14: yy_state = 110; break yy_forNext;
                case 22: yy_state = 111; break yy_forNext;
                default: break yy_forAction;
              }

            case 73:
              switch (yy_input) {
                case 38: yy_isFinal = true; yy_state = 74; break yy_forNext;
                default: break yy_forAction;
              }

            case 74:
              switch (yy_input) {
                case 14: yy_isFinal = true; yy_noLookAhead = true; yy_state = 112; break yy_forNext;
                default: break yy_forAction;
              }

            case 76:
              switch (yy_input) {
                case 28: yy_state = 77; break yy_forNext;
                default: break yy_forAction;
              }

            case 77:
              switch (yy_input) {
                case 14: yy_state = 113; break yy_forNext;
                case 23: yy_state = 114; break yy_forNext;
                default: break yy_forAction;
              }

            case 78:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 78; break yy_forNext;
                case 14: yy_state = 79; break yy_forNext;
                case 18: yy_state = 80; break yy_forNext;
                default: break yy_forAction;
              }

            case 79:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 78; break yy_forNext;
                case 18: yy_state = 80; break yy_forNext;
                case 14: yy_state = 115; break yy_forNext;
                default: break yy_forAction;
              }

            case 80:
              switch (yy_input) {
                case 14: yy_state = 116; break yy_forNext;
                case 19: yy_state = 117; break yy_forNext;
                default: break yy_forAction;
              }

            case 81:
              switch (yy_input) {
                case 38: yy_isFinal = true; yy_state = 30; break yy_forNext;
                case 14: yy_state = 82; break yy_forNext;
                default: break yy_forAction;
              }

            case 82:
              switch (yy_input) {
                case 38: yy_isFinal = true; yy_state = 30; break yy_forNext;
                default: break yy_forAction;
              }

            case 84:
              switch (yy_input) {
                case 6: 
                case 13: yy_isFinal = true; yy_state = 32; break yy_forNext;
                case 7: yy_state = 84; break yy_forNext;
                case 14: yy_isFinal = true; yy_state = 85; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 31; break yy_forNext;
              }

            case 85:
              switch (yy_input) {
                case 6: 
                case 13: yy_isFinal = true; yy_state = 32; break yy_forNext;
                case 7: yy_state = 84; break yy_forNext;
                case 14: yy_isFinal = true; yy_state = 118; break yy_forNext;
                default: yy_isFinal = true; yy_noLookAhead = true; yy_state = 31; break yy_forNext;
              }

            case 89:
              switch (yy_input) {
                case 14: yy_state = 90; break yy_forNext;
                case 38: yy_isFinal = true; yy_state = 91; break yy_forNext;
                default: break yy_forAction;
              }

            case 90:
              switch (yy_input) {
                case 38: yy_isFinal = true; yy_state = 91; break yy_forNext;
                default: break yy_forAction;
              }

            case 91:
              switch (yy_input) {
                case 14: yy_isFinal = true; yy_noLookAhead = true; yy_state = 119; break yy_forNext;
                default: break yy_forAction;
              }

            case 93:
              switch (yy_input) {
                case 38: yy_isFinal = true; yy_state = 38; break yy_forNext;
                case 14: yy_state = 94; break yy_forNext;
                default: break yy_forAction;
              }

            case 94:
              switch (yy_input) {
                case 38: yy_isFinal = true; yy_state = 38; break yy_forNext;
                default: break yy_forAction;
              }

            case 97:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_isFinal = true; yy_pushback = true; yy_state = 97; break yy_forNext;
                case 14: yy_isFinal = true; yy_pushback = true; yy_state = 120; break yy_forNext;
                default: break yy_forAction;
              }

            case 98:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_isFinal = true; yy_pushback = true; yy_state = 97; break yy_forNext;
                default: break yy_forAction;
              }

            case 100:
              switch (yy_input) {
                case 14: yy_state = 101; break yy_forNext;
                case 21: yy_state = 121; break yy_forNext;
                default: break yy_forAction;
              }

            case 101:
              switch (yy_input) {
                case 21: yy_state = 121; break yy_forNext;
                default: break yy_forAction;
              }

            case 102:
              switch (yy_input) {
                case 14: yy_state = 122; break yy_forNext;
                case 22: yy_isFinal = true; yy_state = 123; break yy_forNext;
                case 0: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 26: 
                case 27: 
                case 30: 
                case 38: 
                case 46: 
                case 47: break yy_forAction;
                default: yy_isFinal = true; yy_state = 53; break yy_forNext;
              }

            case 103:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 56; break yy_forNext;
                case 16: yy_state = 58; break yy_forNext;
                default: break yy_forAction;
              }

            case 104:
              switch (yy_input) {
                case 17: yy_state = 61; break yy_forNext;
                default: break yy_forAction;
              }

            case 105:
              switch (yy_input) {
                case 18: yy_state = 106; break yy_forNext;
                default: break yy_forAction;
              }

            case 106:
              switch (yy_input) {
                case 14: yy_state = 124; break yy_forNext;
                case 19: yy_state = 125; break yy_forNext;
                default: break yy_forAction;
              }

            case 108:
              switch (yy_input) {
                case 39: yy_state = 109; break yy_forNext;
                default: break yy_forAction;
              }

            case 109:
              switch (yy_input) {
                case 14: yy_state = 126; break yy_forNext;
                case 33: yy_state = 127; break yy_forNext;
                default: break yy_forAction;
              }

            case 110:
              switch (yy_input) {
                case 22: yy_state = 111; break yy_forNext;
                default: break yy_forAction;
              }

            case 111:
              switch (yy_input) {
                case 14: yy_state = 128; break yy_forNext;
                case 29: yy_state = 129; break yy_forNext;
                default: break yy_forAction;
              }

            case 113:
              switch (yy_input) {
                case 23: yy_state = 114; break yy_forNext;
                default: break yy_forAction;
              }

            case 114:
              switch (yy_input) {
                case 14: yy_state = 130; break yy_forNext;
                case 34: yy_state = 131; break yy_forNext;
                default: break yy_forAction;
              }

            case 115:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 78; break yy_forNext;
                case 18: yy_state = 80; break yy_forNext;
                default: break yy_forAction;
              }

            case 116:
              switch (yy_input) {
                case 19: yy_state = 117; break yy_forNext;
                default: break yy_forAction;
              }

            case 117:
              switch (yy_input) {
                case 14: yy_state = 132; break yy_forNext;
                case 20: yy_state = 133; break yy_forNext;
                default: break yy_forAction;
              }

            case 118:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 84; break yy_forNext;
                default: break yy_forAction;
              }

            case 120:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_isFinal = true; yy_pushback = true; yy_state = 97; break yy_forNext;
                case 14: yy_state = 98; break yy_forNext;
                default: break yy_forAction;
              }

            case 121:
              switch (yy_input) {
                case 14: yy_state = 122; break yy_forNext;
                case 22: yy_state = 134; break yy_forNext;
                default: break yy_forAction;
              }

            case 122:
              switch (yy_input) {
                case 22: yy_state = 134; break yy_forNext;
                default: break yy_forAction;
              }

            case 123:
              switch (yy_input) {
                case 14: yy_state = 135; break yy_forNext;
                case 23: yy_isFinal = true; yy_state = 136; break yy_forNext;
                case 0: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 26: 
                case 27: 
                case 30: 
                case 38: 
                case 46: 
                case 47: break yy_forAction;
                default: yy_isFinal = true; yy_state = 53; break yy_forNext;
              }

            case 124:
              switch (yy_input) {
                case 19: yy_state = 125; break yy_forNext;
                default: break yy_forAction;
              }

            case 125:
              switch (yy_input) {
                case 14: yy_state = 137; break yy_forNext;
                case 20: yy_state = 138; break yy_forNext;
                default: break yy_forAction;
              }

            case 126:
              switch (yy_input) {
                case 33: yy_state = 127; break yy_forNext;
                default: break yy_forAction;
              }

            case 127:
              switch (yy_input) {
                case 14: yy_state = 139; break yy_forNext;
                case 40: yy_state = 140; break yy_forNext;
                default: break yy_forAction;
              }

            case 128:
              switch (yy_input) {
                case 29: yy_state = 129; break yy_forNext;
                default: break yy_forAction;
              }

            case 129:
              switch (yy_input) {
                case 11: yy_state = 141; break yy_forNext;
                case 14: yy_state = 142; break yy_forNext;
                default: break yy_forAction;
              }

            case 130:
              switch (yy_input) {
                case 34: yy_state = 131; break yy_forNext;
                default: break yy_forAction;
              }

            case 131:
              switch (yy_input) {
                case 14: yy_state = 143; break yy_forNext;
                case 25: yy_state = 144; break yy_forNext;
                default: break yy_forAction;
              }

            case 132:
              switch (yy_input) {
                case 20: yy_state = 133; break yy_forNext;
                default: break yy_forAction;
              }

            case 133:
              switch (yy_input) {
                case 14: yy_state = 145; break yy_forNext;
                case 24: yy_state = 146; break yy_forNext;
                default: break yy_forAction;
              }

            case 134:
              switch (yy_input) {
                case 14: yy_state = 135; break yy_forNext;
                case 23: yy_isFinal = true; yy_state = 147; break yy_forNext;
                default: break yy_forAction;
              }

            case 135:
              switch (yy_input) {
                case 23: yy_isFinal = true; yy_state = 147; break yy_forNext;
                default: break yy_forAction;
              }

            case 136:
              switch (yy_input) {
                case 14: yy_isFinal = true; yy_noLookAhead = true; yy_state = 148; break yy_forNext;
                case 0: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 26: 
                case 27: 
                case 30: 
                case 38: 
                case 46: 
                case 47: break yy_forAction;
                default: yy_isFinal = true; yy_state = 53; break yy_forNext;
              }

            case 137:
              switch (yy_input) {
                case 20: yy_state = 138; break yy_forNext;
                default: break yy_forAction;
              }

            case 138:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_isFinal = true; yy_state = 149; break yy_forNext;
                case 14: yy_state = 150; break yy_forNext;
                default: break yy_forAction;
              }

            case 139:
              switch (yy_input) {
                case 40: yy_state = 140; break yy_forNext;
                default: break yy_forAction;
              }

            case 140:
              switch (yy_input) {
                case 14: yy_state = 151; break yy_forNext;
                case 41: yy_state = 152; break yy_forNext;
                default: break yy_forAction;
              }

            case 141:
              switch (yy_input) {
                case 14: yy_state = 153; break yy_forNext;
                case 21: yy_state = 154; break yy_forNext;
                default: break yy_forAction;
              }

            case 142:
              switch (yy_input) {
                case 11: yy_state = 141; break yy_forNext;
                default: break yy_forAction;
              }

            case 143:
              switch (yy_input) {
                case 25: yy_state = 144; break yy_forNext;
                default: break yy_forAction;
              }

            case 144:
              switch (yy_input) {
                case 14: yy_state = 155; break yy_forNext;
                case 21: yy_state = 156; break yy_forNext;
                default: break yy_forAction;
              }

            case 145:
              switch (yy_input) {
                case 24: yy_state = 146; break yy_forNext;
                default: break yy_forAction;
              }

            case 146:
              switch (yy_input) {
                case 14: yy_state = 157; break yy_forNext;
                case 25: yy_state = 158; break yy_forNext;
                default: break yy_forAction;
              }

            case 147:
              switch (yy_input) {
                case 14: yy_isFinal = true; yy_noLookAhead = true; yy_state = 148; break yy_forNext;
                default: break yy_forAction;
              }

            case 149:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_isFinal = true; yy_state = 149; break yy_forNext;
                case 14: yy_isFinal = true; yy_state = 159; break yy_forNext;
                default: break yy_forAction;
              }

            case 150:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_isFinal = true; yy_state = 149; break yy_forNext;
                case 14: yy_state = 160; break yy_forNext;
                default: break yy_forAction;
              }

            case 151:
              switch (yy_input) {
                case 41: yy_state = 152; break yy_forNext;
                default: break yy_forAction;
              }

            case 152:
              switch (yy_input) {
                case 14: yy_state = 161; break yy_forNext;
                case 24: yy_state = 162; break yy_forNext;
                default: break yy_forAction;
              }

            case 153:
              switch (yy_input) {
                case 21: yy_state = 154; break yy_forNext;
                default: break yy_forAction;
              }

            case 154:
              switch (yy_input) {
                case 14: yy_state = 163; break yy_forNext;
                case 42: yy_state = 164; break yy_forNext;
                default: break yy_forAction;
              }

            case 155:
              switch (yy_input) {
                case 21: yy_state = 156; break yy_forNext;
                default: break yy_forAction;
              }

            case 156:
              switch (yy_input) {
                case 14: yy_state = 165; break yy_forNext;
                case 22: yy_state = 166; break yy_forNext;
                default: break yy_forAction;
              }

            case 157:
              switch (yy_input) {
                case 25: yy_state = 158; break yy_forNext;
                default: break yy_forAction;
              }

            case 158:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 158; break yy_forNext;
                case 14: yy_state = 167; break yy_forNext;
                case 15: yy_state = 168; break yy_forNext;
                default: break yy_forAction;
              }

            case 159:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_isFinal = true; yy_state = 149; break yy_forNext;
                case 14: yy_state = 160; break yy_forNext;
                default: break yy_forAction;
              }

            case 160:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_isFinal = true; yy_state = 149; break yy_forNext;
                default: break yy_forAction;
              }

            case 161:
              switch (yy_input) {
                case 24: yy_state = 162; break yy_forNext;
                default: break yy_forAction;
              }

            case 162:
              switch (yy_input) {
                case 14: yy_state = 169; break yy_forNext;
                case 35: yy_state = 170; break yy_forNext;
                default: break yy_forAction;
              }

            case 163:
              switch (yy_input) {
                case 42: yy_state = 164; break yy_forNext;
                default: break yy_forAction;
              }

            case 164:
              switch (yy_input) {
                case 14: yy_state = 171; break yy_forNext;
                case 43: yy_state = 172; break yy_forNext;
                default: break yy_forAction;
              }

            case 165:
              switch (yy_input) {
                case 22: yy_state = 166; break yy_forNext;
                default: break yy_forAction;
              }

            case 166:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 166; break yy_forNext;
                case 14: yy_state = 173; break yy_forNext;
                case 15: yy_isFinal = true; yy_state = 174; break yy_forNext;
                default: break yy_forAction;
              }

            case 167:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 158; break yy_forNext;
                case 15: yy_state = 168; break yy_forNext;
                case 14: yy_state = 175; break yy_forNext;
                default: break yy_forAction;
              }

            case 168:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 168; break yy_forNext;
                case 14: yy_state = 176; break yy_forNext;
                case 26: 
                case 27: yy_state = 177; break yy_forNext;
                default: break yy_forAction;
              }

            case 169:
              switch (yy_input) {
                case 35: yy_state = 170; break yy_forNext;
                default: break yy_forAction;
              }

            case 170:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 170; break yy_forNext;
                case 14: yy_state = 178; break yy_forNext;
                case 15: yy_isFinal = true; yy_state = 179; break yy_forNext;
                default: break yy_forAction;
              }

            case 171:
              switch (yy_input) {
                case 43: yy_state = 172; break yy_forNext;
                default: break yy_forAction;
              }

            case 172:
              switch (yy_input) {
                case 14: yy_state = 180; break yy_forNext;
                case 41: yy_state = 181; break yy_forNext;
                default: break yy_forAction;
              }

            case 173:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 166; break yy_forNext;
                case 15: yy_isFinal = true; yy_state = 174; break yy_forNext;
                case 14: yy_state = 182; break yy_forNext;
                default: break yy_forAction;
              }

            case 174:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_isFinal = true; yy_state = 183; break yy_forNext;
                case 14: yy_state = 184; break yy_forNext;
                default: break yy_forAction;
              }

            case 175:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 158; break yy_forNext;
                case 15: yy_state = 168; break yy_forNext;
                default: break yy_forAction;
              }

            case 176:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 168; break yy_forNext;
                case 26: 
                case 27: yy_state = 177; break yy_forNext;
                case 14: yy_state = 185; break yy_forNext;
                default: break yy_forAction;
              }

            case 177:
              switch (yy_input) {
                case 14: yy_state = 186; break yy_forNext;
                case 28: yy_state = 187; break yy_forNext;
                default: break yy_forAction;
              }

            case 178:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 170; break yy_forNext;
                case 15: yy_isFinal = true; yy_state = 179; break yy_forNext;
                case 14: yy_state = 188; break yy_forNext;
                default: break yy_forAction;
              }

            case 179:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_isFinal = true; yy_state = 189; break yy_forNext;
                case 14: yy_state = 190; break yy_forNext;
                default: break yy_forAction;
              }

            case 180:
              switch (yy_input) {
                case 41: yy_state = 181; break yy_forNext;
                default: break yy_forAction;
              }

            case 181:
              switch (yy_input) {
                case 14: yy_state = 191; break yy_forNext;
                case 44: yy_state = 192; break yy_forNext;
                default: break yy_forAction;
              }

            case 182:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 166; break yy_forNext;
                default: break yy_forAction;
              }

            case 183:
              switch (yy_input) {
                case 14: yy_isFinal = true; yy_state = 174; break yy_forNext;
                case 6: 
                case 7: 
                case 13: yy_isFinal = true; yy_state = 183; break yy_forNext;
                default: break yy_forAction;
              }

            case 184:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_isFinal = true; yy_state = 183; break yy_forNext;
                default: break yy_forAction;
              }

            case 185:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 168; break yy_forNext;
                case 26: 
                case 27: yy_state = 177; break yy_forNext;
                default: break yy_forAction;
              }

            case 186:
              switch (yy_input) {
                case 28: yy_state = 187; break yy_forNext;
                case 14: yy_state = 193; break yy_forNext;
                default: break yy_forAction;
              }

            case 187:
              switch (yy_input) {
                case 14: yy_state = 194; break yy_forNext;
                case 22: yy_state = 195; break yy_forNext;
                default: break yy_forAction;
              }

            case 188:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 170; break yy_forNext;
                default: break yy_forAction;
              }

            case 189:
              switch (yy_input) {
                case 14: yy_isFinal = true; yy_state = 179; break yy_forNext;
                case 6: 
                case 7: 
                case 13: yy_isFinal = true; yy_state = 189; break yy_forNext;
                default: break yy_forAction;
              }

            case 190:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_isFinal = true; yy_state = 189; break yy_forNext;
                default: break yy_forAction;
              }

            case 191:
              switch (yy_input) {
                case 44: yy_state = 192; break yy_forNext;
                default: break yy_forAction;
              }

            case 192:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 192; break yy_forNext;
                case 14: yy_state = 196; break yy_forNext;
                case 15: yy_state = 197; break yy_forNext;
                default: break yy_forAction;
              }

            case 193:
              switch (yy_input) {
                case 28: yy_state = 187; break yy_forNext;
                default: break yy_forAction;
              }

            case 194:
              switch (yy_input) {
                case 22: yy_state = 195; break yy_forNext;
                default: break yy_forAction;
              }

            case 195:
              switch (yy_input) {
                case 14: yy_state = 198; break yy_forNext;
                case 22: yy_state = 199; break yy_forNext;
                default: break yy_forAction;
              }

            case 196:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 192; break yy_forNext;
                case 15: yy_state = 197; break yy_forNext;
                case 14: yy_state = 200; break yy_forNext;
                default: break yy_forAction;
              }

            case 197:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 201; break yy_forNext;
                case 14: yy_state = 202; break yy_forNext;
                case 26: yy_state = 203; break yy_forNext;
                case 39: yy_state = 204; break yy_forNext;
                default: break yy_forAction;
              }

            case 198:
              switch (yy_input) {
                case 22: yy_state = 199; break yy_forNext;
                default: break yy_forAction;
              }

            case 199:
              switch (yy_input) {
                case 14: yy_state = 205; break yy_forNext;
                case 29: yy_state = 206; break yy_forNext;
                default: break yy_forAction;
              }

            case 200:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 192; break yy_forNext;
                default: break yy_forAction;
              }

            case 201:
              switch (yy_input) {
                case 14: yy_state = 197; break yy_forNext;
                case 6: 
                case 7: 
                case 13: yy_state = 201; break yy_forNext;
                case 26: yy_state = 203; break yy_forNext;
                case 39: yy_state = 204; break yy_forNext;
                default: break yy_forAction;
              }

            case 202:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 201; break yy_forNext;
                case 26: yy_state = 203; break yy_forNext;
                case 39: yy_state = 204; break yy_forNext;
                case 14: yy_state = 207; break yy_forNext;
                default: break yy_forAction;
              }

            case 203:
              switch (yy_input) {
                case 39: yy_state = 204; break yy_forNext;
                case 14: yy_state = 207; break yy_forNext;
                default: break yy_forAction;
              }

            case 204:
              switch (yy_input) {
                case 14: yy_state = 208; break yy_forNext;
                case 33: yy_state = 209; break yy_forNext;
                default: break yy_forAction;
              }

            case 205:
              switch (yy_input) {
                case 29: yy_state = 206; break yy_forNext;
                default: break yy_forAction;
              }

            case 206:
              switch (yy_input) {
                case 12: yy_state = 210; break yy_forNext;
                case 14: yy_state = 211; break yy_forNext;
                default: break yy_forAction;
              }

            case 207:
              switch (yy_input) {
                case 39: yy_state = 204; break yy_forNext;
                case 14: yy_state = 212; break yy_forNext;
                default: break yy_forAction;
              }

            case 208:
              switch (yy_input) {
                case 33: yy_state = 209; break yy_forNext;
                default: break yy_forAction;
              }

            case 209:
              switch (yy_input) {
                case 14: yy_state = 213; break yy_forNext;
                case 24: yy_state = 214; break yy_forNext;
                default: break yy_forAction;
              }

            case 210:
              switch (yy_input) {
                case 14: yy_state = 215; break yy_forNext;
                case 30: yy_state = 216; break yy_forNext;
                default: break yy_forAction;
              }

            case 211:
              switch (yy_input) {
                case 12: yy_state = 210; break yy_forNext;
                default: break yy_forAction;
              }

            case 212:
              switch (yy_input) {
                case 39: yy_state = 204; break yy_forNext;
                default: break yy_forAction;
              }

            case 213:
              switch (yy_input) {
                case 24: yy_state = 214; break yy_forNext;
                default: break yy_forAction;
              }

            case 214:
              switch (yy_input) {
                case 14: yy_state = 217; break yy_forNext;
                case 22: yy_state = 218; break yy_forNext;
                default: break yy_forAction;
              }

            case 215:
              switch (yy_input) {
                case 30: yy_state = 216; break yy_forNext;
                default: break yy_forAction;
              }

            case 216:
              switch (yy_input) {
                case 14: yy_state = 219; break yy_forNext;
                case 30: yy_state = 220; break yy_forNext;
                default: break yy_forAction;
              }

            case 217:
              switch (yy_input) {
                case 22: yy_state = 218; break yy_forNext;
                default: break yy_forAction;
              }

            case 218:
              switch (yy_input) {
                case 14: yy_state = 221; break yy_forNext;
                case 21: yy_state = 222; break yy_forNext;
                default: break yy_forAction;
              }

            case 219:
              switch (yy_input) {
                case 30: yy_state = 220; break yy_forNext;
                default: break yy_forAction;
              }

            case 220:
              switch (yy_input) {
                case 14: yy_state = 223; break yy_forNext;
                case 31: yy_state = 224; break yy_forNext;
                default: break yy_forAction;
              }

            case 221:
              switch (yy_input) {
                case 21: yy_state = 222; break yy_forNext;
                default: break yy_forAction;
              }

            case 222:
              switch (yy_input) {
                case 14: yy_state = 225; break yy_forNext;
                case 24: yy_state = 226; break yy_forNext;
                default: break yy_forAction;
              }

            case 223:
              switch (yy_input) {
                case 31: yy_state = 224; break yy_forNext;
                default: break yy_forAction;
              }

            case 224:
              switch (yy_input) {
                case 14: yy_state = 227; break yy_forNext;
                case 31: yy_state = 228; break yy_forNext;
                default: break yy_forAction;
              }

            case 225:
              switch (yy_input) {
                case 24: yy_state = 226; break yy_forNext;
                default: break yy_forAction;
              }

            case 226:
              switch (yy_input) {
                case 14: yy_state = 229; break yy_forNext;
                case 22: yy_state = 230; break yy_forNext;
                default: break yy_forAction;
              }

            case 227:
              switch (yy_input) {
                case 31: yy_state = 228; break yy_forNext;
                default: break yy_forAction;
              }

            case 228:
              switch (yy_input) {
                case 14: yy_state = 231; break yy_forNext;
                case 31: yy_state = 232; break yy_forNext;
                default: break yy_forAction;
              }

            case 229:
              switch (yy_input) {
                case 22: yy_state = 230; break yy_forNext;
                default: break yy_forAction;
              }

            case 230:
              switch (yy_input) {
                case 11: yy_state = 233; break yy_forNext;
                case 14: yy_state = 234; break yy_forNext;
                default: break yy_forAction;
              }

            case 231:
              switch (yy_input) {
                case 31: yy_state = 232; break yy_forNext;
                default: break yy_forAction;
              }

            case 232:
              switch (yy_input) {
                case 10: yy_state = 235; break yy_forNext;
                case 14: yy_state = 236; break yy_forNext;
                default: break yy_forAction;
              }

            case 233:
              switch (yy_input) {
                case 14: yy_state = 237; break yy_forNext;
                case 22: yy_state = 238; break yy_forNext;
                default: break yy_forAction;
              }

            case 234:
              switch (yy_input) {
                case 11: yy_state = 233; break yy_forNext;
                default: break yy_forAction;
              }

            case 235:
              switch (yy_input) {
                case 14: yy_state = 239; break yy_forNext;
                case 31: yy_state = 240; break yy_forNext;
                default: break yy_forAction;
              }

            case 236:
              switch (yy_input) {
                case 10: yy_state = 235; break yy_forNext;
                default: break yy_forAction;
              }

            case 237:
              switch (yy_input) {
                case 22: yy_state = 238; break yy_forNext;
                default: break yy_forAction;
              }

            case 238:
              switch (yy_input) {
                case 14: yy_state = 241; break yy_forNext;
                case 45: yy_state = 242; break yy_forNext;
                default: break yy_forAction;
              }

            case 239:
              switch (yy_input) {
                case 31: yy_state = 240; break yy_forNext;
                default: break yy_forAction;
              }

            case 240:
              switch (yy_input) {
                case 14: yy_state = 243; break yy_forNext;
                case 32: yy_state = 244; break yy_forNext;
                default: break yy_forAction;
              }

            case 241:
              switch (yy_input) {
                case 45: yy_state = 242; break yy_forNext;
                default: break yy_forAction;
              }

            case 242:
              switch (yy_input) {
                case 14: yy_state = 245; break yy_forNext;
                case 29: yy_state = 246; break yy_forNext;
                default: break yy_forAction;
              }

            case 243:
              switch (yy_input) {
                case 32: yy_state = 244; break yy_forNext;
                default: break yy_forAction;
              }

            case 244:
              switch (yy_input) {
                case 10: yy_state = 247; break yy_forNext;
                case 14: yy_state = 248; break yy_forNext;
                default: break yy_forAction;
              }

            case 245:
              switch (yy_input) {
                case 29: yy_state = 246; break yy_forNext;
                default: break yy_forAction;
              }

            case 246:
              switch (yy_input) {
                case 14: yy_state = 249; break yy_forNext;
                case 21: yy_state = 250; break yy_forNext;
                default: break yy_forAction;
              }

            case 247:
              switch (yy_input) {
                case 14: yy_state = 251; break yy_forNext;
                case 33: yy_state = 252; break yy_forNext;
                default: break yy_forAction;
              }

            case 248:
              switch (yy_input) {
                case 10: yy_state = 247; break yy_forNext;
                default: break yy_forAction;
              }

            case 249:
              switch (yy_input) {
                case 21: yy_state = 250; break yy_forNext;
                default: break yy_forAction;
              }

            case 250:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 253; break yy_forNext;
                case 14: yy_state = 254; break yy_forNext;
                case 26: yy_state = 255; break yy_forNext;
                default: break yy_forAction;
              }

            case 251:
              switch (yy_input) {
                case 33: yy_state = 252; break yy_forNext;
                default: break yy_forAction;
              }

            case 252:
              switch (yy_input) {
                case 14: yy_state = 256; break yy_forNext;
                case 34: yy_state = 257; break yy_forNext;
                default: break yy_forAction;
              }

            case 253:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 253; break yy_forNext;
                case 14: yy_state = 258; break yy_forNext;
                case 39: yy_state = 259; break yy_forNext;
                default: break yy_forAction;
              }

            case 254:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 253; break yy_forNext;
                case 26: yy_state = 255; break yy_forNext;
                case 14: yy_state = 260; break yy_forNext;
                default: break yy_forAction;
              }

            case 255:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 253; break yy_forNext;
                case 14: yy_state = 260; break yy_forNext;
                default: break yy_forAction;
              }

            case 256:
              switch (yy_input) {
                case 34: yy_state = 257; break yy_forNext;
                default: break yy_forAction;
              }

            case 257:
              switch (yy_input) {
                case 14: yy_state = 261; break yy_forNext;
                case 35: yy_state = 262; break yy_forNext;
                default: break yy_forAction;
              }

            case 258:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 253; break yy_forNext;
                case 39: yy_state = 259; break yy_forNext;
                case 14: yy_state = 263; break yy_forNext;
                default: break yy_forAction;
              }

            case 259:
              switch (yy_input) {
                case 14: yy_state = 264; break yy_forNext;
                case 33: yy_state = 265; break yy_forNext;
                default: break yy_forAction;
              }

            case 260:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 253; break yy_forNext;
                case 14: yy_state = 266; break yy_forNext;
                default: break yy_forAction;
              }

            case 261:
              switch (yy_input) {
                case 35: yy_state = 262; break yy_forNext;
                default: break yy_forAction;
              }

            case 262:
              switch (yy_input) {
                case 14: yy_state = 267; break yy_forNext;
                case 30: yy_state = 268; break yy_forNext;
                default: break yy_forAction;
              }

            case 263:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 253; break yy_forNext;
                case 39: yy_state = 259; break yy_forNext;
                default: break yy_forAction;
              }

            case 264:
              switch (yy_input) {
                case 33: yy_state = 265; break yy_forNext;
                default: break yy_forAction;
              }

            case 265:
              switch (yy_input) {
                case 14: yy_state = 269; break yy_forNext;
                case 24: yy_state = 270; break yy_forNext;
                default: break yy_forAction;
              }

            case 266:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 253; break yy_forNext;
                default: break yy_forAction;
              }

            case 267:
              switch (yy_input) {
                case 30: yy_state = 268; break yy_forNext;
                default: break yy_forAction;
              }

            case 268:
              switch (yy_input) {
                case 14: yy_state = 271; break yy_forNext;
                case 36: yy_state = 272; break yy_forNext;
                default: break yy_forAction;
              }

            case 269:
              switch (yy_input) {
                case 24: yy_state = 270; break yy_forNext;
                default: break yy_forAction;
              }

            case 270:
              switch (yy_input) {
                case 14: yy_state = 273; break yy_forNext;
                case 22: yy_state = 274; break yy_forNext;
                default: break yy_forAction;
              }

            case 271:
              switch (yy_input) {
                case 36: yy_state = 272; break yy_forNext;
                default: break yy_forAction;
              }

            case 272:
              switch (yy_input) {
                case 14: yy_state = 275; break yy_forNext;
                case 37: yy_state = 276; break yy_forNext;
                default: break yy_forAction;
              }

            case 273:
              switch (yy_input) {
                case 22: yy_state = 274; break yy_forNext;
                default: break yy_forAction;
              }

            case 274:
              switch (yy_input) {
                case 14: yy_state = 277; break yy_forNext;
                case 21: yy_state = 278; break yy_forNext;
                default: break yy_forAction;
              }

            case 275:
              switch (yy_input) {
                case 37: yy_state = 276; break yy_forNext;
                default: break yy_forAction;
              }

            case 276:
              switch (yy_input) {
                case 14: yy_state = 279; break yy_forNext;
                case 37: yy_state = 280; break yy_forNext;
                default: break yy_forAction;
              }

            case 277:
              switch (yy_input) {
                case 21: yy_state = 278; break yy_forNext;
                default: break yy_forAction;
              }

            case 278:
              switch (yy_input) {
                case 14: yy_state = 281; break yy_forNext;
                case 24: yy_state = 282; break yy_forNext;
                default: break yy_forAction;
              }

            case 279:
              switch (yy_input) {
                case 37: yy_state = 280; break yy_forNext;
                default: break yy_forAction;
              }

            case 280:
              switch (yy_input) {
                case 14: yy_state = 283; break yy_forNext;
                case 37: yy_state = 284; break yy_forNext;
                default: break yy_forAction;
              }

            case 281:
              switch (yy_input) {
                case 24: yy_state = 282; break yy_forNext;
                default: break yy_forAction;
              }

            case 282:
              switch (yy_input) {
                case 14: yy_state = 285; break yy_forNext;
                case 22: yy_state = 286; break yy_forNext;
                default: break yy_forAction;
              }

            case 283:
              switch (yy_input) {
                case 37: yy_state = 284; break yy_forNext;
                default: break yy_forAction;
              }

            case 284:
              switch (yy_input) {
                case 14: yy_state = 287; break yy_forNext;
                case 30: yy_state = 288; break yy_forNext;
                default: break yy_forAction;
              }

            case 285:
              switch (yy_input) {
                case 22: yy_state = 286; break yy_forNext;
                default: break yy_forAction;
              }

            case 286:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 286; break yy_forNext;
                case 14: yy_state = 289; break yy_forNext;
                case 15: yy_isFinal = true; yy_state = 290; break yy_forNext;
                default: break yy_forAction;
              }

            case 287:
              switch (yy_input) {
                case 30: yy_state = 288; break yy_forNext;
                default: break yy_forAction;
              }

            case 288:
              switch (yy_input) {
                case 14: yy_state = 291; break yy_forNext;
                case 18: yy_state = 292; break yy_forNext;
                default: break yy_forAction;
              }

            case 289:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 286; break yy_forNext;
                case 15: yy_isFinal = true; yy_state = 290; break yy_forNext;
                case 14: yy_state = 293; break yy_forNext;
                default: break yy_forAction;
              }

            case 290:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_isFinal = true; yy_state = 294; break yy_forNext;
                case 14: yy_state = 295; break yy_forNext;
                default: break yy_forAction;
              }

            case 291:
              switch (yy_input) {
                case 18: yy_state = 292; break yy_forNext;
                default: break yy_forAction;
              }

            case 292:
              switch (yy_input) {
                case 14: yy_state = 296; break yy_forNext;
                case 28: yy_state = 297; break yy_forNext;
                default: break yy_forAction;
              }

            case 293:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_state = 286; break yy_forNext;
                default: break yy_forAction;
              }

            case 294:
              switch (yy_input) {
                case 14: yy_isFinal = true; yy_state = 290; break yy_forNext;
                case 6: 
                case 7: 
                case 13: yy_isFinal = true; yy_state = 294; break yy_forNext;
                default: break yy_forAction;
              }

            case 295:
              switch (yy_input) {
                case 6: 
                case 7: 
                case 13: yy_isFinal = true; yy_state = 294; break yy_forNext;
                default: break yy_forAction;
              }

            case 296:
              switch (yy_input) {
                case 28: yy_state = 297; break yy_forNext;
                default: break yy_forAction;
              }

            case 297:
              switch (yy_input) {
                case 14: yy_state = 298; break yy_forNext;
                case 22: yy_state = 299; break yy_forNext;
                default: break yy_forAction;
              }

            case 298:
              switch (yy_input) {
                case 22: yy_state = 299; break yy_forNext;
                default: break yy_forAction;
              }

            case 299:
              switch (yy_input) {
                case 14: yy_state = 300; break yy_forNext;
                case 19: yy_state = 301; break yy_forNext;
                default: break yy_forAction;
              }

            case 300:
              switch (yy_input) {
                case 19: yy_state = 301; break yy_forNext;
                default: break yy_forAction;
              }

            case 301:
              switch (yy_input) {
                case 14: yy_state = 302; break yy_forNext;
                case 20: yy_isFinal = true; yy_state = 303; break yy_forNext;
                default: break yy_forAction;
              }

            case 302:
              switch (yy_input) {
                case 20: yy_isFinal = true; yy_state = 303; break yy_forNext;
                default: break yy_forAction;
              }

            case 303:
              switch (yy_input) {
                case 14: yy_isFinal = true; yy_noLookAhead = true; yy_state = 304; break yy_forNext;
                default: break yy_forAction;
              }

            default:
              yy_ScanError(YY_ILLEGAL_STATE);
              break;
          } }

          if ( yy_isFinal ) {
            yy_was_pushback = yy_pushback;
            yy_action = yy_state; 
            yy_markedPos = yy_currentPos; 
            if ( yy_noLookAhead ) break yy_forAction;
          }

        }
      }

      if (yy_was_pushback)
        yy_markedPos = yy_pushbackPos;

      switch (yy_action) {    

        case 91: 
        case 119: 
          {  yypushback(yylength()); popState(); valueText = string.toString(); return EncodingParserConstants.InvalidTerminatedStringValue; }
        case 306: break;
        case 74: 
        case 112: 
          {  yybegin(YYINITIAL); if (foundContentTypeValue) hasMore = false; return HTMLHeadTokenizerConstants.MetaTagEnd; }
        case 307: break;
        case 38: 
        case 88: 
          {  yypushback(yylength());popState(); valueText = string.toString(); return EncodingParserConstants.InvalidTerminatedStringValue; }
        case 308: break;
        case 31: 
        case 32: 
        case 34: 
        case 85: 
        case 118: 
          {  yypushback(1); yybegin(UnDelimitedString); string.setLength(0); }
        case 309: break;
        case 30: 
        case 83: 
          {  yybegin(YYINITIAL); isDocumentRootElementChecked = true; return HTMLHeadTokenizerConstants.RootElementTagEnd; }
        case 310: break;
        case 25: 
        case 75: 
          {  yybegin(YYINITIAL);  if (foundContentTypeValue) hasMore = false; return HTMLHeadTokenizerConstants.MetaTagEnd; }
        case 311: break;
        case 46: 
        case 96: 
          {  yypushback(yylength());popState(); valueText = string.toString(); return EncodingParserConstants.InvalidTermintatedUnDelimitedStringValue; }
        case 312: break;
        case 149: 
        case 159: 
          { if (yychar == 0 ) {yybegin(ST_XMLDecl); return XMLHeadTokenizerConstants.XMLDeclStart;} }
        case 313: break;
        case 10: 
        case 11: 
        case 12: 
        case 13: 
        case 14: 
        case 15: 
        case 16: 
        case 17: 
        case 18: 
        case 19: 
        case 20: 
        case 21: 
        case 22: 
        case 23: 
        case 24: 
        case 26: 
        case 27: 
        case 28: 
        case 29: 
        case 33: 
        case 39: 
        case 42: 
        case 45: 
          { if(yychar > MAX_TO_SCAN) {hasMore=false; return EncodingParserConstants.MAX_CHARS_REACHED;} }
        case 314: break;
        case 136: 
        case 147: 
        case 148: 
          { yybegin(ST_META_TAG); return HTMLHeadTokenizerConstants.MetaTagStart; }
        case 315: break;
        case 65: 
        case 107: 
          { yybegin(YYINITIAL);  return XMLHeadTokenizerConstants.XMLDeclEnd; }
        case 316: break;
        case 290: 
        case 294: 
          { pushCurrentState(); yybegin(QuotedAttributeValue); foundContentTypeValue=true; return HTMLHeadTokenizerConstants.MetaTagContentType; }
        case 317: break;
        case 179: 
        case 189: 
          { pushCurrentState(); yybegin(QuotedAttributeValue); this.isXHTML = true; return XMLHeadTokenizerConstants.XMLDelEncoding; }
        case 318: break;
        case 174: 
        case 183: 
          { pushCurrentState(); yybegin(QuotedAttributeValue); foundContentTypeValue=true; hasCharsetAttr=true; return HTMLHeadTokenizerConstants.MetaTagContentType; }
        case 319: break;
        case 303: 
        case 304: 
          { isXHTML = true; }
        case 320: break;
        case 99: 
          { hasMore = false; return EncodingParserConstants.UTF83ByteBOM; }
        case 321: break;
        case 49: 
          { hasMore = false; return EncodingParserConstants.UTF16BE; }
        case 322: break;
        case 50: 
          { hasMore = false; return EncodingParserConstants.UTF16LE; }
        case 323: break;
        case 37: 
        case 40: 
        case 43: 
          {  string.append( yytext() );  }
        case 324: break;
        case 36: 
        case 87: 
          {  yybegin(SQ_STRING); string.setLength(0);  }
        case 325: break;
        case 35: 
        case 86: 
          {  yybegin(DQ_STRING); string.setLength(0);  }
        case 326: break;
        case 41: 
        case 92: 
          {  popState(); valueText = string.toString(); return EncodingParserConstants.StringValue;  }
        case 327: break;
        case 44: 
        case 95: 
          {  yypushback(yylength());popState(); valueText = string.toString(); return EncodingParserConstants.UnDelimitedStringValue;  }
        case 328: break;
        case 47: 
        case 97: 
        case 120: 
          {  pushCurrentState(); yybegin(UnDelimitedCharset); string.append( yytext() );  }
        case 329: break;
        case 53: 
        case 55: 
        case 102: 
        case 123: 
          {  if (!isDocumentRootElementChecked()){yybegin(ST_XMLNameSpace); return HTMLHeadTokenizerConstants.DocumentRootNameSpace;} }
        case 330: break;
        case 48: 
          { yypushback(1); popState();  }
        case 331: break;
        default: 
          if (yy_input == YYEOF && yy_startRead == yy_currentPos) {
            yy_atEOF = true;
            yy_do_eof();
              { hasMore = false; return EncodingParserConstants.EOF; }
          } 
          else {
            yy_ScanError(YY_NO_MATCH);
          }
      }
    }
  }    


}
