# -*- coding: utf-8 -*-
"""
    Constants
    ~~~~~~~~~

    :copyright: Copyright 2019 Autodesk, Inc.
    :license: MIT, see LICENSE for details.
"""
TEXT_ALIGN_LEFT = 'left'
TEXT_ALIGN_CENTER = 'center'
TEXT_ALIGN_RIGHT = 'right'
ALLOWED_ALIGNS = (
    TEXT_ALIGN_LEFT,
    TEXT_ALIGN_RIGHT,
    TEXT_ALIGN_CENTER,
)

TEXT_BASELINE_TOP = 'top'
TEXT_BASELINE_MIDDLE = 'middle'
TEXT_BASELINE_BOTTOM = 'bottom'
ALLOWED_BASELINES = (
    TEXT_BASELINE_TOP,
    TEXT_BASELINE_MIDDLE,
    TEXT_BASELINE_BOTTOM,
)

DEFAULT_CONTENT = ''
DEFAULT_FONT_SIZE = 12
DEFAULT_LINE_SPACING = 1.2

DEFAULT_STROKE_WIDTH = 1
DEFAULT_BORDER_STYLE = 'S'

LINE_CAP_BUTT = 0
LINE_CAP_ROUND = 1
LINE_CAP_SQUARE = 2
ALLOWED_LINE_CAPS = (
    LINE_CAP_BUTT,
    LINE_CAP_ROUND,
    LINE_CAP_SQUARE,
)

LINE_JOIN_MITER = 0
LINE_JOIN_ROUND = 1
LINE_JOIN_BEVEL = 2
ALLOWED_LINE_JOINS = (
    LINE_JOIN_MITER,
    LINE_JOIN_ROUND,
    LINE_JOIN_BEVEL,
)

BLACK = (0, 0, 0)
TRANSPARENT = tuple()

GRAPHICS_STATE_NAME = 'PdfAnnotatorGS'
DEFAULT_BASE_FONT = 'Helvetica'
PDF_ANNOTATOR_FONT = 'PDFANNOTATORFONT1'

CMYK_MODE = 'CMYK'
RGB_MODE = 'RGB'
RGBA_MODE = 'RGBA'
PALETTE_MODE = 'P'
GRAYSCALE_MODE = 'L'
GRAYSCALE_ALPHA_MODE = 'LA'
SINGLE_CHANNEL_MODE = '1'
