/*
 * $Id: conn_atx.c,v 1.13 2012-02-22 09:27:20 siflkres Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "conn_atx.h"

struct cpssp {
	struct sig_std_logic_merge *forward_n_ps_on;
	struct sig_boolean_merge *forward__plus_5Vsb;
	struct sig_boolean_merge *forward_pwr_ok;
	struct sig_boolean_merge *forward__plus_3_3V;
	struct sig_boolean_merge *forward__plus_5V;
	struct sig_boolean_merge *forward__minus_5V;
	struct sig_boolean_merge *forward__plus_12V;
	struct sig_boolean_merge *forward__minus_12V;
	struct sig_boolean_merge *forward_gnd;
};

void *
conn_atx_create(
	const char *name,
	struct sig_manage *port_manage,

	struct sig_power_board *port_ext,

	struct sig_std_logic *port_n_ps_on,
	struct sig_boolean *port__plus_5Vsb,
	struct sig_boolean *port_pwr_ok,
	struct sig_boolean *port__plus_3_3V,
	struct sig_boolean *port__plus_5V,
	struct sig_boolean *port__minus_5V,
	struct sig_boolean *port__plus_12V,
	struct sig_boolean *port__minus_12V,
	struct sig_boolean *port_gnd
)
{
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->forward_n_ps_on = sig_std_logic_merge(
			port_n_ps_on, port_ext->n_ps_on);
	cpssp->forward__plus_5Vsb = sig_boolean_merge(
			port_ext->_plus_5Vsb, port__plus_5Vsb);
	cpssp->forward_pwr_ok = sig_boolean_merge(
			port_ext->pwr_ok, port_pwr_ok);
	cpssp->forward__plus_3_3V = sig_boolean_merge(
			port_ext->_plus_3_3V, port__plus_3_3V);
	cpssp->forward__plus_5V = sig_boolean_merge(
			port_ext->_plus_5V, port__plus_5V);
	cpssp->forward__minus_5V = sig_boolean_merge(
			port_ext->_minus_5V, port__minus_5V);
	cpssp->forward__plus_12V = sig_boolean_merge(
			port_ext->_plus_12V, port__plus_12V);
	cpssp->forward__minus_12V = sig_boolean_merge(
			port_ext->_minus_12V, port__minus_12V);
	cpssp->forward_gnd = sig_boolean_merge(
			port_ext->gnd, port_gnd);

	return cpssp;
}

void
conn_atx_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
conn_atx_suspend(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
conn_atx_resume(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
}
