/* $Id: food.h,v 1.10 2003/05/28 11:15:56 paul Exp $ */

#ifndef FFRENZY_FOOD_H
#define FFRENZY_FOOD_H

#include "global.h"
#include "model.h"

/** \file
 * Food object specific functions and defines.
 */

/* Food settings */
#define FD_INC_LIFE        300 /**< Player life increase on food deliver. */
#define FD_INIT_SPAWN      4   /**< Food objects to spawn per participating
                                    player and start of game. */

/* Food mechanics settings */
#define FD_X_MAX_SPEED     200 /**< Maximum speed of food objects. */
#define FD_X_SPEED_DISOWN  3   /**< Minimum speed for food to keep owner. */

#define FD_X_SPEED_THROW   100 /**< Initial X speed when food object thrown. */
#define FD_Y_SPEED_THROW   45  /**< Initial Y speed when food object thrown. */

#define FD_X_FRICT_GROUND  10  /**< Ground friction for food object. */
#define FD_X_FRICT_AIR     2   /**< Air friction for food object. */

/* Food powerup settings */
#define BAN_X_SPEED_MUL    2   /**< Banana powerup speed multiplication. */
#define BAN_X_ACCEL_BOOMR  20  /**< Banana powerup acceleration for boomrang. */

#define PMK_X_SPEED_MUL    2   /**< Pumpkin powerup speed multiplication. */
#define PMK_X_BOUNCINESS   3   /**< Pumpkin powerup vertical bounciness. */
#define PMK_X_FRICT_GROUND 1   /**< Pumpkin powerup ground friction. */

#define CCB_X_SPEED_MUL    2   /**< Cucumber powerup speed multiplication. */

#define ORA_X_SPEED_MUL    5   /**< Orange powerup speed multiplication. */

/** Listfunc to add the char representing the object type of the current
 *  Object_type node to a string.
 *  \param type Food object tyoe,
 *  \param str  String to append short version of type (char) to.
 *  \return TRUE Keep list_foreach or list_search going.
 */
int food_get_short_string(void *type, void *str);

/** Function to enhance abilities of the food object (maybe spawns another
 * food object) thrown bij player.
 *  \param m Model food object is in.
 *  \param o Food object.
 *  \param p Player that throws powered up food.
 */
void food_powerup(Model *m, Model_object *o, Model_object *p);

/** Tries to generate food object of given type and with given position,
  * size and owner. If a box or food is in the way the food object will NOT
  * be generated.
  * \param m     Model to generate object in.
  * \param t     Food type.
  * \param owner Owner of the food object (player).
  * \param pos   Position vector.
  * \param size  Size vector.
  * \return Pointer to generated Model_object, \c NULL if object
  *         can't be generated because it would cause a collision.
  */
Model_object *food_generate(Model *m, Object_type t, Model_object *owner, 
                            Vector *pos, Vector *size);
			    
/** Player delivers food to home \a h by throwing food \a f in it.
  * \param m Model player is member of.
  * \param h Home of a player.
  * \param f Food thrown by player.
  * \return \c FALSE if the owner of the food is not the owner of
  *         the home, \c TRUE otherwise.
  */
int food_deliver(Model *m, Model_object *h, Model_object *f);

/** Handles tick for food object: applies friction.
 *  \param m Model the food object is in.
 *  \param o Food object.
 */
void food_tick(Model *m, Model_object *o);

#endif /* FFRENZY_FOOD_H */
