/**
 * FreeRDP: A Remote Desktop Protocol Implementation
 * Serial Port Device Service Virtual Channel
 *
 * Copyright 2011 O.S. Systems Software Ltda.
 * Copyright 2011 Eduardo Fiss Beloni <beloni@ossystems.com.br>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __SERIAL_CONSTANTS_H
#define __SERIAL_CONSTANTS_H

/* http://www.codeproject.com/KB/system/chaiyasit_t.aspx */
#define SERIAL_TIMEOUT_MAX 4294967295u

/* DR_CONTROL_REQ.IoControlCode */
enum DR_PORT_CONTROL_REQ
{
	IOCTL_SERIAL_SET_BAUD_RATE = 0x001B0004,
	IOCTL_SERIAL_GET_BAUD_RATE = 0x001B0050,
	IOCTL_SERIAL_SET_LINE_CONTROL = 0x001B000C,
	IOCTL_SERIAL_GET_LINE_CONTROL = 0x001B0054,
	IOCTL_SERIAL_SET_TIMEOUTS = 0x001B001C,
	IOCTL_SERIAL_GET_TIMEOUTS = 0x001B0020,

/* GET_CHARS and SET_CHARS are swapped in the RDP docs [MS-RDPESP] */
	IOCTL_SERIAL_GET_CHARS = 0x001B0058,
	IOCTL_SERIAL_SET_CHARS = 0x001B005C,

	IOCTL_SERIAL_SET_DTR = 0x001B0024,
	IOCTL_SERIAL_CLR_DTR = 0x001B0028,
	IOCTL_SERIAL_RESET_DEVICE = 0x001B002C,
	IOCTL_SERIAL_SET_RTS = 0x001B0030,
	IOCTL_SERIAL_CLR_RTS = 0x001B0034,
	IOCTL_SERIAL_SET_XOFF = 0x001B0038,
	IOCTL_SERIAL_SET_XON = 0x001B003C,
	IOCTL_SERIAL_SET_BREAK_ON = 0x001B0010,
	IOCTL_SERIAL_SET_BREAK_OFF = 0x001B0014,
	IOCTL_SERIAL_SET_QUEUE_SIZE = 0x001B0008,
	IOCTL_SERIAL_GET_WAIT_MASK = 0x001B0040,
	IOCTL_SERIAL_SET_WAIT_MASK = 0x001B0044,
	IOCTL_SERIAL_WAIT_ON_MASK = 0x001B0048,
	IOCTL_SERIAL_IMMEDIATE_CHAR = 0x001B0018,
	IOCTL_SERIAL_PURGE = 0x001B004C,
	IOCTL_SERIAL_GET_HANDFLOW = 0x001B0060,
	IOCTL_SERIAL_SET_HANDFLOW = 0x001B0064,
	IOCTL_SERIAL_GET_MODEMSTATUS = 0x001B0068,
	IOCTL_SERIAL_GET_DTRRTS = 0x001B0078,

/* according to [MS-RDPESP] it should be 0x001B0084, but servers send 0x001B006C */
	IOCTL_SERIAL_GET_COMMSTATUS = 0x001B006C,

	IOCTL_SERIAL_GET_PROPERTIES = 0x001B0074,
	IOCTL_SERIAL_XOFF_COUNTER = 0x001B0070,
	IOCTL_SERIAL_LSRMST_INSERT = 0x001B007C,
	IOCTL_SERIAL_CONFIG_SIZE = 0x001B0080,
	IOCTL_SERIAL_GET_STATS = 0x001B008C,
	IOCTL_SERIAL_CLEAR_STATS = 0x001B0090,
	IOCTL_SERIAL_GET_MODEM_CONTROL = 0x001B0094,
	IOCTL_SERIAL_SET_MODEM_CONTROL = 0x001B0098,
	IOCTL_SERIAL_SET_FIFO_CONTROL = 0x001B009C,
};

enum SERIAL_PURGE_MASK
{
	SERIAL_PURGE_TXABORT = 0x00000001,
	SERIAL_PURGE_RXABORT = 0x00000002,
	SERIAL_PURGE_TXCLEAR = 0x00000004,
	SERIAL_PURGE_RXCLEAR = 0x00000008,
};

enum SERIAL_WAIT_MASK
{
	SERIAL_EV_RXCHAR = 0x0001,	/* Any Character received */
	SERIAL_EV_RXFLAG = 0x0002,	/* Received certain character */
	SERIAL_EV_TXEMPTY = 0x0004,	/* Transmitt Queue Empty */
	SERIAL_EV_CTS = 0x0008,		/* CTS changed state */
	SERIAL_EV_DSR = 0x0010,		/* DSR changed state */
	SERIAL_EV_RLSD = 0x0020,	/* RLSD changed state */
	SERIAL_EV_BREAK = 0x0040,	/* BREAK received */
	SERIAL_EV_ERR = 0x0080,		/* Line status error occurred */
	SERIAL_EV_RING = 0x0100,	/* Ring signal detected */
	SERIAL_EV_PERR = 0x0200,	/* Printer error occured */
	SERIAL_EV_RX80FULL = 0x0400,/* Receive buffer is 80 percent full */
	SERIAL_EV_EVENT1 = 0x0800,	/* Provider specific event 1 */
	SERIAL_EV_EVENT2 = 0x1000,	/* Provider specific event 2 */
};

enum SERIAL_MODEM_STATUS
{
	SERIAL_MS_DTR = 0x01,
	SERIAL_MS_RTS = 0x02,
	SERIAL_MS_CTS = 0x10,
	SERIAL_MS_DSR = 0x20,
	SERIAL_MS_RNG = 0x40,
	SERIAL_MS_CAR = 0x80,
};

enum SERIAL_HANDFLOW
{
	SERIAL_DTR_CONTROL = 0x01,
	SERIAL_CTS_HANDSHAKE = 0x08,
	SERIAL_ERROR_ABORT = 0x80000000,
};

enum SERIAL_FLOW_CONTROL
{
	SERIAL_XON_HANDSHAKE = 0x01,
	SERIAL_XOFF_HANDSHAKE = 0x02,
	SERIAL_DSR_SENSITIVITY = 0x40,
};

enum SERIAL_CHARS
{
	SERIAL_CHAR_EOF = 0,
	SERIAL_CHAR_ERROR = 1,
	SERIAL_CHAR_BREAK = 2,
	SERIAL_CHAR_EVENT = 3,
	SERIAL_CHAR_XON = 4,
	SERIAL_CHAR_XOFF = 5,
};

enum SERIAL_ABORT_IO
{
	SERIAL_ABORT_IO_NONE = 0,
	SERIAL_ABORT_IO_WRITE = 1,
	SERIAL_ABORT_IO_READ = 2,
};

enum SERIAL_STOP_BITS
{
	SERIAL_STOP_BITS_1 = 0,
	SERIAL_STOP_BITS_2 = 2,
};

enum SERIAL_PARITY
{
	SERIAL_NO_PARITY = 0,
	SERIAL_ODD_PARITY = 1,
	SERIAL_EVEN_PARITY = 2,
};

#endif
