#include "classifier.h"

/* Autogenerated code from the script config2c.pl */

static const char *protor_residue_name[] = {"A", "ACE", "ALA", "ARG", "ASN", "ASP", "ASX", "C", "CYS", "DA", "DC", "DG", "DI", "DT", "DU", "G", "GLN", "GLU", "GLX", "GLY", "HIS", "HOH", "I", "ILE", "LEU", "LYS", "MET", "MSE", "NH2", "PHE", "PRO", "PYL", "SEC", "SER", "T", "THR", "TRP", "TYR", "U", "VAL", };
static const char *protor_A_atom_name[] = {"C6", "O2'", "C2'", "OP1", "C5", "C4", "O3'", "OP3", "P", "C4'", "O4'", "C3'", "C8", "N6", "N9", "O5'", "N7", "OP2", "C5'", "N3", "C1'", "N1", "C2", };
static double protor_A_atom_radius[] = {1.61, 1.46, 1.88, 1.42, 1.61, 1.61, 1.46, 1.46, 1.8, 1.88, 1.46, 1.88, 1.76, 1.64, 1.64, 1.46, 1.64, 1.46, 1.88, 1.64, 1.88, 1.64, 1.76, };
static int protor_A_atom_class[] = {FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, };
static struct classifier_residue protor_A_cfg = {
    23,
 "A",
    (char**) protor_A_atom_name,
    (double*) protor_A_atom_radius,
    (freesasa_atom_class*) protor_A_atom_class,
 {NULL, 0, 0, 0, 0, 0},
};

static const char *protor_ACE_atom_name[] = {"O", "CH3", "C", };
static double protor_ACE_atom_radius[] = {1.42, 1.88, 1.76, };
static int protor_ACE_atom_class[] = {FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, };
static struct classifier_residue protor_ACE_cfg = {
    3,
 "ACE",
    (char**) protor_ACE_atom_name,
    (double*) protor_ACE_atom_radius,
    (freesasa_atom_class*) protor_ACE_atom_class,
 {NULL, 0, 0, 0, 0, 0},
};

static const char *protor_ALA_atom_name[] = {"N", "CB", "CA", "C", "O", "OXT", };
static double protor_ALA_atom_radius[] = {1.64, 1.88, 1.88, 1.61, 1.42, 1.46, };
static int protor_ALA_atom_class[] = {FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, };
static struct classifier_residue protor_ALA_cfg = {
    6,
 "ALA",
    (char**) protor_ALA_atom_name,
    (double*) protor_ALA_atom_radius,
    (freesasa_atom_class*) protor_ALA_atom_class,
 {"ALA", 108.76, 43.96, 64.80, 37.75, 71.01, 0},
};

static const char *protor_ARG_atom_name[] = {"C", "CA", "CB", "NH1", "OXT", "CZ", "CG", "O", "NE", "CD", "N", "NH2", };
static double protor_ARG_atom_radius[] = {1.61, 1.88, 1.88, 1.64, 1.46, 1.61, 1.88, 1.42, 1.64, 1.88, 1.64, 1.64, };
static int protor_ARG_atom_class[] = {FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, };
static struct classifier_residue protor_ARG_cfg = {
    12,
 "ARG",
    (char**) protor_ARG_atom_name,
    (double*) protor_ARG_atom_radius,
    (freesasa_atom_class*) protor_ARG_atom_class,
 {"ARG", 238.17, 42.00, 196.17, 165.00, 73.17, 0},
};

static const char *protor_ASN_atom_name[] = {"N", "CA", "CB", "C", "OD1", "O", "CG", "OXT", "ND2", };
static double protor_ASN_atom_radius[] = {1.64, 1.88, 1.88, 1.61, 1.42, 1.42, 1.61, 1.46, 1.64, };
static int protor_ASN_atom_class[] = {FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, };
static struct classifier_residue protor_ASN_cfg = {
    9,
 "ASN",
    (char**) protor_ASN_atom_name,
    (double*) protor_ASN_atom_radius,
    (freesasa_atom_class*) protor_ASN_atom_class,
 {"ASN", 145.01, 41.53, 103.48, 103.46, 41.55, 0},
};

static const char *protor_ASP_atom_name[] = {"OD2", "N", "CG", "O", "OXT", "CA", "CB", "C", "OD1", };
static double protor_ASP_atom_radius[] = {1.46, 1.64, 1.61, 1.42, 1.46, 1.88, 1.88, 1.61, 1.42, };
static int protor_ASP_atom_class[] = {FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, };
static struct classifier_residue protor_ASP_cfg = {
    9,
 "ASP",
    (char**) protor_ASP_atom_name,
    (double*) protor_ASP_atom_radius,
    (freesasa_atom_class*) protor_ASP_atom_class,
 {"ASP", 142.76, 42.29, 100.47, 100.27, 42.49, 0},
};

static const char *protor_ASX_atom_name[] = {"XD2", "N", "O", "CG", "OXT", "CA", "CB", "XD1", "C", };
static double protor_ASX_atom_radius[] = {1.5, 1.64, 1.42, 1.61, 1.46, 1.88, 1.88, 1.5, 1.61, };
static int protor_ASX_atom_class[] = {FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, };
static struct classifier_residue protor_ASX_cfg = {
    9,
 "ASX",
    (char**) protor_ASX_atom_name,
    (double*) protor_ASX_atom_radius,
    (freesasa_atom_class*) protor_ASX_atom_class,
 {NULL, 0, 0, 0, 0, 0},
};

static const char *protor_C_atom_name[] = {"C2", "N1", "N3", "C1'", "C5'", "OP2", "O5'", "C3'", "O4'", "P", "C4'", "O2", "N4", "OP3", "O3'", "C4", "C5", "OP1", "C2'", "O2'", "C6", };
static double protor_C_atom_radius[] = {1.61, 1.64, 1.64, 1.88, 1.88, 1.46, 1.46, 1.88, 1.46, 1.8, 1.88, 1.42, 1.64, 1.46, 1.46, 1.61, 1.76, 1.42, 1.88, 1.46, 1.76, };
static int protor_C_atom_class[] = {FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, };
static struct classifier_residue protor_C_cfg = {
    21,
 "C",
    (char**) protor_C_atom_name,
    (double*) protor_C_atom_radius,
    (freesasa_atom_class*) protor_C_atom_class,
 {NULL, 0, 0, 0, 0, 0},
};

static const char *protor_CYS_atom_name[] = {"O", "OXT", "SG", "CA", "CB", "C", "N", };
static double protor_CYS_atom_radius[] = {1.42, 1.46, 1.77, 1.88, 1.88, 1.61, 1.64, };
static int protor_CYS_atom_class[] = {FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, };
static struct classifier_residue protor_CYS_cfg = {
    7,
 "CYS",
    (char**) protor_CYS_atom_name,
    (double*) protor_CYS_atom_radius,
    (freesasa_atom_class*) protor_CYS_atom_class,
 {"CYS", 132.20, 42.55, 89.66, 92.74, 39.47, 0},
};

static const char *protor_DA_atom_name[] = {"OP2", "C5'", "C1'", "N3", "N1", "C2", "N6", "N9", "O5'", "N7", "C3'", "C8", "OP3", "C4'", "P", "O4'", "C4", "O3'", "C5", "OP1", "C6", "C2'", };
static double protor_DA_atom_radius[] = {1.46, 1.88, 1.88, 1.64, 1.64, 1.76, 1.64, 1.64, 1.46, 1.64, 1.88, 1.76, 1.46, 1.88, 1.8, 1.46, 1.61, 1.46, 1.61, 1.42, 1.61, 1.88, };
static int protor_DA_atom_class[] = {FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, };
static struct classifier_residue protor_DA_cfg = {
    22,
 "DA",
    (char**) protor_DA_atom_name,
    (double*) protor_DA_atom_radius,
    (freesasa_atom_class*) protor_DA_atom_class,
 {NULL, 0, 0, 0, 0, 0},
};

static const char *protor_DC_atom_name[] = {"C5", "C4", "O3'", "C6", "C2'", "OP1", "O5'", "C5'", "OP2", "C2", "C1'", "N3", "N1", "C4'", "P", "N4", "O2", "OP3", "O4'", "C3'", };
static double protor_DC_atom_radius[] = {1.76, 1.61, 1.46, 1.76, 1.88, 1.42, 1.46, 1.88, 1.46, 1.61, 1.88, 1.64, 1.64, 1.88, 1.8, 1.64, 1.42, 1.46, 1.46, 1.88, };
static int protor_DC_atom_class[] = {FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, };
static struct classifier_residue protor_DC_cfg = {
    20,
 "DC",
    (char**) protor_DC_atom_name,
    (double*) protor_DC_atom_radius,
    (freesasa_atom_class*) protor_DC_atom_class,
 {NULL, 0, 0, 0, 0, 0},
};

static const char *protor_DG_atom_name[] = {"C8", "C3'", "N2", "P", "C4'", "OP3", "O4'", "C5'", "OP2", "C2", "C1'", "N3", "N1", "O5'", "N9", "N7", "O6", "OP1", "C6", "C2'", "C4", "O3'", "C5", };
static double protor_DG_atom_radius[] = {1.76, 1.88, 1.64, 1.8, 1.88, 1.46, 1.46, 1.88, 1.46, 1.61, 1.88, 1.64, 1.64, 1.46, 1.64, 1.64, 1.42, 1.42, 1.61, 1.88, 1.61, 1.46, 1.61, };
static int protor_DG_atom_class[] = {FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, };
static struct classifier_residue protor_DG_cfg = {
    23,
 "DG",
    (char**) protor_DG_atom_name,
    (double*) protor_DG_atom_radius,
    (freesasa_atom_class*) protor_DG_atom_class,
 {NULL, 0, 0, 0, 0, 0},
};

static const char *protor_DI_atom_name[] = {"N3", "N1", "C1'", "C2", "OP2", "C5'", "N7", "N9", "O5'", "C3'", "C8", "O4'", "OP3", "C4'", "P", "O3'", "C4", "C5", "OP1", "O6", "C2'", "C6", };
static double protor_DI_atom_radius[] = {1.64, 1.64, 1.88, 1.76, 1.46, 1.88, 1.64, 1.64, 1.46, 1.88, 1.76, 1.46, 1.46, 1.88, 1.8, 1.46, 1.61, 1.61, 1.42, 1.42, 1.88, 1.61, };
static int protor_DI_atom_class[] = {FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, };
static struct classifier_residue protor_DI_cfg = {
    22,
 "DI",
    (char**) protor_DI_atom_name,
    (double*) protor_DI_atom_radius,
    (freesasa_atom_class*) protor_DI_atom_class,
 {NULL, 0, 0, 0, 0, 0},
};

static const char *protor_DT_atom_name[] = {"OP2", "C5'", "N3", "C1'", "N1", "C2", "O5'", "C3'", "O4", "OP3", "O2", "P", "C4'", "O4'", "C4", "O3'", "C5", "C7", "OP1", "C6", "C2'", };
static double protor_DT_atom_radius[] = {1.46, 1.88, 1.64, 1.88, 1.64, 1.61, 1.46, 1.88, 1.42, 1.46, 1.42, 1.8, 1.88, 1.46, 1.61, 1.46, 1.61, 1.88, 1.42, 1.76, 1.88, };
static int protor_DT_atom_class[] = {FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, };
static struct classifier_residue protor_DT_cfg = {
    21,
 "DT",
    (char**) protor_DT_atom_name,
    (double*) protor_DT_atom_radius,
    (freesasa_atom_class*) protor_DT_atom_class,
 {NULL, 0, 0, 0, 0, 0},
};

static const char *protor_DU_atom_name[] = {"C5", "C4", "O3'", "C6", "C2'", "OP1", "O5'", "C5'", "OP2", "C2", "C1'", "N3", "N1", "C4'", "P", "OP3", "O2", "O4'", "C3'", "O4", };
static double protor_DU_atom_radius[] = {1.76, 1.61, 1.46, 1.76, 1.88, 1.42, 1.46, 1.88, 1.46, 1.61, 1.88, 1.64, 1.64, 1.88, 1.8, 1.46, 1.42, 1.46, 1.88, 1.42, };
static int protor_DU_atom_class[] = {FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, };
static struct classifier_residue protor_DU_cfg = {
    20,
 "DU",
    (char**) protor_DU_atom_name,
    (double*) protor_DU_atom_radius,
    (freesasa_atom_class*) protor_DU_atom_class,
 {NULL, 0, 0, 0, 0, 0},
};

static const char *protor_G_atom_name[] = {"O6", "OP1", "O2'", "C6", "C2'", "C4", "O3'", "C5", "C8", "C3'", "N2", "C4'", "P", "OP3", "O4'", "C5'", "OP2", "C2", "N1", "N3", "C1'", "N9", "O5'", "N7", };
static double protor_G_atom_radius[] = {1.42, 1.42, 1.46, 1.61, 1.88, 1.61, 1.46, 1.61, 1.76, 1.88, 1.64, 1.88, 1.8, 1.46, 1.46, 1.88, 1.46, 1.61, 1.64, 1.64, 1.88, 1.64, 1.46, 1.64, };
static int protor_G_atom_class[] = {FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, };
static struct classifier_residue protor_G_cfg = {
    24,
 "G",
    (char**) protor_G_atom_name,
    (double*) protor_G_atom_radius,
    (freesasa_atom_class*) protor_G_atom_class,
 {NULL, 0, 0, 0, 0, 0},
};

static const char *protor_GLN_atom_name[] = {"OE1", "CD", "N", "CG", "O", "OXT", "CB", "CA", "C", "NE2", };
static double protor_GLN_atom_radius[] = {1.42, 1.61, 1.64, 1.88, 1.42, 1.46, 1.88, 1.88, 1.61, 1.64, };
static int protor_GLN_atom_class[] = {FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, };
static struct classifier_residue protor_GLN_cfg = {
    10,
 "GLN",
    (char**) protor_GLN_atom_name,
    (double*) protor_GLN_atom_radius,
    (freesasa_atom_class*) protor_GLN_atom_class,
 {"GLN", 178.83, 42.00, 136.83, 131.85, 46.98, 0},
};

static const char *protor_GLU_atom_name[] = {"O", "CG", "OXT", "OE2", "CA", "CB", "C", "N", "OE1", "CD", };
static double protor_GLU_atom_radius[] = {1.42, 1.88, 1.46, 1.46, 1.88, 1.88, 1.61, 1.64, 1.42, 1.61, };
static int protor_GLU_atom_class[] = {FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, };
static struct classifier_residue protor_GLU_cfg = {
    10,
 "GLU",
    (char**) protor_GLU_atom_name,
    (double*) protor_GLU_atom_radius,
    (freesasa_atom_class*) protor_GLU_atom_class,
 {"GLU", 174.18, 42.00, 132.18, 122.48, 51.70, 0},
};

static const char *protor_GLX_atom_name[] = {"C", "CA", "CB", "XE1", "OXT", "O", "XE2", "CG", "CD", "N", };
static double protor_GLX_atom_radius[] = {1.61, 1.88, 1.88, 1.5, 1.46, 1.42, 1.5, 1.88, 1.61, 1.64, };
static int protor_GLX_atom_class[] = {FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, };
static struct classifier_residue protor_GLX_cfg = {
    10,
 "GLX",
    (char**) protor_GLX_atom_name,
    (double*) protor_GLX_atom_radius,
    (freesasa_atom_class*) protor_GLX_atom_class,
 {NULL, 0, 0, 0, 0, 0},
};

static const char *protor_GLY_atom_name[] = {"OXT", "O", "C", "CA", "N", };
static double protor_GLY_atom_radius[] = {1.46, 1.42, 1.61, 1.88, 1.64, };
static int protor_GLY_atom_class[] = {FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, };
static struct classifier_residue protor_GLY_cfg = {
    5,
 "GLY",
    (char**) protor_GLY_atom_name,
    (double*) protor_GLY_atom_radius,
    (freesasa_atom_class*) protor_GLY_atom_class,
 {"GLY", 81.09, 81.09, 0.00, 44.65, 36.44, 0},
};

static const char *protor_HIS_atom_name[] = {"ND1", "O", "CG", "OXT", "NE2", "CB", "CA", "C", "CD2", "N", "CE1", };
static double protor_HIS_atom_radius[] = {1.64, 1.42, 1.61, 1.46, 1.64, 1.88, 1.88, 1.61, 1.76, 1.64, 1.76, };
static int protor_HIS_atom_class[] = {FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, };
static struct classifier_residue protor_HIS_cfg = {
    11,
 "HIS",
    (char**) protor_HIS_atom_name,
    (double*) protor_HIS_atom_radius,
    (freesasa_atom_class*) protor_HIS_atom_class,
 {"HIS", 182.97, 39.09, 143.87, 85.94, 97.03, 0},
};

static const char *protor_HOH_atom_name[] = {"O", };
static double protor_HOH_atom_radius[] = {1.46, };
static int protor_HOH_atom_class[] = {FREESASA_ATOM_POLAR, };
static struct classifier_residue protor_HOH_cfg = {
    1,
 "HOH",
    (char**) protor_HOH_atom_name,
    (double*) protor_HOH_atom_radius,
    (freesasa_atom_class*) protor_HOH_atom_class,
 {NULL, 0, 0, 0, 0, 0},
};

static const char *protor_I_atom_name[] = {"O3'", "C4", "C5", "OP1", "O6", "C2'", "C6", "O2'", "N3", "N1", "C1'", "C2", "OP2", "C5'", "N7", "N9", "O5'", "C8", "C3'", "O4'", "OP3", "P", "C4'", };
static double protor_I_atom_radius[] = {1.46, 1.61, 1.61, 1.42, 1.42, 1.88, 1.61, 1.46, 1.64, 1.64, 1.88, 1.76, 1.46, 1.88, 1.64, 1.64, 1.46, 1.76, 1.88, 1.46, 1.46, 1.8, 1.88, };
static int protor_I_atom_class[] = {FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, };
static struct classifier_residue protor_I_cfg = {
    23,
 "I",
    (char**) protor_I_atom_name,
    (double*) protor_I_atom_radius,
    (freesasa_atom_class*) protor_I_atom_class,
 {NULL, 0, 0, 0, 0, 0},
};

static const char *protor_ILE_atom_name[] = {"N", "OXT", "O", "CG1", "C", "CA", "CB", "CG2", "CD1", };
static double protor_ILE_atom_radius[] = {1.64, 1.46, 1.42, 1.88, 1.61, 1.88, 1.88, 1.88, 1.88, };
static int protor_ILE_atom_class[] = {FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, };
static struct classifier_residue protor_ILE_cfg = {
    9,
 "ILE",
    (char**) protor_ILE_atom_name,
    (double*) protor_ILE_atom_radius,
    (freesasa_atom_class*) protor_ILE_atom_class,
 {"ILE", 175.73, 41.49, 134.23, 36.85, 138.87, 0},
};

static const char *protor_LEU_atom_name[] = {"CD2", "N", "OXT", "O", "CG", "C", "CA", "CB", "CD1", };
static double protor_LEU_atom_radius[] = {1.88, 1.64, 1.46, 1.42, 1.88, 1.61, 1.88, 1.88, 1.88, };
static int protor_LEU_atom_class[] = {FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, };
static struct classifier_residue protor_LEU_cfg = {
    9,
 "LEU",
    (char**) protor_LEU_atom_name,
    (double*) protor_LEU_atom_radius,
    (freesasa_atom_class*) protor_LEU_atom_class,
 {"LEU", 179.56, 39.78, 139.78, 37.16, 142.39, 0},
};

static const char *protor_LYS_atom_name[] = {"NZ", "N", "CD", "CA", "CB", "C", "CE", "O", "CG", "OXT", };
static double protor_LYS_atom_radius[] = {1.64, 1.64, 1.88, 1.88, 1.88, 1.61, 1.88, 1.42, 1.88, 1.46, };
static int protor_LYS_atom_class[] = {FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, };
static struct classifier_residue protor_LYS_cfg = {
    10,
 "LYS",
    (char**) protor_LYS_atom_name,
    (double*) protor_LYS_atom_radius,
    (freesasa_atom_class*) protor_LYS_atom_class,
 {"LYS", 204.98, 42.00, 162.98, 93.88, 111.10, 0},
};

static const char *protor_MET_atom_name[] = {"N", "SD", "CA", "CB", "C", "O", "CG", "OXT", "CE", };
static double protor_MET_atom_radius[] = {1.64, 1.77, 1.88, 1.88, 1.61, 1.42, 1.88, 1.46, 1.88, };
static int protor_MET_atom_class[] = {FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, };
static struct classifier_residue protor_MET_cfg = {
    9,
 "MET",
    (char**) protor_MET_atom_name,
    (double*) protor_MET_atom_radius,
    (freesasa_atom_class*) protor_MET_atom_class,
 {"MET", 193.10, 42.00, 151.10, 75.48, 117.62, 0},
};

static const char *protor_MSE_atom_name[] = {"SE", "N", "C", "CA", "CB", "OXT", "O", "CG", "CE", };
static double protor_MSE_atom_radius[] = {1.9, 1.64, 1.61, 1.88, 1.88, 1.46, 1.42, 1.88, 1.88, };
static int protor_MSE_atom_class[] = {FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, };
static struct classifier_residue protor_MSE_cfg = {
    9,
 "MSE",
    (char**) protor_MSE_atom_name,
    (double*) protor_MSE_atom_radius,
    (freesasa_atom_class*) protor_MSE_atom_class,
 {NULL, 0, 0, 0, 0, 0},
};

static const char *protor_NH2_atom_name[] = {"N", };
static double protor_NH2_atom_radius[] = {1.64, };
static int protor_NH2_atom_class[] = {FREESASA_ATOM_POLAR, };
static struct classifier_residue protor_NH2_cfg = {
    1,
 "NH2",
    (char**) protor_NH2_atom_name,
    (double*) protor_NH2_atom_radius,
    (freesasa_atom_class*) protor_NH2_atom_class,
 {NULL, 0, 0, 0, 0, 0},
};

static const char *protor_PHE_atom_name[] = {"CD1", "CA", "CB", "C", "CZ", "O", "CG", "OXT", "N", "CE1", "CE2", "CD2", };
static double protor_PHE_atom_radius[] = {1.76, 1.88, 1.88, 1.61, 1.76, 1.42, 1.61, 1.46, 1.64, 1.76, 1.76, 1.76, };
static int protor_PHE_atom_class[] = {FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, };
static struct classifier_residue protor_PHE_cfg = {
    12,
 "PHE",
    (char**) protor_PHE_atom_name,
    (double*) protor_PHE_atom_radius,
    (freesasa_atom_class*) protor_PHE_atom_class,
 {"PHE", 199.88, 38.43, 161.45, 34.94, 164.94, 0},
};

static const char *protor_PRO_atom_name[] = {"C", "CB", "CA", "OXT", "O", "CG", "CD", "N", };
static double protor_PRO_atom_radius[] = {1.61, 1.88, 1.88, 1.46, 1.42, 1.88, 1.88, 1.64, };
static int protor_PRO_atom_class[] = {FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, };
static struct classifier_residue protor_PRO_cfg = {
    8,
 "PRO",
    (char**) protor_PRO_atom_name,
    (double*) protor_PRO_atom_radius,
    (freesasa_atom_class*) protor_PRO_atom_class,
 {"PRO", 137.21, 27.51, 109.70, 16.09, 121.12, 0},
};

static const char *protor_PYL_atom_name[] = {"N2", "N", "CD", "CD2", "O2", "CA2", "C2", "CB", "OXT", "O", "CG", "NZ", "CE2", "CG2", "C", "CA", "CE", "CB2", };
static double protor_PYL_atom_radius[] = {1.64, 1.64, 1.88, 1.88, 1.42, 1.88, 1.61, 1.88, 1.46, 1.42, 1.88, 1.64, 1.76, 1.88, 1.61, 1.88, 1.88, 1.88, };
static int protor_PYL_atom_class[] = {FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, };
static struct classifier_residue protor_PYL_cfg = {
    18,
 "PYL",
    (char**) protor_PYL_atom_name,
    (double*) protor_PYL_atom_radius,
    (freesasa_atom_class*) protor_PYL_atom_class,
 {NULL, 0, 0, 0, 0, 0},
};

static const char *protor_SEC_atom_name[] = {"C", "SE", "CA", "CB", "N", "OXT", "O", };
static double protor_SEC_atom_radius[] = {1.61, 1.9, 1.88, 1.88, 1.64, 1.46, 1.42, };
static int protor_SEC_atom_class[] = {FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, };
static struct classifier_residue protor_SEC_cfg = {
    7,
 "SEC",
    (char**) protor_SEC_atom_name,
    (double*) protor_SEC_atom_radius,
    (freesasa_atom_class*) protor_SEC_atom_class,
 {NULL, 0, 0, 0, 0, 0},
};

static const char *protor_SER_atom_name[] = {"C", "CA", "CB", "N", "OXT", "O", "OG", };
static double protor_SER_atom_radius[] = {1.61, 1.88, 1.88, 1.64, 1.46, 1.42, 1.46, };
static int protor_SER_atom_class[] = {FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, };
static struct classifier_residue protor_SER_cfg = {
    7,
 "SER",
    (char**) protor_SER_atom_name,
    (double*) protor_SER_atom_radius,
    (freesasa_atom_class*) protor_SER_atom_class,
 {"SER", 118.34, 43.41, 74.93, 71.38, 46.96, 0},
};

static const char *protor_T_atom_name[] = {"O2", "OP3", "C4'", "P", "O4'", "C3'", "O4", "O5'", "OP2", "C5'", "N3", "C1'", "N1", "C2", "C6", "C2'", "OP1", "C5", "C7", "C4", "O3'", };
static double protor_T_atom_radius[] = {1.42, 1.46, 1.88, 1.8, 1.46, 1.88, 1.42, 1.46, 1.46, 1.88, 1.64, 1.88, 1.64, 1.61, 1.76, 1.88, 1.42, 1.61, 1.88, 1.61, 1.46, };
static int protor_T_atom_class[] = {FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, };
static struct classifier_residue protor_T_cfg = {
    21,
 "T",
    (char**) protor_T_atom_name,
    (double*) protor_T_atom_radius,
    (freesasa_atom_class*) protor_T_atom_class,
 {NULL, 0, 0, 0, 0, 0},
};

static const char *protor_THR_atom_name[] = {"OXT", "O", "OG1", "C", "CA", "CB", "CG2", "N", };
static double protor_THR_atom_radius[] = {1.46, 1.42, 1.46, 1.61, 1.88, 1.88, 1.88, 1.64, };
static int protor_THR_atom_class[] = {FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, };
static struct classifier_residue protor_THR_cfg = {
    8,
 "THR",
    (char**) protor_THR_atom_name,
    (double*) protor_THR_atom_radius,
    (freesasa_atom_class*) protor_THR_atom_class,
 {"THR", 140.60, 41.96, 98.64, 66.15, 74.45, 0},
};

static const char *protor_TRP_atom_name[] = {"CD1", "CA", "CB", "C", "CG", "O", "OXT", "CZ2", "N", "CZ3", "CE2", "NE1", "CD2", "CE3", "CH2", };
static double protor_TRP_atom_radius[] = {1.76, 1.88, 1.88, 1.61, 1.61, 1.42, 1.46, 1.76, 1.64, 1.76, 1.61, 1.64, 1.61, 1.76, 1.76, };
static int protor_TRP_atom_class[] = {FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, };
static struct classifier_residue protor_TRP_cfg = {
    15,
 "TRP",
    (char**) protor_TRP_atom_name,
    (double*) protor_TRP_atom_radius,
    (freesasa_atom_class*) protor_TRP_atom_class,
 {"TRP", 249.19, 42.59, 206.60, 61.64, 187.55, 0},
};

static const char *protor_TYR_atom_name[] = {"CD2", "OH", "CE2", "N", "CE1", "OXT", "CZ", "CG", "O", "CD1", "C", "CA", "CB", };
static double protor_TYR_atom_radius[] = {1.76, 1.46, 1.76, 1.64, 1.76, 1.46, 1.61, 1.61, 1.42, 1.76, 1.61, 1.88, 1.88, };
static int protor_TYR_atom_class[] = {FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, };
static struct classifier_residue protor_TYR_cfg = {
    13,
 "TYR",
    (char**) protor_TYR_atom_name,
    (double*) protor_TYR_atom_radius,
    (freesasa_atom_class*) protor_TYR_atom_class,
 {"TYR", 214.19, 38.43, 175.76, 81.12, 133.07, 0},
};

static const char *protor_U_atom_name[] = {"O4", "C3'", "O4'", "C4'", "P", "OP3", "O2", "C2", "N3", "N1", "C1'", "C5'", "OP2", "O5'", "OP1", "C2'", "O2'", "C6", "O3'", "C4", "C5", };
static double protor_U_atom_radius[] = {1.42, 1.88, 1.46, 1.88, 1.8, 1.46, 1.42, 1.61, 1.64, 1.64, 1.88, 1.88, 1.46, 1.46, 1.42, 1.88, 1.46, 1.76, 1.46, 1.61, 1.76, };
static int protor_U_atom_class[] = {FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, };
static struct classifier_residue protor_U_cfg = {
    21,
 "U",
    (char**) protor_U_atom_name,
    (double*) protor_U_atom_radius,
    (freesasa_atom_class*) protor_U_atom_class,
 {NULL, 0, 0, 0, 0, 0},
};

static const char *protor_VAL_atom_name[] = {"CG2", "CB", "CA", "CG1", "C", "O", "OXT", "N", };
static double protor_VAL_atom_radius[] = {1.88, 1.88, 1.88, 1.88, 1.61, 1.42, 1.46, 1.64, };
static int protor_VAL_atom_class[] = {FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_APOLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, FREESASA_ATOM_POLAR, };
static struct classifier_residue protor_VAL_cfg = {
    8,
 "VAL",
    (char**) protor_VAL_atom_name,
    (double*) protor_VAL_atom_radius,
    (freesasa_atom_class*) protor_VAL_atom_class,
 {"VAL", 151.97, 41.50, 110.46, 36.87, 115.09, 0},
};

static struct classifier_residue *protor_residue_cfg[] = {
    &protor_A_cfg, &protor_ACE_cfg, &protor_ALA_cfg, &protor_ARG_cfg, &protor_ASN_cfg, &protor_ASP_cfg, &protor_ASX_cfg, &protor_C_cfg, &protor_CYS_cfg, &protor_DA_cfg, &protor_DC_cfg, &protor_DG_cfg, &protor_DI_cfg, &protor_DT_cfg, &protor_DU_cfg, &protor_G_cfg, &protor_GLN_cfg, &protor_GLU_cfg, &protor_GLX_cfg, &protor_GLY_cfg, &protor_HIS_cfg, &protor_HOH_cfg, &protor_I_cfg, &protor_ILE_cfg, &protor_LEU_cfg, &protor_LYS_cfg, &protor_MET_cfg, &protor_MSE_cfg, &protor_NH2_cfg, &protor_PHE_cfg, &protor_PRO_cfg, &protor_PYL_cfg, &protor_SEC_cfg, &protor_SER_cfg, &protor_T_cfg, &protor_THR_cfg, &protor_TRP_cfg, &protor_TYR_cfg, &protor_U_cfg, &protor_VAL_cfg, };

const freesasa_classifier freesasa_protor_classifier = {
    40,    (char**) protor_residue_name,
    "ProtOr",
    (struct classifier_residue **) protor_residue_cfg,
};

