from collections import OrderedDict

use_image = False

# Ordering: http://unicode.org/emoji/charts/emoji-ordering.txt

emoticons = OrderedDict([
    ('Smileys', [
        # group: Smileys
        u'\u263a',  # Category image

        # subgroup: face-positive
        u'\U0001f600',
        u'\U0001f601',
        u'\U0001f602',
        u'\U0001f923',
        u'\U0001f603',
        u'\U0001f604',
        u'\U0001f605',
        u'\U0001f606',
        u'\U0001f609',
        u'\U0001f60a',
        u'\U0001f60b',
        u'\U0001f60e',
        u'\U0001f60d',
        u'\U0001f618',
        u'\U0001f617',
        u'\U0001f619',
        u'\U0001f61a',
        u'\u263a',
        u'\U0001f642',
        u'\U0001f917',

        # subgroup: face-neutral
        u'\U0001f914',
        u'\U0001f610',
        u'\U0001f611',
        u'\U0001f636',
        u'\U0001f644',
        u'\U0001f60f',
        u'\U0001f623',
        u'\U0001f625',
        u'\U0001f62e',
        u'\U0001f910',
        u'\U0001f62f',
        u'\U0001f62a',
        u'\U0001f62b',
        u'\U0001f634',
        u'\U0001f60c',
        u'\U0001f61b',
        u'\U0001f61c',
        u'\U0001f61d',
        u'\U0001f924',
        u'\U0001f612',
        u'\U0001f613',
        u'\U0001f614',
        u'\U0001f615',
        u'\U0001f643',
        u'\U0001f911',
        u'\U0001f632',

        # subgroup: face-negative
        u'\u2639',
        u'\U0001f641',
        u'\U0001f616',
        u'\U0001f61e',
        u'\U0001f61f',
        u'\U0001f624',
        u'\U0001f622',
        u'\U0001f62d',
        u'\U0001f626',
        u'\U0001f627',
        u'\U0001f628',
        u'\U0001f629',
        u'\U0001f62c',
        u'\U0001f630',
        u'\U0001f631',
        u'\U0001f633',
        u'\U0001f635',
        u'\U0001f621',
        u'\U0001f620',

        # subgroup: face-sick
        u'\U0001f637',
        u'\U0001f912',
        u'\U0001f915',
        u'\U0001f922',
        u'\U0001f927',


        # subgroup: face-role
        u'\U0001f607',
        u'\U0001f920',
        u'\U0001f921',
        u'\U0001f925',
        u'\U0001f913',

        # subgroup: face-fantasy
        u'\U0001f608',
        u'\U0001f47f',
        u'\U0001f479',
        u'\U0001f47a',
        u'\U0001f480',
        u'\u2620',
        u'\U0001f47b',
        u'\U0001f47d',
        u'\U0001f47e',
        u'\U0001f916',
        u'\U0001f4a9',

        # subgroup: cat-face
        u'\U0001f63a',
        u'\U0001f638',
        u'\U0001f639',
        u'\U0001f63b',
        u'\U0001f63c',
        u'\U0001f63d',
        u'\U0001f640',
        u'\U0001f63f',
        u'\U0001f63e',

        # subgroup: monkey-face
        u'\U0001f648',
        u'\U0001f649',
        u'\U0001f64a',

        ]),

    ('People', [
        # group: People
        u'\U0001f575',  # Category image

        # subgroup: person
        [
            u'\U0001f476',
            u'\U0001f476\U0001f3fb',
            u'\U0001f476\U0001f3fc',
            u'\U0001f476\U0001f3fd',
            u'\U0001f476\U0001f3fe',
            u'\U0001f476\U0001f3ff',
            ],

        [
            u'\U0001f466',
            u'\U0001f466\U0001f3fb',
            u'\U0001f466\U0001f3fc',
            u'\U0001f466\U0001f3fd',
            u'\U0001f466\U0001f3fe',
            u'\U0001f466\U0001f3ff',
            ],

        [
            u'\U0001f467',
            u'\U0001f467\U0001f3fb',
            u'\U0001f467\U0001f3fc',
            u'\U0001f467\U0001f3fd',
            u'\U0001f467\U0001f3fe',
            u'\U0001f467\U0001f3ff',
            ],

        [
            u'\U0001f468',
            u'\U0001f468\U0001f3fb',
            u'\U0001f468\U0001f3fc',
            u'\U0001f468\U0001f3fd',
            u'\U0001f468\U0001f3fe',
            u'\U0001f468\U0001f3ff',
            ],

        [
            u'\U0001f469',
            u'\U0001f469\U0001f3fb',
            u'\U0001f469\U0001f3fc',
            u'\U0001f469\U0001f3fd',
            u'\U0001f469\U0001f3fe',
            u'\U0001f469\U0001f3ff',
            ],

        [
            u'\U0001f474',
            u'\U0001f474\U0001f3fb',
            u'\U0001f474\U0001f3fc',
            u'\U0001f474\U0001f3fd',
            u'\U0001f474\U0001f3fe',
            u'\U0001f474\U0001f3ff',
            ],

        [
            u'\U0001f475',
            u'\U0001f475\U0001f3fb',
            u'\U0001f475\U0001f3fc',
            u'\U0001f475\U0001f3fd',
            u'\U0001f475\U0001f3fe',
            u'\U0001f475\U0001f3ff',
            ],

        # subgroup: person-role
        [
            u'\U0001f468\u200d\u2695',
            u'\U0001f468\U0001f3fb\u200d\u2695',
            u'\U0001f468\U0001f3fc\u200d\u2695',
            u'\U0001f468\U0001f3fd\u200d\u2695',
            u'\U0001f468\U0001f3fe\u200d\u2695',
            u'\U0001f468\U0001f3ff\u200d\u2695',
            ],

        [
            u'\U0001f469\u200d\u2695',
            u'\U0001f469\U0001f3fb\u200d\u2695',
            u'\U0001f469\U0001f3fc\u200d\u2695',
            u'\U0001f469\U0001f3fd\u200d\u2695',
            u'\U0001f469\U0001f3fe\u200d\u2695',
            u'\U0001f469\U0001f3ff\u200d\u2695',
            ],

        [
            u'\U0001f468\u200d\U0001f393',
            u'\U0001f468\U0001f3fb\u200d\U0001f393',
            u'\U0001f468\U0001f3fc\u200d\U0001f393',
            u'\U0001f468\U0001f3fd\u200d\U0001f393',
            u'\U0001f468\U0001f3fe\u200d\U0001f393',
            u'\U0001f468\U0001f3ff\u200d\U0001f393',
            ],

        [
            u'\U0001f469\u200d\U0001f393',
            u'\U0001f469\U0001f3fb\u200d\U0001f393',
            u'\U0001f469\U0001f3fc\u200d\U0001f393',
            u'\U0001f469\U0001f3fd\u200d\U0001f393',
            u'\U0001f469\U0001f3fe\u200d\U0001f393',
            u'\U0001f469\U0001f3ff\u200d\U0001f393',
            ],

        [
            u'\U0001f468\u200d\U0001f3eb',
            u'\U0001f468\U0001f3fb\u200d\U0001f3eb',
            u'\U0001f468\U0001f3fc\u200d\U0001f3eb',
            u'\U0001f468\U0001f3fd\u200d\U0001f3eb',
            u'\U0001f468\U0001f3fe\u200d\U0001f3eb',
            u'\U0001f468\U0001f3ff\u200d\U0001f3eb',
            ],

        [
            u'\U0001f469\u200d\U0001f3eb',
            u'\U0001f469\U0001f3fb\u200d\U0001f3eb',
            u'\U0001f469\U0001f3fc\u200d\U0001f3eb',
            u'\U0001f469\U0001f3fd\u200d\U0001f3eb',
            u'\U0001f469\U0001f3fe\u200d\U0001f3eb',
            u'\U0001f469\U0001f3ff\u200d\U0001f3eb',
            ],

        [
            u'\U0001f468\u200d\u2696',
            u'\U0001f468\U0001f3fb\u200d\u2696',
            u'\U0001f468\U0001f3fc\u200d\u2696',
            u'\U0001f468\U0001f3fd\u200d\u2696',
            u'\U0001f468\U0001f3fe\u200d\u2696',
            u'\U0001f468\U0001f3ff\u200d\u2696',
            ],

        [
            u'\U0001f469\u200d\u2696',
            u'\U0001f469\U0001f3fb\u200d\u2696',
            u'\U0001f469\U0001f3fc\u200d\u2696',
            u'\U0001f469\U0001f3fd\u200d\u2696',
            u'\U0001f469\U0001f3fe\u200d\u2696',
            u'\U0001f469\U0001f3ff\u200d\u2696',
            ],

        [
            u'\U0001f468\u200d\U0001f33e',
            u'\U0001f468\U0001f3fb\u200d\U0001f33e',
            u'\U0001f468\U0001f3fc\u200d\U0001f33e',
            u'\U0001f468\U0001f3fd\u200d\U0001f33e',
            u'\U0001f468\U0001f3fe\u200d\U0001f33e',
            u'\U0001f468\U0001f3ff\u200d\U0001f33e',
            ],

        [
            u'\U0001f469\u200d\U0001f33e',
            u'\U0001f469\U0001f3fb\u200d\U0001f33e',
            u'\U0001f469\U0001f3fc\u200d\U0001f33e',
            u'\U0001f469\U0001f3fd\u200d\U0001f33e',
            u'\U0001f469\U0001f3fe\u200d\U0001f33e',
            u'\U0001f469\U0001f3ff\u200d\U0001f33e',
            ],

        [
            u'\U0001f468\u200d\U0001f373',
            u'\U0001f468\U0001f3fb\u200d\U0001f373',
            u'\U0001f468\U0001f3fc\u200d\U0001f373',
            u'\U0001f468\U0001f3fd\u200d\U0001f373',
            u'\U0001f468\U0001f3fe\u200d\U0001f373',
            u'\U0001f468\U0001f3ff\u200d\U0001f373',
            ],

        [
            u'\U0001f469\u200d\U0001f373',
            u'\U0001f469\U0001f3fb\u200d\U0001f373',
            u'\U0001f469\U0001f3fc\u200d\U0001f373',
            u'\U0001f469\U0001f3fd\u200d\U0001f373',
            u'\U0001f469\U0001f3fe\u200d\U0001f373',
            u'\U0001f469\U0001f3ff\u200d\U0001f373',
            ],

        [
            u'\U0001f468\u200d\U0001f527',
            u'\U0001f468\U0001f3fb\u200d\U0001f527',
            u'\U0001f468\U0001f3fc\u200d\U0001f527',
            u'\U0001f468\U0001f3fd\u200d\U0001f527',
            u'\U0001f468\U0001f3fe\u200d\U0001f527',
            u'\U0001f468\U0001f3ff\u200d\U0001f527',
            ],

        [
            u'\U0001f469\u200d\U0001f527',
            u'\U0001f469\U0001f3fb\u200d\U0001f527',
            u'\U0001f469\U0001f3fc\u200d\U0001f527',
            u'\U0001f469\U0001f3fd\u200d\U0001f527',
            u'\U0001f469\U0001f3fe\u200d\U0001f527',
            u'\U0001f469\U0001f3ff\u200d\U0001f527',
            ],

        [
            u'\U0001f468\u200d\U0001f3ed',
            u'\U0001f468\U0001f3fb\u200d\U0001f3ed',
            u'\U0001f468\U0001f3fc\u200d\U0001f3ed',
            u'\U0001f468\U0001f3fd\u200d\U0001f3ed',
            u'\U0001f468\U0001f3fe\u200d\U0001f3ed',
            u'\U0001f468\U0001f3ff\u200d\U0001f3ed',
            ],

        [
            u'\U0001f469\u200d\U0001f3ed',
            u'\U0001f469\U0001f3fb\u200d\U0001f3ed',
            u'\U0001f469\U0001f3fc\u200d\U0001f3ed',
            u'\U0001f469\U0001f3fd\u200d\U0001f3ed',
            u'\U0001f469\U0001f3fe\u200d\U0001f3ed',
            u'\U0001f469\U0001f3ff\u200d\U0001f3ed',
            ],


        [
            u'\U0001f468\u200d\U0001f4bc',
            u'\U0001f468\U0001f3fb\u200d\U0001f4bc',
            u'\U0001f468\U0001f3fc\u200d\U0001f4bc',
            u'\U0001f468\U0001f3fd\u200d\U0001f4bc',
            u'\U0001f468\U0001f3fe\u200d\U0001f4bc',
            u'\U0001f468\U0001f3ff\u200d\U0001f4bc',
            ],

        [
            u'\U0001f469\u200d\U0001f4bc',
            u'\U0001f469\U0001f3fb\u200d\U0001f4bc',
            u'\U0001f469\U0001f3fc\u200d\U0001f4bc',
            u'\U0001f469\U0001f3fd\u200d\U0001f4bc',
            u'\U0001f469\U0001f3fe\u200d\U0001f4bc',
            u'\U0001f469\U0001f3ff\u200d\U0001f4bc',
            ],

        [
            u'\U0001f468\u200d\U0001f52c',
            u'\U0001f468\U0001f3fb\u200d\U0001f52c',
            u'\U0001f468\U0001f3fc\u200d\U0001f52c',
            u'\U0001f468\U0001f3fd\u200d\U0001f52c',
            u'\U0001f468\U0001f3fe\u200d\U0001f52c',
            u'\U0001f468\U0001f3ff\u200d\U0001f52c',
            ],

        [
            u'\U0001f469\u200d\U0001f52c',
            u'\U0001f469\U0001f3fb\u200d\U0001f52c',
            u'\U0001f469\U0001f3fc\u200d\U0001f52c',
            u'\U0001f469\U0001f3fd\u200d\U0001f52c',
            u'\U0001f469\U0001f3fe\u200d\U0001f52c',
            u'\U0001f469\U0001f3ff\u200d\U0001f52c',
            ],

        [
            u'\U0001f468\u200d\U0001f4bb',
            u'\U0001f468\U0001f3fb\u200d\U0001f4bb',
            u'\U0001f468\U0001f3fc\u200d\U0001f4bb',
            u'\U0001f468\U0001f3fd\u200d\U0001f4bb',
            u'\U0001f468\U0001f3fe\u200d\U0001f4bb',
            u'\U0001f468\U0001f3ff\u200d\U0001f4bb',
            ],

        [
            u'\U0001f469\u200d\U0001f4bb',
            u'\U0001f469\U0001f3fb\u200d\U0001f4bb',
            u'\U0001f469\U0001f3fc\u200d\U0001f4bb',
            u'\U0001f469\U0001f3fd\u200d\U0001f4bb',
            u'\U0001f469\U0001f3fe\u200d\U0001f4bb',
            u'\U0001f469\U0001f3ff\u200d\U0001f4bb',
            ],

        [
            u'\U0001f468\u200d\U0001f3a4',
            u'\U0001f468\U0001f3fb\u200d\U0001f3a4',
            u'\U0001f468\U0001f3fc\u200d\U0001f3a4',
            u'\U0001f468\U0001f3fd\u200d\U0001f3a4',
            u'\U0001f468\U0001f3fe\u200d\U0001f3a4',
            u'\U0001f468\U0001f3ff\u200d\U0001f3a4',
            ],

        [
            u'\U0001f469\u200d\U0001f3a4',
            u'\U0001f469\U0001f3fb\u200d\U0001f3a4',
            u'\U0001f469\U0001f3fc\u200d\U0001f3a4',
            u'\U0001f469\U0001f3fd\u200d\U0001f3a4',
            u'\U0001f469\U0001f3fe\u200d\U0001f3a4',
            u'\U0001f469\U0001f3ff\u200d\U0001f3a4',
            ],

        [
            u'\U0001f468\u200d\U0001f3a8',
            u'\U0001f468\U0001f3fb\u200d\U0001f3a8',
            u'\U0001f468\U0001f3fc\u200d\U0001f3a8',
            u'\U0001f468\U0001f3fd\u200d\U0001f3a8',
            u'\U0001f468\U0001f3fe\u200d\U0001f3a8',
            u'\U0001f468\U0001f3ff\u200d\U0001f3a8',
            ],

        [
            u'\U0001f469\u200d\U0001f3a8',
            u'\U0001f469\U0001f3fb\u200d\U0001f3a8',
            u'\U0001f469\U0001f3fc\u200d\U0001f3a8',
            u'\U0001f469\U0001f3fd\u200d\U0001f3a8',
            u'\U0001f469\U0001f3fe\u200d\U0001f3a8',
            u'\U0001f469\U0001f3ff\u200d\U0001f3a8',
            ],

        [
            u'\U0001f468\u200d\u2708',
            u'\U0001f468\U0001f3fb\u200d\u2708',
            u'\U0001f468\U0001f3fc\u200d\u2708',
            u'\U0001f468\U0001f3fd\u200d\u2708',
            u'\U0001f468\U0001f3fe\u200d\u2708',
            u'\U0001f468\U0001f3ff\u200d\u2708',
            ],

        [
            u'\U0001f469\u200d\u2708',
            u'\U0001f469\U0001f3fb\u200d\u2708',
            u'\U0001f469\U0001f3fc\u200d\u2708',
            u'\U0001f469\U0001f3fd\u200d\u2708',
            u'\U0001f469\U0001f3fe\u200d\u2708',
            u'\U0001f469\U0001f3ff\u200d\u2708',
            ],

        [
            u'\U0001f468\u200d\U0001f680',
            u'\U0001f468\U0001f3fb\u200d\U0001f680',
            u'\U0001f468\U0001f3fc\u200d\U0001f680',
            u'\U0001f468\U0001f3fd\u200d\U0001f680',
            u'\U0001f468\U0001f3fe\u200d\U0001f680',
            u'\U0001f468\U0001f3ff\u200d\U0001f680',
            ],

        [
            u'\U0001f469\u200d\U0001f680',
            u'\U0001f469\U0001f3fb\u200d\U0001f680',
            u'\U0001f469\U0001f3fc\u200d\U0001f680',
            u'\U0001f469\U0001f3fd\u200d\U0001f680',
            u'\U0001f469\U0001f3fe\u200d\U0001f680',
            u'\U0001f469\U0001f3ff\u200d\U0001f680',
            ],

        [
            u'\U0001f468\u200d\U0001f692',
            u'\U0001f468\U0001f3fb\u200d\U0001f692',
            u'\U0001f468\U0001f3fc\u200d\U0001f692',
            u'\U0001f468\U0001f3fd\u200d\U0001f692',
            u'\U0001f468\U0001f3fe\u200d\U0001f692',
            u'\U0001f468\U0001f3ff\u200d\U0001f692',
            ],

        [
            u'\U0001f469\u200d\U0001f692',
            u'\U0001f469\U0001f3fb\u200d\U0001f692',
            u'\U0001f469\U0001f3fc\u200d\U0001f692',
            u'\U0001f469\U0001f3fd\u200d\U0001f692',
            u'\U0001f469\U0001f3fe\u200d\U0001f692',
            u'\U0001f469\U0001f3ff\u200d\U0001f692',
            ],

        [
            u'\U0001f46e\u200d\u2640',
            u'\U0001f46e\U0001f3fb\u200d\u2640',
            u'\U0001f46e\U0001f3fc\u200d\u2640',
            u'\U0001f46e\U0001f3fd\u200d\u2640',
            u'\U0001f46e\U0001f3fe\u200d\u2640',
            u'\U0001f46e\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f46e\u200d\u2642',
            u'\U0001f46e\U0001f3fb\u200d\u2642',
            u'\U0001f46e\U0001f3fc\u200d\u2642',
            u'\U0001f46e\U0001f3fd\u200d\u2642',
            u'\U0001f46e\U0001f3fe\u200d\u2642',
            u'\U0001f46e\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f575\u200d\u2640',
            u'\U0001f575\U0001f3fb\u200d\u2640',
            u'\U0001f575\U0001f3fc\u200d\u2640',
            u'\U0001f575\U0001f3fd\u200d\u2640',
            u'\U0001f575\U0001f3fe\u200d\u2640',
            u'\U0001f575\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f575\u200d\u2642',
            u'\U0001f575\U0001f3fb\u200d\u2642',
            u'\U0001f575\U0001f3fc\u200d\u2642',
            u'\U0001f575\U0001f3fd\u200d\u2642',
            u'\U0001f575\U0001f3fe\u200d\u2642',
            u'\U0001f575\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f482\u200d\u2640',
            u'\U0001f482\U0001f3fb\u200d\u2640',
            u'\U0001f482\U0001f3fc\u200d\u2640',
            u'\U0001f482\U0001f3fd\u200d\u2640',
            u'\U0001f482\U0001f3fe\u200d\u2640',
            u'\U0001f482\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f482\u200d\u2642',
            u'\U0001f482\U0001f3fb\u200d\u2642',
            u'\U0001f482\U0001f3fc\u200d\u2642',
            u'\U0001f482\U0001f3fd\u200d\u2642',
            u'\U0001f482\U0001f3fe\u200d\u2642',
            u'\U0001f482\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f477\u200d\u2640',
            u'\U0001f477\U0001f3fb\u200d\u2640',
            u'\U0001f477\U0001f3fc\u200d\u2640',
            u'\U0001f477\U0001f3fd\u200d\u2640',
            u'\U0001f477\U0001f3fe\u200d\u2640',
            u'\U0001f477\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f477\u200d\u2642',
            u'\U0001f477\U0001f3fb\u200d\u2642',
            u'\U0001f477\U0001f3fc\u200d\u2642',
            u'\U0001f477\U0001f3fd\u200d\u2642',
            u'\U0001f477\U0001f3fe\u200d\u2642',
            u'\U0001f477\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f934',
            u'\U0001f934\U0001f3fb',
            u'\U0001f934\U0001f3fc',
            u'\U0001f934\U0001f3fd',
            u'\U0001f934\U0001f3fe',
            u'\U0001f934\U0001f3ff',
            ],

        [
            u'\U0001f478',
            u'\U0001f478\U0001f3fb',
            u'\U0001f478\U0001f3fc',
            u'\U0001f478\U0001f3fd',
            u'\U0001f478\U0001f3fe',
            u'\U0001f478\U0001f3ff',
            ],

        [
            u'\U0001f473\u200d\u2640',
            u'\U0001f473\U0001f3fb\u200d\u2640',
            u'\U0001f473\U0001f3fc\u200d\u2640',
            u'\U0001f473\U0001f3fd\u200d\u2640',
            u'\U0001f473\U0001f3fe\u200d\u2640',
            u'\U0001f473\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f473\u200d\u2642',
            u'\U0001f473\U0001f3fb\u200d\u2642',
            u'\U0001f473\U0001f3fc\u200d\u2642',
            u'\U0001f473\U0001f3fd\u200d\u2642',
            u'\U0001f473\U0001f3fe\u200d\u2642',
            u'\U0001f473\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f472',
            u'\U0001f472\U0001f3fb',
            u'\U0001f472\U0001f3fc',
            u'\U0001f472\U0001f3fd',
            u'\U0001f472\U0001f3fe',
            u'\U0001f472\U0001f3ff',
            ],

        [
            u'\U0001f471\u200d\u2640',
            u'\U0001f471\U0001f3fb\u200d\u2640',
            u'\U0001f471\U0001f3fc\u200d\u2640',
            u'\U0001f471\U0001f3fd\u200d\u2640',
            u'\U0001f471\U0001f3fe\u200d\u2640',
            u'\U0001f471\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f471\u200d\u2642',
            u'\U0001f471\U0001f3fb\u200d\u2642',
            u'\U0001f471\U0001f3fc\u200d\u2642',
            u'\U0001f471\U0001f3fd\u200d\u2642',
            u'\U0001f471\U0001f3fe\u200d\u2642',
            u'\U0001f471\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f935',
            u'\U0001f935\U0001f3fb',
            u'\U0001f935\U0001f3fc',
            u'\U0001f935\U0001f3fd',
            u'\U0001f935\U0001f3fe',
            u'\U0001f935\U0001f3ff',
            ],

        [
            u'\U0001f470',
            u'\U0001f470\U0001f3fb',
            u'\U0001f470\U0001f3fc',
            u'\U0001f470\U0001f3fd',
            u'\U0001f470\U0001f3fe',
            u'\U0001f470\U0001f3ff',
            ],

        [
            u'\U0001f930',
            u'\U0001f930\U0001f3fb',
            u'\U0001f930\U0001f3fc',
            u'\U0001f930\U0001f3fd',
            u'\U0001f930\U0001f3fe',
            u'\U0001f930\U0001f3ff',
            ],

        # subgroup: person-fantasy
        [
            u'\U0001f47c',
            u'\U0001f47c\U0001f3fb',
            u'\U0001f47c\U0001f3fc',
            u'\U0001f47c\U0001f3fd',
            u'\U0001f47c\U0001f3fe',
            u'\U0001f47c\U0001f3ff',
            ],

        [
            u'\U0001f385',
            u'\U0001f385\U0001f3fb',
            u'\U0001f385\U0001f3fc',
            u'\U0001f385\U0001f3fd',
            u'\U0001f385\U0001f3fe',
            u'\U0001f385\U0001f3ff',
            ],

        [
            u'\U0001f936',
            u'\U0001f936\U0001f3fb',
            u'\U0001f936\U0001f3fc',
            u'\U0001f936\U0001f3fd',
            u'\U0001f936\U0001f3fe',
            u'\U0001f936\U0001f3ff',
            ],

        # subgroup: person-gesture
        [
            u'\U0001f64d\u200d\u2640',
            u'\U0001f64d\U0001f3fb\u200d\u2640',
            u'\U0001f64d\U0001f3fc\u200d\u2640',
            u'\U0001f64d\U0001f3fd\u200d\u2640',
            u'\U0001f64d\U0001f3fe\u200d\u2640',
            u'\U0001f64d\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f64d\u200d\u2642',
            u'\U0001f64d\U0001f3fb\u200d\u2642',
            u'\U0001f64d\U0001f3fc\u200d\u2642',
            u'\U0001f64d\U0001f3fd\u200d\u2642',
            u'\U0001f64d\U0001f3fe\u200d\u2642',
            u'\U0001f64d\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f64e\u200d\u2640',
            u'\U0001f64e\U0001f3fb\u200d\u2640',
            u'\U0001f64e\U0001f3fc\u200d\u2640',
            u'\U0001f64e\U0001f3fd\u200d\u2640',
            u'\U0001f64e\U0001f3fe\u200d\u2640',
            u'\U0001f64e\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f64e\u200d\u2642',
            u'\U0001f64e\U0001f3fb\u200d\u2642',
            u'\U0001f64e\U0001f3fc\u200d\u2642',
            u'\U0001f64e\U0001f3fd\u200d\u2642',
            u'\U0001f64e\U0001f3fe\u200d\u2642',
            u'\U0001f64e\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f645\u200d\u2640',
            u'\U0001f645\U0001f3fb\u200d\u2640',
            u'\U0001f645\U0001f3fc\u200d\u2640',
            u'\U0001f645\U0001f3fd\u200d\u2640',
            u'\U0001f645\U0001f3fe\u200d\u2640',
            u'\U0001f645\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f645\u200d\u2642',
            u'\U0001f645\U0001f3fb\u200d\u2642',
            u'\U0001f645\U0001f3fc\u200d\u2642',
            u'\U0001f645\U0001f3fd\u200d\u2642',
            u'\U0001f645\U0001f3fe\u200d\u2642',
            u'\U0001f645\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f646\u200d\u2640',
            u'\U0001f646\U0001f3fb\u200d\u2640',
            u'\U0001f646\U0001f3fc\u200d\u2640',
            u'\U0001f646\U0001f3fd\u200d\u2640',
            u'\U0001f646\U0001f3fe\u200d\u2640',
            u'\U0001f646\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f646\u200d\u2642',
            u'\U0001f646\U0001f3fb\u200d\u2642',
            u'\U0001f646\U0001f3fc\u200d\u2642',
            u'\U0001f646\U0001f3fd\u200d\u2642',
            u'\U0001f646\U0001f3fe\u200d\u2642',
            u'\U0001f646\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f481\u200d\u2640',
            u'\U0001f481\U0001f3fb\u200d\u2640',
            u'\U0001f481\U0001f3fc\u200d\u2640',
            u'\U0001f481\U0001f3fd\u200d\u2640',
            u'\U0001f481\U0001f3fe\u200d\u2640',
            u'\U0001f481\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f481\u200d\u2642',
            u'\U0001f481\U0001f3fb\u200d\u2642',
            u'\U0001f481\U0001f3fc\u200d\u2642',
            u'\U0001f481\U0001f3fd\u200d\u2642',
            u'\U0001f481\U0001f3fe\u200d\u2642',
            u'\U0001f481\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f64b\u200d\u2640',
            u'\U0001f64b\U0001f3fb\u200d\u2640',
            u'\U0001f64b\U0001f3fc\u200d\u2640',
            u'\U0001f64b\U0001f3fd\u200d\u2640',
            u'\U0001f64b\U0001f3fe\u200d\u2640',
            u'\U0001f64b\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f64b\u200d\u2642',
            u'\U0001f64b\U0001f3fb\u200d\u2642',
            u'\U0001f64b\U0001f3fc\u200d\u2642',
            u'\U0001f64b\U0001f3fd\u200d\u2642',
            u'\U0001f64b\U0001f3fe\u200d\u2642',
            u'\U0001f64b\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f647\u200d\u2640',
            u'\U0001f647\U0001f3fb\u200d\u2640',
            u'\U0001f647\U0001f3fc\u200d\u2640',
            u'\U0001f647\U0001f3fd\u200d\u2640',
            u'\U0001f647\U0001f3fe\u200d\u2640',
            u'\U0001f647\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f647\u200d\u2642',
            u'\U0001f647\U0001f3fb\u200d\u2642',
            u'\U0001f647\U0001f3fc\u200d\u2642',
            u'\U0001f647\U0001f3fd\u200d\u2642',
            u'\U0001f647\U0001f3fe\u200d\u2642',
            u'\U0001f647\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f926\u200d\u2640',
            u'\U0001f926\U0001f3fb\u200d\u2640',
            u'\U0001f926\U0001f3fc\u200d\u2640',
            u'\U0001f926\U0001f3fd\u200d\u2640',
            u'\U0001f926\U0001f3fe\u200d\u2640',
            u'\U0001f926\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f926\u200d\u2642',
            u'\U0001f926\U0001f3fb\u200d\u2642',
            u'\U0001f926\U0001f3fc\u200d\u2642',
            u'\U0001f926\U0001f3fd\u200d\u2642',
            u'\U0001f926\U0001f3fe\u200d\u2642',
            u'\U0001f926\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f937\u200d\u2640',
            u'\U0001f937\U0001f3fb\u200d\u2640',
            u'\U0001f937\U0001f3fc\u200d\u2640',
            u'\U0001f937\U0001f3fd\u200d\u2640',
            u'\U0001f937\U0001f3fe\u200d\u2640',
            u'\U0001f937\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f937\u200d\u2642',
            u'\U0001f937\U0001f3fb\u200d\u2642',
            u'\U0001f937\U0001f3fc\u200d\u2642',
            u'\U0001f937\U0001f3fd\u200d\u2642',
            u'\U0001f937\U0001f3fe\u200d\u2642',
            u'\U0001f937\U0001f3ff\u200d\u2642',
            ],

        # subgroup: person-activity
        [
            u'\U0001f486\u200d\u2640',
            u'\U0001f486\U0001f3fb\u200d\u2640',
            u'\U0001f486\U0001f3fc\u200d\u2640',
            u'\U0001f486\U0001f3fd\u200d\u2640',
            u'\U0001f486\U0001f3fe\u200d\u2640',
            u'\U0001f486\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f486\u200d\u2642',
            u'\U0001f486\U0001f3fb\u200d\u2642',
            u'\U0001f486\U0001f3fc\u200d\u2642',
            u'\U0001f486\U0001f3fd\u200d\u2642',
            u'\U0001f486\U0001f3fe\u200d\u2642',
            u'\U0001f486\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f487\u200d\u2640',
            u'\U0001f487\U0001f3fb\u200d\u2640',
            u'\U0001f487\U0001f3fc\u200d\u2640',
            u'\U0001f487\U0001f3fd\u200d\u2640',
            u'\U0001f487\U0001f3fe\u200d\u2640',
            u'\U0001f487\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f487\u200d\u2642',
            u'\U0001f487\U0001f3fb\u200d\u2642',
            u'\U0001f487\U0001f3fc\u200d\u2642',
            u'\U0001f487\U0001f3fd\u200d\u2642',
            u'\U0001f487\U0001f3fe\u200d\u2642',
            u'\U0001f487\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f6b6\u200d\u2640',
            u'\U0001f6b6\U0001f3fb\u200d\u2640',
            u'\U0001f6b6\U0001f3fc\u200d\u2640',
            u'\U0001f6b6\U0001f3fd\u200d\u2640',
            u'\U0001f6b6\U0001f3fe\u200d\u2640',
            u'\U0001f6b6\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f6b6\u200d\u2642',
            u'\U0001f6b6\U0001f3fb\u200d\u2642',
            u'\U0001f6b6\U0001f3fc\u200d\u2642',
            u'\U0001f6b6\U0001f3fd\u200d\u2642',
            u'\U0001f6b6\U0001f3fe\u200d\u2642',
            u'\U0001f6b6\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f3c3\u200d\u2640',
            u'\U0001f3c3\U0001f3fb\u200d\u2640',
            u'\U0001f3c3\U0001f3fc\u200d\u2640',
            u'\U0001f3c3\U0001f3fd\u200d\u2640',
            u'\U0001f3c3\U0001f3fe\u200d\u2640',
            u'\U0001f3c3\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f3c3\u200d\u2642',
            u'\U0001f3c3\U0001f3fb\u200d\u2642',
            u'\U0001f3c3\U0001f3fc\u200d\u2642',
            u'\U0001f3c3\U0001f3fd\u200d\u2642',
            u'\U0001f3c3\U0001f3fe\u200d\u2642',
            u'\U0001f3c3\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f483',
            u'\U0001f483\U0001f3fb',
            u'\U0001f483\U0001f3fc',
            u'\U0001f483\U0001f3fd',
            u'\U0001f483\U0001f3fe',
            u'\U0001f483\U0001f3ff',
            ],

        [
            u'\U0001f57a',
            u'\U0001f57a\U0001f3fb',
            u'\U0001f57a\U0001f3fc',
            u'\U0001f57a\U0001f3fd',
            u'\U0001f57a\U0001f3fe',
            u'\U0001f57a\U0001f3ff',
            ],

        u'\U0001f46f\u200d\u2640',
        u'\U0001f46f\u200d\u2642',

        [
            u'\U0001f6c0',
            u'\U0001f6c0\U0001f3fb',
            u'\U0001f6c0\U0001f3fc',
            u'\U0001f6c0\U0001f3fd',
            u'\U0001f6c0\U0001f3fe',
            u'\U0001f6c0\U0001f3ff',
            ],

        u'\U0001f6cc',
        u'\U0001f574',
        u'\U0001f5e3',
        u'\U0001f464',
        u'\U0001f465',

        # subgroup: person-sport
        u'\U0001f93a',
        u'\U0001f3c7',
        u'\u26f7',
        u'\U0001f3c2',
        u'\U0001f3cc\u200d\u2640',
        u'\U0001f3cc\u200d\u2642',

        [
            u'\U0001f3c4\u200d\u2640',
            u'\U0001f3c4\U0001f3fb\u200d\u2640',
            u'\U0001f3c4\U0001f3fc\u200d\u2640',
            u'\U0001f3c4\U0001f3fd\u200d\u2640',
            u'\U0001f3c4\U0001f3fe\u200d\u2640',
            u'\U0001f3c4\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f3c4\u200d\u2642',
            u'\U0001f3c4\U0001f3fb\u200d\u2642',
            u'\U0001f3c4\U0001f3fc\u200d\u2642',
            u'\U0001f3c4\U0001f3fd\u200d\u2642',
            u'\U0001f3c4\U0001f3fe\u200d\u2642',
            u'\U0001f3c4\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f6a3\u200d\u2640',
            u'\U0001f6a3\U0001f3fb\u200d\u2640',
            u'\U0001f6a3\U0001f3fc\u200d\u2640',
            u'\U0001f6a3\U0001f3fd\u200d\u2640',
            u'\U0001f6a3\U0001f3fe\u200d\u2640',
            u'\U0001f6a3\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f6a3\u200d\u2642',
            u'\U0001f6a3\U0001f3fb\u200d\u2642',
            u'\U0001f6a3\U0001f3fc\u200d\u2642',
            u'\U0001f6a3\U0001f3fd\u200d\u2642',
            u'\U0001f6a3\U0001f3fe\u200d\u2642',
            u'\U0001f6a3\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f3ca\u200d\u2640',
            u'\U0001f3ca\U0001f3fb\u200d\u2640',
            u'\U0001f3ca\U0001f3fc\u200d\u2640',
            u'\U0001f3ca\U0001f3fd\u200d\u2640',
            u'\U0001f3ca\U0001f3fe\u200d\u2640',
            u'\U0001f3ca\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f3ca\u200d\u2642',
            u'\U0001f3ca\U0001f3fb\u200d\u2642',
            u'\U0001f3ca\U0001f3fc\u200d\u2642',
            u'\U0001f3ca\U0001f3fd\u200d\u2642',
            u'\U0001f3ca\U0001f3fe\u200d\u2642',
            u'\U0001f3ca\U0001f3ff\u200d\u2642',
            ],

        [
            u'\u26f9\u200d\u2640',
            u'\u26f9\U0001f3fb\u200d\u2640',
            u'\u26f9\U0001f3fc\u200d\u2640',
            u'\u26f9\U0001f3fd\u200d\u2640',
            u'\u26f9\U0001f3fe\u200d\u2640',
            u'\u26f9\U0001f3ff\u200d\u2640',
            ],

        [
            u'\u26f9\u200d\u2642',
            u'\u26f9\U0001f3fb\u200d\u2642',
            u'\u26f9\U0001f3fc\u200d\u2642',
            u'\u26f9\U0001f3fd\u200d\u2642',
            u'\u26f9\U0001f3fe\u200d\u2642',
            u'\u26f9\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f3cb\u200d\u2640',
            u'\U0001f3cb\U0001f3fb\u200d\u2640',
            u'\U0001f3cb\U0001f3fc\u200d\u2640',
            u'\U0001f3cb\U0001f3fd\u200d\u2640',
            u'\U0001f3cb\U0001f3fe\u200d\u2640',
            u'\U0001f3cb\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f3cb\u200d\u2642',
            u'\U0001f3cb\U0001f3fb\u200d\u2642',
            u'\U0001f3cb\U0001f3fc\u200d\u2642',
            u'\U0001f3cb\U0001f3fd\u200d\u2642',
            u'\U0001f3cb\U0001f3fe\u200d\u2642',
            u'\U0001f3cb\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f6b4\u200d\u2640',
            u'\U0001f6b4\U0001f3fb\u200d\u2640',
            u'\U0001f6b4\U0001f3fc\u200d\u2640',
            u'\U0001f6b4\U0001f3fd\u200d\u2640',
            u'\U0001f6b4\U0001f3fe\u200d\u2640',
            u'\U0001f6b4\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f6b4\u200d\u2642',
            u'\U0001f6b4\U0001f3fb\u200d\u2642',
            u'\U0001f6b4\U0001f3fc\u200d\u2642',
            u'\U0001f6b4\U0001f3fd\u200d\u2642',
            u'\U0001f6b4\U0001f3fe\u200d\u2642',
            u'\U0001f6b4\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f6b5\u200d\u2640',
            u'\U0001f6b5\U0001f3fb\u200d\u2640',
            u'\U0001f6b5\U0001f3fc\u200d\u2640',
            u'\U0001f6b5\U0001f3fd\u200d\u2640',
            u'\U0001f6b5\U0001f3fe\u200d\u2640',
            u'\U0001f6b5\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f6b5\u200d\u2642',
            u'\U0001f6b5\U0001f3fb\u200d\u2642',
            u'\U0001f6b5\U0001f3fc\u200d\u2642',
            u'\U0001f6b5\U0001f3fd\u200d\u2642',
            u'\U0001f6b5\U0001f3fe\u200d\u2642',
            u'\U0001f6b5\U0001f3ff\u200d\u2642',
            ],

        u'\U0001f3ce',
        u'\U0001f3cd',

        [
            u'\U0001f938\u200d\u2640',
            u'\U0001f938\U0001f3fb\u200d\u2640',
            u'\U0001f938\U0001f3fc\u200d\u2640',
            u'\U0001f938\U0001f3fd\u200d\u2640',
            u'\U0001f938\U0001f3fe\u200d\u2640',
            u'\U0001f938\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f938\u200d\u2642',
            u'\U0001f938\U0001f3fb\u200d\u2642',
            u'\U0001f938\U0001f3fc\u200d\u2642',
            u'\U0001f938\U0001f3fd\u200d\u2642',
            u'\U0001f938\U0001f3fe\u200d\u2642',
            u'\U0001f938\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f93c\u200d\u2640',
            u'\U0001f93c\U0001f3fb\u200d\u2640',
            u'\U0001f93c\U0001f3fc\u200d\u2640',
            u'\U0001f93c\U0001f3fd\u200d\u2640',
            u'\U0001f93c\U0001f3fe\u200d\u2640',
            u'\U0001f93c\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f93c\u200d\u2642',
            u'\U0001f93c\U0001f3fb\u200d\u2642',
            u'\U0001f93c\U0001f3fc\u200d\u2642',
            u'\U0001f93c\U0001f3fd\u200d\u2642',
            u'\U0001f93c\U0001f3fe\u200d\u2642',
            u'\U0001f93c\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f93d\u200d\u2640',
            u'\U0001f93d\U0001f3fb\u200d\u2640',
            u'\U0001f93d\U0001f3fc\u200d\u2640',
            u'\U0001f93d\U0001f3fd\u200d\u2640',
            u'\U0001f93d\U0001f3fe\u200d\u2640',
            u'\U0001f93d\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f93d\u200d\u2642',
            u'\U0001f93d\U0001f3fb\u200d\u2642',
            u'\U0001f93d\U0001f3fc\u200d\u2642',
            u'\U0001f93d\U0001f3fd\u200d\u2642',
            u'\U0001f93d\U0001f3fe\u200d\u2642',
            u'\U0001f93d\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f93e\u200d\u2640',
            u'\U0001f93e\U0001f3fb\u200d\u2640',
            u'\U0001f93e\U0001f3fc\u200d\u2640',
            u'\U0001f93e\U0001f3fd\u200d\u2640',
            u'\U0001f93e\U0001f3fe\u200d\u2640',
            u'\U0001f93e\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f93e\u200d\u2642',
            u'\U0001f93e\U0001f3fb\u200d\u2642',
            u'\U0001f93e\U0001f3fc\u200d\u2642',
            u'\U0001f93e\U0001f3fd\u200d\u2642',
            u'\U0001f93e\U0001f3fe\u200d\u2642',
            u'\U0001f93e\U0001f3ff\u200d\u2642',
            ],

        [
            u'\U0001f939\u200d\u2640',
            u'\U0001f939\U0001f3fb\u200d\u2640',
            u'\U0001f939\U0001f3fc\u200d\u2640',
            u'\U0001f939\U0001f3fd\u200d\u2640',
            u'\U0001f939\U0001f3fe\u200d\u2640',
            u'\U0001f939\U0001f3ff\u200d\u2640',
            ],

        [
            u'\U0001f939\u200d\u2642',
            u'\U0001f939\U0001f3fb\u200d\u2642',
            u'\U0001f939\U0001f3fc\u200d\u2642',
            u'\U0001f939\U0001f3fd\u200d\u2642',
            u'\U0001f939\U0001f3fe\u200d\u2642',
            u'\U0001f939\U0001f3ff\u200d\u2642',
            ],

        # subgroup: family
        [
            u'\U0001f46b',
            u'\U0001f46c',
            u'\U0001f46d',
            ],

        [
            u'\U0001f469\u200d\u2764\u200d\U0001f468',
            u'\U0001f468\u200d\u2764\u200d\U0001f468',
            u'\U0001f469\u200d\u2764\u200d\U0001f469',
            ],

        [
            u'\U0001f469\u200d\u2764\u200d\U0001f48b\u200d\U0001f468',
            u'\U0001f468\u200d\u2764\u200d\U0001f48b\u200d\U0001f468',
            u'\U0001f469\u200d\u2764\u200d\U0001f48b\u200d\U0001f469',
            ],

        [
            u'\U0001f46a',
            u'\U0001f468\u200d\U0001f466',
            u'\U0001f468\u200d\U0001f466\u200d\U0001f466',
            u'\U0001f468\u200d\U0001f467',
            u'\U0001f468\u200d\U0001f467\u200d\U0001f466',
            u'\U0001f468\u200d\U0001f467\u200d\U0001f467',
            u'\U0001f468\u200d\U0001f468\u200d\U0001f466',
            u'\U0001f468\u200d\U0001f468\u200d\U0001f466\u200d\U0001f466',
            u'\U0001f468\u200d\U0001f468\u200d\U0001f467',
            u'\U0001f468\u200d\U0001f468\u200d\U0001f467\u200d\U0001f466',
            u'\U0001f468\u200d\U0001f468\u200d\U0001f467\u200d\U0001f467',
            u'\U0001f468\u200d\U0001f469\u200d\U0001f466',
            u'\U0001f468\u200d\U0001f469\u200d\U0001f466\u200d\U0001f466',
            u'\U0001f468\u200d\U0001f469\u200d\U0001f467',
            u'\U0001f468\u200d\U0001f469\u200d\U0001f467\u200d\U0001f466',
            u'\U0001f468\u200d\U0001f469\u200d\U0001f467\u200d\U0001f467',
            u'\U0001f469\u200d\U0001f466',
            u'\U0001f469\u200d\U0001f466\u200d\U0001f466',
            u'\U0001f469\u200d\U0001f467',
            u'\U0001f469\u200d\U0001f467\u200d\U0001f466',
            u'\U0001f469\u200d\U0001f467\u200d\U0001f467',
            u'\U0001f469\u200d\U0001f469\u200d\U0001f466',
            u'\U0001f469\u200d\U0001f469\u200d\U0001f466\u200d\U0001f466',
            u'\U0001f469\u200d\U0001f469\u200d\U0001f467',
            u'\U0001f469\u200d\U0001f469\u200d\U0001f467\u200d\U0001f466',
            u'\U0001f469\u200d\U0001f469\u200d\U0001f467\u200d\U0001f467',
            ],

        # subgroup: body
        [
            u'\U0001f933',
            u'\U0001f933\U0001f3fb',
            u'\U0001f933\U0001f3fc',
            u'\U0001f933\U0001f3fd',
            u'\U0001f933\U0001f3fe',
            u'\U0001f933\U0001f3ff',
            ],


        [
            u'\U0001f4aa',
            u'\U0001f4aa\U0001f3fb',
            u'\U0001f4aa\U0001f3fc',
            u'\U0001f4aa\U0001f3fd',
            u'\U0001f4aa\U0001f3fe',
            u'\U0001f4aa\U0001f3ff',
            ],

        [
            u'\U0001f448',
            u'\U0001f448\U0001f3fb',
            u'\U0001f448\U0001f3fc',
            u'\U0001f448\U0001f3fd',
            u'\U0001f448\U0001f3fe',
            u'\U0001f448\U0001f3ff',
            ],

        [
            u'\U0001f449',
            u'\U0001f449\U0001f3fb',
            u'\U0001f449\U0001f3fc',
            u'\U0001f449\U0001f3fd',
            u'\U0001f449\U0001f3fe',
            u'\U0001f449\U0001f3ff',
            ],

        [
            u'\u261d',
            u'\u261d\U0001f3fb',
            u'\u261d\U0001f3fc',
            u'\u261d\U0001f3fd',
            u'\u261d\U0001f3fe',
            u'\u261d\U0001f3ff',
            ],

        [
            u'\U0001f446',
            u'\U0001f446\U0001f3fb',
            u'\U0001f446\U0001f3fc',
            u'\U0001f446\U0001f3fd',
            u'\U0001f446\U0001f3fe',
            u'\U0001f446\U0001f3ff',
            ],

        [
            u'\U0001f595',
            u'\U0001f595\U0001f3fb',
            u'\U0001f595\U0001f3fc',
            u'\U0001f595\U0001f3fd',
            u'\U0001f595\U0001f3fe',
            u'\U0001f595\U0001f3ff',
            ],

        [
            u'\U0001f447',
            u'\U0001f447\U0001f3fb',
            u'\U0001f447\U0001f3fc',
            u'\U0001f447\U0001f3fd',
            u'\U0001f447\U0001f3fe',
            u'\U0001f447\U0001f3ff',
            ],

        [
            u'\u270c',
            u'\u270c\U0001f3fb',
            u'\u270c\U0001f3fc',
            u'\u270c\U0001f3fd',
            u'\u270c\U0001f3fe',
            u'\u270c\U0001f3ff',
            ],

        [
            u'\U0001f91e',
            u'\U0001f91e\U0001f3fb',
            u'\U0001f91e\U0001f3fc',
            u'\U0001f91e\U0001f3fd',
            u'\U0001f91e\U0001f3fe',
            u'\U0001f91e\U0001f3ff',
            ],

        [
            u'\U0001f596',
            u'\U0001f596\U0001f3fb',
            u'\U0001f596\U0001f3fc',
            u'\U0001f596\U0001f3fd',
            u'\U0001f596\U0001f3fe',
            u'\U0001f596\U0001f3ff',
            ],

        [
            u'\U0001f918',
            u'\U0001f918\U0001f3fb',
            u'\U0001f918\U0001f3fc',
            u'\U0001f918\U0001f3fd',
            u'\U0001f918\U0001f3fe',
            u'\U0001f918\U0001f3ff',
            ],

        [
            u'\U0001f919',
            u'\U0001f919\U0001f3fb',
            u'\U0001f919\U0001f3fc',
            u'\U0001f919\U0001f3fd',
            u'\U0001f919\U0001f3fe',
            u'\U0001f919\U0001f3ff',
            ],

        [
            u'\U0001f590',
            u'\U0001f590\U0001f3fb',
            u'\U0001f590\U0001f3fc',
            u'\U0001f590\U0001f3fd',
            u'\U0001f590\U0001f3fe',
            u'\U0001f590\U0001f3ff',
            ],

        [
            u'\u270b',
            u'\u270b\U0001f3fb',
            u'\u270b\U0001f3fc',
            u'\u270b\U0001f3fd',
            u'\u270b\U0001f3fe',
            u'\u270b\U0001f3ff',
            ],

        [
            u'\U0001f44c',
            u'\U0001f44c\U0001f3fb',
            u'\U0001f44c\U0001f3fc',
            u'\U0001f44c\U0001f3fd',
            u'\U0001f44c\U0001f3fe',
            u'\U0001f44c\U0001f3ff',
            ],

        [
            u'\U0001f44d',
            u'\U0001f44d\U0001f3fb',
            u'\U0001f44d\U0001f3fc',
            u'\U0001f44d\U0001f3fd',
            u'\U0001f44d\U0001f3fe',
            u'\U0001f44d\U0001f3ff',
            ],

        [
            u'\U0001f44e',
            u'\U0001f44e\U0001f3fb',
            u'\U0001f44e\U0001f3fc',
            u'\U0001f44e\U0001f3fd',
            u'\U0001f44e\U0001f3fe',
            u'\U0001f44e\U0001f3ff',
            ],

        [
            u'\u270a',
            u'\u270a\U0001f3fb',
            u'\u270a\U0001f3fc',
            u'\u270a\U0001f3fd',
            u'\u270a\U0001f3fe',
            u'\u270a\U0001f3ff',
            ],

        [
            u'\U0001f44a',
            u'\U0001f44a\U0001f3fb',
            u'\U0001f44a\U0001f3fc',
            u'\U0001f44a\U0001f3fd',
            u'\U0001f44a\U0001f3fe',
            u'\U0001f44a\U0001f3ff',
            ],

        [
            u'\U0001f91b',
            u'\U0001f91b\U0001f3fb',
            u'\U0001f91b\U0001f3fc',
            u'\U0001f91b\U0001f3fd',
            u'\U0001f91b\U0001f3fe',
            u'\U0001f91b\U0001f3ff',
            ],

        [
            u'\U0001f91c',
            u'\U0001f91c\U0001f3fb',
            u'\U0001f91c\U0001f3fc',
            u'\U0001f91c\U0001f3fd',
            u'\U0001f91c\U0001f3fe',
            u'\U0001f91c\U0001f3ff',
            ],

        [
            u'\U0001f91a',
            u'\U0001f91a\U0001f3fb',
            u'\U0001f91a\U0001f3fc',
            u'\U0001f91a\U0001f3fd',
            u'\U0001f91a\U0001f3fe',
            u'\U0001f91a\U0001f3ff',
            ],

        [
            u'\U0001f44b',
            u'\U0001f44b\U0001f3fb',
            u'\U0001f44b\U0001f3fc',
            u'\U0001f44b\U0001f3fd',
            u'\U0001f44b\U0001f3fe',
            u'\U0001f44b\U0001f3ff',
            ],

        [
            u'\u270d',
            u'\u270d\U0001f3fb',
            u'\u270d\U0001f3fc',
            u'\u270d\U0001f3fd',
            u'\u270d\U0001f3fe',
            u'\u270d\U0001f3ff',
            ],

        [
            u'\U0001f44f',
            u'\U0001f44f\U0001f3fb',
            u'\U0001f44f\U0001f3fc',
            u'\U0001f44f\U0001f3fd',
            u'\U0001f44f\U0001f3fe',
            u'\U0001f44f\U0001f3ff',
            ],

        [
            u'\U0001f450',
            u'\U0001f450\U0001f3fb',
            u'\U0001f450\U0001f3fc',
            u'\U0001f450\U0001f3fd',
            u'\U0001f450\U0001f3fe',
            u'\U0001f450\U0001f3ff',
            ],

        [
            u'\U0001f64c',
            u'\U0001f64c\U0001f3fb',
            u'\U0001f64c\U0001f3fc',
            u'\U0001f64c\U0001f3fd',
            u'\U0001f64c\U0001f3fe',
            u'\U0001f64c\U0001f3ff',
            ],

        [
            u'\U0001f64f',
            u'\U0001f64f\U0001f3fb',
            u'\U0001f64f\U0001f3fc',
            u'\U0001f64f\U0001f3fd',
            u'\U0001f64f\U0001f3fe',
            u'\U0001f64f\U0001f3ff',
            ],

        [
            u'\U0001f91d',
            u'\U0001f91d\U0001f3fb',
            u'\U0001f91d\U0001f3fc',
            u'\U0001f91d\U0001f3fd',
            u'\U0001f91d\U0001f3fe',
            u'\U0001f91d\U0001f3ff',
            ],

        [
            u'\U0001f485',
            u'\U0001f485\U0001f3fb',
            u'\U0001f485\U0001f3fc',
            u'\U0001f485\U0001f3fd',
            u'\U0001f485\U0001f3fe',
            u'\U0001f485\U0001f3ff',
            ],

        [
            u'\U0001f442',
            u'\U0001f442\U0001f3fb',
            u'\U0001f442\U0001f3fc',
            u'\U0001f442\U0001f3fd',
            u'\U0001f442\U0001f3fe',
            u'\U0001f442\U0001f3ff',
            ],

        [
            u'\U0001f443',
            u'\U0001f443\U0001f3fb',
            u'\U0001f443\U0001f3fc',
            u'\U0001f443\U0001f3fd',
            u'\U0001f443\U0001f3fe',
            u'\U0001f443\U0001f3ff',
            ],

        u'\U0001f463',
        u'\U0001f440',
        u'\U0001f441',
        u'\U0001f441\u200d\U0001f5e8',
        u'\U0001f445',
        u'\U0001f444',

        # subgroup: emotion
        u'\U0001f48b',
        u'\U0001f498',
        u'\u2764',
        u'\U0001f493',
        u'\U0001f494',
        u'\U0001f495',
        u'\U0001f496',
        u'\U0001f497',
        u'\U0001f499',
        u'\U0001f49a',
        u'\U0001f49b',
        u'\U0001f49c',
        u'\U0001f5a4',
        u'\U0001f49d',
        u'\U0001f49e',
        u'\U0001f49f',
        u'\u2763',
        u'\U0001f48c',
        u'\U0001f4a4',
        u'\U0001f4a2',
        u'\U0001f4a3',
        u'\U0001f4a5',
        u'\U0001f4a6',
        u'\U0001f4a8',
        u'\U0001f4ab',
        u'\U0001f4ac',
        u'\U0001f5e8',
        u'\U0001f5ef',
        u'\U0001f4ad',
        u'\U0001f573',

        # subgroup: clothing
        u'\U0001f453',
        u'\U0001f576',
        u'\U0001f454',
        u'\U0001f455',
        u'\U0001f456',
        u'\U0001f457',
        u'\U0001f458',
        u'\U0001f459',
        u'\U0001f45a',
        u'\U0001f45b',
        u'\U0001f45c',
        u'\U0001f45d',
        u'\U0001f6cd',
        u'\U0001f392',
        u'\U0001f45e',
        u'\U0001f45f',
        u'\U0001f460',
        u'\U0001f461',
        u'\U0001f462',
        u'\U0001f451',
        u'\U0001f452',
        u'\U0001f3a9',
        u'\U0001f393',
        u'\u26d1',
        u'\U0001f4ff',
        u'\U0001f484',
        u'\U0001f48d',
        u'\U0001f48e',

        ]),

    ('Animals & Nature', [
        # group: Animals & Nature
        u'\U0001f43c',  # Category image

        # subgroup: animal-mammal
        u'\U0001f435',
        u'\U0001f412',
        u'\U0001f98d',
        u'\U0001f436',
        u'\U0001f415',
        u'\U0001f429',
        u'\U0001f43a',
        u'\U0001f98a',
        u'\U0001f431',
        u'\U0001f408',
        u'\U0001f981',
        u'\U0001f42f',
        u'\U0001f405',
        u'\U0001f406',
        u'\U0001f434',
        u'\U0001f40e',
        u'\U0001f984',
        u'\U0001f98c',
        u'\U0001f42e',
        u'\U0001f402',
        u'\U0001f403',
        u'\U0001f404',
        u'\U0001f437',
        u'\U0001f416',
        u'\U0001f417',
        u'\U0001f43d',
        u'\U0001f40f',
        u'\U0001f411',
        u'\U0001f410',
        u'\U0001f42a',
        u'\U0001f42b',
        u'\U0001f418',
        u'\U0001f98f',
        u'\U0001f42d',
        u'\U0001f401',
        u'\U0001f400',
        u'\U0001f439',
        u'\U0001f430',
        u'\U0001f407',
        u'\U0001f43f',
        u'\U0001f987',
        u'\U0001f43b',
        u'\U0001f428',
        u'\U0001f43c',
        u'\U0001f43e',

        # subgroup: animal-bird
        u'\U0001f983',
        u'\U0001f414',
        u'\U0001f413',
        u'\U0001f423',
        u'\U0001f424',
        u'\U0001f425',
        u'\U0001f426',
        u'\U0001f427',
        u'\U0001f54a',
        u'\U0001f985',
        u'\U0001f986',
        u'\U0001f989',

        # subgroup: animal-amphibian
        u'\U0001f438',

        # subgroup: animal-reptile
        u'\U0001f40a',
        u'\U0001f422',
        u'\U0001f98e',
        u'\U0001f40d',
        u'\U0001f432',
        u'\U0001f409',

        # subgroup: animal-marine
        u'\U0001f433',

        u'\U0001f40b',
        u'\U0001f42c',
        u'\U0001f41f',
        u'\U0001f420',
        u'\U0001f421',
        u'\U0001f988',
        u'\U0001f419',
        u'\U0001f41a',
        u'\U0001f980',
        u'\U0001f990',
        u'\U0001f991',

        # subgroup: animal-bug
        u'\U0001f40c',
        u'\U0001f98b',
        u'\U0001f41b',
        u'\U0001f41c',
        u'\U0001f41d',
        u'\U0001f41e',
        u'\U0001f577',
        u'\U0001f578',
        u'\U0001f982',

        # subgroup: plant-flower
        u'\U0001f490',
        u'\U0001f338',
        u'\U0001f4ae',
        u'\U0001f3f5',
        u'\U0001f339',
        u'\U0001f940',
        u'\U0001f33a',
        u'\U0001f33b',
        u'\U0001f33c',
        u'\U0001f337',

        # subgroup: plant-other
        u'\U0001f331',
        u'\U0001f332',
        u'\U0001f333',
        u'\U0001f334',
        u'\U0001f335',
        u'\U0001f33e',
        u'\U0001f33f',
        u'\u2618',
        u'\U0001f340',
        u'\U0001f341',
        u'\U0001f342',
        u'\U0001f343',

        ]),

    ('Food & Drink', [
        # group: Food & Drink
        u'\U0001f349',  # Category image

        # subgroup: food-fruit
        u'\U0001f347',
        u'\U0001f348',
        u'\U0001f349',
        u'\U0001f34a',
        u'\U0001f34b',
        u'\U0001f34c',
        u'\U0001f34d',
        u'\U0001f34e',
        u'\U0001f34f',
        u'\U0001f350',
        u'\U0001f351',
        u'\U0001f352',
        u'\U0001f353',
        u'\U0001f95d',
        u'\U0001f345',

        # subgroup: food-vegetable
        u'\U0001f951',
        u'\U0001f346',
        u'\U0001f954',
        u'\U0001f955',
        u'\U0001f33d',
        u'\U0001f336',
        u'\U0001f952',
        u'\U0001f344',
        u'\U0001f95c',
        u'\U0001f330',

        # subgroup: food-prepared
        u'\U0001f35e',
        u'\U0001f950',
        u'\U0001f956',
        u'\U0001f95e',
        u'\U0001f9c0',
        u'\U0001f356',
        u'\U0001f357',
        u'\U0001f953',
        u'\U0001f354',
        u'\U0001f35f',
        u'\U0001f355',
        u'\U0001f32d',
        u'\U0001f32e',
        u'\U0001f32f',
        u'\U0001f959',
        u'\U0001f95a',
        u'\U0001f373',
        u'\U0001f958',
        u'\U0001f372',
        u'\U0001f957',
        u'\U0001f37f',

        # subgroup: food-asian
        u'\U0001f371',
        u'\U0001f358',
        u'\U0001f359',
        u'\U0001f35a',
        u'\U0001f35b',
        u'\U0001f35c',
        u'\U0001f35d',
        u'\U0001f360',
        u'\U0001f362',
        u'\U0001f363',
        u'\U0001f364',
        u'\U0001f365',
        u'\U0001f361',

        # subgroup: food-sweet
        u'\U0001f366',
        u'\U0001f367',
        u'\U0001f368',
        u'\U0001f369',
        u'\U0001f36a',
        u'\U0001f382',
        u'\U0001f370',
        u'\U0001f36b',
        u'\U0001f36c',
        u'\U0001f36d',
        u'\U0001f36e',
        u'\U0001f36f',

        # subgroup: drink
        u'\U0001f37c',
        u'\U0001f95b',
        u'\u2615',
        u'\U0001f375',
        u'\U0001f376',
        u'\U0001f37e',
        u'\U0001f377',
        u'\U0001f378',
        u'\U0001f379',
        u'\U0001f37a',
        u'\U0001f37b',
        u'\U0001f942',
        u'\U0001f943',

        # subgroup: dishware
        u'\U0001f37d',
        u'\U0001f374',
        u'\U0001f944',
        u'\U0001f52a',
        u'\U0001f3fa',

        ]),

    ('Travel & Places', [
        # group: Travel & Places
        u'\u2708',  # Category image

        # subgroup: place-map
        u'\U0001f30d',
        u'\U0001f30e',
        u'\U0001f30f',
        u'\U0001f310',
        u'\U0001f5fa',
        u'\U0001f5fe',

        # subgroup: place-geographic
        u'\U0001f3d4',
        u'\u26f0',
        u'\U0001f30b',
        u'\U0001f5fb',
        u'\U0001f3d5',
        u'\U0001f3d6',
        u'\U0001f3dc',
        u'\U0001f3dd',
        u'\U0001f3de',

        # subgroup: place-building
        u'\U0001f3df',
        u'\U0001f3db',
        u'\U0001f3d7',
        u'\U0001f3d8',
        u'\U0001f3d9',
        u'\U0001f3da',
        u'\U0001f3e0',
        u'\U0001f3e1',
        u'\U0001f3e2',
        u'\U0001f3e3',
        u'\U0001f3e4',
        u'\U0001f3e5',
        u'\U0001f3e6',
        u'\U0001f3e8',
        u'\U0001f3e9',
        u'\U0001f3ea',
        u'\U0001f3eb',
        u'\U0001f3ec',
        u'\U0001f3ed',
        u'\U0001f3ef',
        u'\U0001f3f0',
        u'\U0001f492',
        u'\U0001f5fc',
        u'\U0001f5fd',

        # subgroup: place-religious
        u'\u26ea',
        u'\U0001f54c',
        u'\U0001f54d',
        u'\u26e9',
        u'\U0001f54b',

        # subgroup: place-other
        u'\u26f2',
        u'\u26fa',
        u'\U0001f301',
        u'\U0001f303',
        u'\U0001f304',
        u'\U0001f305',
        u'\U0001f306',
        u'\U0001f307',
        u'\U0001f309',
        u'\u2668',
        u'\U0001f30c',
        u'\U0001f3a0',
        u'\U0001f3a1',
        u'\U0001f3a2',
        u'\U0001f488',
        u'\U0001f3aa',
        u'\U0001f3ad',
        u'\U0001f5bc',
        u'\U0001f3a8',
        u'\U0001f3b0',


        # subgroup: transport-ground
        u'\U0001f682',
        u'\U0001f683',
        u'\U0001f684',
        u'\U0001f685',
        u'\U0001f686',
        u'\U0001f687',
        u'\U0001f688',
        u'\U0001f689',
        u'\U0001f68a',
        u'\U0001f69d',
        u'\U0001f69e',
        u'\U0001f68b',
        u'\U0001f68c',
        u'\U0001f68d',
        u'\U0001f68e',
        u'\U0001f690',
        u'\U0001f691',
        u'\U0001f692',
        u'\U0001f693',
        u'\U0001f694',
        u'\U0001f695',
        u'\U0001f696',
        u'\U0001f697',
        u'\U0001f698',
        u'\U0001f699',
        u'\U0001f69a',
        u'\U0001f69b',
        u'\U0001f69c',
        u'\U0001f6b2',
        u'\U0001f6f4',
        u'\U0001f6f5',
        u'\U0001f68f',
        u'\U0001f6e3',
        u'\U0001f6e4',
        u'\u26fd',
        u'\U0001f6a8',
        u'\U0001f6a5',
        u'\U0001f6a6',
        u'\U0001f6a7',
        u'\U0001f6d1',

        # subgroup: transport-water
        u'\u2693',
        u'\u26f5',
        u'\U0001f6f6',
        u'\U0001f6a4',
        u'\U0001f6f3',
        u'\u26f4',
        u'\U0001f6e5',
        u'\U0001f6a2',

        # subgroup: transport-air
        u'\u2708',
        u'\U0001f6e9',
        u'\U0001f6eb',
        u'\U0001f6ec',
        u'\U0001f4ba',
        u'\U0001f681',
        u'\U0001f69f',
        u'\U0001f6a0',
        u'\U0001f6a1',
        u'\U0001f6f0',
        u'\U0001f680',

        # subgroup: hotel
        u'\U0001f6ce',
        u'\U0001f6aa',
        u'\U0001f6cf',
        u'\U0001f6cb',
        u'\U0001f6bd',
        u'\U0001f6bf',
        u'\U0001f6c1',


        # subgroup: time
        u'\u231b',
        u'\u23f3',
        u'\u231a',
        u'\u23f0',
        u'\u23f1',
        u'\u23f2',
        u'\U0001f570',

        [
            u'\U0001f55b',
            u'\U0001f567',
            u'\U0001f550',
            u'\U0001f55c',
            u'\U0001f551',
            u'\U0001f55d',
            u'\U0001f552',
            u'\U0001f55e',
            u'\U0001f553',
            u'\U0001f55f',
            u'\U0001f554',
            u'\U0001f560',
            u'\U0001f555',
            u'\U0001f561',
            u'\U0001f556',
            u'\U0001f562',
            u'\U0001f557',
            u'\U0001f563',
            u'\U0001f558',
            u'\U0001f564',
            u'\U0001f559',
            u'\U0001f565',
            u'\U0001f55a',
            u'\U0001f566',
            ],

        # subgroup: sky & weather
        u'\U0001f311',
        u'\U0001f312',
        u'\U0001f313',
        u'\U0001f314',
        u'\U0001f315',
        u'\U0001f316',
        u'\U0001f317',
        u'\U0001f318',
        u'\U0001f319',
        u'\U0001f31a',
        u'\U0001f31b',
        u'\U0001f31c',
        u'\U0001f321',
        u'\u2600',
        u'\U0001f31d',
        u'\U0001f31e',
        u'\u2b50',
        u'\U0001f31f',
        u'\U0001f320',
        u'\u2601',
        u'\u26c5',
        u'\u26c8',
        u'\U0001f324',
        u'\U0001f325',
        u'\U0001f326',
        u'\U0001f327',
        u'\U0001f328',
        u'\U0001f329',
        u'\U0001f32a',
        u'\U0001f32b',
        u'\U0001f32c',
        u'\U0001f300',
        u'\U0001f308',
        u'\U0001f302',
        u'\u2602',
        u'\u2614',
        u'\u26f1',
        u'\u26a1',
        u'\u2744',
        u'\u2603',
        u'\u26c4',
        u'\u2604',
        u'\U0001f525',
        u'\U0001f4a7',
        u'\U0001f30a',

        ]),

    ('Activity', [
        # group: Activities
        u'\u26bd',  # Category image

        # subgroup: event
        u'\U0001f383',
        u'\U0001f384',
        u'\U0001f386',
        u'\U0001f387',
        u'\u2728',
        u'\U0001f388',
        u'\U0001f389',
        u'\U0001f38a',
        u'\U0001f38b',
        u'\U0001f38d',
        u'\U0001f38e',
        u'\U0001f38f',
        u'\U0001f390',
        u'\U0001f391',
        u'\U0001f380',
        u'\U0001f381',
        u'\U0001f397',
        u'\U0001f39f',
        u'\U0001f3ab',

        # subgroup: award-medal
        u'\U0001f396',
        u'\U0001f3c6',
        u'\U0001f3c5',
        u'\U0001f947',
        u'\U0001f948',
        u'\U0001f949',

        # subgroup: sport
        u'\u26bd',
        u'\u26be',
        u'\U0001f3c0',
        u'\U0001f3d0',
        u'\U0001f3c8',
        u'\U0001f3c9',
        u'\U0001f3be',
        u'\U0001f3b1',
        u'\U0001f3b3',
        u'\U0001f3cf',
        u'\U0001f3d1',
        u'\U0001f3d2',
        u'\U0001f3d3',
        u'\U0001f3f8',
        u'\U0001f94a',
        u'\U0001f94b',
        u'\U0001f945',
        u'\U0001f3af',
        u'\u26f3',
        u'\u26f8',
        u'\U0001f3a3',
        u'\U0001f3bd',
        u'\U0001f3bf',

        # subgroup: game
        u'\U0001f3ae',
        u'\U0001f579',
        u'\U0001f3b2',
        u'\u2660',
        u'\u2665',
        u'\u2666',
        u'\u2663',
        u'\U0001f0cf',
        u'\U0001f004',
        u'\U0001f3b4',

        ]),

    ('Objects', [
        # group: Objects
        u'\U0001f3a7',  # Category image

        # subgroup: sound
        u'\U0001f507',
        u'\U0001f508',
        u'\U0001f509',
        u'\U0001f50a',
        u'\U0001f4e2',
        u'\U0001f4e3',
        u'\U0001f4ef',
        u'\U0001f514',
        u'\U0001f515',

        # subgroup: music
        u'\U0001f3bc',
        u'\U0001f3b5',
        u'\U0001f3b6',
        u'\U0001f399',
        u'\U0001f39a',
        u'\U0001f39b',
        u'\U0001f3a4',
        u'\U0001f3a7',
        u'\U0001f4fb',

        # subgroup: musical-instrument
        u'\U0001f3b7',
        u'\U0001f3b8',
        u'\U0001f3b9',
        u'\U0001f3ba',
        u'\U0001f3bb',
        u'\U0001f941',

        # subgroup: phone
        u'\U0001f4f1',
        u'\U0001f4f2',
        u'\u260e',
        u'\U0001f4de',
        u'\U0001f4df',
        u'\U0001f4e0',

        # subgroup: computer
        u'\U0001f50b',
        u'\U0001f50c',
        u'\U0001f4bb',
        u'\U0001f5a5',
        u'\U0001f5a8',
        u'\u2328',
        u'\U0001f5b1',
        u'\U0001f5b2',
        u'\U0001f4bd',
        u'\U0001f4be',
        u'\U0001f4bf',
        u'\U0001f4c0',

        # subgroup: light & video
        u'\U0001f3a5',
        u'\U0001f39e',
        u'\U0001f4fd',
        u'\U0001f3ac',
        u'\U0001f4fa',
        u'\U0001f4f7',
        u'\U0001f4f8',
        u'\U0001f4f9',
        u'\U0001f4fc',
        u'\U0001f50d',
        u'\U0001f50e',
        u'\U0001f52c',
        u'\U0001f52d',
        u'\U0001f4e1',
        u'\U0001f56f',
        u'\U0001f4a1',
        u'\U0001f526',
        u'\U0001f3ee',

        # subgroup: book-paper
        u'\U0001f4d4',
        u'\U0001f4d5',
        u'\U0001f4d6',
        u'\U0001f4d7',
        u'\U0001f4d8',
        u'\U0001f4d9',
        u'\U0001f4da',
        u'\U0001f4d3',
        u'\U0001f4d2',
        u'\U0001f4c3',
        u'\U0001f4dc',
        u'\U0001f4c4',
        u'\U0001f4f0',
        u'\U0001f5de',
        u'\U0001f4d1',
        u'\U0001f516',
        u'\U0001f3f7',

        # subgroup: money
        u'\U0001f4b0',
        u'\U0001f4b4',
        u'\U0001f4b5',
        u'\U0001f4b6',
        u'\U0001f4b7',
        u'\U0001f4b8',
        u'\U0001f4b3',
        u'\U0001f4b9',
        u'\U0001f4b1',
        u'\U0001f4b2',

        # subgroup: mail
        u'\u2709',
        u'\U0001f4e7',
        u'\U0001f4e8',
        u'\U0001f4e9',
        u'\U0001f4e4',
        u'\U0001f4e5',
        u'\U0001f4e6',
        u'\U0001f4eb',
        u'\U0001f4ea',
        u'\U0001f4ec',
        u'\U0001f4ed',
        u'\U0001f4ee',
        u'\U0001f5f3',

        # subgroup: writing
        u'\u270f',
        u'\u2712',
        u'\U0001f58b',
        u'\U0001f58a',
        u'\U0001f58c',
        u'\U0001f58d',
        u'\U0001f4dd',

        # subgroup: office
        u'\U0001f4bc',
        u'\U0001f4c1',
        u'\U0001f4c2',
        u'\U0001f5c2',
        u'\U0001f4c5',
        u'\U0001f4c6',
        u'\U0001f5d2',
        u'\U0001f5d3',
        u'\U0001f4c7',
        u'\U0001f4c8',
        u'\U0001f4c9',
        u'\U0001f4ca',
        u'\U0001f4cb',
        u'\U0001f4cc',
        u'\U0001f4cd',
        u'\U0001f4ce',
        u'\U0001f587',
        u'\U0001f4cf',
        u'\U0001f4d0',
        u'\u2702',
        u'\U0001f5c3',
        u'\U0001f5c4',
        u'\U0001f5d1',

        # subgroup: lock
        u'\U0001f512',
        u'\U0001f513',
        u'\U0001f50f',
        u'\U0001f510',
        u'\U0001f511',
        u'\U0001f5dd',

        # subgroup: tool
        u'\U0001f528',
        u'\u26cf',
        u'\u2692',
        u'\U0001f6e0',
        u'\U0001f5e1',
        u'\u2694',
        u'\U0001f52b',
        u'\U0001f3f9',
        u'\U0001f6e1',
        u'\U0001f527',
        u'\U0001f529',
        u'\u2699',
        u'\U0001f5dc',
        u'\u2697',
        u'\u2696',
        u'\U0001f517',
        u'\u26d3',

        # subgroup: medical
        u'\U0001f489',
        u'\U0001f48a',

        # subgroup: other-object
        u'\U0001f6ac',
        u'\u26b0',
        u'\u26b1',
        u'\U0001f5ff',
        u'\U0001f6e2',
        u'\U0001f52e',
        u'\U0001f6d2',

        ]),

    ('Symbols', [
        # group: Symbols
        u'\u262f',  # Category image

        # subgroup: transport-sign
        u'\U0001f3e7',
        u'\U0001f6ae',
        u'\U0001f6b0',
        u'\u267f',
        u'\U0001f6b9',
        u'\U0001f6ba',
        u'\U0001f6bb',
        u'\U0001f6bc',
        u'\U0001f6be',
        u'\U0001f6c2',
        u'\U0001f6c3',
        u'\U0001f6c4',
        u'\U0001f6c5',

        # subgroup: warning
        u'\u26a0',
        u'\U0001f6b8',
        u'\u26d4',
        u'\U0001f6ab',
        u'\U0001f6b3',
        u'\U0001f6ad',
        u'\U0001f6af',
        u'\U0001f6b1',
        u'\U0001f6b7',
        u'\U0001f4f5',
        u'\U0001f51e',
        u'\u2622',
        u'\u2623',

        # subgroup: arrow
        u'\u2b06',
        u'\u2197',
        u'\u27a1',
        u'\u2198',
        u'\u2b07',
        u'\u2199',
        u'\u2b05',
        u'\u2196',
        u'\u2195',
        u'\u2194',
        u'\u21a9',
        u'\u21aa',
        u'\u2934',
        u'\u2935',
        u'\U0001f503',
        u'\U0001f504',
        u'\U0001f519',
        u'\U0001f51a',
        u'\U0001f51b',
        u'\U0001f51c',
        u'\U0001f51d',

        # subgroup: religion
        u'\U0001f6d0',
        u'\u269b',
        u'\U0001f549',
        u'\u2721',
        u'\u2638',
        u'\u262f',
        u'\u271d',
        u'\u2626',
        u'\u262a',
        u'\u262e',
        u'\U0001f54e',
        u'\U0001f52f',

        # subgroup: zodiac
        u'\u2648',
        u'\u2649',
        u'\u264a',
        u'\u264b',
        u'\u264c',
        u'\u264d',
        u'\u264e',
        u'\u264f',
        u'\u2650',
        u'\u2651',
        u'\u2652',
        u'\u2653',
        u'\u26ce',

        # subgroup: av-symbol
        u'\U0001f500',
        u'\U0001f501',
        u'\U0001f502',
        u'\u25b6',
        u'\u23e9',
        u'\u23ed',
        u'\u23ef',
        u'\u25c0',
        u'\u23ea',
        u'\u23ee',
        u'\U0001f53c',
        u'\u23eb',
        u'\U0001f53d',
        u'\u23ec',
        u'\u23f8',
        u'\u23f9',
        u'\u23fa',
        u'\u23cf',
        u'\U0001f3a6',
        u'\U0001f505',
        u'\U0001f506',
        u'\U0001f4f6',
        u'\U0001f4f3',
        u'\U0001f4f4',

        # subgroup: other-symbol
        u'\u2640',
        u'\u2642',
        u'\u2695',
        u'\u267b',
        u'\u269c',
        u'\U0001f531',
        u'\U0001f4db',
        u'\U0001f530',
        u'\u2b55',
        u'\u2705',
        u'\u2611',
        u'\u2714',
        u'\u2716',
        u'\u274c',
        u'\u274e',
        u'\u2795',
        u'\u2796',
        u'\u2797',
        u'\u27b0',
        u'\u27bf',
        u'\u303d',
        u'\u2733',
        u'\u2734',
        u'\u2747',
        u'\u203c',
        u'\u2049',
        u'\u2753',
        u'\u2754',
        u'\u2755',
        u'\u2757',
        u'\u3030',
        u'\xa9',
        u'\xae',
        u'\u2122',

        # subgroup: keycap
        [
            u'\x23\u20e3',
            u'\x2a\u20e3',
            u'\x30\u20e3',
            u'\x31\u20e3',
            u'\x32\u20e3',
            u'\x33\u20e3',
            u'\x34\u20e3',
            u'\x35\u20e3',
            u'\x36\u20e3',
            u'\x37\u20e3',
            u'\x38\u20e3',
            u'\x39\u20e3',
            u'\U0001f51f',
            ],

        # subgroup: alphanum
        u'\U0001f4af',
        u'\U0001f520',
        u'\U0001f521',
        u'\U0001f522',
        u'\U0001f523',
        u'\U0001f524',
        u'\U0001f170',
        u'\U0001f18e',
        u'\U0001f171',
        u'\U0001f191',
        u'\U0001f192',
        u'\U0001f193',
        u'\u2139',
        u'\U0001f194',
        u'\u24c2',
        u'\U0001f195',
        u'\U0001f196',
        u'\U0001f17e',
        u'\U0001f197',
        u'\U0001f17f',
        u'\U0001f198',
        u'\U0001f199',
        u'\U0001f19a',
        u'\U0001f201',
        u'\U0001f202',
        u'\U0001f237',
        u'\U0001f236',
        u'\U0001f22f',
        u'\U0001f250',
        u'\U0001f239',
        u'\U0001f21a',
        u'\U0001f232',
        u'\U0001f251',
        u'\U0001f238',
        u'\U0001f234',
        u'\U0001f233',
        u'\u3297',
        u'\u3299',
        u'\U0001f23a',
        u'\U0001f235',


        # subgroup: geometric
        u'\u25aa',
        u'\u25ab',
        u'\u25fb',
        u'\u25fc',
        u'\u25fd',
        u'\u25fe',
        u'\u2b1b',
        u'\u2b1c',
        u'\U0001f536',
        u'\U0001f537',
        u'\U0001f538',
        u'\U0001f539',
        u'\U0001f53a',
        u'\U0001f53b',
        u'\U0001f4a0',
        u'\U0001f518',
        u'\U0001f532',
        u'\U0001f533',
        u'\u26aa',
        u'\u26ab',
        u'\U0001f534',
        u'\U0001f535',

        ]),

    ('Flags', [
        # group: Flags
        u'\U0001f3f4', # Category image

        # subgroup: flag
        u'\U0001f3c1',
        u'\U0001f6a9',
        u'\U0001f38c',
        u'\U0001f3f4',
        u'\U0001f3f3',

        # subgroup: country-flag
        u'\U0001f1e8\U0001f1f3',
        u'\U0001f1e9\U0001f1ea',
        u'\U0001f1ea\U0001f1f8',
        u'\U0001f1eb\U0001f1f7',
        u'\U0001f1ec\U0001f1e7',
        u'\U0001f1ee\U0001f1f9',
        u'\U0001f1ef\U0001f1f5',
        u'\U0001f1f0\U0001f1f7',
        u'\U0001f1f7\U0001f1fa',
        u'\U0001f1fa\U0001f1f8',

    ])])
